######################################################################################
###########################  Loading and Saving procedures  ##########################
######################################################################################

# A saveList is the parameter passed to, and returned from the saveSettings, and
#loadSettings
# procedures.  It has the following format:
#	{
#	{SectionName1   {
#			{key1 value1} {key2 value2} ... {keyn valuen}
#			}
#	}
#	{SectionName2   {
#			{key1 value1} {key2 value2} ... {keyn valuen}
#			}
#	}
#	}
# which corresponds to a settings file:
#	[SectionName1]
#	key1=value1
#	key2=value2
#	keyn=valuen
#
#	[SectionName2]
#	key1=value1
#	key2=value2
#	keyn=valuen

#These saveSettings and loadSettings procedures are an attempt to separate the programmer
#from having to use the tcl function directly.  All the programmer needs to do is to set
#up an alias similar to the ones defined below as "save" and "restore" (Use them as a 
# template)

# This alias saves multiple settings sections in a settings file
# add a new code block for each section you want to save to the settings file
# Yes, I know its messy, annd I could have made it much neater by making it 
# recursive, but I didn't feel like it at the time!
# 
alias save {
	set file [lindex [args] 1]
	if {$file == ""} {
		set file [prompt "Enter File Name and Path for Save" "File:" "$settingsDir$settingsFile"]
	}
	set saveList ""
	set section ""
;
	## ADD OTHER SAVE SECTIONS BELOW HERE ##
;
	## Saving Notify Variables ##
;
	forEachKeyInArray key notifyArray {
		lappend section [list $key $notifyArray($key)]
	}
	lappend saveList [list Notify $section]
;
	## End of Saving Notify Variables ##
;
	## Saving BotOp Variables ##
;       
	set section ""
	forEachKeyInArray key opBots {
		lappend section [list $key $opBots($key)]
	}
	lappend saveList [list BotOp $section]
;
	## End of Saving BotOp Variables ##
;
	## ADD OTHER SAVE SECTIONS ABOVE HERE ##
;
	saveSettings $file $saveList
	echo "*** Settings saved to $file ***"
	complete
}

#This proc takes a saveList and saves it to the give filename, 
#It replaces any definitions in the file only if the corresponding
#definition appears in the save list.
#All other settings in the file are preserved, and any new sections in
#the saveList and not in the file are appended to the end of the file.
#Its not too pretty, but it works =)
#
proc saveSettings {fileNameAndPath saveList} {
	if {[file exists $fileNameAndPath]} {
		set cSettings [loadSettings $fileNameAndPath]
	} else {
		set cSettings ""
	}
	set outputList ""
	foreach cSect $cSettings {
		set cSectHandled 0
		foreach sect $saveList {
			if {[lindex $sect 0] == [lindex $cSect 0]} {
				set modSection ""
				foreach cElt [lindex $cSect 1] {
					set cEltHandled 0
					foreach elt [lindex $sect 1] {
						if {[lindex $elt 0] == [lindex $cElt 0]} {
							lappend modSection $elt
							set cEltHandled 1
						}
					}
					if {!$cEltHandled} {
						lappend modSection $cElt
					}
				}
				foreach elt [lindex $sect 1] {
					set addElt 1
					foreach mElt $modSection {
						if {[lindex $elt 0] == [lindex $mElt 0]} {
							set addElt 0
						}
					}
					if {$addElt} {
						lappend modSection $elt
					}
				}
				lappend outputList [list [lindex $cSect 0] $modSection]
				set cSectHandled 1
			}
		}
		if {!$cSectHandled} {
			lappend outputList $cSect
		}
	}
	foreach sect $saveList {
		set addElt 1
		foreach oSect $outputList {
			if {[lindex $sect 0] == [lindex $oSect 0]} {
				set addElt 0
			}
		}
		if {$addElt} {
			lappend outputList $sect
		}
	}
	set settings [open [file join $fileNameAndPath] w]
	foreach sect $outputList {
		puts $settings "\[[lindex $sect 0]\]"
		foreach pair [lindex $sect 1] {
			puts $settings "[lindex $pair 0]=[lindex $pair 1]"
		}
		puts $settings ""
	}
	flush $settings
	close $settings
}

alias restore {
	set file [args]
	if {$file == ""} {
		set file [prompt "Enter File Name and Path for Load" "File:" "$settingsDir$settingsFile"]
	}
	if {![file exists $file] || ![file isfile $file]} {
		secho "*** No Settings file to load - use /save to create one" 
		complete
		return
	}
	foreach entry [loadSettings $file] {
		switch [lindex $entry 0] {
;			
			## ADD ALL NEW SECTION LOADING CODEBLOCKS BELOW HERE ##
;
			## Notify Load codeblock ##
;
			"Notify" {
				foreach pair [lindex $entry 1] {
					set nick [lindex $pair 0]
					set hostmasks [concat [lindex $pair 1]]
					set notifyArray($nick) $hostmasks
				}
			}
;
			## End Notify Load codeblock ##
;
			## Bot Op Load codeblock ##

			"BotOp" {
				foreach pair [lindex $entry 1] {
					set chan [lindex $pair 0]
					set botList [concat [lindex $pair 1]]
					set opBots($chan) $botList
				}
			}
;
			## End BotOp Load codeblock ##
;
			## ADD ALL NEW SECTION LOADING CODEBLOCKS ABOVE HERE ##
;
			default {
				echo "*** WARNING: Unhandled Section \"\[[lindex $entry 0]\]\" in $file ***"
			}
		}
	}
	echo "*** Settings restored from $file ***"	
	complete
}

#This procedure loads all settings from the given file,
#and returns these settings as a saveList
#
proc loadSettings {fileName} {
	set settings [open [file join $fileName] r]
	set entry ""
	set fileList ""
	set sectionList ""
	set notStart 0
	while {[gets $settings entry] > -1} {
		set entry [string trim $entry]
		if {$entry == ""} {continue}
		if {[string match "*\]" $entry]} {
			if {$notStart} {
				lappend fileList [list $section $sectionList]
				set sectionList ""
			}
			set notStart 1	
			set section [string trim $entry {\[ \]}]
		} else {
			set equalIndex [string first "=" $entry]
			set key [string trim [string range $entry 0 [expr $equalIndex - 1]]]
			set value [string trim [string range $entry [expr $equalIndex + 1] end]]
			lappend sectionList [list $key $value]
		}
	}
	lappend fileList [list $section $sectionList]
	close $settings
	return $fileList
}
	

