
set tcl_precision 17


alias long2ip {
    echo [float2ip [intstr2float [lindex [args] 0]]]
    complete
}

alias ip2long {
    echo [float2intstr [ip2float [lindex [args] 0]]]
    complete
}


proc intstr2float {str} {
    if {![regexp {\.} $str]} {
	set str "${str}.0"
    }
    return [expr double("$str")]
}

proc float2intstr {fl} {
    return [format "%.0f" $fl]
}

proc ip2float {ip} {
    regexp {([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)} $ip a i3 i2 i1 i0
    set total [expr double($i3) * pow(256,3)]
    set total [expr $total + double($i2) * pow(256,2)]
    set total [expr $total + double($i1) * pow(256,1)]
    set total [expr $total + double($i0) * pow(256,0)]
    return $total
}

proc float2ip {float} {
    set p0 [expr pow(256, 0)]
    set p1 [expr pow(256, 1)]
    set p2 [expr pow(256, 2)]
    set p3 [expr pow(256, 3)]

    set a [expr int($float / $p3)]
    set tmp [expr $float - ($a * $p3)]
    set b [expr int($tmp / $p2)]
    set tmp [expr $tmp - ($b * $p2)]
    set c [expr int($tmp / $p1)]
    set tmp [expr $tmp - ($c * $p1)]
    set d [expr int($tmp / $p0)]
    return "$a.$b.$c.$d"
}
