######################################################################################
################################  Ignore Procedures  #################################
######################################################################################

set ignoreArray(head) 1 
set ignoreDelay 5
set ignoreCounter 0
set ignoreTime 300
set ignoreThreshold 10



on MSG {
	if {[ignoreThisEvent [nick]]} {
		complete
	}
	incrIgnoreCount [lindex [args] 0] [nick]
}

on NOTICE {
	if {[ignoreThisEvent [nick]]} {
		complete 
	}
	incrIgnoreCount [lindex [args] 0] [nick]
}

on CTCP { 
	if {[ignoreThisEvent [nick]]} {
		complete 
	}
	incrIgnoreCount [lindex [args] 0] [nick]
}

proc incrIgnoreCount {dest nick} {
	global ignoreArray
	if { [string tolower $dest] == [string tolower [my_nick]]} {
		if {[ignoreThisEvent $nick]} {return}
		if {[isInList [array get ignoreArray] $nick]} {
			set ignoreArray($nick) [expr $ignoreArray($nick) + 1]
		} else {
			set ignoreArray($nick) 1
		}                                              
	}
}

proc ignoreThisEvent {user} {
	set idx [find_user $user]
	if {$idx > -1} {
		if { [get_user_prop $idx ignore] == "1" } {
			return 1
		}
	} 
	return 0
}


alias ignore {
	set nick [lindex [args] 0]
	ignore $nick -1
}

proc ignore {nick type} {
	set idx [find_user $nick]
	if {$idx < 0} { 
		add_user $nick
		set idx [find_user $nick]
		set ig 1
	} elseif { [get_user_prop $idx ignore] == "1" } {
		set ig 0
	} else {
		set ig 1
	}
	
	if {$type != "-1"} { set ig $type }
	set_user_prop $idx ignore $ig
	if {$ig } {		
		secho "*** User $nick is now being ignored ***" 
		/raw notice $nick :You are now being Ignored!
        } else {
		set timerID [findTimerID "ignore $nick 0"]
		if {$timerID > -1} {delTimer $timerID}
		secho "*** User $nick is no longer being ignored ***"
		/raw notice $nick :Ignore off: you may speak again   
	}
}

on TIMER {
	if {$ignoreCounter >= $ignoreDelay} {
		set ignoreCounter 0
		foreach nick [array names ignoreArray] {
			if {$ignoreArray($nick) >= $ignoreThreshold} {
				/raw notice $nick :You have flooded me: Ignoring for $ignoreTime seconds
				ignore $nick 1
				timer $ignoreTime 1 [list ignore $nick 0]
			}
			set ignoreArray($nick) 0
		}
	}
	set ignoreCounter [expr $ignoreCounter + 1]
}

		  