set theftp ""
set thedtp ""
set dtpPort 1300
set dtpclient "" 

set transferType ""

set listTransferList ""
set listTransferComplete 0

alias ftp {
    set site [lindex [args] 0]
    set port [lindex [args] 1]
    if {$port != ""} {
	ftp $site $port
    } else {
	ftp $site
    }
    complete
}

alias cd {
    fput $theftp "CWD [lindex [args] 0]"
    complete
}

alias ls {
    doftpcmd $theftp "NLST"
    complete
}

alias dir {
    doftpcmd $theftp "LIST"
    complete
}

alias txtget {
    set theFile [lindex [args] 0]
    fput $theftp "TYPE A"
    doftpcmd $theftp "RETR $theFile" "asciiTransfer $theFile"
    complete
} 

alias dirget {
    set theFile [lindex [args] 0]
    fput $theftp "TYPE A"
    doftpcmd $theftp "LIST" "asciiTransfer $theFile"
    complete
} 

alias binget {
    set theFile [lindex [args] 0]
    fput $theftp "TYPE I" 
    doftpcmd $theftp "RETR $theFile" "binTransfer $theFile"
    complete
}	

proc ftp {host {port 21}} {
	global theftp  
	global thedtp
	echo "Connecting to ${host}:$port"

	set theftp [socket $host $port]
	fconfigure $theftp -blocking no


	fileevent $theftp readable { 
		global theftp
		global thedtp
		set incoming [read $theftp]
		echo "$incoming"
		if {[eof $theftp]} {
			echo "Connection Closed"
			close $theftp
			close $thedtp	
		}
	}
}	

alias user {
    set user [lindex [args] 0]
    if {"$user" == ""} {set user "anonymous"}
    fput $theftp "USER $user"
    complete
}

alias pass {
    set pass [lindex [args] 0]
    if {"$pass" == ""} {set pass "foo@bar.com"}
    fput $theftp "PASS $pass"
    complete
}

alias ftpcmd {
    fput $theftp [join [args]]
    complete
}

proc showList {chanId host port} {
    global thedtp
    global dtpclient
    global transferType
    set dtpclient $chanId  
    fileevent $dtpclient readable {eval "$transferType"}
    close $thedtp
}

proc screenTransfer {} {
    global dtpclient
    echo "[read $dtpclient]"
    if {[eof $dtpclient]} {
	echo "Transfer Complete"
	close $dtpclient	
    }
}

proc listTransfer {} {
    global dtpclient
    global listTransferList
    global listTransferComplete
    
    lappend listTransferList [read $dtpclient]
    if {[eof $dtpclient]} {
	set listTransferComplete 1
	close $dtpclient	
    }
}

proc asciiTransfer {filename} {
    global dtpclient
    set theFile [open [file join $filename] w]
    fconfigure $theFile -blocking no
    puts $theFile [read $dtpclient]
    if {[eof $dtpclient]} {
	echo "Transfer Complete"
	close $dtpclient	
			close $theFile
    }
}

proc binTransfer {filename} {
    global dtpclient
    global theFile
    fconfigure $dtpclient -blocking no -translation binary
    set theFile [open [file join $filename] w]
    fconfigure $theFile -blocking no -translation binary
    unsupported0 $dtpclient $theFile
    if {[eof $dtpclient]} {
	echo "Transfer Complete"
	close $dtpclient	
	close $theFile
    }
}

	

proc calcport {ip port} {
    regsub -all {\.} $ip , ipcomma
    set bitport "[expr int($port / 256)],[expr $port % 256]"
    set result "$ipcomma,$bitport"
    return $result
}               

proc fput {chan cmd} {
    echo "-> $cmd"
    puts $chan $cmd
    flush $chan
}

alias bye {
    catch {close $theftp} 
    catch {close $thedtp}
    catch {close $dtpclient}
    echo "Disconnected"
    complete
}

on unload {
	/bye
}

proc doftpcmd {chan cmd {type "screenTransfer"}} {
    global thedtp
    global dtpPort
    global transferType
   
    set transferType $type
    set ip [lindex [fconfigure $chan -sockname] 0]

    set thedtp [socket -server showList -myaddr $ip $dtpPort]
    fconfigure $thedtp -blocking no 
    incr dtpPort
    
    set port [lindex [fconfigure $thedtp -sockname] 2]
    set portcmd "PORT [calcport $ip $port]" 
    
    fput $chan $portcmd
    fput $chan $cmd
}
	
