set debugFlag 1

proc decho {text} {
	global debugFlag
	if {$debugFlag} {
		echo "\a0E$text"
	}
}

proc watch {varname {ops w}} {
	decho "Setting watch on variable: $varname"
  if {[regexp {(.*)(\((.*)\))$} $varname a b c d]} {
		upvar $b $b ${b}_old x
		catch {
			set x($d) [subst "\$$b\($d\)"]
		}
  } else {
  	upvar $varname $varname
 		upvar ${varname}_old x
 		catch {
	  	if {[array exists $varname]} {
	  		array set x [array get $varname]
			} else {
				set x [subst "\$$varname"]
			}
		}
	}
  trace variable $varname $ops watchProc
}

proc delwatch {varname {ops w}} {
	decho "Deleting watch on variable: $varname"
	upvar $varname $varname
	trace vdelete $varname $ops watchProc
	if {[regexp {(.*)(\((.*)\))$} $varname a b c d]} {
		upvar $b $b ${b}_old x
		catch {unset x($d)}
  } else {
 		upvar ${varname}_old x
 		catch {unset x}
 	}
}
 
proc listwatch {varname} {
	foreach var [info vars] {
		set w [trace vinfo $var]
		if {$w != ""} {
	    decho "Watch exists on $var: [lindex $w 0]"
		}
  }
}


proc watchProc {name element op} {
	set oldname ${name}_old
	if {$element != ""} {
		set oldname ${name}_old($element)
		set name ${name}($element)
	}
	upvar $name x $oldname x_old
	set old "unknown"
	catch {set old $x_old}
	switch $op {
		r {
	    decho "Watch: $name was read, value=\"$x\""
		}
		w {
	    decho "Watch: $name was set, newvalue=\"$x\" oldvalue=\"$old\""
		}
		u {
	    decho "Watch: $name was unset"
		}
  }
  set x_old $x
}

alias do {
	eval [join [args]]
	complete
}









