######################################################################################
#########################  Procedures for AWAY functionality  ########################
######################################################################################

## GLOBALS ##

set DefaultAwayMsg "Ok, everyone stop what they are doing till I get back"
set DefaultBackMsg "I have returned!  You may now continue."

# AutoAway is how long in seconds you must be idle before it
# automatically sets you away. -1 turns autoaway off.  
set AutoAway 1200

set AWAY 0
set AwayTimer 0
set AwayMsgLog ""
set AwayTimeStamp ""

## Procedures ##


alias AWAY {
    if {$AWAY} {
	echo "*** You are already set AWAY ***"
    } else {
	if {[args] == ""} {
	    set awaymsg $DefaultAwayMsg
	} else {
	    set awaymsg [args]
	}
	set AwayTimeStamp [clock format [clock seconds] -format "%a %I:%M:%S %p %Z"]
	/ame is AWAY: $awaymsg * All msgs will be logged
	/raw away :$awaymsg (Away since $AwayTimeStamp * All msgs will be logged)
	set AWAY 1
	set AwayTimer 0
    }
    complete
}

alias BACK {
    if {$AWAY} {
	if {[args] == ""} {
	    set backmsg $DefaultBackMsg
	} else {
	    set backmsg [args]
	}
	/ame is back: $backmsg
	/raw away
	if {$AwayMsgLog != ""} {
	    echo "You have [llength $AwayMsgLog] Messages"
	    foreach msg $AwayMsgLog {
		echo $msg
	    }
	}
	set AWAY 0
	set AwayMsgLog ""
    } else {
	echo "*** You are not set AWAY ***"
    }
    complete
}

on MSG {
    set dest [lindex [args] 0]
    if {$AWAY} {
	if {[sCompare $dest [my_nick]]} {
	    set timestamp [clock format [clock seconds] -format "%a %I:%M:%S %p %Z"]
	    set msg [join [lrange [args] 1 end]]
	    set msg "<$timestamp> [nick]: $msg"
	    lappend AwayMsgLog "$msg"
	    /query [nick]
	    echo $msg query [nick]
	    # /raw notice [nick] :[my_nick] is away: $awaymsg (Away since $AwayTimeStamp * All msgs will be logged)
	    complete
	}
    }
}


on TIMER {
    if {$AutoAway > -1 && !$AWAY} {
	set AwayTimer [expr $AwayTimer + 1]
	if {$AwayTimer >= $AutoAway} {
	    set AwayTimer 0
	    /away Automatically set away
	}
    }
}

alias PRIVMSG {
    if {$AutoAway > -1 && !$AWAY} {
	set AwayTimer 0
    }
}

