######################################################################################
###############################  Auxillary procedures  ###############################
######################################################################################


#This is an Array Iterator.
#It sets the argument "key" to the Arrays key/index for each
#element of the array.  Its not really neccessary as a foreach
#on "array names" will do the same thing, but I did it to see if I could

proc forEachKeyInArray {key arrayName codeBlock} {
	upvar $key arrayKey
	upvar $arrayName theArray
	foreach arrayKey [array names theArray] {
		uplevel $codeBlock
	}
}

#Iterator for all the users.  you provide variable names for index, user and group
#and the iterator will fill these variables on each iteration.

proc forEachUser {index user group codeBlock} {
	upvar $user userKey
	upvar $index indexKey
	upvar $group groupKey
	for {set indexKey 0} {$indexKey < [user_count]} {set indexKey [expr $indexKey + 1]} {
		set entry [get_user $indexKey]
		set userKey [lindex $entry 0]
		set groupKey [lindex $entry 1]
		uplevel $codeBlock
	}
}

#A Simple proc which tells if $element is in the list $list

proc isInList {list element} {
	if {[lsearch $list $element] == -1} {
		return 0
	} else {
		return 1
	}
}

proc iisInList {list element} {
	if {[ilsearch $list $element] == -1} {
		return 0
	} else {
		return 1
	}
}

proc sCompare {a b} {
    return [string match [string tolower $a] [string tolower $b]]
}

proc escapeOut {text} {
    set output ""
    for {set i 0} {$i < [string length $text]} {incr i} {
	append output "\\[string index $text $i]"
    }
    return $output
}

proc ilsearch {list item} { 
	set idx 0
	foreach i $list {
		if {[sCompare $item $i]} {
			return $idx
		}
		incr idx
	}
	return -1
} 

proc removeFromList {list element} {
	upvar $list mylist
	set i [lsearch -exact $mylist $element]
	if {$i > -1} {set mylist [lreplace $mylist $i $i]} 
}

proc iremoveFromList {list element} {
	upvar $list mylist
	set i [ilsearch $mylist $element]
	if {$i > -1} {set mylist [lreplace $mylist $i $i]} 
}

proc stringListToLower {list} { 
	set lower ""
	foreach item $list {
		lappend lower [string tolower $item]
	}
	return $lower
} 

# A Safe way to check the Key value of an array without
# generating a tcl error if the array has no val at that key

proc getArrayValue {arrayName key} {
	upvar $arrayName myArray
	set list [array get myArray]
	if {[isInList $list $key]} {
		return $myArray($key)
	} else {
		return -1
	}
}

# duplicates an echo to both status window and current active window
proc secho {str} {
	echo "$str" status Status
	if {[string tolower [window_type]] != "status"} {echo "$str"}
}

# arg - joins all arguments to form a single argument

proc arg {} {
    return [join [args]]
}

#This alias allows you to try tcl commands from oirc
alias tcl {
	eval [join [args]]
	complete
}

# This allows you to run timed commands like in mIRC with /timer <interval> <quantity> <cmd>

set timerQueue ""

alias timer {       
	set interval [lindex [args] 0] 
	set quantity [lindex [args] 1] 
	set codeBlock [lrange [args] 2 end]
	echo "*** The timer (TimerID = [timer $interval $quantity $codeBlock]) will execute $quantity times at intervals of $interval seconds."
	complete
}

alias killTimer {
	set pid [lindex [args] 0]
	if {[delTimer $pid] > 0} {
		echo "*** Timer $pid removed from Queue"
	} else {
		echo "*** No Timer event found for ID $pid"
	}
	complete
}

proc delTimer {pid} {
	global timerQueue 
	set removeList "" 
	set dels 0
	foreach event $timerQueue {
		if {[lindex $event 4] == $pid} {
			lappend removeList $event
			set dels [expr $dels + 1]
		}
	}
	foreach event $removeList {
		removeFromList timerQueue $event
	}	
	return $dels
}	


proc timer {interval quantity codeBlock} {  
	global timerQueue
	set startTime [clock seconds]
	set timerPID [clock clicks]
	lappend timerQueue [list $startTime $interval $quantity $codeBlock $timerPID]
	return $timerPID
}

alias findtimer {
	set cmd "[args]" 
	echo "TimerID is: [findTimerID $cmd]"
	complete
}

proc findTimerID {cmd} {
	global timerQueue 
	foreach event $timerQueue {
		if {[string match "*[string tolower $cmd]*" "[string tolower [lindex $event 3]]"] } {
			return [lindex $event 4] 
		}
	}
	return -1
}
	

on timer {
	set removeList ""
	foreach event $timerQueue {           
		set startTime [lindex $event 0]
		set interval [lindex $event 1] 
		set quantity [lindex $event 2]
		set currTime [clock seconds]
		if {([expr ($currTime - $startTime) % $interval] == 0) && ($startTime != $currTime)} {
			eval [lindex $event 3]
		}
		if {$quantity > 0 && $currTime >= [expr $startTime + ($interval * $quantity)]} {
                	lappend removeList $event
		}
	}
	foreach event $removeList {
		removeFromList timerQueue $event
	}		
}

# Given a TYPE NICK USER and HOST, this proc will return a "nick!user@hostmask" 
# matching one of the defined types.	

proc getHostType {type nick user host} {
    set netIdx [string last "." $host]
    set domIdx [string last "." [string range $host 0 [expr $netIdx - 1]]]
    set hstIdx [string first "." $host]
    
    switch "$type" {
	"1" {                                                    
	    return "${nick}!*[string trimleft ${user} "~"]@${host}"
	} 
	"2" {                                                    
	    return "${nick}!*[string trimleft ${user} "~"]@*[string range $host $hstIdx end]"
	} 
	"3" {                                                    
	    return "${nick}!*[string trimleft ${user} "~"]@*[string range $host $domIdx end]"
	} 
	"4" {                                                    
	    return "${nick}!*@${host}"
	} 
	"5" {                                                    
	    return "${nick}!*@*[string range $host $hstIdx end]"
	} 
	"6" {                                                    
	    return "${nick}!*@*[string range $host $domIdx end]"
	} 
	"7" {
	    return "*!*[string trimleft ${user} "~"]@${host}"
	}
	"8" {
	    return "*!*[string trimleft ${user} "~"]@*[string range $host $hstIdx end]"
	}
	"9" {
	    return "*!*[string trimleft ${user} "~"]@*[string range $host $domIdx end]"
	}
	"10" {
	    return "*!*@${host}"
	}
	"11" {
	    return "*!*@*[string range $host $hstIdx end]"
	}
	"12" {
	    return "*!*@*[string range $host $domIdx end]"
	}
	default {
	    return ""
	}
    }
}

proc commafy {theNumber} {
	set output ""
	set length [string length $theNumber]
	set pos 0
	for { set i [expr $length - 1] } { $i > -1} {incr i -1} {
		if {[expr $pos % 3] == 0  && $pos != 0} {
			set output ",$output"
		}
		set output "[string index $theNumber $i]$output"                     
		set pos [expr $pos + 1]
	}
	return $output
}
					  
 
	





