######################################################################################
##################################  Common Aliases  ##################################
######################################################################################

alias M { /msg [arg];complete}

alias chat { /dcc chat [args];complete }

alias W { /whois [args];complete }

alias k { /kick [arg];complete }

alias b { /mode [channel] +b [args];complete }

alias i { /invite [args] [channel];complete }

alias t { /topic [arg];complete }

alias J { 
	foreach chan [args] {
		if {[string match "#*" $chan]} {
			/join $chan
		} else {
			/join #$chan
		}
	}
	complete
}

alias AMSG {
	foreach chan [channels] {
		/msg $chan [args]
	}
	complete
}

alias ANOTICE {
	foreach chan [channels] {
		/notice $chan [args]
	}
	complete
}

alias OP {
    /mode [channel] +oooo [arg]
    complete
}

alias DEOP {
    /mode [channel] -oooo [arg]
    complete
}

alias PING {
    /ctcp [args] ping
    complete
}

alias AME {
	foreach chan [channels] {
		/ctcp $chan ACTION [args]
		echo "* [my_nick] [args]" channel $chan
	}
	complete
}

alias dns {
    set host [lindex [args] 0]
    lookup $host
    echo "*** Attempting to resolve $host"
    complete
}

on lookup {
    set request [lindex [args] 0]
    set result  [lindex [args] 1]
    if { [string length $result] } {
        echo "*** Resolved $request to $result"
    } else {
        echo "[color error]*** ERROR: Could not resolve $request"
    }
}

alias WALL {
    set dest [channel]
    set text [arg]
    set ops [nicks [channel] @*]
    set opList "" 
    set count 0

    if {![llength [nicks $dest @[my_nick]]]} {
	echo "*** You need to be an Op to use Wall"
	complete
	return
    }
    removeFromList ops @[my_nick]
    set wallstring "\[WallOp:$dest\] $text"

    foreach nick $ops {
	set nick [string trimleft $nick "@+"]
	if {$opList != ""} {
	    set opList "${opList},$nick"	
	} else {   
	    set opList "$nick"	
	}                      
	set count [expr $count + 1]
	if {[expr $count % 10] == 0} {
	    /raw notice $opList :$wallstring
	    set opList ""
	    set count 0
	}		
    }  
    if {$opList != ""} {
	/raw notice $opList :$wallstring
    }
    echo "\a0E-[my_nick]-[color notice] $wallstring"
    complete
}                                                  

	
# This allows wallop to recognize wallops from specific channels and
# keep the notices from appearing anywhere but in that channel
# window.

on NOTICE {
    set chan ""
    set text [lindex [args] 1]
    regexp -nocase {\#[a-z0-9]+} $text chan
    if {[ilsearch [channels] $chan] != -1} {
	echo "\a0E-[nick]-[color notice] $text" channel $chan
	complete
    }
    
}
 		
