set encoder_on 0

alias encoder {
    if { [string toupper [lindex [args] 0]] == "ON" } {
        set encoder_on 1
    } elseif { [string toupper [lindex [args] 0]] == "OFF" } {
        set encoder_on 0
    }

    if { $encoder_on } {
        echo "Encoder is now ON.\nType /ENCODER OFF to turn it OFF!"
    } else {
        echo "Encoder is now OFF.\nType /ENCODER ON to turn it ON!"
    }
    complete
}

alias privmsg {
    if { $encoder_on } {
        set text "~"
        append text [encode [join [lrange [args] 1 end]]]
        /msg [lindex [args] 0] $text
        echo "[color highlight]DECODED:[color nick] <[my_nick]>[color default] [encode [string range $text 1 end]]" status
        complete
    }
}
        
on privmsg {
    set text [lindex [args] 1]
    if { [string range $text 0 0] == "~" } {
        echo "[color highlight]DECODED:[color nick] <[nick]>[color default] [encode [string range $text 1 end]]" status
    }
}

proc encode { text } {
    set result ""
    for { set i [expr [string length $text] - 1] } { $i >= 0 } { incr i -1 } {
        append result [string range $text $i $i]
    }
    return $result
}
