# Auxiliary functions
# Part of Dolby

proc arg {} {
    return [join [args]]
}

proc getHostType {type nick user host} {
    set netIdx [string last "." $host]
    set domIdx [string last "." [string range $host 0 [expr $netIdx - 1]]]
    set hstIdx [string first "." $host]
    
    switch "$type" {
	"1" {                                                    
	    return "${nick}!*[string trimleft ${user} "~"]@${host}"
	} 
	"2" {                                                    
	    return "${nick}!*[string trimleft ${user} "~"]@*[string range $host $hstIdx end]"
	} 
	"3" {                                                    
	    return "${nick}!*[string trimleft ${user} "~"]@*[string range $host $domIdx end]"
	} 
	"4" {                                                    
	    return "${nick}!*@${host}"
	} 
	"5" {                                                    
	    return "${nick}!*@*[string range $host $hstIdx end]"
	} 
	"6" {                                                    
	    return "${nick}!*@*[string range $host $domIdx end]"
	} 
	"7" {
	    return "*!*[string trimleft ${user} "~"]@${host}"
	}
	"8" {
	    return "*!*[string trimleft ${user} "~"]@*[string range $host $hstIdx end]"
	}
	"9" {
	    return "*!*[string trimleft ${user} "~"]@*[string range $host $domIdx end]"
	}
	"10" {
	    return "*!*@${host}"
	}
	"11" {
	    return "*!*@*[string range $host $hstIdx end]"
	}
	"12" {
	    return "*!*@*[string range $host $domIdx end]"
	}
	default {
	    return ""
	}
    }
}
