#---------------------------------------------------------------------------
# Simple Aliases
#---------------------------------------------------------------------------

alias m {
    /msg [arg]
    complete
}

alias j {
    /join [arg]
    complete
}

alias p {
    /part [arg]
    complete
}

alias op {
    /mode [channel] +oooo [arg]
    complete
}

alias deop {
    /mode [channel] -oooo [arg]
    complete
}

alias ping {
    /ctcp [arg] ping
    complete
}

alias amsg {
    foreach c [channels] {
        /msg $c [arg]
    }
    complete
}

alias ame {
    foreach c [channels] {
        /ctcp $c ACTION [arg]
        echo "[color nick]* [my_nick][color public] [arg]" channel $c
    }
    complete
}

alias scripts {
    echo "Loaded scripts:"
    set i 0
    foreach s [scripts] {
        echo "\[[incr i]\] $s"
    }
    complete
}

#---------------------------------------------------------------------------
# Ban Alias
#---------------------------------------------------------------------------
set ban_nicks ""
set ban_chans ""

alias ban {
    set nick [string tolower [lindex [args] 0]]
    set chan [channel]
    if { $nick != "" && $chan != "" } {
        lappend ban_nicks $nick
        lappend ban_chans $chan
        whois $nick
    }
    complete
}

on whois {
    set nick [string tolower [nick]]
    set i [lsearch $ban_nicks $nick]
    while { $i > -1 } {
        set ch [lindex $ban_chans $i]
        set ban_nicks [lreplace $ban_nicks $i $i]
        set ban_chans [lreplace $ban_chans $i $i]
        /mode $ch +b [nick]![user]@[host]
        set i [lsearch $ban_nicks $nick]
    }
}

on 401 {
    set nick [string tolower [lindex [args] 1]]
    set i [lsearch $ban_nicks $nick]
    while { $i > -1 } {
        set ban_nicks [lreplace $ban_nicks $i $i]
        set i [lsearch $ban_nicks $nick]
    }
}


#---------------------------------------------------------------------------
# Domain Name Resolution
#---------------------------------------------------------------------------
set dns_nicks ""

alias dns {
    set host [arg]
    if { [string match *.* $host] } {
        lookup $host
        echo "*** Attempting to resolve $host"
    } else {
        lappend dns_nicks [string tolower $host]
        whois $host
        echo "*** Retrieving information for $host"
    }
    complete
}

on lookup {
    set request [lindex [args] 0]
    set result  [lindex [args] 1]
    if { [string length $result] } {
        echo "*** Resolved $request to $result"
    } else {
        echo "[color error]*** ERROR: Could not resolve $request"
    }
}

on whois {
    set nick [string tolower [nick]]
    set i [lsearch $dns_nicks $nick]
    while { $i > -1 } {
        lookup [host]
        echo "*** Attempting to resolve [host]"
        set dns_nicks [lreplace $dns_nicks $i $i]
        set i [lsearch $dns_nicks $nick]
    }
}

on 401 {
    set nick [lindex [args] 1]
    set i [lsearch $dns_nicks $nick]
    while { $i > -1 } {
        set dns_nicks [lreplace $dns_nicks $i $i]
        set i [lsearch $dns_nicks $nick]
    }
}


#---------------------------------------------------------------------------
# Status Popup Menu
#---------------------------------------------------------------------------
menu status "*&Join #XiRCON" { /join #XiRCON }
menu status ""
menu status "&MOTD"          { /motd }
menu status ""
menu status "&Away"          { /away "since [clock format [clock seconds]]" }
menu status "&Back"          { /away }


#---------------------------------------------------------------------------
# Channel Popup Menu
#---------------------------------------------------------------------------
menu channel "*&Properties" { show_props channel [arg] }


#---------------------------------------------------------------------------
# Query Popup Menu
#---------------------------------------------------------------------------
menu query "*&Whois"         { /whois [arg] }
menu query ""
menu query "&CTCP->&Ping"    { /ctcp [arg] ping }
menu query "&CTCP->&Version" { /ctcp [arg] version }
menu query "&CTCP->&Time"    { /ctcp [arg] time }
menu query ""
menu query "&Finger"         { /finger [arg] }


#---------------------------------------------------------------------------
# Chat Popup Menu
#---------------------------------------------------------------------------
menu chat "*&Whois"         { /whois [arg] }
menu chat ""
menu chat "&CTCP->&Ping"    { /ctcp [arg] ping }
menu chat "&CTCP->&Version" { /ctcp [arg] version }
menu chat "&CTCP->&Time"    { /ctcp [arg] time }
menu chat ""
menu chat "&Finger"         { /finger [arg] }


#---------------------------------------------------------------------------
# Users Popup Menu
#---------------------------------------------------------------------------
menu users "&Whois"   { /whois [arg] }
menu users "*&Query"  { /query [arg] }
menu users ""
menu users "&Op"      { /op [arg] }
menu users "&DeOp"    { /deop [arg] }
menu users ""
menu users "&Kick!"   { /kick [arg] }
menu users "&Ban!"    { /ban [arg] }
menu users ""
menu users "&CTCP->&Ping"    { /ctcp [arg] ping }
menu users "&CTCP->&Version" { /ctcp [arg] version }
menu users "&CTCP->&Time"    { /ctcp [arg] time }
menu users ""
menu users "&Slap!" { /me slaps [arg] around a bit with a TCL powered popup }


#---------------------------------------------------------------------------
# General Procedures
#---------------------------------------------------------------------------
proc arg {} {
    return [join [args]]
}

proc longip { ip } {
    global tcl_precision
    set tcl_precision 17
    set result 0
    regexp {([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)} $ip s b3 b2 b1 b0
    if { ![string compare $ip $s] } {
        set total 0
        set total [expr $total + double($b3) * pow(256,3)]
        set total [expr $total + double($b2) * pow(256,2)]
        set total [expr $total + double($b1) * pow(256,1)]
        set total [expr $total + double($b0) * pow(256,0)]
        set result [format "%10.0f" $total]
    }
    return $result
}

proc stricmp { s1 s2 } {
    return [string compare [string tolower $s1] [string tolower $s2]]
}
