
/*******************************************************************************
														MULTI_EDIT MACRO FILE

Name: USERIN  <-  USERIN1

Description:  - - Included by USERIN.S - -
							Most of the general purpose user input routines.

DATA_IN        - A general purpose Boxed Data entry menu.
DI_STRING_IN   - String input field handler for DATA_IN only.
DI_LIST_FIELD  - List field input handler for DATA_IN only.
DI_DIR_FIELD   - Directory field handler for DATA_IN only.
DI_EDIT_WINDOW - Edit window field handler for DATA_IN only.
HISTORY_LIST   - History list handler for DATA_IN only.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

str _specChar(str tstr[max_line_length])  trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  _SpecChar

DESCRIPTION:  This is a general purpose string manipulator that changes
certain "unprintable" characters to the Multi-Edit macro language ASCII
Character representation for the purpose of displaying them in prompts.  The
string is passed to this macro via the standard ME parameter passing
convention, and the result is returned.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str 	TChars[40];
	char 	TChar;
	int 	JX,Jy;

	Tchars = '|26|0|9|255|12|13|27';

	Jy = 1;
	while(  (Jy < 8)  ) {
		jx = 1;
		while(  (Jx > 0)  ) {
			jx = XPOS(Copy(TChars,Jy,1),TStr,jx);
			if(  jx != 0  ) {
				TStr = Str_Del(TStr,jx,1);
				TStr = Str_Ins('||' + Str(Ascii(Copy(TChars,Jy,1))),TStr,jx);
				jx = jx + 3 + (Jy == 4) - (Jy == 2);
/* Special instance of numeric characters following altered string */
SPECIAL_CASE:
				if(  (Length(Tstr) >= Jx)  ) {
					TChar = Copy(TStr,Jx,1);
					if(  (XPos(TChar,'0123456789',1))  ) {
						TStr = Str_Del(TStr,jx,1);
						TStr = Str_Ins('||' + Str(Ascii(Tchar)),TStr,Jx);
						Jx = Jx + 3;
						Goto SPECIAL_CASE;
					}
				}
			}
		}
		++Jy;
	}
	return(Tstr);
}


str _valChar(str tstr[max_line_length]) trans2 {
	str 	Tstr2[60];
	int 	JX,Jy;
	char  TChar ;
	/* Get bar characters */
	JX = 1;
CHECKQ2:
	jx = XPOS('||',TStr,jx);
	if(  jx != 0  ) {
		if(  (JX < Length(TStr)) &
			 (XPOS(Copy(TStr,jx+1,1),'0123456789',1) != 0)  ) {
			jy = jx + 1;
			TStr2 = '';
Next_Char:
			TChar = Copy(Tstr,jy,1);
			if(  XPOS(TChar,'0123456789',1)  ) {
				TStr2 = TStr2 + TChar;
				++jy;
				Goto Next_Char;
			}
			if(  VAL(jy,Tstr2) == 0  ) {
				TStr = Str_Del(TStr,jx,Length(Tstr2) + 1);
				TStr = Str_Ins(Char(Jy),TStr,jx);
			}
			++jx;
		} else {
			jx = jx + 2;
		}
		goto CHECKQ2;
	}
	return(TStr);
}



macro DATA_IN trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name:  DATA_IN

Description: Builds a screen of editable fields.  Each field has its own
	column and line setting, as well as its own help and type attributes.

Parameters:  /#=count  // the number of fields
						 /S=start_field // the starting field number
						 /PRE=str // The prefix to use for the global var names
						 /X=nn  // The Upper Right hand column, or x coordinate
						 /Y=nn  // The Upper Right hand row, or y coordinate
						 /H=str  // help string
						 /HT=nn  // The height of the box, automatically calculated if not
										 present
						 /W=nn  // The width of the box, automatically calculated as above
						 /T=title  // The title of the box
						 /A=nn  Accept type.
										0 = Accept or Cancel.
										1 = Accept no matter what
										2 = Force use of enter key for accept (applies only
												 to classic mode );
										3 = Enter key is Go, F10 key is Done, (applies only to
												 classic mode );

						 /NC=nn 1 = NO Cleanup.  Don't erase global variables when done.
						 /NB=1  Don't create a box
						 /NK=1  Don't kill box
						 /NM=1  Don't allow box move.
						 /VA=1  Verify abort.  If user presses cancel or abort, bring up
										a verify prompt.
						 /NODONE = 1    Don't display a 'Done' or 'OK' button.
						 /NOCANCEL = 1  Don't display a 'Cancel' button.
						 /NOHELP = 1    Don't display a 'Help' button.

						 /EDITFIELDS=1  a very special mode which allows one to move fields
														around.  Does not allow user input.


Returns:    RETURN_INT = 0 if the <ESC> key was pressed.
						Else RETURN_INT = Then item that <ENTER> was pressed on.

Global Vars:
				ISTR_1 .. ISTR_x   // field string, x = count
				IPARM_1 .. IPARM_x  // parmaeter string,x = count
					/C=       column
					/L=       line
					/W=       displayable width of field
					/ML=      max length if max length is 0 then max length = width.
					/H=       help_link.
					/T=       Field title
					/GO=      If <enter> pressed on this field, treat like accept field.
					/G=       Name of a global string to use instead of ISTR_x - rarely used
					/HISTORY= name of history_list globals
					/PROTECT= 1 prevents a field from being changed.
					/MIN=     Minimum numeric value if a numeric type
					/MAX=     Maximum numeric value if a numeric type
					/NHT=     No Height adjust.
					/TP=      type
								 type of 0 = string (default)
												 1 = integer
												 2 = real number
												 3 = Multiple Choice with vertical menu.
														 ISTR_x contains the menu.
														 IINT_x contains the choice number.
												 4 = Hex - same as integer, except display and
																	 user input in hex.
												 5 = toggle true or false.
															ISTR_x = '/T=YES/F=NO'
															IINT_x = boolean value.
												 6 = Not used...
												 7 = Run macro, return integer.
														 IPARM=x /M=macro (must be last parameter)
														 The following parameters get passed to the
														 macro:
																/X=nn
																/Y=nn
																/STR=str (the string in ISTR_x)
												 8 = Run macro, return string(or return global, see below).
														 IPARM=x /M=macro (must be last parameter)
																/X=nn
																/Y=nn
																/INT=nn (the integer in IINT_x)
												 /RGS= Return global string.  Used only with /TP=8.
															 Due to the 255 character limit on Return_Str, if
															 you specify the name of a global string, it will
															 use that instead.

												 9 = Keycode field.  It is stored in IINT as an integer
														 lower byte is primary scan code, upper byte is
														 extended scan code.  Field will be displayed as in
														 the example below:
															 SET_GLOBAL_INT('IINT_1',7181);
															 Displays <ENTER>
														 User will be prompted for a keystroke when he presses
														 <ENTER> a type 9 field.
												10 = Display data, but no entry field.  Uses /L= only.
																/ATTR=nn  attribute
												11 = Button.
												12 = Radio box
												13 = Check box
												14 = 3 state check box
												15 = List box
														 /WIN=nn  Window number, NOT WINDOW_ID!!!!!!!!!
														 /HT=nn   height in lines
												16 = Edit window box
														/WIN=nn  Window number
														/HT=nn   height in lines
														/W=nn  Width of list
														/PB=n non-zero persistent blocks on
												17 = Hidden field, stores a string
												18 = Hidden field, stores an int
												20 = Directory box

												30 = Bitmap button
														 /MD=0    Select bitmap
																 1    Do nothing with the button
																 2    Treat like a type 11 button



				IINT_x = value for integer or multiple choice.

		Note that if an X and Y coordinate was specified in the parameter line
		then, the column and line numbers will be offsets from the X and Y
		coordinates.


Example:  // Setup multi-file search

		Set_Global_Str('ISTR_1',filespec);
		Set_Global_Str('IPARM_1','/T=Filespec:/C=1/W=60/ML=80/H=SR/L=1');
		Set_Global_Str('ISTR_2',Search_Str);
		Set_Global_Str('IPARM_2','/T=Search For:/C=1/W=63/ML=128/H=SR/L=2');
		Set_Global_Str('IPARM_3','/T=>>>>/C=1/H=SR/L=3/TP=6/W=17');
		Set_Global_Str('ISTR_3','START FILE SEARCH');

		Set_Global_Int('IINT_4',search_dirs);
		Set_Global_Str('ISTR_4','/T=YES/F=NO');
		Set_Global_Str('IPARM_4','/T=Search Subdirectories..../C=1/W=3/H=SR/L=4/TP=5');
		Set_Global_Str('ISTR_5',global_str('FSEARCH_PATH'));
		Set_Global_Str('IPARM_5','/T=Starting path............/C=1/W=40/H=SR/L=5');
		Set_Global_Int('IINT_6',case_sensitive);
		Set_Global_Str('ISTR_6','/T=YES/F=NO');
		Set_Global_Str('IPARM_6','/T=Case Sensitivity........./C=1/W=3/H=SR/L=6/TP=5');
		Set_Global_Int('IINT_7',use_reg_exp);
		Set_Global_Str('ISTR_7','/T=YES/F=NO');
		Set_Global_Str('IPARM_7','/T=Use Regular Expressions../C=1/W=3/H=SR/L=7/TP=5');

		RM('UserIn^Data_In /S=1/A=3/#=7/X=1/T=SEARCH FILES/Y=' + str(y1));


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/



#DEFINE dir_immediate Global_Int('DIR_IMMEDIATE')

	str
           MStr[2000],
					 Prefix[10],
					 iint[15], iparm[15], istr[15],
					 c_str1[20],
					 RGS[20],
           signal_str[20] = parse_str('/SGNL=', mparm_str),
           predisp_mac = parse_str("/PREDISP=", mparm_str)

				 ;


	char  tchar ;
	int   tcp,
				fjx,
						menu,
						use_handle = parse_int('/HN=', mparm_str ),
						t_refresh = Refresh,
						field_count,    /* The number of fields */
						X1, Y1, Height,
						Width, jx, jy, jz, old_x, old_y,
						c_choice,
						tt,tw, hc,
						ll,             /* Temp label length */
						protect,        /* field protect status */
						C_Parm,         /* The parm string being worked on */
						accept_mode,
						count,
						Edit_Enable = FALSE,
						go_accept = FALSE,
						ok_button = parse_int("/NODONE=", mparm_str),
						cancel_button = parse_int("/NOCANCEL=", mparm_str),
						help_button = parse_int("/NOHELP=", mparm_str),
						parent_window = parse_int("/PARENT=", mparm_str),
						xx, yy,
						xmenu_count,
						orig_mode = mode,
						old_win = cur_window,
						dialog_style = GLOBAL_INT('@DIALOG_STYLE'),
						Display_Lines = 0,
						signal_flag,
						dialog_done = FALSE,
						help_needs_moving = false;
				 ;

		if(!parent_window)
		{
			parent_window = frame_handle;
		}

		int main_dlg;

		int c_win_enabled = IsWindowEnabled( parent_window );

		int line_height = 0, font_height = 0, font_width = 0, dfont = 0;

		int cur_focus = GetFocus;
		int jx1;



		struct TMsg msg;



		str tstr[max_line_length];

		int xstyle, old_tt,
				th, w,h,y,x, e_id, spare_id = 60000, dstr, yofs;
		str class[40] = "",
			history_str[20];

		real T_Real;

		main_dlg = Create_MEW_Dlg( parse_str("/T=", mparm_str), parse_str ("/H=", mparm_str),
									parent_window, DLG_NOSIZE);
		Get_MEW_Dlg_Metrics( main_dlg, line_height, font_height, font_width, dfont );
		int dc;


	call get_our_dc;

	if(  use_handle  ) {
		menu = return_int;
	} else {
		menu = menu_create;
	}

	signal_flag = (signal_str != '');

	refresh = false;
	working;
	Var_Parse_Str('/RGS=',MParm_Str, Rgs);

	Return_Int = False;
	field_count = 0;
	Push_Labels;
	Set_Global_Int('MENU_LEVEL', Global_Int('MENU_LEVEL') + 1);

		/* Get the count of the fields */
	var_parse_int( '/#=', mparm_str, field_count );

	var_parse_str('/POSG=', mparm_str, mstr );
	if(  mstr != ''  ) {
		mstr = global_str( mstr );
		Var_Parse_Int('/X=', mStr, x1);
		Var_Parse_Int('/Y=', mStr, y1);
	} else {
		Var_Parse_Int('/X=', MParm_Str, x1);
		Var_Parse_Int('/Y=', MParm_Str, y1);
	}

	var_parse_str(  '/PRE=', mparm_str, prefix );
	iint = prefix + 'IINT_';
	istr = prefix + 'ISTR_';
	iparm = prefix + 'IPARM_';

	if(  NOT( use_handle )  ) {
		call reset_fields;
		jx = 0;
		while(  jx < field_count  ) {
			++jx;
			mstr = global_str( iparm + str(jx ) );
			menu_set_item( menu, jx,
				parse_str('/T=', mstr) ,global_str(istr + str(jx)),mstr ,
				parse_int('/TP=',mstr), global_int( iint + str(jx)), 0 );
		}
	}

REBUILD_BOX:
	height = 0;
	width = 0;
	var_parse_int( '/A=', mparm_str, accept_mode );

	if(  (dialog_style) & (accept_mode == 3)  ) {
		accept_mode = 0;
	}
	if(  (accept_mode == 0) & (field_count == 1)  ) {
		accept_mode = 2;
	}
		 tt = 1000;
		/* If no height or width then calculate then by going through the
		 entire list of fields and determining the maximun column and
		 row needed. */
		C_Parm = 1;
		while(  (C_Parm <= field_count)  ) {
			MStr = menu_item_str( menu,  C_Parm, 3);

			if( !xpos("/L=", mstr, 1 )  )
			{
				jy = ((height + 1) / Line_Height) + 1;
			}
			else
				Var_Parse_Int('/L=',MStr, jy);

			// menu_set_int( menu, c_parm, 3, jy );
			tstr = menu_item_str( menu, c_parm, 1 );

			var_parse_int('/C=', mstr, xx);

			var_parse_int('/MID=',mstr, e_id );

			if(!e_id)
			{
				e_id = menu_item_int( menu, c_parm, 3 );

				if( e_id == 0)
          e_id = 200 + c_parm;
			}

			class = "";
			xstyle  = 0;


			if( parse_str("/KC=", mstr) != '' ) {
				tstr +=  parse_str("/KC=", mstr);
			}

			old_tt = tt;
			tt = menu_item_int( menu, c_parm, 1 );


			if( (tt == 11) || (tt == 12) || (tt == 13) || (tt == 14) ) {
				tstr = shorten_str(tstr);
				if( old_tt != tt ) {
					xstyle |= ws_group;
					if( tt != 12)
					{
						xstyle = xstyle | ws_tabstop;
					}
				}
			}
			else {
				if(( tt != 10 ) && (tt != DLG_KeyCode) && (tt != DLG_MacroBtnStr)) {
					if (tt == 30) {
						xstyle |= ws_group;
					} else {
						xstyle |= ws_tabstop + ws_group;
					}
				}
			}



			jx = svl(tstr) + 1;

			if( tt > 3 ) {
				w = GetTextExtent( dc, tstr, jx) AND 0xFFFF;
			}
			else {
				jz = GetTextExtent( dc, tstr, jx) AND 0xFFFF;
				w=(svl(tstr) + 1 ) * font_width;
				if(jz > w)
					w=jz;
			}

			if (jz = parse_int("/QK=",mstr) )
			{
				tstr = str_ins( "&", tstr, jz );
			}

			dstr = 1;
			yofs = 0;
			history_str = "";

			// w=jx * font_width;
			x=(xx - 1) * font_width + 5;
		/*  if(jy == 0)
			{
				y = height + 3;
			}
			else */
				y=(jy - 1) * line_height + 3;
			h=font_height + 2;

			if(  (tt != 17) && (tt != 18)  ) {
				switch(tt) {
				case 0 :
				case 1 :
				case 2 :
					if(  (tt == 0)  ) {
						if(  (Parse_Str('/G=',Mstr) != '')  ) {
	/* If they wish to use a specified storage global, use that instead
	10-03-90 TR */
							menu_set_str( menu, c_parm, 2, Global_Str(Parse_Str('/G=',Mstr)));
						}
						if(  (Parse_Int('/SPCH=',MStr))  ) {
	/* Convert non printable characters into |xx on string type only if required.
	This was primarily created for the printer driver menu */
							RM('SPECCHAR ' + menu_item_str( menu, c_parm, 2 ));
							menu_set_str( menu, c_parm, 2, return_str );
						}
					} else if(  (tt == 1)  ) {
						if(  (Parse_Str('/G=',Mstr) != '')  ) {
	/* If they wish to use a specified storage global, use that instead
	10-03-90 TR */
							menu_set_int( menu, c_parm, 2, Global_Int(Parse_Str('/G=',Mstr)));
						}
					}
					var_parse_int( '/W=', mstr, ll );
					h = line_height - 1;
					history_str = parse_str("/HISTORY=",mstr);
					if(history_str != "")
					{
						class = "COMBOBOX";
						xstyle |= cbs_dropdown | cbs_autohscroll;
						h = parse_int('/#=', global_str(history_str));
						if ( h > 10 )
						{
							h = 10;
							xstyle |= ws_vscroll;
						}
						++h;
						if (h < 4) { // for some reason, if h < 4, the list looks weird
							h = 4;
						}
            h = font_height * h + font_height;
					}
					else
					{
						class = "EDIT";
						xstyle |= ws_border | es_autohscroll;
					}
					xstyle |= es_left;
					if( tstr != "" )
					{
						th = Create_MEW_Ctrl( "STATIC", tstr,
														0,
														x,
														y,
														w,
														line_height - 1,
														main_dlg,spare_id,
														app_handle,  0
														);
						++spare_id;

					}
					--y; --y;
					x = x + w + font_width;
					w=(parse_int("/W=", mstr) * font_width);
					tstr = menu_item_str( menu, c_parm, 2 );

					if( tt == 1 )
					{
						tstr = str( menu_item_int( menu, c_parm, 2 ));
					}
					call create_ctrl;
					h = line_height - 1;

					int max_len = parse_int("/ML=", mstr );
					if(!max_len)
						max_len = parse_int("/W=", mstr);

					if(max_len)
					{
						if(class == "COMBOBOX")
						{
							SendMessage (th, CB_LIMITTEXT, max_len, 0);
						}
						else
						{
							SendMessage (th, EM_LIMITTEXT, max_len, 0);
						}
					}

					if( tt == DLG_Integer )
					{
							int minint = 0 - 0x7ffffffe;
							int maxint = 0x7FFFFFFF;
							if( xpos("/MAX=", mstr,1 ) )
								var_parse_int( "/MAX=", mstr, maxint );
							if( xpos("/MIN=", mstr,1 ) )
								var_parse_int( "/MIN=", mstr, minint );

							int spinwin = CreateWindow("mewspin", "1,99,50",
												WS_VISIBLE | WS_CHILD | (MSS_VERTICAL | MSS_TEXTHASRANGE | MSS_INVERTRANGE),
												x + w + 2, y, (font_width * 2) + 1, line_height - 1,
												main_dlg, 0, app_handle, 0);

							SubClass_With_Macro( th, "DlgSpinProc", "/MIN=" + str(minint) + "/MAX=" + str(maxint) );
							MSHAssociateSet( spinwin, th );
					}

					break;


				case 3 :
					{
						class = "COMBOBOX";
						xstyle |= cbs_dropdown | cbs_dropdownlist;
						w=parse_int("/W=", mstr) * font_width;
						call create_ctrl;

						int c_choice = menu_item_int( menu,c_parm, 2 );
						int res;
						if(  (C_Choice < 1)  ) {
							C_Choice = 1;
						}
						tstr = menu_item_str( menu, c_parm, 2 );
						int jx1 = 1;
						int jx2 = 1;
						int count = 0;
					loop:
						jx1 = xpos( '(', tstr, jx1 + 1 );
						if(  jx1 != 0  ) {
							if(  copy(tstr, jx1 + 1, 1) == '('  ) {
								tstr = str_del( tstr, jx1, 1);
								goto loop;
							}
							++count;
							jy = xpos( ')', tstr, jx1 + 1);
							// helpstr = copy( tstr, jx1 + 1, jy - jx1 - 1 );
							mstr = copy( tstr, jx2, jx1 - jx2 );
							res = 0;
							if(  svl(mstr) > 0  ) {
								if(  str_char( mstr, svl(mstr) ) == '|254'  ) {
									mstr = copy(mstr, 1, svl(mstr) - 1 );
									res = 1;
								}
							}
							SendDlgItemMessageStr( main_dlg, e_id, cb_addstring, 0, mstr);
						// menu_set_item( menu, count, mstr, '', '/S=2/H=' + helpstr, res, 0, 0 );
							jx2 = jy + 1;
							goto loop;
						}
						SetWindowPos( th, 0,0,0, w, line_height + (count * font_height), SWP_NOMOVE | SWP_NOZORDER );
						SendDlgItemMessage( main_dlg, e_id, cb_setcursel, c_choice - 1, 0);
						MStr = menu_item_str( menu,  C_Parm, 3);
					}
					break;

				case DLG_MacroBtnStr :
				case DLG_Keycode :
					if( tstr != "" )
					{
						class = "STATIC";
						e_id = spare_id;
						call create_ctrl;
						++spare_id;
						x = x + w + font_width;
					}
					//yofs = -2;
					w=(parse_int("/W=", mstr) * font_width) - (font_width * 3) + (font_width / 2) - 4;
					class = "EDIT";
					xstyle = xstyle | ws_border;

					var_parse_int("/HT=", mstr,h);
					if( h != 0)
					{
					 h = (h * line_height);
					}
					else
					{
						h = line_height - 2;
					}

					if ( tt == DLG_Keycode )
					{
						tstr = menu_item_str( menu, c_parm, 2 );
						key1 = parse_int("/K1=", tstr );
						key2 = parse_int("/K2=", tstr );
						call create_keycode;
						e_id = 3000 + c_parm;
					}
					else
					{
						tstr = menu_item_str( menu, c_parm, 2 );
					}

					int bwin = CreateWindow("BUTTON", "...",
										WS_VISIBLE | WS_CHILD | BS_PUSHBUTTON | WS_TABSTOP,
										x + w + 2, y, (font_width * 3) + (font_width / 2), line_height,
										main_dlg, spare_id, app_handle, 0);

					call create_ctrl;

					SubClass_With_Macro( bwin, "DlgPopupBtnProc", "/HN=" + str( th ) );
					SubClass_With_Macro( th, "DlgPopupProc",  "/CID=" + str( spare_id ) +
														"/#=" + str(c_parm) + "/K=" + str( tt == DLG_Keycode ) +
														"/DLG=" + str(menu) + menu_item_str(menu,c_parm,3) );
					++spare_id;
					break;

				case 10 :
					if( ll > 0 )
					{
						jy += ll;
					}
					class = "STATIC";
					if(parse_int("/W=", mstr)) {
						switch ( parse_int("/BOX=", mstr) )
						{
							case  1 :
												xstyle |= ss_blackframe;
												break;

							case 2 :
												xstyle |= ss_grayframe;
												break;

							case 3 :
												xstyle |= ss_blackrect;
												break;

							case 4 :
												xstyle |= ss_grayrect;
												break;

							case 0 :
												class = "BUTTON";
												xstyle |= bs_groupbox;
												break;

						}

						y+=2;
						w=parse_int("/W=",mstr) * font_width + 1;
						h=(parse_int("/HT=", mstr) * line_height) - 1;
					}
					call create_ctrl;
					break;



				case 11  :  /* if button */
					if(xpos('/R=', mstr, 1))
					{
						var_parse_int('/R=', mstr, ll );
						if(  ll == 0  ) {
							cancel_button = c_parm;
						} else if(  ll == 1  ) {
							ok_button = c_parm;
						} else if(  ll == 2  ) {
							help_button = c_parm;
						}
					}
					class = "BUTTON";
					xstyle = xstyle + bs_pushbutton | ws_tabstop;
					if ( menu_item_int( menu, c_parm, 2 ) )
					{
						xstyle |= bs_defpushbutton;
					}
					var_parse_int("/HT=", mstr,h);
					if( h != 0)
					{
					 h = (h * line_height);
					}
					else
					{
					 h = ((DLG_DefBtnHeight * font_height) / 8) + 1;
					}

					w+= font_width + 8;
					var_parse_int("/W=", mstr,jz );
					if( jz != 0 )
					{
						w=(jz*font_width);
					}
					call create_ctrl;
					break;

				case 12 :
					if(  menu_item_int( menu, c_parm, 2 ) > 0  ) {
						var_parse_str( '/G=', mstr, c_str1 );
						if(  svl(c_str1) > 0  ) {
							var_parse_int( '/R=', mstr, ll );
							set_global_int( c_str1, ll );
						}
					}
					class = "BUTTON";
					xstyle = xstyle + bs_autoradiobutton;
					w += font_width + font_width + font_width;
					call create_ctrl;
					if( menu_item_int( menu, c_parm, 2 ) )
						SendDlgItemMessage( main_dlg, e_id, bm_setcheck,1, 0 );
					break;


				case 13 :
					class = "BUTTON";
					xstyle = xstyle + bs_autocheckbox;
					w += font_width + font_width + font_width;
					call create_ctrl;
					if( menu_item_int( menu, c_parm, 2 ) )
						SendDlgItemMessage( main_dlg, e_id, bm_setcheck,1, 0 );
					break;

				case 14 :
					class = "BUTTON";
					xstyle = xstyle + bs_auto3state;
					w += font_width + font_width + font_width;
					call create_ctrl;
					switch ( menu_item_int( menu, c_parm, 2 ))
					{
						case 1 :
							SendDlgItemMessage( main_dlg, e_id, bm_setcheck, 1, 0 );
							break;
						case -1 :
							SendDlgItemMessage( main_dlg, e_id, bm_setcheck, 0, 0 );
							break;

						default:
							SendDlgItemMessage( main_dlg, e_id, bm_setcheck, 2, 0 );
					}
					break;


				case 15 :
					Display_Lines = parse_int('/DISP#=',MStr);
					switch_window( parse_int('/WIN=', mstr) );
					window_attr =  0x90;

					call calculate_list_field;
					var_parse_int( '/HT=', mstr, jx );
					if(  jx == 0  ) {
						jx = 10;
						mstr = mstr + '/HT=10';
					}
					h=jx * line_height + 1;
					jy = jy + jx + Display_Lines - 1;
					var_parse_int( '/W=', mstr, jx );
					if(  jx == 0  ) {
						jx = ll;
						var_parse_int( '/MW=', mstr, ll );
						if(  (ll == 0)  ) {
							ll = 15;
						}
						if(  jx < ll  ) {
							jx = ll;
						}
						mstr = mstr + '/W=' + str(jx);
					}

					w=jx + 1;

					menu_set_str( menu, c_parm, 3, mstr );



					int tdc = dc;

					if(dc != 0)
						call release_our_dc;

					if ( tstr != '' )
					{
						th = Create_MEW_Ctrl( "STATIC", tstr,
														0,
														x,
														y,
														(w + 1) * font_width,
														font_height,
														main_dlg,
														spare_id,
														app_handle, 0
														);
						y = y + font_height + 2;
						++spare_id;
					}

						int lflags = 0;
						if(parse_int("/INCO=", mstr))
							lflags |= _LB_FLAG_INCSEARCH;

						window_attr =  0x90;

						th = ListBoxCreate( cur_window, 1, xmenu_count,
										x, y, (w * font_width) + 5, h + 5, e_id,
										lflags, 0, main_dlg, "");

					goto_col(1);

					if(tdc != 0)
						call get_our_dc;

					break;

				case 16 :
					var_parse_int( '/W=', mstr, jx );
					if(  jx == 0  ) {
						jx = 20;
					}
					Jx = Jx + xx + 1;

					var_parse_int( '/HT=', mstr, ll );
					if(  ll == 0  ) {
						ll = 3;
					}

					h = ll * line_height + 1;


					if(dc != 0)
						call release_our_dc;

					if ( tstr != '' )
					{
						th = Create_MEW_Ctrl( "STATIC", tstr,
														0,
														x,
														y,
														(w + 1) * font_width,
														font_height,
														main_dlg,
														spare_id,
														app_handle, 0
														);
						y = y + font_height + 2;
						++spare_id;
					}
					w=(jx + 1) * font_width;

						int lflags = 0;
						if(parse_int("/INCO=", mstr))
							lflags |= _LB_FLAG_INCSEARCH;

					th = Create_MEW_List( "", cur_window,
									ws_child | ws_visible | ws_hscroll | ws_vscroll | ws_tabstop,
									x, y, w + 5, h, main_dlg, e_id);

					if(tdc != 0)
						call get_our_dc;


					break;


				case 30 :
					if(xpos('/R=', mstr, 1))
					{
						var_parse_int('/R=', mstr, ll );
						if(  ll == 0  ) {
							cancel_button = c_parm;
						} else if(  ll == 1  ) {
							ok_button = c_parm;
						} else if(  ll == 2  ) {
							help_button = c_parm;
						}
					}
					var_parse_int("/HT=", mstr,h);
					if( h != 0)
					{
					 h = (h * line_height);
					}
					else
					{
						h = line_height + (font_height / 5);
					}

					w+= font_width + 8;
					var_parse_int("/W=", mstr,jz );
					if( jz != 0 )
					{
						w=(jz*font_width);
					}

					menu_set_str( menu, c_parm, 3, mstr +
								"/_X=" + str(x) +
								"/_Y=" + str(y) +
								"/_W=" + str(w) +
								"/_H=" + str(h)
								);

					if(parse_int("/MD=", mstr) == 1)
					{
						jx = MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP;
						xstyle |= bs_pushbutton;
					}
					else
					{
						xstyle |= ws_tabstop | bs_pushbutton;
						if ( menu_item_int( menu, c_parm, 2 ) )
						{
							xstyle |= bs_defpushbutton;
						}
						jx = MEWBTN_PUSHBUTTON | MEWBTN_SIZETOBITMAP;
					}
					mstr = menu_item_str( menu, c_parm, 2 );
					if(mstr == "")
					{
						mstr = "BT_BLANK";
					}
					th = BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, mstr,
										xstyle, jx,
										e_id, x, y, 0, 0 );
					MStr = menu_item_str( menu,  C_Parm, 3);
					break;


				case 20 :
					break;

				default :
					var_parse_int( '/W=', mstr, ll );
				}
			}
			if( parse_int("/OFF=", mstr))
			{
				EnableWindow( th, false );
				tt = -1;
			}
			if( height < (h + y))
			{
				height = h + y;
			}
			if( svl(history_str) > 0)
			{
				int ic = 0;
				jx = parse_int('/#=', global_str(history_str));
				mstr = global_str( history_str + str(ic) );
				if( mstr != "" )
				{
					SendDlgItemMessageStr( main_dlg, e_id, cb_addstring, 0, mstr );
				}
				for( ic = jx; ic > 0; ic--)
//        for( ic = 0; ic <= jx; ic++)
				{
					mstr = global_str( history_str + str(ic) );
					if( mstr != "" )
					{
						SendDlgItemMessageStr( main_dlg, e_id, cb_addstring, 0, mstr );
					}

				}
			}
			if( tt < 2 ) {
				SetDlgItemText( main_dlg, e_id, tstr );
			}
			menu_set_int( menu, c_parm, 3, make_long(e_id, th) );
			++C_Parm;
		}
		if(  (parse_int('/DBM=', mparm_str) == 0) &
				((((ACCEPT_MODE == 0) | (ACCEPT_MODE == 2))
						& (cancel_button == 0)) |
					NOT(ok_button) | NOT(help_button))  ) {
			height += font_height / 2;
			tw = 0;
			var_parse_str('/ABT=', mparm_str, c_str1 );
			if(  c_str1 == ''  ) {
				if(  accept_mode == 3  ) {
					c_str1 = 'GO';
				} else {
					c_str1 = 'OK';
				}
			}
			var_parse_str('/CBT=', mparm_str, Mstr );
			if(  mstr == ''  ) {
				if(  accept_mode == 3  ) {
					mstr = 'Done ';
				} else {
					mstr = 'Cancel';
				}
			}
			tw = 1;
			if(  NOT( ok_button )  ) {
				++field_count;
				ok_button = field_count;
				menu_set_item( menu, field_count, c_str1, '', '/QK=3/R=1', 11, 1, height );
				tstr = c_str1;
				xstyle = bs_pushbutton + bs_defpushbutton | ws_tabstop;
				w=10;
				e_id = 1;
				call set_standard_button2;

				tw += 12;
			}
			if(  NOT( cancel_button ) & ((accept_mode == 0) | (accept_mode == 2) | (accept_mode ==3))  ) {
				++field_count;
				cancel_button = field_count;
				if(  accept_mode == 3  ) {
					menu_set_item( menu, field_count, mstr, '','/QK=1/R=0/KC=-F10/K1=0/K2=68', 11, 0, height );
				} else {
					menu_set_item( menu, field_count, mstr, '','/QK=1/R=0/KC=-Esc/K1=27/K2=1', 11, 0, height );
				}
				tstr = mstr;
				w = 10;
				e_id = 2;
				call set_standard_button;
				tw += 12;
			}
			if(  NOT( help_button )  ) {
				tw += 2;
				++field_count;
				help_needs_moving = true;
				help_button = field_count;
				menu_set_item( menu, field_count, 'Help', '','/QK=1/R=2/KC=-F1/K1=0/K2=59', 11, 0, height );
				tstr = "Help";
				w = 10;
				e_id = 3;
				call Set_Standard_Button;
				tw += 12;
			}
		}
	var_parse_int( '/S=', mparm_str, C_Parm );  /* Get the starting field number */
	if(  c_parm == 0  ) {
		for( c_parm = 1; c_parm <= field_count; c_parm++ )
		{
			if( menu_item_int( menu, c_parm, 1 ) != 10)
			{
				break;
			}
		}
	}

	call release_our_dc;

	Update_Status_Line;

	refresh =  TRUE;
	Auto_Size_Mew_Dlg(main_dlg, 10,10);

	if (help_needs_moving) {
		int help_handle;
		struct TRECT dlg_rect;

		GetClientRect(main_dlg, &dlg_rect);
		help_handle = GetDlgItem(main_dlg, 3);
		DestroyWindow(help_handle); // its much easier to kill and remake than to move
		tstr = "&Help";
		e_id = 3;
		xstyle = bs_pushbutton | ws_tabstop;
		class = "BUTTON";
		h = ((DLG_DefBtnHeight * font_height) /8) + 1;
		w = font_width * 10;
		x = (dlg_rect.right - dlg_rect.left) - w - 5;
		y = height;
		call create_ctrl;

	}
  if ( predisp_mac != "" )
  {
    RM (predisp_mac + " /DLGHANDLE=" + str (main_dlg));
  }
  ShowWindow( main_dlg, SW_SHOWNORMAL );
	SetFocus(menu_item_int( menu, c_parm, 3 ) >> 16);


	switch( menu_item_int(menu,c_parm,1 )  )
	{
		case 0 :
		case 1 :
		case 2 :
		case 3 :
      if(parse_str("/HISTORY=",menu_item_str(menu,c_parm,3)) != "")
      {
        SendMessage( menu_item_int( menu, c_parm, 3 ) >> 16, CB_SETEDITSEL, 0, Make_Long( 0, -1 ) );
      }
      else
      {
        SendMessage( menu_item_int( menu, c_parm, 3 ) >> 16, EM_SETSEL, 0, Make_Long( 0, -1 ) );
      }
      break;

	}

  int dlgowner = GetWindow( main_dlg, GW_OWNER );

message_loop:
	while( !dialog_done )
	{
		if( getmessage( &msg, 0, 0, 0 ))
		{
      if ( (msg.message == WM_MEW_DLGRETURN) && (msg.hwnd == dlgowner) )
			{
				if(msg.wparam >= 60000)
				{
					SendDlgItemMessage( main_dlg, msg.wparam, WM_TRIGGER_POPUP, 0, 0 );
				}
				else if ( (msg.wparam == 1) || (msg.wparam  == 998) )
				{
					return_int = 1;
					break;
				}
				else if(msg.wparam == 2 )
				{
					return_int = 0;
					break;
				}
				else if(msg.wparam == 3 )
				{
					Call GET_HELP;
				}
				else
				{
					call id_menu_item;
					if(c_parm > 0)
					{
						switch ( menu_item_int(menu,c_parm,1) )
						{
							case 7 :
												call run_int_macro;
												break;
							case 11 :
												call process_button;
												break;
							case 30 :

												mstr = menu_item_str(menu,c_parm,3);
												var_parse_int( "/MD=", mstr, jx );
												switch( jx )
												{
													case 0 :
														menu_set_str(menu,c_parm,2,
																Set_Bitmap(menu_item_str(menu,c_parm, 2), main_dlg));
														mstr = menu_item_str(menu,c_parm,3);
														e_id = menu_item_int(menu,c_parm,3) & 0x0000FFFF;
														th = menu_item_int(menu,c_parm,3) >> 16;
														tstr = menu_item_str( menu, c_parm, 2 );
														if(tstr == "")
															tstr = "BT_BLANK";
														th = ReBuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, tstr ,
																			th,bs_pushbutton, MEWBTN_PUSHBUTTON | MEWBTN_SIZETOBITMAP,
																			e_id,
																			parse_int("/_X=", mstr),
																			parse_int("/_Y=", mstr),
																			parse_int("/_W=", mstr),
																			parse_int("/_H=", mstr) );
														menu_set_int( menu, c_parm, 3, make_long(e_id,th) );
														call check_active;
														break;

													case 1 :
														break;
													case 2 :
														call process_button;
												}
												break;

						}
					}
				}
			}
			else if ((msg.message == WM_KEYDOWN) && (msg.wparam == VK_F1))
			{
				Call GET_HELP;
			}
			else if( !IsDialogMessage( main_dlg, &msg) )
			{
					translatemessage( &msg );
					dispatchmessage( &msg );
			}
		}
		else
		{
			break;
		}
	}


message_exit:
	int  result = return_int;
	refresh = false;


	for( jx = 1; jx <= field_count; jx++ )
	{
		tt = menu_item_int( menu, jx, 1 );
		mstr = menu_item_str( menu, jx, 3 );
		E_Id = Menu_Item_Int( Menu, Jx, 3 );
		switch ( tt )
		{
			case 0 :
			case 2 :
//				GetDlgItemText( main_dlg, jx + 100, tstr, 1023 );
				GetDlgItemText( main_dlg, E_Id & 0xFFFF, tstr, max_line_length );
				menu_set_str( menu, jx, 2, tstr );
				return_str = tstr;
				tstr = parse_str("/HISTORY=", mstr );
				if( tstr != "" )
				{
					rm("HISTORY_LIST /M=1/HISTORY=" + tstr);
				}
				break;

			case 1 :
//				GetDlgItemText( main_dlg, jx + 100, mstr, 1023 );
				GetDlgItemText( main_dlg, E_Id &0xFFFF, mstr, 1023 );
				jx1 = 0;
				val( jx1, mstr );
				menu_set_int( menu, jx, 2, jx1 );
				break;

			case 3 :
				menu_set_int( menu, jx, 2,
				SendDlgItemMessage( main_dlg, E_Id & 0xFFFF, cb_getcursel, 0, 0) + 1);
				break;


			case 8 :
				GetWindowText( E_Id >> 16, tstr, 254 );
				menu_set_str( menu, jx, 2, tstr );
				break;

			case 12 :
			case 13 :
				jx1 = IsDlgButtonChecked( main_dlg, E_Id & 0xFFFF ) == 1;
				menu_set_int( menu, jx, 2, jx1);
				break;

			case 14 :
				jx1 = IsDlgButtonChecked( main_dlg, E_Id & 0xFFFF );
				if ( jx1 == 0)
				{
					jx1 = -1;
				}
				else if ( jx1 == 2)
				{
					jx1 = 0;
				}
				menu_set_int( menu, jx, 2, jx1);
				break;

			case 15 :
				switch_window( parse_int("/WIN=", mstr));
				menu_set_int( menu, jx, 3, c_line );
				break;

		}
	}

big_exit2:
	Destroy_Mew_Dlg( main_dlg );
	return_int = result;
	goto exit;

check_active:
	if(!IsWindowEnabled( main_dlg ) )
	{
		EnableWindow(  main_dlg , TRUE );
	}
	if( GetActiveWindow() !=  main_dlg )
	{
		BringWindowToTop(  main_dlg );
	}
	update_status_line;
	ret;


id_menu_item:
	c_parm = 1;
	while( c_parm <= field_count )
	{
		if(( menu_item_int( menu, c_parm, 3) & 0xffff) == msg.wparam)
		{
			 ret;
		}
		++c_parm;
	}
	c_parm = 0;
	ret;


get_our_dc:
	dc = GetDc( main_dlg );
	Selectobject( dc, dfont );

	ret;

release_our_dc:
	ReleaseDC( main_dlg, dc );
	dc = 0;
	ret;




create_ctrl:
	int tdc = dc;

	if(dc != 0)
		call release_our_dc;

	th = Create_MEW_Ctrl( class, tstr,
							xstyle,
							x,
							y,
							w,
							h,
							main_dlg,e_id,
							app_handle,  0
						);
	if(tdc != 0)
		call get_our_dc;
	ret;


set_standard_button:
	xstyle = bs_pushbutton | ws_tabstop;
set_standard_button2:
	class = "BUTTON";

// This height is the same as is used in DIALOG.S
	h = ((DLG_DefBtnHeight * font_height) /8) + 1;
//  h = line_height + (font_width / 5 );
	w = font_width * w;
	x = tw * font_width;
	y = height;
	call create_ctrl;
	ret;

set_main_dlg:
	EnableWindow( main_dlg, TRUE );
	BringWindowToTop( main_dlg );
	ret;

create_keycode:
	{
		if((key1 == 0) && (key2 == 0))
		{
			tstr = '';
		}
		else
		{
			tstr = make_key_name( make_word( key1, key2 ) );
		}
	}
	ret;

calc_xmenu_count:
	mark_pos;
	eof;
	xmenu_count = c_line;
	if(  c_col == 1  ) {
		--xmenu_count;
	}
	goto_mark;
	ret;

calculate_list_field:
	mark_pos;
	tof;
	xmenu_count = 0;
	ll = 0;
	if( !parse_int("/W=", mstr) ) {
		while(  NOT( at_eof )  ) {
			++xmenu_count;
			jx = length(get_line);
			if(  jx > ll  ) {
				ll = jx;
			}
			down;
		}
	} else {
//		if( !parse_int("/HT=", mstr) )
			call calc_xmenu_count;
	}
	goto_mark;
	if(  at_eof  ) {
		goto_col(1);
		if(  at_eof  ) {
			goto_line( c_line - 1 );
		}
	}

	++ll;
	hc = xmenu_count;
	ret;


prepare_macro:
	Return_Str = Copy(menu_item_str( menu,  C_Parm, 3  ),Return_Int + 3,
		255);
	if(  (XPos(' ',Return_Str,1) == 0)  ) {
		Return_Str = Return_Str + ' ';
	}
	return_str = '/PRE=' + prefix;
	ret;

run_int_macro:
	Return_Int = XPos('/M=',menu_item_str( menu,  C_Parm, 3  ),1);
	if(  (Return_Int)  ) {
		call prepare_macro;
		return_int = menu_item_int( menu, c_parm, 2 );
		call set_fields;
		EnableWindow( main_dlg, FALSE );
    RM(Return_Str + '/DLGHANDLE=' + str(main_dlg) +
          '/INT=' + Str(menu_item_int( menu, c_parm, 2 )));
		call check_active;
		call reset_fields;
		menu_set_int( menu, c_parm, 2, Return_Int );
		return_int = 1;
	}
	ret;

run_str_macro:
	Return_Int = XPos('/M=',menu_item_str( menu,  C_Parm, 3  ),1);
	if(  (Return_Int)  ) {
/* Check to see if command line parameters already exist in the macro name.  If
so, don't add a space between macro name and the params we are adding */
		MStr = Copy(menu_item_str( menu,  C_Parm, 3  ),Return_Int + 3,
			255);
		if(  (XPos(' ',MStr,1) == 0)  ) {
			MStr = MStr + ' ';
		}
		Return_Str = menu_item_str( menu, C_PARM, 2);
		if(  (RGS != '')  ) {
			Set_Global_Str(RGS,menu_item_str(menu, c_parm, 2));
		}
		call set_fields;
		// make_message( mstr );
		EnableWindow( Main_Dlg, FALSE );
    RM(MStr + '/DLGHANDLE=' + str(main_dlg) +
        '/X=' + Str(X1) + '/Y=' + Str(Y1) +
        '/STR=' + menu_item_str( menu, C_PARM, 2) + '/PRE=' + prefix);
		call check_active;
		call reset_fields;
		if(  return_int > 0  ) {
			menu_set_str( menu, c_parm, 2, return_str );
			if(  (RGS != '')  ) {
				menu_set_str( menu, c_parm, 2, global_str( rgs ));
			}
			SetWindowText( menu_item_int( menu, c_parm, 3) >> 16, menu_item_str( menu,c_parm,2));
		}
		// Clear global string
		if ( Svl( Rgs ) != 0 ) {
			Set_Global_Str( Rgs, "" );
		}
		return_int = 1;
	}
	ret;

process_button:
	mstr = menu_item_str(menu,c_parm,3);
	if (parse_int("/M=", mstr)) {     // Run macro
    tstr =  menu_item_str( menu, c_parm, 2 );
		// set_global_int("!DATA_IN_#", t_parm );
    if (xpos(" ", tstr, 1) == 0) {
      tstr = tstr + " ";
		}
		call set_fields;
    Rm( TStr + "/DLGHANDLE=" + str( Main_Dlg ) + "/PRE=" + Prefix
        + "/GSTR=" + Parse_Str( "/GSTR=", MStr ) + "/DATAHANDLE=" +
				str( Menu ) + "/DATAID=" + str( C_Parm ) );
		call check_active;
		call reset_fields;

    if(return_int)
		{
			 dialog_done = TRUE;
		}
	}
	else {
		if(!xpos("/R=", mstr,1))
		{
			return_int = menu_item_int( menu, c_parm, 3) & 0xfff;
			dialog_done = TRUE;
		}
		else
		{
			return_int = parse_int("/R=", mstr );
			if (return_int == 2) {
				call get_help;
			}
			else
				dialog_done = TRUE;
		}
	}
	ret;

get_help:
	MewHelp_Context();
	ret;


int  tx, tc ;

set_fields:
	if( !use_handle ) {
		tx = 0;
		while(  tx < field_count  ) {
			++tx;
			Set_Global_Str(istr + Str(tx),menu_item_str( menu, tx, 2 ));
			Set_Global_Int(iint + Str(tx),menu_item_int( menu, tx, 2 ));
		}
	}
	ret;

reset_fields:
	if( !use_handle ) {
		tx = 0;
		while(  tx < field_count  ) {
			++tx;
			menu_set_str( menu, tx, 2, global_str(istr + str(tx)));
			menu_set_int( menu, tx, 2, global_int(iint + str(tx)));
		}
	}
	ret;



EXIT:
	set_global_int('TESTGLOB', c_parm );

	set_global_int('!DATA_IN_#', c_parm );

	if(  ((return_int == 0) & (Parse_Int('/VA=',Mparm_Str) == True))  ) {
/* Verify abort */
		RM('VERIFY /S=1/H=' + parse_str('/H=', mparm_str) +
				'/T=Are you sure you want to cancel these changes?');
		if(  (Return_Int == 0)  ) {
		 // Goto MAIN_LOOP;
		} else {
			Return_Int = 0;
		}
	}
	if(  (cur_window != old_win) & (parse_int('/NOW=', mparm_str) == 0)  ) {
		switch_window( old_win );
	}
	mode = orig_mode;

	set_global_int('!DATA_IN_X', x1 );
	set_global_int('!DATA_IN_Y', y1 );
	var_parse_str('/POSG=', mparm_str, mstr );
	if(  mstr != ''  ) {
		set_global_str( mstr, '/X=' + str(x1) + '/Y=' + str(y1) );
	}

	Tc = 0;
	while(  (Tc < field_count)  ) {
		++Tc;
		Mstr = menu_item_str( menu, TC , 3);
		tt = menu_item_int( menu, tc , 1);
		if(  (tt < 2)  ) {
			if(  (tt == 0)  ) {
/* Convert |xx back to non printable characters on string type only if required */
				if(  (Parse_Int('/SPCH=',Mstr))  ) {
					RM('VALCHAR ' + menu_item_str( menu, tc, 2));
// Double all ASCII 127 characters so they can be parsed out of a DB file.
					jx = 1;
					while (jx = xpos("",return_str,jx))
						return_str = str_ins("",return_str,++jx++);
					menu_set_str( menu, tc, 2, return_str );
				}
				if(  (Parse_Str('/G=',Mstr) != '')  ) {
/* If they wish to use a specified storage global, store value in that
10-03-90 TR */
					set_global_str(Parse_Str('/G=',Mstr),menu_item_str( menu, tc, 2));
				}
			} else if(  (tt == 1)  ) {
				if(  (Parse_Str('/G=',Mstr) != '')  ) {
/* If they wish to use a specified storage global, store value in that
10-03-90 TR */
					set_global_Int(Parse_Str('/G=',Mstr),menu_item_int( menu, Tc, 2));
				}
			}
		}
	}

	if(  NOT( use_handle )  ) {
		call set_fields;
		tc = 0;
		while(  tc < field_count  ) {
			++tc;
			Set_Global_Str(istr + Str(TC),menu_item_str( menu, tc, 2 ));
			Set_Global_Int(iint + Str(TC),menu_item_int( menu, tc, 2 ));
		}
			/* free up as much garbage as possible */
		if(  parse_int('/NC=', mparm_str) == 0  ) {
			Tc = 0;
			while(  (Tc < field_count)  ) {
				++Tc;
				Set_Global_Str(iparm + Str(TC),'');
			}
		}
		menu_delete(menu);
	}
	Set_Global_Int('MENU_LEVEL', Global_Int('MENU_LEVEL') - 1);
	Pop_Labels;
	Update_Status_Line;
	refresh = t_refresh;
big_exit:
}

macro HISTORY_LIST TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: HISTORY_LIST

Description:  Adds to or lists a history list.

Parameters:  /M=0      List history
             /M=1      Add to history (push)
             /M=2      Remove most recent entry (pop)
						 /X=n      X coordinate for history list
						 /Y=n      Y coordinate for history list
						 /HISTORY=str  History list name
						 /H=str    Help string

 Specify /HL parameter in main history global to give the global history list a length
 different then global.

               (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/
	int  m = parse_int('/M=', mparm_str),
       x = parse_int('/X=', mparm_str),
       y = parse_int('/Y=', mparm_str),
       s,
       c,
       jx, temp_integer,
       max;

	str  history_str[20] = parse_str('/HISTORY=', mparm_str ) ;


  if (Global_Int("@HISTORY_LENGTH") < 1) {
    Set_Global_Int("@HISTORY_LENGTH",15);
  }

  jx = parse_int ("/HL=", Global_Str (history_str));
  if ( jx )
  {
    max = jx;
  }
  else
  {
    max = Global_Int ("@HISTORY_LENGTH");
  }

  if (m == 0) {
	list_history:
		c =  parse_int( '/#=' , global_str(history_str));
		s = 1;
		if(  global_str(history_str + '0') != ''  ) {
			set_global_str( history_str + str(c + 1), global_str(history_str + '0') );
			++c;
			++s;
		}
		RM('GlobalVarList /REV=1/G=' + history_str +
				'/X=' + str(x) + '/Y=' + str(y) +
				'/T=HISTORY/H=' + parse_str('/H=', mparm_str) +
				'/#=' + str( c ) +
				'/SC=' + str(s)
				);
    if (s > 1) {
			set_global_str( history_str + str(c + 1), '' );
		}
  } else if (m == 1) {
	add_to_history:
//		if(  (History_Str == 'FILE_HISTORY')  ) {
//			return_str = caps(return_str);
//		}
    if (return_str != '') {
			jx = parse_int('/#=', global_str(history_str));
      if (!parse_int("/NOCHECK=",mparm_str)) {
        temp_integer = 0;
        while(  temp_integer < jx  ) {
          ++temp_integer;
          if(  caps(global_str( history_str + str(temp_integer) )) == caps(return_str)  ) {
            return_int = temp_integer;
            RM('deleteitem /G=' + history_str  + '/#=' + str(jx));
            --jx;
            temp_integer = jx;
          }
        }
      }

      if (jx > max) {
				return_int = 0;
				RM('deleteitem /G=' + history_str  + '/#=' + str(jx));
			} else {
				++jx;
			}
			set_global_str( history_str + str(jx), return_str);
      set_global_str( history_str, '/#=' + str(jx ) +
                  "/HL=" + parse_str ("/HL=", history_str));
		}
  } else if (m == 2) {  // pop off the most recent entry
    jx = parse_int('/#=', global_str(history_str));
    if (jx > 0) {
      set_global_str( history_str + str(jx), "");
      set_global_str( history_str, '/#=' + str(--jx) +
                  "/HL=" + parse_str ("/HL=", history_str));
    }
	}
}

Macro DELETEITEM TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  DELETEITEM

DESCRIPTION: Performs a "shuffle" of global variables used as arrays to fill
in the gap caused by the deletion of a single element.

PARAMETERS:
						/G= The name of the "base" of the global variable.
						/#= The total amount of array elements.
						/T= The type of global 0=string 1=integer.
						Return_Int the starting point to begin shuffling.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  jx, count, type ;
  str  gstr[20];

  gstr  = parse_str('/G=', mparm_str);
	count = parse_int('/#=', mparm_str);
  type  = parse_int('/T=', mparm_str);
  jx    = return_int;
	while(  jx <= count  ) {
		if(  type == 0  ) {
			set_global_str( gstr + str(jx), global_str( gstr + str(jx + 1)));
		} else {
			set_global_int( gstr + str(jx), global_int( gstr + str(jx + 1)));
		}
		++jx;
	}
	return_int = count - 1;
}

macro GLOBALVARLIST TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  GLOBALVARLIST

DESCRIPTION:  Creates a menu of global string "array elements".  This is
							assuming the use of globals as pseudo arrays by having the last
							part of the global name numeric characters and therefore can be
							referenced sequentially using a counter.
								Example:
									Global_Str('TEST1');
									Global_Str('TEST2');
									Global_Str('TEST3');
							In the above example, "TEST" would be considered the base, and 1,
							2, and 3 would be the value of the index to reference each element.

PARAMETERS:
							/G= The base name of the globals
							/#= The amount of elements
							/SC=n the starting cursor pos (default = 1);

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  old_win, jx, old_refresh, count, reverse ;
	str  gstr[20], event_str[20] ;
	old_win = window_id;
	old_refresh = refresh;
	refresh = FALSE;
	switch_window( window_count );
	create_window;
	window_attr = $80;
	count = parse_int('/#=', mparm_str);
	gstr = parse_str('/G=',mparm_str);
	reverse = parse_int('/REV=', mparm_str);
	if(  reverse  ) {
		jx = count;
	} else {
		jx = 1;
	}
	while(  c_line <= count  ) {
		put_line( global_str( gstr + str(jx) ) );
		if(  reverse  ) {
			--jx;
		} else {
			++jx;
		}
		down;
	}
	tof;
	goto_line(parse_int('/SC=', mparm_str));
	event_str = str(global_int('MENU_LEVEL')) + 'GV';
	set_global_str(event_str + 'IPARM_1', '/DC=1/TP=15/L=1/HT=5/C=1/MW=10/WIN=' + str(cur_window));
	RM( 'DATA_IN /T=HISTORY/#=1/A=2/PRE=' + event_str +
			'/X=' + parse_str('/X=', mparm_str) + '/Y=' + parse_str('/Y=', mparm_str) +
			'/H=' + parse_str('/H=', mparm_str)
		);
	refresh = false;
	return_str = get_line;
	delete_window;
	switch_win_id( old_win );
	refresh = old_refresh;
}

void ProcessDirBtn( ) {
/******************************************************************************
															 Multi-Edit Macro
															 16-Aug-95  16:33

  Function: Bring up the Select Directory dialog and enter the selected entry
						into the specified field.

  Entry   : /DLGHANDLE=   - The dialog window handle ( Windows )
						/DATAHANDLE=	- The data handle ( Menu ).
						/DATAID=			- The selected data id.
 						/SID=					- The position # of the string entry to update
            /FILE=        - By default, only a directory dialog appears.
                            Set this flag to 1, and you get an fprompt dialog
                            where you can select one file from.
            /HELP=        - Help topic to call if help is pressed.

  Exit    : Return_Int = False

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int Dlg = Parse_Int( "/DLGHANDLE=", MParm_Str );
	int Menu = Parse_Int( "/DATAHANDLE=", MParm_Str );
	int DataId = Parse_Int( "/DATAID=", MParm_Str );
  int File = Parse_Int( "/FILE=", MParm_Str );
	int FieldId;
	int CtrlId;
  // Use these flags to modify file prompt
  int FpromptFlags = _FP_FLAG_NOHISTORY | _FP_FLAG_RO | _FP_FLAG_OEM;

	str MStr[ 2000 ] = Menu_Item_Str( Menu, DataId, 3 );
	str TStr;
  str HelpTopic = Parse_Str( "/HELP=", mparm_str );

	FieldId = Parse_Int( "/SID=", MStr );			// String position # id
  if ( FieldId == 0 ) {
		FieldId = DataId - 1;
	}
	CtrlId = Menu_Item_Int( Menu, FieldId, 3 );
	TStr = Menu_Item_Str( Menu, FieldId, 2 );
  GetDlgItemText( Dlg, CtrlId, TStr, 254 );
  if ( file )
  {
    if ( FileNamePrompt(TStr, "Select File", "", HelpTopic, FpromptFlags))
    {
      SetDlgItemText( Dlg, CtrlId, TStr );
      Menu_Set_Str( Menu, FieldId, 2, TStr );
    }
  }
  else
  {
    if( SelectDirectory( Dlg, TStr, "Select Directory", HelpTopic, 0 ) ) {
      SetDlgItemText( Dlg, CtrlId, TStr );
      Menu_Set_Str( Menu, FieldId, 2, TStr );
    }
  }
	Return_Int = False;

}  // ProcessDirBtn