macro_file USERIN;
#include windows.sh
#include mew_dlgs.sh
#include mew_btn.sh
#include mewlist2.sh
#include dialog.sh
#include mewhelp.sh
#include FPROMPT.SH
#include STDDLGS.SH
#include mewlib.sh
#include MEW.SH

#define FILEMOD_HELPLINK "SAVE MODIFIED FILE"

/*******************************************************************************
														MULTI_EDIT MACRO FILE

Name: USERIN

Description:  Most of the general purpose user input routines.

QUERYBOX  - A general purpose boxed string input prompt.
VERIFY    - Are you sure?
CHECKFILE - A verify for files.


		Found in USERIN1.S:

DATA_IN         - A general purpose Boxed Data entry menu.
DI_STRING_IN    - String input field handler for DATA_IN only.
DI_LIST_FIELD   - List field input handler for DATA_IN only.
DI_FKEY_ROW     - Funtion key row help handler for DATA_IN only.
DI_DIR_FIELD    - Directory field handler for DATA_IN only.
DI_EDIT_WINDOW  - Edit window field handler for DATA_IN only.
HISTORY_LIST    - History list handler for DATA_IN only.


		Found in USERIN2.S:

SPECCHAR        - Changes untypeable character into the |xx convention.
VALCHAR         - Changes the |xx back to a character.
STRSRC          - Formats strings to be used in macro source code generators.
CHNGPARM        - Changes a single slash type parameter(/) in a global string.
GLOBALVARLIST		- Creates a menu of global pseudo-array elements.
DELETEITEM      - Shuffles global variable arrays.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/



macro XMENU trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: XMENU

Description: Generates a vertical or horizontal menu.

Returns:      Return_Int = 0 if <ESC> was pressed
												 > 0 then return_int is the number of the select
														 menu item.

Parameters:  /T=nn  0 = Horizontal menu
										1 = Vertical menu
						 /D=nn  0 = Do not include a "Done" Button
										1 = Do include a "Done" button
												Done button returns same value as "Cancel" and is used primarily for
												aesthetics.
						 /S=nn  Start menu item.
						 /L=str Label for box
						 /M=str The menu string.

										The format is as follows:

										Off(INDENT)Auto()Smart()

										Menu titles are seperated by ()'s
										Inside the ()'s are the help indexes
										If the help index is the same for all menu
										options you can just specify the first.

										Must be the LAST parameter passed.

						 /M1= - M3= The names of global strings to be added to /M= in case
										you need more menu choices than will fit on the 254
										character macro command line.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str  bstr[4] ;
	int  start,jx, jx2, jy, count, res, width = 30, pl = DLG_Units_QLine;
	str  mstr, itemname[80], helpstr[40] ;
	int dlg,cx,cw,cc;

	struct DlgCtrl ctrl;

	DlgCreate(dlg);

	start = parse_int( '/S=', mparm_str );


	jx = xpos( '/M=', mparm_str , 1);
	mstr = copy( mparm_str, jx + 3, 254 );
	count = 0;

	call get_menus;
	mstr = global_str( parse_str( '/M1=', mparm_str ) );
	call get_menus;
	mstr = copy(mstr, jx2, 254) + global_str( parse_str( '/M2=', mparm_str ) );
	call get_menus;
	mstr = copy(mstr, jx2, 254) + global_str( parse_str( '/M3=', mparm_str ) );
	call get_menus;
	goto do_menu;

get_menus:
	jx = 1;
	jx2 = 1;
loop:
	jx = xpos( '(', mstr, jx + 1 );
	if(  jx != 0  ) {
		if(  copy(mstr, jx + 1, 1) == '('  ) {
			mstr = str_del( mstr, jx, 1);
			goto loop;
		}
		++count;
		jy = xpos( ')', mstr, jx + 1);
		helpstr = copy( mstr, jx + 1, jy - jx - 1 );
		itemname = copy( mstr, jx2, jx - jx2 );
		res = 0;
		if(  svl(itemname) > 0  ) {
			if(  str_char( itemname, svl(itemname) ) == '|254'  ) {
				itemname = copy(itemname, 1, svl(itemname) - 1 );
				res = 1;
			}
		}

		cw = svl(itemname);
		if((cw+2) > width)
			width = cw + 2;

		cx = 0;
		while(cx < cw)
		{
			++cx;
			if(xpos(str_char(itemname,cx),"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890",1))
			{
				itemname = str_ins("&", itemname, cx );
				break;
			}
		}

		DlgAddCtrl( dlg, DLG_PushButton, itemname, 1, DLG_PosOffset | DLG_Units | pl, 0, 0, 100 + count, 0, "/R=" + str(count + 100 ));
		pl = DLG_Units_Per_Line + DLG_Units_QLine;
		jx2 = jy + 1;
		goto loop;
	}

	ret;

do_menu:
	for(jx=2;jx<=(count+1);jx++)
	{
		mstr = menu_item_str(dlg, jx, 3);
		str_to_struct(ctrl,mstr);
		ctrl.cw = width;
		ctrl.uw = width * DLG_Units_Per_Col;
		struct_to_str( mstr,ctrl );
		menu_set_str( dlg,jx,3, mstr);
	}


	DlgAddCtrl( dlg, DLG_PushButton, "Cancel", 1, DLG_PosOffset + 2, DLG_StanbtnWidth, 0, 1001, 0, "/R=0");
	DlgAddCtrl( dlg, DLG_PushButton, "&Help", width - DLG_StanBtnWidth + 1, dlg_PosOffset, DLG_StanbtnWidth, 0, 1002, 0, "/R=2");
/*  if ( parse_int("/D=", mparm_str ) )
	{
		if (  width <= 20 )
			menu_set_item( menu, count +  3, "Done", "", "/R=1/W=8/L="  + str((count+1) * 2 + 2) + "/C=" + str((width /2)-4), 11, 0, 0 );
		else
			menu_set_item( menu, count +  3, "Done", "", "/R=1/W=8/L="  + str(count * 2 + 2) + "/C=" + str(7 + ((width - 17)/2)), 11, 0, 0 );
		++count;
	}
	return_int = menu;
	rm("DATA_IN /HN=1/A=1/#=" + str(count + 2) + "/T=" + parse_str("/L=",mparm_str) );
*/
	return_int = DlgExecute(dlg, 101, parse_str("/L=", mparm_str), helpstr,"",0 );
	if(return_int < 100)
		return_int = 0;

	if(return_int >= 100)
		return_int = return_int - 100;
	if(  (Return_Int < 0)  ) {
		Return_Int = 0;
	}
	DlgKill(dlg);

}  // XMENU

void QueryBox( ) Trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name:   QUERYBOX

Description:  Creates a simple text input dialog box.

Parameters:   Return_Str is initialized the default input string value.
							The first 2 parameters are not normally neccesary because the box
							will automatically position itself.
							/C=n    The column position
							/L=n    The line number
							/W=n    The maximum width of the string in the box
							/ML=n   The maximum length of the string.
							/T=str  The box title
							/H=str  The help index
							/N=1    Numeric input.  If Numeric input then Return_Int
												should be initialized to the default value.
							/P=str  Prompt.
							/MIN=n  For numeric only.  n = minimum legal response value.
							/MAX=n  For numeric only.  n = maximum legal response value.
							/HISTORY= The history global name.
							/DIRB=1	Add show directory button.

Returns:      If NOT Numeric input then
								Return_Int = 1 if <ENTER> was pressed to accept the input.
								Return_Int = 0 if <ESC> was pressed.
								Return_Str = the inputted string.  Unchanged if Return_Int = 0.
							ELSE
								Return_Str = 'TRUE' if <ENTER> was pressed.
								Return_Str = 'FALSE' if <ESC> was pressed.
								Return_Int = The numeric result.  Unchanged if Return_Str = false.

							 (C) Copyright 1991-95 by American Cybernetics, Inc.
*******************************************************************************/
	int Result;
	int SavReturn_Int = Return_Int;
	int Dlg;
	int CtrlId = 100;
	int Numeric = Parse_Int( "/N=", MParm_Str );
	int Width = Parse_Int( "/W=", MParm_Str );
	int X;
	int Y;

	str Prompt = Parse_Str( "/P=", MParm_Str );
	str Title = Parse_Str( "/T=", MParm_Str );
	str TStr;

	DlgCreate( Dlg );

	DlgAddCtrl( Dlg, dlg_Static, Prompt,
			1, 1,
			0, 0,
			CtrlId, 0, "" );

	X = Svl( Prompt );
	X += ( X / 6 );
	if ( Numeric ) {
		if ( XPos( "/MIN=", MParm_Str, 1 ) ) {
			TStr += "/MIN=" + Parse_Str( "/MIN=", MParm_Str );
		}
		if ( XPos( "/MAX=", MParm_Str, 1 ) ) {
			TStr += "/MAX=" + Parse_Str( "/MAX=", MParm_Str );
		}
		DlgAddCtrl( Dlg, dlg_Integer,"" ,
				dlg_PosOffset + X, dlg_PosOffset + 0,
				Width, 0,
				1000, 0, TStr );
		DlgSetInt( dlg, 1000, return_int );
		Width += 3;
	}
	else {
		TStr = "/HISTORY=" + Parse_Str( "/HISTORY=", MParm_Str ) + "/ML=" +
				Parse_Str( "/ML=", MParm_Str );
		DlgAddCtrl( Dlg, dlg_Text, Return_Str,
				dlg_PosOffset + X, dlg_PosOffset + 0,
				Width, 0,
				1000, 0, TStr );

		if ( Parse_Int( "/DIRB=", MParm_Str ) ) {
			DlgAddCtrl( Dlg, dlg_DirButton, "...",
					dlg_PosOffset + Width + 1, dlg_PosOffset + 0,
					4, 0,
					++CtrlId, 0, "/SID=1000" );
			Width += 5;
		}
	}
  DlgAddCtrl( Dlg, dlg_PushButton, "OK",
      1, dlg_PosOffset | dlg_Units_5QLines,
			dlg_StanBtnWidth, 0,
      id_std_OK, dlgf_DefButton, "/R=1" );

  DlgAddCtrl( Dlg, dlg_PushButton, "Cancel",
      dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
			dlg_StanBtnWidth, 0,
      id_std_Cancel, 0, "/R=0" );
	DlgGetCR( Dlg, id_std_Cancel, X, Y );

	X += dlg_StanBtnWidth + 2;
	Y = Svl( Prompt ) + Width + 3 - dlg_StanBtnWidth;
	if ( Y > X ) {
		X = Y;
	}
  DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
  		X, dlg_PosOffset + 0,
			dlg_StanBtnWidth, 0,
      id_std_Help, 0, "/R=2" );

	Result = DlgExecute( Dlg, 1000, Title, Parse_Str( "/H=", MParm_Str ), "",
			0 );

  if ( Result == 1 ) {
		if ( Numeric ) {
      result = DlgGetInt( Dlg, 1000 );
			Return_Str = "TRUE";
		}
		else {
			Return_Str = DlgGetStr( Dlg, 1000 );
      result = True;
		}
	}
	else {
		if ( Numeric ) {
			Return_Str = "FALSE";
      result = SavReturn_Int;
		}
		else {
      result = False;
		}
	}
	DlgKill( Dlg );
  return_int = result;
}  // QueryBox

macro VERIFY TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name:  VERIFY

Description:  Creats a simple CONFIRM YES/NO box.

Parameters:
							/H=str  help string.
							/T=str  convirm message
							/S=nn   Starting item (0 = Yes, 1 = no );
							/BL=str Box label
							These 2 parameters are not normally neccesary because the box
							will automatically position itself.
							/C=nn column of upper left corner of box
							/L=nn line of upper left corner of box

Returns:      RETURN_INT = True if YES was selected,
													 False if NO was selected or ESC was pressed.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int dlg;
	int si = 110;
	str title = parse_str("/BL=", mparm_str);

	DlgCreate(dlg);

	DlgAddCtrl( dlg, DLG_Icon, "IC_QUESTION", 1, 1, 0,0,100,0, "" );
	DlgAddCtrl( dlg, DLG_Static, parse_str("/T=", mparm_str), 8, 2, 0, 2,101,0, "" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Yes", 8, 4, DLG_StanBtnWidth,0,110,0, "/R=1" );
  DlgAddCtrl( dlg, DLG_PushButton, "&No", 20, 4, DLG_StanBtnWidth,0,111,0, "/R=0" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 35, 4, DLG_StanBtnWidth,0,112,0, "/R=2" );
	if ( parse_int("/S=", mparm_str) == 1 )
	{
		si =  111;
	}
	if ( title == "" )
	{
		title = "Confirm";
	}
	return_int = DlgExecute( dlg, si,title, parse_str("/H=", mparm_str),"", 0 );
	DlgKill(dlg);
}

macro CHECKFILE TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: CHECKFILE

Description:  Checks to see if a file has been saved and prompts the user if
							he wants to save before the window gets erased or deleted.  Will
							save the file, if he so chooses.

Returns:
							Return_Int
								0 - Don't destroy the data.
								1 - O.K. to blast it.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int tl;
	str TStr[80];
	return_int = TRUE;
	if( global_str('@DEL_VERIFY_MACRO') != '') {
		rm( global_str('@DEL_VERIFY_MACRO'));
	}
	if(return_int) {
		if ( File_Changed && ( ( Link_Stat == 0 ) || BriefMode )  ) {
			int dlg;
			str savehstr = FILEMOD_HELPLINK;
			if ( ascii(parse_str("/H=", mparm_str)) )
			{
				savehstr = parse_str("/H=", mparm_str);
			}

			DlgCreate(dlg);

      DlgAddCtrl( dlg, DLG_Icon, "IC_QUESTION", 1, 1, 0,0,100,0, "" );
			DlgAddCtrl( dlg, DLG_Static, "Save changes?", 12, 3, 0,0,101,0, "" );
			DlgAddCtrl( dlg, DLG_Static, file_name, 10, 1, 0,0,102,0, "" );
      DlgAddCtrl( dlg, DLG_PushButton, "&Yes", 2, 5, Dlg_StanBtnWidth,0,110,0, "/R=3" );
      DlgAddCtrl( dlg, DLG_PushButton, "&No", Dlg_PosOffset | (Dlg_StanBtnWidth + 1), Dlg_PosOffset, Dlg_StanBtnWidth,0,111,0, "/R=1" );
      DlgAddCtrl( dlg, DLG_PushButton, "Cancel", Dlg_PosOffset | (Dlg_StanBtnWidth + 1), Dlg_PosOffset, Dlg_StanBtnWidth,0,112,0, "/R=0" );
      DlgAddCtrl( dlg, DLG_PushButton, "&Help", 40, Dlg_PosOffset, Dlg_StanBtnWidth,0,113,0, "/R=2" );

			return_int = DlgExecute( dlg, 110,'File has been modified!', savehstr,"", 0 );
			DlgKill(dlg);
			if(  return_int == 3  ) {
				Error_Level = 0;
				rm("SAVEFILE /NP=1");
				if(  error_level != 0  ) {
					RM('MEERROR');
					return_int = 0;
				}
			}
		}
	}
}


macro MAINHELP TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name:  MAINHELP

Description:  Brings up the main help screen MEW.HLP

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	RM('MEHELP /F=ME/LK=*/CX=' + str(mode == EDIT));
}

#include userin1.s

#include userin2.s