
// Func constants
#define _dbu_Func_Add     0
#define _dbu_Func_Delete  1

#define _BaseErr_DbTools  0
#define _BaseErr_File     3000

#define _Max_WCmds        1000
#define _Max_IfRc         16

// Install dialog control ids
#define id_ins_SrcDir			1000
#define id_ins_InsDir			1001
#define id_ins_PkgLst			1002
#define id_ins_LogChk			1003

#define id_ins_MsgLine		1100
#define id_ins_HlpLine		1101

#define id_ins_BrowseBtn	2010
#define id_ins_RescanBtn	2011
#define id_ins_InstallBtn	2012
#define id_ins_ViewDocBtn	2013
#define id_ins_ViewLogBtn	2014
#define id_ins_DelLogBtn	2015
#define id_ins_EnableBtn	2016
#define id_ins_RmCmdsBtn	2017

#define _ins_BtnWidth			12

global {
	int g_InsLogOn			"@InsLogOn";
	int g_InsLstWin			"!InsLstWin";
	int g_SrcDirChanged	"!SrcDirChanged";
	int g_InsMEWRestart	"!InsMEWRestart";
	int g_AutoStart			"!InsAutoStart";

	str g_InsLstFile		"!InsLstFile";
	str g_SrcDir				"@SrcDir";
	str g_InstallDir		"@InstallDir";
	str g_InsEndMac			"@InsEndMac";
	str g_InsLogFile		"@InsLogFile";
}

struct TWCmds {
	int Entries;
	int Old[ _Max_WCmds ];
	int New[ _Max_WCmds ];
}

struct IfArray {
	int Active[ _Max_IfRc ];
}

prototype UPDATE {

	int EnablePackage( str PackageName, int Enable );
/******************************************************************************
	Function: Enable/disable a registered add-on package

	Entry   : str PackageName	- The registered addon package name
						int Enable			- True to enable, False to disable the package

	Exit    : int
							_NoError					- Success, PackageName was updated
							_ErrorNoFile      - Failure, "MECONFIG.DB" not found
							_ErrorNoDbPage    - Failure, "PACKAGES" not found in "MECONFIG.DB"
							_ErrorNoDbRecord  - Failure, no record matching PackageName found
********************************************************************( ldh )***/

	void Update( str FName );
	void Install( str FName, int AutoStart );
	void Uninstall( );
}
