// toolbox.sh  -  macro functions available from tbmgr.s and bldtboxs.s

prototype tbmgr
{

/******************** Multi-Edit VOID Macro Function ************************

 NAME:         SaveFloatTB()

 DESCRIPTION:  saves floating toolbox placement information
							 in the meconfig^float.db file
							 (used by exit^status)

 PARAMETERS:   None.

 RETURNS:      Nothing.

*****************************07-01-94 12:23pm*******************************/
void  SaveFloatTB();


/******************** Multi-Edit VOID Macro Function ************************

 NAME:         KillAllToolboxes();

 DESCRIPTION:  destroys all toolbox windows, releases wcmds, and
							 and clears the toolbox history list

 PARAMETERS:   None

 RETURNS:      Nothing

*****************************07-01-94 12:23pm*******************************/
void KillAllToolboxes();


/******************** Multi-Edit VOID Macro Function ************************

 NAME:         SaveAllTBinfo();

 DESCRIPTION:  (called by EXIT^STATUS)
							 writes out toolbox placement information to current window
							 for all active toolboxes in the current session

 PARAMETERS:   None

 RETURNS:      Nothing

*****************************07-01-94 12:24pm*******************************/
void SaveAllTBinfo();    // for use only by EXIT^STATUS


/******************** Multi-Edit VOID Macro Function ************************

 NAME:         RestoreTBpos

 DESCRIPTION:  (used by EXIT^RESTORE)

 PARAMETERS:   int hTBHandle      handle to toolbox to restore last position
							 str positionRec    contains window placement information

 RETURNS:      Nothing

*****************************07-01-94 12:24pm*******************************/
void RestoreTBpos(int hTBHandle, str positionRec);


/****************** Multi-Edit INTEGER Macro Function ***********************

 NAME:         BuildToolBox

 DESCRIPTION:  Builds/Rebuilds an individual toolbox

 PARAMETERS:   str tbtobuild        toolset name of toolbox to create
							 int ignoreBS         forced creation of toolbox,
																		ignoring BOXLIST.DB BOXSHOWN field setting

 RETURNS:      Nothing

*****************************07-01-94 12:24pm*******************************/
int BuildToolBox(str tbtobuild, int ignoreBS, int iconsize, int orientation);


/****************** Multi-Edit INTEGER Macro Function ***********************

 NAME:         PutDbRecord

 DESCRIPTION:  Finds and updates the specified record in a .DB file.

 PARAMETERS:   (see parameter list below)

 RETURNS:      window handle of the created toolbox

*****************************07-01-94 12:24pm*******************************/
int PutDbRecord(str fname,            // db filename
								str dpt,              // data page title
								str dbf,              // field name
								str fv,               // field value
								int rec_num,          // record # to return (overrides fv
																			//   and dbf).  Example:  If /#=3 then the
																			//   3rd record will be returned.
																			// 1 = case sensitive search
								int flags,            // name of global variable that is holding
								str global_name,      // the record that is to be written
																			// (set by GetDbRecord)
																			// if TRUE, then remove DB file from memory
								int remove_file,      //    after operation
																			// Misc parameters
								str misc);            //   /AGLO=n  name  of global integer
																			//            to store total #  of
																			//            records
																			//   /LD=str  Delimit to use, default is
																			//            ASCII 127
																			//   /UP=1    save file (update)


/****************** Multi-Edit INTEGER Macro Function ***********************

 NAME:         AddDbRecord

 DESCRIPTION:  Adds the specified record in a .DB file.

 PARAMETERS:   (see parameter list below)

 RETURNS:      1 if successful add,
							 0 if not found or data file error

*****************************07-01-94 12:24pm*******************************/
int AddDbRecord(
								str fname,            // db filename
								str dpt,              // data page title
								str dbf,              // field name [IGNORED]
								str fv,               // field value [IGNORED]
								int rec_num,          // record # to add AFTER (overrides fv
																			//   and dbf).  Example:  If /#=3 then the
																			//   new record will be #4.
																			// this may lead to duplicate records
																			// if == 0, then add to end of record list
																			// and check for duplicates
								int flags,            // 1 = case sensitive search
								str recordToAdd,      // variable that is holding
																			// the record that is to be added
								str global_name,      // variable that will hold the original record
																			// if the record already exists
								int remove_file,      // if TRUE, then remove DB file from memory
																			//    after operation
								str misc);            // Misc parameters
																			//   /AGLO=n  name  of global integer
																			//            to store total #  of
																			//            records
																			//   /LD=str  Delimit to use, default is
																			//            ASCII 127
																			//   /UP=1    Save file (update)
}