// $Header: /MEWIN/SRC/STDDLGS.SH 4     3/05/96 12:17p Todd $

#define dlg_Units_3QLines  dlg_Units | ( dlg_Units_QLine * 3 )
#define dlg_Units_5QLines  dlg_Units | ( dlg_Units_QLine * 5 )
#define dlg_Units_7QLines  dlg_Units | ( dlg_Units_QLine * 7 )

#define dlg_Units_3HLines  dlg_Units | ( dlg_Units_HLine * 3 )
#define dlg_Units_5HLines  dlg_Units | ( dlg_Units_HLine * 5 )
#define dlg_Units_7HLines  dlg_Units | ( dlg_Units_HLine * 7 )

#define _OD_FlagsMask         0xfff00000
#define _OD_UseIcon           0x00100000
#define _OD_Cancel            0x00200000

// VerifyDlg ShowBtns constants
#define _vdsb_CancelBtn 0x01
#define _vdsb_AllBtns   0x02

#define id_std_Cancel   2000
#define id_std_Ok				2001
#define id_std_Help			2002
#define id_std_Close    2003
#define id_std_Yes      2004
#define id_std_No       2005
#define id_std_YesAll   2006
#define id_std_NoAll    2007

prototype StdDlgs {
	int ViewFileDlg( str FName, str Title, str HelpCtx, str Bitmap, int Width,
				int Height );
/******************************************************************************
  Function: View contents of a file or window in a list dialog.

  Entry   : str Title   - The title of the dialog.  "" will use default
													"Viewing File_Name". ( /T= )

 						str FName   - The file name to load a display.  "" will cause the
													current window to be displayed. ( /F= )

						str HelpCtx	- The help context string.  "" for no help button.
													( /HC= )

						str Bitmap  - The name of a bitmap to be shown.  "" for no bitmap.
													( /BM= )

						int Width   - The width of the list box.  0 will use default 95.
													( /W= )

						int Height  - The height of the list box.  0 will use default 15.
													( /H= )

  Exit    : int
							id_std_Close

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  int VerifyDlg( str Msg, str Title, str HelpCtx, int DefBtnNo, int ShowBtns );
/******************************************************************************
  Function: Show a Yes/No Cancel dialog

  Entry   : str Msg					- The message to be shown.  Use "\\n" in message to
 															start a new line.  Can have multiple lines. (/M=)

						str Title 			- The title that will appear on the title bar (/T=)
						str HelpCtx			- The help context string (/HC=)
						int DefBtnNo		- The number of the button that will be the default
															button. 0-Yes, 1-No, 2-Cancel(when shown) (/B=)

            int ShowBtns    - Additional buttons to show.
              _vdsb_CancelBtn - Cancel button
              _vdsb_AllBtns   - Yes/No to all buttons

  Exit    : int             - The button pushed.
							id_std_Yes
							id_std_No
							id_std_Cancel
              id_std_YesAll
              id_std_NoAll

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

  int MsgDlg( str Msg, str Title, str HelpCtx, int Beeps );
  /******************************************************************************
    Function: Show a message dialog.

    Entry   : str Msg         - The message to be shown.  Use "\\n" in message to
                                start a new line.  Can have multiple lines. (/M=)

              str Title       - The title that will appear on the title bar (/T=)
              str HelpCtx     - The help context string (/HC=)
              int Beeps       - Number of beeps                             (/B=)

    Exit    : int             - The button pushed.
                id_std_OK
  ********************************************************************( ldh )***/

int OutputDlgCreate( str title,         // Dialog title
                     str message,       // Initial message
                     str bitmap,        // If specified, display a bitmap or icon
                     int width,         // Width of message field (characters)
                     int height,        // Height of message field (lines)
                     int flags          // Flags
                      );
  /********************************************************************
                                                      Multi-Edit Macro
                                                          3/5/96 9:14AM

    Function: Creates an output dialog that stays up, allowing
              messages to be sent to it.

              Flags supports all DLG_ flags (DLG_MODELESS is assumed), in
              addition to _OD_UseIcon (tells the dialog that bitmap is
              actually the name of an icon) and _OD_Cancel which tells
              the dialog to build a Cancel button.

    Exit    : Returns the handle to the dialog window, OR 0 if the
              function fails.
  ********************************************************************/

  int OutputDlgMessage( int dlg,
                        str message
                  );
  /********************************************************************
                                                      Multi-Edit Macro
                                                          3/5/96 9:29AM

    Function: Changes the message string of an output dialog.
    Exit    : Returns TRUE if the dialog is running, FALSE if the dialog
              has been canceled or destroyed.
  ********************************************************************/

  int OutputDlgKill( int dlg );
  /********************************************************************
                                                      Multi-Edit Macro
                                                          3/5/96 9:35AM

    Function: Destroys the output dialog.
    Exit    : Returns TRUE if sucessful
  ********************************************************************/

  int OutputDlgCheck( int dlg );
  /********************************************************************
                                                      Multi-Edit Macro
                                                        3/5/96 10:18AM

    Function: Returns TRUE if dialog is running, FALSE if the dialog
              was canceled.
  ********************************************************************/
}