// $Header: /MEWIN/SRC/STDDLGS.S 7     3/05/96 12:17p Todd $

macro_file STDDLGS;
#include WINDOWS.SH
#include MEW.SH
#include DIALOG.SH
#include DBTOOLS.SH
#include STDDLGS.SH


int ViewFileDlg(
      str FName   = Parse_Str( "/F=", MParm_Str ),
      str Title   = Parse_Str( "/T=", MParm_Str ),
      str HelpCtx = Parse_Str( "/HC=", MParm_Str ),
      str Bitmap  = Parse_Str( "/BM=", MParm_Str ),
      int Width   = Parse_Int( "/W=", MParm_Str ),
      int Height  = Parse_Int( "/H=", MParm_Str )
) trans2
/******************************************************************************
															 Multi-Edit Macro
															 18-Mar-95  11:43

  Function: View contents of a file or window in a list dialog.

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/
{
	int OrgWinId = Window_Id;
	int TRefresh = Refresh;
  int Dlg;
  int TWindow_Attr;
	int LstWinId = 0;

	Refresh = False;
	Error_Level = 0;
	Return_Int = 0;
	if ( Svl( FName ) != 0 ) {
		Switch_Window( Window_Count );
		Create_Window;
		Load_File( FName );
		LstWinId = Window_Id;
	}
	else {
		FName = File_Name;
	}
	if ( Error_Level == 0 ) {
  	TWindow_Attr = Window_Attr;
  	Window_Attr &= 0xFFFE;
		if ( Width == 0 ) {
			Width = 95;
		}
		if ( Height == 0 ) {
			Height = 15;
		}
  	DlgCreate( Dlg );
  	DlgAddCtrl( Dlg, dlg_ViewTextBox, "",
      	1, dlg_Units | dlg_Units_QLine, Width, Height,
      	1000, 0, "/WIN=" + Str( Cur_Window ) );

  	DlgAddCtrl( Dlg, dlg_PushButton, "Close",
      	1, dlg_PosOffset | dlg_Units | ( dlg_Units_QLine * ( ( 4 * Height ) + 1 ) ),
      	dlg_StanBtnWidth, 0,
      	id_std_Close, dlgf_DefButton, "" );

		if ( Svl( HelpCtx ) != 0 ) {
  		DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
      		Width - dlg_StanBtnWidth, dlg_PosOffset + 0,
      		dlg_StanBtnWidth, 0,
      		id_std_Help, 0, "/R=2" );
		}
		if ( Svl( BitMap ) != 0 ) {
  		DlgAddCtrl( Dlg, dlg_BitmapStatic, Bitmap,
      		Width / 2, dlg_PosOffset + 0, 0, 0,
      		100, 0, "" );
		}
		if ( Svl( Title ) == 0 ) {
			Title = "Viewing " + Caps( Truncate_Path( FName ) );
		}
  	Return_Int = DlgExecute( Dlg, 1000, Title, HelpCtx, "", 0 );
  	DlgKill( Dlg );
  	Window_Attr = TWindow_Attr;
	}
	if ( Switch_Win_Id( LstWinId ) ) {
		Delete_Window;
	}
	Switch_Win_Id( OrgWinId );
	Refresh = TRefresh;
  return ( Return_Int );

}  // ViewFileDlg

int VerifyDlg(
				str Msg[ Max_Line_Length ] = Parse_Str( "/M=", MParm_Str ),
      str Title                  = Parse_Str( "/T=", MParm_Str ),
      str HelpCtx                = Parse_Str( "/HC=", MParm_Str ),
      int DefBtnNo               = Parse_Int( "/B=", MParm_Str ),
      int ShowBtns               = Parse_Int( "/C=", MParm_Str )
) trans2
/******************************************************************************
                               Multi-Edit Macro
                               15-Sep-94  17:57

  Function: Show a Yes/No Cancel dialog

  Entry   : str Msg					- The message to be shown.  Use "\\n" in message to
 															start a new line.  Can have multiple lines. (/M=)

						str Title 			- The title that will appear on the title bar (/T=)
						str HelpCtx			- The help context string (/HC=)
						int DefBtnNo		- The number of the button that will be the default
															button. 0-Yes, 1-No, 2-Cancel(when shown) (/B=)

            int ShowBtns    - Additional buttons to show.
              _vdsb_CancelBtn - Cancel button
              _vdsb_AllBtns   - Yes/No to all buttons

  Exit    : int             - The button pushed.
							id_std_Yes
							id_std_No
							id_std_Cancel
              id_std_YesAll
              id_std_NoAll

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/
{
  int Dlg;
  int CtrlId      = 100;
  int Width       = 46;
  int Jx          = 0;
	int Jy;
  int MsgX        = 9;
  int MsgY        = dlg_Units | dlg_Units_HLine;
  int MsgLines    = 0;
  int ShowAllBtns = ShowBtns & _vdsb_AllBtns;
  int ShowCanBtn  = ShowBtns & _vdsb_CancelBtn;

	str TStr;

  DlgCreate( Dlg );
  DlgAddCtrl( Dlg, dlg_Icon, "IC_QUESTION",
      1, dlg_Units | dlg_Units_HLine,
			0, 0,
      CtrlId, 0, "" );

	Jy = 1;
	while ( Jx = XPos( "\\n", Msg, Jy ) ) {
		TStr = Copy( Msg, Jy, Jx - Jy );
		++MsgLines;
  	DlgAddCtrl( Dlg, dlg_Static, TStr,
      	MsgX, MsgY,
				0, 0,
      	CtrlId, 0 , "" );

		Jy = Jx + 2;
    MsgY += dlg_Units_QLine * 3;
		Jx = Svl( TStr );
    if ( Jx > ( Width - 4 ) ) {
			Width = Jx + ( Jx / 4 );
		}
	}
	TStr = Copy( Msg, Jy, Svl( Msg ) );
	++MsgLines;
  DlgAddCtrl( Dlg, dlg_Static, TStr,
      MsgX, MsgY,
			0, 0,
      CtrlId, 0 , "" );

	Jx = Svl( TStr );
  if ( Jx > ( Width - 4 ) ) {
		Width = Jx + ( Jx / 4 );
	}
	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			MsgX - 1, dlg_Units | dlg_Units_HLine,
      Width, MsgLines - ( MsgLines / 4 ),
			++CtrlId, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Yes",
      8, 2 + MsgLines - ( MsgLines / 4 ),
			dlg_stanBtnWidth, 0,
      id_std_Yes, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&No",
      dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
			dlg_StanBtnWidth, 0,
      id_std_No, 0, "" );

  if ( ShowCanBtn & 1 ) {
  	DlgAddCtrl( Dlg, dlg_PushButton, "Cancel",
      	dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
				dlg_StanBtnWidth, 0,
      	id_std_Cancel, 0, "/R=0" );
	}
	if ( Svl( HelpCtx ) != 0 ) {
  	DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
      	8 + Width - dlg_StanBtnWidth, dlg_PosOffset + 0,
				dlg_StanBtnWidth, 0,
      	id_std_Help, 0, "/R=2" );
	}
  if ( ShowAllBtns ) {
    DlgAddCtrl( Dlg, dlg_PushButton, "Yes to &All",
        8, dlg_PosOffset | dlg_Units + ( 3 * dlg_Units_HLine ),
        dlg_stanBtnWidth + 1, 0,
        id_std_YesAll, 0, "" );

    DlgAddCtrl( Dlg, dlg_PushButton, "No to A&ll",
        dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
        dlg_stanBtnWidth + 1, 0,
        id_std_NoAll, 0, "" );
  }
	switch ( DefBtnNo ) {
		case 1 :
		case id_std_No :
			DefBtnNo = id_std_No;
			break;

		case 2 :
		case id_std_Cancel :
      if ( ShowCanBtn & 1 ) {
				DefBtnNo = id_std_Cancel;
				break;
			}

    case 3 :
    case id_std_YesAll :
      if ( ShowAllBtns) {
        DefBtnNo = id_std_YesAll;
      }
      break;

    case 4 :
    case id_std_NoAll :
      if ( ShowAllBtns) {
        DefBtnNo = id_std_NoAll;
      }
      break;

		default:
			DefBtnNo = id_std_Yes;
	}
	if ( Svl( Title ) == 0 ) {
		Title = "Confirm";
	}
  Return_Int = DlgExecute( Dlg, DefBtnNo, Title, HelpCtx, "", 0 );
  DlgKill( Dlg );

  return ( Return_Int );

}  // VerifyDlg

int MsgDlg(
      str Msg[ Max_Line_Length ] = Parse_Str( "/M=", MParm_Str ),
      str Title                  = Parse_Str( "/T=", MParm_Str ),
      str HelpCtx                = Parse_Str( "/HC=", MParm_Str ),
      int BeepCnt                = Parse_Int( "/B=", MParm_Str )
) trans2
/******************************************************************************
                               Multi-Edit Macro
                               13-Feb-96  14:44

  Function: Show a message dialog.

  Entry   : str Msg					- The message to be shown.  Use "\\n" in message to
 															start a new line.  Can have multiple lines. (/M=)

						str Title 			- The title that will appear on the title bar (/T=)
            str HelpCtx     - The help context string                     (/HC=)
            int Beeps       - Number of beeps                             (/B=)

  Exit    : int             - The button pushed.
              id_std_OK

               Copyright (C) 1996 by American Cybernectic, Inc.
********************************************************************( ldh )***/
{
  int CtrlId      = 100;
  int Width       = 26;
  int MsgX        = 9;
  int MsgY        = dlg_Units | dlg_Units_HLine;
  int MsgLines    = 0;
  int Dlg;
  int Jx;
	int Jy;

	str TStr;
  str Icon = "IC_EXCLAMATION";

  if ( BeepCnt ) {
    Rm( "MEERROR^Beeps /C=" + Str( BeepCnt ) );
  }
  DlgCreate( Dlg );
  DlgAddCtrl( Dlg, dlg_Icon, Icon,
      1, dlg_Units | dlg_Units_HLine,
			0, 0,
      CtrlId, 0, "" );

	Jy = 1;
	while ( Jx = XPos( "\\n", Msg, Jy ) ) {
		TStr = Copy( Msg, Jy, Jx - Jy );
		++MsgLines;
  	DlgAddCtrl( Dlg, dlg_Static, TStr,
      	MsgX, MsgY,
				0, 0,
      	CtrlId, 0 , "" );

		Jy = Jx + 2;
//    MsgY = dlg_PosOffset + 1;
    MsgY += dlg_Units_QLine * 3;
		Jx = Svl( TStr );
    if ( Jx > ( Width - 4 ) ) {
      Width = Jx + ( Jx / 4 );
		}
	}
	TStr = Copy( Msg, Jy, Svl( Msg ) );
	++MsgLines;
  DlgAddCtrl( Dlg, dlg_Static, TStr,
      MsgX, MsgY,
			0, 0,
      CtrlId, 0 , "" );

	Jx = Svl( TStr );
  if ( Jx > ( Width - 4 ) ) {
    Width = Jx + ( Jx / 4 );
	}
	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			MsgX - 1, dlg_Units | dlg_Units_HLine,
//      Width, MsgLines,
      Width, MsgLines - ( MsgLines / 4 ),
			++CtrlId, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "OK",
//      8, 2 + MsgLines - ( MsgLines / 4 ),
      ( Width / 2 ), 2 + MsgLines - ( MsgLines / 4 ),
			dlg_stanBtnWidth, 0,
      id_std_OK, 0, "" );

	if ( Svl( HelpCtx ) != 0 ) {
  	DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
      	8 + Width - dlg_StanBtnWidth, dlg_PosOffset + 0,
				dlg_StanBtnWidth, 0,
      	id_std_Help, 0, "/R=2" );
	}
  Return_Int = DlgExecute( Dlg, id_std_OK, Title, HelpCtx, "", 0 );
  DlgKill( Dlg );

  return ( Return_Int );

}  // MsgDlg




#define _OD_STAT_Running   1
#define _OD_STAT_Canceled  2
#define _OD_STAT_Destroyed 0
#define _OD_Global         "!OuputDlg_"

int OutputDlgCreate( str title,         // Dialog title
                     str message[1024], // Initial message
                     str bitmap,        // If specified, display a bitmap or icon
                     int width,         // Width of message field (characters)
                     int height,        // Height of message field (lines)
                     int flags          // Flags
                    ) trans2
/********************************************************************
                                                     Multi-Edit Macro
                                                        3/5/96 9:14AM

  Function: Creates an output dialog that stays up, allowing
            messages to be sent to it.

            Flags supports all DLG_ flags (DLG_MODELESS is assumed), in
            addition to _OD_UseIcon (tells the dialog that bitmap is
            actually the name of an icon) and _OD_Cancel which tells
            the dialog to build a Cancel button.

  Exit    : Returns the handle to the dialog window, OR 0 if the
            function fails.


********************************************************************/
{

  int Result = FALSE;

  int dlg,result;
  int bitmapoffset = 1;

  DlgCreate(dlg);

  if(bitmap != "")
  {
    if(flags & _OD_UseIcon)
    {
      DlgAddCtrl( dlg, DLG_Icon, bitmap, 1, DLG_Units | 10, 0,0,-1,0, "" );
    }
    else
    {
      DlgAddCtrl( dlg, Dlg_BitmapStatic, bitmap, DLG_Units | 10,1,0,0,-1,0,"" );
    }
    bitmapoffset = 11;
  }
  DlgAddCtrl( dlg, DLG_BlackFrame, "", bitmapoffset, DLG_Units | 7, width + 2, height,-1,0, "" );
  DlgAddCtrl( dlg, DLG_Static, message, bitmapoffset + 1, DLG_Units | 8, width, height,1000,0, "" );

  if(flags & _OD_Cancel)
  {
    DlgAddCtrl( dlg, DLG_PushButton, "Cancel", ((bitmapoffset + width) / 2) - (DLG_StanBtnWidth / 2), height + 2, DLG_StanBtnWidth,0,111,0, "" );
  }

  DlgExecute( dlg, 0,title, "","/HOOK=OutputDlgMsgProc", DLG_Modeless );
  Set_Global_Int( _OD_Global + Str(dlg), _OD_Stat_Running );
  result = dlg;

  return ( result );

}  // OutputDlgCreate

int OutputDlgMsgProc( int &retval, int window, int message, int wparam, int lparam, str parms ) no_break
{
	switch ( Message ) {
    case WM_COMMAND :
      if(wparam == 111)
      {
        Set_Global_Int( _OD_Global + parse_str("/DLG=",parms), _OD_Stat_Canceled );
        return(1);
      }
      break;

    case WM_SYSCOMMAND :
           switch ( wparam )
           {
              case SC_CLOSE :
                Set_Global_Int( _OD_Global + parse_str("/DLG=",parms), _OD_Stat_Canceled );
                return(1);
                break;
           }
           break;

    case WM_DESTROY :
      Set_Global_Int( _OD_Global + parse_str("/DLG=",parms), _OD_Stat_Destroyed );
      break;
  }

	return ( DlgMessageProc( RetVal, Window, Message, WParam, LParam, Parms ) );
}



int OutputDlgMessage( int dlg,
                  str message[1024]
                 ) trans2
/********************************************************************
                                                     Multi-Edit Macro
                                                        3/5/96 9:29AM

  Function: Changes the message string of an output dialog.
  Exit    : Returns TRUE if the dialog is running, FALSE if the dialog
            has been canceled or destroyed.

********************************************************************/
{

  int Result = TRUE;

  if(Global_Int( _OD_Global + Str(dlg)))
  {
    SendDlgItemMessageStr( DlgGetWHandle(dlg), 1000, WM_SETTEXT, 0, message );
  }
  ProcessMsgQueue( 10 );
  return ( Global_Int( _OD_Global + Str(dlg)) == _OD_STAT_Running );
}  // OutputDlgMessage



int OutputDlgCheck( int dlg )
/********************************************************************
                                                     Multi-Edit Macro
                                                       3/5/96 10:18AM

  Function: Returns TRUE if dialog is running, FALSE if the dialog
            was canceled.
********************************************************************/
{

  int Result = FALSE;
  ProcessMsgQueue( 10 );

  if(Global_Int( _OD_Global + Str(dlg)) == _OD_STAT_Running)
    Result = TRUE;

  return ( Result );

}  // OutputDlgCheck


int OutputDlgKill( int dlg ) trans2
/********************************************************************
                                                     Multi-Edit Macro
                                                        3/5/96 9:35AM

  Function: Destroys the output dialog.
  Exit    : Returns TRUE if sucessful


********************************************************************/
{

  int Result = False;

  if(Global_Int( _OD_Global + Str(dlg)))
  {
    result = DestroyWindow( DlgGetWHandle(dlg) );
  }
  return ( Result );

}  // OutputDlgKill

void stest()
{
  int dlg = OutputDlgCreate( "TEST", "Start", "BT_SR_101", 40,1, _OD_Cancel );
  int jx = 0;
  while(jx++ < 1000)
  {
    if(! OutputDlgMessage( dlg, "This is step " + str(jx)))
    {
      break;
    }
  }
  OutputDlgKill(dlg);
}
