//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)19 SAP.S, 21-Nov-95,22:54:18, LDH"

macro_file SAP;
/******************************************************************************
														 Multi-Edit Macro File
															 15-Aug-93  02:08

	This macro is the specific interface code for the VCS package Sourcerer's
	Apprentice from Borland (Not supported by Borland anymore).

								Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

#include DIALOG.SH
#include WINEXEC.SH
#include IDEXE.SH
#include METOOLS.SH
#include DBTOOLS.SH
#include DB.SH
#include VCS.SH

#ifdef   _DEBUG_
	#include DBUG.SH                      // Dbug macros
	#include SPRINTF.SH
#endif

#ifdef  _BETA_
  #define _SAP_VER    "7.01(0.10b)"
#else
  #define _SAP_VER    "7.01(0.10b)"
#endif

prototype Sap {
	int  SapExec( str CmdLine, int Show_Win, int Chg_Dir );
	str  SapXlate( str Path, str Fname, str Lfile );
	str  SapExt( str FName );
	int  SapChkLib( str Path, str FName, int Pm );
	str  SapGetFname( str LibFile );
	int  SapChkLock( );
	str  SapLookup( str FName, str Field1, str Field2 );
	str  SapCfgFile( str FName, str Param );
	void SapParseErr( );
	str  SapGetUser( );
}

global {
	str g_SapCfg				"!SapCfg";				// Contains the command/setup options
	str g_SapLUT				"!SapLUT";				// Contains the LOOKUP data record
}

macro Sap Trans {
/******************************************************************************
															 Multi-Edit Macro
															 15-Sep-94  21:25

	Name    : Sap

	Function: Checks that the GET executable is found and initilizes SAP
						support.

	Syntax  : Rm( "Sap /I" );

	Entry   : /I              - Initialize the system if checks pass.

	Exit    : Return_Int
							False         - SAP support not installed and checks failed.
							True          - SAP support installed and checks passed.

						gstr !vcsVerStr   - "SAP " + macro version number.
						gstr !vcsRevStr   - macro revision number.
						gstr !vcsDoLogin  - False.

	Globals : str !vcsVerStr  - Returns the string "SAP " + macro version no.
						str !vcsRevStr  - Returns the macro revision number.
						str !vcsDoLogin - Set True to enable changing username and passwd.
						str !vcsCfg     - Contains the current vcs configuration options.

	Macros  : int VcsChkVer
						mac PathSearch
						mac ChngParm

								 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

//+++keyword+++ "@(#)%v %n, %f, %w"
	str Rev_Id = "@(#)19 SAP.S, 21-Nov-95,22:54:18, LDH";
	str Cmd = Copy( _GET_CMDL, 1, XPos( " ", _GET_CMDL, 1 ) - 1 );
  str BDir = _BDIR_CMDL;

	// Check for get command EXE file
  if ( Svl( BDir ) ) {
    BDir += ";";
  }
  Return_Str = ExecSearchPath( Cmd, BDir + "<%PATH>" );
	Return_Int = ( Return_Str != "" );
	if ( Return_Int ) {
		if ( VcsChkVer( _SAP_VER ) ) {
			if ( XPos( "/I", MParm_Str, 1 ) ) {  // Initialize?
				vcsDoLogin = False;             // Disable change user ID menu item
				Return_Str = "/MLC=";           // Force single line comment
				Rm( "ChngParm /G=!vcsCfg/P=0" );
			}
		}
		else {
			Error_Level = 9011;               // Set version error
		}
	}
	else {
		Error_Level = 9010;                 // Set no EXE found error
	}
	vcsVerStr = "SAP " + _SAP_VER;
	vcsRevStr = Rev_Id;

}  // Sap

macro SapView Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapView

	Function: The SAP specific view macro to view the changes to the current
						work file compared to the latest revision in the archive.

	Syntax  : Rm( "SapView" );

	Entry   : gstr !vcsFName  - Filename of file to compare
						gint !vcsLibFnd - Set True if archive found.

	Exit    : Return_Int
							True          - No Error
							False         - ( Error_Level == 0 ) Cancelled
															( Error_Level != 0 ) Error

	Globals : str !vcsFName   - The work file name.
						int !vcsLibFnd  - The archive found status (True = found).
						str !vcsDlgMsg  - The dialog message when calling VcsGetLib.
						str !vcsMsg     - The status line message when exec is run.
						str !sapCfg     - The SAP specific command/setup options.
						str !vcsName    - The vcs temp file name.


	Macros  : int  VcsGetLib
						int  SapExec
						mac  CDiff
						void VcsViewWinDlg

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	str FName = Truncate_Path( vcsFName );
	str TFName = TempFileName( FName );

	int Frn = False;

	if ( !vcsLibFnd ) {
		vcsDlgMsg = "(SAP) VIEW Archive File Path.";
		if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
			vcsMsg = "SAP archive file for \"" + FName + "\" not found.";
			Error_Level = 3002;
			Return_Int = False;
		}
	}
	if ( vcsLibFnd ) {
		Working;
		if ( Switch_File( vcsFName ) ) {
			if ( File_Changed ) {
				Rm( "SaveFile /NP=1" );
			}
		}
    if ( File_Exists( TFName ) ) {
      Set_File_Attr( _VCS3_TMP, 0 );
      Del_File( _VCS3_TMP );
      Rename_File( TFName, _VCS3_TMP );
      Frn = True;
    }
		vcsMsg = "Viewing changes made to \"" + FName + "\"...";
		vcsDlgMsg = "(SAP) VIEW Command Line.";
		if ( Return_Int = SapExec( _VIEW_CMDL, _DISP_WIN, _DO_CD ) ) {
      if ( Global_Int( "!UseCDiff" ) ) {
        Rm( "CDiff /F=" + TFName + "/D=" + str( !_CDIF ) );
      }
      else {
        Rm( "Fc /F=" + TFName + "/S=" + Str( _CDIF * 6 ) );
      }
      if ( Return_Int == 1 ) {
        vcsMsg = "Files the same.";
      }
      else {
        vcsMsg = "CDIFF complete.";
      }
      Set_File_Attr( TFName, 0 );
      Del_File( TFName );
      Return_Int = True;
		}
		if ( Frn ) {
			Rename_File( _VCS3_TMP, TFName );
		}
	}
}  // SapView

macro SapList Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapList

	Function:

	Syntax  :

	Entry   :

	Exit    : Return_Int
							True          - No Error
							False         - ( Error_Level == 0 ) Cancelled
															( Error_Level != 0 ) Error

	Globals :

	Macros  :

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	str FName = Truncate_Path( vcsFName );

	if ( !vcsLibFnd ) {
		vcsDlgMsg = "(SAP) LIST Archive File Path.";
		if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
			vcsMsg = "SAP archive file for \"" + FName + "\" not found.";
			Error_Level = 3002;
			Return_Int = False;
		}
	}
	if ( vcsLibFnd ) {
		vcsMsg = "Listing versions of \"" + Truncate_Path( vcsFName ) + "\"...";
		vcsDlgMsg = "(SAP) LIST Command Line.";
		if ( Return_Int = SapExec( _LIST_CMDL, _DISP_WIN, False ) ) {  // No vcs errors
			if ( Switch_File( vcsName ) ) {
				Return_Int = False;
				Error_Level = 0;
				Load_File( vcsName );
				if ( !Error_Level ) {
					VcsViewWinDlg( "(SAP) Versions of " + Truncate_Path( vcsFName ),
							100, 18, "BT_VCS_109", hc_vcs_List );
					vcsMsg = "SAP LIST command complete.";
					Return_Int = True;
				}
			}
		}
	}
}  // SapList

macro SapLock Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapLock

	Function:

	Syntax  :

	Entry   :

	Exit    : Return_Int
							True          - No Error
							False         - ( Error_Level == 0 ) Cancelled
															( Error_Level != 0 ) Error

	Globals :

	Macros  :

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	str FName = Truncate_Path( vcsFName );

	int Frn = False;

	if ( !vcsLibFnd ) {
		vcsDlgMsg = "(SAP) LOCK Archive File Path.";
		if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
			vcsMsg = "SAP archive file for \"" + FName + "\" not found.";
			Error_Level = 3002;
			Return_Int = False;
		}
	}
	if ( vcsLibFnd ) {
		if ( Return_Int = !SapChkLock( ) ) {
			if ( File_Exists( vcsFName ) ) {
				Set_File_Attr( _VCS3_TMP, 0 );
				Del_File( _VCS3_TMP );
				Rename_File( vcsFName, _VCS3_TMP );
				Frn = True;
			}
			vcsMsg = "Locking \"" + vcsFName + "\"...";
			vcsDlgMsg = "(SAP) LOCK Command Line.";
			Return_Int = SapExec( _LOCK_CMDL, _DISP_WIN, _DO_CD );
			if ( Frn ) {
				if ( Return_Int ) {
					Rename_File( _VCS3_TMP, vcsFName );
				}
				else {
					int Sel = Error_Level;

					Set_File_Attr( _VCS3_TMP, 0 );
					Del_File( _VCS3_TMP );
					Error_Level = Sel;
				}
			}
		}
	}
}  // SapLock

macro SapGet Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapGet

	Function:

	Syntax  :

	Entry   :

	Exit    : Return_Int
							True          - No Error
							False         - ( Error_Level == 0 ) Cancelled
															( Error_Level != 0 ) Error

	Globals :

	Macros  :

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	str Vcs_Cmd[ 128 ];
	str FName = Truncate_Path( vcsFName );
	str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );

	int Fw = 0;
	int Frn = False;
	int Sel;

	if ( !vcsLibFnd ) {
		vcsDlgMsg = "(SAP) " + Cmd + " Archive File Path.";
		if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
			vcsMsg = "SAP archive file for \"" + FName + "\" not found.";
			Error_Level = 3002;
			Return_Int = False;
		}
	}
	if ( vcsLibFnd ) {
		Return_Int = True;
		if ( Cmd == "GET" ) {
			Return_Int = !SapChkLock( );
			Vcs_Cmd = _GET_CMDL;
		}
		else {
			Vcs_Cmd = _BROWSE_CMDL;
		}
		if ( Return_Int ) {
			if ( Caps( File_Name ) == Caps( vcsFName ) ) {
				Frn = True;
			}
			else if ( Switch_File( vcsFName ) ) {
				Frn = True;
			}
			if ( Frn ) {
				if ( !Read_Only || vcsDF || ( Truncate_Path( File_Name ) != FName ) ) {
					Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
							" Already loaded, OVERWRITE? /BL= ARE YOU SURE? " );
				}
				if ( Return_Int ) {
					Fw = Window_Id;
					VcsPushPos( );
					Erase_Window;
				}
			}
			else if ( File_Exists( vcsFName ) ) {
				Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
						" Already exists, OVERWRITE? /BL= ARE YOU SURE? " );
			}
		}
		if ( Return_Int ) {
			Frn = False;
			if ( File_Exists( vcsFName ) ) {
				Set_File_Attr( _VCS3_TMP, 0 );
				Del_File( _VCS3_TMP );
				Rename_File( vcsFName, _VCS3_TMP );
				Frn = True;
			}
			vcsMsg = "Retrieving \"" + vcsFName + "\"...";
			vcsDlgMsg = "(SAP) " + Cmd + " Command Line.";
			if ( Return_Int = SapExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
				if ( Frn ) {
					Sel = Error_Level;
					Set_File_Attr( _VCS3_TMP, 0 );
					Del_File( _VCS3_TMP );
					Error_Level = Sel;
				}
				if ( ( Cmd == "GET" ) && ( File_Attr( vcsFName ) & 0x01 ) ) {
					Return_Int = False;
					Error_Level += 9001;
				}
			}
			if ( !Return_Int  ) {             // error, restore file
				if ( Frn ) {
					Rename_File( _VCS3_TMP, vcsFName );
				}
				if ( Switch_Win_Id( Fw ) ) {
					Sel = Error_Level;
					Error_Level = 0;
					Load_File( vcsFName );
					if ( !Error_Level ) {
						Rm( "ExtSetup" );
					}
					VcsPopPos( True );
					Error_Level = Sel;
					Return_Int = False;
				}
			}
		}
	}
}  // SapGet

macro SapPut Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapPut

	Function: The SAP specific CREATE/PUT/UNLOCK commands.

	Syntax  :

	Entry   :

	Exit    : Return_Int
							True          - No Error
							False         - ( Error_Level == 0 ) Cancelled
															( Error_Level != 0 ) Error
	Globals :

	Macros  :

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	str Vcs_Cmd[ 128 ];
	str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );
	str FName[ 12 ] = Truncate_Path( vcsFName );

	int Sel;
	int Fw = 0;
	int Ow = 0;
	int Get_Cmt = False;

	Return_Int = True;
	if ( vcsChkMod != "V" ) {
		Return_Int = !SapChkLock( );
	}
	if ( Return_Int ) {
		if ( Caps( File_Name ) == Caps( vcsFName ) ) {
			Fw = Window_Id;
		}
		else if ( Switch_File( vcsFName ) ) {
			Fw = Window_Id;
		}
		if ( Fw ) {
			VcsPushPos( );
		}
		if ( vcsChkMod == "V" ) {
			if ( Window_Id == Fw ) {
				Erase_Window;
			}
			if ( File_Exists( vcsFName ) ) {
				Set_File_Attr( vcsFName, 0 );
				Del_File( vcsFName );
			}
		}
		else {
			if ( !vcsLibFnd ) {
				vcsDlgMsg = "(SAP) " + Cmd + " Archive File Path.";
				vcsLibFnd = VcsGetLib( vcsFName );
				Return_Int = !Error_Level;
				Error_Level = 0;
			}
			if ( Return_Int ) {
				if ( Cmd == "PUT" ) {
					Get_Cmt = True;
					if ( !vcsLibFnd ) {
						Cmd = "CREATE";
					}
					if ( !Fw ) {
						Ow = Window_Id;
						Switch_Window( Window_Count );
						Create_Window;
						Load_File( vcsFName );
						Fw = Window_Id;
					}
				}
				switch ( Cmd ) {
					case "CREATE":
						Vcs_Cmd = _CREATE_CMDL;
						vcsMsg = "Creating \"" + Get_Path( vcsAFile ) + FName + "\" ...";
						vcsDlgMsg = "(SAP) Describe \"" + FName + "\".";
						break;

					case "PUT":
						Vcs_Cmd = _PUT_CMDL;
						vcsMsg = "Storing \"" + FName + "\" in \"" + Get_Path( vcsAFile ) +
								FName + "\"...";
						vcsDlgMsg = "(SAP) Describe changes to \"" + FName + "\".";
						break;

					case "UNLOCK":
						Vcs_Cmd = _UNLOCK_CMDL;
						vcsMsg = "Unlocking \"" + Get_Path( vcsAFile ) + FName + "\"...";
						break;
				}
				Return_Int = True;
				if ( Get_Cmt ) {
					Return_Int = VcsGetCmt( True, False );
				}
				if ( Return_Int ) {
					if ( Fw ) {
						Erase_Window;
					}
					vcsDlgMsg = "(SAP) " + Cmd + " Command Line.";
					if ( Return_Int = SapExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
						if ( File_Exists( vcsFName ) ) {
							if ( _DEL_SRC ) {
								Sel = Error_Level;
								Set_File_Attr( vcsFName, 0 );
								Del_File( vcsFName );
								Error_Level = Sel;
							}
						}
						if ( Ow ) {
							Delete_Window;
							Switch_Win_Id( Ow );
						}
					}
					else {                        // error, reload file
						if ( Switch_Win_Id( Fw ) ) {
							Sel = Error_Level;
							Error_Level = 0;
							Load_File( vcsFName );
							if ( Error_Level == 0 ) {
								if ( Get_Cmt && vcsChgFlg ) {
									VcsPutCmt( False );
								}
								Rm( "ExtSetup" );
							}
							Get_Cmt = True;
							if ( Ow ) {
								Delete_Window;
								Switch_Win_Id( Ow );
								Get_Cmt = False;
							}
							VcsPopPos( Get_Cmt );
							Error_Level = Sel;
							Return_Int = False;
						}
					}
				}
			}
		}
	}
}  // SapPut

int SapExec( str CmdLine, int Show_Win, int Chg_Dir ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Sep-94  21:44

	Name    : SapExec

	Function: Execute the SAP command in cmdline.

	Syntax  : Pass = SapExec( CmdLine, Show_Win, Chg_Dir );

	Entry   : str CmdLine
						int Show_Win
						int Chg_Dir
						gstr !vcsFName
						gstr !vcsAFile
						gint !vcsSNCL

	Exit    : int
							True            - No Error.
							False           - ( Error_Level == 0 ) Cancelled
																( Error_Level = Error number ) Error
								gstr !vcsMsg  - Error message  ( Only when Error_Level != 0 )

						gstr !vcsDlgMsg   - Cleared.

	Globals : str !vcsFName   - Contains the work file name.
						str !vcsAFile   - Contains the archive file name.
						int !vcsSNCL    - Flag to not show cmdline dialog ( True ).
						str !vcsCfg     - Contains the main vcs config options.
						str !vcsMsg     - Contains the status line message.
						str !vcsName    - Contains the vcs temp file name.
						str !vcsDlgMsg  - Contains the show cmdline dialog message.

	Macros  : str SapXlate
						int VcsEditStrDlg
						int ExecProg

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	int Result = True;
	int Flags = _ep_flags_NoBypass | _ep_flags_NoSavFile;

  str Cmd = Get_Path( Copy( CmdLine, 1, XPos( " ", CmdLine, 1 ) - 1 ) );
  str BDir = _BDIR_CMDL;

  if ( Svl( Cmd ) == 0 ) {
    if ( Svl( BDir ) ) {
      if ( Copy( BDir, Svl( BDir ), 1 ) != "\\" ) {
        BDir += "\\";
      }
      CmdLine = BDir + CmdLine;
    }
  }
	CmdLine = SapXlate( CmdLine, vcsFName, vcsAFile );
	Error_Level = 0;
	if ( vcsSNCL ) {
		if ( Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ) {
			Result = False;
		}
	}
	else if ( _SHOW_CMD ) {
		Result = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
	}
	if ( Result ) {
		Set_File_Attr( vcsName, 0 );
		Del_File( vcsName );                // Erase tmp capture file
		Result = False;
		Working;
		Make_Message( vcsMsg );
		Error_Level = ExecProg( CmdLine, vcsPrjDir, vcsName, vcsName, Flags );
		switch ( Error_Level ) {

			case _Exec_Abort :
				Error_Level = 0;
				break;

			case _Exec_Error :
				Error_Level = ExecErrorCode;
				break;

			case _Exec_Success :
				Error_Level = 0;
				switch ( ExecId ) {

					case _Exe_Id_Windows :
						SapParseErr( );

					case _Exe_Id_Dos :
					case _Exe_Id_Os2 :
					case _Exe_Id_Nt :
						Error_Level = ExecReturnCode;
						if ( Error_Level == 0 ) {
							Result = True;
							break;
						}

					default :
						Error_Level += 9000;
				}
		}
	}
	vcsDlgMsg = "";
	return ( Result );

}  // SapExec

str SapXlate(
				str Path = Return_Str,
				str FName = Parse_Str( "/F=", MParm_Str ),
				str LPath = Parse_Str( "/P=", MParm_Str )
		) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapXlate

	Function: Place holder for adding code to implement any SAP specific
						tranlation metacommands. Calls VcsXlate to finish the translations.

	Syntax  : Path = SapXlate( Path, FName, LPath );

	Entry   : str Path            - The string to be translated.
						str FName           - The work file name.
						str LPath           - The SAP archive path.

	Exit    : str ( Return_Str )  - The expanded command line.

	Globals : none

	Macros  : str VcsXlate

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	int Jx;

	while ( Jx = XPos( "<SAPCMT>", Caps( Path ), 1 ) ) {
		Path = Str_Del( Path, Jx, 8 );
		if ( !( Global_Int( "!VCSCHG_FLG" ) ) ) {
			if ( Global_Str( "@VCS_MESSAGE!" ) != "" ) {
				Path = Str_Ins( "-c\"" + Global_Str( "@VCS_MESSAGE!" ) + "\"", Path, Jx );
			}
		}
	}
	return ( VcsXlate( Path, FName, LPath ) );

}  // SapXlate

str SapExt( str FName = Parse_Str( "/F=", MParm_Str ) ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapExt

	Function: Takes a filename extension and converts it to the equivalent SAP
						extension.

	Syntax  : Ext = SapExt( str FName );

	Entry   : str FName     - Filename for which the extension is translated.

	Exit    : str           - The vcs file extension based upon LIBEXT.

	Globals : none.

	Macros  : none.

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	str New_Ext[ 3 ] = _LIB_EXT;
	str Ext[ 3 ] = Get_Extension( FName );

	if ( New_Ext != "" ) {
		if ( XPos( "%", New_Ext, 1 ) ) {
			if ( Copy( Ext, 3, 1 ) == "" ) {
				Ext = Str_Ins( "%", Str_Del( Ext, 3, 1 ), 1 );
				if ( Copy( Ext, 3, 1 ) == '' ) {
					Ext = Str_Ins( "%", Str_Del( Ext, 3, 1 ), 1 );
					if ( Copy( Ext, 3, 1 ) == "" ) {
						Ext = Str_Ins( "%", Str_Del( Ext, 3, 1 ), 1 );
					}
				}
			}
			else {
				Ext = Str_Ins( "&", Str_Del( Ext, 1, 1 ), 1 );
			}
		}
	}
	return ( Ext );

}  // SapExt

int SapChkLib(
				str Path = Parse_Str( "/P=", MParm_Str ),
				str FName = Parse_Str( "/F=", MParm_Str ),
				int Pm = Parse_Int( "/M=", MParm_Str )
		) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapChkLib

	Function: Search "Path" for the SAP archive for "FName" based upon "Pm".

	Syntax  : LibFnd = SapChkLib( Path, FName, Pm );

	Entry   : gstr !vcsID - The name of the currently selected vcs package.
						str  Path   - Contains the search path.
						str  FName  - The filename for which to find archive.
						int  Pm     - Path Mode.
							-2        - Check for and return archive file only.
							-1        - Check for and return archive file,
													iff no file return 1st lib path.
							 0        - Return full archive path.
							+#        - Return # directory from archive path.

	Exit    : int ( gint !vcsRInt )
							#                 - File was found in # path.
								gstr !vcsAFile  - The found archive filename or path.
							0                 - File NOT found.
								gstr !vcsAFile  - The archive path based upon pm.
																	( Not set if Pm == -2 ).

	Globals : str !vcsID    - The name of the currently selected vcs package.
						int !vcsRInt  - The return integer.
						str !vcsAFile - The found archive filename or path.

	Macros  : int VcsGetPath

								Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

	vcsRInt = False;
	if ( ( Path == _LIB_PATH ) && ( _DO_CD == 2 ) ) {
		Path = "<LOOKUP>";
	}
	return ( vcsRInt = VcsGetPath( Path, FName, SapExt( FName ), Pm ) );

}  // SapChkLib

str SapGetFName( str LibFile = Parse_Str( "/P=", MParm_Str ) ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapGetFName

	Function: Returns the work file name extracted from the archive "LibFile" or
						"" when archive doesn't exist.

	Syntax  : FName = SapGetFName( LibFile );

	Entry   : str LibFile           - archive file name

	Exit    : str ( gstr !vcsRStr ) - The workfile_name or "".

	Globals : str !vcsRStr          - The return string.

	Macros  : none

								Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

	int Hn;
	int Jx;

	str Buf[ 128 ];

	vcsRStr = "";
	if ( !S_Open_File( LibFile, 0x00, Hn ) ) {
		if ( !S_Read_Bytes( Buf, Hn, 128 ) ) {
			if ( Jx = XPos( "\f", Buf, 1 ) ) {
				vcsRStr = Caps( Copy( Buf, ++Jx, XPos( "\x00", Buf, Jx ) - Jx ) );
			}
		}
		S_Close_File( Hn );
	}
	return ( vcsRStr );

}  // SapGetFName

int SapChkLock( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapChkLock

	Function: Check to see if a archive file is locked.

						Note: The SAP support doesn't support this at this time, thus it
									always returns False (not locked).

	Syntax  : Locked = SapChkLock( );

	Entry   : none.

	Exit    : int
							True      - Archive file locked.
							False     - Archive file not locked.

	Globals : none.

	Macros  : none.

								Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

	return ( False );

}  // SapChkLock

macro SapDir Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 29-Sep-94  01:33

	Name    : SapDir

	Function: Displays directory listing of SAP archive files.  Allows user to
						select a file to be retrieved for modification, viewing only, or
						listing the version history.

	Syntax  : Rm( "SapDir /C=Cmd/RC" );

	Entry   : /C=str        - Command to execute ( ie GET, BROWSE or LIST ).
						/RC           - Repeat command until <ESC>.

	Exit    : none.

	Globals : none.

	Macros  : mac VcsFile

								Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

	str User = SapGetUser( );
	VcsGetPath( _LIB_PATH, FExpand( "*.*" ), "", 1 );
	VcsFileDlg( "(SAP) Archive Files", vcsAFile + "*.*", User );

}  // SapDir

macro SapIActive Trans {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapIActive

	Function: Runs the "menu command line" that is contained in "!sapCfg" global
						variable.

	Syntax  : Rm( "SapIActive" );

	Entry   : none.

	Exit    : none.

	Globals : str !sapCfg - Contains the commands/setup options for SAP.

	Macros  : int WinExecAndWait

								Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

	str CmdLine = _MENU_CMDL;
  str Cmd = Get_Path( Copy( CmdLine, 1, XPos( " ", CmdLine, 1 ) - 1 ) );
  str BDir = _BDIR_CMDL;

  if ( Svl( Cmd ) == 0 ) {
    if ( Svl( BDir ) ) {
      if ( Copy( BDir, Svl( BDir ), 1 ) != "\\" ) {
        BDir += "\\";
      }
      CmdLine = BDir + CmdLine;
    }
  }
	if ( _SHOW_CMD ) {
		vcsDlgMsg = "(SAP) Run Interactive Command Line";
		Return_Int = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
	}
	if ( Return_Int ) {
//		WinExecAndWait( CmdLine, "", _EP_Flags_DontWait, "", "" );
		ExecProg( CmdLine, "", "", "", _EP_Flags_DontWait | _EP_Flags_SkipExec );
	}
}  // SapIActive

macro SapLogin Trans {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapLogin

	Function: Check if a user is logged in ( Not supported in SAP ).

	Syntax  : Rm( "SapLogin" );

	Entry   : none.

	Exit    : none.

	Globals : none.

	Macros  : none.

								 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

}  // SapLogin

macro SapAdminPrj Trans {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapAdminPrj

	Function: Create, edit and delete entries in the user's administer project
						database for SAP.

	Syntax  : Rm( "SapAdminPrj" );

	Entry   : none.

	Exit    : none.

	Globals : str !sapLUT - The contents of the current db record.

	Macros  : mac SapChkAdmin

								 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

	g_SapLUT = "";                          // clear global lookup variable
	Db( _VCS_DB, "SAP.VAD", "MEWHDRS.DB", "VCSVAD.HDR",
			"(SAP) Associate Directories",
			"(SAP) Associate Directories Setup",
			"!VAD", 0,
			"/BMP=BT_VCS_102/NDF=1/PRE=!VAD/H=" + hc_vcs_Admin +
					"/DIRB=1/CP=New File Directory:/MOVE=1/MACRO=SapChkAdmin" );

}  // SapAdminPrj

str SapLookup(
				str FName = Parse_str( "/F=", MParm_Str ),
				str Field1 = Parse_Str( "/F1=", MParm_Str ),
				str Field2 = Parse_Str( "/F2=", MParm_Str )
		) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapLookup

	Function: Returns the string in "Field2" of the SAP administer project
						database when the directory of "FName" matches a string in
						"Field1".

	Syntax  : Str_Val = SapLookup( FName, Field1, Field2 );

	Entry   : str FName  - The filename to extract the directory name from.
						str Field1 - The field name of the field to match the directory to.
						str Field2 - The field name fo the field to return the string from.

	Exit    : str ( gstr !vcsRStr )
							""          - Empty string if no match or Field2 empty.
							[Field2]    - Contents of Field2 when match found.

						gstr !sapLUT  - Contains the found record.

	Globals : str !vcsRStr  - The return string.
						str !sapLUT   - The contents of the matched db record.

	Macros  : int DbGetRecord

								 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

	int Result = True;

	vcsRStr = "";
	FName = Caps( Get_Path( FName ) );
	if ( FName != Parse_Str( "\x7F" + Field1 + "=", g_SapLUT ) ) {

		int Cnt = 0;
		int OrgWin = Window_Id;
		int TRefresh = Refresh;
		int Flags = _dbf_NoDelWin | _dbf_NoSwitchWin;

		str ADField = "\x7F" + "AD=";
		str DbName = _VCS_DB;
		str TStr;
		str SFName = FName;

		Result = False;
		Refresh = False;
		g_SapLUT = "";
		while ( DbGetRecord( DbName, "SAP.VAD", Field1, FName, Cnt, Flags, "" ) ==
				_NoError ) {
			if ( g_SapLUT != "" ) {
				TStr =  Parse_Str( ADField, g_SapLUT ) + ";" +
						Parse_Str( ADField, FName );
				Return_Str = ADField;
				Rm( "ChngParm /G=!sapLUT/P=" + TStr );
			}
			else {
				g_SapLUT = FName;
				if ( Field1 == "AD" ) {
					break;
				}
			}
			Flags =  _dbf_NoDelWin | _dbf_NoSwitchWin | _sf_Position;
			FName = SFName;
			DbName = "";
			Result = True;
		}
		Switch_Win_Id( OrgWin );
		Refresh = TRefresh;
	}
	if ( Result ) {
		vcsRStr = Parse_Str( "\x7F" + Field2 + "=", g_SapLUT );
		if ( Field1 == "AD" ) {
			g_SapLUT = "";
		}
	}
	return ( vcsRStr );

}  // SapLookup

str SapCfgFile(
				str FName = Parse_Str( "/F=", MParm_Str ),
				str Param = Parse_Str( "/P=", MParm_Str )
		) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 20-Dec-94  00:50

	Name    : SapCfgFile

	Function: Parse and return the value for Param from the VC.CFG file.
						(Note: this function currently uses the <LOOKUP> function until the
						code is actually written and tested to parse the VC.CFG file)

	Syntax  : Str_Val = SapCfgFile( FName, Param );

	Entry   : str FName   - The filename to extract the directory name from
						str Param   - The parameter to parse for the return string

	Exit    : str ( gstr !vcsRStr )
							""          - Empty string if no match
							[Param]     - Contents of Param from config file when match found

	Globals : str !vcsRStr  - The return string
						str !sapCfg

	Macros  : str SapLookUp
						str SapGetUser

								 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

	vcsRStr = "";
	switch ( Param ) {
		case "ARCDIR" :
			vcsRStr = SapLookup( FName, "FD", "AD" );
			break;

		case "ARCEXT" :
			vcsRStr = _LIB_EXT;
			break;

		case "USER" :
			vcsRStr = SapGetUser( );
			break;

		case "WORKDIR" :
			vcsRStr = SapLookup( FName, "FD", "WD" );
			break;
	}
	return ( vcsRStr );

}  // SapCfgFile

macro SapChkAdmin Trans {
/******************************************************************************
															 Multi-Edit Macro
															 15-Aug-94  23:05

	Name    : SapChkAdmin

	Function: Called by the AdminPrj dialog to capitialize, check and update all
						directories to end with a \ when saving the data in the dialog.

	Syntax  : Called only by the DB macro when in the AdminPrj dialog.

	Entry   : Values passed by the DB macro.

	Exit    : updated data.

	Globals : none.

	Macros  : none.

								 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

	if ( Parse_Int( "/P=", MParm_Str ) != 0 ) {

		str GStr = Parse_Str( "/GLO=", MParm_Str );
		str TStr = Caps( Global_Str( GStr ) );

		int Len = Svl( TStr );
		int Jx = 1;

		while ( Jx < Len ) {
			if ( ( Jx = XPos( "\x7F", TStr, ++Jx ) ) == 0 ) {
				Jx = Len + 1;
			}
			if ( Pos( Copy( TStr, Jx - 2, 1 ), "=" ) == 0 ) {
				if ( Pos( Copy( TStr, Jx - 1, 1 ), ";>\\" ) == 0 ) {
					TStr = Str_Ins( "\\", TStr, Jx );
					Len = Svl( TStr );
				}
			}
		}
		Jx = 1;
		while ( Jx = XPos( ";", TStr, Jx ) ) {
			if ( Copy( TStr, Jx - 1, 1 ) != "\\" ) {
				TStr = Str_Ins( "\\", TStr, Jx );
			}
			++Jx;
		}
		Set_Global_Str( GStr, TStr );
	}
}  // SapChkAdmin

void SapParseErr( ) Trans {
/******************************************************************************
															 Multi-Edit Macro
															 15-Sep-94  21:44

	Name    : SapParseErr

	Function: Used to parse the captured file from a Windows executable.
						Note: Currently no Windows programs for SAP to support.

	Syntax  : SapParseErr( );

	Entry   : None.

	Exit    : gint ExecReturnCode - The error code for the executed windows program

	Globals : int ExecReturnCode

	Macros  : None.

									Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/

	ExecReturnCode = 100;                 // Return error no supported yet

}  // SapParseErr

str SapGetUser( ) {
/******************************************************************************
															 Multi-Edit Macro
															 03-Oct-94  15:04

	Name    :
	Function:
	Syntax  :
	Entry   :
	Exit    :
	Globals :
	Macros  :

									Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/

	str Result = Get_Environment( "USER" );

	if ( Result == "" ) {
		Result = _VCS_USERID;
	}
	return ( Result );

}  // SapGetUser
