// $Header: /MeShare/Src/PASCAL.S 20    4/17/96 16:45 Dan $

macro_file PASCAL;
/******************************************************************************
														MULTI-EDIT MACRO FILE

Name: PASCAL

Description:	Language support for Pascal style languages

PASMTCH - Construct matching
PAS_IND - Smart indent
PASTEMP - Template editing (old style)
PASSETX - Sets up the template expansion data global string.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*************************************************************************** **/

#include LANGUAGE.SH
#include TEMPLATE.SH
#include DBTOOLS.SH
#include DIALOG.SH

#ifdef _Debug_
  #include MSGLOG.SH
#endif

#define _pas_prop_IndentStyle		"/IS="
#define _pas_prop_ProcIndent		"/PI="
#define _pas_prop_Options				"/O="

#define _pas_opt_ParenHi				0x0001
#define _pas_opt_UndAfterEnd		0x0002
#define _pas_opt_MatchHi				0x0004

#define id_StyleFrame						500
#define id_StyleTxt1						501
#define id_StyleTxt2						502
#define id_StyleTxt3						503
#define id_StyleTxt4						504

#define id_IndentStyle					1002
#define id_ProcIndent						1003

#define id_ParenHiCB						1100
#define id_UndAfterEndCB				1101
#define id_MatchHi							1102

// Comment character structure
structure tPasProperties {
	str Language;
	int IndStyle;
	int ProcInd;
	int Options;
}

void _PasShowIndStyle(
			int Dlg 	 = Parse_Int( "/DATAHANDLE=", MParm_Str ),
			int Change = Parse_Int( "/CH=", MParm_Str ),
			int Focus	 = Parse_Int( "/FOCUS=", MParm_Str )
)
/******************************************************************************
															 Multi-Edit Macro
															 20-Oct-95  15:47

	Function: Show the a sample of the indent selected indent style.  Only to be
						called by the PasSetProperties macro. ( Internal Function )

	Entry   : int Dlg			- The data handle for the Properties dialog
						int Change	- Set true when called when entry changed
						int Focus		- Set true when called and the field just got the focus

	Exit    : None

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	if ( Dlg && ( Focus || Change ) ) {

		str TStr1[ 18 ];
		str TStr2[ 18 ];
		str TStr3[ 18 ];
		str TStr4[ 18 ];

		int Style;

    DlgSetFields( Dlg );
		if ( Parse_Int( "/PI=", MParm_Str ) ) {
			Style = DlgGetInt( Dlg, id_ProcIndent );
			switch ( Style ) {
				case 1 :
					TStr1 = "procedure Name;";
					TStr2 = "begin";
					TStr3 = "  Test;";
					TStr4 = "end;";
					break;

				case 2 :
					TStr1 = "procedure Name;";
					TStr2 = "  begin";
					TStr3 = "    Inc(I);";
					TStr4 = "  end;";
					break;

				case 3 :
					TStr1 = "procedure Name;";
					TStr2 = "  begin";
					TStr3 = "  Inc(I);";
					TStr4 = "  end;";
					break;
			}
		}
		else {
			Style = DlgGetInt( Dlg, id_IndentStyle );
			switch ( Style ) {
				case 1 :
					TStr1 = "if I=1 then begin";
					TStr2 = "  Inc(I);";
					TStr3 = "end;";
					TStr4 = "";
					break;

				case 2 :
					TStr1 = "if I=1 then";
					TStr2 = "begin";
					TStr3 = "  Inc(I);";
					TStr4 = "end;";
					break;

				case 3 :
					TStr1 = "if I=1 then";
					TStr2 = "  begin";
					TStr3 = "  Inc(I);";
					TStr4 = "  end;";
					break;

				case 4 :
					TStr1 = "if I=1 then";
					TStr2 = "  begin";
					TStr3 = "    Inc(I);";
					TStr4 = "  end;";
					break;
			}
		}
  	DlgSetStr( Dlg, id_StyleTxt1, TStr1 );
  	DlgUpdateCtrl( Dlg, id_StyleTxt1, 0 );

  	DlgSetStr( Dlg, id_StyleTxt2, TStr2 );
  	DlgUpdateCtrl( Dlg, id_StyleTxt2, 0 );

  	DlgSetStr( Dlg, id_StyleTxt3, TStr3 );
  	DlgUpdateCtrl( Dlg, id_StyleTxt3, 0 );

  	DlgSetStr( Dlg, id_StyleTxt4, TStr4 );
  	DlgUpdateCtrl( Dlg, id_StyleTxt4, 0 );
	}
	Return_Int = 0;

}  // _PasShowIndStyle

void PasSetProperties(
			str GStr 		= Parse_Str( "/GSTR=", MParm_Str ),
			str ParmStr = MParm_Str
)
/******************************************************************************
															 Multi-Edit Macro
															 20-Oct-95  14:03

	Function: Set Pascal and Delhpi specific properties.  Should only be run by
						the LangSetProperties macro.

	Entry   : str GStr			- Name of global string containing properties (/GSTR=)
						str ParmStr		- Misc parameters
							/L=str				- Language name to show on title bar

	Exit    : None

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	str Properties = Global_Str( GStr );
	str Language	 = Parse_Str( "/L=", ParmStr );

	int IndStyle	 = Parse_Int( _pas_prop_IndentStyle, Properties );
	int ProcIndent = Parse_Int( _pas_prop_ProcIndent, Properties );
	int Options	 	 = Parse_Int( _pas_prop_Options, Properties );
	int Dlg;
	int X;
	int Y;

	if ( Svl( Language ) == 0 ) {
		Language = "Pascal";
	}
	DlgCreate( Dlg );

	DlgAddCtrl( Dlg, dlg_Static, "&Indent Style:",
			1, 1,
			0, 0,
			-1, 0, "" );
	DlgAddCtrl( Dlg, dlg_Choice, "0()1()2()3()",
			dlg_PosOffset + 13, dlg_PosOffset + 0,
			9, 0,
			id_IndentStyle, 0,
			"/CHANGEMAC=_PasShowIndStyle //CH=1/FOCUSMAC=_PasShowIndStyle" );
	DlgSetInt( Dlg, id_IndentStyle, IndStyle + 1 );

	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			dlg_PosOffset + 12, dlg_PosOffset + 0,
			20, 3,
			id_StyleFrame, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "&Func Indent:",
			1, dlg_PosOffset + 1,
			0, 0,
			-1, 0, "" );
	DlgAddCtrl( Dlg, dlg_Choice, "0()1()2()",
			dlg_PosOffset + 13, dlg_PosOffset + 0,
			9, 0,
			id_ProcIndent, 0,
			"/CHANGEMAC=_PasShowIndStyle //CH=1//PI=1" +
			"/FOCUSMAC=_PasShowIndStyle //PI=1" );
	DlgSetInt( Dlg, id_ProcIndent, ProcIndent + 1 );

	DlgAddCtrl( Dlg, dlg_GroupBox, "Options",
			1, dlg_PosOffset + 2,
			45, 4,
			-1, 0, "" );

	DlgAddCtrl( Dlg, dlg_CheckBox, "Highlight matches",
			dlg_PosOffset + 1, dlg_PosOffset + 1,
			0, 0,
			id_MatchHi, 0, "" );
	DlgSetInt( Dlg, id_MatchHi, ( Options & _pas_opt_MatchHi ) != 0 );

	DlgAddCtrl( Dlg, dlg_CheckBox, "Auto-&paren closure highlight",
			dlg_PosOffset, dlg_PosOffset + 1,
			0, 0,
			id_ParenHiCB, 0, "" );

	DlgSetInt( Dlg, id_ParenHiCB, ( Options & _pas_opt_ParenHi ) != 0 );


	DlgAddCtrl( Dlg, dlg_CheckBox, "&Undent After End",
			dlg_PosOffset + 0, dlg_PosOffset + 1,
			0, 0,
			id_UndAfterEndCB, 0, "" );
	DlgSetInt( Dlg, id_UndAfterEndCB, ( Options & _pas_opt_UndAfterEnd ) != 0 );

  DlgAddCtrl( Dlg, dlg_PushButton, "OK",
			1, dlg_PosOffset | dlg_Units | dlg_Units | ( dlg_Units_HLine * 3 ),
			dlg_StanBtnWidth, 0,
			2001, dlgf_DefButton, "/R=1" );

  DlgAddCtrl( Dlg, dlg_PushButton, "Cancel",
			dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
			dlg_StanBtnWidth, 0,
			2000, 0, "/R=0" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
			dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
			dlg_StanBtnWidth, 0,
			2002, 0, "/R=2" );

	DlgGetXY( Dlg, id_StyleFrame, X, Y );
	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_Units | X + 1, dlg_Units | Y,
			18, 0,
			id_StyleTxt1, 0, "" );
	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units | 8,
			18, 0,
			id_StyleTxt2, 0, "" );
	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units | 8,
			18, 0,
			id_StyleTxt3, 0, "" );
	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units | 8,
			18, 0,
			id_StyleTxt4, 0, "" );

	int Result = DlgExecute( Dlg, id_IndentStyle, Language + " Properties Setup",
			"", "/INITMAC=_PasShowIndStyle", 0 );
	Return_Int = 0;
	if ( Result ) {
		Options = 0;
		if ( DlgGetInt( Dlg, id_ParenHiCB ) != 0 ) {
			Options |= _pas_opt_ParenHi;
		}
		if ( DlgGetInt( Dlg, id_UndAfterEndCB ) != 0 ) {
			Options |= _pas_opt_UndAfterEnd;
		}
		if ( DlgGetInt( Dlg, id_MatchHi ) != 0 ) {
			Options |= _pas_opt_MatchHi;
		}
		IndStyle = DlgGetInt( Dlg, id_IndentStyle ) - 1;
		ProcIndent = DlgGetInt( Dlg, id_ProcIndent ) - 1;
		Properties = _pas_prop_IndentStyle + Str( IndStyle ) +
				_pas_prop_ProcIndent + Str( ProcIndent ) +
				_pas_prop_Options + Str( Options );
		Set_Global_Str( GStr, Properties );
	}
	DlgKill( Dlg );

}  // PasSetProperties

int PasGetProperties( struct tPasProperties rPasP )
/******************************************************************************
															 Multi-Edit Macro
															 20-Oct-95  12:36

	Function: Get the specific language properties for the current file.
	Entry   : struct rPasP		- A structure to fill with the properties.
	Exit    : int
							True		- Properties fill from Db
							False		- Properties set to internal defaults

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	int Result = False;

	str Language;
	str Properties;
	str LanguageRec[ Max_Line_Length ];

	if ( LangGetRecord( Language, LanguageRec ) == _NoError ) {
		Properties = Parse_Str( "\x7F" + _db_lang_Properties + "=", LanguageRec );
	}
	rPasP.Language = Language;
	if ( Svl( Properties ) != 0 ) {
		rPasP.IndStyle = Parse_Int( _pas_prop_IndentStyle, Properties );
		rPasP.ProcInd	 = Parse_Int( _pas_prop_ProcIndent, Properties );
		rPasP.Options  = Parse_Int( _pas_prop_Options, Properties );
		Result = True;
	}
	else {
		rPasP.IndStyle = 0;
		rPasP.ProcInd	 = 0;
		rPasP.Options  = _pas_opt_ParenHi | _pas_opt_UndAfterEnd;
	}
	return ( Result );

}  // PasGetProperties

void PasIndentTmp(
			str Set 		= Parse_Str( "/S=", MParm_Str ),
			str Name 		= Parse_Str( "/N=", MParm_Str ),
			int ProcInd = Parse_Int( "/PI=", MParm_Str )
)
/******************************************************************************
															 Multi-Edit Macro
															 25-Oct-95  12:45

	Function: Insert the indent style template Name from the template set Set.
	Entry   : str Set     - The template set
						str Name		- The template name
						int ProcInd	- Set true to specify procedure indent style else
													use normal indent style
	Exit    : None

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	struct tPasProperties rPasP;

	int Style;

	PasGetProperties( rPasP );
	if ( ProcInd ) {
		Style = rPasP.ProcInd;
	}
	else {
		Style = rPasP.IndStyle;
	}
	TmpExpand( Set, Name + Str( Style ) );

}  // PasIndentTmp

void Pas_Ind( )
/*******************************************************************************
																MULTI-EDIT MACRO

Name: PAS_IND

Description:  This macro will perform a smart indent when the <ENTER> key is
	pressed.  This macro is called by the macro CR.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
{
	int	SavRefresh = Refresh;
	int OrgCol = C_Col;
	int CurCol;
	int Sig_Char_Found;
	int Ind_Count;
	int IndentFlag;
	int OutdentFlag;
	int	Jx;

	str C_Str;          /* Word to check for indent */

	char Found_Char;

	struct tPasProperties rPasP;

	if ( Insert_Mode == False ) {
		Cr;
		First_Word;
		goto Mac_Exit;
	}
	Refresh = False;
	Messages = False;
	Mark_Pos;
	Down;
	Up;
	Left;
	// Check to see if we are inside a comment
	// Don''t go back farther than 5 lines in order to improve speed
	if ( Find_Text( "{|}|(\\(\\*)|(\\*\\))", 5, _RegExp | _Backward )  ) {
		if ( Jx = XPos( Cur_Char, "{(", 1 ) ) {
			Right;
			if ( Jx == 2 ) {
				Right;
			}
			Set_Indent_Level;
			Goto_Mark;
			Cr;
			goto Mac_Exit;
		}
	}
	Goto_Mark;

	PasGetProperties( rPasP );
	switch ( rPasP.IndStyle ) {
		case 0 :
			IndentFlag  = True;
			OutdentFlag = True;
			break;

		case 1 :
			IndentFlag  = False;
			OutdentFlag = False;
			break;

		case 2 :
			IndentFlag  = True;
			OutdentFlag = True;
			break;
	}
	Mark_Pos;
	call Skip_Pas_Noise1;
	Found_Char = Cur_Char;
	Goto_Mark;

	First_Word;              		// Go to the first word on the line
	CurCol = C_Col;          		// Store this position

	if ( CurCol > OrgCol ) {   	// If this position is greater than the original
		CurCol = OrgCol;       		//   then store the original
		Goto_Col( CurCol );      	//   and go there
	}
	if ( !At_Eol ) {
		Set_Indent_Level;
	}

	CurCol = C_Col;                        // Store the current position
	// Get the current word, removing any extra space
	C_Str = " " + Remove_Space( Caps( Get_Word( "; (,{" ) ) ) + " ";
//	if ( C_Str == " BEGIN " ) {
	if ( XPos( C_Str, " BEGIN ASM ", 1 ) ) {
		Mark_Pos;
		Goto_Col( CurCol );
		Left;
		call Skip_Pas_Noise1;
		Found_Char = Cur_Char;
		Goto_Mark;
	}
	Goto_Col( OrgCol );                   // Put cursor on original position
	Cr;
	// If the word is in this list, and the original position was not on the
	// first word then indent
//	if ( ( CurCol != OrgCol ) && ( Pos( C_Str, " PROCEDURE FUNCTION BEGIN " ) !=
	if ( ( CurCol != OrgCol ) && ( Pos( C_Str, " PROCEDURE FUNCTION BEGIN ASM " ) !=
			0 ) ) {
//		if ( ( C_Str == " BEGIN " ) ) {
		if ( ( XPos( C_Str, " BEGIN ASM ", 1 ) ) ) {
			if ( Found_Char != ";" ) {
				if ( rPasP.IndStyle != 2 ) {
					Indent;
				}
			}
			else if ( rPasP.ProcInd != 2 ) {
				Indent;
			}
		}
		else if ( rPasP.ProcInd ) {
			Indent;
		}
	}
	else if ( ( Found_Char != ";" ) && ( CurCol != OrgCol ) &&
			( Pos( C_Str,
//			" VAR TYPE CONST PROCEDURE FUNCTION BEGIN IF WHILE REPEAT WITH FOR ELSE "
			" VAR TYPE CONST PROCEDURE FUNCTION BEGIN IF WHILE REPEAT WITH FOR ELSE ASM"
			) != 0) )
	{
		if ( IndentFlag ) {
			Indent;
		}
	}
	else if ( rPasP.Options & _pas_opt_UndAfterEnd ) {
//	else if ( OutdentFlag == True ) {
		if ( C_Str == " END " ) {
			Undent;
		}
	}
	goto Mac_Exit;


Skip_Pas_Noise1:
	// Here we look for the nearest preceding nonblank character.  If it is a
	// closing comment then we find the nearest opening comment.

	if ( Find_Text( "[^ \t\xFF]", 1, _RegExp | _Backward ) ) {
		if ( Cur_Char == ")" ) {
			Left;
			if ( Cur_Char == "*" ) {
				Jx = Find_Text( "(*", 0, _Backward );
				Left;
				goto Skip_Pas_Noise1;
			}
			Right;
			Sig_Char_Found = True;
			goto Exit_Skip_Pas;
		}
		else {
			if ( Cur_Char == "}" ) {
				Jx = Find_Text( "{", 0, _Backward );
				Left;
				goto Skip_Pas_Noise1;
			}
		}
		Sig_Char_Found = True;
		goto Exit_Skip_Pas;
	}

	/* If we failed to find a nonblank character on the current line, and the
	 * cursor is on line 1, we failed to find a significant character;
	 * otherwise, we back up a line and try again. */

	if ( C_Line == 1 ) {
		Sig_Char_Found = False;
		goto Exit_Skip_Pas;
	}
	Up;
	Eol;
	goto Skip_Pas_Noise1;

Exit_Skip_Pas:
	ret;

Mac_Exit:
	Refresh = SavRefresh;
	Messages = True;

}  // Pas_Ind

void PasSetX( )
/******************************************************************************
															 Multi-Edit Macro
															 05-Apr-96  11:23

  Function: Sets the Pascal style language construct matching globals.
	Entry   : None
	Exit    : None
	Author  : Dan Hughes

							 Copyright (C) 1996 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	struct tPasProperties rPasP;

	// Set default file global
	if ( Length( Global_Str( "PasDefFile" ) ) == 0 ) {
		Set_Global_Str( "PasDefFile", "<FILE>" );
	}
	PasGetProperties( rPasP );
	if ( rPasP.Options & _pas_opt_ParenHi ) {
		Key_To_Window( Ascii( ")" ), "PAS^Pas_Close_Paren" );	 // ")" key
	}
	if ( Length( Global_Str( "!PasMatchExtra" ) ) == 0 ) {
		// Set word begin/end characters
  	Set_Global_Str( "!PasMatchExtra",
      	"B=" + "\xFF\t ;)" +
      	"E=" + "\xFF\t ;.(" );
		// Set begin construct patterns
  	Set_Global_Str( "!PasMatchBegPat",
      	"(" +                          // ( matching
          	"B= ( " +
          	"M=" +
          	"E= ) " +
          	"X=[()]" +
      	"[" +                          // [ matching
          	"B= [ " +
          	"M=" +
          	"E= ] " +
          	"X=[\\[\\]]" +
      	"{" +                          // { matching
          	"B= { " +
          	"M=" +
          	"E= } " +
          	"X=[{}]" +
      	"(*" +                         // (* matching
          	"B= (* " +
          	"M=" +
          	"E= *) " +
          	"X=(\\(\\*)|(\\*\\))" +
      	"ASMBEGINCASECLASSEXCEPTFINALLYOBJECTRECORD" +
          	"B= ASM BEGIN CASE CLASS EXCEPT FINALLY OBJECT RECORD " +
          	"M=" +
          	"E= END " +
          	"X=(END)|(ASM)|(BEGIN)|(CASE)|(CLASS)|(EXCEPT)|(FINALLY)|(OBJECT)|(RECORD)" +
      	"TRY" +
          	"B= TRY " +
          	"M=" +
          	"E= EXCEPT FINALLY " +
          	"X=(EXCEPT)|(FINALLY)|(TRY)" +
      	"REPEAT" +
          	"B= REPEAT " +
          	"M=" +
          	"E= UNTIL " +
          	"X=(UNTIL)|(REPEAT)" +
				"" );
		// Set end construct patterns
  	Set_Global_Str( "!PasMatchEndPat",
      	")" +                          // ) matching
          	"B= ) " +
          	"E= ( " +
          	"X=[()]" +
      	"]" +                          // ] matching
          	"B= ] " +
          	"E= [ " +
          	"X=[\\[\\]]" +
      	"}" +                          // } matching
          	"B= } " +
          	"E= { " +
          	"X=[{}]" +
      	"*)" +                         // *) matching
          	"B= *) " +
          	"E= (* " +
          	"X=(\\(\\*)|(\\*\\))" +
      	"END" +
          	"B= END " +
          	"E= ASM BEGIN CASE CLASS OBJECT RECORD TRY " +
          	"X=(ASM)|(BEGIN)|(CASE)|(CLASS)|(OBJECT)|(RECORD)|(TRY)|(END)" +
      	"UNTIL" +
          	"B= UNTIL " +
          	"E= REPEAT " +
          	"X=(REPEAT)|(UNTIL)" +
				"" );
	}
}  // PasSetX

void _PasGetMatchPat( )
/******************************************************************************
															 Multi-Edit Macro
															 05-Apr-96  10:48

  Function: Called by LangDoMatch to locate and return a special pattern to
 						match for Pascal style languages.

  Entry   : None

  Exit    : Return_Str  - Pattern to match or "" if a special pattern not found
            g_LangInCmt - True when pattern starts in a comment

	Author	: Dan Hughes

							 Copyright (C) 1996 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	str Special = "{}()[]*";
  str BChars = Parse_Str( _mtchBChars, MParm_Str );
  str EChars = Parse_Str( _mtchEChars, MParm_Str );
	str TStr;

  int StartInCmt;

	if ( !XPos( Cur_Char, Special, 1 ) ) {
		// Not a special character
		if ( At_Eol ) {
			// Move back to end of word
			while ( XPos( Cur_Char, EChars, 1 ) && ( C_Col != 1 ) ) {
				Left;
			}
		}
		if ( !XPos( Cur_Char, BChars + Special, 1 ) ) {
			// Move back to beginning of word
			while ( !XPos( Cur_Char, BChars, 1 ) && ( C_Col != 1 ) ) {
				Left;
			}
			if ( XPos( Cur_Char, BChars, 1 ) ) {
				Right;
			}
		}
		else {
			// Move forward to beginning of word
			Forward_Till_Not( BChars );
		}
	}
	StartInCmt = GetStatusAtCursor( );
	if ( XPos( Cur_Char, Special, 1 ) ) {
		Mark_Pos;
		TStr = Cur_Char;
		switch ( Cur_Char ) {
			case '{' :
				StartInCmt = 1;
				break;

			case '(' :
				Right;
				if ( Cur_Char == '*' ) {
					StartInCmt = 1;
					TStr += Cur_Char;
				}
				else {
					Left;
				}
				break;

			case ')' :
				if ( C_Col != 1 ) {
					Left;
				}
				if ( Cur_Char == '*' ) {
					StartInCmt = 1;
					TStr = Cur_Char + TStr;
				}
				else {
					Right;
				}
				break;

			case '*' :
				Right;
				if ( Cur_Char == ')' ) {
					StartInCmt = 1;
					TStr += Cur_Char;
					Pop_Mark;
					Mark_Pos;
					Left;
				}
				else {
					Left;
					Left;
					if ( Cur_Char == '(' ) {
						StartInCmt = 1;
						TStr = Cur_Char + TStr ;
						Pop_Mark;
						Mark_Pos;
					}
					else {
						TStr = '';
					}
				}
				break;
		}
		TStr = "\x7F" + TStr + "\x7F";
	}
  g_LangInCmt = StartInCmt;
  Return_Str = TStr;

}  // _PasGetMatchPat

void PasMtch( )
/******************************************************************************
															 Multi-Edit Macro
															 04-Apr-96  09:55

  Function: Find matching language constructs for Pascal style languages.

	Entry   : /HI=1    		- Highlight block
						/RC=1    		-	Restore cursor to original position
						/LS=x    		-	Limit scope of search to x number of lines
						/NM=1				- Display no messages
						/NA=1				- No check for abort

	Exit    : Return_Int
						 -1					- Search aborted
							0         - Match found
							1         - No match found

	Author	: Dan Hughes

							 Copyright (C) 1996 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
  Return_Int = LangDoMatch( "Pas", "", MParm_Str );

}  // PasMtch

void Pas_Close_Paren( )
/******************************************************************************
															 Multi-Edit Macro
															 09-Apr-96  15:24

	Function: Auto match the opening paren for the Pascal style languages.
	Entry   : MParm_Str			- Additional parameters ( See LangDoMatch )
	Exit    : None
	Author  : Dan Hughes

							 Copyright (C) 1996 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	int SavRefresh = Refresh;
	int TSearch_Highlight = 0;

	Push_Undo;
	Refresh = False;
	Text( ")" );
	if ( ( GetStatusAtCursor( ) & 0x0F ) == 0 ) {
		Left;
		if ( C_Col > 1 ) {
			Left;
			if ( Cur_Char == "*" ) {
				Right;
				goto Done;
			}
			Right;
		}
		LangDoMatch( "Pas", "", MParm_Str + "/RC=1/HI=1/LS=20" );
		TSearch_Highlight = Search_Highlight;

	Done:
		Right;
		Search_Highlight = TSearch_Highlight;
	}
	Refresh = SavRefresh;
	Pop_Undo;

}  // Pas_Close_Paren
