macro_file NOTEBOOK;


#include windows.sh
#include mewlist2.sh
#include dialog.sh


#define NOTEBOOK_HELPLINK     "NOTEBOOK"
#define EDITNOTE_HELPLINK     "EDIT NOTE"
#define NOTEBOOKPRT_HELPLINK  "NOTEBOOK PRINT"


#define	PGS	1		// Modified 7.00p 1993/08/18 MLM
// PGS : Two outstanding bugs in NOTEBOOK resulted in loss of categories and
// PGS : incorrect deletions of category contents.  The first would overwrite
// PGS : the first char of the next category header, making it invisible and
// PGS : leading to mysterious (apparent) loss of contents by re-inserting a
// PGS : bogus empty category at the end of file.  The second, when an entire
// PGS : category was being deleted, expected category names to start in col.
// PGS : 2, *not* 4, where they really begin.  This resulted in all contents
// PGS : of the deleted category being left behind and occasional collisions
// PGS : on category names.
/****************************Multi-Edit Macro********************************

 NAME:         notebook

 DESCRIPTION:  A neat little notes organizer.  Allows you to specify any
							 number of categories and notes.  You can mark notes as "To Do"
							 and "Complete".  Is USER_ID specific for networks.

 PARAMETERS:
							/FN=	File name override.  Default name is NOTEBOOK.TXT.  If
										Global_Str("~NOTEBOOK_NAME") is defined, it will use that.
										This parameter overrides both.


 RETURNS:

*****************************10-17-91 04:49pm*******************************/
global {
	int category_window;
	int note_list_window;
	int edit_window;
	int old_window;
	int category_id;
	int notes_id;
	int last_active_list;
	int NoteList_Offset;
	int Category_Offset;
	int NoteBook_hDlg "!NoteBook_hdlg";
  int BtnOnRight    "&BtnOnRight";
}
#define N_Select      101
#define N_Create      102
#define N_Delete      103
#define N_ChgNote     104
#define N_Complete    105
#define N_Edit_PB     106
#define Note_Print    107
#define N_Done        108
#define N_Help        109
#define N_CatList     2100
#define N_NotesList   2101
#define notebook_bmp  'BT_GN_125'
#define todo_bmp      'BT_NB_100'
#define complete_bmp  'BT_NB_101'

void notebook () {

	if (NoteBook_hDlg != 0) {
// don't allow multiple occurances, switch to currently active notebook
		SetActiveWindow(NoteBook_hdlg);
		Return();
	}

	int main_window = 0,
			note_num,
			jx, jy, ll, cl;

	str sShortDate;

	old_window = window_id;

	refresh = false;

	return_str = Global_Str("NOTEBOOK_NAME");

	if (parse_str("/FN=",Mparm_Str) != "") {
// If notebook file is specified by a macro parameter, use it
		return_str = fexpand(parse_str("/FN=",Mparm_Str));
	}


	switch_window( window_count );
	create_window;
	window_attr = $80;
	category_window = window_id;
	create_window;
	window_attr = $80;
	note_list_window = window_id;
	create_window;
	window_attr = $80;
	edit_window = window_id;
	set_global_str('~NOTEBOOK_PARMS', '/EW=' + str( edit_window ) +
																 '/NW=' + str( note_list_window ) +
																 '/CW=' + str( category_window ) +
																 '/MW=' + str( main_window ) +
																 '/CAT#=5'
																 );
	rm("N_SET_NOTEBOOK");
	switch_win_id(main_window);
	window_attr = $80;
	switch_win_id(category_window);

	GetProfileString("intl", "sShortDate", "yy", sShortDate, 16);

  int bpos, otherpos;
  if ( BtnOnRight ) {
    bpos = 91;
    otherpos = 1;
  } else {
    bpos = 1;
    otherpos = 14;
  }

	int dlg, hDlg;
	DlgCreate(dlg);
  DlgAddCtrl(dlg, Dlg_BitmapStatic, notebook_bmp, bpos + 2, 1, 0, 0, 1300, 0, "");
  DlgAddCtrl(dlg, Dlg_PushButton, '&Activate', bpos, 3, Dlg_StanBtnWidth + 1, 0, N_Select, 0, '');
	DlgAddCtrl(dlg, Dlg_PushButton, 'Co&mplete', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), Dlg_StanBtnWidth + 1, 0, N_Complete, 0, '');
	DlgAddCtrl(dlg, Dlg_PushButton, '&Insert...', Dlg_PosOffset, Dlg_PosOffset + 2, Dlg_StanBtnWidth + 1, 0, N_Create, 0, '');
	DlgAddCtrl(dlg, Dlg_PushButton, '&Delete', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), Dlg_StanBtnWidth + 1, 0, N_Delete, 0, '');
	DlgAddCtrl(dlg, Dlg_PushButton, '&Edit...', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), Dlg_StanBtnWidth + 1, 0, N_Edit_PB, DLGF_DefButton, '');
	DlgAddCtrl(dlg, Dlg_PushButton, 'Chan&ge...', Dlg_PosOffset, Dlg_PosOffset + 2, Dlg_StanBtnWidth + 1, 0, N_ChgNote, 0, '');
	DlgAddCtrl(dlg, Dlg_PushButton, '&Print...', Dlg_PosOffset, Dlg_PosOffset + 2, Dlg_StanBtnWidth + 1, 0, Note_Print, 0, '');
  DlgAddCtrl(dlg, Dlg_PushButton, 'Close', 1, Dlg_PosOffset + 2, Dlg_StanBtnWidth + 1, 0, N_Done, 0, '/R=0');
	DlgAddCtrl(dlg, Dlg_PushButton, '&Help', Dlg_PosOffset + 90, Dlg_PosOffset, Dlg_StanBtnWidth + 1, 0, N_Help, 0, '/R=2');
  DlgAddCtrl(dlg, DLG_Static,'Ca&tegories:',otherpos, Dlg_Units + 4,30,0,2001,0,'');
	DlgAddCtrl(dlg, Dlg_ListBox, "BMP=/T=3/W=15/H=15CAT=/W=20", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 10), 28, 12, N_CatList,_LB_FLAG_PTR,
			"/INCO=1/WIN=" + str(cur_window) + "/INSWCMD=" + str(N_Create) + "/DELWCMD=" + str(N_DELETE));
	DlgAddCtrl(dlg, DLG_Static,'&Notes:', Dlg_PosOffset + 30, Dlg_NegOffset - (Dlg_Units | 10), 30,0,2002,0,'');
	if ( xpos('yyyy', sShortDate, 1) ) {
		DlgAddCtrl(dlg, Dlg_ListBox, "BMP=/T=3/W=15/H=15SBJ=/W=30/H=15CD=/W=12/H=15CT=/W=8/H=15", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 10), 58, 12, N_NotesList, 0,
				"/INCO=1/WIN=" + str(cur_window + 1)  + "/INSWCMD=" + str(N_Create) + "/DELWCMD=" + str(N_DELETE));
	} else
	{
		DlgAddCtrl(dlg, Dlg_ListBox, "BMP=/T=3/W=15/H=15SBJ=/W=32/H=15CD=/W=10/H=15CT=/W=8/H=15", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 10), 58, 12, N_NotesList, 0,
				"/INCO=1/WIN=" + str(cur_window + 1)  + "/INSWCMD=" + str(N_Create) + "/DELWCMD=" + str(N_DELETE));
	}
	hDlg = DlgBuild(dlg, 'Notebook', 'NoteBook', '', DLG_Modeless | DLG_NoParDisable);
	SetFocus(GetDlgItem (hDlg, N_CatList));   //MNB new focus stuff for modeless
	category_id = GetFocus;
	SetFocus(GetDlgItem (hDlg, N_NotesList));
	notes_id = GetFocus;
	last_active_list = notes_id;
	switch_win_id(old_window);
	return_int = DlgExecute(dlg, N_NotesList, 'Notebook', NOTEBOOK_HELPLINK, '/HOOK=NoteMsgProc', DLG_Modeless | DLG_NoParDisable);
	return();

}

Str Note_List_Xlate (str disp_str)
{
	str tstr;
	int jx;
	disp_str = str_ins('|127CD=', disp_str, 44);
	jx = xpos(' ', disp_str, 44);
	disp_str = str_ins('|127CT=', disp_str, jx);
	disp_str = str_ins('|127SBJ=', disp_str, 4);
	tstr = copy(disp_str, 2, 1);
	if ( tstr == '|42' ) {
		tstr = todo_bmp;
	} else if ( tstr == '|251' ) {
		tstr = complete_bmp;
	} else {
		tstr = '';
	}
	disp_str = str_del(disp_str, 2, 2);
	disp_str = str_ins('|127BMP=' + tstr, disp_str, 2);
	disp_str = disp_str + '          ';
	return(disp_str);
}

str Cat_List_Xlate (str disp_str)
{
	if ( '|175' == copy(disp_str, 1, 1) )
	{
		disp_str = str_del(disp_str, 1, 2);
		disp_str = '|127BMP=CHKMRK0|127CAT=' + disp_str;
	} else {
		disp_str = str_del(disp_str, 1, 2);
		disp_str = '|127BMP=|127CAT=' + disp_str;
	}
	return(disp_str);
}

int NoteMsgProc( int &retval, int window, int message, int wparam, int lparam, str parms ) no_break
{
	//int jx;
	//if ( category_id == GetFocus ) {
	//	last_active_list = category_id;
	//} else if ( notes_id == GetFocus ) {
	//	last_active_list = notes_id;
	//}
	switch ( message )
	{
		case WM_COMMAND :
			switch ( wparam )
				{
					case DLG_Wcmd_Init :
						NoteBook_hDlg = window;
            str t_str[50] = "NOTE_LIST_XLATE";
            SendMessageStr(GetDlgItem(window, N_NotesList), WM_ML2_SETMACROPROC, 0, t_str);
            t_str = "CAT_LIST_XLATE";
            SendMessageStr(GetDlgItem(window, N_CatList), WM_ML2_SETMACROPROC, 0, t_str);
						int jx = window_id;
						switch_win_id(note_list_window);
						return_int = c_line - 1;
						switch_win_id (jx);
						SendDlgItemMessage( window, N_NotesList, LB_SETCURSEL, return_int, 0 );
						SendDlgItemMessage( window, N_CatList, LB_SETCURSEL, -1, 0 );
						return (1);
					case N_CatList :
						switch (lParam >> 16)
						{
							case LBN_SETFOCUS :
							{
								last_active_list = category_id;
								EnableWindow (GetDlgItem (window, N_Select), TRUE);
								EnableWindow (GetDlgItem (window, N_Complete), FALSE);
								SendMessage(window, DM_SETDEFID, N_Select, 0);
								return(1);
							}
							case LBN_SELCHANGE :
							{
								SendDlgItemMessage( window, N_NotesList, LB_SETCURSEL, -1, 0 );
								return(1);
							}
						}
						return(1);
					case N_NotesList :
						switch (lParam >> 16)
						{
							case LBN_SETFOCUS :
							{
								last_active_list = notes_id;
								EnableWindow (GetDlgItem (window, N_Select), FALSE);
								EnableWindow (GetDlgItem (window, N_Complete), TRUE);
								SendMessage(window, DM_SETDEFID, N_Edit_PB, 0);
								return(1);
							}
							case LBN_SELCHANGE :
							{
								SendDlgItemMessage( window, N_CatList, LB_SETCURSEL, -1, 0 );
								return(1);
							}
						}
						return(1);
					case 998 :
					case N_Select :
						int jx = SendDlgItemMessage( window, N_NotesList, LB_GETCOUNT, 0, 0 );
						int jy = SendDlgItemMessage( window, N_CatList, LB_GETCOUNT, 0, 0 );
						int jz = SendDlgItemMessage( window, N_CatList, LB_GETCURSEL, 0, 0 );
						rm('notes_select');
						if ( category_id == last_active_list ) {
							while(  jx > 0 )
							{
								SendDlgItemMessage( window, N_NotesList, LB_DELETESTRING, 0, 0 );
								--jx;
							}
							while(  jx < return_int )
							{
								SendDlgItemMessage( window, N_NotesList, LB_ADDSTRING, 0, 0 );
								++jx;
							}
							jx = window_id;
							switch_win_id(category_window);
							mark_pos;
							eof;
							return_int = c_line;
							goto_mark;
							switch_win_id(jx);
							while(  jy > 0 )
							{
								SendDlgItemMessage( window, N_CatList, LB_DELETESTRING, 0, 0 );
								--jy;
							}
							while(  jy < return_int )
							{
								SendDlgItemMessage( window, N_CatList, LB_ADDSTRING, 0, 0 );
								++jy;
							}
							SendDlgItemMessage( window, N_CatList, LB_SETCURSEL, jz, 0 );
						}
						break;
					case N_Create :
						int jx = SendDlgItemMessage( window, N_NotesList, LB_GETCOUNT, 0, 0 );
						rm('notes_create');
						if ( return_int == 1 ) {
							SendDlgItemMessage(window, N_CatList, LB_ADDSTRING,0,0 );
							while ( jx > 0 ) {
								SendDlgItemMessage(window, N_NotesList, LB_DELETESTRING, 0, 0);
								-- jx;
							}
						} else if (return_int == 2) {
							SendDlgItemMessage(window, N_NotesList, LB_ADDSTRING,0,0 );
						}
						break;
					case N_Delete :
						int jx = SendDlgItemMessage( window, N_NotesList, LB_GETCOUNT, 0, 0 );
						rm('notes_delete');
						if ( return_int == 1 ) {
							SendDlgItemMessage(window, N_CatList, LB_DELETESTRING,0,0 );
							rm('notes_select');
							while ( jx > 0 ) {
								SendDlgItemMessage(window, N_NotesList, LB_DELETESTRING, 0, 0);
								-- jx;
							}
							while ( jx < return_int ) {
								SendDlgItemMessage(window, N_NotesList, LB_ADDSTRING, 0, 0);
								++jx;
							}
						} else if (return_int == 2) {
							SendDlgItemMessage(window, N_NotesList, LB_DELETESTRING,0,0 );
						}
						break;
					case N_ChgNote :
						int jx = SendDlgItemMessage(window, N_CatList, LB_GETCOUNT, 0, 0);
						int jy = SendDlgItemMessage(window, N_NotesList, LB_GETCOUNT, 0, 0);
						rm('n_set_notebook /LIST=1');
						if ( return_int ) {
							while ( jx > 0 ) {
								SendDlgItemMessage(window, N_CatList, LB_DELETESTRING, 0, 0);
								-- jx;
							}
							while ( jy > 0 ) {
								SendDlgItemMessage(window, N_NotesList, LB_DELETESTRING, 0, 0);
								-- jy;
							}
							jx = window_id;
							switch_win_id(category_window);
							mark_pos;
							eof;
							return_int = c_line;
							goto_mark;
							while ( return_int > 0 ) {
								SendDlgItemMessage(window, N_CatList, LB_ADDSTRING, 0, 0);
								-- return_int;
							}
							switch_win_id(note_list_window);
							mark_pos;
							eof;
							return_int = c_line;
							goto_mark;
							while ( return_int > 0 ) {
								SendDlgItemMessage(window, N_NotesList, LB_ADDSTRING, 0, 0);
								-- return_int;
							}
							switch_win_id(note_list_window);
							return_int = c_line - 1;
							switch_win_id (jx);
							SendDlgItemMessage( window, N_NotesList, LB_SETCURSEL, return_int, 0 );
							SendDlgItemMessage( window, N_CatList, LB_SETCURSEL, -1, 0 );
						}
						//setfocus(last_active_list);
						break;
					case N_Complete :
						jx = SendDlgItemMessage(window, N_CatList, LB_GETCOUNT, 0, 0);
						rm('NOTES_SELECT /MARK=1');
						if ( jx ) {
							SendDlgItemMessage(window, N_NotesList, LB_DELETESTRING, 0, 0);
							SendDlgItemMessage(window, N_NotesList, LB_ADDSTRING, 0, 0);
						}
						break;
					case N_Edit_PB :
						if ( Last_Active_List == Notes_ID ) {
							rm('Notes_Select');
						} else
							rm('N_EDIT_CAT_NAME');
						break;
					case Note_Print :
						rm('n_print /HNDL=' + str(window));
						break;
					case 2 :
					case N_Done :
DONE:
						rm("n_close_notebook");
						switch_win_id( edit_window );
						delete_window;
						switch_win_id( note_list_window );
						jx = c_line;
						delete_window;
						switch_win_id( category_window );
						set_global_str('~NOTEBOOK_PARMS', '/LL=' + str(jx) + '/CL=' + str(c_line) );
						delete_window;
						switch_win_id( old_window );
						DestroyWindow( window );
						Notebook_hdlg = 0;
						retval = 0;
						return(1);
				}
				setfocus(last_active_list);
				sendmessage(N_NotesList, WM_ML2_REDRAW, 0, 0);
				sendmessage(N_CatList, WM_ML2_REDRAW, 0, 0);
		case WM_SysCommand :
				if ( wparam == 61536)
					goto done;
	}
	return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));
}

macro n_set_notebook
{
	str nstr[80] = global_str('~NOTEBOOK_PARMS');

	int main_window = parse_int('/MW=', nstr ),
			category_window = parse_int('/CW=', nstr ),
			note_list_window = parse_int('/NW=', nstr ),
			edit_window = parse_int('/EW=', nstr ),
			owin = window_id,
			note_num,
			jx
			;

	return_int = 1;
	if( parse_int("/LIST=",mparm_str) == 1 ) {
		return_str = "*.TXT";
		rm("MAKEUSERPATH");
		rm("FILE_PROMPT /T=SELECT NOTEBOOK/H=" +NOTEBOOK_HELPLINK);
		if ( return_int )
			rm("n_close_notebook");
	}

	if( return_int ) {
		if( return_str == "" ) {
			return_str = 'NOTEBOOK.TXT';
			rm('MAKEUSERPATH');
		}

		error_level = 0;
		if( !switch_file( return_str ) ) {   //true if file is loaded already
			if( main_window == 0 ) {
				switch_window( window_count );
				create_window;
			}
			else
				switch_win_id( main_window );
			erase_window;
			main_window = window_id;
			load_file( return_str );
			if( error_level != 0 ) {
				file_name = fexpand(return_str);
				error_level = 0;
				put_line( '0' );
				down;
				put_line( 'CATEGORIES' );
			}
			if (read_only) {
				RM('USERIN^VERIFY /H='+NOTEBOOK_HELPLINK+'/BL=NOTEBOOK FILE IS LOCKED/T=Unlock?/S=2');
				if( return_int ) {
					read_only = false;
					cur_file_attr = (cur_file_attr & $FFFE);
				}
			}
		} else {
			main_window = window_id;
		}
		set_global_str("NOTEBOOK_NAME", file_name );
		tof;
		jx = val( note_num, get_line );
		set_global_int( '~NOTEBOOK_NUM', note_num );

		set_global_str('~NOTEBOOK_PARMS', '/EW=' + str( edit_window ) +
																	'/NW=' + str( note_list_window ) +
																	'/CW=' + str( category_window ) +
																	'/MW=' + str( main_window ) +
																	'/CAT#=5'
																	);



		reg_exp_stat = TRUE;
		rm( 'N_GET_CATEGORIES' );
		switch_win_id( category_window );
		tof;
		while( !at_eof && ( cur_char != "" ) )
			down;
		if(at_eof)
			tof;

		rm( 'n_get_list');
		switch_win_id( owin );
		return_int = 1;		//Added to make processing easier in the proc
	}
}

macro n_close_notebook
{
	str nstr[80] = global_str('~NOTEBOOK_PARMS');

	int main_window = parse_int('/MW=', nstr ),
			category_window = parse_int('/CW=', nstr ),
			note_list_window = parse_int('/NW=', nstr ),
			edit_window = parse_int('/EW=', nstr ),
			owin = window_id,
			note_num,
			jx,jy
			;

	reg_exp_stat = 1;
	switch_win_id( category_window );
	jx = c_line;
	switch_win_id( main_window );
	tof;
	search_fwd("%\f\f\fCATEGORIES", 0 );
	eol;
	if( search_fwd("%[\f]", 0 ) ) {
		 if( (jx + 2) != c_line ) {
				insert_mode = FALSE;
				if( cur_char != "\f" )
					text(" " );
				goto_line( jx + 2 );
				goto_col(1);
				text("");
				insert_mode = TRUE;
		 }
	}

	switch_win_id(note_list_window);
	jx = c_line;
	jy = 0;
	switch_win_id( main_window );
	goto_line( global_int("~NOTEBOOK_LINE"));
	eol;
	if( search_fwd("%[\f]",0) ) {
		if( cur_char == "" ) {
			if( (c_line - global_int("~NOTEBOOK_LINE") ) == jx )
				goto no_change;
			insert_mode = FALSE;
			text(" ");
		}
	}
	goto_line( global_int("~NOTEBOOK_LINE") + jx );
	insert_mode = FALSE;
	goto_col(1);
#ifdef	PGS		// Don't trash next category if this one is empty!
	if(!At_Eof && (Cur_Char != "\f"))
	{	Text("");
	}
#else		// PGS
	text("");
#endif	// PGS
no_change:

	tof;
	jx = val( note_num, get_line );
	if (global_int('~NOTEBOOK_NUM') != note_num) {
		put_line( str(global_int( '~NOTEBOOK_NUM' )) );
	}

	if( file_changed )
			save_file;
	window_attr = $81;

	insert_mode = TRUE;
}

macro notes_select
{
		str nstr[80] = global_str('~NOTEBOOK_PARMS'),
				note_num[20],
				tstr[120];

		int main_window = parse_int('/MW=', nstr ),
				category_window = parse_int('/CW=', nstr ),
				note_list_window = parse_int('/NW=', nstr ),
				edit_window = parse_int('/EW=', nstr ),
				owin = window_id,
				tpb = persistent_blocks,
				mark_complete = parse_int('/MARK=', mparm_str ), mw
				;

		persistent_blocks = TRUE;
		//if((owin == category_window) && !(mark_complete)) {
		if((category_id == last_active_list) && !(mark_complete)) {
			rm( 'n_get_list');
		//} else if ((owin == note_list_window) || mark_complete) {
		} else if ((notes_id == last_active_list) || mark_complete) {
			switch_win_id(note_list_window);   //modeless stuff
			int jx, jy, ew;
			jy = c_line;
			jx = parse_int('|127NUM=', get_line );
			switch_win_id( main_window );
			mw = cur_window;
			goto_line(global_int('~NOTEBOOK_LINE'));
			reg_exp_stat = TRUE;
			if( search_fwd('%|12NUM=' + str(jx) + '|12', 0)) {
				jx = c_line;
				return_str = get_line;
				note_num = parse_str('|12NUM=', return_str);
				down;
				block_begin;
				goto_col(1);
				if( search_fwd('%|12', 0)) {
					if (c_line == block_line1) {
						block_off;
					} else {
						up;
						block_end;
					}
				} else {
					if(at_eof)
							block_off;
					else {
						eof;
						block_end;
					}
				}
				switch_win_id( edit_window );
				ew = cur_window;
				erase_window;
				window_copy( mw );
				persistent_blocks = tpb;
				if( mark_complete ) {
					tstr = return_str;
					var_remove_str('DONE=', tstr );
					return_str = tstr + 'DONE=1';
					return_int = TRUE;
				}
				else
					rm('n_edit_note /EDIT=1');
				persistent_blocks = TRUE;
				if( return_int ) {
					str sTime[2], time_str[10] = STR_DEL(TIME,6,3); //timefix begin

					GetProfileString("intl","sTime", ":",sTime,2);  // gets MS-Win time
					if (xpos(sTime,time_str,1) == 2) {
						time_str = STR_DEL(TIME,5,3);
					} //timefix end
					int to_do = parse_int('|127DO=', return_str ) && !parse_int('|127DONE=', return_str);
					tof;
					block_begin;
					eof;
					block_end;
					switch_win_id( main_window );
					goto_line( jx );
					delete_block;
					tstr = return_str;
					var_remove_str( '|127MD=', tstr );
					return_str = tstr + '|127MD=' + date + ' ' + time_str; //timefix
					//return_str = Str_Del(return_str, length(return_str) - 4, 3);
					//if ( copy(return_str, length(return_str)- 6, 1) != '1' ) { //NEWLIST STUFF
					//	return_str = str_ins('0', return_str, length(return_str) - 5);
					//}
					//if ( copy(return_str, length(return_str) - 15, 1) != '1' ) {
					//	return_str = str_ins('0', return_str, length(return_str) - 14);
					//}                                                            //NEWLIST STUFF
					if ( !mark_complete )   /* DKF */
						return_str = '|12NUM=' + note_num + '|12' + return_str;
					put_line( return_str );
					down;
					window_copy( ew );
					block_off;
					goto_line( global_int('~NOTEBOOK_LINE') );
					jx = 0;
					while( jx++ < jy )
							down;
					del_line;
					rm("sort_note");
					jx = return_int;
					RM('n_list_entry /N=' + note_num );
					put_line( return_str );
					switch_win_id( note_list_window );
					goto_line( jy );
					del_line;
					goto_line( jx );
					goto_col(1);
					if(!at_eof) {
						jx = line_attr;
						cr;
						line_changed = FALSE;
						line_attr = jx;
						up;
					}
					put_line( return_str );
					line_changed = FALSE;
					if( to_do ) {
						line_attr = 0;
						rm('n_set_cat /ON=1');
					} else {
						line_attr = 0;
						reg_exp_stat = TRUE;
						mark_pos;
						tof;
						to_do = search_fwd('%?@*', 0);
						goto_mark;
						rm('n_set_cat /ON=' + str(to_do) );
					}
				}
			}
		}
		switch_win_id( owin );
		persistent_blocks = tpb;
}

macro sort_note
{
	int jx;
	str ds[8] = parse_str("CD=", return_str),
			ys[2] = copy(ds,7,2),
			tstr[128];

	goto_line( global_int('~NOTEBOOK_LINE') );
	down;
	goto_col(1);

	ds = copy(ds,1,5);
	jx = 1;
	tstr = get_line;
	if( parse_int('DO=', return_str) && !parse_int('DONE=', return_str) ) {
		while( !at_eof && (copy(tstr, 1, 1) != "\f")
					&& (copy(tstr,2,1) == "*")
					&& (copy(tstr,50,2) >= ys)
					&& (copy(tstr,44,5) > ds)) {
					++jx;
					down;
					tstr = get_line;
		}

	}
	else {
		while( !at_eof && (copy(tstr, 1, 1) != "\f")
					&& (((copy(tstr,50,2) >= ys)
					&& (copy(tstr,44,5) > ds)) || (copy(tstr,2,1) == "*"))
					) {
					++jx;
					down;
					tstr = get_line;
		}
	}
	if(!at_eof) {
		cr;
		up;
	}
	return_int = jx;
}

macro notes_delete
{
		str nstr[80] = global_str('~NOTEBOOK_PARMS');

		int main_window = parse_int('/MW=', nstr ),
				category_window = parse_int('/CW=', nstr ),
				note_list_window = parse_int('/NW=', nstr ),
				edit_window = parse_int('/EW=', nstr ),
				owin = window_id,
				tpb = persistent_blocks
				;
		int jx, jy;

		persistent_blocks = TRUE;

		//if(owin == category_window) {
		if(category_id == last_active_list) {
			switch_win_id(category_window);   // modeless stuff
#ifdef	PGS	// Fix offset (4, not 2) so delete works correctly
			Rm("UserIn^Verify /H="+NOTEBOOK_HELPLINK+"/T=All notes in \"" +
					Shorten_Str(Copy(Get_Line, 4, 20)) + "\" will be lost!");
#else		// PGS
			RM('USERIN^VERIFY /H='+NOTEBOOK_HELPLINK+'/T=All notes in "' + shorten_str( copy(get_line,2,20))
									 + '" will be lost!');
#endif	// PGS
			if( return_int ) {
				jx = c_line;
#ifdef	PGS	// Fix offset (4, not 2) so delete works correctly
				Return_Str = Shorten_Str(Copy(Get_Line, 4, 20));
#else		// PGS
				return_str = shorten_str(copy( get_line, 2, 20 ));
#endif	// PGS
				switch_win_id( main_window );
				tof;
				down;
				jy = 0;
				while( jy < jx ) {
					down;
					++jy;
				}
				del_line;
				goto_col(1);
				reg_exp_stat = TRUE;
				if( search_fwd( '%|12|12' + return_str + '~~~!', 0 )) {
					block_begin;
					eol;
					if( !search_fwd('%|12|12?*@~@~@~!',0))
							eof;
					else
							up;
					block_end;
					delete_block;
				}
				switch_win_id( category_window );
				del_line;
				goto_col(1);
				if(block_stat) {
					goto_line(block_line1);
				} else if (at_eof) {
					up;
				}
				rm('n_get_list');
				return_int = 1;
			}
		//} else if (owin == note_list_window) {
		} else if (notes_id == last_active_list) {
			switch_win_id(note_list_window);  // modeless stuff
			RM('USERIN^VERIFY /H='+NOTEBOOK_HELPLINK+'/T=Delete this note?');
			if( return_int ) {
				jy = c_line;
				jx = parse_int('|127NUM=', get_line);
				del_line;
				switch_win_id( main_window );
				goto_line(global_int('~NOTEBOOK_LINE'));
				reg_exp_stat = TRUE;
				if( search_fwd('%|12NUM=' + str(jx) + '|12', 0)) {
					jx = c_line;
					block_begin;
					eol;
					if( search_fwd('%|12', 0)) {
						up;
						block_end;
					} else {
						eof;
						block_end;
					}
					delete_block;
					goto_line( global_int('~NOTEBOOK_LINE') );
					jx = 0;
					while( jx++ < jy )
						down;
					del_line;
				}
				return_int = 2;
			}
		}
		switch_win_id( owin );
		persistent_blocks = tpb;
}


macro n_list_entry
{
	str tstr[120];

	tstr = parse_str('|127SBJ=', return_str );
	pad_str( tstr, 40, ' ' );
	tstr = tstr + parse_str('|127CD=', return_str);  //MNB
	if( parse_int('|127DONE=', return_str) )
			tstr = '  ' + tstr;
	else if( parse_int('|127DO=', return_str) )
			tstr = ' * ' + tstr;
	else
			tstr = '   ' + tstr;
	pad_str( tstr, 59, ' ' );
	tstr += '|127NUM=' + parse_str('/N=', mparm_str);
	return_str = tstr;    //MNB
}

macro n_print trans {
	str nstr[80] = global_str('~NOTEBOOK_PARMS');

	int   main_window = parse_int('/MW=', nstr ),
				note_list_window = parse_int('/NW=', nstr),
				category_window = parse_int('/CW=', nstr ),
				owin = window_id,
				to_do_only = 0, summary = 1,
				handle = 0,
				jx, line_count, page_count = 1,
				hndl = parse_int('/HNDL=', mparm_str),
				trefresh = refresh
				;
	str header_str[128], tstr, margin_str[80];

	int note_prn_window;

	#define P_Category 101
	#define P_S_Note   102
	#define	P_Margin   201
	#define	P_Prn_Sum  1001
	#define	P_ToDo     1002
	#define	P_Done     103
	#define	P_Help     104


	refresh = false;
	return_str = global_str('PRINTER_TYPE');
	int prn_dlg;
	DlgCreate(prn_dlg);
	DlgAddCtrl(prn_dlg, Dlg_PushButton, 'Print Cate&gory', 1, 1, Dlg_StanBtnWidth + 8, 0, P_Category, 0, '/R=10');
	DlgAddCtrl(prn_dlg, Dlg_PushButton, 'Print Single &Note', 1, Dlg_PosOffset + 2, Dlg_StanBtnWidth + 8, 0, P_S_Note, 0, '/R=11');
	//DlgAddCtrl(prn_dlg, Dlg_Static, 'Print &Margin', 1, Dlg_PosOffset + 2, 0, 0, 121, 0, '');
	//DlgAddCtrl(prn_dlg, Dlg_Integer, '', Dlg_PosOffset + 14, Dlg_PosOffset, 2, 0, P_Margin, 0, '');
	//DlgSetInt( prn_dlg, P_Margin, 1);
	DlgAddCtrl( prn_dlg, Dlg_GroupBox, "", Dlg_PosOffset + 22, 1, 24, 3, 2001, 0, "");
	DlgAddCtrl( prn_dlg, DLG_CheckBox, "Print S&ummary", Dlg_PosOffset + 1, Dlg_PosOffset + (Dlg_Units | 10), 0, 0, P_Prn_Sum, 0, "");
	DlgSetInt( prn_dlg, P_Prn_Sum, 1);
	DlgAddCtrl( prn_dlg, DLG_CheckBox, '"&To Do" items only', Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, P_ToDo, 0, "");
	DlgSetInt( prn_dlg, P_ToDo, 0);
	DlgAddCtrl(prn_dlg, Dlg_PushButton, 'Close', 1, Dlg_PosOffset + 2, Dlg_StanBtnWidth, 0, P_Done, 0, '/R=0');
	DlgAddCtrl(prn_dlg, Dlg_PushButton, '&Help', Dlg_PosOffset + 34, Dlg_PosOffset, Dlg_StanBtnWidth, 0, P_Help, 0, '/R=2');

	return_int = DlgExecute(prn_dlg, P_Category, 'Notebook Print', NOTEBOOKPRT_HELPLINK, '', 0);

	if ((return_int == 10) || (return_int == 11)) {
		switch_window(window_count);
		create_window;
		note_prn_window = cur_window;
		file_name = 'NOTEBOOK';
		summary = DlgGetInt( prn_dlg, P_Prn_Sum);
		to_do_only = DlgGetInt( prn_dlg, P_ToDo);
		print_margin = DlgGetInt( prn_dlg, P_Margin);
		jx = return_int;
		if( jx == 10 ) {
			call print_category;
		}
		else if( jx == 11 ) {
			call print_note;
		}

		rm('print^printwindow /DLGHANDLE=' + str(hndl) + '/WINHANDLE=' + str(note_prn_window));
		switch_window(note_prn_window);
		delete_window;
	}
	goto exit;

print_note:
	call setup_print;
	switch_win_id( note_list_window );
	return_str = parse_str("NUM=", get_line);
	switch_win_id( main_window );
	goto_line( global_int('~NOTEBOOK_LINE') );
	if( search_fwd('|12NUM=' + make_literal(return_str) + '|12',0)) {
		call print_note_line;
		down;
		goto_col(1);
		call format_note;
	}
	ret;


setup_print:
	str sTime[2], time_str[10] = STR_DEL(TIME,6,3); //timefix begin

	GetProfileString("intl","sTime", ":",sTime,2);
	if (xpos(sTime,time_str,1) == 2) {
		time_str = STR_DEL(TIME,5,3);
	}  //timefix end
	reg_exp_stat = TRUE;
	switch_win_id( main_window );
	goto_line( global_int('~NOTEBOOK_LINE') );
	pad_str( margin_str, print_margin, ' ');
	return_str = copy(get_line,3,40);
	jx = xpos('~~~!', return_str,1);
	if( jx != 0 ) {
		return_str = copy(return_str,1, jx - 1 );
	}
	Header_Str = margin_str + "Category:  " + return_str;
	pad_str(header_str, 40, ' ' );
	header_str += date + ' ' + time_str;  //timefix
	//header_str = Str_Del(return_str, length(return_str) - 4, 3);
	pad_str(header_str, 80 - print_margin - 5, ' ' );
	header_str += 'Pg. ';
	line_count = 0;
	ret;


print_category:
	call setup_print;
	jx = window_id;
	return_str = header_str + str( page_count );
	switch_window(note_prn_window);
	put_line (return_str);
	eol;
	cr;cr;
	switch_win_id(jx);
	//rm('printstr /H=' + str(handle));

	if( summary ) {
		tstr = "Summary:";
		call print_line;
		down;
		goto_col(1);
		while( cur_char != '|12' ) {
			if( !to_do_only || (copy(get_line,2,1) == '*')) {
				tstr = '    ' + copy(get_line,1,60);
				call print_line;
			}
			down;
		}
	}
	else {
		eol;
		if (!search_fwd('%|12', 0 ))
				goto pdone;
	}

	while( (copy(get_line,1,2) != '|12|12') && !at_eof) {

		if( cur_char == '|12') {		// if this is a header line...
			switch ( to_do_only )
			{
				case  1:
					if ( (parse_int('DO=',get_line) && !(parse_int('DONE=',get_line))) )
					{
						call print_note_line;
					}
					else
					{
						eol;
						if ( !search_fwd('|12',0) )		// skip ahead to next header
						{
							eof;
						}
						up;	// adjust for down stmt below
					}
					break;
				case  0:
					call print_note_line;
					break;
			}
		}
		else {
			call format_note;
			while ( (cur_char != '|12') && (!at_eof) )
			{
				down;
			}
			up;
		}
		down;
	}
pdone:
	ret;


print_line:
		//++line_count;
		//if( line_count > 54 ) {
		//	call form_feed;
		//}
		//return_str = margin_str + tstr + '|13|10';
		return_str = margin_str + tstr;
		//rm('printstr /H=' + str(handle));
		jx = window_id;
		switch_window(note_prn_window);
		put_line(return_str);
		eol;
		cr;
		switch_win_id(jx);
	ret;


print_note_line:
	tstr = '';
	call print_line;
	if( line_count > 49 ) {
		call form_feed;
	}
	pad_str( tstr, 75 - print_margin, '-');
	call print_line;
	tstr = 'SUBJECT:  ' + parse_str('SBJ=', get_line );
	call print_line;
	tstr = 'CREATED: ' + parse_str('CD=', get_line )
				+ '  MODIFIED: '  + parse_str('MD=', get_line );
	if( parse_int('DONE=', get_line) )
			tstr += ' >>> DONE';
	else if( parse_int('DO=', get_line) )
			tstr += ' >>> TO DO';
	call print_line;
	tstr = '';
	call print_line;
	ret;

format_note:
	int thiswin = cur_window;
	switch_window(window_count);
	create_window;
	int format_win = cur_window;
	switch_window(thiswin);
	mark_pos;
	block_begin;
	while( !at_eof && (cur_char != '|12')) {
		down;
	}
	if ( cur_char == '|12' )
		up;
	block_end;

	switch_window(format_win);
	window_copy(thiswin);
	switch_window(thiswin);
	switch_window(format_win);
	right_margin = 65;
	while( !at_eof ) {
		if ( length(get_line) > right_margin )
		{
			rm('Text^reformat');
		} else {
			goto_col(1);
			down;
		}
	}
	tof;
	while( !at_eof ) {
		tstr = '    ' + get_line;
		call print_line;
		down;
	}
 	delete_window;
	switch_window(thiswin);
	goto_mark;
	block_off;
	make_message('');
	ret;

form_feed:
	++page_count;
	line_count = 0;
	return_str = '|12' + header_str + str( page_count ) + '|13|10|10|10';
	rm('printstr /H=' + str(handle));
	ret;

exit:
	return_int = 100;
	refresh = trefresh;
	switch_win_id( owin );
}

macro n_edit_cat_name
{
		str nstr[80] = global_str('~NOTEBOOK_PARMS');

		int main_window = parse_int('/MW=', nstr ),
				category_window = parse_int('/CW=', nstr ),
				owin = window_id
				;
		int jx, jy;
		str tstr[10];

		switch_win_id( category_window );
		jx = c_line;
		nstr = copy(get_line, 4, 20);
		tstr = copy( get_line, 1, 3 );
		return_str = nstr;
		rm('USERIN^QUERYBOX /H='+NOTEBOOK_HELPLINK+'/T=NEW NAME OF CATEGORY/W=20');
		if( return_int ) {
			return_str = shorten_str(return_str);
			put_line('');
			mark_pos;
			tof;
			if(search_fwd('% ' + return_str + '$',0)) {
				RM('MEERROR^MESSAGEBOX /M=Category already exists!');
				goto_mark;
				put_line( '  ' + nstr );
				goto exit;
			}
			goto_mark;
			put_line(tstr + return_str );
			switch_win_id( main_window );
			tof;
			goto_line( jx + 2 );
			put_line(tstr + return_str );
			reg_exp_stat = TRUE;
			if( search_fwd( '%|12|12' + nstr + '~~~!', 0 ) ) {
				put_line('|12|12' + return_str + '~~~!' );
			}
		}
	exit:
		switch_win_id( owin );
}

macro n_set_cat {
		str nstr[80] = global_str('~NOTEBOOK_PARMS');

		int main_window = parse_int('/MW=', nstr ),
				category_window = parse_int('/CW=', nstr ),
				owin = window_id,
				ti = insert_mode;
				;
		int jx, jy;

		switch_win_id( category_window );
		mark_pos;
		jx = c_line;
		goto_col( 2 );
		insert_mode = false;
		if( parse_int('/ON=', mparm_str )) {
				text('*');
				line_attr = 0;
		} else {
				text(' ');
				line_attr = 0;
		}
		line_changed = false;
		goto_mark;
		switch_win_id( main_window );
		mark_pos;
		tof;
		goto_line( jx + 2 );
		goto_col( 2 );
		if( parse_int('/ON=', mparm_str ))
				text('*');
		else
				text(' ');
		goto_mark;
		switch_win_id( owin );
		insert_mode = ti;
}

macro notes_create
{
		str nstr[80] = global_str('~NOTEBOOK_PARMS');
		str tstr[100];

		int main_window = parse_int('/MW=', nstr ),
				category_window = parse_int('/CW=', nstr ),
				note_list_window = parse_int('/NW=', nstr ),
				edit_window = parse_int('/EW=', nstr ),
				owin = window_id,
				tpb = persistent_blocks, ew
				;

		int jx, jy;

		persistent_blocks = TRUE;

		if(category_id == last_active_list) {
			switch_win_id(category_window);  //modeless stuff
			jx = c_line;
			jy = jx;
			return_str = '';
			RM('USERIN^QUERYBOX /H='+NOTEBOOK_HELPLINK+'/T=NEW NOTE CATEGORY/W=20');
			if( return_int ) {
				switch_win_id( main_window );
				tof;
				search_fwd( '|12|12|12CATEGORIES', 0 );
				while( jx-- > 0)
						down;
				cr;
				up;
				put_line( '   ' + shorten_str(return_str) );
				jy = c_line;
				switch_win_id( category_window );
				goto_line(jy - 2);
				goto_col(1);
				jy = line_attr;
				cr;
				line_changed = FALSE;
				line_attr = jy;
				up;
				mark_pos;
				put_line( '   ' + return_str );
				rm( 'n_get_list');
				switch_win_id( owin );
				goto_mark;
				return_int = 1;
			}
		} else if ( notes_id == last_active_list ) {
			switch_win_id(note_list_window);  //modeless stuff
		//} else if (owin == note_list_window ) {
			str sTime[2], time_str[10] = STR_DEL(TIME,6,3); //timefix begin

			GetProfileString("intl","sTime", ":",sTime,2);
			if (xpos(sTime,time_str,1) == 2) {
				time_str = STR_DEL(TIME,5,3);
			}  //timefix end
			switch_win_id( edit_window );
			ew = cur_window;
			return_str = date + ' ' + time_str; //timefix
			//return_str = Str_Del(return_str, length(return_str) - 4, 3);
			//if ( copy(return_str, length(return_str) - 6, 1) != '1' ) { //NEWLIST STUFF
			//	return_str = str_ins('0', return_str, length(return_str) - 5);
			//}
			//if ( copy(return_str, length(return_str) - 15, 1) != '1' ) {
			//	return_str = str_ins('0', return_str, length(return_str) - 14);
			//}                                                            //NEWLIST STUFF
			return_str = '|127CD=' + return_str + '|127MD=' + return_str;
			erase_window;
			persistent_blocks = tpb;
			rm('n_edit_note');
			persistent_blocks = TRUE;
			if( return_int ) {
				int		tl,
							to_do = parse_int('|127DO=', return_str ) && !parse_int('|127DONE=', return_str);
				tof;
				block_begin;
				eof;
				block_end;
				switch_win_id( main_window );
				goto_line( global_int('~NOTEBOOK_LINE') );
				goto_col(1);
				down;
				reg_exp_stat = TRUE;
				if( !search_fwd('%|12',0) ) {
					eof;
					if( c_col > 1)
							down;
				}
				goto_col(1);
				cr;
				up;
				jx = global_int( '~NOTEBOOK_NUM' );
				++jx;

				put_line( '|12NUM=' + str(jx) + '|12' + return_str );
				set_global_int( '~NOTEBOOK_NUM', jx );
				down;
				window_copy( ew );
				block_off;
				rm("sort_note");
				tl = return_int;
				RM('n_list_entry /N=' + str(jx) );
				put_line( return_str );
				switch_win_id( note_list_window );
				goto_line( tl );
				goto_col( 1 );
				if( !at_eof) {
					tl = line_attr;
					cr;
					line_changed = FALSE;
					line_attr = tl;
					up;
				}
				put_line( return_str );
				line_changed = FALSE;

				if( to_do ) {
					line_attr = 0;
					rm('n_set_cat /ON=1');
				} else {
					reg_exp_stat = TRUE;
					mark_pos;
					tof;
					to_do = search_fwd('%?@*', 0);
					rm('n_set_cat /ON=' + str(to_do) );
					goto_mark;
				}
				return_int = 2;
			}
		}
		switch_win_id( owin );
		persistent_blocks = tpb;
}


macro n_edit_note
{
	int note_dlg, start= 1;

	if(parse_int('/EDIT=', mparm_str))
			start = 4;

	wrap_stat = TRUE;
	right_margin = 65;
	block_off;
	DlgCreate(note_dlg);
	DlgAddCtrl( note_dlg, Dlg_Static, "&Subject:",1, 1, 0, 0, 2001, 0, "");
	DlgAddCtrl( note_dlg, Dlg_Text, parse_str('|127SBJ=', return_str), 12, Dlg_PosOffset, 33, 0, 1101, 0, "/ML=33");
	DlgAddCtrl( note_dlg, DLG_GreyFrame, '',Dlg_PosOffset + 44, Dlg_PosOffset + (Dlg_Units | 2), 15, 2, 1030, 0, "" );
	DlgAddCtrl( note_dlg, DLG_CheckBox, 'To &Do',DLG_PosOffset + 1,DLG_PosOffset,0,0,1001,0,"");
	DlgSetInt ( note_dlg, 1001,parse_int('|127DO=', return_str) != 0);
	DlgAddCtrl( note_dlg, DLG_CheckBox, '&Complete',DLG_PosOffset,DLG_PosOffset + 1,0,0,1002,0,"");
	DlgSetInt ( note_dlg, 1002,parse_int('|127DONE=', return_str) != 0);
	DlgAddCtrl( note_dlg, Dlg_Static, '&Text:', 1, Dlg_PosOffset + 1, 0, 0, 2002, 0, "");
	DlgAddCtrl( note_dlg, Dlg_Text, "", 1, Dlg_PosOffset + 1, 70, 11, 2100, DLGF_GetTextFromWin | DLGF_es_MultiLine | DLGF_es_WantReturn, "/ML=32000/WID=" + str(edit_window));
	DlgAddCtrl( note_dlg, DLG_BlackFrame, '',Dlg_PosOffset, Dlg_PosOffset + 12, 70, Dlg_Units | 15, 1031, 0, "" );
	DlgAddCtrl( note_dlg, Dlg_Static, "Created",Dlg_PosOffset + (Dlg_Units | 4), Dlg_PosOffset + (Dlg_Units | 2), 0, 0, 2003, 0, "");
	DlgAddCtrl( note_dlg, Dlg_Text, parse_str('|127CD=', return_str), Dlg_PosOffset + 10, Dlg_PosOffset, 20, DLGF_es_ReadOnly, 1102, 0, "");
	DlgAddCtrl( note_dlg, Dlg_Static, "Last Mod",Dlg_PosOffset + 26, Dlg_PosOffset, 0, 0, 2004, 0, "");
	DlgAddCtrl( note_dlg, Dlg_Text, parse_str('|127MD=', return_str), Dlg_PosOffset + 10, Dlg_PosOffset, 20, 0, 1103, 0, "");
	DlgAddCtrl( note_dlg, Dlg_PushButton, 'OK', 1, Dlg_PosOffset + 2, Dlg_StanBtnWidth, 0, 101, DLGF_DefButton, '/R=1');
	DlgAddCtrl( note_dlg, Dlg_PushButton, 'Cancel', Dlg_PosOffset + 12, Dlg_PosOffset , Dlg_StanBtnWidth, 0, 102, 0, '/R=0');
	DlgAddCtrl( note_dlg, Dlg_PushButton, '&Help', Dlg_PosOffset + 48, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 103, 0, '/R=2');
	return_int = DlgExecute(note_dlg, 1101, 'Edit Note', EDITNOTE_HELPLINK, '/S=' + str(start), 0);
	return_str = '|127SBJ=' + DlgGetStr(note_dlg, 1101)
				+ '|127DO=' + str(DlgGetInt(note_dlg, 1001))
				+ '|127DONE=' + str(DlgGetInt(note_dlg, 1002))
				+ '|127CD=' + DlgGetStr(note_dlg, 1102)
				+ '|127MD=' + DlgGetStr(note_dlg, 1103);
	DlgKill(note_dlg);
}


macro n_get_list
{
		str nstr[80] = global_str('~NOTEBOOK_PARMS'),
				tstr[20];

		int cat_count, jx,
				main_window = parse_int('/MW=', nstr ),
				category_window = parse_int('/CW=', nstr ),
				note_list_window = parse_int('/NW=', nstr),
				owin = window_id,
				tpb = persistent_blocks, mw
				;

		persistent_blocks = TRUE;
		switch_win_id( category_window );
		goto_col(1);
		if(at_eof)
				tof;
		if(at_eof) {
			put_line('   Default');
			switch_win_id( main_window );
			tof;
			down;
			eol;
			cr;
			put_line('   Default');
			switch_win_id( category_window );
		}
		return_str = copy( get_line, 4, 20 );
		tstr = return_str;
		pad_str( tstr, 20, ' ' );
		mark_pos;
		tof;
		reg_exp_stat = TRUE;
		while( search_fwd( '%|175', 0) ) {
			jx = line_attr;
			insert_mode = FALSE;
			text(" ");
			insert_mode = TRUE;
			line_changed = false;
			line_attr = jx;
		}
		goto_mark;
		jx = line_attr;
		put_line( '|175' + copy( get_line, 2, 22 ) );
		line_changed = false;
		line_attr = jx;
		block_begin; block_end;
		//menu_set_str( global_int('~NOTEBOOK_MENU'), parse_int('/CAT#=', nstr), 1, tstr );
		switch_win_id( main_window );
		mw = cur_window;
		block_off;
		reg_exp_stat = false;
		tof;
		if( search_fwd( '|12|12' + return_str + '~~~!', 0 )) {
			set_global_int('~NOTEBOOK_LINE', c_line );
			down;
			cat_count = c_line;
			block_begin;
			reg_exp_stat = TRUE;
			if( search_fwd( '%|12', 0 )) {
				up;
			} else {
				eof;
			}
			block_end;
			if( (block_line1 < cat_count) || ( block_line2 < cat_count ))
					block_off;
		} else {
			eof;
			if( c_col != 1)
					down;
			put_line( '|12|12' + return_str + '~~~!' );
			set_global_int('~NOTEBOOK_LINE', c_line );
			down;
		}
		switch_win_id( note_list_window );
		erase_window;
		window_copy( mw );
		block_off;
		mark_pos;                    //MNB
		eof;                         //MNB
		return_int = c_line;    		 //MNB
		goto_mark;                   //MNB
		goto_col(2);
		while( !at_eof ) {
			if( cur_char == '*' ) {
				line_attr = 0;
				line_changed = FALSE;
			}
			down;
		}
		tof;
		while(search_fwd("%",0)) {
			insert_mode = FALSE;
			text(" ");
			line_changed = FALSE;
			insert_mode = TRUE;
		}
		jx = C_LINE;
		tof;
		while(c_line < jx )
			down;
		switch_win_id( owin );
		persistent_blocks = tpb;
}

macro n_get_categories
{
		str nstr[80] = global_str('~NOTEBOOK_PARMS');

		int cat_count,
				main_window = parse_int('/MW=', nstr ),
				category_window = parse_int('/CW=', nstr ),
				owin = window_id,
				tpb = persistent_blocks, mw
				;

		persistent_blocks = TRUE;

		switch_win_id( main_window );
		mw = cur_window;
		block_off;
		reg_exp_stat = true;
		tof;
		if( search_fwd( '%|12|12|12CATEGORIES', 0 )) {
			down;
			cat_count = c_line;
			block_begin;
			if( search_fwd( '%|12', 0 )) {
				up;
			} else {
				eof;
			}
			block_end;
			if( (block_line1 < cat_count) || ( block_line2 < cat_count ))
					block_off;
		} else {
			cr;
			up;
			put_line( '|12|12|12CATEGORIES' );
			down;
			cat_count = c_line;
		}
		switch_win_id( category_window );
		erase_window;
		window_copy( mw );
		goto_col(2);
		while( !at_eof ) {
			if( cur_char == '*' ) {
				line_attr = 0;
				line_changed = FALSE;
			}
			down;
		}
		tof;
		block_off;
		switch_win_id( owin );
		persistent_blocks = tpb;
}