macro_file msglog;
/***************************************************************************
  msglog.mac

  Routines for logging of debug messages.

***************************************************************************/

#INCLUDE sprintf.sh
/*******************************************************************************
  MsgLog - 5/22/95 10:07AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

 Logs window messages to a specified log buffer.

********************************************************************************/
void MsgLog( int lognum,    // The log buffer #.  Log buffers are named
                            // "~MSGLOG-#" where # is the specifiec lognum

             str id[32],    // This str is usually used to identify the
                            //   calling routine

                            // The following parameters are the standard
                            //   Windows message parameters

             int window,    // The Windows' HWND
             int message,   // The message
             int wparam,    // The wparam
             int lparam     // The lparam
            )
{
  str mstr;
  int tr = refresh;
  refresh = false;

  int tw = cur_window;

  if(!switch_win_id( global_int("~MSGLOG-" + str(lognum))))
  {
    rm("CreateWindow");
    set_global_int("~MSGLOG-" + str(lognum), window_id);
    file_name = "MSG-" + str(lognum) + ".LOG";
  }
  refresh = true;
  eof;
  if(c_col > 1)
    down;

  switch ( message )
  {
    case 0x0000 : mstr = "wm_Null"; break;
    case 0x0001 : mstr = "wm_Create"; break;
    case 0x0002 : mstr = "wm_Destroy"; break;
    case 0x0003 : mstr = "wm_Move"; break;
    case 0x0005 : mstr = "wm_Size"; break;
    case 0x0006 : mstr = "wm_Activate"; break;
    case 0x0007 : mstr = "wm_SetFocus"; break;
    case 0x0008 : mstr = "wm_KillFocus"; break;
    case 0x000A : mstr = "wm_Enable"; break;
    case 0x000B : mstr = "wm_SetRedraw"; break;
    case 0x000C : mstr = "wm_SetText"; break;
    case 0x000D : mstr = "wm_GetText"; break;
    case 0x000E : mstr = "wm_GetTextLength"; break;
    case 0x000F : mstr = "wm_Paint"; break;
    case 0x0010 : mstr = "wm_Close"; break;
    case 0x0011 : mstr = "wm_QueryEndSession"; break;
    case 0x0012 : mstr = "wm_Quit"; break;
    case 0x0013 : mstr = "wm_QueryOpen"; break;
    case 0x0014 : mstr = "wm_EraseBkGnd"; break;
    case 0x0015 : mstr = "wm_SysColorChange"; break;
    case 0x0016 : mstr = "wm_EndSession"; break;
    case 0x0018 : mstr = "wm_ShowWindow"; break;
    case 0x0019 : mstr = "wm_CtlColor"; break;
    case 0x001A : mstr = "wm_WinIniChange"; break;
    case 0x001B : mstr = "wm_DevModeChange"; break;
    case 0x001C : mstr = "wm_ActivateApp"; break;
    case 0x001D : mstr = "wm_FontChange"; break;
    case 0x001E : mstr = "wm_TimeChange"; break;
    case 0x001F : mstr = "wm_CancelMode"; break;
    case 0x0020 : mstr = "wm_SetCursor"; break;
    case 0x0021 : mstr = "wm_MouseActivate"; break;
    case 0x0022 : mstr = "wm_ChildActivate"; break;
    case 0x0023 : mstr = "wm_QueueSync"; break;
    case 0x0024 : mstr = "wm_GetMinMaxInfo"; break;
    case 0x0026 : mstr = "wm_PaintIcon"; break;
    case 0x0027 : mstr = "wm_IconEraseBkGnd"; break;
    case 0x0028 : mstr = "wm_NextDlgCtl"; break;
    case 0x002A : mstr = "wm_SpoolerStatus"; break;
    case 0x002B : mstr = "wm_DrawItem"; break;
    case 0x002C : mstr = "wm_MeasureItem"; break;
    case 0x002D : mstr = "wm_DeleteItem"; break;
    case 0x002E : mstr = "wm_VKeyToItem"; break;
    case 0x002F : mstr = "wm_CharToItem"; break;
    case 0x0030 : mstr = "wm_SetFont"; break;
    case 0x0031 : mstr = "wm_GetFont"; break;
    case 0x0037 : mstr = "wm_QueryDragIcon"; break;
    case 0x0039 : mstr = "wm_CompareItem"; break;
    case 0x0041 : mstr = "wm_Compacting"; break;

    case 0x0081 : mstr = "wm_NCCreate"; break;
    case 0x0082 : mstr = "wm_NCDestroy"; break;
    case 0x0083 : mstr = "wm_NCCalcSize"; break;
    case 0x0084 : mstr = "wm_NCHitTest"; break;
    case 0x0085 : mstr = "wm_NCPaint"; break;
    case 0x0086 : mstr = "wm_NCActivate"; break;
    case 0x0087 : mstr = "wm_GetDlgCode"; break;
    case 0x00A0 : mstr = "wm_NCMouseMove"; break;
    case 0x00A1 : mstr = "wm_NCLButtonDown"; break;
    case 0x00A2 : mstr = "wm_NCLButtonUp"; break;
    case 0x00A3 : mstr = "wm_NCLButtonDblClk"; break;
    case 0x00A4 : mstr = "wm_NCRButtonDown"; break;
    case 0x00A5 : mstr = "wm_NCRButtonUp"; break;
    case 0x00A6 : mstr = "wm_NCRButtonDblClk"; break;
    case 0x00A7 : mstr = "wm_NCMButtonDown"; break;
    case 0x00A8 : mstr = "wm_NCMButtonUp"; break;
    case 0x00A9 : mstr = "wm_NCMButtonDblClk"; break;

    case 0x0100 : mstr = "wm_KeyFirst"; break;
    case 0x0100 : mstr = "wm_KeyDown"; break;
    case 0x0101 : mstr = "wm_KeyUp"; break;
    case 0x0102 : mstr = "wm_Char"; break;
    case 0x0103 : mstr = "wm_DeadChar"; break;
    case 0x0104 : mstr = "wm_SysKeyDown"; break;
    case 0x0105 : mstr = "wm_SysKeyUp"; break;
    case 0x0106 : mstr = "wm_SysChar"; break;
    case 0x0107 : mstr = "wm_SysDeadChar"; break;
    case 0x0108 : mstr = "wm_KeyLast"; break;

    case 0x0110 : mstr = "wm_InitDialog"; break;
    case 0x0111 : mstr = "wm_Command"; break;
    case 0x0112 : mstr = "wm_SysCommand"; break;
    case 0x0113 : mstr = "wm_Timer"; break;
    case 0x0114 : mstr = "wm_HScroll"; break;
    case 0x0115 : mstr = "wm_VScroll"; break;
    case 0x0116 : mstr = "wm_InitMenu"; break;
    case 0x0117 : mstr = "wm_InitMenuPopup"; break;
    case 0x011F : mstr = "wm_MenuSelect"; break;
    case 0x0120 : mstr = "wm_MenuChar"; break;
    case 0x0121 : mstr = "wm_EnterIdle"; break;


    case 0x0200 : mstr = "wm_MouseFirst"; break;
    case 0x0200 : mstr = "wm_MouseMove"; break;
    case 0x0201 : mstr = "wm_LButtonDown"; break;
    case 0x0202 : mstr = "wm_LButtonUp"; break;
    case 0x0203 : mstr = "wm_LButtonDblClk"; break;
    case 0x0204 : mstr = "wm_RButtonDown"; break;
    case 0x0205 : mstr = "wm_RButtonUp"; break;
    case 0x0206 : mstr = "wm_RButtonDblClk"; break;
    case 0x0207 : mstr = "wm_MButtonDown"; break;
    case 0x0208 : mstr = "wm_MButtonUp"; break;
    case 0x0209 : mstr = "wm_MButtonDblClk"; break;
    case 0x0209 : mstr = "wm_MouseLast"; break;

    case 0x0210 : mstr = "wm_ParentNotify"; break;
    case 0x0220 : mstr = "wm_MDICreate"; break;
    case 0x0221 : mstr = "wm_MDIDestroy"; break;
    case 0x0222 : mstr = "wm_MDIActivate"; break;
    case 0x0223 : mstr = "wm_MDIRestore"; break;
    case 0x0224 : mstr = "wm_MDINext"; break;
    case 0x0225 : mstr = "wm_MDIMaximize"; break;
    case 0x0226 : mstr = "wm_MDITile"; break;
    case 0x0227 : mstr = "wm_MDICascade"; break;
    case 0x0228 : mstr = "wm_MDIIconArrange"; break;
    case 0x0229 : mstr = "wm_MDIGetActive"; break;
    case 0x0230 : mstr = "wm_MDISetMenu"; break;

    case 0x0300 : mstr = "wm_Cut"; break;
    case 0x0301 : mstr = "wm_Copy"; break;
    case 0x0302 : mstr = "wm_Paste"; break;
    case 0x0303 : mstr = "wm_Clear"; break;
    case 0x0304 : mstr = "wm_Undo"; break;
    case 0x0305 : mstr = "wm_RenderFormat"; break;
    case 0x0306 : mstr = "wm_RenderAllFormats"; break;
    case 0x0307 : mstr = "wm_DestroyClipboard"; break;
    case 0x0308 : mstr = "wm_DrawClipboard"; break;
    case 0x0309 : mstr = "wm_PaintClipboard"; break;
    case 0x030A : mstr = "wm_VScrollClipboard"; break;
    case 0x030B : mstr = "wm_SizeClipboard"; break;
    case 0x030C : mstr = "wm_AskCBFormatName"; break;
    case 0x030D : mstr = "wm_ChangeCBChain"; break;
    case 0x030E : mstr = "wm_HScrollClipboard"; break;
    case 0x030F : mstr = "wm_QueryNewPalette"; break;
    case 0x0310 : mstr = "wm_PaletteIsChanging"; break;
    case 0x0311 : mstr = "wm_PaletteChanged"; break;
    case 0x0048 : mstr = "wm_Power"; break;
    case 0x0017 : mstr = "wm_SystemError"; break;
    case 0x0044 : mstr = "wm_CommNotify"; break;

    case 0x0046 : mstr = "wm_WindowPosChanging"; break;
    case 0x0047 : mstr = "wm_WindowPosChanged"; break;
    case 0x0233 : mstr = "wm_DropFiles"; break;

    case 0x0380 : mstr = "wm_PenWinFirst"; break;
    case 0x038F : mstr = "wm_PenWinLast"; break;

    case 0x0390 : mstr = "wm_Coalesce_First"; break;
    case 0x039F : mstr = "wm_Coalesce_Last"; break;

    default:
        if(message >= 0x400)
        {
          mstr = "wm_user + 0x" + hex_str(message - 0x400);
        }
        else
        {
          mstr = "unknown 0x" + hex_str(message);
        }
  }

  pad_str( mstr, 22, " " );
  str wp[6] = hex_str(wparam & 0xffff),
      lp[10] = hex_str(lparam) ;

  wp = copy("0000", 1, 4 - svl(wp) ) + wp;
  lp = copy("00000000", 1, 8 - svl(lp) ) + lp;
  put_line( id + ": " + caps( mstr ) + " WP: 0x" + wp + "  LP: 0x" + lp );

  refresh = false;
  switch_window( tw );
  refresh = tr;
} // MsgLog


/*******************************************************************************
  DebugLog - 5/22/95 10:07AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

 Logs debugging messages to a specified log buffer.

********************************************************************************/
void DebugLog( int lognum,    // The log buffer #.  Log buffers are named
                            // "~MSGLOG-#" where # is the specifiec lognum

             str id[32],    // This str is usually used to identify the
                            //   calling routine

                            // The following parameters are the standard
                            //   Windows message parameters

             str msg,       // The specified message.  Fully supports
                            //   sprintf formatting

             ...            // Additional parms
             )

{
  int tr = refresh;
  refresh = false;

  str mstr;
  int tw = cur_window;

  if(!switch_win_id( global_int("~MSGLOG-" + str(lognum))))
  {
    rm("CreateWindow");
    set_global_int("~MSGLOG-" + str(lognum), window_id);
    file_name = "MSG-" + str(lognum) + ".LOG";
  }
  refresh = true;
  eof;
  if(c_col > 1)
    down;

  sprintf( mstr, msg, optional_params );
  put_line( id + ": " +  mstr);

  refresh = false;
  switch_window( tw );
  refresh = tr;
} // DebugLog
































