// $Header: /MeWin/Src/MEWSETUP.S 163   4/17/96 4:27p Todd $

macro_file mewsetup;

//#DEFINE MEWDEMO

#include windows.sh
#include metools.sh
#include fonts.sh
#include winexec.sh
#include dialog.sh
#include mew_dlgs.sh
#include tbwin.sh
#include exit.sh
#include db.sh
#include mew.sh
#include fprompt.sh
#include mewlib.sh

#define SRCHDEF_HELPLINK      "SEARCH DEFAULTS"
#define SRCHREPDEF_HELPLINK   "SEARCH AND REPLACE DEFAULTS"
#define FNAMEEXT_HELPLINK     "FILENAME EXTENSION SETUP"
#define MAINSRCHDEF_HELPLINK  "SEARCH DEFAULTS, CONFIGURING"
#define MFSRCHDEF_HELPLINK    "MULTI-FILE SEARCH DEFAULTS"
#define MSRCHREPDEF_HELPLINK  "MULTI-FILE SEARCH AND REPLACE DEFAULTS"
#define BACKTMPAUTO_HELPLINK  "BACKUPS/TEMP FILES/AUTOSAVE"
#define MEMUSE_HELPLINK       "MEMORY USAGE"
#define USERINTR_HELPLINK     "USER INTERFACE, CONFIGURING"
#define CUSTOMIZE_HELPLINK    "CUSTOMIZE DIALOG BOX"
#define EDITSETT_HELPLINK     "EDIT SETTINGS"
#define BLOCKOP_HELPLINK      "BLOCK SETTINGS"

global
{
	int _reset_screen;
}

macro CHECK_SETUP TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  CHECK_SETUP

Description:  Checks for configuration changed and prompts the user to save.

Parameters:
							/X=   X coordinate for menu box
							/Y=   Y coordinate for menu box

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

#ifdef DEMO
	Set_Global_Int('SETUP_CHANGED',0);
#else
	if(global_int("SETUP_CHANGED"))
	{
		rm("SETSAVE");
	}
#endif // DEMO
	return_int = 1;
}

void Customize()
{
	int start_num = 17, tw = window_id, tr = refresh;
	int tundo = undo_stat, bw = 30, bh = DLG_Units | DLG_Units_Line_Half;

	int dlg;

	undo_stat = false;
	refresh = false;

	DlgCreate(dlg);

	rm("CmdSetMgr /M=1");


	DlgAddCtrl( dlg, DLG_BlackFrame, "", 1,DLG_Units | 5,34,DLG_Units | ((Dlg_Units_Per_Line * 8) + DLG_Units_HLine),901,0,"" );
  DlgAddctrl( dlg, DLG_Static, "Comma&nd set:", DLG_PosOffset + 1, DLG_PosOffset, 0, 0, 910, 0, "" );
	DlgAddCtrl( dlg, DLG_MacroBtnStr, return_str, DLG_PosOffset, DLG_PosOffset | 1, 31, 0, 2400, 0, "/M=CmdSetMgr" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_106 &Keys/Commands...", DLG_PosOffset,DLG_PosOffset | DLG_Units | DLG_Units_Line_Half,bw,bh, 1401, 0, "/M=CommandMapEdit" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_107 &Menus...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1409, 0, "/M=Menus^MenuEditor" );
  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_GN_111 &Toolbars/boxes...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1410, 0, "/M=TBMGR" );
	bw = 24;
  DlgAddCtrl( dlg, DLG_BlackFrame, "", 38, DLG_Units | 5, 53,DLG_Units | ((Dlg_Units_Per_Line * 16)),941,0,"" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_101 &Edit settings...", DLG_PosOffset + 1,DLG_PosOffset,bw,bh, 1001, 0, "/M=SETEDIT" );
  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_BL_100 &Block settings...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1015, 0, "/M=SETBLOCK" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_103 Memor&y, program execution...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1002, 0, "/M=SETMEMORY" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SR_100 &Search defaults...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1006, 0, "/M=SrchSet" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_FL_102 Backups, temp f&iles, autosave...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1005, 0, "/M=SetMEPaths" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_104 Filename e&xtensions...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1011, 0, "/M=Extens" );
  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_ED_115 Spell&check...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1031, 0, "/M=Spell^SpellSetup" );
  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_TAGS_100 Ta&gs...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1033, 0, "/M=METAGS^TAG_CONFIGURE" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_100 &User interface...", DLG_PosOffset + bw + 2,DLG_Units | 5,bw,bh, 1003, 0, "/M=INTERFACESETUP" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_102 &Fonts...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1004, 0, "/M=SetupDefFonts" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_105 C&olors...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1007, 0, "/M=SetupDefColors" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_FL_114 File comp&are...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1008, 0, "/M=FC^FC_CONFIG" );
	DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_SETUP_108 &Languages...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1012, 0, "/M=LANGUAGE^Lang_Menu /LM=0" );
  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_GN_116 Tem&plates...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh,1040 , 0, "/M=Template^Tmp_Edit /NM=1" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_VCS_100 &VCS interface...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1030, 0, "/M=VCS^VCSCONFIGURE" );

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_GN_121 &Restore, session manager...", DLG_PosOffset,DLG_PosOffset + 2,bw,bh, 1032, 0, "/M=SESSMGR^SM_CONFIGURE" );
	DlgAddCtrl( dlg, DLG_PushButton, "Close",
				1, DLG_PosOffset | 1
						, DLG_StanBtnWidth, 0, 2101, 0, "/R=0");

	DlgAddCtrl( dlg, DLG_PushButton, "&Help",
				20, DLG_PosOffset, DLG_StanBtnWidth, 0, 2102, 0, "/R=2");

	DlgExecute( dlg, 2101, "Customize",	CUSTOMIZE_HELPLINK, "" , 0 );

	DlgKill(dlg);

	if(global_int("SETUP_CHANGED"))
	{
    if ( global_int ("SETUP_CHANGED") & $8000 ) // Dialog font change
    {
      SetDialogFont (parse_str("/NAMEDLG=" , DefaultFont),
                      parse_int("/SIZEDLG=" , DefaultFont),
                      parse_int("/WTDLG=", DefaultFont), 0);

      RedrawWindow( frame_handle, 0, 0, RDW_UPDATENOW | RDW_INVALIDATE | RDW_ALLCHILDREN );
      SendMessage ( frame_handle, WM_PARENTSIZE, 0, 0);

    }
		rm("SETSAVE");
	}

	switch_win_id(tw);
	undo_stat = tundo;
	refresh = tr;
	return();

}


global
{
  str CmdSetMgrTmp  "~CMDSETMGR_TMP";
  str Csm_Copied    "@CSM_CopiedRec";
}

void CmdSetMgr( int m = parse_int("/M=", mparm_str ))
{
	int tw = window_id;
	str tstr[100] = "Command Set Manager";


	if( !LocateDbPage( "MECONFIG", "CMDMAPLIST.DB", false ) )
	{
		if( LocateDbPage( "MECONFIG", "CMDMAPLIST.DB", true ) )
		{
			eol;
			cr;
			put_line( "NAME=DefaultFN=WCMDMAP" );
		}
	}
	switch_win_id(tw);
	switch ( m )
	{
		case 2 :
			{
				int dlg;
				DlgCreate(dlg);

  			DlgAddCtrl( dlg, DLG_BlackRect, "", 1,DLG_Units | 4, 60, 7, -1,0, "" );

  			DlgAddCtrl( dlg, DLG_Icon, "IC_HAND", 2, 1, 0,0,-1,0, "" );

  			DlgAddCtrl( dlg, Dlg_Static, ""
         , 9, DLG_Units | 3, 50, 7, 2001, 0, "");

				DlgSetStr(dlg, 2001, "You will now be asked to select a command/key map.  " +
				 "The command map you you choose will be used whenever an add-on option like Delphi Integration or EVOLVE adds commands.  " +
				 "If you change command maps after installing an add-on option, you will need to re-install that option.  " +
				 "\r\n\nNOTE: The default command map is Windows/CUA compliant.");

  			DlgAddCtrl( dlg, DLG_PushButton, "OK", 25, DLG_PosOffset + 8, DLG_StanBtnWidth, 0, 201, DLGF_DefButton, "/R=1");
  			//DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + Dlg_StanBtnWidth + 1, DLG_PosOffset, Dlg_StanBtnWidth, 0, 202, 0, "/R=0");
  			//DlgAddCtrl( dlg, DLG_PushButton, "&Help", DLG_PosOffset + 39, DLG_PosOffset, Dlg_StanBtnWidth, 0, 203, 0, "/R=2");

  			DlgExecute( dlg, 201, "Initial Setup", "", "", 0);
				DlgKill(dlg);
				tstr = "Please select a Command Map";
			}
		case 0 :
				str fstr = return_str;
				if(db( "MECONFIG", "CMDMAPLIST.DB", "MEWHDRS.DB", "CMDMAPLIST.HDR", tstr,
								"Command Set Manager","~CMDSETMGR_TMP", 1, "/PRE=@CSM_/NCP=1/NDH=1/MOVE=1/H=" + str(0) +
								"/FV=" + fstr + "/EMAC=CMDSETMGR_EDIT"  ))
				{

					if( LocateDbPage( wcmdmapname, "WCMDMAP.DB", false ) )
					{
						if(file_changed)
							save_file;
						delete_window;
					}

					wcmdmapname = parse_str( "FN=", CmdSetMgrTmp );
          wcmdmapinit = parse_str( "IM=", CmdSetMgrTmp );

					RebuildWcmds();

					Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
					return_str = parse_str("NAME=", CmdSetMgrTmp );
				}
				else
				{
					call get_cmdset;
					return_int = 1;
				}
				CmdSetMgrTmp = "";
				break;

		case 1 :
					call get_cmdset;
					return_int = 1;
					break;

	}
	switch_win_id(tw);
	return();

get_cmdset:
	if(GetDbRecord("MECONFIG", "CMDMAPLIST.DB", "FN", wcmdmapname,
				0,0, "~CMDSETMGR_TMP", false, "" ) )
	{
		return_str = parse_str("NAME=", CmdSetMgrTmp );
	}
	else
	{
		return_str = wcmdmapname;
	}
	ret;
}

void CmdSetMgr_Edit(  )
{

	int tw = window_id;
	int copying = parse_int("/COPY=", mparm_str);
	int creating = parse_int("/CREATE=",mparm_str);
	int dlg, result;

	str orig_name[128] = parse_str("NAME=", CmdSetMgrTmp);
  str orig_fn[260] = parse_str("FN=", CmdSetMgrTmp);
  str orig_init_macro[128] = parse_str("IM=", CmdSetMgrTmp);
	str tstr;
	int j = 1;


	orig_fn = Caps(Truncate_Path(Truncate_Extension( orig_fn ) ) );

	str name[128] = orig_name;
  str fn[260] = orig_fn;
  str init_macro[128] = orig_init_macro;
	str hook_str = "";
	str dlg_name = "Edit Command Set";

	DlgCreate(dlg);

	if( copying )
	{
		dlg_name = "Copy Command Set";
		hook_str = "/HOOK=CmdSetMgrHook";
		name = "<new command map description>";
		fn = "<net command map filename>";
    DlgAddCtrl( dlg, Dlg_GroupBox, "Copy", 1,1,56, 3,2200, 0,"" );
		DlgAddCtrl( dlg, DLG_Static, "Description:", 2, DLG_PosOffset + 1, 0, 0, 2100, 0, "");
		DlgAddCtrl( dlg, DLG_Static, orig_name, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 2150, 0, "");
		DlgAddCtrl( dlg, DLG_Static, "Filename:", 2, Dlg_PosOffset + 1, 0, 0, 2101, 0, "");
		DlgAddCtrl( dlg, DLG_Static, orig_fn, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 2151, 0, "");
    tstr = "To";
		j = 2;
		DlgAddCtrl( dlg, Dlg_GroupBox, tstr, 1, Dlg_PosOffset + j,56,
				DLG_Units | ((Dlg_Units_Per_Line * 3) + Dlg_Units_QLine),2201, 0,"" );
	}
	else
	{
		if(creating)
		{
			dlg_name = "Import(Insert) Command Set";
		}
		j = 1;
		tstr = "Edit:";
	}

	DlgAddCtrl( dlg, DLG_Static, "&Description:", j, DLG_PosOffset + 1, 0, 0, 2000, 0, "");
	DlgAddCtrl( dlg, DLG_Text, name, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 1000, 0, "");

	DlgAddCtrl( dlg, DLG_Static, "&Filename:", j, Dlg_PosOffset + 1, 0, 0, 2001, 0, "");
	DlgAddCtrl( dlg, DLG_Text, fn, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 1001, 0, "/ML=128");

  DlgAddCtrl( dlg, DLG_Static, "&Init macro:", j, Dlg_PosOffset + 1, 0, 0, 2002, 0, "");
  DlgAddCtrl( dlg, DLG_Text, init_macro, DLG_PosOffset + 13, Dlg_PosOffset, 40, 0, 1002, 0, "/ML=128");

	DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset + j + 1, DLG_StanBtnWidth, 0, 100, DLGF_DefButton, "/R=1");
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0, 101, 0, "/R=0");
	DlgAddCtrl( dlg, DLG_PushButton, "&Help", 46, DLG_PosOffset, DLG_StanBtnWidth, 0, 102, 0, "/R=2");

	result = DlgExecute(dlg, 1000, dlg_name, "","/PARENT=" + parse_str("/DLGHANDLE=", mparm_str) + hook_str, 0 );

	if(result == 1)
	{
		 name = DlgGetStr( dlg, 1000 );
		 fn = Caps(Truncate_Path(Truncate_Extension(DlgGetStr( dlg, 1001 ))));
     init_macro = DlgGetStr( dlg, 1002 );
     CmdSetMgrTmp = "NAME=" + name + "FN=" + fn + "IM=" + init_macro;

		 if(copying)
		 {
			 fn = CreateUserPath( fn + ".DB", false );
			 if( LocateDbPage( orig_fn, "WCMDMAP.DB", false ) )
			 {
				if(file_changed)
					save_file;
				file_name = fn;
				save_file;
			 }
		 }
	}

	DlgKill(Dlg);

	return_int = result;
	switch_win_id(tw);
}

int CmdSetMgrHook( int &retval, int window, message, wparam, lparam, str parms ) no_break
{
	switch ( message )
	{
		case WM_COMMAND :
				if( wparam == 100 )
				{
					str fn[128], orig_fn[128] = "", estr[80];
					SendDlgItemMessageStr( window, 1001, WM_GETTEXT, 127, fn );

					int for_copy = ( GetDlgItem(window,2151) != 0 );
					if(for_copy)
					{
						SendDlgItemMessageStr( window, 2151, WM_GETTEXT, 127, orig_fn );
					}

					if(xpos("<", fn,1))
					{
						estr = "Valid filename required";
						goto ok_error;
					}
					else
					{
						fn = Caps(Truncate_Path(Truncate_Extension( fn ) ) );
						SendDlgItemMessageStr( window, 1001, WM_SETTEXT, svl(fn), fn );
						if( orig_fn == fn )
						{
							estr = "Unique filename required!";
							goto ok_error;
						}
					}
					if(file_exists(createuserpath(fn + ".DB", false)))
					{
						estr = fn + ".DB already exists.  Please choose new filename.";
						goto ok_error;
					}
					break;

				ok_error:
					beep;
					MessageBox( window, estr, "Data Entry Error", MB_OK | MB_ICONSTOP );
					SetFocus( GetDlgItem( window, 1001 ) );
					SendDlgItemMessage( window, 1001, EM_SETSEL, 0, Make_Long( 0, -1 ) );
					return(1);
				}
				break;

	}
	return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));

}

void _KeepChange( int Dlg = Parse_Int( "/DLGHANDLE=", MParm_Str ) )
/******************************************************************************
															 Multi-Edit Macro
															 18-Dec-95  13:39

	Function: `description`
	Entry   : `entry`
	Exit    : `exit`

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	int Enable = SendMessage( GetDlgItem( Dlg, 1105 ), bm_GetCheck, 0, 0 );

  EnableWindow( GetDlgItem( Dlg, 207 ), Enable );
  EnableWindow( GetDlgItem( Dlg, 1107 ), Enable );

}  // _KeepChange

void SetMemory()
{
	int dlg;
	int CtrlId = 100;
	DlgCreate( dlg );

	DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SETUP_103", 1, 1, 0,0, 1000, 0, "" );
	DlgAddCtrl( dlg, DLG_Static, '&Max % of Windows memory to use(1-90):',
					2, 3, 0,0, CtrlId, 0, "" );
	DlgAddCtrl( dlg, DLG_Integer, "", DLG_PosOffset + 39, DLG_PosOffset, 5, 0, 1002, 0, "/MIN=1/MAX=99");
	DlgSetInt( dlg, 1002, memory_percentage );


	DlgAddCtrl( dlg, DLG_GroupBox, "Execute DOSEXEC.EXE", 2, DLG_PosOffset | 2, 40, 3, ++CtrlId, 0, "" );
	DlgAddCtrl( dlg, DLG_RadioButton, "&Directly", DLG_PosOffset | 1, DLG_PosOffset | 1, 0, 0, 1101,0,"" );
	DlgSetInt( dlg, 1101, DosExecMethod == _DosExec_Direct );
	DlgAddCtrl( dlg, DLG_RadioButton, "&Via DOSEXEC.PIF", DLG_PosOffset, DLG_PosOffset | 1, 0, 0, 1102,0,"" );
	DlgSetInt( dlg, 1102, DosExecMethod == _DosExec_PIF );

	// Not implemented yet
 // DlgAddCtrl( dlg, DLG_RadioButton, "&Through SHELL VM", DLG_PosOffset, DLG_PosOffset | 1, 0, 0, 1103,0,"" );
 // DlgSetInt( dlg, 1103, DosExecMethod == _DosExec_ExecVM );

	DlgAddCtrl( Dlg, dlg_GroupBox, "Exec options",
		2, dlg_PosOffset + 2,
		40, 5,
		++CtrlId, 0, "" );

	DlgAddCtrl( Dlg, dlg_CheckBox, "&Use W32EXEC on NT",
			dlg_PosOffset + 1, dlg_PosOffset + 1,
			0, 0,
			1108, 0, "" );
	DlgSetInt( Dlg, 1108, g_UseW32Exec );

  DlgAddCtrl( Dlg, dlg_CheckBox, "&No output in window",
			dlg_PosOffset + 0, dlg_PosOffset + 1,
			0, 0,
			1106, 0, "" );
	DlgSetInt( Dlg, 1106, ExecNoDisplay != False );

  DlgAddCtrl( Dlg, dlg_CheckBox, "&Keep running",
			dlg_PosOffset + 0, dlg_PosOffset + 1,
			0, 0,
			1105, 0, "/CHANGEMAC=_KeepChange" );
	DlgSetInt( Dlg, 1105, ExecKeep != False );

	DlgAddCtrl( Dlg, dlg_Static, "&On Exit",
			dlg_PosOffset + 3, dlg_PosOffset + 1,
			0, 0,
			207, 0, "" );
	DlgAddCtrl( Dlg, dlg_Choice, "Shutdown()Prompt()Keep()",
			dlg_PosOffset + 9, dlg_PosOffset + 0,
			15, 0,
			1107, 0, "" );
	DlgSetInt( Dlg, 1107, ExecShutdown + 1 );

	DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset + 2, DLG_StanBtnWidth, 0, 2001, DLGF_DefButton, "/R=1");
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + DLG_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0, 2000, 0, "/R=0");
	DlgAddCtrl( dlg, DLG_PushButton, "&Help", 38, DLG_PosOffset, DLG_StanBtnWidth, 0, 2002, 0, "/R=2");


	if(DlgExecute( dlg, 1002, "Memory Usage, DOS Program Execution", MEMUSE_HELPLINK,
			"/PARENT=" + parse_str("/DLGHANDLE=", mparm_str) + "/INITMAC=_KeepChange", 0 ) )
	{
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
		memory_percentage = DlgGetInt( dlg, 1002 );
		if ( DlgGetInt( dlg,1101 ) ) {
			DosExecMethod = _DosExec_Direct;
		}
		else if ( DlgGetInt( dlg,1102 ) ) {
			DosExecMethod = _DosExec_PIF;
		}
	//  else if(DlgGetInt( dlg,1103 ))
	//  {
	//    DosExecMethod = _DosExec_ExecVM;
	//  }
		ExecKeep = DlgGetInt( Dlg, 1105 );
		ExecNoDisplay = DlgGetInt( Dlg, 1106 );
		ExecShutdown = DlgGetInt( Dlg, 1107 ) - 1;
		g_UseW32Exec = DlgGetInt( Dlg, 1108 );
	}
	DlgKill( dlg );
	return_int = 0;
	return();
}


#define Ruler_Ctrl_ID 1050
#define Ruler_All_ID  1051
/*******************************************************************************
  UserCtrl - 9/21/95 4:51PM

 Parameters:

 Returns:

 by John K. Perona, Copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
void RulerCtrl( int dlg= parse_int("/DLGHANDLE=", mparm_str),
               int id = parse_int("/CTRLID=", mparm_str) )
{
  int flag = TRUE;
  int oid;

  if ( id == Ruler_Ctrl_Id )
  {
    oid = Ruler_All_Id;
  }
  else if ( id == Ruler_All_Id )
  {
    oid = Ruler_Ctrl_Id;
  }
  else
  {
    return ();
  }

  if ( SendDlgItemMessage (dlg, id, BM_GETCHECK, 0, 0))
  {
    flag = FALSE;
    SendDlgItemMessage (dlg, oid, BM_SETCHECK, 0, 0);
  }
  EnableWindow (GetDlgItem (dlg, oid), flag);
  return ();
} // UserCtrl


macro InterfaceSetup TRANS2 NO_BREAK
{
/*******************************************************************************
																MULTI-EDIT MACRO

Name: INTERFACESETUP

Description: A dialog box to configure user interface preferences.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int dlg;
  int flags;

	DlgCreate( dlg );

	DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SETUP_100",1,1,8,0,150,0,"");
  DlgAddCtrl( dlg, DLG_GroupBox, 'Options',7, 1, 48, 13, 2001, 0, "" );

//	DlgAddCtrl( dlg, DLG_CheckBox, '&Overlap split window borders',DLG_PosOffset + 1,DLG_PosOffset + 1,0,0,1001,0,"");
//	DlgSetInt( dlg, 1001,Global_Int('SPLIT_EDGE_MODE') == 0);

	DlgAddCtrl( dlg, DLG_CheckBox, '&Auto-arrange compiler error window',DLG_PosOffset + 1, DLG_PosOffset + 1,0,0,1002,0,"");
	DlgSetInt( dlg, 1002,Global_Int('!AutoArrangErrSrc'));

  DlgAddCtrl( dlg, DLG_CheckBox, '&Confirm file overwrites',DLG_PosOffset,DLG_PosOffset + 1,0,0,1005,0,"");
	DlgSetInt( dlg, 1005,!Global_Int("NO_CONFIRM_OVERWRITE"));

	DlgAddCtrl( dlg, DLG_CheckBox, '&Bypass compiler menus with only 1 entry',DLG_PosOffset,DLG_PosOffset + 1,0,0,1006,0,"");
	DlgSetInt( dlg, 1006,Global_Int('@PGM_MENU_BYPASS'));

	DlgAddCtrl( dlg, DLG_CheckBox, '&Saving file clears line-changed highlighting',DLG_PosOffset,DLG_PosOffset + 1,0,0,1025,0,"");
	DlgSetInt( dlg, 1025, save_resets_changed );

  DlgAddCtrl( dlg, DLG_CheckBox, 'Outline current &line',DLG_PosOffset,DLG_PosOffset + 1,0,0,1030,0,"");
	DlgSetInt( dlg, 1030, cl_focus_rect);

	DlgAddCtrl( dlg, DLG_CheckBox, 'Al&ways have at least one window open',DLG_PosOffset,DLG_PosOffset + 1,0,0,1040,0,"");
	DlgSetInt( dlg, 1040, !nofile_hidden );

	DlgAddCtrl( dlg, DLG_CheckBox, 'Place dialog buttons on &righthand side',DLG_PosOffset,DLG_PosOffset + 1,0,0,1041,0,"");
	DlgSetInt( dlg, 1041, BtnOnRight );

  DlgAddCtrl( dlg, DLG_CheckBox, 'Place &message line on lefthand side',DLG_PosOffset,DLG_PosOffset + 1,0,0,1042,0,"");
  DlgSetInt( dlg, 1042, MsgOnLeft );


  DlgAddCtrl( dlg, DLG_CheckBox, 'Create first window maximi&zed',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1031, 0, "");
  DlgSetInt( dlg, 1031, Global_Int ("@Maximize_Windows"));

  DlgAddCtrl( Dlg, dlg_CheckBox, "&Delete error window on no errors",
			dlg_PosOffset, dlg_PosOffset + 1,
			0, 0,
			1044, 0, "" );
  DlgSetInt( dlg, 1044, Global_Int( "&DelErrWin" ) );


  flags = 0;
  if ( g_DefaultRuler )
  {
    flags = DLGF_Disable;
  }
  DlgAddCtrl( dlg, DLG_CheckBox, '&Ruler control affects all windows',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, Ruler_All_Id, flags, "/CHANGEMAC=RulerCtrl");
  DlgSetInt( dlg, Ruler_All_Id, g_DefaultAllRuler);

  flags = 0;
  if ( g_DefaultAllRuler )
  {
    flags = DLGF_Disable;
  }
  DlgAddCtrl( dlg, DLG_CheckBox, 'Crea&te windows with a ruler',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, Ruler_Ctrl_Id, flags, "/CHANGEMAC=RulerCtrl");
  DlgSetInt( dlg, Ruler_Ctrl_Id, g_DefaultRuler);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Caret', 57, 1, 35, 4, -1, 0, "" );

  DlgAddCtrl( dlg, DLG_Static, '&Insert:', DLG_PosOffset + 2, 2, 0, 0, -1, 0, "");

  DlgAddCtrl( dlg, DLG_Choice, 'Thin()1/2()1/3()Full()', DLG_PosOffset, Dlg_PosOffset | DLg_Units | 10, 14, 5, 1401, 0, "");
  DlgSetInt( dlg, 1401, (ins_cursor & 0x7f) + 1 );

  DlgAddCtrl( dlg, DLG_CheckBox, 'Horiz', DLG_PosOffset + 2, DLG_PosOffset + 1, 0, 0, 1032, 0, "");
	DlgSetInt( dlg, 1032, (Ins_Cursor & 0x80) != 0);

  DlgAddCtrl( dlg, DLG_Static, '&Overwrite:', DLG_PosOffset + 16,  2, 0, 0, -1, 0, "");
  DlgAddCtrl( dlg, DLG_Choice, 'Thin()1/2()1/3()Full()', DLG_PosOffset, Dlg_PosOffset | DLg_Units | 10, 14, 5, 1402, 0, "");
  DlgSetInt( dlg, 1402, (ovr_cursor & 0x7f) + 1 );

  DlgAddCtrl( dlg, DLG_CheckBox, 'Horiz', DLG_PosOffset + 2, DLG_PosOffset + 1, 0, 0, 1033, 0, "");
	DlgSetInt( dlg, 1033, (Ovr_Cursor & 0x80) != 0);



  DlgAddCtrl( dlg, DLG_GroupBox, 'File Prompt Options', 57, Dlg_PosOffset | DLG_Units | 18, 35, 5, -1, 0, "" );

  DlgAddCtrl( dlg, DLG_CheckBox, '"E&xplorer" style',DLG_PosOffset + 1,DLG_PosOffset + 1,0,0,1043,0,"");
  DlgSetInt( dlg, 1043, Fprompt_Mode & _FPM_EXPLORER );

  DlgAddCtrl( dlg, DLG_CheckBox, '&Use mask from last file',DLG_PosOffset,DLG_PosOffset + 1,0,0,1700,0,"");
  DlgSetInt( dlg, 1700, Fprompt_Mode & _FPM_LASTMASK );

  DlgAddCtrl( dlg, DLG_CheckBox, 'Use &path from last file',DLG_PosOffset,DLG_PosOffset + 1,0,0,1702,0,"");
  DlgSetInt( dlg, 1702, Fprompt_Mode & _FPM_LASTPATH );

  DlgAddCtrl( dlg, DLG_CheckBox, 'Clear mas&k on startup',DLG_PosOffset,DLG_PosOffset + 1,0,0,1701,0,"");
  DlgSetInt( dlg, 1701, Fprompt_Mode & _FPM_CLEARMASKSTART);


  DlgAddCtrl( dlg, DLG_Static, 'Toolbar pop-up help delay (in 10ths of a second):', 57, Dlg_PosOffset + 2, 28, 2, 2004,0,"");
  DlgAddCtrl( dlg, DLG_Integer, "" ,DLG_PosOffset + 28 ,DLG_PosOffset,5,0,1200,0,"/MIN=1/MAX=100");
	DlgSetInt( dlg, 1200, Global_Int("TOOLHELPDELAY"));

  DlgAddCtrl( dlg, DLG_Static, 'Max items in History lists:', 57, Dlg_PosOffset | Dlg_Units | 18, 28, 2, 2005,0,"");
  DlgAddCtrl( dlg, DLG_Integer, "" ,DLG_PosOffset + 28 ,DLG_PosOffset,5,0,1201,0,"/MIN=15/MAX=100");
  DlgSetInt( dlg, 1201, Global_Int("@HISTORY_LENGTH") + 1);



  DlgAddCtrl( dlg, DLG_PushButton, "OK",    1, 15,Dlg_StanBtnWidth,0,100,DLGF_DefButton,"/R=1");
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel",DLG_PosOffset  + Dlg_StanBtnWidth + 2,DLG_PosOffset,Dlg_StanBtnWidth,0,101,0,"/R=0");
	DlgAddCtrl( dlg, DLG_PushButton, "&Help", 79,DLG_PosOffset,Dlg_StanBtnWidth,0,102,0,"/R=2");

  if(DlgExecute( dlg, 1002, "User Interface Setup",
    USERINTR_HELPLINK , "/PARENT=" + parse_str("/DLGHANDLE=", mparm_str), 0 ))
	{
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);

		int tcl = cl_focus_rect;
    Cl_Focus_Rect           = DlgGetInt( dlg, 1030);
    Save_Resets_Changed     = DlgGetInt( dlg, 1025);
    Nofile_Hidden           = !DlgGetInt( dlg, 1040);
    BtnOnRight              = DlgGetInt( dlg, 1041);
    MsgOnLeft               = DlgGetInt( dlg, 1042);
    g_DefaultRuler          = DlgGetInt( dlg, Ruler_Ctrl_Id);
    g_DefaultAllRuler       = DlgGetInt( dlg, Ruler_All_Id);

		Set_Global_Int( "&DelErrWin", DlgGetInt( Dlg, 1044 ) );
    Set_Global_Int('@History_Length',   DlgGetInt(dlg, 1201) - 1);
//    Set_Global_Int('Split_Edge_Mode',   DlgGetInt(dlg,1001) == 0 );
		Set_Global_Int('!AutoArrangErrSrc', DlgGetInt(dlg,1002) );
    Set_Global_Int("@Maximize_Windows", DlgGetInt (dlg, 1031));
    Set_Global_Int("No_Confirm_Overwrite", !DlgGetInt(dlg,1005));
    Set_Global_Int('@Pgm_Menu_Bypass',DlgGetInt(dlg,1006));
    Set_Global_Int("Toolhelpdelay",DlgGetInt( dlg, 1200));
    ToolboxSetPopupDelay( Global_Int("Toolhelpdelay") * 100 );

    Ins_Cursor = DlgGetInt(dlg,1401) - 1;
    Ovr_Cursor = DlgGetInt(dlg,1402) - 1;
		if ( DlgGetInt(dlg, 1032) ) {
			Ins_Cursor = Ins_Cursor | 0x80;
		} else {
			Ins_Cursor = Ins_Cursor & 0x7F;
		}
		if ( DlgGetInt(dlg, 1033) ) {
			Ovr_Cursor = Ovr_Cursor | 0x80;
		} else {
			Ovr_Cursor = Ovr_Cursor & 0x7F;
		}

    fprompt_mode            = DlgGetInt( dlg, 1043);
    if(DlgGetInt(dlg,1700))
    {
      fprompt_mode |= _FPM_LASTMASK;
    }
    if(DlgGetInt(dlg,1701))
    {
      fprompt_mode |= _FPM_CLEARMASKSTART;
    }

    if(DlgGetInt(dlg,1702))
    {
      fprompt_mode |= _FPM_LASTPATH;
    }


    SendMessage (frame_handle, WM_STATPREF, MsgOnLeft, 0);
    if(tcl != Cl_Focus_Rect)
		{
      RedrawWindow( Frame_Handle, 0, 0, RDW_INVALIDATE | RDW_ALLCHILDREN );
			int tr = refresh;
			refresh = true;
			new_screen;
			refresh = tr;
		}
	}
	DlgKill( dlg );
	return_int = 0;
}

void SetBlock( int parent = parse_int("/DLGHANDLE=", mparm_str) ) {
/*******************************************************************************
  SetBlock - 9/18/95 7:02PM

 Parameters:

 Returns:

 by

*******************************************************************************/

  int dlg;

  DlgCreate (dlg);

  DlgAddCtrl( dlg, Dlg_BitmapStatic, "BT_BL_100", 1, 1, 0, 0, -1, 0,"" );


  DlgAddCtrl( dlg, Dlg_GroupBox, "Options", 8, 1, 53, 10, -1, 0,"" );
  DlgAddCtrl( dlg, DLG_CheckBox, '&Persistent blocks',
    DLG_PosOffset + 1, DLG_PosOffset + 1, 0, 0, 1001,0,"");
  DlgSetInt( dlg, 1001,Persistent_blocks);

  DlgAddCtrl( dlg, DLG_CheckBox, 'Blo&ck edit operations only work in block',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1005,0,"");
  DlgSetInt( dlg, 1005, g_ChkInBlock);

  DlgAddCtrl( Dlg, DLG_CheckBox, "&Keep block marking after edit operations",
    	dlg_PosOffset, dlg_PosOffset + 1,
			0, 0,
			1006, 0, "" );
  DlgSetInt( Dlg, 1006, g_KeepBlkMarking );

  DlgAddCtrl( Dlg, DLG_CheckBox, "Del and B&S keys delete block",
    	dlg_PosOffset, dlg_PosOffset + 1,
			0, 0,
			1007, 0, "" );
  DlgSetInt( Dlg, 1007, g_DelKeyDelsBlk );

  DlgAddCtrl( dlg, DLG_CheckBox, 'I&nclusive stream blocks',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1002, 0, "");
  DlgSetInt( dlg, 1002,stream_block_mode);

  DlgAddCtrl( dlg, DLG_CheckBox, '&Typing overwrites non-persistent blocks',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1003, 0, "");
  DlgSetInt( dlg, 1003,typing_overwrites_block);

  DlgAddCtrl( dlg, DLG_CheckBox, 'Turn block highlight &off after paste',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1004, 0, "");
  DlgSetInt( dlg, 1004,Global_Int("BlockOffAfterPaste"));

  DlgAddCtrl( dlg, DLG_CheckBox, 'Shift+&Up/Down begins line block',
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1008, 0, "");
  DlgSetInt( dlg, 1008,g_ShiftCursorMode);

  DlgAddCtrl( Dlg, dlg_CheckBox, "T&ab key indents/undents block",
			dlg_PosOffset, dlg_PosOffset + 1,
			0, 0,
			1009, 0, "" );
  DlgSetInt( Dlg, 1009, g_TabIndentsBlock );

  DlgAddCtrl( dlg, DLG_GroupBox, 'Column block move', 1, Dlg_PosOffset + 2, 30, 3, -1, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Deletes space",
    Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1010, 0, "");
  DlgSetInt( dlg, 1010, Column_Move_Style);

  DlgAddCtrl( dlg, DLG_RadioButton, "&Leaves space",
    Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1031, 0, "");
  DlgSetInt( dlg, 1031, Column_Move_Style == 0);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Leave cursor at',
    32, Dlg_NegOffset + 2, 30, 3, -1, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Beginning of pasted text",
    DLG_PosOffset + 1, DLG_PosOffset + 1, 0, 0, 1020, 0, "");
  DlgSetInt( dlg, 1020, Global_Int("Cursor_Eob") == 0);

  DlgAddCtrl( dlg, DLG_RadioButton, "&End of pasted text",
    DLG_PosOffset, DLG_PosOffset + 1, 0, 0, 1021, 0, "");
  DlgSetInt( dlg, 1021, Global_Int("CURSOR_EOB") != 0);

  DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset + 2, DLG_StanBtnWidth, 0, 2001, DLGF_DefButton, "/R=1");
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + DLG_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0, 2000, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 61 - DLG_StanBtnWidth, DLG_PosOffset, DLG_StanBtnWidth, 0, 2002, 0, "/R=2");


  if(DlgExecute( dlg, 1001, "Block Operation Setup", BLOCKOP_HELPLINK , "/PARENT=" + parse_str("/DLGHANDLE=", mparm_str), 0 ))
	{
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);

    Persistent_Blocks       = DlgGetInt( dlg, 1001);
    Stream_Block_Mode       = DlgGetInt( dlg, 1002);
    Typing_Overwrites_Block = DlgGetInt( dlg, 1003);
    Column_Move_Style       = DlgGetInt( dlg, 1010);
    g_ChkInBlock            = DlgGetInt( dlg, 1005);
		g_KeepBlkMarking				= DlgGetInt( Dlg, 1006 );
		g_DelKeyDelsBlk					= DlgGetInt( Dlg, 1007 );
		g_ShiftCursorMode				= DlgGetInt( Dlg, 1008 );
		g_TabIndentsBlock				= DlgGetInt( Dlg, 1009 );
    Set_Global_Int ("BlockOffAfterPaste", DlgGetInt( dlg, 1004 ));
    Set_Global_Int ('Cursor_Eob', DlgGetInt(dlg, 1021));
  }
  DlgKill (dlg);

} // SetBlock


Macro SrchSet Trans2 {
/********************************MULTI-EDIT MACRO******************************

Name: SRCHSET

Description:  Setup routine for default search/search and replace/multi-file
							search settings.

Global Strings Modified:
							'DEF_SWITCHES'
							'DEF_REPL_SWITCHES'
							'DEF_FS_SWITCHES'
							'DEF_FS_PATH'
							'DEF_FSR_SWITCHES'
							'DEF_FSR_PATH'

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  int jx, menu, menu_cnt;
  str switches_str[40], temp_return, title[40], multi_search_help[40];
  int tsmode = global_int('~SR_MODAL');

  Set_Global_Int( "~SR_MODAL", True );

	temp_return = return_str;
	jx = 1;

Loop:
	Menu_Cnt = 5;
	Title = "Multi-File Search Setup";

	int Dlg,
			Bw = 46,
			Bh = DLG_Units | DLG_Units_Line_Half;

	DlgCreate( Dlg );

	DlgAddCtrl( Dlg, DLG_CheckBox, "Uni&x-style regular expressions",
			1, 1,
			0, 0,
			1007, 0, "" );
	DlgSetInt( Dlg, 1007, Global_Int( "Reg_Exp_Style" ) );

	DlgAddCtrl( Dlg, DLG_BlackFrame, "",
			1, DLG_Units | DLG_Units_Line_Half,
			49, DLG_Units | ((Dlg_Units_Per_Line * 8)),
			900, 0, "" );

	DlgAddCtrl( Dlg, DLG_BitmapBtn, "BT_SR_100 &Search Defaults",
			2, DLG_PosOffset,
			Bw, Bh,
			100, 0, "/R=101" );

	DlgAddCtrl( Dlg, DLG_BitmapBtn, "BT_SR_101 Search and &Replace Defaults",
			2, DLG_PosOffset + 2,
			Bw, Bh,
			101, 0, "/R=102" );

	DlgAddCtrl( Dlg, DLG_BitmapBtn, "BT_SR_103 &Multi-File Search Defaults",
			2, DLG_PosOffset + 2,
			Bw, Bh,
			102, 0, "/R=103" );

	DlgAddCtrl( Dlg, DLG_BitmapBtn, "BT_SR_104 Multi-&File Search and Replace Defaults",
			2, DLG_PosOffset + 2,
			Bw, Bh,
			103, 0, "/R=104" );

  DlgAddCtrl( Dlg, DLG_PushButton, "OK",
			1, 11,
			DLG_StanBtnWidth, 0,
			110, 0, "/R=1" );
	DlgAddCtrl( Dlg, DLG_PushButton, "Cancel",
			DLG_PosOffset | (DLG_StanBtnWidth + 2), DLG_PosOffset,
			DLG_StanBtnWidth, 0,
			114, 0, "/R=0" );
	DlgAddCtrl( Dlg, DLG_PushButton, "&Help",
			38, DLG_PosOffset,
			DLG_StanBtnWidth, 0,
			115, 0, "/R=2" );

	return_int = DlgExecute( Dlg, 110, "Search Defaults Setup",
			MAINSRCHDEF_HELPLINK, "/PARENT=" + parse_str("/DLGHANDLE=", mparm_str), 0 );
	if ( Return_Int > 0 ) {
		Set_Global_Int( "Reg_Exp_Style", DlgGetInt( Dlg, 1007 ) );
	}
	DlgKill( Dlg );

	if ( Return_Int > 0 ) {
		Set_Global_Int( "Setup_Changed", Global_Int( "Setup_Changed" ) | 0x01 );
		Jx = Return_Int;
		switch ( Return_Int ) {
			case 101 :
			  Rm( "SEARCH^SrchIntr /M=0/SWONLY=1/SWG=Def_Switches/H=" +
						SRCHDEF_HELPLINK );
				if ( Return_Int ) {
					Set_Global_Int( "Setup_Changed", Global_Int( "Setup_Changed" ) | 0x01 );
				}
				goto loop;

			case 102 :
			  Rm( "SEARCH^SrchIntr /M=1/SWONLY=1/SWG=DEF_REPL_SWITCHES/H=" +
						SRCHREPDEF_HELPLINK );
				if ( Return_Int ) {
					Set_Global_Int( "Setup_Changed", Global_Int( "Setup_Changed" ) | 0x01 );
				}
				goto loop;

			case 103 :
			case 104 :
			{
				int Dlg;

				if ( Return_Int == 103 ) {
					Switches_Str = Global_Str( "Def_FS_Switches" );
				}
				else {
					Switches_Str = Global_Str( "Def_FSR_Switches" );
				}
				DlgCreate( Dlg );

				DlgAddCtrl( Dlg, DLG_CheckBox, "&Search sub-directories",
						10, 1,
						24, 0,
						1001, 0, "" );
				DlgSetInt( Dlg, 1001, XPos( "S", Switches_Str, 1 ) != 0 );

        DlgAddCtrl( Dlg, DLG_CheckBox, "&Case sensitivity",
						dlg_PosOffset + 0, dlg_PosOffset + 1,
						24, 0,
						1002, 0, "" );
				DlgSetInt( Dlg, 1002, XPos( "I", Switches_Str, 1 ) == 0 );

        DlgAddCtrl( Dlg, DLG_CheckBox, "&Regular expressions",
						dlg_PosOffset + 0, dlg_PosOffset + 1,
						24, 0,
						1003, 0, "" );
				DlgSetInt( Dlg, 1003, XPos( "X", Switches_Str, 1 ) != 0 );

				DlgAddCtrl( Dlg, DLG_CheckBox, "Search file in &memory",
						dlg_PosOffset + 0, dlg_PosOffset + 1,
						24, 0,
						1004, 0, "" );
				DlgSetInt( Dlg, 1004, XPos( "F", Switches_Str, 1 ) != 0 );

				if ( Return_Int == 103 ) {
					DlgAddCtrl( Dlg, DLG_CheckBox, "&List all occurences",
							dlg_PosOffset + 0, dlg_PosOffset + 1,
							24, 0,
							1005, 0, "" );
					DlgSetInt( Dlg, 1005, XPos( 'L', Switches_Str, 1 ) != 0 );

					DlgAddCtrl( Dlg, DLG_BitmapStatic, "BT_SR_103",
							1, 1,
							0, 0,
							100, 0, "" );

					DlgAddCtrl( Dlg, DLG_BlackFrame, "",
							9, DLG_UNITS | 5,
							30, DLG_Units | ((Dlg_Units_Per_Line * 4) + 6 ),
							900, 0, "" );

          DlgAddCtrl( Dlg, DLG_Static, "Starting &path:",
							1, 7,
							0, 0,
							101, 0, "" );

					DlgAddCtrl( Dlg, DLG_Text, Global_Str( "Def_FS_Path" ),
							16, dlg_PosOffset + 0,
							30, 0,
							1100, 0,"/ML=60" );

					DlgAddCtrl( Dlg, dlg_DirButton, "...",
							dlg_PosOffset + 30 + 1, dlg_PosOffset + 0,
							4, 0,
							2200, 0, "/SID=1100" );

					Multi_Search_Help = MFSRCHDEF_HELPLINK;
				}
				else {
					DlgAddCtrl( Dlg, DLG_BitmapStatic, "BT_SR_104",
							1, 1,
							0, 0,
							100, 0, "" );

					DlgAddCtrl( Dlg, DLG_CheckBox, "&Leave all files open",
							10, 5,
							24, 0,
							1005, 0, "" );
					DlgSetInt( Dlg, 1005, XPos( "O", Switches_Str, 1 ) != 0 );

					DlgAddCtrl( Dlg, DLG_BlackFrame, "",
							9, DLG_Units | 4,
							30, DLG_Units | ((Dlg_Units_Per_Line * 4) + 6 ),
							900, 0, "" );

					DlgAddCtrl( Dlg, DLG_Static, "Starting &Path:",
							1, 7,
							0, 0,
							101, 0, "" );

					DlgAddCtrl( Dlg, DLG_Text, Global_Str( "Def_FSR_Path"),
							16, 7,
							30, 0,
							1100, 0, "/ML=60" );

					DlgAddCtrl( Dlg, dlg_DirButton, "...",
							dlg_PosOffset + 30 + 1, dlg_PosOffset + 0,
							4, 0,
							2200, 0, "/SID=1100" );

					Menu_Cnt = 6;
					Title = "Multi-File Search And Replace Setup";
					Multi_Search_Help = MSRCHREPDEF_HELPLINK;
				}
				DlgAddCtrl( Dlg, DLG_PushButton, "OK",
						1, DLG_PosOffset | dlg_Units | dlg_Units_Line_Half,
						DLG_StanBtnWidth, 0,
						1006, DLGF_DefButton, "/R=1" );

				DlgAddCtrl( Dlg, DLG_PushButton, "Cancel",
						DLG_PosOffset + DLG_StanBtnWidth + 2, DLG_PosOffset,
						DLG_StanBtnWidth, 0,
						1007, 0, "/R=0" );

				DlgAddCtrl( Dlg, DLG_PushButton, "&Help",
						41, DLG_PosOffset,
						DLG_StanBtnWidth, 0,
						1008, 0, "/R=2" );

				Return_Int = DlgExecute( Dlg, 1100, Title, Multi_Search_Help, "/PARENT=" + parse_str("/DLGHANDLE=", mparm_str), 0 );
				if ( Return_Int ) {
					Switches_Str = "";
					if ( DlgGetInt( Dlg, 1003 ) ) {
						Switches_Str = "X";
					}
					if ( !DlgGetInt( Dlg, 1002 ) ) {
						Switches_Str += "I";
					}
					if ( DlgGetInt( Dlg, 1001 ) ) {
						Switches_Str += "S";
					}
					if ( DlgGetInt( Dlg, 1004 ) ) {
						Switches_Str += "F";
					}
					if ( menu_cnt == 6 ) {
						if ( DlgGetInt( Dlg, 1005 ) ) {
							Switches_Str += "O";
						}
						Set_Global_Str( "Def_FSR_Switches", Switches_Str );
						Set_Global_Str( "Def_FSR_Path", DlgGetStr( Dlg, 1100 ) );
					}
					else {
						if ( DlgGetInt( Dlg, 1005 ) ) {
							Switches_Str += 'L';
						}
						Set_Global_Str( "Def_FS_Switches", Switches_Str );
						Set_Global_Str( "Def_FS_Path", DlgGetStr( Dlg, 1100 ) );
					}
					Set_Global_Int( "Setup_Changed", Global_Int( "Setup_Changed" ) | 0x01 );
				}
				DlgKill( Dlg );
			}
			goto loop;
		}
	}

Exit:
  Set_Global_Int( "~SR_MODAL", TSMode );
	Return_Str = Temp_Return;
	Return_Int = 0;

}  // SrchSet

Macro SetEdit Trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  SETEDIT

Description:  This is the edit settings dialog.

               (C) Copyright 1996 by American Cybernetics, Inc.
*******************************************************************************/
  int  dlg;

	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SETUP_101",
    1, 2, 0, 0, 1000, 0, "" );
  RM( 'USERIN^SPECCHAR ' + Page_Str );
  DlgAddCtrl( dlg, Dlg_Static, "&Page Break string",
    9, 1, 0, 0, 2001, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, return_str,
    Dlg_PosOffset + 25, Dlg_PosOffset, 15, 0, 1101, 0, "/ML=10");

/* Specchar and dlbparen properly represent unprintable ASCII codes in the menu */
  RM( 'USERIN^SPECCHAR ' + Word_Delimits );
  DlgAddCtrl( dlg, Dlg_Static, "&Word delimits",
    9, Dlg_PosOffset + 1, 0, 0, 2002, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, return_str,
    Dlg_PosOffset + 25, Dlg_PosOffset, 40, 0, 1102, 0, "/ML=40");

  DlgAddCtrl( dlg, Dlg_Static, "Max &undo count",
    9, Dlg_PosOffset + 1, 0, 0, 2003, 0, "");

  DlgAddCtrl( dlg, Dlg_Integer, "",
    DLG_PosOffset + 25, Dlg_PosOffset, 8, 0, 1103, 0, "/MIN=0/MAX=65535");
	DlgSetInt( dlg, 1103, max_undo);

  DlgAddCtrl( dlg, Dlg_Static, "Default &file extension(s)",
    9, Dlg_PosOffset + 1, 0, 0, 2004, 0, "");
  DlgAddCtrl( dlg, Dlg_Text, Global_Str('@DEFAULT_EXT_LIST'),
    Dlg_PosOffset + 25, Dlg_PosOffset, 40, 0, 1104, 0, "/ML=80");

  DlgAddCtrl( dlg, DLG_GroupBox, 'Options',1, 6, 28, 5, 2001, 0, "" );

  DlgAddCtrl( dlg, DLG_CheckBox, "Tru&ncate spaces",
    Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1001, 0, "");
	DlgSetInt( dlg, 1001, Truncate_Spaces);

  DlgAddCtrl( dlg, DLG_CheckBox, "Control-&Z at EOF",
    Dlg_PosOffset,  Dlg_PosOffset + 1, 0, 0, 1002, 0, "");
	DlgSetInt( dlg, 1002, Ctrl_Z);

  DlgAddCtrl( dlg, DLG_CheckBox, "&CR/LF at EOF",
    Dlg_PosOffset,  Dlg_PosOffset + 1, 0, 0, 1003, 0, "");
	DlgSetInt( dlg, 1003, EOF_Cr);

  DlgAddCtrl( dlg, DLG_CheckBox, "Edit binary files in he&x",
    Dlg_PosOffset,  Dlg_PosOffset + 1, 0, 0, 1004, 0, "");
	DlgSetInt( dlg, 1004, Binary_Mode);   //global_int("BINARY_MODE"));

  DlgAddCtrl( dlg, DLG_GroupBox, 'Tab expand',
    31, 6, 20, 3, 2002, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Tabs",
    Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1301, 0, "");
	DlgSetInt( dlg, 1301, Tab_Expand);

  DlgAddCtrl( dlg, DLG_RadioButton, "&Spaces",
    Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1302, 0, "");
	DlgSetInt( dlg, 1302, Tab_Expand == 0);


  DlgAddCtrl( dlg, DLG_GroupBox, 'Default mode',
    Dlg_PosOffset + 21, 6, 20, 3, 2004, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Insert",
    Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1305, 0, "");
  DlgSetInt( dlg, 1305, Global_Int("Default_Insert_Mode"));

  DlgAddCtrl( dlg, DLG_RadioButton, "&Overwrite",
    Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1306, 0, "");
  DlgSetInt( dlg, 1306, Global_Int("Default_Insert_Mode") == 0);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Paragraphs separated by',
    31, (Dlg_Units | Dlg_PosOffset) | 14, 42, 3, -1, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Blank lines only",
    Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1330, 0, "");
  DlgSetInt( dlg, 1330,(word_wrap_style & 2) == 0);

  DlgAddCtrl( dlg, DLG_RadioButton, "In&dent levels",
    Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1331, 0, "");
  DlgSetInt( dlg, 1331, (word_wrap_style & 2) != 0);



  DlgAddCtrl( dlg, DLG_PushButton, "OK", 2, 13,
    DLG_StanBtnWidth, 0, 201, DLGF_DefButton, "/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel",
    DLG_PosOffset + Dlg_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0, 202, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help",
    63, Dlg_PosOffset, DLG_StanBtnWidth, 0, 203, 0, "/R=2");

	return_int = DlgExecute( dlg, 1101, "Edit Settings", EDITSETT_HELPLINK, "/PARENT=" + parse_str("/DLGHANDLE=", mparm_str), 0);


	if(  return_int  ) {
		RM('USERIN^VALCHAR ' + DlgGetStr(dlg, 1101));
    Page_Str          = return_str;
		RM('USERIN^VALCHAR ' + DlgGetStr(dlg, 1102));
    word_delimits     = return_str;
    max_undo          = DlgGetInt(dlg, 1103);
    Truncate_Spaces   = DlgGetInt(dlg, 1001);
    ctrl_z            = DlgGetInt(dlg, 1002);
    eof_cr            = DlgGetInt(dlg, 1003);
    Binary_Mode       = DlgGetInt(dlg, 1004);
    tab_expand        = DlgGetInt(dlg, 1301);
    Set_Global_Str ('@Default_Ext_List', DlgGetStr(dlg, 1104));
    Set_Global_Int ("Binary_Mode", DlgGetInt(dlg, 1004));
    Set_Global_Int ('Default_Insert_Mode', DlgGetInt(dlg, 1305));

    Set_Global_Int('Setup_Changed',Global_Int('Setup_Changed') | $01);
	}
	return_int = 0;

	DlgKill(dlg);
}

Macro SetMePaths Trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  SETMEPATHS

Description:  This menu sets up the backup methods, and backup and
	temp file paths

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int  dlg;
/* Build a menu with current settings */
	DlgCreate(dlg);

	DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_FL_102", 1, 4 , 0,0, 1000, 0, "" );

	DlgAddCtrl( dlg, DLG_Static, 'Autosave', 8, DLG_Units | 16, 0, 0, -1, 0, "" );
	DlgAddCtrl( dlg, DLG_BlackFrame, '', 19, DLG_Units | 4, 70, DLG_Units | ((2 * 12) + 8), -1, 0, "" );

	DlgAddCtrl( dlg, Dlg_Static, "&Seconds of keyboard inactivity (0 = OFF)",
							Dlg_PosOffset + 1, Dlg_PosOffset | DLG_Units | 3, 0, 0, -1, 0, "");
	DlgAddCtrl( dlg, Dlg_Integer, "",
							DLg_PosOffset + 40, Dlg_PosOffset, 8, 0, 1102, 0, "/MIN=0/MAX=254");
	DlgSetInt( dlg, 1102, parse_int('/T1=', global_str('!AUTOSAVEPARMS')));

	DlgAddCtrl( dlg, DLG_CheckBox, "Sa&ve status",
			Dlg_PosOffset | 12, Dlg_PosOffset, 0, 0, 1001, 0, "");
	DlgSetInt( dlg, 1001, parse_int('/S1=', global_str('!AUTOSAVEPARMS')));

	DlgAddCtrl( dlg, Dlg_Static, "&Absolute interval in seconds (0 = OFF) ",
							20, Dlg_PosOffset | DLG_Units | 16, 0, 0, -1, 0, "");
	DlgAddCtrl( dlg, Dlg_Integer, "",
							DLg_PosOffset + 40, Dlg_PosOffset, 8, 0, 1103, 0, "/MIN=0/MAX=254");
	DlgSetInt( dlg, 1103, parse_int('/T2=', global_str('!AUTOSAVEPARMS')));
	DlgAddCtrl( dlg, DLG_CheckBox, "Sav&e status",
			Dlg_PosOffset | 12, Dlg_PosOffset, 0, 0, 1002, 0, "");
	DlgSetInt( dlg, 1002, parse_int('/S2=', global_str('!AUTOSAVEPARMS')));


	DlgAddCtrl( dlg, DLG_Static, 'Backups', 9, DLG_Units | ((6 * 12) + 6), 0, 0, -1, 0, "" );
	DlgAddCtrl( dlg, DLG_BlackFrame, '', 19, DLG_Units | ((4 * 12) + 4), 70, DLG_Units | ((5 * 12) + 8), -1, 0, "" );

	DlgAddCtrl( dlg, DLG_GroupBox, 'Backup method', DLG_PosOffset + 2,
							Dlg_PosOffset, 33, 4, -1, 0, "" );
	DlgAddCtrl( dlg, DLG_RadioButton, "&Off", Dlg_PosOffset + 1,
							Dlg_PosOffset + 1, 0, 0, 1301, 0, "");
	DlgSetInt( dlg, 1301, (backups & 0xF == 0));
	DlgAddCtrl( dlg, DLG_RadioButton, "Create .&BAK file", Dlg_PosOffset,
							Dlg_PosOffset + 1, 0, 0, 1302, 0, "");
	DlgSetInt( dlg, 1302, (backups & 0xF == 1));
	DlgAddCtrl( dlg, DLG_RadioButton, "&Copy file to backup directory", Dlg_PosOffset,
							Dlg_PosOffset + 1, 0, 0, 1303, 0, "");
	DlgSetInt( dlg, 1303, (backups & 0xF == 2));

  DlgAddCtrl( dlg, DLG_GroupBox, 'Backup Frequency', 57, Dlg_NegOffset - 3, 23, 3, -1, 0, "" );
	DlgAddCtrl( dlg, DLG_RadioButton, "&First save only", Dlg_PosOffset + 1,
							Dlg_PosOffset + 1, 0, 0, 1304, 0, "");
	DlgSetInt( dlg, 1304, (backups & 0x80 == 0));
	DlgAddCtrl( dlg, DLG_RadioButton, "Ever&y save", Dlg_PosOffset,
							Dlg_PosOffset + 1, 0, 0, 1305, 0, "");
	DlgSetInt( dlg, 1305, (backups & 0x80 != 0));
	DlgAddCtrl( dlg, Dlg_Static, "Backup &directory:", 22, DLG_PosOffset | DLG_Units | 32, 0, 0, 2004, 0, "");
	DlgAddCtrl( dlg, Dlg_Text, Global_Str('!BACKUP_PATH'),
							dlg_PosOffset + 20, Dlg_PosOffset, 35, 0, 1101, 0, "");
  DlgAddCtrl( dlg, Dlg_DirButton, "...",
              dlg_PosOffset + 36, Dlg_PosOffset, 4, 0, 25002, 0, "/SID=1101");

	DlgAddCtrl( dlg, DLG_BlackFrame, '', 1, DLG_PosOffset | DLG_Units | 29, 46,
				DLG_Units | ((5 * 12) + 3), -1, 0, "" );
	DlgAddCtrl( dlg, DLG_BlackFrame, '', 50, DLG_PosOffset, 39,
				DLG_Units | ((5 * 12) + 3), -1, 0, "" );

	DlgAddCtrl( dlg, DLG_CheckBox, "&Network file locking",
			2, Dlg_PosOffset, 0, 0, 1003, 0, "");
	DlgSetInt( dlg, 1003, file_locking);

	int xx,xy;
	DlgGetXY( dlg, 1003, xx,xy);

	DlgAddCtrl( dlg, DLG_CheckBox, "Save fi&les when switching tasks",
			Dlg_PosOffset, Dlg_PosOffset | 1, 0, 0, 1402, 0, "");
	DlgSetInt( dlg, 1402, (ActivateFlags & _SaveOnDeactivate) != 0 );

	DlgAddCtrl( dlg, DLG_CheckBox, "&Reload changed files when switching back",
			Dlg_PosOffset, Dlg_PosOffset | 1, 0, 0, 1403, 0, "");
	DlgSetInt( dlg, 1403, (ActivateFlags & _ReloadOnActivate) != 0 );

	DlgAddCtrl( dlg, DLG_GroupBox, "Determine changed file by",
			Dlg_PosOffset | 4, Dlg_PosOffset | 1, 32, 2, -1, 0, "");

	DlgAddCtrl( dlg, DLG_CheckBox, "Date/time",
			Dlg_PosOffset | 2, Dlg_PosOffset | 1, 0, 0, 1404, 0, "");
	DlgSetInt( dlg, 1404, (ActivateFlags & _ChangedOnTime) != 0 );

	DlgAddCtrl( dlg, DLG_CheckBox, "Attribute",
			Dlg_PosOffset | 16, Dlg_PosOffset, 0, 0, 1405, 0, "");
	DlgSetInt( dlg, 1405, (ActivateFlags & _ChangedOnAttr) != 0 );

	DlgAddCtrl( dlg, Dlg_Static, "S&wap file directory:",
							51, DLG_Units | xy, 0, 0, -1, 0, "");
	DlgAddCtrl( dlg, Dlg_Text, Global_Str('!TEMP_PATH'),
              dlg_PosOffset + 1, Dlg_PosOffset | Dlg_Units | 10, 30, 0, 1104, 0, "");
  DlgAddCtrl( dlg, Dlg_DirButton, "...",
              dlg_PosOffset + 31, Dlg_PosOffset, 4, 0, 25000, 0, "/SID=1104");
	DlgAddCtrl( dlg, Dlg_Static, ".&TMP file directory:",
              51, Dlg_PosOffset | Dlg_Units | 20, 0, 0, -1, 0, "");
	DlgAddCtrl( dlg, Dlg_Text, Global_Str('@TMP_FILE_PATH'),
              dlg_PosOffset + 1, Dlg_PosOffset | Dlg_Units | 10, 30, 0, 1105, 0, "");
  DlgAddCtrl( dlg, Dlg_DirButton, "...",
              dlg_PosOffset + 31, Dlg_PosOffset, 4, 0, 25001, 0, "/SID=1105");

	DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, DLG_PosOffset | Dlg_Units | 35, Dlg_StanBtnWidth, 0, 201, DLGF_DefButton, "/R=1");
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset +Dlg_StanBtnWidth + 2, DLG_PosOffset, Dlg_StanBtnWidth, 0, 202, 0, "/R=0");
	DlgAddCtrl( dlg, DLG_PushButton, "&Help", 78, DLG_PosOffset, Dlg_StanBtnWidth, 0, 203, 0, "/R=2");

  return_int = DlgExecute(dlg, 1101,
                "Backups, Temp Files and Autosave",
                BACKTMPAUTO_HELPLINK, "/PARENT=" + parse_str("/DLGHANDLE=", mparm_str), 0);

	if(  return_int  ) {
		file_locking = DlgGetInt( dlg, 1003);
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);

		RM('SetAutoSave /M2=1/T1=' + Str(DlgGetInt(dlg, 1102)) +
				'/S1=' + str(DlgGetint( dlg, 1001)) +
				'/T2=' + str(DlgGetInt(dlg, 1103)) +
				'/S2=' + str(DlgGetInt(dlg, 1002)) +
				'/H1=' + parse_Str('/H1=', global_str('!AUTOSAVEPARMS')) +
				'/H2=' + parse_Str('/H2=', global_str('!AUTOSAVEPARMS')));

		ActivateFlags = 0;
		if(DlgGetInt(dlg,1402))
			ActivateFlags |= _SaveOnDeactivate;

		if(DlgGetInt(dlg,1403))
			ActivateFlags |= _ReloadOnActivate;

		if(DlgGetInt(dlg,1404))
			ActivateFlags |= _ChangedOnTime;

		if(DlgGetInt(dlg,1405))
			ActivateFlags |= _ChangedOnAttr;

		backups = 0;
		if (DlgGetInt( dlg, 1302)) {
			backups = 1;
		}
		if (DlgGetInt( dlg, 1303)) {
			backups = 2;
		}
		if (DlgGetInt( dlg, 1305)) {
			backups = backups | $80;
		}
		return_str = DlgGetstr( dlg, 1101);
		Set_Global_Str('!BACKUP_PATH', return_str );
		rm('XLATECMDLINE');
		backup_path = AddTrailingSlash(return_str);
		return_str = DlgGetstr(dlg, 1104);
		Set_Global_Str('!TEMP_PATH', return_str );
    RM('XLATECMDLINE');
		temp_path = AddTrailingSlash(return_str);

    Set_Global_Str('@TMP_FILE_PATH', DlgGetStr(dlg, 1105));

	}
	DlgKill(dlg);

	return_int = 0;
}


void Ext_Dlg_Update (int parent = parse_int ("/DLGHANDLE=", mparm_str)) Trans2
{
  str TStr[2048] = Get_Line;

  str font_name, font_str[2048];
  int font_size, ptsize;
	str charset_name;

  int dc = GetDC (0);
  int logy = GetDeviceCaps (dc, LOGPIXELSY);
  ReleaseDC (0, dc);

  Font_Str  = parse_str ("\X7F" + "FONT=", TStr);

  Font_Name = parse_str ("/NAME=", Font_Str);
  Font_Size = parse_int ("/SIZE=", Font_Str);
  ptsize = -(font_size * 72) / logy;

  if ( font_name == "" )
  {
    SetWindowText(GetDlgItem (parent, 20001), "");
		EnableWindow (GetDlgItem (parent, 20002), False);
		SendDlgItemMessage (parent, 20002, BM_SETCHECK, 2, 0);
  }
  else
  {
    SetWindowText (GetDlgItem (parent, 20001),
      font_name + "  " + str(ptsize) + "Pt");
  }
}

macro CHECK_EXT TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

NAME:  CHECK_EXT

DESCRIPTION:  Checks to see if a extension create is aborted or an extension
is deleted, and if so, finds and deletes any associated compiler records.
Also, resets the extension global string of an edited extension record.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str
      g_str[20]     = Parse_Str('/GLO=',Mparm_Str),
      tstr      = Parse_Str('EXT=',Global_Str(g_str)),
			tstr2[8],
      language[40]  = Parse_Str('LS=',Global_Str(g_str));
	int
    parent = parse_int ("/DLGHANDLE=", mparm_str),
		t_int,
		t_int2,
		t_int3,
		reinit = false,
		reinit_count,
		active_window = window_id;
		mark_pos;

	if (Parse_Int('/P=',MParm_Str)) {
// prompt user if he wants to reinitialize extension parameters for all
// existing windows */
// language_not_changed = (language == parse_str("/LANG=",global_str("@T_EXT")));

    // If there are no files loaded with the designated extensions
    // then do not prompt the user
		t_int2 = 1;
		do
		{
			t_int = xpos(' ', tstr, t_int2 );
			if(t_int == 0)
			{
				tstr2 = copy( tstr,t_int2,3);
			}
			else
			{
				tstr2 = copy( tstr, t_int2, t_int - t_int2 );
			}
			if(global_str("." + caps(tstr2)) != "")
			{
				reinit = TRUE;
				t_int = 0;
			}
			t_int2 = t_int + 1;
		} while( t_int != 0);

		if(reinit)
			RM("VERIFY /T=Reset extension configuration in currently loaded files?/H=" +
				FNAMEEXT_HELPLINK);
    reinit = return_int;
		if ((tstr != parse_str("/EXT=",global_str("@T_EXT"))) &&
				(!parse_int("/CREATE=",global_str("@T_EXT")))) {
			Mark_Pos;
			Tof;
			Reg_Exp_Stat = True;
			if (Search_Fwd('%|12' + parse_str("/EXT=",global_str("@T_EXT")) + '.PGM$',0)) {
				right;
				del_chars(length(parse_str("/EXT=",global_str("@T_EXT"))));
				insert_mode = true;
				text(tstr);
			}
			goto_mark;
		}

/* This will reassign the extension specific global on the fly */
		t_int2 = 1;
		call SKIP_DELIMITS;

PARSE_EXT:
		tstr2 = '';
		while ((t_int2 <= svl(tstr)) && (!xpos(str_char(tstr,t_int2)," ;,",1))) {
			tstr2 = tstr2 + str_char(tstr,t_int2);
			++t_int2;
		}
		call SKIP_DELIMITS;
		TStr2 = '.' + Tstr2;
		if (tstr2 == ".DEFAULT") {
/* The default get special treatment.  We need to find all extension specific
globals that use default and reassign them */
			t_int = 1;
FIND_EXT:
			if (t_int3 = XPos("",global_str("EXTENSIONS"),t_int + 1)) {
				tstr2 = copy(global_str("EXTENSIONS"),t_int,t_int3 - t_int);
				if (xpos("DEFAULT",parse_str("EXT=",Global_Str(tstr2)),1)) {
					call SET_EXT_PARMS;
				}
				t_int = t_int3 + 1;
				Goto FIND_EXT;
			}
		} else if (Global_Str(TStr2) != '') {
			call SET_EXT_PARMS;
		}
		if (t_int2 <= svl(tstr))
			goto PARSE_EXT;
	} else {
		Set_Global_Str("@T_EXT","/EXT=" + tstr + "/LANG=" + language + mparm_str);
	}
	goto EXIT;

SKIP_DELIMITS:
	while ((t_int2 <= svl(tstr)) && (xpos(str_char(tstr,t_int2)," ;,",1)))
		++t_int2;
	RET;

SET_EXT_PARMS:
	Set_Global_Str(tstr2,Global_Str(g_str));
	if (reinit) {
/* go around the window list to see if there are any currently loaded files
	 with this extension */
			for (reinit_count = 0;reinit_count < window_count;++reinit_count) {
				switch_window(cur_window + 1);

        if ("." + caps(get_extension(file_name)) == caps(tstr2)) {
// if the language has not changed, EXTSETUP need not run SET_SYNTAX_PARMS
          RM("EXTSETUP /SETFC=1" +
            "/NOSYNTAX=" + str((language == parse_str ("/LANG=",
              global_str("." + get_extension(file_name)))))
            );
				}
			}
	}
	RET;

EXIT:
	switch_win_id(active_window);
	goto_mark;
}

void Extens Trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

NAME:  EXTENS

DESCRIPTION:  This is the filename extension specific setup menu.

PARMS:				/CE=1			Use the current filename extension and bring the dialog up.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str extraparms = "";

	if( parse_int("/CE=", mparm_str))
	{
		extraparms = "/NL=1" + "/FV=" + parse_str("EXT=", Global_Str("." + get_extension(file_name)));
	}

	Set_Global_Str('T_Format','');
  DB( "MECONFIG", "EXT.DB", "MEWHDRS.DB", "EXT.HDR",
      "Filename Extension Setup",
      "Edit Filename Extension Setup","EXT", 0,
      '/H=' + FNAMEEXT_HELPLINK +
      '/NDF=1/PROTECT1=DEFAULT/PRE=EXT/BMP=BT_SETUP_104/DEFCOPY=DEFAULT'+
      '/CP=Input new extension: /DELMAC=1/CANMAC=1' +
      '/PREEDIT=Ext_Dlg_Update' + extraparms +
      '/MACRO=CHECK_EXT'
      );

	Set_Global_Str('T_Format','');
	Set_Global_Str("@T_EXT","");
}

#define format_ctrl 1000
#define col_ctrl 2000
#define OK_ctrl          101
#define Cancel_ctrl      102
#define Help_ctrl        103
#define format_width  100

global {
  int g_col_hwnd "!EDFORMAT_COL_HWND";
  int g_dlg_hwnd "!EDFORMAT_HWND";
  int g_cur_col  "!EDFORMAT_CUR_COL";
}

str EDFORMAT_DLG(str t_format[max_line_length] = mparm_str) TRANS2 {
/*******************************************************************************
                                MULTI-EDIT MACRO

Name: EDFORMAT

Description:  This macro allows for editing of the format line for an
              individual file.

               (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/
  int dlg,
      result,
      do_this_window = 0,
      t_refresh = refresh;

  if (!svl(t_format)) {
    do_this_window = 1;
    t_format = format_line;
  }
  refresh = false;

  DlgCreate(dlg);
  g_cur_col = 0;
  DlgAddCtrl(dlg, DLG_Static, "C: 1", 1, 1, format_width, 0, col_ctrl, 0, "");
  DlgAddCtrl(dlg, DLG_Text, t_format, 1, 2, format_width, 0, format_ctrl, 0, "");
  DlgAddCtrl(dlg, DLG_PushButton, "OK", 1, Dlg_PosOffset | Dlg_Units | 20, Dlg_StanBtnWidth, 0, OK_Ctrl, Dlgf_DefButton, "/R=1");
  DlgAddCtrl(dlg, DLG_PushButton, "Cancel", Dlg_StanBtnWidth + 2, dlg_PosOffset, Dlg_StanBtnWidth, 0, Cancel_Ctrl, 0, "/R=0");
  DlgAddCtrl(dlg, DLG_PushButton, "&Help", format_width - Dlg_StanBtnWidth, Dlg_PosOffset, Dlg_StanBtnWidth, 0, Help_Ctrl, 0, "/R=2");

  result = DlgExecute(dlg, format_ctrl, "Edit Format Line", "", "/PARENT=" + parse_str("/DLGHANDLE=", mparm_str) + "/HOOK=EDFORMAT_HOOK", 0);
  if (result) {
    t_format = DlgGetStr(dlg, format_ctrl);
    if (do_this_window) {
      Make_Message('Format line changes saved.  The format line WILL BE SAVED with the file.');
      format_line = t_format;
      format_stat = true;
    }
  }
  DlgKill(dlg);
  refresh = t_refresh;
  return(t_format);
}

/*******************************************************************************
  EditFormatEx - 4/21/95 5:56PM

  by Todd Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
macro EditFormatEx trans2
{
  set_global_str( parse_str("/GSTR=", mparm_str),
  EdFormat_Dlg( global_str(parse_str("/GSTR=", mparm_str))));
  return_int = 0;
} // EditFormatEx



int Edformat_Hook(int &retval, int window, message, wparam, lparam, str parms ) trans2 {

  if (message == WM_COMMAND) {
    switch (wparam) {
    case DLG_WCMD_INIT :
      g_dlg_hwnd = window;
      g_col_hwnd = GetDlgItem(window, col_Ctrl);
      Subclass_With_Macro(GetDlgItem(window, format_Ctrl), "Edformat_Subclas", "");
// Kludge to deselect text initially
   //   PostMessage(GetDlgItem(window, format_Ctrl), WM_KEYDOWN, VK_HOME, 0);
   //   PostMessage(GetDlgItem(window, format_Ctrl), WM_KEYUP, VK_HOME, 0);

      PostMessage(GetDlgItem(window, format_Ctrl), EM_SETSEL,0, 0);
      break;
    case format_ctrl :
      if ((lparam >> 16) == EN_CHANGE) {
      }
      break;
    }
	}
	return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));
}


int Edformat_Subclas( int &retval, int window, int message, int wparam, int lparam, str parms ) no_break trans2 {
  int result = 0;

  switch (message) {
    case WM_KEYUP :
    case WM_LBUTTONUP :
      call UPDATE_COL;
      break;
    case WM_LBUTTONDOWN :
      if (GetKeyState(VK_SHIFT) & 0x80){
// this disables shifted mouse (selecting text)
        result = 1;
        break;
      }
// this disables selection of text with the mouse
      PostMessage(window, WM_LBUTTONUP, wparam, lparam);
    case WM_KEYDOWN :
      switch (wParam) {
        case vk_up :  // up arrow
        case vk_down :  // down arrow
// this disables up and down arrows
          result = 1;
          break;
        case vk_left :  // left arrow
        case vk_right :  // right arrow
          if (GetKeyState(VK_SHIFT) & 0x80){
// this disables shifted left and right (selecting text)
            result = 1;
          }
          break;
      }

      call UPDATE_COL;
      break;
		case WM_GETDLGCODE :
      retval = DLGC_WANTCHARS | DLGC_WANTALLKEYS | DLGC_WANTTAB;
//      retval = DLGC_WANTTAB;
      result = 1;
      break;
    case WM_CHAR : {
      char t_char;
//    case WM_SYSCHAR :
      switch (wparam) {
        case VK_ESCAPE :
          SendMessage(g_dlg_hwnd, WM_COMMAND, cancel_ctrl, 0);
          RETURN(1);
        case VK_RETURN :
          SendMessage(g_dlg_hwnd, WM_COMMAND, ok_ctrl, 0);
          RETURN(1);
        case VK_TAB :
          t_char = "\x10";
INSERT_CHAR:
          result = 1;
          int col = (SendMessage(window, EM_GETSEL, 0, 0) & 0xffff) + 1;
          str t_str[max_line_length];
          GetWindowText(window, t_str, max_line_length - 1);
          if (svl(t_str)) {
            SetWindowText(window, copy(t_str, 1, col - 1) + t_char + copy(t_str, col, max_line_length));
            SendMessage(window, EM_SETSEL, 0, make_long(col, col));
          } else {
            SetWindowText(window, t_char);
          }
          break;
        default:
          if ((wparam > 31) & (wparam < 127)) {
            t_char = char(wparam);
            goto INSERT_CHAR;
          }
          break;
      }
//      call UPDATE_COL;
      break;
    }
  }
  return(result);

UPDATE_COL:
  SetWindowText(g_col_hwnd, "C: " +  str((SendMessage(window, EM_GETSEL, 0, 0) & 0xffff) + 1));
  RET;
}



Macro SetSave Trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

NAME:  SETSAVE

DESCRIPTION:  This macro creates and compiles INIT.S to save all setup
							parameters

PARAMETERS:
							/NKKW=1   Don't get rid of keymap window when done.  This
												rarely used parameter was created specifically
												for conversion macros so that the keymap window
												can be retained and reused.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

#ifdef DEMO
	RM("MESSAGEBOX /B=2/T=OPERATION NOT AVAILABLE IN DEMO/M=The Multi-Edit Demo does not support permanent saving of configuration settings.");
#else
  str gn[32], gv[MAX_LINE_LENGTH];
  int gi,jx;

	int T_Insert_Mode;
	int Active_Window;

	Refresh = False;

	T_Insert_Mode = Insert_Mode;
	Return_Str = '';
	Undo_Stat = False;
	Insert_Mode = True;
	Active_Window = Window_Id;
	Working;

	if( LocateDBPage( "MECONFIG", "INIT.CFG", true ) )
	{
		if( read_only )
		{
			rm("MESSAGEBOX /B=2/T=Error Saving Configuration/M=MECONFIG.DB is locked!");
			goto end_of_mac;
		}

		int tl = c_line;
		goto_col(1);
		down;
		block_begin;
		while(!at_eof && (cur_char != "\f"))
		{
			down;
		}
		up;
		block_end;
		if(c_line > tl)
			delete_block;
		goto_line(tl);

		eol;
		cr;

		put_line("/MEMORY_PERCENTAGE=" + str(memory_percentage ) );
		eol; cr;;

		Put_Line('/PAGE_STR=' + Convert_String(page_str));
		eol; cr;;

		Put_Line('/TRUNCATE_SPACES=' + Str(Truncate_Spaces));
		eol; cr;;

		Put_Line('/PERSISTENT_BLOCKS=' + Str(persistent_Blocks));
		eol; cr;;

		Put_Line('/SAVE_RESETS_CHANGED=' + Str(save_resets_changed));
		eol; cr;;

		Put_Line('/TYPING_OVERWRITES_BLOCK=' + Str(typing_overwrites_block));
		eol; cr;;

		Put_Line('/STREAM_BLOCK_MODE=' + Str(stream_block_mode));
		eol; cr;;

		Put_Line('/CTRL_Z=' + Str(Ctrl_Z));
		eol; cr;;

		Put_Line('/EOF_CR=' + Str(Eof_Cr));
		eol; cr;;

		Put_Line('/FILE_LOCKING=' + Str(File_Locking));
		eol; cr;;

//		Put_Line('/DISPLAY_TABS=' + Str(Display_Tabs));
//		eol; cr;;

		Put_Line('/TAB_EXPAND=' + Str(Tab_Expand));
		eol; cr;;

		Put_Line('/WORD_DELIMITS=' + Convert_String(Word_Delimits));
		eol; cr;;

		Put_Line('/MAX_UNDO=' + Str(Max_Undo));
		eol; cr;;

		Put_Line('/COLUMN_MOVE_STYLE=' + Str(Column_Move_Style));
		eol; cr;;

		Put_Line('/KEYWORD_HIGHLIGHTING=' + Str(Keyword_Highlighting));
		eol; cr;;

		Put_Line('/KEYWORD_CLINE_OVERRIDE=' + Str(Keyword_Cline_Override));
		eol; cr;;

		Put_Line('/CL_FOCUS_RECT=' + Str(CL_Focus_Rect));
		eol; cr;;

		Put_Line('/INSERT_MODE=' + str(Global_Int('Default_Insert_Mode')));
		eol; cr;;

		Put_Line('/BACKUPS=' + Str(Backups));
		eol; cr;;

		Put_Line('/INS_CURSOR=' + Str(INS_CURSOR));
		eol; cr;;

		Put_Line('/OVR_CURSOR=' + Str(OVR_CURSOR));
		eol; cr;;


		put_line('/GLOBAL_VARIABLES=');
		eol; cr;;


		// save every global that begins with a #
	gn =  First_Global( jx );
Loop:
	if(  svl(gn) ) {
		if( str_char(gn,1) == "#"  ) {
			if(  jx == 1  ) {
				call do_global_int;
			} else {
				call do_global_str;
			}
		}
		gn = Next_Global(jx);
		Goto Loop;
	}


    gn = "@Me_Serial#";
		call do_global_str;

    gn = "@Mewprocstart";
		call do_global_str;

    gn = "&Wcmdmapname";
		call do_global_str;

    gn = "&Wcmdmapinit";
		call do_global_str;

    #ifdef MEWDEMO
    //This global is used for the demo
    gn = "&Wcmdidpref";
    call do_global_int;
    #endif

    gn = "&Defaultfont";
		call do_global_str;

    gn = "&Defaultmenu";
		call do_global_str;

    gn = "&Defaultcolor";
		call do_global_str;

    gn = "!Backup_Path";
		call do_global_str;

    gn = "!Temp_Path";
		call do_global_str;

    gn = "@Tmp_File_Path";
		call do_global_str;

    gv = Global_Str('!Autosaveparms');
		var_remove_str('/H1=', gv );
		var_remove_str('/H2=', gv );

    gn = "!Autosaveparms";
		call do_global_str2;

    gn = "@Pgm_Menu_Bypass";
		call do_global_int;

    gn = "@Restore_Path";
		call do_global_str;

    gn = "@Restore_Flags";
		call do_global_int;

// session manager stuff
    gn = "~Session_New_Empty";
		call do_global_int;

    gn = "!Sess_Sort_Descend";
		call do_global_int;

    gn = "!Sess_Sort_By_Dir";
		call do_global_int;

    gn = "!Autoarrangerrsrc";
		call do_global_int;

    gn = "&Vcsenable";
		call do_global_int;

// calculator globals
    gn = "!Calc_Tape_Off";
		call do_global_int;

    gn = "Calc_Word_Length";
		call do_global_int;

    gn = "Calc_Unsigned";
		call do_global_int;

    gn = "!Calc_Force_Numlock";
		call do_global_int;

    gn = "@Default_Ext_List";
		call do_global_str;

    gn = "Default_Insert_Mode";
		call do_global_int;

    gn = "Reg_Exp_Style";
		call do_global_int;

    gn = "Switches";
    gv = GLobal_Str("Def_Switches");
		call do_global_str2;

    gn = "Def_Switches";
		call do_global_str;

    gn = "Repl_Switches";
    gv = GLobal_Str("Def_Repl_Switches");
		call do_global_str2;

    gn = "Def_Repl_Switches";
		call do_global_str;

    gn = "Fswitches";
    gv = GLobal_Str("Def_Fs_Switches");
		call do_global_str2;

    gn = "Def_Fs_Switches";
		call do_global_str;

    gn = "Fsearch_Path";
    gv = GLobal_Str("Def_Fs_Path");
		call do_global_str2;

    gn = "Def_Fs_Path";
		call do_global_str;

    gn = "Frswitches";
    gv = GLobal_Str("Def_Fsr_Switches");
		call do_global_str2;

    gn = "Def_Fsr_Switches";
		call do_global_str;

    gn = "Fsearch_Repl_Path";
    gv = GLobal_Str("Def_Fsr_Path");
		call do_global_str2;

    gn = "Def_Fsr_Path";
		call do_global_str;

    gn = "Fc_Config_Str";
		call do_global_str;

    gn = "Binary_Mode";
		call do_global_int;

    gn = "Toolhelpdelay";
		call do_global_int;


    gn = "Split_Edge_Mode";
		call do_global_int;

    gn = "No_Confirm_Overwrite";
		call do_global_int;

    gn = "Cursor_Eob";
		call do_global_int;

    gn = "@Restore";
		call do_global_int;

    gn = "@Maximize_Windows";
		call do_global_int;

    gn = "!Nofile_Hidden";
		call do_global_int;

    gn = "!Dosexecmethod";
		call do_global_int;

		gn = "BlockOffAfterPaste";
		call do_global_int;

		gn = "!ActivateFlags";
		call do_global_int;

		Gn = "!UseW32Exec";
		call Do_Global_Int;

		Gn = "@ExecKeep";
		call Do_Global_Int;

		Gn = "@ExecNoDisplay";
		call Do_Global_Int;

		Gn = "!ExecShutdown";
		call Do_Global_Int;

		Gn = "&DelErrWin";
		call Do_Global_Int;

		Gn = "&BtnOnRight";
		call Do_Global_Int;

    Gn = "&MsgOnLeft";
		call Do_Global_Int;

    Gn = "!DefaultRuler";
		call Do_Global_Int;

    Gn = "!DefaultAllRuler";
		call Do_Global_Int;

    Gn = "!ChkInBlock";
		call Do_Global_Int;

    Gn = "!KeepBlkMarking";
		call Do_Global_Int;

		Gn = "!DelKeyDelsBlk";
		call Do_Global_Int;

    Gn = "!Tmp_Global"; // flag for global template expansion
		call Do_Global_Int;

    Gn = "Oem_Mode";
    Call Do_Global_Int;

    Gn = "@History_Length";
    Call Do_Global_Int;

    Gn = "!Fprompt_Mode";
    Call Do_Global_Int;

		Set_Global_Int('SETUP_CHANGED', 0);

		save_file;
		error_level = 0;

		// TMJ - 01-15-93 08:52am
		// This is to  allow for other macros to be executed after the configuration
		// is changed
		str temp_stuff = global_str('@CONFIG_MACRO@');
		int jx;

		while(  temp_stuff != ''  ) {
			jx = xpos( ';', temp_stuff, 1 );
			if(  jx == 0  ) {
				jx = svl(temp_stuff) + 1;
			}
			Return_Int = 1;
			if(  jx > 1  ) {
				RM( copy( temp_stuff, 1, jx -1)  );
			}
			temp_stuff = str_del( temp_stuff, 1, jx );
		}
	}
	else
	{
		rm("MESSAGEBOX /B=2/T=Error Saving Configuration/M=Could not build INIT.CFG in MECONFIG.DB");
	}

	Goto END_OF_MAC;
/*********************************** SUBROUTINES *******************************/

do_global_str:
	put_line("/GS=" + gn + "=" + Convert_String( global_str(gn)));
	eol; cr;
	ret;

do_global_str2:
	put_line("/GS=" + gn + "=" + Convert_String( gv ));
	eol; cr;;
	ret;

do_global_int:
	put_line("/GI=" + gn + "=" + str( Global_Int(gn)));
	eol; cr;;
	ret;

do_global_int2:
  put_line("/GI=" + gn + "=" + str( gi));
	eol; cr;;
	ret;


END_OF_MAC:

/* clean up altered system variables */
	Undo_Stat = True;
	Insert_Mode = T_Insert_Mode;
	switch_win_id( active_window );
#endif // DEMO

}