macro_file mewlist2;

#include windows.sh
#include mewlist2.sh
#include mew_dlgs.sh
#include mew.sh


void ListSetCount( int list_hwnd, int count )
{
		// Set count to 0
	SendMessage( list_hwnd, LB_RESETCONTENT, 0, 0 );

		// Add nul strings till done
	while( count-- > 0 )
	{
		SendMessage( list_hwnd, LB_ADDSTRING, 0, 0 );
	}
}


void ListBoxDispStr(
										 int list_hwnd,           // Listbox hwnd
										 str delimit[1],          // field delimiter
										 str &disp_str,           // display str
										 int font_width,          // font width
										 int xoffset,             // Starting x position
										 int &disp_height,        // line height
										 int &width,              // calced width
										 int &incsearchfield      // incremental search field
										)
{
	str disp_str2;
	int  tx, theight;

	int Jz = 0;
	int jx = 1, jy;
	struct MewListDispRec dr;
			 //     {
			 //        asciiz  fieldname[33];
			 //        word  fieldx    ;
			 //        word  fieldw    ;
			 //        byte  fieldtype ;
			 //        int   fieldflags;
			 //     }
	width = xoffset;
pd_loop:
	jx = xpos( delimit, disp_str, jx);
	if(  jx != 0  ) {
		++Jz;
		jy = xpos('=', disp_str, jx + 1 );
		dr.fieldname = copy( disp_str, jx, jy - jx + 1 );
		jx = xpos( delimit, disp_str, jy + 1 );
		if(!jx)
			jx = svl(disp_str) + 1;
		disp_str2 = copy( disp_str, jy + 1, jx - jy - 1 );
		dr.fieldflags = 0;
		dr.fieldx = width;
		if(copy(disp_str2,1,1) == "/")
		{
			dr.fieldw = parse_int("/W=", disp_str2);
			dr.fieldtype = parse_int("/T=", disp_str2);
			switch ( dr.fieldtype )
			{
				case _FT_MENU :


				case _FT_EXT_TEXT :
				case _FT_TEXT :
				case _FT_KEYLABEL :
								if(!incsearchfield)
								{
									incsearchfield = jz;
								}
								dr.fieldw *= font_width;
			}
			theight = parse_int("/H=", disp_str2);
			if ( theight > disp_height )
			{
				disp_height = theight;
			}
			if(parse_int("/IS=", disp_str2))
			{
				incsearchfield = jz;
			}
		}
		else
		{
			val( tx, disp_str2 );
			dr.fieldw = tx * font_width;
			dr.fieldtype = 0;
			if(!incsearchfield)
			{
				incsearchfield = jz;
			}
		}
		SendMessage( list_hwnd, WM_ML2_ADDDISPREC , 0, &dr );
		width += dr.fieldw + 1;
		goto pd_loop;
	}


}


int ListBoxCreate( int mwin,              // The edit buffer/window number
									 int startline,         // The starting line in the buffer
									 int count,             // The number of lines
									 int x, y, w, h,        // Position and size in pixels
									 int id,                // Ctrl id
									 int flags,             // Flag bits. See _LB_FLAG_xxxx
									 int incsearch_field,   // Field number to use for  inc search
									 int parent,            // Parent window
									 str disp_str           // display string
									 )
{
	int tw = cur_window;
	int tr = refresh;
	int width = w, auto_width = (w==0),_flags = 0, xoffset = 2;
	int xstyle = ws_child | ws_visible | ws_border | ws_vscroll | ws_tabstop
										|  lbs_notify;

	int line_height = 0, font_height = 0, font_width = 0, dfont = 0;

	refresh = false;

//  ProcessMsgQueue( 10 );

	switch_window( mwin );

	Get_MEW_Dlg_Metrics( 0, line_height, font_height, font_width, dfont );


	if ( flags & _LB_FLAG_INCSEARCH )
	{
		xstyle |= lbs_wantkeyinput;
	}

	if ( flags & _LB_FLAG_SCROLLBAR )
	{
		xstyle |= lbs_disablenoscroll;
	}

	if ( flags & _LB_FLAG_EXTENDEDSEL )
	{
		xstyle |= lbs_extendedsel;
	}

	if ( flags & _LB_FLAG_HSCROLL )
	{
		xstyle |= ws_hscroll;
	}

	int list_hwnd = Create_MEW_List2( "", mwin,
					xstyle,
					x, y, w, h, parent, id);

	if(list_hwnd)
	{
		int disp_height = font_height + 1;

		SendMessage(list_hwnd, wm_setfont, dfont, 0 );


		if ( flags & _LB_FLAG_PTR )
		{
			xoffset += 10;
		}
	//  ProcessMsgQueue( 5 );

		if(disp_str != "")
		{
			ListBoxDispStr(list_hwnd,"", disp_str, font_width, xoffset, disp_height,
													 width, incsearch_field
													);
			if( !w )
				w=width;
		}

		SendMessage(list_hwnd , WM_ML2_SETDIMENSIONS, 0, disp_height);

		ListSetCount( list_hwnd, count );

		if(startline <= 0)
		{
			startline = 1;
		}
		sendmessage( list_hwnd, WM_ML2_SETLISTBUF, mwin, startline - 1);


		if((!auto_width) and (!w))
		{
			auto_width = TRUE;
			w = 50;
		}


		if ( flags & _LB_FLAG_INCSEARCH )
		{
			_flags |= 1;
		}
		if ( flags & _LB_FLAG_PTR )
		{
			_flags |= 2;
		}
    if ( flags & _LB_FLAG_NODBLCLICK )
    {
      _flags |= 8;
    }

		SendMessage( list_hwnd, WM_ML2_SETFLAGS, _flags, incsearch_field );

	 // ProcessMsgQueue( 5 );

		struct trect rcDlg;

		if(auto_width)
		{
			GetWindowRect(list_hwnd, &rcDlg);

			h = rcDlg.bottom - rcDlg.top + 1;

			if(( count * disp_height ) > (h - 4))
			{
				w += GetSystemMetrics( SM_CXVSCROLL ) + 2;
			}

			SetWindowPos( list_hwnd, 0, 0, 0,
											w, h,
											SWP_NOMOVE + SWP_NOZORDER );
		}


//      if (!( flags & _LB_FLAG_EXTENDEDSEL ))
     //   SendMessage( list_hwnd, WM_ML2_SETCARET, 0xFFFF, 0 );
       SendMessage( list_hwnd, WM_ML2_SETCARET, 1, c_line - startline );
			ProcessMsgQueue( 10 );
	}
	switch_window(tw);
	refresh = tr;
	return( list_hwnd );

}

int LBGetSelectCount( int list_hwnd  )
{
	return(SendMessage( list_hwnd, LB_GETSELCOUNT, 0, 0 ));
}

int LBIsItemSelected( int list_hwnd, int item )
{
	return(SendMessage( list_hwnd, LB_GETSEL, item, 0 ));
}

int LBSetHScroll( int list_hwnd, int width )
{
	return(SendMessage(list_hwnd, lb_sethorizontalext, width,0 ));
}

void LBSetMacroProc( int hListBox, str MacroStr )
/******************************************************************************
                               Multi-Edit Macro
                               26-Jan-96  14:14

  Function: Attach a translate macro to a listbox control.
  Entry   : int hListBox  - The listbox Windows handle
            str MacroStr  - The macro command line

               Copyright (C) 1996 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
  if ( hListBox ) {
    SendMessageStr( hListBox, wm_ML2_SetMacroProc, 0, MacroStr );
  }
}  // LBSetMacroProc
