macro_file MEWHELP;

#include mewhelp.sh
#include windows.sh
#include metools.sh
#include dialog.sh
#include WINEXEC.SH
#include DBTOOLS.SH
#include DB.SH

#ifdef _Debug_
	#include DBUG.SH
	#include SPRINTF.SH
#endif

#define mewmain_help        "MEW.HLP"
#define CONTENTS_HELPLINK   "CONTENTS"

#define _hlpFilesPg					"HLPFILES"
#define _hlpSelectFile			"@HlpSelectFile"

#define _hlp_Desc    				"DS"
#define _hlp_FilePath				"HFP"
#define _hlp_GlobalStr			"GS"

void MEW_MAIN_HELP() {
	MEWHELP("");
}

str Locate_Help_Main( )
/******************************************************************************
															 Multi-Edit Macro
															 24-Jan-96  00:07

	Function: `description`
	Entry   : `entry`
	Exit    : `exit`

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
  str HelpFile[ 1024 ] = SearchPath( MEWMAIN_HELP, "<ME_PATH>HELP;<ME_PATH>" );

  if ( Svl( HelpFile )  == 0 ) {
		HelpFile = g_HelpPath;
		if ( Svl( HelpFile ) != 0 ) {
    	HelpFile = SearchPath( MewMain_Help, HelpFile );
		}
    if ( Svl( HelpFile ) == 0 ) {
    	HelpFile = SearchPath( MewMain_Help, Get_Environment( "PATH" ) );
    }
  }
  return ( HelpFile );

}  // Locate_Help_Main

str Locate_Help_File( str FName )
/******************************************************************************
															 Multi-Edit Macro
															 24-Jan-96  00:06

	Function: `description`
	Entry   : `entry`
	Exit    : `exit`

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
  if ( Get_Path( FName ) != "" ) {
    return ( FName );
	}

  str HelpFile[ 1024 ] = g_HelpPath;

  if ( Get_Extension( FName ) == "" ) {
    FName += ".HLP";
	}
	if ( Svl( HelpFile ) != 0 ) {
    HelpFile = SearchPath( FName, HelpFile );
	}
  if ( Svl( HelpFile ) == 0 ) {
		HelpFile = SearchPath( FName, Get_Environment( "PATH" ) );
    if ( Svl( HelpFile ) == 0 ) {
      HelpFile = SearchPath( FName, "<ME_PATH>HELP;<ME_PATH>" );
    }
  }
  if ( Svl( HelpFile ) == 0 ) {
    HelpFile = FName;
	}
  return ( HelpFile );

}  // Locate_Help_File

void MEWHELP(str help_Str = Parse_Str ('/H=', mparm_str)) TRANS2 {
/*

	The main help macro for Multi-Edit for Windows
		Parameters:
			help_str		should be in the format "file^param"
									File can be any Windows help file.  It may or may
									not contain a path.  If a path is not provided,
									the path or paths contained in the global string
									"!HELP_PATH!" will be searched.  File also
 									assumes an extension of .HLP if one is not
 									specified.
									Param can be a character string corresponding to
									a keyword search string contained in the help
 									file, or it is expected to be a numeric value
 									corresponding to a context string contained in
 									the help file.
*/
  int t_int, context_int = 0,
			do_search = parse_int("/SEARCH=",mparm_str);
	str help_file = help_str,
			help_param = "",
      help_path = "",
      tstr;


	if (help_file == "") {
    help_file = Locate_Help_Main();
		help_param = CONTENTS_HELPLINK; // default to main help screen
	} else if (t_int = xpos("^",help_file,1)) {
    help_file = caps(copy(help_file,1,t_int - 1));
    if ((help_file == "") || (help_file == mewmain_help)) {
      help_file = Locate_Help_Main();
		}
		help_param = copy(help_str,t_int + 1,255);
	} else {
		help_param = help_file;
    help_file = Locate_Help_Main();
	}

	if (!Xpos(".", help_file,1)) {
		help_file = help_file + ".HLP";
	}

  if( get_path( help_file ) == "" )
  {
    help_file = Locate_Help_File( help_file );
  }

	if ( Get_Extension( Help_File ) == "INF" ) {
    Help_File = truncate_extension(Help_File);
		TStr = "VIEW.EXE " + Help_File + " " + Help_Param;
		T_Int = WinExecAndWait( TStr, "", _EP_Flags_DontWait, "", "" );
	}
	else if ( Do_Search ) {
  	t_int = WinHelpStr(frame_handle, help_file,
												HELP_PARTIALKEY, "");
	} else if (!val(context_int,help_param)) {
  	t_int = WinHelp(frame_handle, help_file,
                    HELP_CONTEXT, context_int);
	} else {
  	t_int = WinHelpStr(frame_handle, help_file,
												HELP_PARTIALKEY, help_param);
	}

  RETURN();
}

void MEWHELP_CONTEXT ()
{
  MewHelp (Global_str ('!MEWHELP_CONTEXT'));
}
void MEWHELP_SEARCH() {
	RM("mewhelp /SEARCH=1");
}

void Ext_Help( ) trans2
/*
 Invokes extension specific help.  Gets the word at the cursor or
 the text in the currently marked block (if the cursor is in the
 block) and searches in the help file configured under extension
 setup.
*/
{
  str Help_Str;
	str	Help_File;
  str Help_Search_Str;
  str ext = Get_Extension( File_Name );
	str MacName;

	int Ext_Str_Pos;
	int Jx;

  Rm( "Find_Ext /EXT=." + ext );
  Help_Str = Parse_Str( "\x7F" + "HLP=", Global_Str( Return_Str ) );

	Return_Int = False;
	Help_Str = TranslateCmdline( Help_Str, File_Name );
	if ( Copy( Help_Str, 1, 2 ) == "@>" ) {
		if ( !( Jx = XPos( ";", Help_Str, 1 ) ) ) {
			Jx = Svl( Help_Str ) + 1;
		}
		MacName = Copy( Help_Str, 3, Jx - 3 );
		Help_Str = Copy( Help_Str, Jx + 1, Svl( Help_Str ) - Jx );
		Return_Int = False;
		if ( Svl( MacName ) ) {
			Rm( MacName );
		}
	}
	if ( !Return_Int ) {
  	Help_Search_Str = Get_Context( "" );
  	if ( XPos( ";", Help_Str, 1 ) ) {

    	int TWid 					= Window_Id;
    	int SavRefresh 		= Refresh;
    	int SavInsertMode = Insert_Mode;

    	Refresh = FALSE;
    	Insert_Mode = TRUE;

    	Create_Window;
    	Put_Line( Help_Str );
    	while ( Find_Text( ";", 0, 0 ) ) {
      	Del_Char;
      	Cr;
    	}
    	Tof;

      if(Global_Str("EH." + ext) != "")
      Find_Text( "^| " + make_literal_x( Global_Str("EH." + ext)) + " |$", 0, _RegExp );

    	int Dlg;

    	DlgCreate( Dlg );

    	DlgAddCtrl( Dlg, DLG_BitmapStatic, "BT_HL_101",
					3, 2,
					0, 0,
					2010, 0, "" );
    	DlgAddCtrl( Dlg, Dlg_ListBox, "",
					Dlg_PosOffset + Dlg_StanBtnWidth, 1,
					30, 5,
					2100, DLGF_LBIncsearch, "/INCO=2/WIN=" + Str( Cur_Window ) );
    	DlgAddCtrl( Dlg, DLG_PushButton, "OK",
					1, 7,
					Dlg_StanBtnWidth, 0,
					102, DLGF_Defbutton, "/R=1" );
    	DlgAddCtrl( Dlg, DLG_PushButton, "Cancel",
					Dlg_PosOffset + Dlg_StanBtnWidth + 2,
					DLG_PosOffset, Dlg_StanBtnWidth, 0,
					102, DLGF_Defbutton, "/R=0" );
    	DlgAddCtrl( Dlg, DLG_PushButton, "&Help",
					Dlg_Posoffset + Dlg_StanBtnWidth + 10,
					DLG_PosOffset, Dlg_StanBtnWidth, 0,
					103, 0, "/R=2" );

    	Return_Int = DlgExecute( Dlg, 2100, "Select Help File", "", "" ,0 );
    	DlgKill( Dlg );

    	Help_Str = Get_Line( );

    	Delete_Window;
    	Switch_Win_Id( TWid );
    	Refresh = SavRefresh;
    	Insert_Mode = SavInsertMode;

    	if ( !Return_Int ) {
      	return ( );
    	}
      Set_Global_Str("EH." + ext, help_str);
  	}
  	if ( Jx = XPos( "^", Help_Str, 1 ) ) {
    	Help_File = Copy( Help_Str, 1, Jx - 1 );
    	Help_Search_Str = Copy( Help_Str, Jx, 255 );
  	}
		else {
    	Help_File = Help_Str;
    	//help_search_str = "";
  	}
		MewHelp( Help_File + "^" + Help_Search_Str );
	}
  return ( );

}  // Ext_Help

str Get_Context(str tstr[100]) trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

	Macro   : Get_Context
	Function: Return the word under the cursor defined by the passed Regular
						Expresson or the word marked by a column or stream block.  The
						marked word will only be used if the cursor is on the same line
						as the marked word.

							 (C) Copyright 1994 by American Cybernetics, Inc.
***********************************************************************(ldh)***/

	str tstr2[100];
  int org_refresh, org_reg, col, tc;
	int tpb = persistent_blocks;
	persistent_blocks = TRUE;

	/* Set up our context */
	org_refresh = REFRESH;
	REFRESH = FALSE;                       /* No flashing of windows */
	org_reg = Reg_Exp_Stat;
	Reg_Exp_Stat = TRUE;                   /* Regular expression search */

	Mark_Pos;                               /* Save current column position */

//	tstr = Return_Str;                     /* Get Word Definition */
	if(  tstr == ''  ) {
		tstr = '[A-Za-z0-9._]';
	}
	tstr2 = Str_Ins('~', tstr, 2);

	if(  Marking  ) {
		Block_End;
	}
	if(  (Block_Stat > 1) & (Block_Line1 == C_Line) & (Block_Line2 == C_Line)  ) {
		Goto_Col(Block_Col1);
		col = Block_Col2 + 1;
	} else {
		Search_Bwd(tstr, 1);
		if(  Search_Bwd(tstr2, 1) == 0  ) {
			Goto_Col(1);
		}
		Search_Fwd(tstr, 1);
		Mark_Pos;
		if(  Search_Fwd(tstr2, 1) == 0  ) {
			EOL;
		}
		col = C_Col;
		Goto_Mark;
	}

  tc = c_col;

	/* Grab the characters that make up this word */
	Return_Str = '';
	while(  (C_Col < col)  ) {
		Return_Str = Return_Str + Cur_Char;
		right;
	}

	/* Restore original cursor position */
	Goto_Mark;

	REFRESH = org_refresh;
	Reg_Exp_Stat = org_reg;
	persistent_blocks = tpb;
  Set_Highlight(c_line,tc,c_line, col );
	return ( Return_Str );

}  // Get_Context

macro REGEXPHELP
{
  if ( GLOBAL_INT('reg_exp_style') )
  {
    rm('mewhelp /H=UNIX STYLE REGULAR EXPRESSIONS');
  }
  else
  {
    rm('mewhelp /H=CLASSIC REGULAR EXPRESSIONS');
  }
  return_int = 0;

}  // RegExpHelp

void HlpSetGlobals( ) trans2
/******************************************************************************
															 Multi-Edit Macro
															 24-Jan-96  00:58

	Function: `description`
	Entry   : `entry`
	Exit    : `exit`

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	int ActiveWin	 = Window_Id;
	int SavRefresh = Refresh;
	int FirstRec 	 = 0;
	int NumRec;
	int CfgWin;

	str Line;
	str GStr;
	str HFile;

	Refresh = False;
	DbGetPage( "MECONFIG", _hlpFilesPg + ".DB", FirstRec, NumRec );
	if ( NumRec ) {
		CfgWin = Cur_Window;
		while ( NumRec-- ) {
			Line = Get_Line_From_Win( FirstRec++, CfgWin );
			GStr = Parse_Str( "\x7F" + _hlp_GlobalStr + "=", Line );
			if ( Svl( GStr ) != 0 ) {
				HFile = Parse_Str( "\x7F" + _hlp_FilePath + "=", Line );
				Set_Global_Str( GStr, HFile );
			}
		}
	}
	Switch_Win_Id( ActiveWin );
	Refresh = SavRefresh;

}  // HlpSetGlobals

void HlpManageFiles( ) trans2
/******************************************************************************
															 Multi-Edit Macro
															 24-Jan-96  00:50

	Function: `description`
	Entry   : `entry`
	Exit    : `exit`

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	Db( "MECONFIG.DB", _hlpFilesPg + ".DB", "MEWHDRS.DB", _hlpFilesPg + ".HDR",
			"Manage Help Files",
			"",
			_hlpSelectFile,
			Parse_Int( "/LO=", MParm_Str ),
			Mparm_Str + "/H=" + "/BMP=/NDF=1/NDH=1/MOVE=1/NOALPHA=1" );

	if ( Global_Int( "@DB_FILE_CHANGED" ) ) {
		HlpSetGlobals( );
	}
}  // ReEditAlias