// $Header: /MeShare/Src/METOOLS.SH 24    4/03/96 10:37a Todd $

// Block_Stat constants
#define _LinBlock		1
#define _ColBlock		2
#define _StrBlock		3
#define _StrBlockNI	4

Global {
	// Set True for block ops to only work when cursor is in a block
  int g_ChkInBlock      "!ChkInBlock";
  int g_LastBlockType   "@Last_Block_Type";
	int g_KeepBlkMarking	"!KeepBlkMarking";
	int g_DelKeyDelsBlk		"!DelKeyDelsBlk";
  str g_DefTransInTbl   "!DefTransInTbl";
  str g_DefTransOutTbl  "!DefTransOutTbl";

}

Prototype METOOLS {
  void WriteIt( );
/******************************************************************************
  Function: Runs the passed macro and writes the string in Return_Str returned
            by the macro to the current cursor position.

  Entry   : Macro command line
********************************************************************( ldh )***/

  void SetDefTransTbls( );
/******************************************************************************
  Function: Sets the default tables global variables used by the Translate
            macro to convert alpha characters from one case to the other.
********************************************************************( ldh )***/

  str Translate( str String, str OutTable, str InTable, ...);
/******************************************************************************
  Function: Returns a string with characters in String that are in InTable
            translated to the corresponding character in OutTable (OutTable is
            padded with PadChar if needed).  If neither translate table is
            specified, String is translated to opposite case as setup by the
            SetDefTransTbls fuction.

  Entry   : str String      - The string                                ( /S= )
            str OutTable    - Output table                              ( /O= )
            str InTable     - Input table                               ( /I= )
            [ str PadChar ] - Optional pad character (defaults to blank)

  Exit    : str             - Translated string
********************************************************************( ldh )***/

  int StrAbbrev( str FullStr, str TestStr, ... );
/******************************************************************************
  Function: Return True when TestStr is equal to the leading characters of
            FullStr and the length of TestStr is at least Len long, otherwise
						return False.

  Entry   : str FullStr		- Full string to check the abbreviated string against
						str TestStr 	- The abbreviated string
						[ int Len ] 	- Optional length, default length of TestStr

  Exit    :	int
							True      	- Match found
							False     	- No match
********************************************************************( ldh )***/

  str StrCenter( str String, int Len, ... );
/******************************************************************************
  Function: Returns a string of length Len with String center in it, optionally
            padded with PadChar (defaults to blank) or truncated as needed.
            Odd number of truncation is applied to the right side.

  Entry   : str String      - String to center
            int Len         - Length of return string
            [ str PadChar ] - Optional pad character

  Exit    : str             - String of length Len with String center in it.
********************************************************************( ldh )***/

  str StrLeft( str String, int Len, ... );
/******************************************************************************
  Function: Returns a string of length Len containing the left-most Len
            characters of String, padded with Pad or truncated on the right as
            needed.  PadChar defaults to blank.

  Entry   : str String      - The string
            int Len         - The length of the returned string.
            [ str PadChar ] - Optional pad character (defaults to blank)

  Exit    : str             - The Len left most chars of String.
********************************************************************( ldh )***/

  str StrRight( str String, int Len, ... );
/******************************************************************************
  Function: Returns a string of length Len containing the right-most Len
            characters of String, padded with Pad or truncated on the left as
            needed.

  Entry   : str String      - The string
            int Len         - The length of the returned string
            [ str PadChar ] - Optional pad character (defaults to blank)

  Exit    : str             - The right-most Len characters of String
********************************************************************( ldh )***/

  str StrCopies( str String, int Cnt);
/******************************************************************************
  Function: Returns Cnt concatenated copies of String.

  Entry   : str String    - The string
            int Cnt       - Number of copies to concatenate
  Exit    : str           - The concatenated string
********************************************************************( ldh )***/

  str TranslateCmdLine( str cmdline, str fname );
/******************************************************************************
Description:  Translates cmdline so that any occurances of
							<FILE>, <NAME>, <EXT>, <PATH>, <ME_PATH>, <USER_PATH>, <MAC_PATH>
								are expanded out.

							Also, <%str> is now expanded out to whatever the environment
							variable "str" is.
							AND, <~str> is now expanded out to the value of
							Global_Str( str ).

							fname is the file name to be used.
******************************************************************************/

	str GetUserMacroPath();
	/******************* Multi-Edit STRING Macro Function ***********************

	 DESCRIPTION:  Returns the path to place user generated .MAC files in.
	*****************************07-23-93 11:15am*******************************/

	str GetUserPath( );
	// Simply returns User_Path

	str CreateUserPath( str path, int copy_default );

	str TempFileName( str path );

	int LocateDbPage( str fname, str page_title, int create_if_not_found  );
	/*******************************************************************************
	Description: Loads up the specified DB file (if it is not already
							loaded), and then searches for the specified page title.

	Returns:    1 IF the title was found,
							0 If NOT found.

	Parameters:   fname                   The db file name.
								page_title              The page Title.
								create_if_not_found     1 = Create page if not found.

	*******************************************************************************/

	int GetDbRecord(
	/****************************************************************************
	Description:  Finds and returns the specified record in a .DB file.
	Returns:
								1 if found
								0 if not found, but first record is stored in /GLO=
							 -1 if not found and there are no records.
							 -2 if the DPT is not found in the DB file.
							 -3 if the DB file is not found.

	This only works for string and integer fields
	****************************************************************************/
					str fname,           // db filename
					str dpt,             // data page title
					str dbf,             // field name
					str fv,              // field value
					int rec_num,         // record # to return (overrides fv
															 //   and dbf).  Example:  If /#=3 then the
															 //   3rd record will be returned.
					int flags,           // 1 = case sensitive search
					str global_name,     // name of global variable to store record
					int remove_file,     // if TRUE, then remove DB file from memory
															 //    after operation
					str misc             // Misc parameters
															 //   /AGLO=n  name  of global integer
															 //            to store total #  of
															 //            records
															 //   /LD=str  Delimit to use, default is
															 //            ASCII 127
								 );

	int CheckDupFields (str dbpage, str dbline, str fielddata, ...);
	//******************************************************************************
	// Check for duplicate fields in records of a dbpage.  The current window is
	// the current db file.
	//
	//  dbpage    = strname of page for db list
	//  dbline    = Skip this record
	//  fielddata = str of field data to compare
	//  ...       = optional field names to compare in each record, must be strings i.e. NAME=
	//
	//******************************************************************************
	str SearchPath( str fname, fpath );
/******************************************************************************
	Description: Searches for a filename in a given path
							TranslateCmdLine is called to parse out any metacommands BEFORE
							the search takes place.

	Returns:    complete path and filename, or a NUL string if
							the search was not successful.

******************************************************************************/

	int CursorInBlock( int Offset );
/******************************************************************************
  Function: Check if cursor is in a marked block.
	Entry		: int Offset - True to offset cursor - 1 when non-inclusive block
												 marked.  ( "/O" )
  Exit    : int
              False = Cursor NOT in block or no block marked.
              True	= Cursor in block.
********************************************************************( ldh )***/

	int PushBlock( int Hide );
/******************************************************************************
  Function: Pushes the current marked block info on a block stack
  Entry   : int Hide 		- !0 to turn block off after being pushed ( "/H" )
  Exit    :	int 				- # of the pushed block
********************************************************************( ldh )***/

	int PopBlock( int Show );
/******************************************************************************
  Function: Pops block information off ot the block stack.
  Entry   : int Show 		- !0 to show popped block else throws info away ( "/S" )
  Exit    :	int 				- # of the block poped.
********************************************************************( ldh )***/

	void MarkBlock( int Type, int BlkOff, int Extend, int Message, str Misc );
/******************************************************************************
  Function: Mark, extend or unmark a block.
  Entry   : int Type 		Block Type ( /T=int )
								1				- Line block
								2				-	Column block
								3				-	Inclusive stream block
								4				-	Noninclusive stream block.
							other			-	Block off

						int BlkOff	Will not turn block off if block is of different type
												( /O=1 )
						int Extend	Extend current block ( /E=int )
								1				- Extend end of block to cursor
								2				- Extend beginning of block to cursor
						int Message	Show messages when True ( /NM=1 no messages )
						str Misc		Additional parameters for future expansion

  Exit    : None
********************************************************************( ldh )***/

int GetFileTime( str FileName );
/******************************************************************************
															 Multi-Edit Macro
																9/28/95 6:15PM

  Function: Return the time of FileName.
  Entry   : str FileName  - Name of file to get the time for
  Exit    : int						- File time

********************************************************************( ldh )***/

}


#DEFINE  EVENT_CURSOR_LINE      0x0001  // Trigger event on vertical cursor move
#DEFINE  EVENT_CURSOR_COL       0x0002  // Trigger event on hortical cursor move
#DEFINE  EVENT_WCMD             0x0004  // Trigger event on WCMD
#DEFINE  EVENT_KEY_ENHANCED     0x0008  // Trigger event on key IF no wcmd was generated
#DEFINE  EVENT_DELETE_WIN       0x0010  // Trigger event before a window is deleted
#DEFINE  EVENT_ACTIVATE_WIN     0x0020  // Trigger event when a window is actived
#DEFINE  EVENT_DEACTIVATE_WIN   0x0040  // ... when a window is deactivated
#DEFINE  EVENT_MOUSE_VSCROLL    0x0080  // ... when a vertical scrolll is used
#DEFINE  EVENT_MOUSE_HSCROLL    0x0100  // ... when a horizontal scrolll is used
#DEFINE  EVENT_PRESAVE          0x0200  // ... before file is saved
#DEFINE  EVENT_POSTSAVE         0x0400  // ... after file is saved
#DEFINE  EVENT_WORDWRAP         0x0800  // ... after a wordrap/paragraph reformat  occurs
#DEFINE  EVENT_ACTIVATE_APP     0x1000  // ... after the whole app is activated
#DEFINE  EVENT_DEACTIVATE_APP   0x2000  // ... after the whole app is deactivated
#DEFINE  EVENT_MODE_ENHANCED    0x8000  // Enabled the above events


structure DOS_FIND_DATA
{
  byte fill[21];
  byte attr;
  int time;
  int size;
  asciiz name[13];
}

structure SYSTEMTIME
{
  int16 wYear          ;
  int16 wMonth         ;
  int16 wDayOfWeek     ;
  int16 wDay           ;
  int16 wHour          ;
  int16 wMinute        ;
  int16 wSecond        ;
  int16 wMilliseconds  ;
}

structure WIN32_FIND_DATA
{
    int dwFileAttributes;
    int ftCreationTimeLow;
    int ftCreationTimeHi;
    int ftLastAccessTimeLow;
    int ftLastAccessTimeHi;
    int ftLastWriteTimeLow;
    int ftLastWriteTimeHi;
    int nFileSizeHigh;
    int nFileSizeLow;
    int dwReserved0;
    int dwReserved1;
    asciiz cFileName[ 260 ];
    asciiz cAlternateFileName[ 14 ];
}