// $Header: /MESHARE/SRC/MESYS.S 172   4/22/96 9:45a Todd $

#ifdef Windows
	macro_file MEWSYS;

  #define LFN     // Turn Long File Names on

	#define MasterHeader      "MEWHDRS.DB"
	#define GOTOLINE_HELPLINK "GOTO LINE NUMBER"
	#define hc_AlreadyLoad		"CONTENTS"
	#define FILELOCK_HELPLINK	"FILE LOCKING"

	#include MEW.SH
	#include WINDOWS.SH
	#include MEWLIB.SH
	#include DIALOG.SH
	#include COLORS.SH
	#include MEWHELP.SH
  #include TEMPLATE.SH
	#include LANGUAGE.SH
	#include DBTOOLS.SH
	#include EXIT.SH
	#include HEX.SH

	#ifdef _Debug_
		#include DBUG.SH
    #include MSGLOG.SH
	#endif
#else
	macro_file MESYS;

	#define MasterHeader 			""
	#define hc_AlreadyLoad		"FL"
#endif

#include WINDOW.SH
#include METOOLS.SH
#include MEUTIL2.SH

/*******************************************************************************
														MULTI_EDIT MACRO FILE

MESYS is loaded automatically by Multi-Edit upon startup.  Multi-Edit will
abort if it cannot find the MESYS macro file.

MESYS contains the following macros:

UNDO            Executes an UNDO or REDO
SETSCRN         Sets up the screen based on the selected style.
INSTGL          Toggles insert/overwrite mode.
BSWORD          Deletes the word before the cursor.
DELWORD         Deletes the word under the cursor.
DELEOL          Delete to end of line.
DEL_TO_HOME     Deletes to the home position of the line
DEL             Processes the <DEL> key in a CUA compliant manner.
HOME            Implements the multi-stroke start of line/window/file function.
END             Implements the multi-stroke end of line/window/file function.
SHIFT_CURSOR    Handles SAA/CUA complient shifted cursor key use
CR              Implements carriage return with indenting styles.
TAB             Processes <TAB> and <ShiftTAB> in a CUA compiant manner
DATETIME        Stamps the date and time into a file.
GOTOLINE        Prompts for a line number to go to.
TOPBLOCK        Cursor to top of block.
ENDBLOCK        Cursor to end of block.
TOPWIN          Cursor to top of window.
BOTWIN          Cursor to bottom of window.
SCROLLUP        Scroll the window up one line.
SCROLLDN        Scroll the window down one line.
PAGEBRK         Insert a line with a page break.
SPACE           Inserts a space character at the current cursor position.
MEXTCHGLINE     Goes to next/previous changed line.
FIND_EXT        Retrieves the extension specific setup from EXT.DB.
SETTABS         Creates a temporary format line from the tab spacing parameter.
EXTSETUP        Setup a file/window format based on its extension.
PATHSEARCH      Searches for a filename in a given path
SETFILENAME     Adds in the default directory for an extension.
CREATEWINDOW    Creates a new window at the end of the window list.
LDFILES         Load files into windows.  Allows wildcards.
AUTOSAVE        Implements the automatic save feature.
AUTOSAVETIMER   Manages autosave timer events.
SETAUTOSAVE     Initializes timer events for AUTOSAVE
SETWINDOWNAMES  Creates sequential window letters for all editable windows.
KEYMAC_LOAD     Loads, saves, erases keystroke macros from KEYMAC.DB
PARMS1          Process command line switches.
PARMLOAD        Load files from the command line.

							 (C) Copyright 1991 by American Cybernetics, Inc.
********************************************************************************/


#IFNDEF windows
	#INCLUDE dosonly.s
#ENDIF


macro Undo trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: UNDO

Description:  Performs an UNDO or REDO

Parameters:   /R        causes a REDO instead of an UNDO

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	if ( XPos( "/R", Caps( MParm_Str ), 1 ) ) {
		Redo;
	}
	else {
		Undo;
	}
}  // Undo

int InsTgl( int CMStyle = Parse_Int( "/CMS=", MParm_Str ) ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Aug-95  01:33

  Function: Toggles between insert and overwrite modes and if CMStyle not zero
						set the column move style to delete spaces in insert mode and
						leave spaces in overwrite mode.

  Entry   : CMStype 		Not zero to toggle column_move_style variable also.
  Exit    : Previous insert_mode.
            Insert_Mode toggled and Column_Move_Style set appropriately

              Copyright (C) 1991-95 by American Cybernetics, Inc.
********************************************************************( ldh )***/

  int Result = Insert_Mode;

  Insert_Mode = !Insert_Mode;
  if ( CMStyle ) {
		Column_Move_Style = Insert_Mode;
  }
  return ( Result );

}  // InsTgl

macro BSWORD TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: BSWORD

Description:  This macro deletes the word before the cursor(And you thought it
							had something to do with cow pies).

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	Push_Undo;
	if( read_only )
	{
		return();
	}

	if(  C_Col == 1  ) {
		BACK_SPACE;
		GOTO EXIT;
	}

	if(  at_eol  ) {
		eol;
		if(c_col == 1)
		{
			goto exit;
		}
	}
	LEFT;
	if(xpos(cur_char,'|255|9 ',1))
	{
		call Kill_White_Space;
	}
	else if(  XPOS( cur_char, word_delimits, 1)  ) {
		Call Kill_Delimits;
	//  Call Kill_White_Space;
	//  Call Kill_Word;
	//  Call Kill_White_Space;
	} else {
		Call Kill_Word;
	//  Call Kill_White_Space;
	}
	RIGHT;
	goto EXIT;


kill_white_space:
	if(  (xpos(cur_char,' |9|255',1)) & NOT(at_eol)  ) {
		del_char;
		if(  (C_Col > 1)  ) {
			left;
			Goto KILL_WHITE_SPACE;
		} else {
			Goto EXIT;
		}
	}
	RET;



KILL_WORD:
	if(  xpos(cur_char,word_delimits,1) == 0  ) {
		del_char;
		if(  (C_Col > 1)  ) {
			left;
			Goto KILL_WORD;
		} else {
			Goto EXIT;
		}
		right;
		goto exit;
	}
	RET;

KILL_DELIMITS:
	if((xpos(cur_char,word_delimits,1) != 0) && (xpos(cur_char,'|255|9 ',1) == 0)  ) {
		if(  NOT( at_eol )  ) {
			del_char;
		}
		if(  (C_Col > 1)  ) {
			left;
			Goto KILL_DELIMITS;
		} else {
			Goto EXIT;
		}
	}
	RET;

EXIT:
	Pop_Undo;
}

macro DELWORD TRANS2  {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DELWORD

Description:  This macro deletes the word after the cursor

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int jx,tr;

	if( read_only )
	{
		return();
	}

	tr = refresh;
	jx = 0;

	Push_Undo;

	if(  (AT_EOL)  ) {
		Del_Char;
		Goto Exit;
	}

	refresh = false;
	if( read_only )
			goto exit;
Delete1:
	/* IF on white space, then delete only to non-white space  */
	if(  xpos(cur_char,' |255|9', 1) != 0  ) {
	delete_white_space:
		while(  NOT(At_Eol) & (xpos(cur_char,' |255|9', 1) != 0)  ) {
			++jx;
			Del_Char;
		}
		if(  jx == 1  ) {
			call delete_word_delimits;
		}
		goto exit;
	}

	++jx;
	if(  (XPOS(Cur_Char,Word_Delimits,1) != 0)  ) {
		call delete_word_delimits;
		GOTO delete_white_space;
	}
	while(  (NOT(AT_EOL)) & (XPOS(Cur_Char,Word_Delimits,1) == 0)  ) {
		++jx;
		Del_Char;
	}
	goto delete_white_space;


delete_word_delimits:
	while(!AT_EOL && XPOS(Cur_Char,Word_Delimits,1)
		&& !xpos(cur_char,'|255|9 ',1) )
	{
		++jx;
		del_char;
	}
	ret;

EXIT:
	refresh = tr;
	Pop_Undo;

}

macro DELEOL TRANS2  {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DELEOL

Description:  Deletes to the end of a line

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int jx;
	Jx = Length(Get_Line);
	Del_Chars(jx - c_col + 1);
}

macro DEL_TO_HOME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DEL_TO_HOME

Description:  Deletes to the home position of the line

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int jx = c_col;
	push_undo;
	first_word;
	if ( c_col >= jx )
		goto_col(1);
	del_chars( jx - c_col );
	pop_undo;
}

void Del( ) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 29-Aug-95  12:21

  Function: Deletes character that the cursor is on OR iff a block is marked
						and the cursor is in the block, then that block is deleted.

  Entry   : /I=1		Delete block only when cursor is in a block
  Exit    : None

							Copyright (C) 1991-95 by American Cybernectic, Inc.
********************************************************************( ldh )***/

  int InBlk = Parse_Int( "/I=", MParm_Str );
	int SavRefresh = Refresh;

	if ( InBlk == 0 ) {
		InBlk = Global_Int( "!ChkInBlock" );
	}
  if ( InBlk == 1 ) {
    InBlk = CursorInBlock( True );			// Check cursor in block
	}
	else {
    InBlk = Block_Stat;                 // Block marked
	}
  if ( InBlk && g_DelKeyDelsBlk ) {
		Delete_Block;
	}
	else {
		Refresh = False;
		Del_Char;
		Right;
		Left;
		Refresh = SavRefresh;
	}
}  // Del

void BsKey( ) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 29-Aug-95  12:21

  Function: Deletes the previous character OR iff a block is marked and the
						cursor is in the block, then that block is deleted.

  Entry   : /I=1		Delete block only when cursor is in a block
  Exit    : None

							Copyright (C) 1991-95 by American Cybernectic, Inc.
********************************************************************( ldh )***/

  int InBlk = Parse_Int( "/I=", MParm_Str );

	if ( InBlk == 0 ) {
	InBlk = Global_Int( "!ChkInBlock" );
	}
  if ( InBlk == 1 ) {
    InBlk = CursorInBlock( True ); 		// Check cursor in block
	}
	else {
    InBlk = Block_Stat;               // Block marked
	}
  if ( InBlk && g_DelKeyDelsBlk ) {
		Delete_Block;
	}
	else {
		Back_Space;
	}
}  // BsKey

#IFDEF windows

global
{
	str _KEY_TIMER "!_KEY_TIMER";
}

macro HOME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: HOME

Description:  Implements the home function as follows:

			If the home key is pressed once, then the cursor will go to:
					A.  The current indent level if the cursor is beyond the current
							indent level.
					B.  Column 1 if the cursor is less than or equal to the current
							indent level.

			The following stuff requires that the /T=nn parameter be passed to HOME
			where nn is the number of milliseconds to wait for the next keypress.

			If the home key is pressed twice in rapid succession and the cursor is NOT
					at the top of the window, then the cursor will go to the top of the
					window.  If the cursor is at the top of the window, then the cursor
					will be moved to the top of the file.

			If the home key is pressed three times in rapid succession, then the cursor
					will be moved to the top of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int tm = 36, tc ;
	str key_timer[40] = _KEY_TIMER;

	int last_time, last_op, new_op = 0, last_function;

	var_parse_int("/LT=", key_timer, last_time );
	var_parse_int("/LO=", key_timer, last_op );
	var_parse_int("/LF=", key_timer, last_function );

	if ((key1 != prev_key1) || (key2 != prev_key2) || (last_function != 1) || (last_keypress_time > (last_time + tm)) || ( last_op >= 2) )
	{
		new_op = 0;
	} else {
		if(c_col == 1)
			new_op = last_op + 1;
	}


	PUSH_UNDO;

	switch ( new_op )
	{
		case 1 :
							refresh = FALSE;
							while(  c_row > 1  ) {
								up;
							}
							refresh = TRUE;
							goto_col(1);
							redraw;
							break;

		case 2 :
							tof;
							break;

		case  0 :
		default:
							tc = c_col;
							if ( c_col > 1 )
							{
								first_word;
								if( (c_col < tc)  && (c_col > 1) )
								{
									--new_op;
									break;
								}
							}
							goto_col(1);
							break;
	}

exit:
	_KEY_TIMER = "/LT=" + str(last_keypress_time) + "/LO=" + str(new_op) + "/LF=" + str(1);
	POP_UNDO;
}

#ELSE
macro HOME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: HOME

Description:  Implements the home function as follows:

			If the home key is pressed once, then the cursor will go to:
					A.  The current indent level if the cursor is beyond the current
							indent level.
					B.  Column 1 if the cursor is less than or equal to the current
							indent level.

			The following stuff requires that the /T=nn parameter be passed to HOME
			where nn is the number of milliseconds to wait for the next keypress.

			If the home key is pressed twice in rapid succession and the cursor is NOT
					at the top of the window, then the cursor will go to the top of the
					window.  If the cursor is at the top of the window, then the cursor
					will be moved to the top of the file.

			If the home key is pressed three times in rapid succession, then the cursor
					will be moved to the top of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  k1, k2, tm = 18, tc, t ;

	k1 = key1;  k2 = key2;

	PUSH_UNDO;
loop:
	tc = c_col;
	if(  tc > 1  ) {
		first_word;
	}
	if(  (c_col > 1) && (c_col < tc)  ) {
		goto exit;
	}
	if(  (at_eol)  ) {
		if(  tc > indent_level  ) {
			goto_col(indent_level);
		}
	} else {
		if(  c_col >= tc  ) {
			goto_col(1);
		}
	}
	goto_col( c_col );
	tm = Parse_Int( '/T=', MParm_Str );
	if(  ( tm > 0 )  ) {
		tm = tm / 55;
		call delay_check;
		if(  return_int  ) {
home_on:
			if(  (key1 == k1) && (key2 == k2)  ) {
				if(  c_row == 1  ) {
					goto try_tof;
				}
				refresh = FALSE;
				while(  c_row > 1  ) {
					up;
				}
				refresh = TRUE;
				goto_col(1);
				call delay_check;
				if(  return_int  ) {
		 home_on2:
					if((key1 == k1) && (key2 == k2)) {
	try_tof:
						tof;
						goto exit;
					}
				}
			}
			goto push_exit;
		}
	}

	goto exit;

delay_check:
	return_int = 0;
	t = system_timer;
	while(( system_timer - t) < tm) {
		if(check_key) {
			return_int = 1;
			break;
		}
	}
	ret;


push_exit:
	push_key( key1, key2 );

exit:
	POP_UNDO;
}
#ENDIF

#IFDEF Windows
macro END TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: END

Description:  Implements the end of line function as follows:
			If the end key is pressed once then, the cursor will go to the end of line.

			The following stuff requires that the /T=nn parameter be passed to END
			where nn is the number of milliseconds to wait for the next keypress.

			If the end key is pressed twice in rapid succession and the cursor is NOT
					at the bottom of the window, then the cursor will go to the bottom
					of the window.  If the cursor is at the bottom of the window, then
					the cursor will be moved to the end of the file.

			If the end key is pressed three times in rapid succession, then the cursor
					will be moved to the end of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int tm = 36, tc ;
	str key_timer[40] = _KEY_TIMER;

	int last_time, last_op, new_op = 0, last_function;

	var_parse_int("/LT=", key_timer, last_time );
	var_parse_int("/LO=", key_timer, last_op );
	var_parse_int("/LF=", key_timer, last_function );
	if ((key1 != prev_key1) || (key2 != prev_key2) ||
			(last_function != 2) || (last_keypress_time > (last_time + tm)) ||
			( last_op >= 2) )
	{
		new_op = 0;
	} else {
		if(at_eol)
			 new_op = last_op + 1;
	}


	PUSH_UNDO;

	switch ( new_op )
	{
		case 1 :
						int wl = win_cheight();
						if( wl > 1)
						{
							refresh = false;
							while(  c_row < wl  ) {
								down;
							}
							eol;
							refresh = true;
							redraw;
						}
						break;

		case 2 :
							eof;
							break;

		case  0 :
		default:
							eol;
							break;
	}

exit:
	_KEY_TIMER = "/LT=" + str(last_keypress_time) + "/LO=" + str(new_op) + "/LF=" + str(2);
	POP_UNDO;
}


#ELSE
macro END TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: END

Description:  Implements the end of line function as follows:
			If the end key is pressed once then, the cursor will go to the end of line.

			The following stuff requires that the /T=nn parameter be passed to END
			where nn is the number of milliseconds to wait for the next keypress.

			If the end key is pressed twice in rapid succession and the cursor is NOT
					at the bottom of the window, then the cursor will go to the bottom
					of the window.  If the cursor is at the bottom of the window, then
					the cursor will be moved to the end of the file.

			If the end key is pressed three times in rapid succession, then the cursor
					will be moved to the end of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  k1, k2, wl, tm, t ;

	k1 = key1;  k2 = key2;
	PUSH_UNDO;
loop:
	eol;

	tm = Parse_Int( '/T=', MParm_Str );
	if(  ( tm > 0 )  ) {
		tm = tm / 55;
		call delay_check;
		if(  return_int  ) {
	 end_on:
			if(  (key1 == k1) & (key2 == k2)  ) {
				wl = Win_CHeight () - 1;
				if(  c_row == wl  ) {
					goto try_eof;
				}
				refresh = false;
				while(  c_row < wl  ) {
					down;
				}
				eol;
				if(  at_eof  ) {
					eof;
				}
				refresh = true;
				redraw;
				call delay_check;
				if(  return_int  ) {
			end_on2:
					if(  (key1 == k1) & (key2 == k2)  ) {
	try_eof:
						eof;
						goto exit;
					}
				}
			}
			goto push_exit;
		}
	}

	goto exit;

delay_check:
	return_int = 0;
	t = system_timer;
	while(( system_timer - t) < tm) {
		if(check_key) {
			return_int = 1;
			break;
		}
	}
	ret;


push_exit:
	push_key( key1, key2 );

exit:
	POP_UNDO;
}
#ENDIF

#IFDEF Windows
global {
  int present_direction;
}

/******************** Multi-Edit VOID Macro Function ************************

 NAME:         ShiftCursor( )

 DESCRIPTION:  Handles Shifted Cursor movement for  ME4WIN only.


*****************************04-21-94 12:15pm*******************************/
void ShiftCursor( ) trans2
{
	int k1 = key1,
			k2 = key2,
			pass = TRUE,
			need_redraw = FALSE,
      t_block_stat = block_stat,
      A_Left = 1, A_Right = 2, A_Up = 3, A_Down = 4,
      L_Mode, R_Mode, U_Mode, D_Mode,
      same_direction = 0,
      temp_integer = 0,
      oim = insert_mode,
			tr = refresh;
      ;

  char L_Char, R_Char, U_Char, D_Char;

  if ( global_int('~LDSTAT' ))
  {
    insert_mode = false;
    switch ( k1 )
    {
      case VK_DOWN :
        if(  (global_int('~LDSTAT') == 3)  ) {
          Text(' ');
          Left;
          Down;
          Present_Direction = 0;
          //Goto WAIT_FOR_KEYPRESS;
          break;
        }
        Same_Direction = (Present_Direction == A_Down);
        if (Same_Direction) { /* If we were previously going a
  different direction, then insert char at current cusror position. Otherwise,
  insert char in the next down position */
          Down;
        }
        Present_Direction = A_Down;
        call LookAround;

        Temp_Integer = XPos(U_Char,'پ',1);
        if ((Temp_Integer) && (Same_Direction)) {
          Up;
          Text(Copy('Ź',((global_int('~LDSTAT') - 1) * 12) + Temp_Integer,1));
          LEFT;
          break;
        }

        if(  ((U_Mode > 0) & ((R_Mode + D_Mode + L_Mode) == 0))  ) {
          Text(Copy('',global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  ((L_Mode == 1) & (R_Mode == 1))  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }


        if(  ((L_Mode == 2) & (R_Mode == 2))  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (L_Mode == 1)  ) {
          Text(Copy('ټټٽ',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (L_Mode == 2)  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (R_Mode == 2)  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (R_Mode == 1)  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

  /* If no other condition exists... */
        Text(Copy('',global_int('~LDSTAT'),1));
        LEFT;
        break;
      case VK_RIGHT :
        if(  (global_int('~LDSTAT') == 3)  ) {
          Text(' ');
          Present_Direction = 0;
          //Goto WAIT_FOR_KEYPRESS;
          break;
        }
        Same_Direction = (Present_Direction == A_Right);
        if (Same_Direction) { /* If we were previously going a
  different direction, then insert char at current cusror position. Otherwise,
  insert char in the next right position */
          Right;
        }
        Present_Direction = A_Right;
        call LookAround;

        Temp_Integer = XPos(L_Char,'پ',1);
        if ((Temp_Integer) && (Same_Direction)) {
          Left;
          Text(Copy('',((global_int('~LDSTAT') - 1) * 12) + Temp_Integer,1));
          LEFT;
          break;
        }

        if ((L_Mode > 0) & ((D_Mode + U_Mode + R_Mode) == 0)) {
          Text(Copy('',global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  ((D_Mode == 1) & (U_Mode == 1))  ) {
          Text(Copy('ƴδƵ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  ((D_Mode == 2) & (U_Mode == 2))  ) {
          Text(Copy('̶ζ̴',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (D_Mode == 1)  ) {
          Text(Copy('տտ˿տڸ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (D_Mode == 2)  ) {
          Text(Copy('ɷ˷ɷֻ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (U_Mode == 2)  ) {
          Text(Copy('ȽʽȽӼ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (U_Mode == 1)  ) {
          Text(Copy('پټټپ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

  /* If no other condition exists... */
        Text(Copy('',global_int('~LDSTAT'),1));
        LEFT;
        break;
      case VK_UP :
        if(  (global_int('~LDSTAT') == 3)  ) {
          Text(' ');
          Left;
          Up;
          Present_Direction = 0;
          //Goto WAIT_FOR_KEYPRESS;
          break;
        }
        Same_Direction = (Present_Direction == A_Up);
        if (Same_Direction) { /* If we were previously going a
  different direction, then insert char at current cusror position. Otherwise,
  insert char in the next up position */
          Up;
        }
        Present_Direction = A_Up;
        call LookAround;


        Temp_Integer = XPos(D_Char,'',1);
        if ((Temp_Integer) && (Same_Direction)) {
          Down;
          Text(Copy('Ź',((global_int('~LDSTAT') - 1) * 12) + Temp_Integer,1));
          LEFT;
          break;
        }

        if(  ((D_Mode > 0) & ((R_Mode + U_Mode + L_Mode) == 0))  ) {
          Text(Copy('',global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  ((L_Mode == 1) & (R_Mode == 1))  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  ((L_Mode == 2) & (R_Mode == 2))  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (L_Mode == 1)  ) {
          Text(Copy('ٽٽٽٷٽٽ',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (L_Mode == 2)  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (R_Mode == 2)  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (R_Mode == 1)  ) {
          Text(Copy('',((U_Mode * 8) + (D_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

  /* If no other condition exists... */
        Text(Copy('',global_int('~LDSTAT'),1));
        LEFT;
        break;
      case VK_LEFT :
        if(  (global_int('~LDSTAT') == 3)  ) {
          Text(' ');
          Left;
          Left;
          Present_Direction = 0;
          //Goto WAIT_FOR_KEYPRESS;
          break;
        }
        Same_Direction = (Present_Direction == A_Left);
        if (Same_Direction) { /* If we were previously going a
  different direction, then insert char at current cusror position. Otherwise,
  insert char in the next left position */
          Left;
        }
        Present_Direction = A_Left;
        call LookAround;

        Temp_Integer = XPos(R_Char,'',1);
        if ((Temp_Integer) && (Same_Direction)) {
          Right;
          Text(Copy('',((global_int('~LDSTAT') - 1) * 12) + Temp_Integer,1));
          LEFT;
          break;
        }

        if(  ((R_Mode > 0) & ((D_Mode + U_Mode + L_Mode) == 0))  ) {
          Text(Copy('',global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  ((D_Mode == 1) & (U_Mode == 1))  ) {
          Text(Copy('ƴδƴ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }


        if(  ((D_Mode == 2) & (U_Mode == 2))  ) {
          Text(Copy('̶̶ǹ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (D_Mode == 1)  ) {
          Text(Copy('տ˿տ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (D_Mode == 2)  ) {
          Text(Copy('ɷ˷ɷ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (U_Mode == 2)  ) {
          Text(Copy('ȽʽȽ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

        if(  (U_Mode == 1)  ) {
          Text(Copy('پپپپپ',((L_Mode * 8) + (R_Mode * 2)) + global_int('~LDSTAT'),1));
          LEFT;
          break;
        }

  /* If no other condition exists... */
        Text(Copy('',global_int('~LDSTAT'),1));
        LEFT;
        break;
    }
    insert_mode = oim;
  }
  else {

    k2 = k2 & 0xfd;
    if ( marking )
    {
       pass_key(k1,k2);
    }
    else
    {
      if( block_stat == 0)
      {
        if (    (k1 == VK_RIGHT) // if we are going left or right or
            ||  (k1 == VK_LEFT)  // then stream mark
            ||  (k1 == VK_HOME)
            ||  (k1 == VK_END)
						||  (g_ShiftCursorMode == 0))
        {
          str_block_begin;
					if(stream_block_mode)
						pass = FALSE;
        }
        else
        {
          block_begin;
					pass = FALSE;
        }

      }
      else
      {
        if(persistent_blocks)
        {
          if (((GetShiftUpTime == 0) ||
               (GetShiftUpTime > global_int('~ShiftMark'))) ||
               (global_int('~ShiftMark') == 0)) {
            if (    (k1 == VK_RIGHT) // if we are going left or right or
                ||  (k1 == VK_LEFT)  // then stream mark
                ||  (k1 == VK_HOME)
                ||  (k1 == VK_END)
								||  (g_ShiftCursorMode == 0))
            {
              str_block_begin;
            }
            else
            {
              block_begin;
            }
          } else {
            goto continue;
          }
          //block_extend;
        }
  CONTINUE:
        marking = true;
      }
			char old_char = cur_char;
			int tc = c_col;
			int tl = c_line;

			if(pass)
			{
      	int winnum = 0;
      	int wc = Wcmd_Key( 0, make_word(k1,k2) );
      	if( wc ==  0 )
      	{
        	winnum = cur_window;
        	wc = Wcmd_Key( cur_window, make_word(k1, k2) );
      	}
      	if( wc == 0 )
      	{
        	pass_key(k1,k2);
      	}
      	else
      	{
        	Wcmd_Execute( winnum, wc, wcmd_last_lparam );
      	}
    	/*  if(persistent_blocks)
      	{
        	Block_Extend;
      	} */
			}
			if(copy(keywords_str,1,4) == "HTML")
			{
				refresh = false;
				if(cur_char == ">")
				{
					if((c_line == tl) && (c_col == (tc - 1)))
					{
						find_text( "<", 10, _BACKWARD );
					}
				}
				else if( old_char == "<" )
				{
					if((c_line ==tl) && (c_col == (tc + 1)))
					{
						if(find_text(">", 10, 0 ))
						{
							if(!stream_block_mode)
							{
								right;
							}
						}
					}
				}
				refresh = tr;
			}
      block_end;
    }
    set_global_int('~ShiftMark', GetMessageTime);
  }

goto exit;

LOOKAROUND:
/*  This subroutine looks at all chars surrounding CUR_CHAR and stores special
values into variables based on what it finds  */


  Undo_stat = False;
  //if(  (((C_Row + 2) > Win_Y1) & ((C_Row + 4) < Win_Y2))  ) {
  Refresh = False;
  hidecaret(window_handle);
  //}

  if(  C_Line > 1  ) {
    UP;
    U_Char = Cur_Char;
    RIGHT;
    DOWN;
  } else {
    U_Char = '|0';
    Right;
  }
  R_Char = Cur_Char;
  DOWN;
  LEFT;
	D_Char = Cur_Char;
	if(  c_col > 1  ) {
		LEFT;
		UP;
		L_Char = Cur_Char;
		RIGHT;
	} else {
		L_Char = '|0';
		Up;
	}

  D_Mode = XPos(D_Char,'϶',1);
  D_Mode = (D_Mode > 0) + (D_Mode > 13);
  U_Mode = XPos(U_Char,'ڶ',1);
  U_Mode = (U_Mode > 0) + (U_Mode > 13);
  L_Mode = XPos(L_Char,'',1);
  L_Mode = (L_Mode > 0) + (L_Mode > 13);
  R_Mode = XPos(R_Char,'ٵ',1);
  R_Mode = (R_Mode > 0) + (R_Mode > 13);

  showcaret(window_handle);
  Refresh = True;
  Undo_Stat = true;
  ret;

EXIT:
}
#ELSE
void shift_cursor TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SHIFT_CURSOR

Description:  Handles SAA/CUA complient shifted cursor key use (mark a stream
							block)

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str codes1[20] = '12346789|0',
			codes2[20] = '|71|72|73|75|77|79|80|81|116|115|145|141|132|118|119|117',
			m_str[8];
	int block_mode = parse_int("/M=", mparm_str),
			shift_stat = peek( 0, 0x417) & 0x0f;

	if ( block_mode == 0 )
	{
		block_mode = global_int("@SHFT_CURS_BLCK_MODE");
	}
	if ((block_mode < 1) || (Block_mode > 3))
		block_mode = 3;

	switch (block_mode) {
		case 1 :
			m_str = "MarkBlck";
			key2 = 0;
			break;
		case 2 :
			m_str = "MColBlck";
			key2 = 0;
			break;
		default :
			m_str = "MStrBlck";
	}

	if( !marking )
		rm("MEUTIL2^" + m_str);
	refresh = TRUE;
	pass_key( 0, key2 );
	do {
		if( check_key ) {
			if( key1 == 253 )
					key1 = 0;
			if( xpos( char(key1), codes1, 1 ) && xpos( char(key2), codes2, 1 )) {
				pass_key( 0, key2 );
			} else {
				push_key(key1, key2 );
				break;
			}
		}
		refresh = TRUE;
		goto_col(c_col);
	} while( peek( 0, 0x417) & shift_stat );
	rm("MEUTIL2^" + m_str);
}

#ENDIF

macro CR trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: CR

Description:	Performs a carriage return according to INDENT_STYLE:
							0 = None.  Just do a plain carriage return
							1 = Auto.  Indents to first word of previous line.
							2 = Smart.  Uses language specific smart indenting.

              /NS=1 	will cause the current line to not be split.

              (C) Copyright 1991-95 by American Cybernetics, Inc.
*******************************************************************************/

	str TStr;
	str Language;
	str LanguageRec[ Max_Line_Length ];

	int Jx;
	int Temp_Ins;

	Push_Undo;
  if ( Parse_Int( "/NS=", MParm_Str ) ) {
    Eol;
  }
  // If auto-indent then
	if ( Indent_Style == 1 ) {
		Jx = C_Col;
		First_Word;
		if (  !At_Eol ) {
			Set_Indent_Level;
		}
		Goto_Col( Jx );
	}
	else if ( Indent_Style == 2 ) {
		if ( LangGetRecord( Language, LanguageRec ) == _NoError ) {
			TStr = Parse_Str( "\x7F" + _db_lang_IndentMac + "=", LanguageRec );
		}
		if ( Svl( TStr ) == 0 ) {
			if ( Svl( LanguageRec ) != 0 ) {
				TStr = Copy( Language, 1, 8 ) + "^" + Copy( Language, 1, 3 ) + "_Ind";
			}
		}
		if ( Svl( TStr ) != 0 ) {
			Error_Level = 0;
			Rm( TStr + " " + MParm_Str );
			if ( Error_Level != 0 ) {
				if ( Error_Level == 5001 ) {
					Error_Level = 0;
					Make_Message( "Smart indent macro NOT found." );
				}
				else {
					Rm( "MeError" );
				}
				goto ExitX;
			}
			goto Exit;
		}
	}

ExitX:
  // If in then insert a hard carriage return if one is defined
  if ( ( Hard_Cr != "" ) && ( Hard_Cr != '|0' ) ) { // Dan, this MUST be single quotes!
		Temp_Ins = Insert_Mode;
		Insert_Mode = True;
		Text( Hard_CR );
		Cr;
		if ( Wrap_Stat ) {
			Word_Wrap_Line( False, True );
		}
		Insert_Mode = Temp_Ins;
	}
	else {
		Jx = C_Col;
		Cr;
		if ( ( Insert_Mode == False ) && ( Jx >= Indent_Level ) ) {
			Goto_Col( Indent_Level );
		}
	}

Exit:
	Pop_Undo;

}  // CR

void Tab(
  		int TabRight = Parse_Int( "/M=", MParm_Str ),
			int InBlk 	 = Parse_Int( "/I=", MParm_Str ),
			int Message  = Parse_Int( "/NM=", MParm_Str ) == 0,
			str Misc		 = MParm_Str
) trans2 {
/******************************************************************************
                               Multi-Edit macro
                               30-Aug-95  01:52

  Function: Handles <TAB>/<ShftTAB>. If block is marked.

  Entry   : int TabLeft		Tab Direction ( /M=int )
							0 					- Tab right or indent block.
							1 					- Tab left or undent block.
						int InBlk			Indent only if cursor in block ( /I=1 )
 						int Message		Show messages ( /NM=1 no messages )

  Exit    : Nothing.

						 Copyright (C) 1991-95 by American Cybernectics, Inc.
**********************************************************************(ldh)***/

	int Result = 0;

  if ( TabRight ) {
		if ( g_TabIndentsBlock ) {
    	Result = UndBlk( InBlk, Message, Misc );
		}
		if ( Result == 0 ) {
      Tab_Left;
		}
	}
	else {
		if ( g_TabIndentsBlock ) {
  	  Result = IndBlk( InBlk, Message, Misc );
		}
		if ( Result == 0 ) {
      Tab_Right;
		}
	}
}  // Tab

macro DATETIME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DATETIME

Description:  Writes the current date and time onto the current line.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	 str time_str[10] = STR_DEL(TIME,6,3);

#IFDEF WINDOWS
	str sTime[2];
	GetProfileString("intl","sTime", ":",sTime,2);
	if (xpos(sTime,time_str,1) == 2) {
		time_str = STR_DEL(TIME,5,3);
	}
#ENDIF

	 TEXT( DATE + ' ' + time_str);
}

macro GOTOLINE TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: GOTOLINE

Description:  Prompts for a line number, then moves the cursor to that line.

Parameters:
							/X=   The column to place the prompt box.
							/Y=   The line to place the prompt box.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

		int jx,jj;
		Return_Str = '';
		Return_Int = Global_Int('@GOTOLINE#');
		if(  return_int < 1  ) {
			return_int = 1;
		}
#ifdef WINDOWS
		RM('userin^QUERYBOX /N=1/MIN=1/L=' + parse_str('/Y=', mparm_str) +
					'/C=' + parse_str('/X=', mparm_str) + '/W=12/P=Line number: /T=Go To Line/H=' +
					GOTOLINE_HELPLINK);
#else
		RM('userin^QUERYBOX /N=1/MIN=1/L=' + parse_str('/Y=', mparm_str) +
					'/C=' + parse_str('/X=', mparm_str) + '/W=12/P=Line number: /T=Go To Line/H=GOTOLINE');
#endif
		if(  Return_Str == 'TRUE'  ) {
			refresh = TRUE;
			GOTO_LINE(return_int);
			Set_Global_Int('@GOTOLINE#', return_int);
			redraw;
			return_int = 100;
		} else {
			return_int = 0;
		}
}

void cursor_to_line( int l ) {
/*---------------12-30-92 12:39pm-------------------
 Moves the cursor to line l.  Unlike Goto_Line, this
 function moves the cursor as if the up or down
 arrow keys were used.
--------------------------------------------------*/
	int tr = refresh;
	refresh = false;
	if( c_line > l )
	{
		if(( c_line - l) <= (win_y2 - win_y1))
		{
			while ( c_line > l )
			{
				up;
			}
		}
		else
		{
			rm("TOPWIN");
			goto_line(l);
		}
	}
	else if(c_line < l)
	{
		if(( l - c_line) <= (win_y2 - win_y1))
		{
			while ( c_line < l )
			{
				down;
			}
		}
		else
		{
			rm("BOTWIN");
			goto_line(l);
		}
	}
	refresh = tr;
}

macro TOPBLOCK TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: TOPBLOCK

Description:  Take cursor to top of currently defined block

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int tpersist = persistent_blocks;
	persistent_blocks = true;

	if(  Block_Stat != 0  ) {
		cursor_to_line(block_line1);
		if(  Block_Stat != 1  ) {
			Goto_Col( Block_Col1 );
		}
		Redraw;
	}
	persistent_blocks = tpersist;
}

macro ENDBLOCK TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: ENDBLOCK

Description:  Take cursor to bottom of currently defined block

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int tpersist = persistent_blocks;
	persistent_blocks = true;
	if(  Block_Stat != 0  ) {
		cursor_to_line(block_line2);
		if(  Block_Stat != 1  ) {
			Goto_Col( Block_Col2 );
		}
		Redraw;
	}
	persistent_blocks = tpersist;
}

void TopWin( int MvLine = Parse_Int( "/ML=", MParm_Str ) ) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 30-Aug-95  02:45

  Function: Position cursor only or current line to top of the window.
  Entry   : int MvLine		True to position line at top of window
  Exit    : None

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

  int SavRefresh = Refresh;
  int SavLin 		 = C_Line;

  Refresh = False;
  Push_Undo;
  while ( C_Row > 1 ) {
    Up;
	}
  if ( MvLine > 0 ) {
    Goto_Line( SavLin );
	}
  Pop_Undo;
  Refresh = SavRefresh;
  Redraw;

}  // TopWin

void BotWin( int MvLine = Parse_Int( "/ML=", MParm_Str ) ) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 30-Aug-95  02:47

  Function: Position cursor only or current line to bottom of window.
  Entry   : int MvLine		True to position line at bottom of window
  Exit    : None

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

  int SavRefresh = Refresh;
  int SavLin     = C_Line;
	int Height;

#ifdef Windows
	Height = Win_CHeight( );
#else
	Height = Win_Y2 - Win_Y1 - 1;
#endif

  Refresh = False;
  Push_Undo;
	while ( C_Row < Height ) {
    Down;
	}
  if ( MvLine ) {
    Goto_Line( SavLin );
  }
  Pop_Undo;
  Refresh = SavRefresh;
  Redraw;

}  // BotWin

void MidWin( int MvLine = Parse_Int( "/ML=", MParm_Str ) ) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 30-Aug-95  02:50

  Function: Position cursor only or current line to middle of window.
  Entry   : int MvLine		True to center line in window
  Exit    : None

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

  int SavRefresh = Refresh;
	int SavLin = C_Line;
  int Height;

#ifdef Windows
	Height = Win_CHeight( ) / 2;
#else
	Height = ( Win_Y2 - Win_Y1 ) / 2 );
#endif

	if((height > 0) && ((c_line > Height) || (!MvLine)))
	{
		int old_c_row = -1;
  	Refresh = False;
  	Push_Undo;
  	while ( (C_Row > Height) && (C_Row != old_c_row) ) {
			old_c_row = c_row;
    	Up;
		}
		old_c_row = -1;
  	while ( (C_Row < Height) && (C_Row != old_c_row) ) {
			old_c_row = c_row;
    	Down;
		}
  	if ( MvLine ) {
    	Goto_Line( SavLin );
  	}
  	Pop_Undo;
  	Refresh = SavRefresh;
  	Redraw;
	}

}  // MidWin

macro CenterLn {
/****************************Multi-Edit Macro********************************

 NAME:         CenterLn

 DESCRIPTION:  Centers the current line vertically in the window.

*****************************08-17-93 05:25pm*******************************/

	MidWin( True );

}  // CenterLn

macro ScrollUp trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 29-Aug-95  01:54

  Function: Scroll screen up one line with cursor movement or not.
  Entry   : /MC=1		Move the cursor with the scrolled line if possible

							Copyright (C) 1991-95 by American Cybernectic, Inc.
********************************************************************( ldh )***/
	#ifdef windows
	 int MoveCursor = Parse_Int( "/MC=", MParm_Str );

	 MEW_ScrollDown(1);
		if ( MoveCursor == 0 ) {
			MoveCursor = Global_Int( "!ScrlMvCursor" );
		}
		if ( MoveCursor == 1 ) {
			if (C_Row > 1) {
				Up;
			}
		}
	#else

	int SavRefresh = Refresh;
	int MoveCursor = Parse_Int( "/MC=", MParm_Str );

	Refresh = False;
	Goto_Line( C_Line + 1 );
	if ( MoveCursor == 0 ) {
		MoveCursor = Global_Int( "!ScrlMvCursor" );
	}
	if ( MoveCursor == 1 ) {
		if (C_Row > 1) {
			Up;
		}
	}
	Refresh = SavRefresh;
	Redraw;
	#endif
}  // ScrollUp

macro ScrollDn trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 29-Aug-95  01:54

  Function: Scroll screen down one line with cursor movement or not.
  Entry   : /MC=1		Move the cursor with the scrolled line if possible

							Copyright (C) 1991-95 by American Cybernectic, Inc.
********************************************************************( ldh )***/

#ifdef windows
	int MoveCursor = Parse_Int( "/MC=", MParm_Str );
	MEW_ScrollUp(1);
	if ( MoveCursor == 0 ) {
		MoveCursor = Global_Int( "!ScrlMvCursor" );
	}
	if ( MoveCursor == 1 ) {
		if (C_Row < win_cheight) {
			down;
		}
	}
#else

	int SavRefresh = Refresh;
	int MoveCursor = Parse_Int( "/MC=", MParm_Str );
	int Height;

	Height = Win_Y2 - Win_Y1 - 1;

	Refresh = False;
	Goto_Line( C_Line - 1 );
	if ( MoveCursor == 0 ) {
		MoveCursor = Global_Int( "!ScrlMvCursor" );
	}
	if ( MoveCursor == 1 ) {
		if ( C_Row < Height ) {
			Down;
		}
	}
	Refresh = SavRefresh;
	Redraw;
#endif
}  // ScrollDn

macro PAGEBRK TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: PAGEBRK

Description:  Insert a page break

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	push_undo;
	UP;
	EOL;
	CR;
	GOTO_COL(1);
	TEXT( PAGE_STR );
	UP;
	DOWN;
	pop_undo;
}

void Space( ) {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SPACE

Description: Spacebar handling

Parameters:  /TEMPLATE=1 invokes template expansion if enabled.

               (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/
  if ( ( g_Tmp_Global ||
      Parse_Int( "ATX=", Global_Str( "." + Get_Extension( File_Name ) ) ) ) &&
      Parse_Int( "/TEMPLATE=", MParm_Str ) ) {
		Template( True );
  }
	else {
    Text( " " );
  }
}

void NextChgLine (int back = parse_int("/BACK=", mparm_str))
/*******************************************************************************
																MULTI-EDIT MACRO

Name: NextChgLine

Description:  Positions the cursor on the next or previous changed
							line.  If no more lines are changed, no action takes
							place.

Parameters:   /BACK=1  Looks backwards from current line.

							 (C) Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/
{
	int or = refresh;
	refresh = false;
	mark_pos;
	if ( !back ) {
		down;
		while ( (!line_changed) && (!at_eof) ) {
			down;
		}
	} else {
		up;
		while ( (!line_changed) && (c_line != 1) ) {
			up;
		}
	}
	if ( (at_eof) || ((c_line == 1) && !line_changed) ) {
		goto_mark;
		beep;
		make_message("No more changed lines");
	} else
#IFDEF WINDOWS
		Set_Highlight( c_line, 0, c_line, max_line_length );
#ENDIF
		pop_mark;

  redraw;
	refresh = or;
}


macro FIND_EXT {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: FIND_EXT

Description: Makes sure extension specific setup globals are loaded for
	the passed extension.

Parameters:   /EXT=str    Str is the extension to use (including the
													leading ".").

Returns:
			RETURN_STR contains the name of the global to use to access
			the extension specific setup.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str Ext;

	Ext = Caps(Parse_Str('/EXT=',MParm_Str));

	if(  (Global_Str(Ext) == '')  ) {
		reg_exp_stat = TRUE;
		RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext +
			"/FV=" + make_literal(Copy(Ext,2,260)) + " |,|;|");
		if (return_int < 1) {
// The regular expressions in /FV= allow multiple file extensions per record
// example C;INC;H
			RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext +
				"/FV=[~]*[ ,;]" + make_literal(Copy(Ext,2,260)) + " |,|;|");
		}
//    RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext + '/FV=' + Copy(Ext,2,3));
		if(  (Return_Int < 1)  ) {
				RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext + '/FV=DEFAULT');
			Return_Int = -1;
		} else {
			Return_Int = 0;
		}
		if(  xpos( ext + '', Global_Str('EXTENSIONS'), 1 ) == 0  ) {
			Set_Global_Str('EXTENSIONS',Global_Str('EXTENSIONS') + Ext + '');
		}
	} else {
		Return_Int = 0;
	}
EXIT:
	return_str = ext;
}

macro SETTABS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SETTABS

Description: Sets up even interval tab spacing.

Parameters: /TS=nn    Tab spacing.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  Tab_Size, jx, margin, m ;
	str  tformat[max_line_length];
	Tab_Size = Parse_Int('/TS=', mparm_str );
	Margin = Parse_Int('/RM=', mparm_str );
	if(  (Margin < 1) | (Margin > max_line_length)  ) {
		Margin = 128;
	}
	m=margin;
	if(m == max_line_length)
		--m;

	TFormat = ' ';
	while(  SVL(TFormat) < m  ) {
		Jx = 1;
		while(  jx < Tab_Size  ) {
			TFormat = TFormat + ' ';
			++jx;
		}
		TFormat = TFormat + '|16';
	}
	Format_Line = TFormat;
	Format_Stat = False;
}


macro ExtSetup {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: EXTSETUP

Description:  Is called to setup a window/file based on the files extension.
						If the extension is not found in the global extension list, then
						the default extension setup is used.

Parameters:
							/PRE=  If 1, then post-load macro will not be run, such as would
							be the case if this was run after the file had already been loaded.

              /NOSYNTAX= if 1 don't set syntax parameters

              /SETFC=   if 1 reset colors if none is selected.

							/FTO=x File type override
										1 = DOS
										2 = UNIX
										3 = Binary
												/BRL=x  record length
									255 = Do NOT override the line_terminator value or the
												fixed line length value

							/OEM=x Oem mode override  	Windows only
										0 = Defaults
										1 = Ansi
										2 = Oem


Returns:  Return_Str = default directory for file.
							 (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/
	#ifndef windows
	int  t_cb_t_color = cb_t_color;
	#endif

  int post = parse_int('/POST=', mparm_str);
	str TStr1[max_line_length],TStr2,Tstr3;
  int jx,jy,T_File_Changed = File_Changed;

	str LanguageRec[ Max_Line_Length ];

	if(  xpos('/EXT=', mparm_str, 1) != 0  ) {
		tstr3 = parse_str('/EXT=', mparm_str );
	} else {
		tstr3 = get_extension( file_name );
	}
	RM( 'FIND_EXT /EXT=.' + tstr3 );
	Tstr3 = Return_Str;
	TStr1 = Global_Str(tstr3);

	Wrap_Stat = Parse_Int('WW=', TStr1 );
	indent_style = Parse_Int('IND=', TStr1 );
	if(  (Indent_Style > 0)  ) {
		Indent_Style = Indent_Style - 1;
	}
	Doc_Mode = Parse_Int('DOC=', TStr1 );

	if(  post == 0  ) {
		jx = parse_int('/FTO=',mparm_str);

		if(jx != 255 )
		{
			filetype_override = 0;
			fixed_line_length = 0;
			if(jx == 0)
			{
				jx = parse_int('FT=', tstr1 );
				if(jx > 0)
					--jx;
			}

			if(  jx == 2  ) {
				line_terminator = '|10|0';
			} else if(  jx == 3  ) {
				line_terminator = '|0';
				fixed_line_length = parse_int('/BRL=', mparm_str);
				if(fixed_line_length == 0)
					fixed_line_length = parse_int('BRL=', tstr1);
				if(fixed_line_length == 0)
					fixed_line_length = 16;
			} else {
				line_terminator = '|13|10';
				if( jx == 0 )
				{
					filetype_override = 255;
				}
			}
		}
	}
	if(  Format_Stat == 0  ) {
		if(  (Parse_Int('UF=',TStr1) == 0)  ) {
			JX = Parse_Int('TS=',TStr1);
			if(  (JX != 0)  ) {
				Use_Format_Line = false;
				right_margin = Parse_Int('RM=',TStr1);
				if(  (right_margin == 0)  ) {
					Right_Margin = 80;
				}
				if( ( post == 0 ) || (format_line == "") ) {
					RM('SETTABS /TS=' + str( jx ) + '/RM=' + str(right_margin) );
	/* Here, we are deleting any defined format line from the global to conserve ram */
					Jx = XPos('FORMAT=',Tstr1,1);
					if(  (Jx)  ) {
						Jy = Length(Parse_Str('FORMAT=',Tstr1));
						Set_Global_Str(TStr3,Str_Del(TStr1,Jx,Jy + 8));
					}
				}
			} else {
				Goto USE_FORMAT;
			}
		} else {
USE_FORMAT:
			TStr2 = Parse_Str('FORMAT=',TStr1);
			if(  Tstr2 != ''  ) {
				Format_Line = TStr2;
				Format_Stat = false;
				Use_Format_Line = true;
			}
			if(  (XPos('R',Caps(Format_Line),1) == 0)  ) {
/* If there is no right_margin defined in the format line, see if there is one
defined explicity */
				Right_Margin = Parse_Int('RM=',TStr1);
			}
		}
	}
	tstr3 = parse_str('CC=', tstr1 );
#IFNDEF Windows
	if(  xpos('/CTC=', tstr3, 1) != 0  ) {
		t_color = parse_int( '/CTC=', tstr3);
		c_color = parse_int( '/CCC=', tstr3);
		b_color = parse_int( '/CBC=', tstr3);
		h_color = parse_int( '/CHC=', tstr3);
		s_color = parse_int( '/CSC=', tstr3);
		l_color = parse_int( '/CLC=', tstr3);
		lb_color = parse_int( '/CLBC=', tstr3);
		eof_color = parse_int( '/CEC=', tstr3);
		window_color_stat = TRUE;
	}
	else {
		t_color = w_t_color;
		c_color = w_c_color;
		b_color = w_b_color;
		h_color = w_h_color;
		s_color = w_s_color;
		l_color = w_l_color;
		lb_color = w_lb_color;
		eof_color = w_eof_color;
		window_color_stat = FALSE;
	}
#ELSE
	if ( post == 0)
	{
  	if ((tstr3 != '') && ( tstr3 != DefaultColor) )
		{
    	if ( (tstr3 == "NONE") && (parse_int("/SETFC=", mparm_str) != 0) )
    	{
      	SetTemplateAttrs (cur_window, DefaultColor);
    	}
    	else
    	{
      	SetTemplateAttrs (cur_window, tstr3);
    	}
			window_color_stat = TRUE;
		}
		else {
			window_color_stat = FALSE;
		}

		// Setup the Oem Translate mode
		int oe;
  	str fontname;
  	int fontsize, fontoe;

		jx = Parse_Int( "/OEM=", mparm_str );
		if ( jx == 0 )                      // No override
		{
  		oe 		= parse_int ("\x7F" + "OEM=", tstr1);  // if extension specific
  		tstr3 = parse_str ("\x7F" + "FONT=", tstr1);
			if ( (oe == 0) || (tstr3 == ""))                      // 0 =  use global
			{
				oe = Global_Int ("Oem_Mode");
      	Get_Window_Font (-oe, fontname, fontsize, fontoe);
      	Set_Window_Font (cur_window, fontname, fontsize, fontoe);
				Set_Oem_Ansi (cur_window, oe);
				window_attr |= $200;	                   // Tell system we are using default
			}
			else
			{
				if ( oe < 0)
				{
					oe = 0;
				}
      	fontname = parse_str ("/NAME=", tstr3);
      	fontsize = parse_int ("/SIZE=", tstr3);
      	fontoe   = parse_int ("/SET=",  tstr3);
      	Set_Window_Font (cur_window, fontname, fontsize, fontoe);
				Set_Oem_Ansi (cur_window, oe);
				window_attr &= $FDFF;
			}
		}
		else
		{
			oe = jx - 1;
      Get_Window_Font (-oe, fontname, fontsize, fontoe);
      Set_Window_Font (cur_window, fontname, fontsize, fontoe);
			Set_Oem_Ansi (cur_window, oe);
			window_attr &= $FDFF;
		}
	}
#ENDIF
	if ( Parse_Int('/PRE=',MParm_Str)==0 )
	{
    if ( ( TStr3 = Parse_Str( "\x7F" + "TEMPLATE=", TStr1 ) ) != "" ) {
			Tmp_Init_All( TStr3, 0 );
    }
    else if ( ( TStr3 = Parse_Str( "\x7F" + "LS=", TStr1 ) ) != "" ) {
			Tmp_Init_All( TStr3, 0 );
    }
		TStr3 = Parse_Str( "\x7F" + "LS=", TStr1 );
		// Initialize addon templates
		TStr2 = Parse_Str( "\x7F" + "ATEMP=", TStr1 );
		while ( Svl( TStr2 ) != 0 ) {
			Jx = XPos( ";", TStr2, 1 );
			if ( Jx == 0 ) {
				Jx = Svl( TStr2 ) + 1;
			}
			Tmp_Init_All( Copy( TStr2, 1, Jx - 1 ), 0 );
			TStr2 = Str_Del( TStr2, 1, Jx );
		}
		TStr2 = "";
		if ( LangGetRecord( TStr3, LanguageRec ) == _NoError ) {
			TStr2 = Parse_Str( "\x7F" + _db_lang_InitMac + "=", LanguageRec );
		}
		if ( Svl( TStr2 ) == 0  ) {
			TStr2 = Copy( TStr3, 1, 8 ) + "^" + Copy( TStr3, 1, 3 ) + "SetX";
		}
		if ( Svl( TStr2 ) != 0 ) {
			Rm( TStr2 );
		}
		if (!parse_int("/NOSYNTAX=",Mparm_Str)) {
			RM("SET_SYNTAX_PARMS");
		}
		error_level = 0;
		TStr3 = Parse_Str('MAC=',TStr1);
		if ( ''!=TStr3 )
		{
			int fsa=File_Search_ATTR;
			str fsr[80]=File_Search_REC;
			File_Changed = T_File_Changed;
			RM(TStr3);
			T_File_Changed = File_Changed;
			File_Search_ATTR=fsa;
			File_Search_REC=fsr;
		}
	}
	if ((post != 0) && (copy(line_terminator,1,1) == '|0') && !(window_attr & 0x20))
	{
		if (Binary_Mode)
			rm("hex /M=1");
	}
	File_Changed = T_File_Changed;
}

#IFDEF windows
global
{
	str resword1 "!resword1";
	str resword2 "!resword2";
	str resword3 "!resword3";
	str resword4 "!resword4";
}
macro SET_SYNTAX_PARMS {
/*
*/
	str language[40] = parse_str("/LANG=",mparm_str);
	int reinit = parse_int("/REINIT=",mparm_str),
			reset =  parse_int("/RESET=", mparm_str),
			case_sensitive;

	if (!svl(language))
		language = parse_str("LS=",Global_Str("." + Get_Extension(file_name)));
	else
		reinit = true;

	if (svl(language)) {
		str g_str [max_line_length],
				g_name [20] = "@" + copy(language,1,3) + "_SYNTAX_PARMS";

		if ((global_str(g_name) == "") || RESET) {
			RM("GET_DB_RECORD /F=MECONFIG/NDF=1/DPT=LANGUAGE.DB/DBF=LANG/FV="
				+ language
				+ "/GLO=" + g_name);
		}
		g_str = global_str(g_name);
		var_remove_str("LANG=",g_str);
		if(svl(g_str) != 0)
		{
			if(g_str != "RECORD_SET")
			{
	// if we are not case sensitive, capitalize all keywords
				case_sensitive = parse_int("CS=",g_str);

				resword1 = remove_space(parse_str("RW1=",g_str));
				resword2 = remove_space(parse_str("RW2=",g_str));
				resword3 = remove_space(parse_str("RW3=",g_str));
				resword4 = remove_space(parse_str("RW4=",g_str));
				if (!case_sensitive)
				{
					resword1 = caps(resword1);
					resword2 = caps(resword2);
					resword3 = caps(resword3);
					resword4 = caps(resword4);
				}

				set_keywords(copy(language,1,25) + "_KEYS",  // name
					case_sensitive,                 // TRUE = case sensitive
					"",
					"",                  						// scan chars
					" " + resword1 + " ",           //  reserved words 1
					" " + resword2 + " ",						// reserved words 2
					" " + resword3 + " ",           // reserved words 3
					" " + resword4 + " ",						// reserved words 4
					"",
					0,    													// reserved words attr
					parse_str("SYM=",g_str),       // Symbols
					0,    													// symbol attribute
					parse_str("STR=",g_str),       // string chars,
					0,    													// string attr
					parse_str("LIT=",g_str),       // literal char
					parse_str("EOL=",g_str),       // eol comment
					0,    													// eol comment attr 1
					parse_int("EOC=",g_str ),      // eol column
					parse_str("EOL2=",g_str),      // eol comment
					0,    													// eol comment attr 2
					parse_int("EOC2=",g_str ),     // eol column
					parse_str("OC1=",g_str),       // open comment 1
					parse_str("CC1=",g_str),       // close comment 1
					0,    													// open/close comment 2 attr
					parse_str("OC2=",g_str),       // open comment 2
					parse_str("CC2=",g_str),       // close comment 2
					0,    													// open/close comment 2 attr
					parse_str("NC=",g_str),        // numeric chars
					0     													// numeric chars attr
					);

				set_global_str(g_name,"RECORD_SET");
				resword1 = "";
				resword2 = "";
				resword3 = "";
				resword4 = "";
			}
			if (!reinit)  {
				keywords_str = copy(language,1,25) + "_KEYS";
			}
		}
	}
}

#ELSE
macro SET_SYNTAX_PARMS {
/*
*/
	str language[40] = parse_str("/LANG=",mparm_str),
			t_str, sc1, ac1[128] = "",
			rw1,rw2,rw3,rw4;
	int t_int,
			ta,
			reinit = parse_int("/REINIT=",mparm_str),
			reset =  parse_int("/RESET=", mparm_str),
			parse_mode = 0,
			case_sensitive;
	char tc;

	if (!svl(language))
		language = parse_str("LS=",Global_Str("." + Get_Extension(file_name)));
	else
		reinit = true;

	if (svl(language)) {
		str g_str [max_line_length],
				g_name [20] = "@" + copy(language,1,3) + "_SYNTAX_PARMS";

		if ((global_str(g_name) == "") || RESET) {
			RM("GET_DB_RECORD /F=MECONFIG/NDF=1/DPT=LANGUAGE.DB/DBF=LANG/FV="
				+ language
				+ "/GLO=" + g_name);
		}
		g_str = global_str(g_name);
		var_remove_str("LANG=",g_str);
		if(svl(g_str) != 0)
		{
			if(g_str != "RECORD_SET")
			{
	// if we are not case sensitive, capitalize all keywords
				case_sensitive = parse_int("CS=",g_str);
				rw1 = remove_space(parse_str("RW1=",g_str));
				if (!case_sensitive)
					rw1 = caps(rw1);
				rw2 = remove_space(parse_str("RW2=",g_str));
				if (!case_sensitive)
					rw2 = caps(rw2);
				rw3 = remove_space(parse_str("RW3=",g_str));
				if (!case_sensitive)
					rw3 = caps(rw3);
				rw4 = remove_space(parse_str("RW4=",g_str));
				if (!case_sensitive)
					rw4 = caps(rw4);
	// parse out first character of each of the keywords fields
				t_str = rw1;
				t_int = 2;
				call PARSE_SCAN_CHARS;
				t_int = svl(t_str) + 1;
				t_str = t_str + rw2;
				call PARSE_SCAN_CHARS2;
				t_int = svl(t_str) + 1;
				t_str = t_str + rw3;
				call PARSE_SCAN_CHARS2;
				t_int = svl(t_str) + 1;
				t_str = t_str + rw4;
				call PARSE_SCAN_CHARS2;
				sc1 = t_str;

				t_int = 2;
				t_str = /* t_str + */
				copy(parse_str("OC1=",g_str),1,1) +
				copy(parse_str("CC1=",g_str),
								length(parse_str("CC1=",g_str)),1) +
				Copy(parse_str("OC2=",g_str),1,1) +
				copy(parse_str("CC2=",g_str),
								length(parse_str("CC2=",g_str)),1) +
				parse_str("SYM=",g_str) +
				parse_str("STR=",g_str) +
				parse_str("EOL=",g_str) +
				parse_str("EOL2=",g_str)
				;
				parse_mode = 1;
				call PARSE_SCAN_CHARS2;
				str attr_str = Global_Str ("&SYNTAX_COLORS");

				set_keywords(copy(language,1,25) + "_KEYS",   // name
					case_sensitive,// TRUE = case sensitive
					sc1,
					t_str, // + parse_str("SYM=",g_str),  // scan chars
					//  reserved words 1
					" " + RW1 + " ",
					// reserved words 2
					" " + RW2 + " ",
					// reserved words 3
					" " + RW3 + " ",
					// reserved words 4
					" " + RW4 + " ",
					ac1,
					parse_int("/RWC=",attr_str),    // reserved words attr
					parse_str("SYM=",g_str),       //Symbols
					parse_int("/SYC=",attr_str),    // symbol attribute
					parse_str("STR=",g_str),       //string chars,
					parse_int("/SCC=",attr_str),    //string attr
					parse_str("LIT=",g_str),       // literal char
					parse_str("EOL=",g_str),       // eol comment
					parse_int("/ECC=",attr_str),    // eol comment attr
					parse_int("EOC=",g_str ),      // eol column
					parse_str("EOL2=",g_str),      // eol comment
					parse_int("/ECC=",attr_str),    // eol comment attr
					parse_int("EOC2=",g_str ),     // eol column
					parse_str("OC1=",g_str),       //open comment 1
					parse_str("CC1=",g_str),       //close comment 1
					parse_int("/C1C=",attr_str),    // open/close comment 2 attr
					parse_str("OC2=",g_str),       //open comment 2
					parse_str("CC2=",g_str),       // close comment 2
					parse_int("/C2C=",attr_str),    // open/close comment 2 attr
					parse_str("NC=",g_str),        // numeric chars
					parse_int("/NCC=",attr_str)     // numeric chars attr
					);
				set_global_str(g_name,"RECORD_SET");
			}
			if (!reinit)  {
				keywords_str = copy(language,1,25) + "_KEYS";
			}
		}
	}
	goto EXIT;

PARSE_SCAN_CHARS:
	while (((tc = str_char(t_str,t_int)) != " ") && (t_int <= svl(t_str))) {
		t_str = str_del(t_str,t_int,1);
			// TMJ - 10-30-92 10:51am - Locate NON-ALPHA-NUMERIC chars
		if( !xpos( caps(tc),  "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_",1)) {
			if ( !xpos( tc, ac1,1) )
			{
				ac1 += tc;
			}
		}
	}
	if (t_int < svl(t_str)) {
		t_str = str_del(t_str,t_int,1); // remove the space
PARSE_SCAN_CHARS2:
		if (xpos(str_char(t_str,t_int),copy(t_str,1,t_int - 1),1)) {
//if this char is already in the string, delete it
			t_str = str_del(t_str,t_int,1);
		} else if ((t_int < svl(t_str)) || (parse_mode))
			++t_int;
		if (parse_mode) {
			if (t_int > svl(t_str))
				RET;
			goto PARSE_SCAN_CHARS2;
		}
		goto PARSE_SCAN_CHARS;

	}
	RET;

EXIT:
}
#ENDIF

macro SETFILENAME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SETFILENAME

Description:  Completes a filename (no wildcards).  Adds in the default
	directory for that extension if none is specified.

Parameters:   Return_Str = Filename

Returns:      Return_Str = new Filename
							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  str  tstr[260], gstr[20] ;
	int  jx ;

	tstr = return_str;
	if(  get_path(tstr) == ''  ) {
		RM( 'FIND_EXT /EXT=.' + get_extension( tstr ) );
		gstr = return_str;
		return_str = SearchPath(tstr,TranslateCmdLine(parse_str('DIR=',Global_Str(gstr)), tstr));
		if(  return_str == ""  ) {
			return_str = TranslateCmdLine(parse_str('DIR=',Global_Str(gstr)), tstr);
			jx = xpos(';', return_str, 1);
			if(  jx == 0  ) {
				jx = length(return_str) + 1;
			}
			return_str = AddTrailingSlash(copy(return_str,1, jx - 1));

			return_str = return_str + tstr;
		}
	}
Expand_Exit:
	return_str = fexpand( return_str );
}

void CreateWindow ()
{
/*******************************************************************************
																MULTI_EDIT MACRO

Name: CreateWindow

Description: Creates a new window at the end of the window list.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  	jx;
	int 	tr = refresh;

	refresh = FALSE;

	jx = cur_window;
	Switch_Window(Window_Count);
	Error_Level = 0;
	Create_window;
	if(  error_level == 0  ) {

#ifndef Windows
		int  x1, x2, y1, y2, ox1,oy1 ;
		str  tstr[40] ;

		x1 = min_window_col;
		x2 = max_window_col;
		y1 = min_window_row;
		screen_num = global_int('@SCREEN_COUNT') + 1;
		if(  screen_num <= 1  ) {
			screen_num = 2;
		}
		jx = (global_int( '~WIN_BOTTOM_BORDER') == 0) * (global_int('ICON_ROWS') != 0);
		y2 = max_window_row - Global_Int( 'ICON_ROWS') - jx;
		set_global_int('@SCREEN_COUNT', screen_num );
		tstr = global_str('@INIT_WINDOW_PARMS');
		if(  tstr != ''  ) {
			x1 = parse_int('/X1=', tstr);
			x2 = parse_int('/X2=', tstr);
			y1 = parse_int('/Y1=', tstr);
			y2 = parse_int('/Y2=', tstr);
			if(  x1 < min_window_col  ) {
				x1 = min_window_col;
			}
			if(  (x2 == 0) | (x2 > max_window_col)  ) {
				x2 = max_window_col;
			}
			if(  y1 < min_window_row  ) {
				y1 = min_window_row;
			}
			if(  (y2 == 0) | (y2 > (max_window_row - Global_Int( 'ICON_ROWS') - jx)  )) {
				y2 = max_window_row - Global_Int( 'ICON_ROWS') - jx;
			}
		}
		size_window( x1, y1, x2, y2 );
#else
		if( !parse_int("/NV=", mparm_str))
		{
			int jy;
			int flag = 0;
			for ( jy = 1; jy < Window_Count; jy++ )
			{
				switch_window (jy);
				if ((window_attr & 0x01) == 0 )  // not hidden
				{
					flag = 1;
					break;
				}
			}
			switch_window (window_count);
			if ( (Global_Int ("@MAXIMIZE_WINDOWS") != 0) && (flag == 0))
			{
				make_window_visible (3);  // show maximized  SW_SHOWMAXIMIZED
			} else {
				make_window_visible (1);
			}
		}

#endif
	} else {
		switch_window(jx);
	}

	refresh = TR;
}

macro LdFiles trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: LDFILES

Description:  Loads files into windows.  Handles wild card characters.
						Normally, LDFILES checks to see if the file is already loaded.

Parameters: Return_Str = the filename;

      /LC=n   This parameter is a little awkward to understand.
              Basically, if it is 0 then the first file will be
              loaded into the current window.  If it is non-zero,
              then new windows will be created.  Return_Int will
              return the number of files loaded + the number passed
              with /LC=.

      /MC=n   The max number of files allowed to be loaded.  Only
              applies to wildcards and file lists.

      /NW=1   Do not allow wildcards.

      /NC=1   Do not check to see if a file is already loaded.
              Normally LDFILES checks to see if the specified file
              is already loaded and prompts the user for
              re-loading.

      /PRE=   Will pass this parameter to EXTSETUP

      /CW=    1   Create new window immediately, regardless of /LC=.

              2   Create new window ONLY if the current window is
                  NOT empty.

      /NHA=1  No History Add - don't add files to history list.

      /DE=1   Use default extension if applicable.  This allows you
              to pass a filename without an extension, and LDFILES
              will use the default extension list (configured in
              Edit Settings) to find the file.

      /RO=1   Open files read-only (no modifications allowed)

      /FTO=x  Filetype override
              0 = Use defaults for extension
              1 = DOS
              2 = UNIX
              3 = Binary  /BRL=x record length
              255 = Leave line_terminator values alone

      /TAG=id Load using tag list in specified window id
              A tag list is a list of files to load, where there is
              one filename per line.  You pass the window_id of the
              window that contains the list.  IMPORTANT:  we are
              using Window_Id here, not Cur_Window (the window
              order number).  Also, /TAG does not support locating
              files in their default directories.  The file's path
              must be specified, or must be the current directory.

      /OEM=x  0 = Use Default
              1 = Ansi
              2 = Oem

      /NRL=1  Do not reload or prompt for already loaded files. If
              the specified file already exists, do not reload it,
              and do not prompt, just switch to it.

      /XL=1   Do XLoad_File instead of Load_File.  XLoad_File does
              not try to load any of the file into memory, it just
              opens the file.  The file will get loaded into memory
              when it is accessed or displayed.  This is not used
              often.

      /NR=1   Do not modify Window redraw flag ( Windows only ).
              Normally redraw is turned off, all files are loaded,
              and then redraw is restored so that the screen can
              be repainted.

      /FN=str Filename to load.  This overrides Return_Str.

      /NB=1   Do not do any special brief window processing.


Returns:
      The number of files loaded is returned in Return_Int,
      however, Return_Int is always at least 1.  To check the
      success of the operation, use Error_Level.  If Error_Level is
      non-zero, then an error occurred.  If you use /LC=1 (or > 0),
      or /CW=1, or use a tag list, then new windows will be created
      even if the file load fails (you get the "File not found, new
      file assumed" message).

      Also, Global integer Load_Count will be set to /LC=nn + the
      number of files loaded.

							 (C) Copyright 1991-1995 by American Cybernetics, Inc.
*******************************************************************************/

	int Load_Count = Parse_Int( "/LC=", MParm_Str );
	int Max_Count  = Parse_Int( "/MC=", MParm_Str );
	int	Wild_Cards = Parse_Int( "/NW=", MParm_Str ) == 0;
	int Load_Check = Parse_Int( "/NC=", MParm_Str ) == 0;
	int	Lc2 			 = Parse_Int( "/CW=", MParm_Str );
	int AddHistory = Parse_Int( "/NHA=", MParm_Str ) == 0;
	int UseDefExt  = Parse_Int( "/DE=", MParm_Str );
	int	Fto 			 = Parse_Int( "/FTO=", MParm_Str );
	int Brl				 = Parse_Int( "/BRL=", mparm_str );
  int Tag 			 = Parse_Int( "/TAG=", MParm_Str );
  int Oem 			 = Parse_Int( "/OEM=", MParm_Str );
	int NoReload 	 = Parse_Int( "/NRL=", MParm_Str );
	int DoXLoad		 = Parse_Int( "/XL=", MParm_Str );
  int No_Redraw  = Parse_Int( "/NR=", MParm_Str );
	int NoBrief		 = Parse_Int( "/NB=", MParm_Str );

	int SavRefresh 	 = Refresh;
	int SavFto 			 = Fto;
  int Redraw_State = False;
	int Good_Load 	 = False;
  int XLoad 			 = False;
	int OrgWin 			 = Window_Id;
	int NewWin 			 = Window_Id;
	int FirstLoad		 = True;
	int OrgWinZoomed = IsZoomed( Window_Handle );

	int	Jx;
	int Jy;
	int Tr;
  int T_Win;
  int Font_Size;
	int Font_Oem;

	str PreStr 	= Parse_Str( "/PRE=", MParm_Str );
  str TStr 		= Parse_Str( "/FN=", MParm_Str );
  str TStr2;
  str MStr[ 128 ];
  str Font_Name;

#ifdef LFN

	struct WIN32_FIND_DATA 	New_Fd;
  struct DOS_FIND_DATA 		Old_Fd;

  int Find_Handle;

#else

  str T_Search_Rec[ 64 ] = File_Search_Rec;

  int T_File_Search_Attr = File_Search_Attr;

	File_Search_Attr = 0x27;

#endif

	if ( BriefMode && !NoBrief ) {
		NoReload = True;
  	call Redraw_Off;
	}
  if ( Svl( TStr ) ) {
    Return_Str = TStr;
  }
	else {
    TStr = Return_Str;
  }
	if ( Max_Count == 0 ) {
		Max_Count = 1000;
	}
	if ( Lc2 == 2 ) {
		Lc2 = 1;
		if ( ( Caps( File_Name ) == "?NO-FILE?" ) && ( File_Changed == False ) ) {
			if ( ( Lines_In_Mem == 0 ) && Eof_In_Mem ) {
			 Lc2 = 0;
			}
		}
	}
	if ( Tag ) {
		Refresh = False;
		if ( Switch_Win_Id( Tag ) ) {
			Tof;
			TStr = Shorten_Str( Get_Line( ) );
			if ( Svl( TStr ) != 0 ) {
				if ( AddHistory ) {
					// Mods below by AJH 12/30/94 3:46PM to add multiple loaded files
					// to history list.  To enable, set global integer below to 1
					if ( Global_Int( "!MULTI_FILE_HISTORY" ) ) {
						Return_Str = TStr;
						do {
							Rm( "USERIN^History_List /M=1/HISTORY=FILE_HISTORY" );
							Down;
							Return_Str = Shorten_Str( Get_Line( ) );
						} while ( !At_Eof );
						Tof;
					}
					else {
             Return_Str = TStr;
						 Rm( "USERIN^History_List /M=1/HISTORY=FILE_HISTORY" );
					}
				}
				while ( True ) {
					if ( Jx = XPos( "/FTO=", TStr, 1 ) ) {
						Fto = Parse_Int( "/FTO=", TStr );
						TStr = Shorten_Str( Copy( TStr, 1, Jx - 1 ) );
					}
					else {
						Fto = SavFto;
					}
					if ( Wild_Cards && ( XPos( "*", TStr, 1 ) || XPos( "?", TStr, 1 ) ) ) {
						TStr2 = Get_Path( TStr );
#ifdef LFN
  					Find_Handle = FindFirstFile( TStr, &New_Fd, &Old_Fd );
  					if ( Find_Handle ) {
							do {
      					TStr = TStr2 + New_Fd.cFileName;
								Switch_Win_Id( OrgWin );
								call Do_Load_File;
								if ( FirstLoad ) {
									NewWin = Window_Id;
									FirstLoad = False;
								}
                if  (
                  #ifndef windows
                     Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ||
                  #endif
										( Load_Count >= Max_Count ) ) {
									break;
								}
								Switch_Win_Id( Tag );
    					} while ( FindNextFile( Find_Handle, &New_Fd, &Old_Fd ) );
    					FindClose( Find_Handle );
						}
#else
						if ( !First_File( TStr ) ) {
							do {
								TStr = TStr2 + Last_File_Name;
								Switch_Win_Id( OrgWin );
								call Do_Load_File;
								if ( FirstLoad ) {
									NewWin = Window_Id;
									FirstLoad = False;
								}
                if  (
                    #ifndef windows
                     Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ||
                    #endif
										( Load_Count >= Max_Count ) ) {
									break;
								}
								Switch_Win_Id( Tag );
							} while ( !Next_File );
						}
#endif 																	// LFN

					}  // if Wild_Cards
					else {
						Switch_Win_Id( OrgWin );
						call Do_Load_File;
						if ( FirstLoad ) {
							NewWin = Window_Id;
							FirstLoad = False;
						}
					}
          if  (
              #ifndef windows
               Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ||
              #endif
							( Load_Count >= Max_Count ) ) {
						break;
					}
					Switch_Win_Id( Tag );
					Down;
					if ( ( TStr = Shorten_Str( Get_Line( ) ) ) == "" ) {
						break;
					}
				}  															// while
				Delete_Window;
				Switch_Win_Id( NewWin );
			}  																// if Svl( TStr )
			Refresh = SavRefresh;
		}  																	// if Switch_Win_Id( Tag )
	}  																		// if Tag
	else if ( Wild_Cards && ( XPos( "*", TStr, 1 ) || XPos( "?", TStr, 1 ) ) ) {
		if ( AddHistory ) {
			Rm( "USERIN^History_List /M=1/HISTORY=FILE_HISTORY" );
		}
		TStr2 = Get_Path( TStr );

#ifdef LFN
    Find_Handle = FindFirstFile( TStr, &New_Fd, &Old_Fd );
    if ( Find_Handle ) {
			do {
        TStr = TStr2 + New_Fd.cFileName;
				call Do_Load_File;
        if  (
            #ifndef windows
            Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ||
            #endif
						( Load_Count >= Max_Count ) ) {
					break;
				}
    	} while ( FindNextFile( Find_Handle, &New_Fd, &Old_Fd ) );
      FindClose( Find_Handle );
		}
#else
		if ( !First_File( TStr ) ) {
			do {
				TStr = TStr2 + Last_File_Name;
				call Do_Load_File;
        if  (
            #ifndef windows
             Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ||
            #endif
						( Load_Count >= Max_Count ) ) {
					break;
				}
			} while ( !Next_File );
		}
#endif  																// LFN

	}
	else {
		// Support for default file extensions T.R.
		if ( UseDefExt ) {
			if ( !XPos( ".", Truncate_Path( TStr ), 1 ) && ( File_Exists( TStr ) != 1 ) ) {
				TStr2 = Global_Str( "@DEFAULT_EXT_LIST" );
				if ( Svl( TStr2 ) ) {
					// Parse out each extension one at a time until a file is found with
					// that extension, or we come to the end of the list.
					Jy = 0;

More_Exts:
					if ( Jy > Svl( TStr2 ) ) {
						// If we come to the end of the list, use no extension, unless the
						// global integer points to a desired default, and consider it a
	 					// new file.

						MStr = "";
						Tr = Global_Int( "@DEFAULT_EXT_POS" );
						while ( Tr ) {
							call Parse_Ext;
							--Tr;
						}
						goto Got_Ext;
					}
					call Parse_Ext;

					Return_Str = Tstr + Mstr;
					Rm( "SetFilename" );
					if ( File_Exists( Return_Str ) == 1 ) {
						goto Got_Ext;
					}
					goto More_Exts;

Got_Ext:
					TStr += Copy( MStr, 1, 260 );
				}
			}
		}

No_Ext:
		Return_Str = TStr;
		Rm( "SetFileName" );
		TStr = Return_Str;
		if ( AddHistory ) {
			Rm( "USERIN^History_List /M=1/HISTORY=FILE_HISTORY" );
		}
		call Do_Load_File;
	}
	Set_Global_Int( "Load_Count", Load_Count );
	Return_Int = Load_Count;

#ifndef LFN
	File_Search_Rec = T_Search_Rec;
	File_Search_Attr = T_File_Search_Attr;
#endif

	Rm( "SetWindowNames" );
	if ( BriefMode && !NoBrief && !HexEnabled( ) ) {
		if ( Return_Int && !Error_Level ) {
			if ( Window_Id != OrgWin ) {
				Rm( "BRIEF^BrSwitchBuffer /NEWBUFF=" + Str( Window_Id ) );
				Return_Int = Load_Count;
			}
			else {
				Rm( "Select_Window /MAX=" + Str( OrgWinZoomed ) );
			}
		}
	}
	call Redraw_On;
	Refresh = SavRefresh;
	return ( );


Do_Load_File:
  TStr = GetLongName(FExpand( TStr ));
	T_Win = Cur_Window;
	Tr = Refresh;
	Refresh = False;
	if ( Load_Check ) {
		if ( Switch_File( TStr ) ) {
			if ( NoReload ) {
				Return_Int = 0;
			}
			else {
				Rm( "USERIN^Verify /S=1/H=" + hc_AlreadyLoad + "/T=" + TStr +
						" already loaded, load again?" );
			}
			if ( Return_Int <= 0 ) {
				++Load_Count;
				window_attr &= 0xFF7F;            // Make it a non-system window
				Rm( "WINDOW^Select_Window /VIS=1/BM=" + Str( !NoBrief ) );
				redraw;
				Refresh = Tr;
				Good_Load = False;
				ret;
			}
			Switch_Window( T_Win );
		}
	}
	if ( ( Load_Count + Lc2 ) > 0 ) {
		Error_Level = 0;
		if ( Window_Count >= 128 ) {
			goto No_Windows;
		}
		if ( Load_Count > 0 ) {
			Refresh = False;
		}
		else {
			Refresh = True;
		}
		Rm( "CreateWindow" );
    Redraw;
		if ( Error_Level != 0 ) {

No_Windows:
      Load_Count  = 20000;
			Error_Level = 0;
      Make_Message( "Out of Windows!!!" );
			Good_Load = False;
			ret;
		}
	}
	if ( Load_Count == 0 ) {
		Refresh = Tr;
	}
	Make_Message( "Loading \"" + TStr + "\"..." );
	Rm( "ExtSetup /PRE=1/EXT=" + Get_Extension( TStr ) +
			"/FTO=" + Str( Fto ) + "/OEM=" + str (oem) + "/BRL=" + str(brl) );
	if ( ( Load_Count > 0 ) || DoXLoad ) {
		XLoad_File( TStr );
		XLoad = True;
	}
	else {
		Load_File( TStr );
		XLoad = False;
  }

	if ( Error_Level == 3002 ) {
		MStr = "";
		Error_Level = 0;
		Return_Int = 0;
		if ( Global_Str( "@FNF_LOAD_MACRO@" ) != "" ) {
			Rm( Global_Str( "@FNF_LOAD_MACRO@" ) + " /F=" + TStr );
		}
		if ( Return_Int == 0 ) {
			if ( ( Error_Level == 0 ) && ( Caps( File_Name ) == "?NO-FILE?" ) ) {
				MStr = TStr + " NOT Found,  NEW file assumed.";
				File_Name = FExpand( TStr );
			}
			else {
				Error_level = 3002;
				MStr = "Error:" + Str( Error_Level ) + " occured loading \"" + TStr + "\"";
			}
		}
	}
	else if ( Error_Level != 0 ) {
		Erase_Window;
		Rm( "MEERROR^ErrMsg" );
		MStr = "\"" + TStr + "\":  Error " + Str( Error_Level ) + " " + Return_Str;
	}
	else { /* IF (Load_Count > 0) or (EOF_IN_MEM > 0) or (xload) THEN  */
    if( parse_int("/RO=", mparm_str))
    {
      read_only = TRUE;
    }
		if ( Read_Only ) {
			TStr = " (Read-Only).";
		}
		else {
			TStr = ".";
		}
		MStr = "\"" + File_Name + "\" loaded" + TStr;
	}
	if ( Svl( MStr ) != 0 ) {
		Make_Message( MStr );
	}
	File_Changed = False;
  if ( ( ( Window_Attr & 0x0001 ) || ( Window_Handle == 0 ) ) && !No_Redraw ) {
		Rm( "Select_Window /MAX=" + Str( Global_Int( "@Maximize_Windows" ) ) );
		Window_Attr &= 0xFF7E;
	}
	if ( Error_Level == 0 ) {
		Rm( "ExtSetup /POST=1/PRE=" + PreStr +
			"/FTO=" + Str( Fto ) + "/OEM=" + str (oem) + "/BRL=" + str(brl) );
	}
	call Redraw_Off;
	++Load_Count;
	Good_Load = True;
	if ( BriefMode && !HexEnabled( ) ) {
		Window_Attr &= 0xFFFE;
		Make_Window_Visible( 1 );
		// set as a hidden buffer
		Window_Attr |= 0x01;
	}
	ret;


Redraw_Off:

#ifdef Windows
  if ( !No_Redraw ) {
		// Here we are going to turn off the windows redraw flag
		if( !Redraw_State ) {
			if ( IsWindowVisible( Frame_Handle ) ) {
				if ( ( SendMessage( Frame_Handle, WM_MDIGETACTIVE, 0, 0 ) >> 16 ) == 0 ) {
					Redraw_State = True;
					SendMessage( Frame_Handle, WM_SETREDRAW, 0, 0 );
				}
			}
		}
	}
#endif
	ret;

Redraw_On:
#ifdef Windows
  if ( !No_Redraw ) {
	 	// Here we are going to turn on the windows redraw flag
	 	if ( Redraw_State ) {
	 		Redraw_State = False;
			SendMessage( Frame_Handle, WM_SETREDRAW, 1, 0 );
			RedrawWindow( Frame_Handle, 0, 0, RDW_FRAME | RDW_ALLCHILDREN | RDW_INVALIDATE );
	 	}
	}
#endif
	ret;

Parse_Ext:
	Jx = XPos( ";", TStr2, Jy + 1 );
	if ( Jx == 0 ) {
		Jx = Svl( TStr2 ) + 1;
	}
	MStr = Copy( TStr2, Jy + 1, Jx - Jy - 1 );
	if ( Str_Char( MStr, 1 ) != "." ) {
		MStr = "." + MStr;
	}
	Jy = Jx;
	ret;

}  // LdFiles

macro QuickLoad( int HistoryFile = Parse_Int( "/F=", MParm_Str ) ) {

	int HistoryCount = Parse_Int( "/#=", Global_Str( "FILE_HISTORY" ) );
	int Index 			 = ( HistoryCount - HistoryFile ) + 1;
	int OrgWin 			 = Window_Id;
	int NewWin;

	str FName;

	if ( ( HistoryCount > 0 ) && ( Index > 0 ) && ( Index <= HistoryCount ) ) {
		FName = Global_Str( "FILE_HISTORY" + Str( Index ) );
		if ( Switch_File( FName ) ) {
			Rm( "Select_Window /BM=1/VIS=1" );
			return ( );
		}
		Return_Str = FName;
		Rm( "LdFiles /LC=0/CW=2" );
	}
}  // QuickLoad

macro AUTOSAVE TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: AUTOSAVE

Description:  Checks all windows and saves all modified files.  Can be invoked
							by the autosave timer system, or as part of the exit macro.

Parameters:
							/NF=1  Don't try to save "no-file" windows.

							/EX=1  tells autosave to clean up autosave files and save all
										 changed files if the global autosave_ext was defined.

							/EX=2  tells autosave to clean up autosave files and exit
										 if the global autosave_ext was defined.

	if the global autosave_ext is not defined the parameter /EX has no effect

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int Save_Count,JX,OLD_WIN, t_error, b1, old_refresh;
/* Start of .ASV modification block 1
	Def_Str(f_name, flg_name, ASV_name, save_ext);
	def_int (t_Ex, tmp_backup);

	t_Ex := Parse_Int('/EX=', mparm_str);
End of .ASV modification block 1  */

	old_refresh = refresh;
	Refresh = False;
	OLD_WIN = CUR_WINDOW;
	Save_Count = 0;
	t_error = 0;
	b1 = 0;
	JX = 1;
	error_level = 0;
	while(  jx <= Window_Count  ) {
		Switch_Window(jx);
		++jx;

/* Start of .ASV modification block 2
		save_ext := '.' + global_str( 'autosave_ext' );
		flg_name   := Truncate_Extension(Truncate_Path(File_Name)) + save_ext;
		IF (t_Ex) THEN
			IF (Global_Int(flg_name)) THEN
				if (backups = 2) Then
					ASV_Name := Backup_Path +
											Truncate_Extension(Truncate_Path(File_Name)) +
											save_ext;
				else
					ASV_Name := Truncate_Extension(File_name) +
											save_ext;
				end;
				Put_Box( 20, 5, 60, 8, 0, m_s_color, 'REMOVING AUTOSAVE FILES...', TRUE );
				Draw_Char( 32, 22, 6, m_t_color, 35 );
				Write( truncate_path( ASV_name ), 26, 6, 0, m_t_color );
				Set_File_Attr(ASV_name,0);
				del_file(ASV_name);           /* delete autosave file if exiting */
				File_changed := TRUE;
			END;
			save_ext := '.';
		END;
		IF ((t_Ex = 2) and (global_str( 'autosave_ext' ) <> '')) THEN
			goto ASV_quit;
		END;
End of .ASV modification block 2  */

		if(  (File_Changed != 0) && (((window_attr & $80) == 0) /* ||
			(caps(file_name) != "?NO-FILE?") */)  ) {
				#IFNDEF windows
			if(  NOT(b1)  ) {
				b1 = TRUE;
				Put_Box( 20, 5, 60, 8, 0, m_s_color, 'SAVING FILES...', TRUE );
			}
			Draw_Char( 32, 22, 6, m_t_color, 35 );
			Write( truncate_path( file_name ), 26, 6, 0, m_t_color );
				#ENDIF
			if(  CAPS(File_Name) == '?NO-FILE?'  ) {
				if(!parse_int("/NF=", mparm_str))
				{
					Refresh = True;
					Redraw;
					RM( 'MEUTIL1^SAVEFILE' );
					if(  (Return_Int == 0)  ) {
						T_Error = 1;
					}
					Refresh = False;
				}
			} else {
				rm("MEUTIL1^SAVEFILE /NP=1/NM=1/NCO=1");
/* Start of .ASV modification block 3
				IF (save_ext <> '.') THEN
					f_name := File_Name;
					if (backups = 2) Then
						File_Name := Backup_Path +
												Truncate_Extension(Truncate_Path(File_Name)) +
												save_ext;
					else
						File_Name := Truncate_Extension(File_name) +
												save_ext;
					end;
					Set_Global_Int(flg_name,1);
					if (CAPS(TRUNCATE_PATH(File_Name)) <> '!BUF.0') and
						(CAPS(TRUNCATe_PATH(File_Name)) <> 'MEFIND.TMP') then
						tmp_backup := backups;
						Backups := 0;
						SAVE_FILE;
						Backups := tmp_backup;
					end;
					File_Name := f_name;
					File_Changed := 0;
				ELSE
					SAVE_FILE;
				END;
End of .ASV modification block 3 */
			}
			if(  Error_Level != 0  ) {
				if(!parse_int("/NF=", mparm_str))
				{
					RM( 'MEERROR' );
				}
				error_level = 0;
				t_error = true;
			}
			++Save_Count;
		}
/*
ASV_quit:
 */
	}
	#IFNDEF windows
	if(  b1  ) {
		kill_box;
	}
	#ENDIF
	Switch_Window(OLD_WIN);
	error_level = 0;
	Refresh = old_refresh;
	return_int = t_error;
}

macro AUTOSAVETIMER TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: AUTOSAVETIMER

Description:  Manages autosave timer events.  The timer can be based on the
amount of time that has passed since the last time the user pressed a key (or moved
the mouse), or on an absolute interval.  This macro is only intended to be run
by assigning it as a timer event macro.  EXAMPLE:
Timer_Handle := SET_TIMER_EVENT('AUTOSAVETIMER /NOW=0/T=10/S=0', 18, EDIT);

Parameters:
						/NOW= If <> 0, will immediately autosave.  This is for the absolute
						interval method.  IF 0, then the keyboard inactivity method is used.
						/S= If <> 0, then the complete status of the editor is saved as
						well as the files.


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	if(  (Global_Int('Menu_Level'))  ) {
/* We don't want to autosave in the middle of a menu or prompt */
		Goto EXIT;
	}
	if(  parse_int('/NOW=', mparm_str)  ) {
		goto GO_AUTOSAVE;
	}
	if(  global_int('!LAST_AUTOSAVE_TIME') < last_keypress_time  ) {
		if(  (last_event_time - last_keypress_time) >= parse_int('/T=', mparm_str)  ) {
GO_AUTOSAVE:
			set_global_int( '!LAST_AUTOSAVE_TIME', last_event_time );
			SET_GLOBAL_INT('@TEMP_RETURN_INT', return_int );
			SET_GLOBAL_STR('@TEMP_RETURN_STR', return_str );
			RM('AUTOSAVE');
			if(  (Parse_Int('/S=',MParm_Str))  ) {
				RM(']EXIT^STATUS');
			}
			return_int = Global_Int('@TEMP_RETURN_INT');
			return_str = Global_Str('@TEMP_RETURN_STR');
			set_global_int('@TEMP_RETURN_INT',0);
			set_global_str('@TEMP_RETURN_STR','');
			update_status_line;
		}
	}
EXIT:
}

macro SETAUTOSAVE TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SETAUTOSAVE

Description:  Creates 1 or 2 autosave events from parameters passed by the
installation and setup screen.

Parameters:
						/H1= Existing timer event handle.  This macro will release this
								 handle before assigning a new one to replace it.  The new
								 handles are saved into GLOBAL_STR( '!AUTOSAVEPARMS') using
								 identical parameter syntax.  You must pass these handles to
								 this macro, or they will remain in force.
						/H2= Same as above.

						/T1= Timeout factor for event 1 in seconds.
						/T2= Timeout factor for event 2.

						/M1= Timeout method for event 1.
								0=Keyboard inactivity method.
								1=Absolute interval method.
						/M2= Timeout method for event 2.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  h1,h2,T1,T2,M1,M2,S1,S2;
	str  astr[80] ;

	astr = Global_str('!AUTOSAVEPARMS');
	h1 = parse_int('/H1=', astr );
	h2 = parse_int('/H2=', astr );
	m1 = 0;
	m2 = 0;
	S1 = parse_int('/S1=', mparm_str );
	S2 = parse_int('/S2=', mparm_str );
	if(  h1 != 0  ) {
		kill_timer_event( h1 );
		h1 = 0;
	}
	if(  h2 != 0  ) {
		kill_timer_event( h2 );
		h2 = 0;
	}
	T1 = parse_int('/T1=', mparm_str ) * 18;
	T2 = parse_int('/T2=', mparm_str ) * 18;
	if(  T1 > 0  ) {
		M1 = parse_int('/M1=', mparm_str );
		if(  M1 == 0  ) {
			h1 = set_timer_event('AUTOSAVETIMER /T=' + str( T1 ) + '/S=' + Str(S1), 28, EDIT);
		} else if(  M1 == 1  ) {
			h1 = set_timer_event('AUTOSAVETIMER /NOW=1/S=' + Str(S1), T1, edit);
		}
	}
	if(  T2 > 0  ) {
		M2 = parse_int('/M2=', mparm_str );
		if(  M2 == 0  ) {
			h2 = set_timer_event('AUTOSAVETIMER /T=' + str( T2 ) + '/S=' + Str(S2), 28, EDIT);
		} else if(  M2 == 1  ) {
			h2 = set_timer_event('AUTOSAVETIMER /NOW=1/S=' + Str(S2), T2, edit);
		}
	}

	Set_Global_STR( '!AUTOSAVEPARMS', '/H1=' + str(H1) + '/H2=' + str(H2) +
									'/M1=' + str(M1) + '/M2=' + str(M2) +
									'/T1=' + str(T1 / 18) + '/T2=' + str(T2 / 18) +
									'/S1=' + str(S1) + '/S2=' + str(S2)
									);

}

macro SetWindowNames {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SetWindowNames

Description:  Goes through the entire set of windows currently loaded
		and assigns alphabetic WINDOW_NAMEs to them, skipping any with the
		INVISIBLE (Bit 7) attribute.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int SavRefresh = Refresh;
	int ActiveWin	 = Cur_Window;
	int ErrorWinId = Global_Int( "~MEERR_ID" );
	int Jx 				 = 0;
	int Jy         = 0;
	int Jz         = 0;

	Refresh = False;
	while ( Jx < Window_Count ) {
		++Jx;
		Switch_Window( Jx );
		if ( ( Window_Attr & 0x80 ) == 0 ) {
			if( Window_Id == ErrorWinId ) {
				Window_Name = "OUTPUT";
			}
			else {
				++Jy;
				if ( Jy > 26 ) {
					Jy = 1;
				 ++Jz;
				}
				if ( Jz > 0 ) {
					Window_Name = Char( Jz + 48 ) + Char( Jy + 64 );
				}
				else {
					Window_Name = Char( Jy + 64 );
				}
				// Change to use exported function from FC.SH when available
				if ( XPos( "FC_EPROC", Caps( Event_Macro ), 1 ) ) {
					Window_Name += "-Cmpr";
				}
				if ( HexEnabled( ) ) {
					Window_Name += "-Hex";
				}
			}
		}
	}
	Switch_Window( ActiveWin );
	Refresh = SavRefresh;

}  // SetWindowNames

macro KEYMAC_LOAD {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: KEYMAC_LOAD

Description:  Loads, saves, erases keystroke macros from KEYMAC.DB

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int Active_Window,
					Keymac_Window,
					Keymac_Count,
					T_Reg_Exp_Stat = Reg_Exp_Stat,
					T_Insert_Mode = Insert_Mode,
					T_Mode,
					T_Refresh,
					Load_Mode,
					K_int,
					Keep_Window;
	str k_str;

	T_Refresh = Refresh;
	Refresh = False;
	Load_Mode = Parse_Int('/LM=',MParm_Str);
	Keep_Window = Parse_Int('/KW=',MParm_Str);
	Keymac_Count = 0;
	Reg_Exp_Stat = True;
	Active_Window = Window_Id;
	RM('Setconfig /DB=MECONFIG/T=KEYMAC.DB');

	if (Return_Int == 0) {
		if (Parse_Int('/NE=',MParm_Str)) {
			Error_Level = 0;
			Goto EXIT;
		}
		if (Load_Mode == 1) {
//      error_level = 3003;
			RM('MESSAGEBOX /B=1/M=Can''t find ' + Return_Str + ' to save this keystroke macro in.');
		} else if(  (Load_mode == 2)  ) {
			RM('MESSAGEBOX /B=1/M=Can''t find ' + Return_Str + ' to erase keystroke macros.');
		} else {
			RM('MESSAGEBOX /B=1/M=Can''t find ' + Return_Str + ' to load keystroke macros.');
		}
		Goto EXIT;
	}

	eol;

	if (Load_Mode == 1) {
		reg_Exp_Stat = TRUE;
		RM('KEYMAC^DOUBLE_127');
		if (Search_Fwd('%|12',0)) {
			Up;
		} else {
			Eof;
			if(  (C_Col == 1)  ) {
				Up;
			}
		}
		Eol;
		Insert_Mode = True;
		Cr;
		Put_Line('D=' + Parse_Str('/D=',MParm_Str) + 'KEY=' +
			parse_str("KEY=",mparm_str) + 'M=' + Parse_Str('/M=',MParm_Str) +
			'S=' + Convert_String(Global_Str('@KEYBUF')));
		Set_Global_Str('@KEYBUF','');
	} else {
/* Find each keystroke macro record and set up the global and key assignment */
		Down;
		Goto_Col(1);
		while ((Not(At_Eof)) & (Cur_Char != '|12')) {
			if (Get_Line != '') {
				T_Mode = Parse_Int('M=',Get_Line);
				if ((T_Mode != 0) & (T_Mode != 1) & (T_Mode != 3) &
						(T_Mode != 255)) {
/* Make sure the ME mode is a legal value */
					T_Mode = 0;
				}

				K_str = Parse_str('KEY=',Get_Line);
				if (svl(k_str)) {
					k_int = (parse_int("/K2=",k_str) << 8) | (parse_int("/K1=",k_str));
					if (k_int) {
/* Only load those macros who have a key assigned to them */
						++keymac_count;
						if (Load_Mode == 2) {
/* This will unload the macros from memory */
							set_global_str('@KM!#' + str(keymac_count),'');
							Unassign_key(k_int,t_mode);
						} else {
							set_global_str('@KM!#' + str(keymac_count),Reconvert_String(Parse_str('S=',Get_Line)));
							global_to_key(K_Int, '@KM!#' + str(keymac_count),T_Mode);
						}
					}
				}
			}
			Down;
		}
		if (Load_Mode == 2) {
			set_global_int('@KEYMACRO_COUNT@',0);
/* This will reload the keymap in case a keystroke macro had previously
overwritten a keymap assignment */
			ERROR_LEVEL = 0;
			RM(User_Id+'INIT^'+User_Id+'KEYMAP');
			if (ERROR_LEVEL != 0) {
				RM('INIT^KEYMAP');
			}
		} else {
			set_global_int('@KEYMACRO_COUNT@', keymac_count );
		}
	}

EXIT:
	Switch_Win_id(Active_Window);
	Reg_Exp_Stat = T_Reg_Exp_Stat;
	Insert_Mode = T_Insert_Mode;
	Refresh = T_Refresh;
}

macro PARMS1 DUMP {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: PARMS1

Description:  Called by Multi-Edit internally to process most command line
		parameters.  Gets called before PARMLOAD, after INIT and before STARTUP.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int Parm_Number;
	int jx, default_back, kspeed ;
	str TStr;
	char Tchar;


	set_global_int("@NO_MOUSE_SET", TRUE );

	temp_path = TranslateCmdLine(Global_Str('!TEMP_PATH'), '');
	#ifdef windows
	if (length(temp_path) == 0) {
		temp_path = Get_Environment("TEMP");
		if(temp_path == "")
		{
			temp_path  =  char(GetTempDrive(0)) + ":\\";
		}
		// GetTempFileName(GetTempDrive(jx), "", 0, tstr);
		// temp_path = get_path(tstr);
	}
	#endif

	Temp_Path = AddTrailingSlash( temp_path );

	backup_path = AddTrailingSlash(TranslateCmdLine( Global_Str('!BACKUP_PATH'), '' ));

#IFNDEF windows
		kspeed = (Global_Int('NO_KEYSPEED') == 0);


		 /* Do we need to set default colors? */
	if(  global_int('DEFAULT_COLORS')  ) {
		intr($11);
		if(  (r_ax & $0030) == $0030  ) {
			call set_mono;
		} else {
			call set_color;
		}
	}

	Parm_Number = 1;
	while(  Parm_Number <= PARAM_COUNT  ) {
		TStr = Caps(PARAM_STR(Parm_Number));
		if(  XPOS(Copy(TStr,1,1),'/-',1) != 0  ) {
			TStr = Copy(TStr,2,80);
			TChar = Copy(Tstr,1,1);
			if(  (Length(TSTR) > 1) & (XPos(Copy(Tstr,2,1),'0123456789',1) != 0)  ) {
				if(  VAL(jx, Copy(Tstr,2,8)) == 0  ) {
				}
			} else {
				if(  (Length(tstr) == 2) & (XPOS(Copy(Tstr,2,1), 'YN', 1) != 0)  ) {
					if(  (Copy(Tstr,2,1) == 'Y')  ) {
						jx = true;
					} else {
						jx = false;
					}

					if(  TChar == 'K'  ) {
						Set_Global_Int('NO_KEYSPEED', jx == 0 );
						kspeed = jx;
					}
					if(  TChar == 'N'  ) {
						Name_Line = jx;
					}
					if(  TChar == 'L'  ) {
						Logo_Screen = jx;
					}
				} else {
					if(  (Length(TStr) == 1)  ) {
/* This is a list of command line options that occurs if a /? is used on the
command line. */
						if(  (Tchar == '?')  ) {
							Rest_Dos_Screen;
							Write_Sod('The following command line options are available:|13|10');
							Write_Sod('  /Ln = Go to line n in first file loaded.|13|10');
							Write_Sod('  /MN = Mouse disable, /MY = Mouse enable|13|10');
							Write_Sod('  /MF = Force fully compatible mouse mode|13|10');
							Write_Sod('  /KN = Don''t change keyspeed, /KY = Change keyspeed|13|10');
							Write_Sod('  /NR = No Restore;  Does not change the setup|13|10');
							Write_Sod('  /B  = Use black and white colors, /C = Use default colors|13|10');
							Write_Sod('  /Xn = Sets screen width to n.|13|10');
							Write_Sod('  /Yn = Sets screen height to n.|13|10');
							Write_Sod('  /O  = OS/2 switch on.|13|10');
							Write_Sod('  /EN = Don''t try to use enhanced keyboard|13|10');
							Write_Sod('  /D  = Use direct video.  Bypass Desq-View/Windows|13|10');
							Write_Sod('  /V  = Don''t wait for retrace on CGA video I/O.|13|10');
							Write_Sod('  /Rmacro_name = Run the macro: macro_name.|13|10');
							Write_Sod('  /EMSOFF = Do NOT use expanded/extended memory.|13|10');
							Write_Sod('  /BIGVM = Use large virtual memory mode.|13|10');
							Write_Sod('  /@filename = Load file list.|13|10');
// new options (and old) - loading of files [with filetype override]
							Write_Sod('  filename [filename [...]] = Load the specified file.|13|10');
							Write_Sod('      Multiple files may be loaded, and optionally, use|13|10');
							Write_Sod('      the following File Type Override specifiers:|13|10');
							Write_Sod('  /!filename = Load file in UNIX format.|13|10');
							Write_Sod('  /&filename = Load file in Binary format.|13|10');
							Write_Sod('  /*filename = Load file in MSDOS text format.|13|10');
							Write_Sod('  /CDpath = change to directory.|13|10');
							quit(0);
						}
						if(  TChar == 'B'  ) {
							/* /B force monochrome defaults */
							Set_Global_Int('COM_DEFAULT_COLORS',1);
							call set_mono;
						}
						if(  TChar == 'C'  ) {
							Set_Global_Int('COM_DEFAULT_COLORS',1);
							call set_color;
						}
					}
				}
			}
		Next_While:
		}
		Parm_Number = Parm_Number + 1;
	}

	if(  kspeed  ) {
		R_BX = (Global_Int('KEYDELAY') << 8) | GLOBAL_INT('KEYSPEED');
		R_AX = $0305;
		INTR( $16 );
		Set_Global_Int('NO_KEYSPEED', 0 );
	}
	goto exit;

color_defaults:
	stat1_color = lightgray | default_back;
	stat2_color = white | default_back;
	message_color = lightgray | default_back;
	fnum_color = lightgray | default_back;
	fkey_color = 112;
	w_t_color = LightGray | default_back;
	w_s_color = yellow | default_back;
	w_b_color = lightgray | default_back;
	w_h_color = 112;
	w_eof_color = white | default_back;
	w_l_color = yellow | default_back;
	w_lb_color = 113;
	w_c_color = white | default_back;
	m_t_color = LightGray | default_back;
	m_s_color = white | default_back;
	m_b_color = white | default_back;
	m_k_color = cyan | default_back;
	m_h_color = 112;
	d_t_color = m_t_color;
	d_s_color = m_s_color;
	d_b_color = m_b_color;
	d_h_color = m_h_color;
	h_t_color = lightgray | default_back;
	h_s_color = white | default_back;
	h_r_color = yellow | default_back;
	h_b_color = lightgray | default_back;
	h_h_color = 112;
	h_f_color = 112;
	h_t1_color = 33;
	h_t2_color = 41;
	h_t3_color = 240;
	working_color = 240;
	background_color = default_back | white;
	Error_color = white | default_back;
	Shadow_Color = LightGray | default_back;
	Shadow_Char = Char(177);
	button_color = 7;
	button_key_color = 15;
	button_shadow_color = default_back | lightgray;
	Set_Global_Str('&SYNTAX_COLORS','/RWC=271/SYC=271/ECC=880/SCC=265/C1C=880/C2C=880/NCC=0');
	ret;

set_color:
	Error_Color = 79;
	Shadow_Color = 8;
	Shadow_Char = '|0';
	W_T_Color = 23;
	W_H_Color = 96;
	W_B_Color = 27;
	W_C_Color = 31;
	w_l_color = 30;
	w_lb_color = 110;
	W_EOF_Color = 20;
	W_S_Color = 30;
	M_T_Color = 112;
	M_S_Color = 113;
	M_B_Color = 112;
	M_H_Color = 95;
	m_k_color = 120;
	CB_H_Color = 63;
	CB_T_Color = 48;
	CB_S_Color = 49;
	Button_Color = 27;
	Button_Key_Color = 30;
	Button_Shadow_Color = 120;
	D_T_Color = 112;
	D_S_Color = 113;
	D_B_Color = 112;
	D_H_Color = 80;
	H_T_Color = 23;
	H_T1_Color = 27;
	H_T2_Color = 28;
	H_T3_Color = 127;
	H_S_Color = 31;
	H_B_Color = 23;
	H_H_Color = 112;
	H_R_Color = 30;
	H_F_Color = 112;
	FKey_Color = 112;
	FNum_Color = 49;
	Stat1_Color = 112;
	Stat2_Color = 113;
	Message_Color = 112;
	Working_Color = 192;
	Background_Color = 23;
	Set_Global_Str('&SYNTAX_COLORS','/RWC=283/SYC=267/ECC=316/SCC=298/C1C=268/C2C=268/NCC=266');
	ret;

set_mono:
	CB_H_Color = 112;
	CB_T_Color = 7;
	CB_S_Color = 15;
	default_back = 0;
	Call Color_Defaults;
	Set_Global_Str('&SYNTAX_COLORS','/RWC=271/SYC=271/ECC=880/SCC=265/C1C=880/C2C=880');
	ret;

#ENDIF

exit:
}

int Ld_Override_File( str FStr, int Lc ) {
/****************** Multi-Edit INTEGER Macro Function ***********************

 NAME:         ld_override_file

 DESCRIPTION:  loads a filename from command-line using
	 using a filetype override specifier

	command line syntax:   me /<specifier>filename ...

	multiple type-overridden filenames are valid.

				! - unix format override
				& - binary format override
				* - msdos text format override

 PARAMETERS:  str tstr	filename with type specifier
				int lc	current value of Load_Count in PARMLOAD
						macro or 0 to just load the file.

 RETURNS:     return_int as returned by LDFILES macro (new Load_Count)

*****************************12-02-93 01:35am*******************************/

	str tstr = fstr; // str_char requires local string variable!!!

	int this_fto = 0;
	int use_def_ext = 0;


	switch ( str_char( tstr, 1) )
	{
		case '!':	// load as unix file
			this_fto = 2;
			tstr = str_del(tstr, 1, 1);
			break;
		case '&': // load as binary file
			this_fto = 3;
			tstr = str_del(tstr, 1, 1);
			break;
		case '*': // load as msdos text file
			this_fto = 1;
			tstr = str_del(tstr, 1, 1);
			break;
		default:
			use_def_ext = 1;
			break;
	}
	return_str = tstr;
	RM('LDFILES /DE='+str(use_def_ext)+
		'/NRL=1/FTO='+str(this_fto)+
		'/LC=' + str(lc));
	return(return_int);		// return new Load_Count
}

void ConfigLocked() trans
{
	#IFDEF windows
	int dlg;
	DlgCreate( dlg );
	DlgAddCtrl( dlg, DLG_ICON,"IC_STOP", 1,1, 0,0, 1100, 0, "" );
	DlgAddCtrl( dlg, DLG_Static,"Your configuration files are locked!", 8,2, 0,0, 1000, 0, "" );
	DlgAddCtrl( dlg, DLG_Static,"Before unlocking them, insure that there are NOT multiple " +
	"copies of Multi-Edit running with your user id.",
											DLG_PosOffset,DLG_PosOffset + 1, 50,2, 1002, 0, "" );

	DlgAddCtrl( dlg, DLG_ICON,"IC_QUESTION", 1,DLG_POSOFFSET + 2, 0,0, 1101, 0, "" );
	DlgAddCtrl( dlg, DLG_Static,"Do you want to unlock your configuration files?",
											8,DLG_PosOffset + 1, 0,0, 1003, 0, "" );
	DlgAddCtrl( dlg, DLG_PushButton,"&Yes", 6,DLG_POSOFFSET + 2, DLG_StanBtnWidth,0, 100, DLGF_DefButton, "/R=1" );
	DlgAddCtrl( dlg, DLG_PushButton,"&No", DLG_PosOffset + DLG_StanBtnWidth + 1,DLG_POSOFFSET, DLG_StanBtnWidth,0, 102, 0, "/R=0" );
	DlgAddCtrl( dlg, DLG_PushButton,"&Help", DLG_PosOffset + 32,DLG_POSOFFSET, DLG_StanBtnWidth,0, 104, 0, "/R=2" );

	return_int = DlgExecute( dlg, 100, "Warning!", FILELOCK_HELPLINK, "", DLG_ScreenCenter );
	DlgKill( dlg );
	#ELSE
	RM('MEERROR^MessageBox /NW=1/T=Warning/M=Your configuration files are locked.  Before unlocking them, insure that there are NOT multiple copies of Multi-Edit running with your user id.');
	RM('USERIN^XMENU /B=1/X=25/Y=8/T=1/L=Action:/M=Unlock configuration files()Ignore and leave files locked()');
	kill_box;
	#ENDIF
	if(  return_int == 1  ) {
		int tr = refresh;
		str tstr;

		refresh = false;
		make_message('Unlocking configuration files...');
		working;

		tstr = TranslateCmdline('<USER_PATH>*.*','');
		call unlock_files;

		goto config_unlocked;

		unlock_files:
      #IFDEF LFN
      struct WIN32_FIND_DATA new_fd;
      struct DOS_FIND_DATA old_fd;

      int find_handle = FindFirstFile( tstr, &new_fd, &old_fd );

      if(find_handle)
      {
        do {
          if( new_fd.dwFileAttributes & 1)
          {
            if( switch_file( fexpand( get_path( tstr ) + new_fd.cFileName )))
            {
              if(file_changed)
                save_file;
              delete_window;
            }
            Set_File_Attr( get_path( tstr ) + new_fd.cFileName,
                            new_fd.dwFileAttributes & $FFFFFFFE );
          }
        }
        while(FindNextFile( find_handle, &new_fd, &old_fd ));
        FindClose(find_handle );
			}
      #ELSE
			int jx = FIRST_FILE(TSTR);
			while(  jx == 0  ) {
				if(last_file_attr & 1)
				{
          if( switch_file( fexpand( get_path( tstr ) + last_file_name )))
					{
						if(file_changed)
							save_file;
						delete_window;
					}
					Set_File_Attr( get_path( tstr ) + last_file_name,
													last_file_attr & $FE );
				}
				jx = next_file;
			}
      #ENDIF
			ret;

config_unlocked:
		make_message('Configuration files unlocked.');
		refresh = tr;
	}
	return();
}


void ProcessCmdLine( int m = parse_int("/M=", mparm_str) )
{
}


macro ParmLoad
/*******************************************************************************
																MULTI_EDIT MACRO

Name: PARMLOAD

Description:  This macro is called by Multi-Edit directly after STARTUP.  It
							takes care of loading in files and executing macros from the
							command line.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
{
  int ParmLoad_Mode = Parse_Int( "/M=", MParm_Str );

#ifdef DEMO
	if( !parmload_mode)
	{
    // special stuff for the demo to support Evolve
		if (global_int('!EVgDialectId')) {
	/*
			make_message("!EVgDialectId=" + str(global_int('!EVgDialectId')));
			read_key;
	*/
			RM("EVINIT");
		}
	}
#endif // DEMO

  int Load_Count = 0;
  int Parm_Number;
	int cur_id 		= window_id;
  int popup_sm 	= FALSE;
	int jx, tw, tr, mouse_initialized = FALSE ;
  int restore_enable = 1, goto_l_id, no_restore = 0, Goto_L_Num = 0,tl;
  int GotoCol = 0;
  int GotoColWid;
  int SNSwitch = False;
  int ForceRestore = False;
  int NoVcsInit = False;

  str tstr [1024];
	str tstr2;
	str session_name[128] = "";
	str wdir [512] = "";


	set_global_int('MENU_LEVEL', global_int('MENU_LEVEL') + 1 );
  Set_Global_Int( "InParmLoad", Window_Id );
  Set_Global_Int( "ParmLoad_Mode", ParmLoad_Mode );

	if( !parmload_mode )
	{
#IFNDEF Windows
		make_message('Welcome to Multi-Edit V' + Version + '.  Press ' + global_str('!HM_KEY1') + ' for help.');
#ELSE
		make_message('Welcome to Multi-Edit V' + Version + '.  Press <F1> for help.');
#ENDIF
		refresh = false;
		working;
		RM('.STARTUP^STARTUP');
	}

	refresh = false;
	working;

  if ( !ParmLoad_Mode ) {
    /* Check and see if MECONFIG is read_only.  If so then prompt the user, to
       see if he/she wants them unlocked */
    Tw = Window_Id;
    TStr = TranslateCmdLine( '<USER_PATH>MECONFIG', '' );

    /* This provides support for a default DB file extension to be configured.
       It is overridden if the calling macro specifies an extension */
    if (  (Global_Str('@DB_EXTENSION') == '')  ) {
			Tstr = Tstr + '.DB';
    }
    else {
			Tstr = Tstr + '.' + Global_Str('@DB_EXTENSION');
		}
    if ( Switch_File( TStr ) ) {
      if ( Read_Only ) {
        call Init_Mouse;
        Delete_Window;
        ConfigLocked( );
			}
		}
    Switch_Win_Id( Tw );
  }

	Error_Level = 0;
//  Load_Count = ParmLoad_Mode;

	Parm_Number = 1;
	refresh = false;
	while(  Parm_Number <= PARAM_COUNT  ) {
		TStr = PARAM_STR(Parm_Number);
		TStr = Caps(Remove_Space(TStr));
		if(  Xpos(Copy(Tstr,1,1),'/-',1)  ) {
			Tstr = Copy(Tstr,2,80);

      if ( Copy( TStr, 1, 3 ) == "WK=" ) {
        WDir = Copy( TStr, 4, 128 );
			}
      else if ( TStr == "SM" ) {
        Popup_Sm = TRUE;
			}
      else if ( Copy( TStr, 1, 2 ) == "SR" ) {

        int TId = Window_Id;
        int Tr = Refresh;

        Refresh = False;
        if ( LocateDbPage("MECONFIG", "SESSMGR.CFG", False ) ) {
          Down;
          Session_Name = Get_Line( );
          Restore_Enable = TRUE;
          ForceRestore = TRUE;
				}
        Switch_Win_Id( TId );
        Refresh = Tr;
			}
			else if ((Copy( TStr, 1, 2) == "SN" ) &&
					(Global_Int('@RESTORE') == 3)) // only if encoded status files are active
			{
						// switch to named session
				restore_enable = True;
        Session_Name = Remove_Space( Copy( Param_Str( Parm_Number ), 4, 256 ) );
        SNSwitch = True;
        ForceRestore = TRUE;
			}
			else if ( Copy( TStr, 1, 1) == "@" ) {
						// Load files from a file list
        Refresh = False;
        if ( !ForceRestore ) {
          Restore_Enable = FALSE;
        }
        Set_Global_Int( "Load_Count", Load_Count );

        int TId = Window_Id;

				create_window;
				window_attr = 0x81;
          // Re-get the filename so that caps is not performed
        tstr = remove_space (param_str (parm_number));
        tstr = copy (tstr, 3, 260);
				load_file ( tstr );

				int tag_win = window_id;

				make_message("");
				if(error_level)
				{
					call init_mouse;
					rm("messagebox /B=2/T=Error/M=List file " + tstr + " not found.");
				}
				else
				{
					switch_win_id( tid );
          Rm( "LdFiles /NRL=1/TAG=" + Str( Tag_Win ) + "/DE=1/CW=2/LC=" +
              Str( Load_Count ) );
          if ( Load_Count == 1 ) {
            /* Save the first file loaded so that if the user specifies a line
              number to go to, we can do it. */

            if ( Goto_L_Num = 0 ) {
              Goto_L_Id = Window_Id;
            }
					}
          Load_Count = Return_Int;
          TId = Window_Id;
				}
        Refresh = False;
        if ( Switch_Win_Id( Tag_Win ) ) {
          Delete_Window;
        }
        Switch_Win_Id( TId );
			}
      else if ( TStr == "NR" ) {
        if ( !ParmLoad_Mode ) {
          Restore_Enable = False;
          No_Restore = TRUE;
				}
      }
      else if ( TStr == "NS" ) {    // no restore(windows), no save status
        if ( !ParmLoad_Mode ) {
          Restore_Enable = False;
          No_Restore = TRUE;
          Set_Global_Int( "@Restore", 0 );
				}
      }
      else if ( TStr == 'R' ) {
        call Init_Mouse;
				++Parm_Number;
        if ( !ForceRestore ) {
          Restore_Enable = FALSE;
        }
				Refresh = True;
        if ( Param_Str( Parm_Number ) != '' ) {
          Rm( Param_Str( Parm_Number ) );
				}
      }
      else if ( Copy( TStr, 1, 1 ) == 'R' ) {
        call Init_Mouse;
        if ( !ForceRestore ) {
          Restore_Enable = FALSE;
        }
        Refresh = TRUE;
        TStr = Copy( TStr, 2, 40 );
        if ( TStr != "" ) {
          Rm( TStr );
				}
      }
      else if ( Str_Char( TStr, 1 ) == 'C' ) {
        // This is the go to column number parameter
        TStr = Remove_Space( Copy( TStr, 2, 10 ) );
        if ( Val( Tl, TStr ) == 0 ) {
          if ( !( ( Tl < 0 ) || ( Tl > Max_Line_Length ) ) ) {
            Goto_Col( tl );
            if ( GotoCol == 0 ) {
              GotoCol = Tl;
              GotoColWid = Window_Id;
            }
          }
				}
      }
      else if(  (Str_Char(TStr,1) == 'L')  ) {
        // This is the go to line number parameter
				tstr = remove_space( copy(tstr,2,10));
        if(  (Val(tl,TStr) == 0)  ) {
          if(  !((tl < 0) || (tl > 2000000000))  ) {
            Goto_Line( tl );
						rm("CenterLn");
						redraw;
            if(goto_l_num == 0)
            {
              goto_l_num = tl;
              goto_l_id = window_id;
            }
          }
				}
			}
      else if ( TStr == "NV" ) {        // Bypass VCS Init
        NoVcsInit = True;
      }
		// ----------------------------------------------------------------------
		// mods to handle loading unix,msdos  and binary file type overrides

		// to load a file in unix mode (to override or it is really is):
		// 	C:\> me /!unix.fil

		// to load a file in binary mode
		// 	C:\> me /&binary.fil

		// to load a file in msdos text mode
		// 	C:\> me /*msdostxt.fil

		// or load multiple files
		// 	C:\> me normal.fil /!unix.fil /&binary.fil /*msdostxt.fil

		// 			Yuuuck!

			else if ( Xpos(Copy(Tstr,1,1),'!&*',1) )
			{
				refresh = false;
        if ( !ForceRestore ) {
          Restore_Enable = FALSE;
        }
        Set_Global_Int( "Load_Count", Load_Count );

				// Load file as unix, msdos, or binary format file
        Load_Count = Ld_Override_File( TStr, Load_Count );
        if ( Load_Count == 1 ) {
					// Save the first file loaded so that if the user
					// specifies a line number to go to, we can do it.
            if(goto_l_num = 0)
            {
              Goto_l_id = window_id;
            }
          if ( GotoCol == 0 ) {
            GotoColWid = Window_Id;
          }
				}
				refresh = false;
			}
		}
		else {
      if ( ( Load_Count < 20000 ) && ( Pos( Copy( TStr, 1, 1), "/-" ) == 0 ) &&
          ( Copy( TStr, 1, 1 ) != ";" ) ) {
        if ( Load_Count == 0 ) {
          Refresh = True;
				}
        if ( !ForceRestore ) {
          Restore_Enable = FALSE;
        }
        Set_Global_Int( "Load_Count", Load_Count );

        // Re-get the filename so that caps is not performed
        TStr = Remove_Space( Param_Str( Parm_Number ) );
				// Check if has a path or not

        if ( XPos( "\\", TStr, 1 ) ) {
          Return_Str = TStr;
        }
        else {
          Return_Str = WDir + TStr;
        }
				if ( Switch_File( FExpand( Return_Str ) ) ) {
					Rm( "Select_Window" );
          if ( Goto_L_Num = 0 ) {
            Goto_l_id = Window_Id;
	        }
				}
        else {
          Rm( "LdFiles /CW=2/NRL=1/DE=1/LC=" + Str( Load_Count ) );
          if ( Load_Count == 1 ) {
            /* Save the first file loaded so that if the user specifies a line
               number to go to, we can do it. */
            if ( Goto_L_Num = 0 ) {
              Goto_L_Id = Window_Id;
	          }
					}
          Load_Count = Return_Int;
				}
			}
		}
		++Parm_Number;
	}

  if ( !ParmLoad_Mode ) {
    // Load keystroke macros if present
    Rm( "Keymac_Load /NE=1" );
		Error_Level = 0;
	}

  if ( Goto_L_Num ) {
    // Go directly to specified line number
    if(  (Switch_Win_Id(Goto_L_Id))  ) {
			Goto_Line(Goto_L_Num);
      Rm( "CenterLn" );
      Redraw;
		}
	}
  if ( GotoCol ) {
    if ( Switch_Win_Id( GotoColWid ) ) {
      Goto_Col( GotoCol );
		}
	}

  int tid = window_id;
  int tr = refresh;

  if ( popup_sm && restore_enable ) {
  	refresh = false;
    restore_enable = False;
    no_restore = True;
    if (LocateDbPage("MECONFIG", "SESSMGR.CFG", false)) {
      down;
      session_name = get_line;
    }
    Switch_Win_Id( TId );
    Refresh = Tr;
    if ( !ParmLoad_Mode ) {
      TStr = "/NOSWITCH=1";
    }
    else {
      TStr = "";
    }
    Rm( "SessMgr /SN=" + Session_Name + TStr );
  }

  if ( !ParmLoad_Mode ) {
    if ( Global_Int( "@Restore" ) ) {
      if ( Restore_Enable ) {
        Rm( "EXIT^Restore /SN=" + Session_Name );
				Error_Level = 0;
			}
      else if ( !No_Restore ) {
        Rm( "EXIT^Restore /M=1" );
				Error_Level = 0;
			}
		}

#ifdef Windows
    if (( MEW_ShowCmd != 0) && (MEW_ShowCmd != -1) ) {
			if( (Restore_Flags & _REST_SCREEN_POS) && ((!Global_Int("@RESTORE")) || (!restore_enable)) )
			{
  			tid = window_id;
  			tr = refresh;
  			refresh = false;
				tstr = "";
    		if (LocateDbPage("MECONFIG", "POSITION.CFG", false)) {
      		down;
					tstr = get_line;
    		}
    		switch_win_id(tid);
    		refresh = tr;
				if(tstr != "")
				{
					if((mew_showcmd == SW_SHOW) || (mew_showcmd == SW_SHOWNORMAL))
						mew_showcmd = -1;
					RestoreScreenPos( tstr, mew_showcmd );
					MEW_SHowCmd = -1;
				}
			}
			if(MEW_ShowCmd != -1)
				ShowWindow( frame_handle,MEW_ShowCmd );
			MEW_ShowCmd = -1;
		}
    else {
			ShowWindow( frame_handle, SW_Show );
			MEW_ShowCmd = -1;
		}

		RedrawWindow (frame_handle, 0, 0, RDW_INVALIDATE | RDW_UPDATENOW | RDW_ALLCHILDREN | RDW_FRAME);

#endif

    if ( NoVcsInit == False ) {
      Rm( "VCSCHK^VcsStartup" );    // Initialize the vcs support
    }
		Rm( "METAGS^Tag_Init" );
		HlpSetGlobals( );							      // Initialize the help files system

    /* This is for the "post restore" startup macro which can be used to do
       stuff that you don't want restore to undo like setting globals */
    if ( Length( Global_Str( "@Startup_Mac_2" ) ) ) {
      Rm( Global_Str( "@Startup_Mac_2" ) );
			Error_Level = 0;
		}
	}
  else if ( SNSwitch && Restore_Enable ) {
    Rm( "SessMgr /SESSION=" + Session_Name );
  }
  goto Exit;

Init_Mouse:
  if ( !Parmload_Mode ) {

#ifndef windows
    if ( !Mouse_Initialized ) {
      Rm( "Init_Mouse" );
    }
    Set_Global_Int( "@No_Mouse_Set", 0 );
#endif

    Mouse_Initialized = TRUE;
	}
	ret;

Exit:
#ifndef Windows
  Set_Virtual_Display;
#endif

  Refresh = TRUE;

  if ( !ParmLoad_Mode ) {
    if ( Load_Count > 0 ) {
      Switch_Window( 1 );
      Rm( "FindWin" );
		}
	}
exit2:

  if ( !ParmLoad_Mode ) {
    Rm( "SetWindowNames" );
		tstr = global_str('!AUTOSAVEPARMS');
		if(  (parse_int('/T1=', tstr ) != 0) | (parse_int('/T2=', tstr ) != 0)  ) {
			RM('SetAutoSave ' + tstr);
		}

		// load global templates
	  if ( g_Tmp_Global && File_Exists( User_Path + "GLOBAL" + Tmp_File_Ext ) ) {
			Tmp_Init_All( "GLOBAL", 0 );
			error_level = 0;
	  }
	}


	set_global_int('MENU_LEVEL', 0);
	#IFNDEF windows
	update_virtual_display;
	reset_virtual_display;
	call init_mouse;
	#ENDIF
  Set_Global_Int( "InParmLoad", 0 );
  Set_Global_Int( "ParmLoad_Mode", 0 );

}  // ParmLoad