Macro_File LineDraw;

#include windows.sh
#include mew_dlgs.sh

#define WM_LDINIT 0x2000

prototype ld
{
  void LinedrawProc ( int &retval, int window, message, wparam, lparam, str parms );
}


global {
  int Ldstat        "~LDSTAT";
  int LineDraw_hDlg "~LineDraw_hdlg";
  int MovedLDPosX   "&LDPOSX";
  int MovedLDPosY   "&LDPOSY";
  int EditWindow    "~EditWindow";
}

void LINEDRAW TRANS {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: LINEDRAW

Description: This macro allows the user to draw the single and double line
characters using the arrow keys to create lines and boxes etc.

              (C) Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/

  if (LineDraw_hDlg != 0) {
// don't allow multiple occurances, switch to currently active notebook
    SendMessage(LineDraw_hdlg, WM_SYSCOMMAND, SC_CLOSE, 0);
		Return();
	}

/*
Here is a list of all of the linedrawing characters:

 */

  struct tRect rect;

 // int main_dlg = Create_Mew_DlgEx ("", WS_POPUP, 1, 1, frame_handle, DLG_NOSIZE | DLG_NOCENTER | DLG_NOPARDISABLE | DLG_MODELESS);
  int main_dlg = Create_Mew_Dlg ("LineDraw", "", frame_handle, DLG_NOSIZE | DLG_NOCENTER | DLG_NOPARDISABLE | DLG_MODELESS);
  int ldb = Create_MEW_Ctrl( "BUTTON", "Single",
                bs_autoradiobutton,
                1, 1, 60, 20,
                main_dlg,101,
                app_handle, 0
              );
  int ldb = Create_MEW_Ctrl( "BUTTON", "Double",
                bs_autoradiobutton,
                61, 1, 60, 20,
                main_dlg,102,
                app_handle, 0
              );
  int ldb = Create_MEW_Ctrl( "BUTTON", "Erase",
                bs_autoradiobutton,
                121, 1, 60, 20,
                main_dlg,103,
                app_handle, 0
              );
  SubClass_With_Macro( main_dlg, "LinedrawProc", "" );


  SendDlgItemMessage(main_dlg, 101, BM_SETCHECK, 1, 0);
  Auto_Size_Mew_Dlg (main_dlg, 100, 100);
  struct tpoint pt;
  if ( MovedLDPosX || MovedLDPosY )
	{
    pt.x = MovedLDPosX;
    pt.y = MovedLDPosY;
	}
	else
	{
    GetWindowRect (client_handle, &rect);
    pt.x = rect.right;
    pt.y = rect.top;

    GetWindowRect (main_dlg, &rect);
    pt.x -= (rect.right - rect.left) + 1;
    if ( SendMessage(client_handle, WM_MDIGETACTIVE, 0, 0) & 0xFFFF0000)
    {
      pt.x -= GetSystemMetrics(SM_CXVSCROLL) - 1;
    }
	}
  SetWindowPos ( main_dlg, 0, pt.x, pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
  ShowWindow( main_dlg, sw_shownormal );
  BringWindowToTop( main_dlg );
  PostMessage(main_dlg, WM_LDINIT, 0, 0);

  int blarg, k1, k2;
  str tst, tst1;
  if( Wcmd_Find( 0, global_int('~LD_WCMD_ID'), blarg, k1, k2, tst, tst1)){
    tst = '';
    if ( k2 )
    {
      tst = Make_Key_Name(k2) + '  OR  ';
    }
    tst += Make_Key_Name(k1) + '  to toggle mode.';
    make_message(tst);
  }
}

int LinedrawProc (int &retval, int window, message, wparam, lparam, str parms) {
  int rv = 0;
  switch ( message )
  {
    case WM_ACTIVATE :
    {
      if ( !wparam )
      {
        LineDraw_hDlg = window;
        if (SendDlgItemMessage(window, 101, BM_GETCHECK, 0, 0)) {
          LDSTAT = 1;
        } else if (SendDlgItemMessage(window, 102, BM_GETCHECK, 0, 0)) {
          LDSTAT = 2;
        } else if (SendDlgItemMessage(window, 103, BM_GETCHECK, 0, 0)) {
          LDSTAT = 3;
        }
      }
      else
      {
        EditWindow = (lparam & 0x0000FFFF);
      }
      break;
    }
    case WM_COMMAND :
    {
      switch ( wparam )
      {
        case  101 :
        case  102 :
        case  103 :
          if ( (lparam >> 16) == BN_CLICKED )
          {
            SetActiveWindow(editwindow);
          }
      }
      break;
    }
    case WM_LDINIT :
    {
      SetActiveWindow(editwindow);
      break;
    }
    case WM_DESTROY :
    {
      struct tRect rect;
      GetWindowRect(window, &rect);
      MovedLDPosX = rect.left;
      MovedLDPosY = rect.top;
      LineDraw_hDlg = 0;
      LDSTAT = 0;
      make_message('');
      break;
    }
  }
  retval = 0;
  return (rv);
}

void LDToggle
{
  if ( ldstat )
  {
    int jx = ldstat;
    ++ldstat;
    if ( ldstat > 3 )
    {
      ldstat = 1;
    }
    SendDlgItemMessage(LineDraw_hDlg, 100 + jx, BM_SETCHECK, 0, 0);
    SendDlgItemMessage(LineDraw_hDlg, 100 + ldstat, BM_SETCHECK, 1, 0);
    RedrawWindow(LineDraw_hDlg,0, 0, RDW_INVALIDATE | RDW_UPDATENOW);
  }
}