/*

This file was created with the intention of simplifying the process of passing
 keycodes when necessary.  This would occur primarily in CMACWIN functions such as
 MACRO_TO_KEY.

 Due to the fact that this is an Include file and the keynames are all defined
 constants, there are some differences in keynames from the Dos version of ME.

 - All Names are preceded by K_
 - Names no longer are enclosed in Angle Brackets <>
 - Operators are spelled out and abreviated in some cases
 - In an effort to be more Windows-like, keys using the 'Grey' identifer have been
    renamed to use the 'Num' identifier. ie. <GreyEnter> is now K_NumEnter


*/


#DEFINE K_F1                   0x170
#DEFINE K_ShftF1               0x370
#DEFINE K_CtrlF1               0x570
#DEFINE K_AltF1                0x970
#DEFINE K_CtrlShftF1           0x770
#DEFINE K_AltShftF1            0xB70

#DEFINE K_F2                   0x171
#DEFINE K_ShftF2               0x371
#DEFINE K_CtrlF2               0x571
#DEFINE K_AltF2                0x971
#DEFINE K_CtrlShftF2           0x771
#DEFINE K_AltShftF2            0xB71

#DEFINE K_F3                   0x172
#DEFINE K_ShftF3               0x372
#DEFINE K_CtrlF3               0x572
#DEFINE K_AltF3                0x972
#DEFINE K_CtrlShftF3           0x772
#DEFINE K_AltShftF3            0xB72

#DEFINE K_F4                   0x173
#DEFINE K_ShftF4               0x373
#DEFINE K_CtrlF4               0x573
#DEFINE K_AltF4                0x973
#DEFINE K_CtrlShftF4           0x773
#DEFINE K_AltShftF4            0xB73

#DEFINE K_F5                   0x174
#DEFINE K_ShftF5               0x374
#DEFINE K_CtrlF5               0x574
#DEFINE K_AltF5                0x974
#DEFINE K_CtrlShftF5           0x774
#DEFINE K_AltShftF5            0xB74

#DEFINE K_F6                   0x175
#DEFINE K_ShftF6               0x375
#DEFINE K_CtrlF6               0x575
#DEFINE K_AltF6                0x975
#DEFINE K_CtrlShftF6           0x775
#DEFINE K_AltShftF6            0xB75

#DEFINE K_F7                   0x176
#DEFINE K_ShftF7               0x376
#DEFINE K_CtrlF7               0x576
#DEFINE K_AltF7                0x976
#DEFINE K_CtrlShftF7           0x776
#DEFINE K_AltShftF7            0xB76

#DEFINE K_F8                   0x177
#DEFINE K_ShftF8               0x377
#DEFINE K_CtrlF8               0x577
#DEFINE K_AltF8                0x977
#DEFINE K_CtrlShftF8           0x777
#DEFINE K_AltShftF8            0xB77

#DEFINE K_F9                   0x178
#DEFINE K_ShftF9               0x378
#DEFINE K_CtrlF9               0x578
#DEFINE K_AltF9                0x978
#DEFINE K_CtrlShftF9           0x778
#DEFINE K_AltShftF9            0xB78

#DEFINE K_F10                  0x179
#DEFINE K_ShftF10              0x379
#DEFINE K_CtrlF10              0x579
#DEFINE K_AltF10               0x979
#DEFINE K_CtrlShftF10          0x779
#DEFINE K_AltShftF10           0xB79

#DEFINE K_F11                  0x17A
#DEFINE K_ShftF11              0x37A
#DEFINE K_CtrlF11              0x57A
#DEFINE K_AltF11               0x97A
#DEFINE K_CtrlShftF11          0x77A
#DEFINE K_AltShftF11           0xB7A

#DEFINE K_F12                  0x17B
#DEFINE K_ShftF12              0x37B
#DEFINE K_CtrlF12              0x57B
#DEFINE K_AltF12               0x97B
#DEFINE K_CtrlShftF12          0x77B
#DEFINE K_AltShftF12           0xB7B

#DEFINE K_Enter                0x10D
#DEFINE K_CtrlEnter            0x50D
#DEFINE K_AltEnter             0x90D
#DEFINE K_CtrlShftEnter        0x70D
#DEFINE K_AltShftEnter         0xB0D

#DEFINE K_Tab                  0x109
#DEFINE K_ShftTab              0x309
#DEFINE K_CtrlTab              0x509
#DEFINE K_AltTab               0x909
#DEFINE K_CtrlShftTab          0x709
#DEFINE K_AltShftTab           0xB09

#DEFINE K_Esc                  0x11B
#DEFINE K_AltEsc               0x91B
#DEFINE K_CtrlShftEsc          0x71B
#DEFINE K_AltShftEsc           0xB1B

// 'BS' refers to the Backspace Key
#DEFINE K_BS                   0x108
#DEFINE K_CtrlBS               0x508
#DEFINE K_AltBS                0x908
#DEFINE K_CtrlShftBS           0x708
#DEFINE K_AltShftBS            0xB08

#DEFINE K_Up                   0x8126
#DEFINE K_ShftUp               0x8326
#DEFINE K_CtrlUp               0x8526
#DEFINE K_AltUp                0x8926
#DEFINE K_CtrlShftUp           0x8726
#DEFINE K_AltShftUp            0x8B26

#DEFINE K_Down                 0x8128
#DEFINE K_ShftDown             0x8328
#DEFINE K_CtrlDown             0x8528
#DEFINE K_AltDown              0x8928
#DEFINE K_CtrlShftDown         0x8728
#DEFINE K_AltShftDown          0x8B28

#DEFINE K_Left                 0x8125
#DEFINE K_ShftLeft             0x8325
#DEFINE K_CtrlLeft             0x8525
#DEFINE K_AltLeft              0x8925
#DEFINE K_CtrlShftLeft         0x8725
#DEFINE K_AltShftLeft          0x8B25

#DEFINE K_Right                0x8127
#DEFINE K_ShftRight            0x8327
#DEFINE K_CtrlRight            0x8527
#DEFINE K_AltRight             0x8927
#DEFINE K_CtrlShftRight        0x8727
#DEFINE K_AltShftRight         0x8B27

#DEFINE K_PgUp                 0x8121
#DEFINE K_ShftPgUp             0x8321
#DEFINE K_CtrlPgUp             0x8521
#DEFINE K_AltPgUp              0x8921
#DEFINE K_CtrlShftPgUp         0x8721
#DEFINE K_AltShftPgUp          0x8B21

#DEFINE K_PgDown               0x8122
#DEFINE K_ShftPgDown         8  0x8322
#DEFINE K_CtrlPgDown           0x8522
#DEFINE K_AltPgDown            0x8922
#DEFINE K_CtrlShftPgDown       0x8722
#DEFINE K_AltShftPgDown        0x8B22

#DEFINE K_Home                 0x8124
#DEFINE K_ShftHome             0x8324
#DEFINE K_CtrlHome             0x8524
#DEFINE K_AltHome              0x8924
#DEFINE K_CtrlShftHome         0x8724
#DEFINE K_AltShftHome          0x8B24

#DEFINE K_End                  0x8123
#DEFINE K_ShftEnd              0x8323
#DEFINE K_CtrlEnd              0x8523
#DEFINE K_AltEnd               0x8923
#DEFINE K_CtrlShftEnd          0x8723
#DEFINE K_AltShftEnd           0x8B23

#DEFINE K_Ins                  0x812D
#DEFINE K_ShftIns              0x832D
#DEFINE K_CtrlIns              0x852D
#DEFINE K_AltIns               0x892D
#DEFINE K_CtrlShftIns          0x872D
#DEFINE K_AltShftIns           0x8B2D

#DEFINE K_Del                  0x812E
#DEFINE K_ShftDel              0x832E
#DEFINE K_CtrlDel              0x852E
#DEFINE K_AltDel               0x892E
#DEFINE K_CtrlShftDel          0x872E
#DEFINE K_AltShftDel           0x8B2E

// 'Subtract' refers to the '-' character on the numeric keypad
#DEFINE K_Subtract             0x16D
#DEFINE K_CtrlSubtract         0x56D
#DEFINE K_AltSubtract          0x96D
#DEFINE K_CtrlShftSubtract     0x76D
#DEFINE K_AltShftSubtract      0xB6D

// 'Add' refers to the '+' character on the numeric keypad
#DEFINE K_Add                  0x16B
#DEFINE K_CtrlAdd              0x56B
#DEFINE K_AltAdd               0x96B
#DEFINE K_CtrlShftAdd          0x76B
#DEFINE K_AltShftAdd           0xB6B

// 'Multiply' refers to the '*' character on the numeric keypad
#DEFINE K_Multiply             0x16A
#DEFINE K_CtrlMultiply         0x56A
#DEFINE K_AltMultiply          0x96A
#DEFINE K_CtrlShftMultiply     0x76A
#DEFINE K_AltShftMultiply      0xB6A

// 'Divide' refers to the '/' character on the numeric keypad
#DEFINE K_Divide               0x816F
#DEFINE K_CtrlDivide           0x856F
#DEFINE K_AltDivide            0x896F
#DEFINE K_CtrlShftDivide       0x876F
#DEFINE K_AltShftDivide        0x8B6F

// 'Accept' refers to the Enter key on the numeric keypad
#DEFINE K_Accept               0x810D
#DEFINE K_CtrlAccept           0x850D
#DEFINE K_AltAccept            0x890D
#DEFINE K_CtrlShftAccept       0x870D
#DEFINE K_AltShftAccept        0x8B0D

#DEFINE K_ScrollLock           0x191

#DEFINE K_A                    0x141
#DEFINE K_ShftA                0x341
#DEFINE K_CtrlA                0x541
#DEFINE K_AltA                 0x941
#DEFINE K_CtrlShftA            0x741
#DEFINE K_AltShftA             0xB41

#DEFINE K_B                    0x142
#DEFINE K_ShftB                0x342
#DEFINE K_CtrlB                0x542
#DEFINE K_AltB                 0x942
#DEFINE K_CtrlShftB            0x742
#DEFINE K_AltShftB             0xB42

#DEFINE K_C                    0x143
#DEFINE K_ShftC                0x343
#DEFINE K_CtrlC                0x543
#DEFINE K_AltC                 0x943
#DEFINE K_CtrlShftC            0x743
#DEFINE K_AltShftC             0xB43

#DEFINE K_D                    0x144
#DEFINE K_ShftD                0x344
#DEFINE K_CtrlD                0x544
#DEFINE K_AltD                 0x944
#DEFINE K_CtrlShftD            0x744
#DEFINE K_AltShftD             0xB44

#DEFINE K_E                    0x145
#DEFINE K_ShftE                0x345
#DEFINE K_CtrlE                0x545
#DEFINE K_AltE                 0x945
#DEFINE K_CtrlShftE            0x745
#DEFINE K_AltShftE             0xB45

#DEFINE K_F                    0x146
#DEFINE K_ShftF                0x346
#DEFINE K_CtrlF                0x546
#DEFINE K_AltF                 0x946
#DEFINE K_CtrlShftF            0x746
#DEFINE K_AltShftF             0xB46

#DEFINE K_G                    0x147
#DEFINE K_ShftG                0x347
#DEFINE K_CtrlG                0x547
#DEFINE K_AltG                 0x947
#DEFINE K_CtrlShftG            0x747
#DEFINE K_AltShftG             0xB47

#DEFINE K_H                    0x148
#DEFINE K_ShftH                0x348
#DEFINE K_CtrlH                0x548
#DEFINE K_AltH                 0x948
#DEFINE K_CtrlShftH            0x748
#DEFINE K_AltShftH             0xB48

#DEFINE K_I                    0x149
#DEFINE K_ShftI                0x349
#DEFINE K_CtrlI                0x549
#DEFINE K_AltI                 0x949
#DEFINE K_CtrlShftI            0x749
#DEFINE K_AltShftI             0xB49

#DEFINE K_J                    0x14A
#DEFINE K_ShftJ                0x34A
#DEFINE K_CtrlJ                0x54A
#DEFINE K_AltJ                 0x94A
#DEFINE K_CtrlShftJ            0x74A
#DEFINE K_AltShftJ             0xB4A

#DEFINE K_K                    0x14B
#DEFINE K_ShftK                0x34B
#DEFINE K_CtrlK                0x54B
#DEFINE K_AltK                 0x94B
#DEFINE K_CtrlShftK            0x74B
#DEFINE K_AltShftK             0xB4B

#DEFINE K_L                    0x14C
#DEFINE K_ShftL                0x34C
#DEFINE K_CtrlL                0x54C
#DEFINE K_AltL                 0x94C
#DEFINE K_CtrlShftL            0x74C
#DEFINE K_AltShftL             0xB4C

#DEFINE K_M                    0x14D
#DEFINE K_ShftM                0x34D
#DEFINE K_CtrlM                0x54D
#DEFINE K_AltM                 0x94D
#DEFINE K_CtrlShftM            0x74D
#DEFINE K_AltShftM             0xB4D

#DEFINE K_N                    0x14E
#DEFINE K_ShftN                0x34E
#DEFINE K_CtrlN                0x54E
#DEFINE K_AltN                 0x94E
#DEFINE K_CtrlShftN            0x74E
#DEFINE K_AltShftN             0xB4E

#DEFINE K_O                    0x14F
#DEFINE K_ShftO                0x34F
#DEFINE K_CtrlO                0x54F
#DEFINE K_AltO                 0x94F
#DEFINE K_CtrlShftO            0x74F
#DEFINE K_AltShftO             0xB4F

#DEFINE K_P                    0x150
#DEFINE K_ShftP                0x350
#DEFINE K_CtrlP                0x550
#DEFINE K_AltP                 0x950
#DEFINE K_CtrlShftP            0x750
#DEFINE K_AltShftP             0xB50

#DEFINE K_Q                    0x151
#DEFINE K_ShftQ                0x351
#DEFINE K_CtrlQ                0x551
#DEFINE K_AltQ                 0x951
#DEFINE K_CtrlShftQ            0x751
#DEFINE K_AltShftQ             0xB51

#DEFINE K_R                    0x152
#DEFINE K_ShftR                0x352
#DEFINE K_CtrlR                0x552
#DEFINE K_AltR                 0x952
#DEFINE K_CtrlShftR            0x752
#DEFINE K_AltShftR             0xB52

#DEFINE K_S                    0x153
#DEFINE K_ShftS                0x353
#DEFINE K_CtrlS                0x553
#DEFINE K_AltS                 0x953
#DEFINE K_CtrlShftS            0x753
#DEFINE K_AltShftS             0xB53

#DEFINE K_T                    0x154
#DEFINE K_ShftT                0x354
#DEFINE K_CtrlT                0x554
#DEFINE K_AltT                 0x954
#DEFINE K_CtrlShftT            0x754
#DEFINE K_AltShftT             0xB54

#DEFINE K_U                    0x155
#DEFINE K_ShftU                0x355
#DEFINE K_CtrlU                0x555
#DEFINE K_AltU                 0x955
#DEFINE K_CtrlShftU            0x755
#DEFINE K_AltShftU             0xB55

#DEFINE K_V                    0x156
#DEFINE K_ShftV                0x356
#DEFINE K_CtrlV                0x556
#DEFINE K_AltV                 0x956
#DEFINE K_CtrlShftV            0x756
#DEFINE K_AltShftV             0xB56

#DEFINE K_W                    0x157
#DEFINE K_ShftW                0x357
#DEFINE K_CtrlW                0x557
#DEFINE K_AltW                 0x957
#DEFINE K_CtrlShftW            0x757
#DEFINE K_AltShftW             0xB57

#DEFINE K_X                    0x158
#DEFINE K_ShftX                0x358
#DEFINE K_CtrlX                0x558
#DEFINE K_AltX                 0x958
#DEFINE K_CtrlShftX            0x758
#DEFINE K_AltShftX             0xB58

#DEFINE K_Y                    0x159
#DEFINE K_ShftY                0x359
#DEFINE K_CtrlY                0x559
#DEFINE K_AltY                 0x959
#DEFINE K_CtrlShftY            0x759
#DEFINE K_AltShftY             0xB59

#DEFINE K_Z                    0x15A
#DEFINE K_ShftZ                0x35A
#DEFINE K_CtrlZ                0x55A
#DEFINE K_AltZ                 0x95A
#DEFINE K_CtrlShftZ            0x75A
#DEFINE K_AltShftZ             0xB5A

#DEFINE K_Space                0x120
#DEFINE K_CtrlSpace            0x520
#DEFINE K_AltSpace             0x920
#DEFINE K_CtrlShftSpace        0x720
#DEFINE K_AltShftSpace         0xB20

// 'OQuote' refers to the ' `' character ( this is usually the char which shares the
//  same key as the tilde character.
// 'Tilde' refers to the '~' character
#DEFINE K_OQuote               0x1C0
#DEFINE K_AltOQuote            0x9C0
#DEFINE K_Tilde                0x3C0
#DEFINE K_AltTilde             0xBC0

// 'Ex' refers to the '!' character
#DEFINE K_1                    0x131
#DEFINE K_Alt1                 0x931
#DEFINE K_Ex                   0x331
#DEFINE K_AltEx                0xB31

// 'At'  refers to the '@' character
#DEFINE K_2                    0x132
#DEFINE K_Ctrl2                0x532
#DEFINE K_Alt2                 0x932
#DEFINE K_At                   0x332
#DEFINE K_CtrlAt               0x732
#DEFINE K_AltAt                0xB32

// 'Pound' refers to the '#' character
#DEFINE K_3                    0x133
#DEFINE K_Alt3                 0x933
#DEFINE K_Pound                0x333
#DEFINE K_AltPound             0xB33

// 'Dollar' refers to the '$' character
#DEFINE K_4                    0x134
#DEFINE K_Alt4                 0x934
#DEFINE K_Dollar               0x334
#DEFINE K_AltDollar            0xB34

// 'Percent' refers to the '%' character
#DEFINE K_5                    0x135
#DEFINE K_Alt5                 0x935
#DEFINE K_Percent              0x335
#DEFINE K_AltPercent           0xB35

// 'Caret' refers to the '^' character
#DEFINE K_6                    0x136
#DEFINE K_Ctrl6                0x536
#DEFINE K_Alt6                 0x936
#DEFINE K_Caret                0x336
#DEFINE K_CtrlCaret            0x736
#DEFINE K_AltCaret             0xB36

// 'Amp' refers to the '&' character
#DEFINE K_7                    0x137
#DEFINE K_Alt7                 0x937
#DEFINE K_Amp                  0x337
#DEFINE K_AltAmp               0xB37

// 'Asterisk' refers to the '*' character
#DEFINE K_8                    0x138
#DEFINE K_Alt8                 0x938
#DEFINE K_Asterisk             0x338
#DEFINE K_AltAsterisk          0xB38

// 'OParen' refers to the '(' character
#DEFINE K_9                    0x139
#DEFINE K_Alt9                 0x939
#DEFINE K_OParen               0x339
#DEFINE K_AltOParen            0xB39

// 'CParen' refers to the ')' character
#DEFINE K_0                    0x130
#DEFINE K_Alt0                 0x930
#DEFINE K_CParen               0x330
#DEFINE K_AltCParen            0xB30

// 'Dash' refers to the '-' character
// 'UScore' refers to the '_' character
#DEFINE K_Dash                 0x1BD
#DEFINE K_CtrlDash             0x5BD
#DEFINE K_AltDash              0x9BD
#DEFINE K_UScore               0x3BD
#DEFINE K_CtrlUScore           0x7BD
#DEFINE K_AltUScore            0xBBD

// 'Equal' refers to the '=' character
// 'Plus' refers to the '+' c
#DEFINE K_Equal                0x1BB
#DEFINE K_AltEqual             0x9BB
#DEFINE K_Plus                 0x3BB
#DEFINE K_AltPlus              0xBBB

// 'BSlash' refers to the '\' character
// 'Pipe' refers to the '|' character
#DEFINE K_BSlash               0x1DC
#DEFINE K_CtrlBSlash           0x5DC
#DEFINE K_AltBSlash            0x9DC
#DEFINE K_Pipe                 0x3DC
#DEFINE K_CtrlPipe             0x7DC
#DEFINE K_AltPipe              0xBDC

// 'OSquare' refers to the '[' character
// 'OCurly' refers to the '{' character
#DEFINE K_OSquare              0x1DB
#DEFINE K_CtrlOSquare          0x5DB
#DEFINE K_AltOSquare           0x9DB
#DEFINE K_OCurly               0x3DB
#DEFINE K_CtrlOCurly           0x7DB
#DEFINE K_AltOCurly            0xBDB

// 'CSquare' refers to the ']' character
// 'CCurly' refers to the '}' character
#DEFINE K_CSquare              0x1DD
#DEFINE K_CtrlCSquare          0x5DD
#DEFINE K_AltCSquare           0x9DD
#DEFINE K_CCurly               0x3DD
#DEFINE K_CtrlCCurly           0x7DD
#DEFINE K_AltCCurly            0xBDD

// 'SemiColon' refers to the ';' character
// 'Colon' refers to the ':' character
#DEFINE K_Semicolon            0x1BA
#DEFINE K_AltSemicolon         0x9BA
#DEFINE K_Colon                0x3BA
#DEFINE K_AltColon             0xBBA

// 'SQuote' refers to the ''' character
// 'DQuote' refers to the '"' character
#DEFINE K_SQuote               0x1DE
#DEFINE K_AltSQuote            0x9DE
#DEFINE K_DQuote               0x3DE
#DEFINE K_AltDQuote            0xBDE

// 'Comma' refers to the ',' character
// 'OAngle' refers to the '<' character
#DEFINE K_Comma                0x1BC
#DEFINE K_AltComma             0x9BC
#DEFINE K_OAngle               0x3BC
#DEFINE K_AltOAngle            0xBBC

// 'Period' refers to the '.' character
// 'CAngle' refers to the '>' character
#DEFINE K_Period               0x1BE
#DEFINE K_AltPeriod            0x9BE
#DEFINE K_CAngle               0x3BE
#DEFINE K_AltCAngle            0xBBE

// 'Slash' refers to the '/' character  (NOT the rock star!!)
// 'Question' refers to the '?' character
#DEFINE K_Slash                0x1BF
#DEFINE K_AltSlash             0x9BF
#DEFINE K_Question             0x3BF
#DEFINE K_AltQuestion          0xBBF