macro_file HEX;

#include WINDOWS.SH
#include MEWLIB.SH
#include WINDOW.SH
#include METOOLS.SH
#include MEW.SH
#include HEX.SH

#ifdef _Debug_
	#include DBUG.SH
#endif


void HexSetEvent( int Set, int Wid2, int WinZoomed )
/******************************************************************************
															 Multi-Edit Macro
															 15-Nov-95  15:23

	Function: Set and clear the event macro for hex mode
	Entry   : int Set					- True to set event, False to clear event macro
						int Wid2				- The window id of the other hex window
						int WinZoomed		- True to specify window is maximized

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	str GStr = _HexEventSav + Str( Window_Id );

	if ( Set ) {
		// Save current event macro and mode
		Set_Global_Str( GStr, Event_Macro );
		Set_Global_Int( GStr, Event_Mode );

		SetCursorLock( Cur_Window, Wid2 );
		Window_Attr |= 0x100;

		// Set new event macro and mode
		Event_Macro = _HexEventMac + " /W1=" + Str( Window_Id ) +
				"/W2=" + Str( Wid2 ) + "/WZ=" + Str( WinZoomed );
		Event_Mode = EVENT_MODE_ENHANCED | EVENT_DELETE_WIN;
	}
	else {
		// Restore previous Event_Macro and Event_Mode
		Event_Macro = Global_Str( GStr );
		Event_Mode = Global_Int( GStr );
		Set_Global_Str( GStr, "" );
		Set_Global_Int( GStr, 0 );

		Window_Attr &= 0xFFFF ^ 0x120;
	}
}  // HexSetEvent

int _HexEvent( int Event ) {
/******************************************************************************
															 Multi-Edit Macro
															 15-Nov-95  15:52

	Function: Hex mode event to unsplit the windows upon window delete
	Entry   : int Event   - Event message
	Exit    : int					- True

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	int Wid1 	   	 = Parse_Int( "/W1=", MParm_Str );
	int Wid2 	 	   = Parse_Int( "/W2=", MParm_Str );
	int WinZoomed  = Parse_Int( "/WZ=", MParm_Str );
	int OrgWin 		 = Window_Id;
	int SavRefresh = Refresh;


	switch ( Event & 0xFFFF ) {
		case EVENT_DELETE_WIN :
			Refresh = False;
			if ( OrgWin == Wid1 ) {
				if ( Switch_Win_Id( Wid2 ) ) {
					Rm( "UnSplitWin /ID=" + Str( Wid1 ) );
					if ( WinZoomed ) {
						SendMessage( Client_Handle, WM_MDIMAXIMIZE, Window_Handle, 0 );
					}
				}
			}
			HexSetEvent( False, 0, 0 );
			Refresh = SavRefresh;
			break;
	}
	return ( True );

}  // _HexEvent

int HexEnabled( )
/******************************************************************************
															 Multi-Edit Macro
																01/03/96 14:14

	Function: Return TRUE when hex mode is enabled for the current window.
	Exit    : int
 							True 		- Hex mode enabled
							False		- Hex mode not enabled

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	return ( Copy( Event_Macro, 1, Length( _HexEventMac ) ) == _HexEventMac );

}  // HexEnabled

void Hex( )
/******************************************************************************
															 Multi-Edit Macro
															 15-Nov-95  16:37

	Function: Toggles hex mode for the current window.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	int SavRefresh = Refresh;
  int OrgWin;
	int Width;
	int WinZoomed;
	int WinId2;

	Refresh = False;
	if ( HexEnabled( ) ) {
		Delete_Window;
		if ( BriefMode ) {
			Rm( "BRIEF^BrDelSpecialWin" );
		}
	}
	else {
		if ( BriefMode ) {
			Rm( "BRIEF^BrMakeSpecialWin" );
		}
		OrgWin = Window_Id;
		Width = ( Win_X2 - Win_X1 ) / 4;
		WinZoomed = IsZoomed( Window_Handle );

		Rm( "SplitWin /WL=0/DIR=Left/LN#=" + str( Width * 3 ) );
		WinId2 = Window_Id;
		Window_Attr |= 0x20;

		HexSetEvent( True, OrgWin, WinZoomed );

		Switch_Win_Id( OrgWin );
		HexSetEvent( True, WinId2, WinZoomed );

		Switch_Win_Id( WinId2 );
	}
	Rm( "WINDOW^SetWindowNames" );
	Redraw;
	New_Screen;
	Refresh = SavRefresh;

}  // Hex