// $Header: /MEWIN/SRC/FONTS.S 31    3/19/96 12:15p Johnp $
Macro_File fonts;

#include windows.sh
#include dialog.sh
#include commdlg.sh
#include fonts.sh
#include mewhelp.sh
#include mewlib.sh
#include mew_dlgs.sh

#define FONT_HELPLINK 	"FONTS, CHANGING"
#define TRANS_HELPLINK 	"OEM TRANSLATION"

#define _FO_ID_HELP   1038

#DEFINE OEM_ID  1011
#DEFINE ANSI_ID 1012
#DEFINE DLG_ID  1013


structure ts
{
	ASCIIZ style[100];
}

Global
{
  str Font_Title          "&Font_Title";
  str Font_Help           "&Font_Help";
  int Use_Default_Button  "&Use_Font_Default";
}

int ChooseFontProc ( int dlg, int message, int wparam, int lparam, struct TChooseFont frec ) No_Break
{

	int result = 0;
  // msglog( 1, "Font", dlg, message, wparam, lparam );
	switch ( message )
	{
    case WM_INITDIALOG :
    {
      struct TRect  tr;
      struct TPoint pt;

      SetWindowText (dlg, font_title);

      // Add the Set to Default button if flag is set
      if ( Use_Default_Button )
      {
        GetWindowRect (GetDlgItem (dlg, _FO_ID_HELP), &tr);
        pt.x = tr.left;
        pt.y = tr.top;
        ScreenToClient (dlg, &pt);

        int wn = CreateWindow("BUTTON", "&Default",
          WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
          pt.x, pt.y - (tr.bottom - tr.top) - 4, tr.right - tr.left, tr.bottom - tr.top,
          dlg, 6979, app_handle, 0);

        int font = SendMessage (GetDlgItem (dlg, _FO_ID_HELP), WM_GETFONT, 0, 0);
        SendMessage (wn, WM_SETFONT, font, 0);
      }

      break;
    }
		case WM_ACTIVATE :
		{
			if ( wparam )
			{
				HelpLink_String = FONT_HELPLINK;
      } else {
				HelpLink_String = "";
			}
			break;
		}
    case WM_SYSCOMMAND :
    {
      if (wparam == SC_CLOSE  )
      {
        SendMessage (dlg, WM_COMMAND, ID_CANCEL, 0);
        break;
      }
    }
		case WM_COMMAND :
		{
			switch ( wparam )
			{
      case _FO_ID_HELP :
        MewHelp_Context();
        result = 1;
        break;
      case 6979 :
        frec.iPointSize = -1;
        SendMessage (dlg, WM_COMMAND, ID_CANCEL, 0);
			}
		}
	}
	return (result);
}

void GetDialogFontInfo (str &fontname, int &fontsize, int &fontweight, int &charset)
{
	int dlg_hfont = GetDialogFont ();

	int dc = GetDC (0);
	int old_font = SelectObject (dc, dlg_hfont);
	GetTextFace (dc, 255, fontname);
	struct TTextMetric tm;
	GetTextMetrics (dc, &tm);
	fontsize 		= -(tm.tmHeight - tm.tmInternalLeading);
	fontweight 	= tm.tmWeight;
	charset  		= tm.tmCharset;

	SelectObject (dc, old_font);
	ReleaseDc (0, dc);
}

int SelectFont( int parent, str &fontname, int &fontsize,
                int &fontweight, int &charset, int &pointsize,
                int fixed, int ansi, str title, str helplink ) trans2
{
  struct TLogFont     Cur_Font;
  struct TChooseFont  ChooseRec;

	struct ts t;
	if( !parent)
	{
		parent = frame_handle;
	}

	if ( fontsize == 0 )
	{
		fontsize = -12;
	}

	if ( fontname == "" )
	{
		fontname = "Courier New";
	}

	cur_font.lfHeight         = fontsize;
	cur_font.lfWidth          = 0;
	cur_font.lfEscapement     = 0;
  cur_font.lfWeight         = fontweight;
	cur_font.lfItalic         = 0;
	cur_font.lfUnderline      = 0;
	cur_font.lfStrikeOut      = 0;
	cur_font.lfOrientation    = 0;
  cur_font.lfCharSet        = charset;
  cur_font.lfCLipPrecision  = CLIP_DEFAULT_PRECIS;
  cur_font.lfQuality        = DEFAULT_QUALITY;
  cur_font.lfPitchAndFamily = FF_DONTCARE;  // FF_FIXED
	cur_font.lfFaceName       = fontname;

	ChooseRec.lStructSize     = 46;             //
	ChooseRec.hWndOwner       = parent;         // caller's window handle
	ChooseRec.hDC             = 0;              // printer DC/IC or nil
	ChooseRec.lpLogFont       = &cur_font;      // ptr. to a LOGFONT struct
	ChooseRec.iPointSize      = 0;              // 10 * size in points of selected font
  ChooseRec.Flags           = CF_SCREENFONTS
                              | CF_INITTOLOGFONTSTR
                              | CF_FORCEFONTEXIST
                              | CF_SHOWHELP;   // enum. type flags
  if ( ansi )
  {
    ChooseRec.Flags |= CF_ANSIONLY;
  }
  if ( fixed )
  {
    ChooseRec.Flags |= CF_FIXEDPITCHONLY;
  }
	ChooseRec.rgbColors       = 0x00ffffff;     // returned text color
	ChooseRec.lCustData       = 0;              // data passed to hook fn.
	ChooseRec.lpfnHook        = 0;              // ptr. to hook function
	ChooseRec.lpTemplateName  = 0;              // custom template name
	ChooseRec.hInstance       = app_handle;    /* instance handle of.EXE that
																								contains cust. dlg. template */
	ChooseRec.lpszStyle       = &t.style;     /* return the style field here
																							must be lf_FaceSize or bigger */
	ChooseRec.nFontType       = 0;            /* same value reported to the EnumFonts
																							call back with the extra fonttype_
																							bits added */
	ChooseRec.nSizeMin        = 0;            // minimum pt size allowed &
	ChooseRec.nSizeMax        = 0;            /* max pt size allowed if
																							cf_LimitSize is used      */

  font_title = title;
  font_help  = helplink;
  if( HookFontPromptWithMacro( &ChooseRec, "ChooseFontProc" ) )
	{
    fontname    = cur_font.lfFaceName;
    fontsize    = cur_font.lfHeight;
    fontweight  = cur_font.lfWeight;
    charset     = cur_font.lfCharset;
    pointsize   = chooserec.iPointSize;


		return(TRUE);
	}
  else
  {
    if ( ChooseRec.iPointSize < 0)
    {
      fontname    = "";
      fontsize    = 0;
      fontweight  = 0;
      charset     = 0;
      pointsize   = -1;
    }
  }
	return(FALSE);
}

void SetupFont (int parent = parse_int("/DLGHANDLE=", mparm_str),
                str id = parse_str ("/ID=", mparm_str),
                str pn = parse_str ("/PN=", mparm_str),
                int flag = parse_int ("/FG=", mparm_str))
{
  int tr = refresh;
  int dlgid;
  int fixed, ansi;
  str title;
  str fontstr;
	str fontname;
  int fontsize, fontweight, charset, ptsize;
	int def_flag = 0;


  fontstr = Global_Str (pn);
  var_parse_str("/NAME" + id + "=", fontstr, fontname);
  var_parse_int("/SIZE" + id + "=", fontstr, fontsize);
  var_parse_int("/WT"   + id + "=", fontstr, fontweight);
  var_parse_int("/SET"  + id + "=", fontstr, charset);
	if ( (fontname == "") || (fontsize == 0) )
	{
		def_flag = 1;
	}
  switch ( id )
  {
  case "OEM" :
    fixed = 1;
    ansi  = 0;
    title = "DOS/OEM Font Select";
		if ( def_flag)
		{
			Get_Window_Font (-1, fontname, fontsize, charset);
		}
    break;
  case "ANSI" :
    fixed = 1;
    ansi  = 1;
    title = "Windows/ANSI Font Select";
		if ( def_flag)
		{
			Get_Window_Font (0, fontname, fontsize, charset);
		}
    break;
  default:
    fixed = 0;
    ansi  = 0;
    title = "Dialog Font Select";
		if ( def_flag)
		{
			GetDialogFontInfo (fontname, fontsize, fontweight, charset);
		}

  }
  Use_Default_Button = 0;
  if( SelectFont( parent, fontname, fontsize, fontweight, charset, ptsize,
                  fixed, ansi,
                  title, FONT_HELPLINK ))
	{
    switch ( id )
    {
    case "OEM" :
      Set_Window_Font( -1, fontname, fontsize, charset);
      fontweight = FW_NORMAL;
      break;
    case "ANSI" :
      Set_Window_Font( 0, fontname, fontsize, charset);
      fontweight = FW_NORMAL;
      break;
    default:
      if ( !flag )
      {
        Set_Global_Int ("SETUP_CHANGED", Global_Int("SETUP_CHANGED") | $8000);
      }
    }
    RedrawWindow( frame_handle, 0, 0, RDW_INVALIDATE | RDW_ALLCHILDREN );
    refresh = true;
    new_screen;


    Var_Remove_Str ("/NAME" + id + "=", fontstr);
    Var_Remove_Str ("/SIZE" + id + "=", fontstr);
    Var_Remove_Str ("/WT"   + id + "=", fontstr);
    Var_Remove_Str ("/SET"  + id + "=", fontstr);


    fontstr +=    "/NAME" + id + "=" + fontname
                + "/SIZE" + id + "=" + str(fontsize)
                + "/WT"   + id + "=" + str(fontweight)
                + "/SET"  + id + "=" + str(charset);
    Set_Global_Str (pn, fontstr);

    fontstr = fontname + "  " + str (ptsize / 10) + "Pt";
    switch ( id )
    {
    case "OEM" :
      dlgid = OEM_ID;
      break;
    case "ANSI" :
      dlgid = ANSI_ID;
      break;
    case "DLG" :
      dlgid = DLG_ID;
      break;
    }
    SetWindowText (GetDlgItem (parent, dlgid), fontstr);

    if ( !flag )
    {
      Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
    }

    refresh = tr;
	}

}

int WarnOemChange ()
{
	int dlg;
	DlgCreate (dlg);


	DlgAddCtrl( dlg, DLG_ICON, "IC_STOP", 1, 1, 0, 0, 1000, 0, "" );

	DlgAddCtrl( dlg, DLG_STATIC, 	"You are changing the default OEM/ANSI translation." +
															" All open windows using the default font will be switched to the " +
															"translation mode that matches the font if you continue.",
							Dlg_PosOffset + 7, Dlg_PosOffset, 50, 4, 1001, 0, "");

	DlgAddCtrl( dlg, DLG_PUSHBUTTON, "OK",
							Dlg_PosOffset, Dlg_PosOffset + 3,
							DLG_StanBtnWidth, 0, 1002, DLGF_DefButton, "/R=1");
	DlgAddCtrl( dlg, DLG_PUSHBUTTON, "Cancel",
							Dlg_PosOffset + Dlg_StanBtnWidth + 2, Dlg_PosOffset,
							DLG_StanBtnWidth, 0, 1003, 0, "/R=0");

	DlgAddCtrl( dlg, DLG_PUSHBUTTON, "&Help",
							47, Dlg_PosOffset,
							DLG_StanBtnWidth, 0, 1004, 0, "/R=2");

  int rt = DlgExecute (dlg, 1002, "WARNING", TRANS_HELPLINK, "", 0);
	DlgKill (dlg);

	return( rt);
}

void SetupDefFonts( int parent = parse_int("/DLGHANDLE=", mparm_str) )
{

  int dlg;
  str fontstr = DefaultFont;
  str fontname;
  int fontsize, ptsize;
	int fontweight, charset;

  DlgCreate (dlg);

  int dc = GetDC (0);
  int logy = GetDeviceCaps (dc, LOGPIXELSY);
  ReleaseDC (0, dc);


  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SETUP_102",
              1, 1, 0, 0,
              -1, 0, "" );


  DlgAddCtrl( dlg, DLG_Groupbox, "Default &Editing fonts",
              10, 1, 52, 3,
              -1, 0, "" );
  DlgAddCtrl (dlg, DLG_PushButton, "...",
              	11, Dlg_PosOffset + 1,
								0, DLG_Units | 10, 1001, 0,
              	"/M=SetupFont /ID=OEM/PN=&DefaultFont");

  DlgAddCtrl (dlg, DLG_PushButton, "...",
              	DLG_PosOffset, DLG_PosOffset + 1,
								0, DLG_Units | 10, 1002, 0,
              	"/M=SetupFont /ID=ANSI/PN=&DefaultFont");

	DlgAddCtrl( dlg, DLG_RadioButton, "&Oem",
								18, 2, 0, 0, 1020, 0, "");
  DlgSetInt( dlg, 1020, Global_Int ("OEM_Mode") != 0);

	DlgAddCtrl( dlg, DLG_RadioButton, "&Ansi",
								DLG_PosOffset, DLG_PosOffset + 1,
								0, 0, 1021, 0, "");
  DlgSetInt( dlg, 1021, Global_Int ("OEM_Mode") == 0);

  var_parse_str("/NAMEOEM=", fontstr, fontname);
  var_parse_int("/SIZEOEM=", fontstr, fontsize);
	if ( (fontname == "") || (fontsize == 0))
	{
		Get_Window_Font (-1, fontname, fontsize, charset);
	}
  ptsize = -(fontsize * 72) / logy;
  DlgAddCtrl( dlg, DLG_Static, fontname + "  " + str (ptsize) + "Pt",
              	28, DLG_Units | 14,
								32, 0, OEM_ID, 0, "");

  var_parse_str("/NAMEANSI=", fontstr, fontname);
  var_parse_int("/SIZEANSI=", fontstr, fontsize);
	if ( (fontname == "") || (fontsize == 0))
	{
		Get_Window_Font (0, fontname, fontsize, charset);
	}
  ptsize = -(fontsize * 72) / logy;
  DlgAddCtrl( dlg, DLG_Static, fontname + "  " + str (ptsize) + "Pt",
              	DLG_Posoffset, Dlg_PosOffset + 1,
								32, 0, ANSI_ID, 0, "");

  DlgAddCtrl( dlg, DLG_Groupbox, "&Dialog font",
              10, 5, 52, 2,
              -1, 0, "" );
  DlgAddCtrl (dlg, DLG_PushButton, "...",
              	11, DLG_Posoffset + 1,
								0, DLG_Units | 10, 1003, 0,
              	"/M=SetupFont /ID=DLG/PN=&DefaultFont");
  var_parse_str("/NAMEDLG=", fontstr, fontname);
  var_parse_int("/SIZEDLG=", fontstr, fontsize);
	if ( (fontname == "") || (fontsize == 0))
	{
		GetDialogFontInfo (fontname, fontsize, fontweight, charset);
	}
  ptsize = -(fontsize * 72) / logy;
  DlgAddCtrl( dlg, DLG_Static, fontname + "  " + str (ptsize) + "Pt",
              	DLG_Posoffset + 4 + 3, Dlg_PosOffset,
								32, 0, DLG_ID, 0, "");

  DlgAddCtrl (dlg, DLG_PushButton, "OK",
              	1, DLG_PosOffset + 2,
								DLG_StanBtnWidth, 0, 1004, DLGF_DefButton,
              	"/R=1");

  DlgAddCtrl (dlg, DLG_PushButton, "Cancel",
              	DLG_Posoffset + DLG_StanBtnWidth + 2, DLG_PosOffset,
								DLG_StanBtnWidth, 0, 1005, 0,
              	"/R=0");

  DlgAddCtrl (dlg, DLG_PushButton, "&Help",
              	52, DLG_PosOffset,
								DLG_StanBtnWidth, 0, 1006, 0,
              	"/R=2");
  return_int = DlgExecute (dlg, 1020, "Default Fonts", FONT_HELPLINK, "", 0);

	if ( return_int)
	{
		int oe = DlgGetInt (dlg, 1020);
		if ( Global_Int ("Oem_Mode") != oe)
		{
			if (WarnOEMChange ())	                     // Let em know
			{
				int jx;
				int twin	= cur_window;
				int tr 		= refresh;
				str fontname;
				int fontsize, fontoe;

				refresh = false;
				for ( jx = 1; jx <= window_count; jx++ )  // Go through all windows
				{
					switch_window (jx);
					if ( window_attr & $0200)	             // Using default
					{
      			Get_Window_Font (-oe, fontname, fontsize, fontoe);
      			Set_Window_Font (cur_window, fontname, fontsize, fontoe);
						Set_Oem_Ansi (cur_window, oe);
					}
				}
				switch_window (twin);
				refresh = tr;
    		Set_Global_Int ("OEM_Mode", oe);
			}
		}
    RedrawWindow (client_handle, 0, 0, RDW_INVALIDATE | RDW_ALLCHILDREN);
    Set_Global_Int('Setup_Changed',Global_Int('Setup_Changed') | $01);
	}
	DlgKill (dlg);
}

void SetupExtFont (  int parent = parse_int("/DLGHANDLE=", mparm_str),
                      str id = parse_str ("/ID=", mparm_str),
                      str gs = parse_str ("/GSTR=", mparm_str))

{

  int dlgid;
  str title;
  str fontstr;
	str fontname;
  int fontsize, fontweight, charset, ptsize;

  dlgid = 20001;  // Has to be same as value in Mewhdrs.DB
  title = "Extension Font Select";
  fontstr = Global_Str (gs);
  var_parse_str("/NAME=", fontstr, fontname);
  var_parse_int("/SIZE=", fontstr, fontsize);
  var_parse_int("/WT=",   fontstr, fontweight);
  var_parse_int("/SET=",  fontstr, charset);

  Use_Default_Button = 1;
  if( SelectFont( parent, fontname, fontsize, fontweight, charset, ptsize,
                    1, 0,
                    title, FONT_HELPLINK ))
	{
      fontweight = FW_NORMAL;
      Set_Global_Str (gs, "/NAME="  + fontname
                        + "/SIZE=" + str(fontsize)
                        + "/WT="   + str(fontweight)
                        + "/SET="  + str(charset));
			EnableWindow (GetDlgItem (parent, 20002), TRUE);
			if ( charset == ANSI_CHARSET)
			{
				SendDlgItemMessage (parent, 20002, BM_SETCHECK, 0, 0);
			}
			else
			{
				SendDlgItemMessage (parent, 20002, BM_SETCHECK, 1, 0);
			}
      fontstr = fontname + "  " + str (ptsize / 10) + "Pt";
      SetWindowText (GetDlgItem (parent, dlgid), fontstr);
	}
  else
  {
    if ( ptsize < 0 )
    {
      Set_Global_Str (gs, "");
			SendDlgItemMessage (parent, 20002, BM_SETCHECK, 2, 0);
      SetWindowText  (GetDlgItem (parent, dlgid), "");
			EnableWindow (GetDlgItem (parent, 20002), False);
    }
  }
  Use_Default_Button = 0;
  return_int = 0;
}
