//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)3 ERRMACS.S, 06-Oct-95,15:22:28, LDH"

macro_file ERRMACS;

#include CMPERROR.SH
#include REGEXP.SH

// All macros with "RE Enabled" can eventually be removed because they have
// been replace with Regular Expression matching.  They are here for reference.


void ErrTurboPascal( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for all versions 4 - 6 of Turbo Pascal.
							Also handles Multi-Edit MACRO language.

// RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str Comp_Str[ 30 ] = g_LastComp;
	str File_Str[ 128 ];
	str MStr;
	str FndStr = "(Error[^s])|(Warning[^s])|(Not enough memory)|(Aborted)|" +
					"(Too big)";

	int ELine;
	int ECol;
	int Offset = 0;

	Return_Int = rc_NoErrors;

Again:
//	if ( Search_FWD('{ERROR[~S]}||{WARNING[~S]}||{NOT ENOUGH MEMORY}||{ABORTED}||{TOO BIG}',0) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		// This prevents finding any of the above keywords imbedded in a file name
		if ( C_Col == 1 ) {
      Up;
      File_Str = Get_Word( " (," );
      Right;
      MStr = Remove_Space( Get_Word( ") ," ) );
      Val( ELine, MStr );
      ECol = 1;
      Down;
      MStr = Get_Line( );
      Eol;
//			Return_Int = rc_DisplayError;
      goto Go_Find_Error;
		}
		Left;
		if ( Cur_Char != " " ) {
			Right;
			Right;
			goto Again;
		}
		Right;

		Goto_Col( 1 );
		if ( Comp_Str == "MULTI_EDIT" ) {
//			if ( (Search_Fwd('{Runtime error}||{too big}',0)) ) {
//				if (Search_Fwd('Runtime error found', 0) )  {
			if ( Find_Text( "(Runtime error)|(Too big)", 0, _RegExp ) ) {
				if ( Caps( Found_Str ) == "TOO BIG" ) {
					MStr = "Fatal compiler error probably due to running out of memory.";
					Return_Int = rc_DisplayError;
					goto Exit;
				}
				else {
					Goto_Col( 1 );
				}
			}
		}
		File_Str = Caps( Remove_Space( Get_Word( " (," ) ) );
		Right;
		MStr = Remove_Space( Get_Word( ",)" ) );
		if ( File_Str == "ERROR" ) {
			if ( Caps( Copy( MStr, 1, 7 ) ) == "OPENING" ) {
				Tof;
				MStr = "Error opening file.";
				Return_Int = rc_DisplayError;
				goto Exit;
			}
		}
		if ( Val( ELine, MStr ) != 0 ) {
			goto Error_Exit;
		}
		if ( Cur_Char == "," ) {
			Right;
			MStr = Remove_Space( Get_Word( ")" ) );
			if ( Val( ECol, MStr ) != 0 ) {
				goto Error_Exit;
			}
		}
		Word_Right;
		MStr = Get_Word( "" );
		if ( ( Copy( Comp_Str, 1, 12 ) == "TURBO PASCAL" ) ||
				( Caps( Comp_Str ) == "BORLAND PASCAL 7.0" ) ) {
			Down;
			First_Word;
			ECol = C_Col;
			Offset = 1;
			Down;
			while ( ( Cur_Char != "^" ) && !At_Eol ) {
				Right;
			}
			if ( Cur_Char == "^" ) {
				ECol = C_Col - ECol;
			}
			Up;
			Up;
		}

Go_Find_Error:
		Rm( "ErrFindError /F=" + File_Str + "/L=" + Str( ELine ) +
				"/C=" + Str( ECol ) + "/OF=" + Str( Offset ) );
	}

Error_Exit:
Exit:
	Return_Str = MStr;
}

void ErrBorland( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description: Error file handling for all versions of Turbo C, including
					   Turbo C++ 1.0 and Borland C++ 2.0.
 					   Turbo Assembler error file handling added 04-29-91.
 					   TLINK errors improved 11-05-91.
 					   Borland Make and PolyMake errors added 01-03-92

 // RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str TStr[ 80 ];
	str MStr;
	str FndStr = "(^\\*(\\*Fatal\\*)|(\\*Error\\*)|(Warning)\\*)|" +
					"(^(Fatal)|(Error)|(Warning)[ :])|" +
					"(Not enough memory)|(make:)|(\\*\\* Error)";

	int ELine;
	int Jx;

	Return_Int = rc_NoErrors;

Do_More:
//	if ( Search_Fwd( '{%@*{@*Fatal@*}||{@*Error@*}||{Warning}@*}||{%{fatal}||'+
//		'{error}||{warning}[ :]}||{Not enough memory}||{make:}||{@*@* error}', 0) )
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Jx = 1;
		ELine = 1;
		TStr = "";
		if ( ( Copy( Found_Str, Length( Found_Str ), 1 ) == ":") ||
				( Caps( Found_Str ) == "NOT ENOUGH MEMORY" ) ||
			  ( Caps( Found_Str ) == "** ERROR" ) )
		{
			MStr = Get_Line( );
			Eol;
			Rm( "ErrFindError /F=" + g_LastCompiledWindow );
			if ( rc_CantFind == Return_Int ) {
				MStr = Return_Str;
			}
			goto Done;
		}

		MStr = Get_Word( " " );
		Right;
		FName = Caps( Get_Word( " (" ) );

		if ( Copy( FName, Length( FName ), 1 ) == ":" ) {  // For Turbo Assembler:
			Eol;                                         		 // 'Error messages:   4'
			goto Do_More;                                		 // 'Warning message:  2'
		}

		FName = FExpand( FName );
		Right;

		if ( Val( ELine, Get_Word( ": )" ) ) == 0  ) {
			Right;
			Jx = C_Col;
//			if ( Search_Fwd("'", 1)  ) {
			if ( Find_Text( "'", 1, 0 )  ) {
				Right;
				TStr = Get_Word( "'" );
			}
			MStr += ": " + Copy( Get_Line( ), Jx, 132 );
		}
		else {
			Return_Int = rc_ProblemParsing;
			goto Exit;
		}
		Eol;

		Rm( "ErrFindError /F=" + FName + "/OF=1/C=0/L=" + Str( ELine ) );
		if ( Return_Int == rc_DisplayError ) {
			if ( Svl( TStr ) != 0 ) {
				Find_Text( TStr, 1, 0 );
			}
		}
		else {
			MStr = Return_Str;
		}
Done:
			Return_Str = MStr;
	}
	else {
		Return_Int = rc_NoMoreErrors;
		Tof;
	}

Exit:
}  // ErrBorland

void ErrBatCom( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for BATCOM batch file compiler

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ] = g_LastCompiledWindow;
	str TStr[ 80 ];
	str MStr;
	str ErrorStr = "*** ERROR ***";
	str FndStr = "^(Compile is not complete.)|" + Make_Literal_X( ErrorStr ) + ")";

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( '%{@*@*@* ERROR @*@*@*}||{Compile is not complete.}', 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Mstr = Get_line( );
		if ( Caps( Found_Str ) == ErrorStr ) {
			Mstr = Copy( MStr, 15, 132 );
		}
		else {
			Mark_Pos;
			Tof;
//			if ( Search_Fwd( "LINK", 0 ) ) {
			if ( Find_Text( "LINK", 0, 0 ) ) {
				Mstr += "  Check libraries and external object files.";
			}
			else {
				Mstr += "  Probably due to linker not found.";
			}
			Goto_Mark;
		}
		Eol;
		if ( MStr == "Can not find input file." ) {
			goto Done;
		}
		Up;
		TStr = Get_Line( );
		Down;
		/* This one does not specify line numbers in the listing, so we have to
		 search for the line.  This method has many drawbacks, not the least of
		 which is identical lines. */

		Rm( "ErrFindError /NL=1/F=" + FName );
		if ( Return_Int == rc_CantFind ) {
			Return_Str = FName;
			goto Exit;
		}
		Tof;
//		Search_Fwd( "%" + TStr + "$", 0 );
		Find_Text( "^" + Make_Literal_X( TStr ) + "$", 0, _RegExp );
		Return_Int = True;

Done:
		Return_Int = rc_DisplayError;
		Return_Str = MStr;
	}

Exit:
}  // ErrBatCom

void ErrPowerC( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Power C 1.0 compiler

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ] = g_LastCompiledWindow;
	str MStr;
	str FndStr = "Error in file:";

	int Eline;
	int ECol;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( "ERROR IN FILE:", 0 ) ) {
	if ( Find_Text( FndStr, 0, 0 ) ) {
		MStr = Get_Word( ":" );
		Right;
		FName = Get_Word( "" );
		Up;
		Up;
		Goto_Col( 1 );
		if ( Val( ELine, Remove_Space( Get_Word( "||" ) ) ) != 0  ) {
			Return_Int = rc_ProblemParsing;
		}
		else {
			Down;
			Goto_Col( 1 );
//			if ( Search_Fwd( "^", 1 ) ) {
			if ( Find_Text( "^", 1, 0) ) {
				ECol = C_Col - 6;
			}
			Down;
			Down;
			Rm( "ErrFindError /NL=1/F=" + FName + "/L=" + Str( ELine ) +
					"/C=" + Str( ECol ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
	}
}  // ErrPowerC

void ErrPowerC_20( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Power C 2.0 compiler

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ] = g_LastCompiledWindow;
	str MStr;
	str FndStr = "^Line";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( "%Line", 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Forward_Till( "0123456789" );
		if ( Val( ELine, Get_Word( ":" ) ) != 0 ) {
			Return_Int = rc_ProblemParsing;
		}
		else {
			Right;
			Right;
			MStr = Get_Word( "" );
			Rm( "ErrFindError /NL=1/F=" + FName + "/L=" + Str( ELine ) );
			if ( Return_Int == rc_CantFind) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
	}
}  // ErrPowerC_20

void ErrPowerC_X20( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 14-Jun-95  16:23

  Function: Error file handling for Power C 1.2.0 and 2.2.0 compiler

// RE Enabled
							(C) Copyright 1992-95 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^[ \t]+[0-9]+:";
	str FilStr = "^.+\\([0-9]+\\):";

	int ELine;
	int ECol = C_Col;
	int Offset;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( "%{[ \x9]+[0-9]+:}", 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		MStr = Remove_Space( Get_Line( ) );
		Eol;
		Mark_Pos;
//		if ( Search_Bwd( "%?+([0-9]+):",0 ) ) {
		if ( Find_Text( FilStr, 0, _RegExp | _Backward ) ) {
			FName = Get_Word( "(" );
			Right;
			if ( Val( ELine, Get_Word( ")" ) ) == 0 ) {
				Down;
				Goto_Col( 1 );
				Forward_Till_Not( "*" );
				Offset = C_Col;
//				if ( Search_Fwd( "^", 1 ) ) {
				if ( Find_Text( "^", 1, 0 ) ) {
					ECol = C_Col - Offset;
				}
				Goto_Mark;
				Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
						"/C=" + Str( ECol ) );
				if ( rc_DisplayError == Return_Int ) {
					Return_Str = MStr;
				}
				else {
					Return_Str = FName;
				}
			}
			else {
				Goto_Mark;
				Return_Int = rc_ProblemParsing;
			}
		}
		else {
			Pop_Mark;
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrPowerC_120

void Err2500AD( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO


Description:  Error file handling for 2500AD C Compiler and Assemblers

// RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^.* : Line";

	int ELine;
	int Asm = 0;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( "%?* : Line",0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		// Check to see if it is the assembler
		if ( " " == Cur_Char ) {
			++Asm;
			Forward_Till( "*" );
			Forward_Till_Not( "*" );
			Right;
		}
		FName = Get_Word( " " );
		Forward_Till( "0123456789" );
		if ( Val( ELine, Get_Word( " " ) ) == 0 ) {
			if ( Asm ) {
				Down;
				First_Word;
			}
			else {
				Right;
				Right;
				Right;
			}
			MStr = Get_Word( "" );
			Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
			if ( rc_DisplayError == Return_Int ) {
				Return_Str = MStr;
			}
			else {
				Return_Str = FName;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // Err2500AD_C

void ErrDataBus( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling DATABUS

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ] = g_LastCompiledWindow;
	str MStr;
	str FndStr = "\\*$";

	int ELine;
	int ECol;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( '@*$', 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		ECol = C_Col;
		Down;
		MStr = Remove_Space( Get_Line( ) );
		Up;
		Up;
		Goto_Col( 1 );
		if ( Val( ELine, Remove_Space( Get_Word( "." ) ) ) == 0 ) {
			ECol -= 34;
			Down;
			Eol;
			Rm( "ErrFindError /NL=1/F=" + FName + "/L=" + Str( ELine ) +
					"/C=" + Str( ECol ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrDataBus

void ErrSalfordFTN7( ) Trans2 {
/*******************************************************************************
													 MULTI-EDIT MACRO

Description:  Error file handling for Salford Fortran 77/386

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ] = g_LastCompiledWindow;
	str MStr;
	str FndStr = "^....\\)";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( "%????)", 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		if ( Val( ELine, Remove_Space( Get_Word( ")" ) ) ) == 0 ) {
			Down;
			MStr = Remove_Space( Get_Line( ) );
			Rm( "ErrFindError /NL=1/F=" + FName + "/L=" + Str( ELine ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrSalfordFTN7

void ErrGimpelLint( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error handling for PC-lint.

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ] = g_LastCompiledWindow;
	str MStr;
	str FndStr = " : (Warning)|(Info)";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( " : {WARNING}||{INFO}", 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Goto_Col( C_Col + 3 );
		MStr = Remove_Space( Copy( Get_Line( ), C_Col, 132 ) );
		Goto_Col( 1 );
		Forward_Till( "(" );
		Right;
		if ( Val( ELine, Remove_Space( Get_Word( ")" ) ) ) == 0 ) {
			Down;
			Rm( "ErrFindError /NL=1/F=" + FName + "/L=" + Str( ELine ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = RC_ProblemParsing;
		}
	}
}  // ErrGimpelLint

void ErrGimpelLint5( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error handling for PC-lint v5.x

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str TStr;
	str FndStr = "^(File .+Line)|((Warning)|(Error)|(Info) [0-9]+:)|" +
					"([^ ]+  [0-9]+  w|i|e)";
	str	XStr = "\x7F" + "Warning" + "\x7F" + "Error" + "\x7F" + "Info" + "\x7F";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd("%{File ?+{line}}||{Warning [0-9]+:}||{Error [0-9]+:}||{Info [0-9]+:}||" +
//					"{[~ ]+  [0-9]+  w||i||e}", 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		TStr = Get_Word( " " );
		if ( TStr == "File" ) {
			Forward_Till( " " );
			Right;
			FName = Get_Word( "," );
			Forward_Till( "0123456789" );
			if ( Val( ELine, Get_Word( "" ) ) == 0 ) {
//				if ( Search_Fwd('% +{Warning}||{Error}||{Info} [0-9]+:',0) )
				if ( Find_Text( "^ +(Warning)|(Error)|(Info) [0-9]+:", 0, _RegExp ) ) {
					MStr = Remove_Space( Get_Word( "" ) );
				}
				else {
					Return_Int = rc_ProblemParsing;
				}
			}
			else {
				Return_Int = rc_ProblemParsing;
			}
		}
		else if ( XPos( "\x7F" + TStr + "\x7F", XStr, 1 ) == 0 ) {
			Goto_Col( 1 );
			FName = Get_Word( " " );
//			Search_Fwd( " [0-9]+", 0 );
			Find_Text( " [0-9]+", 0, _RegExp );
			Right;
			if ( Val( ELine, Get_Word( " \t" ) ) == 0 ) {
				Forward_Till( " IWE" );
				MStr = Get_Word( "" );
			}
			else {
				Return_Int = rc_ProblemParsing;
			}
		}
		else { // if ( ( TStr == "Warning" )||( TStr == "Error")||(TStr == "Info") ) {
//			Search_Fwd(' [0-9]+',0);
			Find_Text( " [0-9]+", 0, _RegExp );
			Right;
			if ( Val( ELine, Get_Word( ":" ) ) == 0 ) {
				Right;
				Right;
				MStr = TStr + ": " + Get_Word( "" );
				Mark_Pos;
//				if ( Search_Bwd( "%{ |\t}+--- Wrap-up", 0 ) ) {
				if ( Find_Text( "^( |\t)+--- Wrap-up", 0, _RegExp | _Backward ) ) {
					Forward_Till( ":");
					Right;
					Right;
					FName = Get_Word( "" );
				}
				Goto_Mark;
			}
			else {
				Return_Int = rc_ProblemParsing;
			}
		}
		if ( Return_Int != rc_ProblemParsing ) {
			Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
	}
}  // ErrGimpelLint_5

void ErrTelxonTCal( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Telxon TCal Compiler Version 3.3

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "line";

	int ELine;
	int Jx;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd('line', 0) ) {
	if ( Find_Text( FndStr, 0, 0 ) ) {
		MStr = Get_Line( );
		Forward_Till( "1234567890" );
		if ( Val( ELine, Remove_Space( Get_Word( " " ) ) ) == 0 ) {
			if ( XPos( "\"", MStr, 1 ) == 1 ) {
				Jx = XPos( "\",", MStr, 1 );
				if ( Jx > 2 ) {
					FName = Copy( MStr, 2, Jx - 2 );
					Jx = XPos( ":", MStr, 1 );
					if ( Jx != 0 ) {
						++Jx;
						MStr = Str_Del( MStr, 1, Jx );
						Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
						if ( Return_Int == rc_CantFind ) {
							Return_Str = FName;
						}
						else {
							Return_Str = MStr;
						}
					}
				}
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrTelxonTCal

void ErrMicrosoft( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Microsoft languages and Clipper v5.0.
							Modifications made to parse Microsoft BASIC which includes column
							information.

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str CompStr[ 30 ] = g_LastComp;
	str Path[ 128 ];
	str TPath[ 128 ];


	int ELine;
	int ECol = 0;
	int Jx;
	int Errors = 0;

	Return_Int = rc_NoMoreErrors;
	if ( ( CompStr == "MICROSOFT C /FS" ) || ( CompStr == "MICROSOFT MASM LIST" ) ) {
//		if ( Search_Fwd('%@*@*@*@*@*',0) ) {
		if ( Find_Text( "^\\*\\*\\*\\*\\*", 0, _RegExp ) ) {
			Forward_Till( " " );
			Right;

Do_More:
			++Errors;
			FName = Get_Word( "(" );
//*****For Clipper, if an error exists in an INCLUDE file, we will first check
//*****the directory where the source files exist then each directory in the
//*****include environment variable.

			if ( Caps( Copy( CompStr, 1, 4 ) ) == "CLIP" ) {
				FName = Caps( FName );
				if ( XPos( ".CH", FName, 1 ) ) {
					Path = Get_Environment( "INCLUDE" );
					Path = Get_Path( g_LastCompiledWindow ) + ";" + Path;
					if ( Copy( Path, Svl( Path ), 1 ) != ";" ) {
						Path += ";";
					}
					while ( Path != "" ) {				// parse the path and try each file name
						TPath = Copy( Path, 1, XPos( ";", Path, 1 ) - 1 );
						if ( Copy( TPath, Svl( TPath ), 1 ) != "\\" ) {
							TPath += "\\";
						}
						if ( File_Exists( TPath + FName ) ) {
							 FName = TPath + FName;
							 Path = "";
						}
						else {
							 Path = Copy( Path, XPos( ";", Path, 1 ) + 1, 2048 );
						}
					}
				 	if ( !File_Exists( FName ) ) {
						Return_Int = rc_CantFind;
						Return_Str = FName;
						goto Exit;
					}
				}
			}
//**** End of Clipper "INCLUDE" error processing **************************
			Right;
			MStr = Remove_Space( Get_Word( ")" ) );
			if ( 0 != ( Jx = XPos( ",", MStr, 1 ) ) ) {
				if ( Val( ECol, Copy( MStr, Jx + 1, 4 ) ) ) {
					Return_Int = rc_ProblemParsing;
					goto Exit;
				}
				else {
					MStr = Copy( MStr, 1, Jx - 1 );
				}
			}
			if ( Val( ELine, MStr ) ) {
					Return_Int = rc_ProblemParsing;
					goto Exit;
			}
//			Search_Fwd('{:||) +}{fatal}||{error}||{warning}||{warn[i1-5]}',1)
			Find_Text( "([:)] +)(fatal)|(error)|(warning)|(warn[i1-5])", 1, _RegExp );
			Right;
			MStr = Remove_Space( Get_Word( "" ) );
			Eol;
		}
	}
	else {
//		if ( Search_Fwd('{:||) +}{fatal}||{error}||{warning}||{warn[i1-5]}||{@*err@*}',0) ) {
		if ( Find_Text( "([:)] +)(fatal)|(error)|(warning)|(warn[i1-5])|(\\*err\\*)", 0, _RegExp ) ) {
			Goto_Col( 1 );
			goto Do_More;
		}
	}

//  If 'Errors' is non-zero we have errors. The error message is in 'MStr' and
//  the line number is in 'ELine'

	if ( Errors ) {
		// We need to change all '/' to '\'. Microsoft C does this when there is
		//  an error in a header file: C:/C600/INCLUDE\sys\stat.h.  Also Microsoft
		//  C accepts include file names with '/' in them (Unix)
//		for( ; Jx = XPos( "/", FName, 1 ); FName= Str_Ins( "\\", Str_Del( FName, Jx, 1 ), Jx ) );
		while ( Jx = XPos( "/", FName, 1 ) ) {
			FName = Str_Ins( "\\", Str_Del( FName, Jx, 1 ), Jx );
		}
		Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
				"/C=" + Str( ECol ) );
		if ( Return_Int == rc_CantFind ) {
			Return_Str = FName;
			goto Exit;
		}
		else {
			Return_Str = MStr;
		}
	}
	else {
//		if ( 0 != Search_Fwd( "%Include file", 0 ) ) {
//			if ( 0 != Search_Fwd('not found',1) ) {
		if ( 0 != Find_Text( "^Include file", 0, _RegExp ) ) {
			if ( 0 != Find_Text( "not found", 1, 0 ) ) {
				++Errors;
				MStr = Get_Line( );
				Eol;
			}
		}
		if ( Errors ) {
			Return_Int = rc_DisplayError;
			Return_Str = MStr;
		}
		else {
			Return_Int = rc_NoMoreErrors;
		}
	}

Exit:
} // ERR_MICROSOFT

void ErrTeX( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 16-Jun-95  11:44

  Function: Error file handling for EmTeX. In practive, and TeX...

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str FName[ 128 ];
	str MStr;
	str TStr;
	str FndStr = "^!|(Overfull \\\\.*[0-9]--[0-9]+)";
	str LinStr = "^l\\.[1-9]";

	int ELine;
	int ECol;

	int BraceMatch;
	int Done;
	int CurLine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( '{%!}||{%Overfull \?*[0-9]--[0-9]+}', 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		MStr = Get_Line;
//		if ( Search_Fwd( "%l.[1-9]", 0 ) ) {
		if ( Find_Text( LinStr, 0, _RegExp ) ) {
			Goto_Col( 3 );
			TStr = Get_Word( " " );
			if ( Val( ELine, TStr ) == 0 ) {
				CurLine = C_Line;   //  save where we are in the error file
				Eol;                //  goto the end of this line
				Word_Left;          //  go back to beginning of token that caused error
				ECol = C_Col;		    //  this is the column that we want to goto
				Goto_Col( 3 );      //  but first we have to adjust ECol by the
				Word_Right;         //  length of the first "word" (l.nnn) of the line
				ECol -= C_Col + 1; 	//  that reports the error
			}
			else {
				Return_Int = rc_ProblemParsing;
				goto Exit;
			}
		}
		else {
			if ( Copy( MStr, 1, 10 ) == "Overfull \\" ) {
				Eol;
				Word_Left;
				TStr = Get_Word( " -" );
				Val( ELine, TStr );
				CurLine = C_Line;
				ECol = 1;
			}
			else {
				Return_Int = rc_CantFind;
				Return_Str = '"l.nnn" parsing .log file...';
				goto Exit;
			}
		}
		//  Now search (backward) for the appropriate filename
		Done = 0;
		BraceMatch = 1;
//		while ( !Done && ( Search_Bwd( "[()]", 0 ) ) ) {
		while ( !Done && ( Find_Text( "[()]", 0, _RegExp | _Backward ) ) ) {
			if ( Found_Str == ")" ) {
				++BraceMatch;
			}
			if ( Found_Str == "(" ) {
				--BraceMatch;
			}
			Done = !BraceMatch;
			if ( !Done ) {
				Left;
			}
		}
		Right;
		FName = Get_Word( " " );
		Goto_Line( CurLine );       /*  restore our place in the error file so we can
																find the next error  */
		if ( Found_Str == "(" ) {
			Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine) +
					"/C=" + Str( ECol ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = rc_CantFind;
			Return_Str = '''(filename'' parsing .log file...';
		}
	}

Exit:
}  // ErrTeX

macro ERR_MFCOBOL Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Microsoft/Micro Focus COBOL v4.0

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	str Error_Number, Temp_Str;
	int Line_Number;

	if(  ( 0 != Search_Fwd('( +[0-9]+)@*@*', 0) )  )
	{                                                     //   Look for '(   x)**'
		Goto_Col(2);                                        //   Goto second column
		Error_Number = Remove_Space(Get_Word('*'));         //   Get word till '*'
		Up;                                                 //   Go up one line
		First_Word;                                         //   Go to first word
		if(  ( 0 != Val(Line_Number, Get_Word(' ')) )  )
		{                                                   //   Get line number
			Line_Number = -1;                                 //   No line number
		}
		Down;                                               //   Go down 2 lines
		Down;
		Eol;
		if(  ( -1 != Line_Number )  )
		{                                                   //   If line number detected
			Error_Number = Error_Number + ':  ';              //      use a colon
		}
		else
		{                                                   //   Else
			Error_Number = Error_Number + '||  ';             //      use a vertical bar
		}                                                   //   Print error message
		RM('MEERROR^Beeps /C=1');
		Temp_Str = Error_Number + Remove_Space(Copy(Get_Line, 3, 132));
		rm('ErrFindError /NL=1/F=' + Global_Str('last_compiled_window') +
				"/L=" + str(line_number));
/*
		Switch_File(Global_Str('last_compiled_window'));
		if(  ( -1 != Line_Number )  )
		{
			Goto_Line(Line_Number);
		}
*/
		Return_Str = Temp_Str;
//		Return_Int = RC_DisplayError;
	}
	else
		Return_Int = RC_NoMoreErrors;
Exit:
} // ERR_MFCOBOL

macro ERR_MS_PASCAL Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Microsoft PASCAL

// RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	int EL;

	if ( Search_Fwd('@^',0) )
	{
		goto_col(7);
		word_right;
		if ( Val(EL,remove_space(get_word(' '))) != 0 )
			Return_Int = RC_ProblemParsing;
		else
		{
			Return_Str = get_word('');
			Return_Int = RC_DisplayError;
			Switch_File(Global_Str('last_compiled_window'));
			if (Window_Attr & 0x40)
				RM('WINDOW^ZOOM');
			Goto_Line(EL);
		}
	}
	else
		Return_Int = RC_NoMoreErrors;
} // ERR_MS_PASCAL

Macro ERR_C87_FB TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Clipper Summer 87 and FoxBase

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	str FName[80], M_Str;

	int ErrorWindow = Window_Id,
			LastLine,
			ErrorColumn,
			ErrorLine;

	if ( (Search_Fwd('%{error in }*line [0-9]+:',0)) )
	{
		Forward_Till('0123456789');
		if ( Val(ErrorLine,Remove_Space(Get_Word(':'))) > 0 )
			Return_Int = RC_ProblemParsing;
		else
		{
			LastLine = C_Line;
			Right;
			M_Str = '--' + Get_Word('');
			Down;
			Goto_Col(1);
			if ( Caps(Get_Word(' ')) != 'LINE' )
			{
				down;
				if ( (Search_Fwd('^',1)) )
					ErrorColumn = C_Col;
			}
			Goto_Line(LastLine);
			if ( !Search_Bwd('%COMPILING ',0) )
				Return_Int = RC_ProblemParsing;
			else
			{
				Forward_Till(' ');
				FName = FExpand(Remove_Space(Get_Word('')));
				Goto_Line(LastLine);
				eol;
				rm('ErrFindError /F=' + fname +
						"/L=" + str(ErrorLine) +
						"/C=" + str(ErrorColumn));
				if (return_int == RC_CantFind)
					goto EXIT;
/*
				if (!Switch_File(FName)) {
					Switch_Window(Window_Count);
					Create_Window;
					Error_Level = 0;
					Load_File(FName);

					if ( (Error_Level) )
					{
						Delete_Window;
						Switch_Win_Id(ErrorWindow);
						Return_Int = RC_CantFind;
						Return_Str = FName;
						Error_Level = 0;
						Goto Exit;
					}

					RM('SetWindowNames');
					RM('EXTSETUP');
				}
				Goto_Line(ErrorLine);
				Goto_Col(ErrorColumn);
*/
				Return_Str = M_Str;
//				Return_Int = RC_DisplayError;
			}
		}
	}
	else
		Return_Int = RC_NoMoreErrors;
Exit:
}

macro ERR_RealiaCobol TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Realia COBOL

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	int ErrorLine;

	if ( (Search_Fwd('%????? E||W',0)) )
	{
		if ( Cur_Char == ' ' )
			Word_Right;
		if ( Val(ErrorLine,Get_Word(' ')) != 0 )
			Return_Int = RC_ProblemParsing;
		else
		{
			Goto_Col(7);
			if ( (Cur_Char == 'E') )
				Return_Str = 'ERROR: ';
			else
				Return_Str = 'WARNING: ';
			Goto_Col(9);
			Switch_File(Global_Str('Last_Compiled_Window'));
			Goto_Line(ErrorLine);
			Return_Str = Return_Str + Remove_Space(Get_Word(''));
			Return_Int = RC_DisplayError;
		}
	}
	else if ( (C_Line == 1) )
		Return_Int = RC_NoErrors;
	else
		Return_Int = RC_NoMoreErrors;
} // ERR_RealiaCobol

macro Err_CrossCode_C Trans Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Cross Code C

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	str Fn[80],Es;
	int Ln, Cn;

	if ( Search_Fwd('%{LINKER:}||{?+:"?+"}', 0) ) {
		if ( Copy(Found_Str, 1, 7) != 'LINKER:' ) {
			Search_Fwd('"?+"', 1);
			Fn = Copy(Found_Str, 2, Length(Found_Str) - 2);
			Make_Message(fn);
			Search_Fwd('line [0-9]+', 1);
			Forward_Till('0123456789');
			if ( VAL(Ln, Get_Word(' :')) ) {
				Return_Int = RC_ProblemParsing;
				Goto Exit;
			}
			if ( ':'!=Cur_Char )
			{
				Forward_Till('0123456789');
				if ( VAL(Cn, Get_Word(':')) ) {
					Return_Int = RC_ProblemParsing;
					Goto Exit;
				}
			}
			Right; Right;
			Es = Get_Word('');
			rm('ErrFindError /F='+Fn+'/L='+str(Ln)+'/C='+str(Cn));
			if ( RC_DisplayError == Return_Int )
				Return_Str = Es;
			else
				Return_Str = Fn;
		}
		else
		{
			Return_Str = Get_Line;
			Return_Int = RC_DisplayError;
			Eol;
		}
	}
	else
		Return_Int = RC_NoMoreErrors;
Exit:
}

macro Err_Arch_8051_C Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Archimedes 8051 C

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	int El, ECol = 0;
	str M_Str, F_Str;
	str FndStr = "^(<q\">,<i><b1>(Error)|(Warning)\\[<i>\\]:)|" +
					"(Error in)|(Error\\[<i>\\])|(Errors:<b1>(<i>)|(none))|(Fatal!)";

//	if ( Search_Fwd('%{"?+",[0-9]+ +{Error}||{Warning}@[[0-9]+@]:}'+
//			'||{Error in}||{Error@[[0-9]+@]}||{Errors: +{[0-9]+}||{none}}||{Fatal!}', 0)) {
	FndStr = ReTranslate( FndStr, 1 );
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		if ( "Error" == Copy( Found_Str, 1, 5 ) ) {
			if ( "Error in" == Found_Str ) {	 // Assembler error
				Forward_Till( "01234567890" );
				if ( Val(El,Get_Word(':')) ) {
					Return_Int = RC_ProblemParsing;
					goto Exit;
				}
				Right;Right;
				M_Str = 'Error: '+Get_Word('');
				rm('ErrFindError /F='+Global_Str('Last_Compiled_Window')+'/L='+Str(El));
				Return_Str = M_Str;
			}
			else if ( "Errors" == Copy(Found_Str,1,6) ) {
				M_Str = Get_Word('')+', '; Down; Goto_Col(1);
				M_Str = M_Str+Get_Word('');
				rm('ErrFindError /F='+Global_Str('Last_Compiled_Window'));
				Return_Str = M_Str;
				Return_Int = RC_DENoBeep;
			}
			else if ( 'Error[' == Copy(Found_Str,1,6) ) {  // Linker error
				Forward_Till(':');
				Right;Right;
				M_Str = 'Linker: ' +Get_Word('(');
				if ( '(' == Cur_Char )
				{
					Right;Right;
					F_Str = Get_Word(' ');
				}
				else
					F_Str = Global_Str('Last_Compiled_Window');
				rm('ErrFindError /F='+F_Str);
				if ( Return_Int == RC_DisplayError )
					Return_Str = M_Str;
			}
		}
		else if ( "Fatal" == Copy(Found_Str,1,5) ) {
			M_Str = Get_Word('');
			rm('ErrFindError /F='+Global_Str('Last_Compiled_Window'));
			Return_Str = M_Str;
			Return_Int = RC_DisplayError;
		}
		else {
			Right;
			F_Str = Get_Word( "\"" );
			Forward_Till( "0123456789" );
			if ( Val( El, Get_Word( " " ) ) ) {
				Return_Int = RC_ProblemParsing;
				Goto Exit;
			}
			Forward_Till_Not(' ');
			M_Str = Get_Word('[');
			Forward_Till(':');
			M_Str = M_Str+Get_Word('');
			Goto_Col(1);
			Up;
			if ( Find_Text( "^", 1, 0 ) ) {
				ECol = C_Col;
				Up;
				First_Word;
				ECol = ECol - C_Col;
				Down;
				Down;
			}
			else
					Down;
			Eol;
			rm('ErrFindError /OF=1/F='+F_Str+'/C='+Str(ECol)+'/L='+Str(El));
			Return_Str = M_Str;
//			Return_Int = RC_DisplayError;
		}
	}
	else
	{
		Tof;
		Return_Int = RC_NoMoreErrors;
	}
Exit:
}

macro Err_AVMAC65 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Avocet AVMAC65.  Command line for AVMAC65
							should be "AVMAC65 <FILE> ERRONLY QUIET PR=<MEERR><NR>"

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	str FStr[128],MStr;
	int Ln,LastColon;

	if ( Search_Fwd('%-----> ',0) )
	{
		Forward_Till(' ');
		Right;
		FStr=Get_Word(' ');
		for ( Ln=0;Ln=XPos(':',FStr,1+Ln);LastColon=Ln-1 )
			;
		FStr=FExpand(Copy(FStr,1,LastColon));
		Search_Bwd(':',1);
		Right;
		if ( VAL(Ln,Get_Word(' ')) )
		{
			Return_Int=RC_ProblemParsing;
			Goto Exit;
		}
		Right;
		MStr=Get_Word(' ')+': ';
		Forward_Till_Not(' ');
		Forward_Till(' ');
		Right;
		MStr=MStr+Get_Word('');
		rm('ErrFindError /F='+FStr+'/L='+Str(Ln));
//		Return_Int=RC_DisplayError;
		Return_Str=MStr;
	}
	else
	{
		Return_Int = RC_NoMoreErrors;
		Tof;
	}
Exit:
}

macro ERR_ACUCOBOL Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for ACU COBOL.

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	str	Fn[128];
	int Ln;
	if ( Search_Fwd('%?*, line [0-9]+:',0) )
	{
		Fn=Get_Word(',');
		for(;Ln=XPos('/',Fn,1);Fn=Str_Ins('\',Str_Del(Fn,Ln,1),Ln))
			;
		Forward_Till('0123456789');
		if ( Val(Ln,Get_Word(':')) )
			Return_Int = RC_ProblemParsing;
		else
		{
			Str Es;
			Right;
			Es=Remove_Space(Get_Word(''));
			rm('ErrFindError /F='+FExpand(Fn)+'/L='+Str(Ln));
//			Return_Int=RC_DisplayError;
			Return_Str=Es;
		}
	}
	else
	{
		Return_Int = RC_NoMoreErrors;
		TOF;
	}
}

macro ERR_Metaware  Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Metaware High C and Metaware Professional
							Pascal.

// RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	if ( Search_Fwd('%[EW] +"?*",',0) )
	{
		str Es,Fn[128];
		int Ln,Cn;
		if ( 'W'==Caps(Copy(Found_Str,1,1)) )
			Es='Warning: ';
		else
			Es='Error: ';
		Forward_Till('"');
		Right;
		Fn=Get_Word('"');
		for(;Ln=XPos('/',Fn,1);Fn=Str_Ins('\',Str_Del(Fn,Ln,1),Ln))
			;
		Forward_Till('0123456789');
		if ( Val(Ln,Get_Word('/')) )
			Return_Int=RC_ProblemParsing;
		else if ( Val(Cn,Copy(Get_Word(':'),3,8)) )
			Return_Int=RC_ProblemParsing;
		else
		{
			Right;
			Str T_Str=Get_Word('');
			Tabs_To_Spaces(T_Str);
			Es=Es+Remove_Space(T_Str);
			rm('ErrFindError /F='+FExpand(Fn)+'/L='+Str(Ln)+'/C='+Str(Cn));
//			Return_Int=RC_DisplayError;
			Return_Str=Es;
		}
	}
	else
	{
		Return_Int=RC_NoMoreErrors;
		TOF;
	}
}

macro ErrAspect Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for PROCOMM's ASPECT script compiler.

// RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	int ln;
	str Es,Fn[128];

	if ( Search_Fwd('%{Error}||{Warning} ',0) )
	{
		Es=Get_Word(' ');
		if ( Search_Fwd('[0-9]+:',1) )
		{
			Val(ln,Get_Word(':'));
			Es=Es+Get_Word('');
			Mark_Pos;
			if ( Search_Bwd('%[~ ]+.ASP:',0) )
			{
				Fn=Get_Word(':');
				Goto_Mark;
				rm('ErrFindError /F='+FExpand(Fn)+'/L='+Str(Ln));
//				Return_Int=RC_DisplayError;
				Return_Str=Es;
			}
			else
			{
				Return_Int=RC_ProblemParsing;
				Pop_Mark;
			}
		}
		else
			Return_Int=RC_ProblemParsing;
	}
	else
	{
		Return_Int=RC_NoMoreErrors;
		TOF;
	}
}

macro Err_SVS_FORTRAN {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for SVS FORTRAN compiler.

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	if ( Search_Fwd(' +[0-9]+. @*@*@*@*@*@*@*@*@*@*@*@*',0) )
	{
		str Em,Fn[128];
		int El,i;
		Down; Down; Forward_Till('*'); Forward_Till_Not('*'); Right;
		Em=Get_Word(' ')+': ';
		if ( Search_Fwd('in line',1) )
		{
			Forward_Till('0123456789');
			if ( !Val(El,Get_Word(' ')) )
			{
				if ( Search_Fwd('file',1) )
				{
					Forward_Till(' '); Right;
					Fn=Get_Word(' ');
					if ( SVL(Fn)==(i=XPos('.',Fn,1)) )
						Fn=Copy(Fn,1,i);
					Down; Down; First_Word; Forward_Till('*'); Forward_Till_Not('*'); Right;
					Em+=Get_Word('');
					rm('ErrFindError /F='+Fn+'/L='+Str(El));
					Return_Str=Em;
//					Return_Int=RC_DisplayError;
				}
				else
					Return_Int=RC_ProblemParsing;
			}
			else
				Return_Int=RC_ProblemParsing;
		}
		else
			Return_Int=RC_ProblemParsing;
	}
	else
	{
		Return_Int=RC_NoMoreErrors;
		TOF;
	}
}


macro Err_MCC68000_C Trans Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Microtec Research MCC68K C Compiler

// RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/
	str Fn[80],Es;
	int Ln, Cn;

	if ( Search_Fwd('%{"?+"}', 0) ) {
		Fn = Copy(Found_Str, 2, Length(Found_Str) - 2);
		for(;Ln=XPos('/',Fn,1);Fn=Str_Ins('\',Str_Del(Fn,Ln,1),Ln))
				;
		Search_Fwd('line [0-9]+', 1);
		Forward_Till('0123456789');
		if ( VAL(Ln, Get_Word(' ;')) ) {
			Return_Int = RC_ProblemParsing;
			Goto Exit;
		}
		if ( ';'!=Cur_Char )
		{
			Forward_Till('0123456789');
			if ( VAL(Cn, Get_Word(';')) ) {
				Return_Int = RC_ProblemParsing;
				Goto Exit;
			}
		}
		Right; Right;
		Es = Get_Word('');
		rm('ErrFindError /F='+Fn+'/L='+str(Ln)+'/C='+str(Cn));
		if ( RC_DisplayError == Return_Int )
			Return_Str = Es;
		else
			Return_Str = Fn;
		}
	else
		Return_Int = RC_NoMoreErrors;
Exit:
}


void ErrAMD_HighC29K( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for Advanced Micro Devices HighC 29K C
							Compiler

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^. \".+\"";
	str LinStr = ",L[0-9]+";

	int ELine;
	int ECol = 0;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd('%? "?+"',0 ) ) {
	if ( Find_Text( FndStr,0, _RegExp ) ) {
		MStr = Caps( Cur_Char ) + ": ";
		FName = Copy( Found_Str, 4, Length( Found_Str ) - 4 );
//		Search_Fwd(',L[0-9]+',1);
		Find_Text( LinStr, 1, _RegExp );
		Right;
		Right;
		if ( Val( ELine, Get_Word( "/:" ) ) == 0 ) {
			if ( Cur_Char != ":" ) {
				Right;
				Right;
				if ( Val( ECol, Get_Word( ": " ) ) != 0 ) {
					Return_Int = rc_ProblemParsing;
				}
			}
			if ( Return_Int != rc_ProblemParsing ) {
				Right;
				MStr += Remove_Space( Get_Word( "" ) );
				Mark_Pos;
				while ( True ) {
					Down;
					Goto_Col( 1 );
					if ( Cur_Char != "|" ) {
						break;
					}
					Right;
					MStr += " " + Remove_Space( Get_Word( "" ) );
				}
				Goto_Mark;
				Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
						"/C=" + Str( ECol ) );
				if ( Return_Int == rc_CantFind ) {
					Return_Str = FName;
				}
				else {
					Return_Str = MStr;
				}
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrAMD_HighC29K

void ErrTDBS( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling TDBS

							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str MissingStr = "*Missing Procedures*";
	str FndStr = "^(\\[ *[0-9])|(" + Make_Literal_X( MissingStr ) + ")";
	str FilStr = "^Compiling \\[";

	int ELine;
	int ECol;

	Return_Int = rc_NoMoreErrors;
//	if ( (Search_Fwd('{%@[ *[0-9]}||{%@*Missing Procedures@*}',0))  ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		if ( Found_Str != MissingStr ) {
			Forward_Till( "0123456789" );
			if ( Val( ELine, Get_Word( "]" ) ) == 0 ) {
				Forward_Till( "0123456789" );
				Mstr = Get_Word( "]" );
				Right;
				Mstr += ": " + Get_Word( "" );
				Mark_Pos;
//				Search_Bwd('%Compiling @[',0);
				if ( Find_Text( FilStr, 0, _RegExp | _Backward ) ) {
					Forward_Till( "[" );
					Right;
					Fname = Remove_Space( Get_Word( "]" ) );
					Goto_Mark;
					Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
					if ( Return_Int == rc_CantFind ) {
						Return_Str = FName;
					}
					else {
						Return_Str = MStr;
					}
				}
				else {
					Goto_Mark;
					Return_Int = rc_ProblemParsing;
				}
			}
			else {
				Return_Int = rc_ProblemParsing;
			}
		}
		else {
			Eol;
			MStr = "Missing Procedures";
			Return_Int = rc_DisplayError;
		}
	}
}  // ErrTDBS

void ErrSAsm( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling SASM

// RE Enabled
							 (C) Copyright 1992 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^\x07*File -> .*at line \\#[0-9]+";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd("%\x07*File -> ?*at line #[0-9]*",0) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		ELine = Parse_Int( "line #", Found_Str );
		Forward_Till( " " );
		Right;
		Forward_Till( " " );
		Right;
		FName = Get_Word( " " );
		Forward_Till_Not( " " );
		MStr = Get_Word( "" );
		Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
		if ( Return_Int == rc_CantFind ) {
			Return_Str = FName;
		}
		else {
			Return_Str = MStr;
		}
	}
}  // Err_SAsm

void ErrWatcomCpp( ) Trans2 {
/*******************************************************************************
															 Multi-Edit Macro

Description:  Error handling for Watcom_C_9.01.

// RE Enabled
							 (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^\\([0-9]+,[0-9]+\\):";
	str FilStr = "^File:[ \t]+";

	int ELine;
	int ECol;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd( "%([0-9]+,[0-9]+)", 0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Right;
		if ( Val( ELine, Remove_Space( Get_Word( ",)" ) ) ) == 0 ) {
			Right;
			if ( Val( ECol, Remove_Space( Get_Word( ",)" ) ) ) == 0 ) {
				Right;
				Right;
				Right;
				MStr = Remove_Space( Get_Word( "" ) );
				Mark_Pos;
//				Search_Bwd('%File:[ |9]+',0);
				Find_Text( FilStr, 0, _RegExp | _Backward );
				Forward_Till( " \t\xFF" );
				Right;
				FName = Get_Word( "" );
				Goto_Mark;
				Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
						"/C=" + Str( ECol ) );
				if ( rc_CantFind == Return_Int ) {
					Return_Str = FName;
				}
				else {
					Return_Str = MStr;
				}
			}
			else {
				Return_Int = rc_ProblemParsing;
			}
		}
		else
			Return_Int = rc_ProblemParsing;
	}
}  // Err_Watcom_CPP

void ErrMeridianAda( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error handling for Meridian ADA V4.1.

// RE Enabled
							 (C) Copyright 1993 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^\".+\",";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd('%"?+",',0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Right;
		FName = Get_word( "\"" );
		Forward_Till( "0123456789" );
		if ( Val( ELine, Get_Word( ":" ) ) == 0 ) {
			MStr = Remove_Space( Get_Word( "" ) );
			Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrMeridianAda

void ErrSoftools( )	Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error handling for Softools C and ASM.

// RE Enabled
							 (C) Copyright 1993 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^.+\\[[0-9]+\\] - (Warning)|(Error)|(Fatal)";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd('%?+@[[0-9]+@] - {Warning}||{Error}||{Fatal}',0 )) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		FName = Get_Word( "[" );
		Right;
		if ( Val( ELine, Get_Word( "]" ) ) == 0 ) {
			Right;
			Right;
			Right;
			MStr = Get_Word( "" );
			Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
			if ( Return_Int == rc_CantFind ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrSoftools

void ErrTI_C( )	Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error handling for TI C Compiler.

// RE Enabled
							 (C) Copyright 1993 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^\".+\", line";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//	if ( Search_Fwd('%"?+", line',0 ) ) {
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Right;
		FName = Get_Word( "\"" );
		Forward_Till( "0123456789" );
		if ( Val( ELine, Get_Word( ":" ) ) == 0 ) {
			Right;
			Right;
			MStr = Get_word( "" );
			Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
			if ( Return_Int == rc_CantFind) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrTI_C

void ErrByteCraft( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for BYTECRAFT compiler.

// RE Enabled
               (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^(WARNING)|(ERROR)";

	int ELine;
	int ECol;

	Return_Int = rc_NoMoreErrors;
//  if ( Search_Fwd('%{WARNING}||{ERROR}',0) ) {
  if ( Find_Text( FndStr, 0, _RegExp ) ) {
    MStr = Get_Word( " " );
    Word_Right;
    FName = Get_Word( " " );
    Right;
    if ( Val( ELine, Get_Word( ": " ) ) == 0 ) {
    	if ( Cur_Char == ":" ) {
      	Right;
			}
      if ( Val( ECol, Get_Word( ": " ) ) == 0 ) {
    		MStr += Get_Word( "" );
    		Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
						"/C=" + Str( ECol ) );
    		if ( rc_CantFind == Return_Int ) {
      		Return_Str = FName;
				}
				else {
      		Return_Str = MStr;
				}
    	}
			else {
       	Return_Int = rc_ProblemParsing;
			}
    }
		else {
      Return_Int = rc_ProblemParsing;
		}
  }
}  // ErrByteCraft

macro Err_INTEL Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  error file handling for Intel PLM51 and ASM51 Compilers.

							 (C) Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/
	str Fn[128],Es;
	int Ln, Cn;

  if ( Search_Fwd('{@*@*@* errOR}||{Exception}', 0) ) {
		if (caps(found_str) == 'EXCEPTION') {
			Fn = Global_Str('Last_Compiled_Window');
			Es = get_line;
			Ln = 1;
      goto process_err;
		}
		if ( search_fwd('IN FILE ?+.', 1) ) {
			word_right; word_right;
			Fn = get_path(global_str('last_compiled_window')) + get_word(',');
			make_message('[' + fn + ']');read_key;
		} else
			Fn = Global_Str('last_compiled_window'); //  in main file
		goto_col(1);
		Es = copy(get_line, 1, xpos('LINE', get_line, 1) -1);
		search_fwd('LINE @#[0-9]+',1);
		forward_till('0123456789');
		if ( VAL(Ln, Get_Word(' (,')) ) {
			Return_Int = RC_ProblemParsing;
			Goto Exit;
		}
		forward_till(',');
		right; right;
		mark_pos;
		if ( caps(get_word(' ')) == 'IN' )
		{
			forward_till(',');
			right; right;
			pop_mark;
		} else
			goto_mark;
		Es += Get_Word('');
PROCESS_err:
    rm('ErrFindError /F='+Fn+'/L='+str(Ln));
		if (return_int == RC_CantFind) {
			Return_Str = Fn;
			goto EXIT;
		}
		Return_Str = Es;
	}
	else
    Return_Int = RC_NoMoreerrors;
Exit:
}

void ErrIntrol( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  Error file handling for INTROL compiler.

// RE Enabled
               (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^.+: +[0-9]+ (-)|(warning )";

	int ELine;

	Return_Int = rc_NoMoreErrors;
//  if ( Search_Fwd( '%?+: +[0-9]+ {-}||{warning }', 0 ) ) {
  if ( Find_Text( FndStr, 0, _RegExp ) ) {
    FName = Get_Word( " " );
		FName = Copy( FName, 1, Svl( FName ) - 1 );
		Forward_Till( "0123456789" );
    if ( Val( ELine, Get_Word( " " ) ) == 0 ) {
    	Forward_Till_Not( " -" );
    	MStr = Get_Word( "" );
    	Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
    	if ( rc_CantFind == Return_Int ) {
      	Return_Str = FName;
			}
			else {
      	Return_Str = MStr;
			}
    }
		else {
      Return_Int = rc_ProblemParsing;
		}
  }
}  // ErrIntrol

void ErrIbmCpp( ) Trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO

Description:  error file handling for IBM CPP Compiler.

// RE Enabled
               (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/

	str FName[ 128 ];
	str MStr;
	str FndStr = ":[ \t]+error edc.+:";

	int ELine;
	int ECol;

  Return_Int = rc_NoMoreErrors;
//  if ( Search_Fwd( ":{ ||9}+errOR EDC?+:", 0 ) ) {
  if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Goto_Col( 1 );
		FName = Get_Word( "(" );
		Right;
		if ( Val( ELine, Get_Word( ":" ) ) == 0 ) {
			Right;
			if ( Val( ECol, Get_Word( ") " ) ) == 0 ) {
				Right;
				Right;
				MStr = Get_Word( "" );
    		Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
						"/C=" + Str( ECol ) );
    		if ( rc_CantFind == Return_Int ) {
					Return_Str = FName;
				}
				else {
					Return_Str = MStr;
				}
			}
			else {
				Return_Int = rc_ProblemParsing;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrIbmCpp

void ErrStonyBrookM2( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 08-Jun-95  16:33

  Function: Error file handling for Stonybrook Modula-2

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str FName[ 128 ] = g_LastCompiledWindow;
	str MStr;

	int ELine;
	int ECol;

	Word_Right;
	Goto_Col( 1 );
	MStr = Get_Word( " " );
	if ( Val( ELine, MStr ) == 0 ) {
		Right;
		MStr = Get_Word( " " );
		if ( Val( ECol, MStr ) > 0 ) {
			Return_Int = rc_NoMoreErrors;
		}
		else {
			Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
					"/C=" + Str( ECol ) );
//				Return_Int = ErrFindError( FName, ELine, ECol, 0, 0 );
		}
	}
	else {
		// try Stonybrook 21
		Goto_Col( 1 );
		Forward_Till( "(" );
		Right;
		MStr = Get_Word( ")" );
		if ( Val( ELine, MStr ) > 0 ) {
			Return_Int = rc_NoMoreErrors;
		}
		else {
			Forward_Till( "(" );
			Right;
			MStr = Get_Word( ")" );
			if ( Val( ECol, MStr ) > 0 ) {
				Return_Int = rc_NoMoreErrors;
			}
			else {
				Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
						"/C=" + Str( ECol ) );
//				Return_Int = ErrFindError( FName, ELine, ECol, 0, 0 );
			}
		}
	}
}  // ErrStonyBrookM2

void ErrLaheyFortran( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 23-Jun-95  14:15

  Function: Error file handling for Lahey Fortran

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str FName[ 128 ] = g_LastCompiledWindow;
	str MStr;
	str FndStr = "(Fatal)|(Warning)|(Abort)";

	int ELine;
	int ECol;

  Return_Int = rc_NoMoreErrors;
  if ( Find_Text( FndStr, 0, _RegExp ) ) {
		MStr = Get_Line( );
		Eol;
		Mark_Pos;
		Up;
		Goto_Col( 1 );
		if ( Find_Text( "^", 1, 0 ) ) {
			ECol = C_Col;
			Find_Text( "Line .*:", 0, _RegExp | _Backward );
			Word_Right;
			if ( Val( ELine, Get_Word( ":" ) ) == 0 ) {
				ECol -= C_Col;
			}
			else {
				Return_Int = rc_ProblemParsing;
			}
		}
		else {
			Down;
			ECol = 0;
			if ( Find_Text( "line", 2, 0 ) ) {
				Word_Right;
				if ( Val( ELine, Get_Word( " .&" ) ) != 0 ) {
					Return_Int = rc_ProblemParsing;
				}
			}
		}
		Goto_Mark;
		if ( Return_Int != rc_ProblemParsing ) {
    	Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) +
					"/C=" + Str( ECol ) );
    	if ( rc_CantFind == Return_Int ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
	}
}  // ErrLaheyFortran

void ErrJanusAda( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 23-Jun-95  14:15

  Function: Error file handling for Lahey Fortran

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str FName[ 128 ];
	str MStr;
	str FndStr = "^In File ";

	int ELine;

  Return_Int = rc_NoMoreErrors;
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Goto_Col( 9 );
		FName = Get_Word( " " );
		Word_Right;
		Word_Right;
		Word_Right;
		MStr = Get_Word( "" );
		if ( Val( ELine, MStr ) == 0 ) {
			Down;
			Down;
			Down;
			Down;
			Down;
			Goto_Col( 1 );
			MStr = Get_Word( "" );
    	Rm( "ErrFindError /F=" + FName + "/L=" + Str( ELine ) );
    	if ( rc_CantFind == Return_Int ) {
				Return_Str = FName;
			}
			else {
				Return_Str = MStr;
			}
		}
		else {
			Return_Int = rc_ProblemParsing;
		}
	}
}  // ErrJanusAda

void ErrDataFlex( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 28-Jun-95  17:29

  Function: Error processing for DataFlex compiler.

// RE Enabled
							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str FName[ 128];
	str Msg;
	str FndStr = "^\x07(Error: .+ on line: (<i>) .+ of File: (<p>))$";
//	str FndStr = "^\x07(Error: .+ on line: ([0-9]+) .+ of File: " +
// 					"(([A-Za-z]:\\\\|/)*([^\\]\\[\\\\:/<>|=;, \t]*\\\\|/)*" +
//					"[^\\]\\[\\\\:/<>|=;, \t]*))$";
	str RepStr = "\xFE" + "F=\\2" + "\xFE" + "L=\\1" + "\xFE" + "M=\\0";
	str TStr;

	int Line;

	Return_Int = rc_NoMoreErrors;
	FndStr = ReTranslate( FndStr, 1 );
	if ( Find_Text( FndStr, 0, _RegExp ) ) {
		Replace( RepStr );
		TStr = Get_Line( );
		Undo;
		Eol;
		FName = Parse_Str( "\xFE" + "F=", TStr );
		Line = Parse_Int( "\xFE" + "L=", TStr );
		Msg = Parse_Str( "\xFE" + "M=", TStr );
		Return_Int = ErrFindError( FName, Line, 0, 0, 0 );
		if ( Return_Int == rc_CantFind ) {
			Return_Str = FName;
		}
		else {
			Return_Str = Msg;
		}
	}
	Make_Message( Return_Str );
}  // ErrDataFlex
