
// Dialog control styles
#DEFINE DLG_Text          0  // Standard text prompt
#DEFINE DLG_Integer       1  // Integer prompt
#DEFINE DLG_RealNumber    2  // Real number prompt
#DEFINE DLG_Choice        3  // Pull down menu
#DEFINE DLG_Hex           4  // Hex Integer prompt
#DEFINE DLG_MacroBtnInt   7  // Integer prompt with button
#DEFINE DLG_MacroBtnStr   8  // Text prompt with button
#DEFINE DLG_Keycode       9  // Keycode prompt - for keymapping, etc.
#DEFINE DLG_Static       10  // Static text - mostly used for titles of other fields
#DEFINE DLG_PushButton   11  // Pushbutton - can run a macro or return a value
#DEFINE DLG_RadioButton  12  // Radio button. used in groups of 2 or more
#DEFINE DLG_CheckBox     13  // Check box.  On or off.
#DEFINE DLG_ListTextBox  15  // Multiple-choice list box.  see DLG_LISTBOX for a more versatile control
#DEFINE DLG_ViewTextBox  16  // Multi-line text editing window
#DEFINE DLG_HiddenStr    17  // Hidden text prompt - for passwords, etc.
#DEFINE DLG_HiddenInt    18  // Like above, except for integers
#DEFINE DLG_GroupBox     21  // Box around groups of related items
#DEFINE DLG_BlackFrame   22  // Black outline frame
#DEFINE DLG_GreyFrame    23  // Grey outline frame
#DEFINE DLG_WhiteFrame   24  // White outline frame
#DEFINE DLG_ListBox      25  // ListBox as DLG_ListTextBox but much more powerful
//  /INSWCMD=x    The command to send when
//                the ins key is presssed
//  /DELWCMD=x    The command to send when
//                the del key is pressed

#DEFINE DLG_BlackRect    26 //
#DEFINE DLG_GreyRect     27
#DEFINE DLG_WhiteRect    28

#DEFINE DLG_BitmapDefine 30
#DEFINE DLG_BitmapStatic 31
#DEFINE DLG_BitmapBtn    32
#DEFINE DLG_Icon         33
#DEFINE DLG_3State       34
#DEFINE DLG_OwnerButton  35
#DEFINE DLG_DirButton    36

#DEFINE DLG_SubDlg       50


#DEFINE DLG_PosOffset     0x00010000
#DEFINE DLG_NegOffset     0x00020000
#DEFINE DLG_Units         0x00040000

	// Edit control styles
	// Use for DLG_Text controls WITHOUT history lists.
	// These flags are ignored for DLG_Text controls with history lists
#DEFINE DLGF_es_Left        0x00000000
#DEFINE DLGF_es_Center      0x00010000
#DEFINE DLGF_es_Right       0x00020000
#DEFINE DLGF_es_MultiLine   0x00040000
#DEFINE DLGF_es_UpperCase   0x00080000
#DEFINE DLGF_es_LowerCase   0x00100000
#DEFINE DLGF_es_Password    0x00200000
#DEFINE DLGF_es_AutoVScroll 0x00400000
#DEFINE DLGF_es_AutoHScroll 0x00800000
#DEFINE DLGF_es_NoHideSel   0x01000000
#DEFINE DLGF_es_OEMConvert  0x04000000
#DEFINE DLGF_es_ReadOnly    0x08000000
#DEFINE DLGF_es_WantReturn  0x10000000
#DEFINE DLGF_Es_HScrollBar  0x00000008

#DEFINE DLGF_GetTextFromWin 0x00000004  // This flag allows DLG_Text to get
																				// the text to and from a specified
																				// window.  The window is specified
																				// with /WID=window_id in the
																				// misc parameter in DlgAddCtrl
																				// This is usually used with
																				// DLGF_es_multiline.

// These can be used on the STATIC class
#DEFINE   DLGF_ss_Left           0x000000
#DEFINE   DLGF_ss_Center         0x010000
#DEFINE   DLGF_ss_Right          0x020000
#DEFINE   DLGF_ss_LeftNoWordWrap 0x0C0000
#DEFINE   DLGF_ss_NoPrefix       0x800000   // Don't do "&" character translation



#DEFINE DLGF_Disable      0x00000001
#DEFINE DLGF_DefButton    0x00000002
#DEFINE DLGF_BitmapTgl    0x00010000
#DEFINE DLGF_SubDlgSwitch 0x00020000

#DEFINE DLGF_LBIncSearch  	0x00010000
#DEFINE DLGF_LBPTR        	0x00080000
#DEFINE DLGF_LB_SCROLLBAR 	0x00100000	// Use this to force a scrollbar in a listbox
#DEFINE DLGF_LB_EXTENDEDSEL 0x00200000 // Allow multiple selections
#define DLGF_LB_HSCROLL   	0x00400000
#DEFINE DLGF_LB_NODBLCLICK 	0x00800000 // No double click on the list items

#ifndef DLG_NOSIZE
#define DLG_NOSIZE        0x00000001
#define DLG_NOCENTER      0x00000002
#define DLG_SCREENCENTER  0x00000004
#define DLG_NOPARDISABLE  0x00000008
#define DLG_TEMPLATE      0x00000010
#DEFINE DLG_MODELESS      0x00010000
#ENDIF

#DEFINE DLG_WCMD_INIT    0x7fff

#DEFINE DLG_Units_Per_Row   8
#DEFINE DLG_Units_Per_Line  12
#DEFINE DLG_Units_Per_Col   4
#DEFINE DLG_Units_Line_Half 18
#DEFINE DLG_Units_Hline     6
#DEFINE DLG_UNITS_QLine     3

#DEFINE DLG_DefBtnHeight    13
#DEFINE DLG_StanBtnWidth    10

#define WM_TRIGGER_POPUP (wm_user + 200)
#DEFINE WM_GET_SPINWIN   (wm_user + 201)

#define SK_NoDelete					0x0001
#define SK_NoCurrentAssign  0x0002


structure DlgCtrl
{
	BYTE 	ctrltype;
	BYTE 	c,r,cw,ch;
	INT16 ux,uy,uw,uh;
	INT16 x,y,w,h;
	INT16 id;
	INT 	flags;
	WORD 	whandle;
	WORD 	extrahandle;
}

prototype dialog
{
		// Creates and returns a dialog handle. This handle must be passed to
		// all dialog box functions
	int DlgCreate( int &dlg );

		// Creates a dialog control.
	int DlgAddCtrl( int dlg,    // the dialog handle create with DlgCreate
									int ctrltype,   // the control type
									str ctrltext,   // the control title
									int x,          // the x coordinate or column number
									int y,          // the y coordinate or row number
									int width,      // the width of the control
									int height,     // the height of the control
									int ctrlid,     // the identifying number for the control
									int flags,			// bit flags
									str misc        // miscelaneous parameters
							 );

		// Gets the X and Y coordinates of a control in dlg units
	void DlgGetXY( int dlg,
								 int ctrlid,
								 int &x,
								 int &y );

		// Gets the column and row coordinates of a control
	void DlgGetCR( int dlg,
								 int ctrlid,
								 int &c,
								 int &r );


		// Returns the integer value for a dialog control
	int DlgGetInt( int dlg,         // the dialog handle
								 int ctrlid       // the control id
							 );


		// Returns the string value for a dialog control
	str DlgGetStr( int dlg,         // the dialog handle
								 int ctrlid       // the control id
							 );

		//  Sets the integer value of the specified dialog control
	void DlgSetInt( int dlg,        // the dialog handle
									int ctrlid,     // the control id
									int value       // the value to set
								);

		// Sets the string value of the specified dialog control
	void DlgSetStr( int dlg,        // the dialog handle
									int ctrlid,     // the control id
									str value       // the value to set
								);

		// Deletes a dialog structure from memory
		// and then sets the dialog handle to zero
	void DlgKill( int dlg );

		// Fits a filename into w (width).
	str DlgFitFileName( str fn, int w  );

		// Copies all of the data from the Windows controls into the dialog ctrl
		// records.  This must only be done AFTER a DlgBuild.
	void DlgSetFields( int dlg );

		// Executes the specified dialog box
	int DlgExecute(  int dlg,         // the dialog box handle
									 int startid,			// the Default ctr id
									 str title,       // the title of the dialog
									 str helpindex,   // help file index
									 str misc,        // misc parameters
                                    // /RPOS=globalstr
                                    //     get/store dialog box position in
                                    //     named global string
									 int flags
								);

	int DlgBuild( int dlg,
								str title,
								str helpindex,
								str misc,
								int flags
								);

	int DlgMessageProc( int &retval, int window, message, wparam, lparam, str parms );

	int GetDefaultButton( int w );
	int SetDefaultButton( int w, int id );

	str Set_Bitmap( str bitmap_str, int parent );
	str Set_KeyCode( str key_str, int parent, str title, int flags );

	int DlgGetWhandle(int dlg);
	void DlgGetStruct(int dlg, m_int, struct DlgCtrl);
	int DlgGetId(int dlg, seq_num);
	int DlgIdToSeq(int dlg, id_int);

  void DlgSetPos( int dlg, x, y);

  void DlgUpdateCtrl(int dlg, ctrl_id, seq_int);
  void DlgSetFocus( int Dlg, CtrlId );
/******************************************************************************
  Function: Set the input focus to CtrlId.
  Entry   : int Dlg				- The dialog data handle ( not the Windows handle )
						int CtrlId		- The control id number
  Exit    : None
********************************************************************( ldh )***/

	void DlgSetActiveWindow( int Dlg );
/******************************************************************************
  Function: Makes the dialog window for Dlg the active window.
  Entry   : int Dlg				- The dialog data handle ( not the Windows handle )
	Exit		: None
********************************************************************( ldh )***/

  void DlgEnableCtrl( int Dlg, int CtrlId, int Enable );
/******************************************************************************
  Function: Enables or Disables an existing dialog control for input.
  Entry   : int Dlg   		- The dialog data handle ( not the Windows handle )
						int CtrlId		- The control id number
						int Enable		- True to enable control, False to disable control.
  Exit    : None
********************************************************************( ldh )***/

  int DlgCtrlIsEnabled(int dlg, id_int);
/******************************************************************************
  Function: Used to determine if a control is active and can receive input
  Entry   : int Dlg				- The dialog data handle ( not the Windows handle )
						int CtrlId		- The control id number
  Exit    : int
							True				- Control is enabled
							False				- Contorl is not enabled
********************************************************************( ldh )***/

  void DlgInsertText(int Dlg, id_int, str t_str);

  void DlgGetCtrlPos( int Dlg, int CtrlId, int &X, int &Y );

  void DlgChoice2Win( int Dlg, int CtrlId );
/******************************************************************************
  Function: Puts all the choices in a dlg_Choice type control into the current
						MEW window

  Entry   : int Dlg				- The dialog data handle ( not the Windows handle )
						int CtrlId		- The control id number
  Exit    : None
********************************************************************( ldh )***/

  void DlgWin2Choice( int Dlg, int CtrlId );
/******************************************************************************
  Function: Updates a dlg_Choice type control from line of text in the current
						MEW window.

  Entry   : int Dlg				- The dialog data handle ( not the Windows handle )
						int CtrlId		- The control id number
  Exit    : None
********************************************************************( ldh )***/

  str double_slashes(str t_str);

  int DlgGetHandle( int Dlg, int CtrlId );
/******************************************************************************
  Function: Return the Windows handle for CtrlId
  Entry   : int Dlg     - Data dialog handle
            int CtrlId  - Control Id

  Exit    : int         - The Windows handle for CtrlId
********************************************************************( ldh )***/
}
