// $Header: /MeWin/Src/COMPILE.S 17    3/01/96 16:52 Dan $

macro_file COMPILE;

#define _UseStdDlgs_

#ifdef _UseStdDlgs_
	#include STDDLGS.SH
#endif

#include WINDOWS.SH
#include METOOLS.SH
#include DIALOG.SH
#include WINEXEC.SH
#include DB.SH
#include CMPERROR.SH
#include DBTOOLS.SH
#include VCS.SH

#ifdef _Debug_
  #include MSGLOG.SH
#endif

#define _ConfigFile				"MECONFIG"
#define _HeaderFile	      "MEWHDRS.DB"
#define _ProgramsHdr  		"PROGRAMS.HDR"

#define hc_ExecComp 			"EXECUTE COMPILER"
#define hc_CompTypes			""

#define hc_FileLock				"FILE LOCKING, NETWORK"

#define _PgmGlobal				"!PGM"

// PGM db constants
#define _db_pgm_Page			"PGM.DB"

// PGM record field name constants
#define _db_pgm_Program		"PGM"
#define _db_pgm_ErrFile		"EFILE"
#define _db_pgm_PreMac		"BCMAC"
#define _db_pgm_PostMac		"ACMAC"
#define _db_pgm_ErrMac		"EMAC"
#define _db_pgm_ErrFndRE	"SRE"
#define _db_pgm_ErrRepRE	"RRE"
#define _db_pgm_ErrXtra		"XTR"

#define _CTGlobal					"CT_"

global {
	int g_TmpFileCnt				"&TmpFileCnt";
	int g_MeErrId						"~MeErr_Id";
	int g_BypassMenu				"@Pgm_Menu_Bypass";
	int g_PgmCnt						_PgmGlobal;

	str g_PgmData						_PgmGlobal;
}

prototype COMPILE {
	// Public functions
	void Compile( int RunBkg );
	str  GetErrFileName( str FName );

	// Internal functions
	void _PostCompile( str FileName, str ErrorFile, str CompileType,
					int DontProcess, int SrcWin );
}

void Compile( int RunBkg = Parse_int( "/B=", MParm_Str ) ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 01-Jun-95  21:23

  Function: Bring up the compile list and run the selected compiler.

  Entry   : int RunBkg		- Flag to enable running the compile in the
														background (/B=)

 							0 						- Run based on Background setting in Compiler Setup
 							1 						- Run in the background
							2 						- Run in forground

							Copyright (C) 1992-95 by American Cybernectic, Inc.
********************************************************************( ldh )***/

  str TStr;
	str	Tstr2[ 1024 ];
	str CompRec[ Max_Line_Length ];
  str StdOut;
  str StdErr;
	str	CompileType[ 30 ];
	str	Ext;
	str	ErrFile;
	str	Ext_List[ 80 ];
	str PostCompileMac = "_PostCompile ";
	str PreMacro;
	str SrcFileName = File_Name;

	int OrgWin = Window_Id;
	int TRefresh = Refresh;
	int Compiler_Prompt = False;
	int Save_All = False;
	int Reload_File = False;
	int Dont_Process = False;
	int Jx;
	int Flags;
	int TestErr = False;
	int ErrFileOnly = False;

	Refresh = False;
	// Get the compiler/program interface data for this extension
	Ext = Get_Extension( File_Name );
	Ext_List = Parse_Str( _db_Delimit + "EXT=", Global_Str( "." + Ext ) );
	Return_Int = GetDbRecord( _ConfigFile, Ext_List + ".PGM", "EXT", "...", 0, 0,
			_PgmGlobal, False, "/AGLO=" + _PgmGlobal );

	if ( Return_Int != -2 ) {
		Tstr = Ext;
		Jx = 1;
	}
	else {
		// If we can't find a compiler for this extension, Check to see if there
		// might be a default compiler setup, and if so, see if this extension was
		// intended to fall under the default setup.
		Return_Int = GetDbRecord( _ConfigFile, "DEFAULT.PGM", "EXT", "...", 0, 0,
				_PgmGlobal, False, "/AGLO=" + _PgmGlobal );
		if ( Return_Int != -2 ) {
			if ( Ext == "" ) {
				goto No_Extension;
			}
			Return_Int = GetDbRecord( _ConfigFile, "EXT.DB", "EXT", Ext_List, 0, 0,
					_PgmGlobal, False, "" );
			if ( Return_Int > -1 ) {

No_Extension:
				Jx = 1;
				TStr = "DEFAULT";
			}
			else {
				TStr = "";
				Jx = 0;
			}
		}
	}
	Switch_Win_Id( OrgWin );

	// Create temporary error file
  ErrFile = GetErrFileName( "MEERR.TMP" );
  // Set stdout and stderr capture by default
  StdOut = ErrFile;
  StdErr = ErrFile;

	if ( Jx == 0 ) {
		TStr = "";
		Compiler_Prompt = True;
		goto Comp_Prompt;
	}

	// Skip menu if user has configured to bypass menu and only 1 program defined
	if ( !g_BypassMenu || ( g_PgmCnt != 1 ) ) {
		Jx = Db( _ConfigFile, Ext_List + ".PGM",
				_HeaderFile, _ProgramsHdr,
				"(." + TStr + ") Select a Program",
				"Compiler//Program Setup",
				_PgmGlobal,
				2,
				"/2TOP=1/NDF=1/NDH=1/NOALPHA=1/BMP=BT_GN_104/ENC=1/BM=BT_GN_104/H=" +
					hc_ExecComp + "/MOVE=1" );

		if ( Jx == 0 ) {
			Make_Message( "Compiler/program aborted." );
			goto Exit;
		}
		else if ( Jx == -1 ) {
			Tstr = "";
			Compiler_Prompt = True;
			goto Comp_Prompt;
		}
	}

	// Deallocate global used to store amount of compiler interfaces
	TStr2 = g_PgmData;
	g_PgmData = "";
	g_PgmCnt = 0;

	// We must parse out the compiler command line before we capitalize TStr2
	// because some compliers command line options are case sensitive.
	TStr = Parse_Str( _db_Delimit + "CL=", TStr2 );
	TStr2 = Caps( Tstr2 );

	// This will set COMPILER_PROMPT true if the parameter extists or if the
	// command line is null
	Compiler_Prompt = Parse_Int( _db_Delimit + "CP=", TStr2 ) || ( TStr == "" );
	Save_All = Parse_Int( _db_Delimit + "SA=", TStr2 );
	Reload_File = Parse_int( _db_Delimit + "RF=", TStr2 );
	Dont_Process = Parse_int( _db_Delimit + "DP=", TStr2 );
	CompileType = Caps( Parse_Str( _db_Delimit + "PT=", TStr2 ) );
	ErrFileOnly	= Parse_Int( _db_Delimit + "EFO=", TStr2 );
	if ( RunBkg == 0 ) {
		RunBkg = Parse_Int( _db_Delimit + "BKG=", TStr2 );
	}
	// Get program type information from db
	CompRec = CompileType;
	Jx = 0;
	Flags = _sf_ErrorNoRec | _sf_FirstField | _dbf_NoDelWin;
	Return_Int = DbGetRecord( _ConfigFile, _db_pgm_Page, _db_pgm_Program, CompRec,
			Jx, Flags, "" );
	if ( Return_Int == _NoError ) {
		Set_Global_Str( _CTGlobal + CompileType, CompRec );
		PreMacro = Parse_Str( _db_Delimit + _db_pgm_PreMac   + "=", CompRec );
		ErrFile  = Parse_Str( _db_Delimit + _db_pgm_ErrFile  + "=", CompRec );
		if ( Svl( ErrFile ) != 0 ) {
			// Set new error file
			if ( XPos( "<", ErrFile, 1 ) ) {
        ErrFile = TranslateCmdLine( ErrFile, File_Name );
			}
      ErrFile = FExpand( GetShortName( ErrFile ) );
      // Disable stdout and stderr capture
      StdOut = "";
      StdErr = "";
		}
		else {
			// Restore original error file
      ErrFile = StdOut;
		}
		if ( Svl( PreMacro ) != 0 ) {
			// Run pre compile macro
			Rm( PreMacro );
		}
	}
	if ( Parse_Int( _db_Delimit + "NR=", TStr2 ) ) {
    // Disable stdout capture
    StdOut = "";
	}
  if ( Parse_Int( _db_Delimit + "NRE=", TStr2 ) ) {
    // Disable stderr capture
    StdErr = "";
	}
	// See if we have a command line
	if ( Svl( TStr ) != 0 ) {
		// Setup to run test compile errors using CMPERROR.DB
		if ( XPos( "<TESTERR>", TStr, 1 ) ) {
			TestErr = True;
			TStr = "_CmpTestErr /CT=" + Double_Slashes( CompileType ) +
					"/EF=" + ErrFile;
		}
		if ( XPos( "<", TStr, 1 ) ) {
			// Translate the <NR> metacommand
			while ( 0 != ( Jx = XPos( "<NR>", Caps( TStr ), 1 ) ) ) {
				TStr = Str_Del( TStr, Jx, 4 );
        // Disable stdout and stderr capture
        StdOut = "";
        StdErr = "";
			}
			// Translate the <MEERR> metacommand
			while ( 0 != ( Jx = XPos( "<MEERR>", Caps( TStr ), 1 ) ) ) {
				TStr = Str_Del( TStr, Jx, 7 );
				TStr = Str_Ins( ErrFile, TStr, Jx );
			}
			if ( XPos( "<", TStr, 1 ) ) {
				// Parse the compiler command to insert filename, path and extensions
        TStr = TranslateCmdLine( TStr, File_Name );
			}
		}
	}

Comp_Prompt:
	// Special processing for PLM-86
	//  Since we use a lot of compiler defaults I tack them on at the end of
	//  the command line
	//  Someday I am going to make a menu to choose the options from which will
	//  build the command line for the user
	//  setting the command line prompt to yes will allow the user to enter
	//  his own command line for now
	if ( ( ( CompileType == "INTEL PLM-86" ) || ( CompileType == "INTEL IC-86" ) ) &&
			( TStr == "" ) )
	{
		if ( CompileType == "INTEL PLM-86" ) {
			TStr = "PLM86 " + GetShortName(File_Name) + " ";
		}
		else {
			TStr = "IC86 " + GetShortName(File_Name) + " ";
		}
		Return_Str = TStr;
    Rm( "QueryBox /P=Command Line: /T=LA OT(3) NOLI DB PR(CON:) " +
				"added to invocation line for you./W=73/ML=120" );
		TStr = Return_Str;
		Jx = Return_Int;
		if ( Jx == 0 ) {
			TStr = "";
		}

		if ( Svl( TStr ) == 0 ) {
			Make_Message( "Compile line null.  Compile aborted." );
			goto Exit;
		}
		else {
			TStr += " LA OT(3) NOLI DB PR(CON:)";
			Compiler_Prompt = False;
		}
	}

	// Now see if command line exists
	// If it exists then setup
	if ( Compiler_Prompt ) {
		Return_Str = TStr;
    Rm( "USERIN^QueryBox /W=74/ML=256/T=Enter Compiler/Program Command/H=" +
				hc_ExecComp );

		if ( Return_Int == False ) {
	 		Make_Message( "Compiler/program aborted." );
	 		goto Exit;
		}
		if ( Return_Str == "" ) {
			Make_Message( "Compile line null.  Compile aborted." );
			goto Exit;
		}
		TStr = Return_Str;
	}

	// Save off source file only or all files if Save_All flag is set
	error_level = 0;
	if ( Save_All ) {
		Rm( "AutoSave" );
		if ( Error_Level ) {
			goto Exit;
		}
	}
	else if ( File_Changed ) {
		Rm( "SaveFile /NP=1" );
		if ( Error_Level || !Return_Int ) {
			goto Exit;
		}
	}
	Refresh = True;
	Switch_Win_Id( OrgWin );
	Refresh = False;
	// Need to do this if network file locking is turned on
	if ( Reload_File ) {
    // Save cursor position
    VcsPushPos( );
//    Erase_Window;
//    RunBkg = False;
    Mark_Pos;
    Eof;
    Goto_Mark;
 	}
	Working;
	Make_Message( TStr );

	Del_File( ErrFile );

	// Compile the program

  str Working_Dir;

  Flags = _EP_FLAGS_NoSavFile;
  switch ( Parse_Int( _db_Delimit + "WORKLOC=", TStr2 ) ) {
    case 0 :
      Working_Dir = "";
      break;

    case 1 :
      Working_Dir = Get_Path( File_Name );
      break;

    case 2 :
      Working_Dir = "";
      Flags |= _EP_FLAGS_WDPROG;
      break;

    case 3 :
  		Working_Dir = Parse_Str( _db_Delimit + "WORKDIR=", TStr2 );
      Working_Dir = TranslateCmdLine( Working_Dir, GetShortName(File_Name) );
			break;
  }
  switch ( Parse_Int( _db_Delimit + "SHOW=", TStr2 ) ) {
    case  1 :
      Flags |= _EP_FLAGS_MINIMIZED;
      break;

    case  2 :
      Flags |= _EP_FLAGS_MAXIMIZED;
      break;
  }
	// Override Exe Type detection
	switch ( Parse_Int( _db_Delimit + "EXEID=", TStr2 ) ) {
		case 2 :
			Flags |= _EP_Flags_ExeDos;
			break;

		case 3 :
			Flags |= _EP_Flags_ExeWin;
			break;

		case 4 :
			Flags |= _EP_Flags_ExeOs2;
			break;

		case 5 :
			Flags |= _EP_Flags_ExeW32C;
			break;
	}
	if ( Parse_Int( _db_Delimit + "CMD=", TStr2 ) ) {
		Flags |= _EP_Flags_Comspec;
	}
	if ( ErrFileOnly ) {
		if ( Svl( TStr ) != 0 ) {
			ErrFile = TStr;
		}
	}
	PostCompileMac += "/F=" + File_Name + "/E=" + ErrFile +
			"/T=" + Double_Slashes( CompileType ) + "/DP=" + Str( Dont_Process ) +
			"/W=" + Str( OrgWin );
	if ( RunBkg == 1 ) {
		Flags |= _EP_Flags_RunBkg;
		BkgTaskMac = PostCompileMac;
	}
  if ( ( Svl( StdOut ) == 0 ) && ( Svl( StdErr ) == 0 ) ) {
		Flags |= _ep_Flags_SkipExec;
	}
	if ( ErrFileOnly ) {
		Jx = 0;
	}
	else if ( TestErr ) {
		Rm( TStr );
		Jx = Return_Int;
	}
	else {
    Jx = ExecProg( TStr, Working_Dir , StdOut, StdErr, Flags );
	}

	// Reload file if that flag is set
	if ( Reload_File ) {
    Load_File( SrcFileName );
		Rm( "ExtSetup" );
    // Reposition cursor
    VcsPopPos( True );
	}

	if ( Jx > 0 ) {
		if ( ExecErrorCode == _ExecEC_ExecInUse ) {
			Beep;
			Make_Message( "Exec in Use." );
		}
		else {
			Make_Message( "Unable to run compiler." );
		}
		goto Exit;
	}
	if ( RunBkg != 1 ) {
		Rm( PostCompileMac );
	}
	else {

Exit:
		Switch_Win_Id( OrgWin );
	}
	Refresh = TRefresh;

}  // Compile

str GetErrFileName( str FName = Parse_Str( "/F=", MParm_Str ) ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 01-Jun-95  12:17

  Function: Return a unique error file based upon FName.

  Entry   : str FName	- The name of the error file

  Exit    : str				- Error file name with full path

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int FileCnt = g_TmpFileCnt;
	int Jx;

	str TStr;
	str CntStr;

	FName = TempFileName( Truncate_Extension( FName ) );
	TStr = Truncate_Path( FName );
	if ( ( Jx = Svl( TStr ) ) > 5 ) {
		FName = Copy( FName, 1, Svl( FName ) - Jx + 5 );
	}
	TStr = FName;
	do {
		CntStr = "00" + Hex_Str( ++FileCnt );
		CntStr = Copy( CntStr, Svl( CntStr ) - 2, 3 );
		FName = TStr + CntStr + ".TMP";
	} while ( File_Exists( FName ) != 0 );
	g_TmpFileCnt = FileCnt;
//	Make_Message( FName );
	return ( GetShortName(FName) );

}  // GetErrFileName

void _PostCompile(
				str FileName = Parse_Str( "/F=", MParm_Str ),
				str ErrorFile = Parse_Str( "/E=", MParm_Str ),
				str CompileType = Parse_Str( "/T=", MParm_Str ),
				int DontProcess = Parse_Int( "/DP=", MParm_Str ),
				int SrcWin = Parse_Int( "/W=", MParm_Str )
		 ) Trans2
{
/******************************************************************************
															 Multi-Edit Macro
															 31-May-95  13:57

  Function: Load the error file and check for errors.

  Entry   : str FileName 		- Source file name (/F=)
						str ErrorFile		- Error file name  (/E=)
						str CompileType	- Compiler type name (/T=)
						int DontProcess	- True to not process errors (/DP=)
						int SrcWin			- Window_Id of source file (/W=)

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int ActiveWin = Window_Id;
	int TRefresh = Refresh;
	int MeErr_Id = 0;
	int Jx;

	str MeErrFile = TempFileName( "MEERR.TMP" );
	str ErrName = Caps( Truncate_Path( MeErrFile ) );
	str CompRec[ Max_Line_Length ] = Global_Str( _CTGlobal + CompileType );
	str PostMacro = Parse_Str( _db_Delimit + _db_pgm_PostMac  + "=", CompRec );

	Refresh = False;

	// Set global variable for CmpError
	g_LastCompiledWindow = Caps( FileName );
	g_LastComp = CompileType;

	g_LastErrMac 	= Parse_Str( _db_Delimit + _db_pgm_ErrMac   + "=", CompRec );
	g_LastFndRE		= Parse_Str( _db_Delimit + _db_pgm_ErrFndRE + "=", CompRec );
	g_LastRepRE		= Parse_Str( _db_Delimit + _db_pgm_ErrRepRE + "=", CompRec );
	g_LastErrXtra	= Parse_Str( _db_Delimit + _db_pgm_ErrXtra  + "=", CompRec );

	// Find the error window
	Jx = 0;
	while ( ( Jx < Window_Count ) &&
			( Caps( Truncate_Path( File_Name ) ) != ErrName ) )
	{
		++Jx;
		Switch_Window( Cur_Window + 1 );
	}
	// Get rid of MEERR.TMP if it exists in memory.
	if ( Caps( Truncate_Path( File_Name ) ) == ErrName ) {
		Erase_Window;
		MeErr_Id = Window_Id;
	}
	else {
		if ( File_Exists( ErrorFile ) ) {
			Create_Window;
			MeErr_Id = Window_Id;
			g_MeErrId = MeErr_Id;
			Rm( "SetWindowNames" );
			Make_Window_Visible( 1 );
		}
		else {
			MeErr_Id = 0;
		}
	}
	// Load in the error file
	if ( MeErr_Id ) {
		Load_File( ErrorFile );
		File_Name = MeErrFile;
		Save_File;
		Del_File( ErrorFile );
		Rm( "ExtSetup /EXT=" + Get_Extension( FileName ) );
		Event_Macro = "_ErrFileEvent";
		Event_Mode = event_Cursor_Line;
	}
	g_MeErrId = MeErr_Id;

	Return_Int = True;
	if ( DontProcess ) {
		Return_Str = "";
	}
	else if ( ( CompileType == "NONE" ) || ( Svl( CompileType ) == 0 ) ) {
		Return_Str = "Unsupported program type. Check this window for errors.";
		ActiveWin = MeErr_Id;
	}
	else {
		Return_Int = False;
		if ( Svl( PostMacro ) != 0 ) {
			// Call post compile macro
			Rm( PostMacro );
		}
	}
	if ( Return_Int ) {
		if ( g_DelErrWin && MeErr_Id && ( ActiveWin != MeErr_Id ) ) {
			Delete_Window;
		}
		Switch_Win_Id( SrcWin );
		AutoArrangErrSrc( Return_Str );
		Switch_Win_Id( ActiveWin );
	}
	else {
		Tof;
		Switch_Win_Id( SrcWin );
		// Run the find error macro
		CmpError( False );
	}

Exit:
	Refresh = TRefresh;

}  // _PostCompile

void Pgm_Menu( ) Trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  PGM_MENU

Description:  Menu of compiler/program types for extension setup

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	Db( _ConfigFile, "PGM.DB",
			_HeaderFile, "PGM.HDR",
			"Compiler//Program Type",
			"Compiler//Program Type Setup",
			"!PGM",
			1,
			"/NDF=1/NDH=1/FV=" + Parse_Str( "/STR=", MParm_Str ) + "/MOVE=1/PRE=PT" +
					"/NOALPHA=1/H=" + hc_CompTypes + "/MACRO=COMPILE^Pgm_Warning" );

}  // Pgm_Menu

void Pgm_Db Trans2( ) {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  PGM_DB

Description:  Menu of program/compiler interfaces for the selected extension
							This macro is run by DATA_IN

Parameters:
							/PRE=   Prefix of the ISTR global.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	Db( _ConfigFile, Parse_Str( "/EXT=", Global_Str( "@T_EXT" ) ) + ".PGM",
			_HeaderFile, _ProgramsHdr,
			"Compiler/Program",
			"Compiler//Program Setup",
			"",
			0,
			"/PRE=PGM/NDF=1/NHF=1/CBT=Done/NOALPHA=1/MOVE=1/H=" + hc_ExecComp );

}  // Pgm_Db

void Pgm_Warning( ) Trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

Name:  PGM_WARNING

Description:  Warns user that he cannot just arbitrarily add program types
							without having support for them.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	if ( Parse_Int( "/P=", MParm_Str ) ) {
//		if ( Parse_Int( "/NOCHECK=", MParm_Str) == 0 ) {
//			// Check record count against orignal amount
//			Rm( "GET_DB_RECORD /NDF=1/F=MECONFIG/DPT=LANGUAGE.DB/DBF=LANG/AGLO=@TLANG/FV=" + language );
//			if ( Global_Int( "@TLANG" ) > Global_Int( "@LANG" ) ) {
//				RM('MEERROR^MessageBox /T=WARNING/B=1/M=If you added any new language types, be sure that you have the appropriate support macros.');
//			}
//			Set_Global_Int( "@LANG", 0 );
//		}
//		Rm( "MeError^MessageBox /T=WARNING/B=1/M=If you added any new program types, be sure that the macro CMPERROR in the macro file LANGUAGE.S has code to support it.");
	}
}

void _CmpTestErr( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Jun-95  11:32

  Function: Write error data for selected Compile Type from CMPERROR.DB to the
						error file.  *** Used for testing purposes only ***.

  Entry   : /CT=str			Compile type string.
						/EF=str			Error file name to create.

  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str CompileType = Parse_Str( "/CT=", MParm_Str );

	int OrgWin = Window_Id;
	int TRefresh = Refresh;
	int FirstRec = 0;
	int NumRec;
	int CfgWin;
	int Result;

	Refresh = False;
	Result = DbGetPage( "CMPERROR", CompileType, FirstRec, NumRec );
	if ( NumRec ) {
		Down;
		Block_Begin;
		Goto_Line( FirstRec + NumRec - 1 );
		Rm( "SaveBlck /FN=" + Parse_Str( "/EF=", MParm_Str ) );
	}
	if ( Result != _ErrorNoFile ) {
		DbToolsExit( _NoError, 0, OrgWin );
	}
	Refresh = TRefresh;
	Return_Int = _exec_Success;

}  // CmpTestErr

void PostCmpMultiEdit( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 13-Jun-95  16:14

  Function: Do post compile processing for Multi-Edit CMAC compiler.

  Exit    : Return_Int
							True			- No Errors found
							False			- Continue error processing

						Return_Str	- Message to display when Return_Int is True

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str MacName[ 128 ];

	Return_Int = False;
	if ( Find_Text( "OUTPUT-FILE", 0, 0 ) ) {
		Goto_Col( C_Col + 12 );
		while ( Cur_Char == " " ) {
			Right;
		}
		if ( Cur_Char == "=" ) {
			Right;
		}
		MacName = Remove_Space( Get_Word( "" ) );
		Goto_Col( 1 );

		Load_Macro_File( MacName );
		Return_Int = True;
		Return_Str = "No errors.  Macro file = " + MacName;
	}
}  // PostCmpMultiEdit

void PostCmpDataFlex( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 13-Jun-95  16:14

  Function: Do post compile processing for DataFlex compiler.

  Exit    : Return_Int
							True			- No Errors found
							False			- Continue error processing

						Return_Str	- Message to display when Return_Int is True

	Notes		: This code assumes the use of the following batch file.
						Note that the filename and extension must be given as 2 seperate
						parms (%4 is MEERR file):

						ECHO OFF
						ERASE %4
						DFCOMP %1.%2 %3 > Nul:
						COPY %1.PRN %4 > Nul:
						IF %3 == -V99F GOTO DONE
						ERASE %1.PRN
						:DONE
						EXIT

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	Eof;
	if ( Find_Text( "Errors *: 0", 0, _RegExp | _Backward ) ) {
		Return_Int = True;
		Return_Str = "No errors.";
	}
	Tof;

}  // PostCmpDataFlex


void PostCmpEmptyFile( ) Trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 26-Jun-95  13:04

  Function: Do post compile processing for compilers that return blank ouput
						when no error is found.

  Exit    : Return_Int
							True			- No Errors found ( Error file blank )
							False			- Continue error processing

						Return_Str	- Message to display when Return_Int is True

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	Eof;
	if ( ( C_Line == 1 ) && ( C_Col == 1 ) ) {
		Return_Int = True;
		Return_Str = "Empty file, no errors.";
	}
	Tof;

}  // PostCmpEmptyFile
