macro_file collapse;

#INCLUDE windows.sh
#INCLUDE mewlib.sh
#INCLUDE dialog.sh
#include REGEXP.SH
#include COLLAPSE.SH

global
{
  int collapse_hdlg 			"!Collapse_hDlg";
  int collapse_dlg 				"!Collapse_Dlg";
	int GCollapse_BlockEx	  "#Collapse_BlockEx";
	int GCollapse_SearchEx  "#Collapse_SearchEx";
}

#DEFINE _COLLAPSE_GLOBAL	"!COLLAPSE_" + str(buffer_id)
#define COLLAPSE_HELPLINK "COLLAPSE MODE"

#define id_col_ColumnRB		1001
#define id_col_SearchRB		1002
#define id_col_ActiveCB		1004

#define id_col_ColNoTxt		2000
#define id_col_ColumnNo		2001

#define id_col_ForTxt			3000
#define id_col_SearchStr	3001
#define id_col_RegExp			3010
#define id_col_Case				3011
#define id_col_InvertCB		3012

#define id_col_BlockEx    7000
#define id_col_SearchEx   7001

void Collapse(  )
{
/*******************************************************************************
  CollapseDialog - 6/15/95 11:01AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
  if (collapse_hdlg != 0) {
		// don't allow multiple occurances, switch to currently active collapse dialog
    SetActiveWindow(collapse_hdlg);
		return ( );
	}

  int dlg,result;

  DlgCreate(dlg);

  collapse_dlg = dlg;

//  DlgAddCtrl( dlg, DLG_Static, "By:", 2, 1, 0, 0,-1,0, "" );
  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_GN_129_S",
              1, 1, 0,0, -1, 0, "" );
  DlgAddCtrl( dlg, DLG_RadioButton, "&Column", Dlg_PosOffset + 5,
			DLG_Units | 0, 0, 0,
			id_col_ColumnRB, 0, "" );

  DlgAddCtrl( dlg, DLG_RadioButton, "&Search", Dlg_PosOffset + 12,
			Dlg_PosOffset, 0, 0,
			id_col_SearchRB, 0, "" );
//  DlgAddCtrl( dlg, DLG_RadioButton, "&Tags", Dlg_PosOffset + 12,  Dlg_PosOffset, 0, 0, 1003, 0, "");
  DlgAddCtrl( dlg, DLG_WhiteFrame, "", DLG_PosOffset + 12, DLG_Units | 2, 12, DLG_Units | 8,-1,0, "" );
  DlgAddCtrl( dlg, DLG_CheckBox, "&Active",
			Dlg_PosOffset | 1,  DLG_Units | 0, 0, 0,
			id_col_ActiveCB, 0, "");

  DlgAddCtrl( dlg, DLG_BlackFrame, "",
			1, DLG_Units | 18,
			42, DLG_Units | 34,
			4000, 0, ""  );

  DlgAddCtrl( dlg, DLG_Static, "C&olumn #:", 2,  DLG_Units | 18, 0, 0, id_col_ColNoTxt, 0, "/MIN=1/MAX=" + str(max_line_length));
  DlgAddCtrl( dlg, DLG_Integer, "",
			Dlg_PosOffset + 12, Dlg_PosOffset,
			6, 0,
			id_col_ColumnNo, 0, "/MIN=1/MAX=" + Str( Max_Line_Length ) );

  DlgAddCtrl( dlg, DLG_Static, "&For:", 2,  DLG_Units | 18, 0, 0, id_col_ForTxt, 0, "");
  DlgAddCtrl( dlg, DLG_Text, "",
			Dlg_PosOffset + 5, Dlg_PosOffset, 35, 0,
			id_col_SearchStr, 0, "/ML=256/HISTORY=SEARCH_HISTORY");

  DlgAddCtrl( dlg, DLG_CheckBox, "Regular &exp.",
			Dlg_PosOffset,  Dlg_PosOffset | 1, 0, 0,
			id_col_RegExp, 0, "");

  DlgAddCtrl( dlg, DLG_CheckBox, "Case Sensiti&ve",
			Dlg_PosOffset | 18,  Dlg_PosOffset, 0, 0,
			id_col_Case, 0, "");
  DlgAddCtrl( dlg, DLG_CheckBox, "&Invert", Dlg_NegOffset | 18,  Dlg_PosOffset + 1, 0, 0, id_col_InvertCB, 0, "");

  DlgAddCtrl( dlg, DLG_CheckBox, "&Block copy excludes collapsed text", 2,  DLG_UNits | (47 + 8), 0, 0, id_col_BlockEx, 0, "");
  DlgAddCtrl( dlg, DLG_CheckBox, "Sea&rching excludes collapsed text", 2,  DLG_PosOffset | 1, 0, 0, id_col_SearchEx, 0, "");

  DlgAddCtrl( dlg, DLG_PushButton, "Scan", 1, DLG_UNits | (47 + 12 + 12 + 12), DLG_StanBtnWidth,0,110,0, "/R=1" );
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset | (Dlg_StanBtnWidth + 2), DLG_PosOffset, DLG_StanBtnWidth,0,111,0, "/R=0" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 32, DLG_PosOffset, DLG_StanBtnWidth,0,112,0, "/R=2" );

  result = DlgExecute( dlg, 110,"Collapse", COLLAPSE_HELPLINK,"/RPOS=CollapsePos/HOOK=CollapseMsgProc",
      DLG_Modeless | DLG_NoParDisable );

} // CollapseDialog

void CollapseDlgSet( int dlg, int reset_values )
{
/*******************************************************************************
  CollapseDlgSet - 6/15/95 1:11PM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

*******************************************************************************/

  str Collapse_Parms = Global_Str( _COLLAPSE_GLOBAL );

  int cm = parse_int("/CM=", collapse_parms);
  int Hide_Mode = SW_HIDE;

	struct TRect Rect;

  SendDlgItemMessage( dlg, id_col_ColumnRB, bm_setcheck, (cm == _COLLAPSE_COLUMN) || (cm == _COLLAPSE_OFF), 0 );
  SendDlgItemMessage( dlg, id_col_SearchRB, bm_setcheck, cm == _COLLAPSE_SEARCH, 0 );
//  SendDlgItemMessage( dlg, 1003, bm_setcheck, cm == _COLLAPSE_TAGS, 0 );
  SendDlgItemMessage( dlg, id_col_ActiveCB, bm_setcheck, !((cm == _COLLAPSE_OFF) || ((collapse_mode & 1) == 0)), 0 );

  if ( Reset_Values ) {

		int Jx =  Parse_Int( "/CL=", Collapse_Parms );

		if ( Jx <= 0 ) {
			Jx = 1;
		}
    SetDlgItemInt( Dlg, id_col_ColumnNo, Jx, False );

    SetDlgItemText( dlg, id_col_SearchStr, parse_str("/CS=", collapse_parms ));
    SendDlgItemMessage( dlg, id_col_RegExp, bm_setcheck,
      (parse_int("/CSF=", collapse_parms ) & _COLLAPSE_REGEXP) != 0,
      0
      );
    SendDlgItemMessage( dlg, id_col_Case, bm_setcheck,
      (parse_int("/CSF=", collapse_parms ) & _COLLAPSE_CASESENSITIVE) != 0,
      0
      );

		SendDlgItemMessage(dlg, id_col_BlockEx, bm_setcheck, GCollapse_BlockEx,0);
		SendDlgItemMessage(dlg, id_col_SearchEx, bm_setcheck, GCollapse_BlockEx,0);
  }
  switch ( cm )
  {
/*    case _COLLAPSE_OFF :
      call hide_column;
      call hide_search;
      call hide_tags;
      break;
 */
		case _COLLAPSE_OFF :
    case _COLLAPSE_COLUMN :
      call Hide_Search;
      call Hide_Tags;
      Hide_Mode = SW_SHOW;
      call Hide_Column;
      break;

    case _COLLAPSE_SEARCH :
      call hide_column;
      call hide_tags;
      hide_mode = SW_SHOW;
      call hide_search;
      break;

    case _COLLAPSE_TAGS :
      call hide_column;
      call hide_search;
      hide_mode = SW_SHOW;
      call hide_tags;
      break;
  }
	GetUpdateRect( GetDlgItem( Dlg, 4000 ), &Rect, False );
  RedrawWindow( Dlg, &Rect, 0, RDW_INVALIDATE | RDW_ERASE | RDW_ERASENOW );
  return ( );

Hide_Column:
  ShowWindow( GetDlgItem( Dlg, id_col_ColNoTxt ), Hide_Mode );
  ShowWindow( GetDlgItem( Dlg, id_col_ColumnNo ), Hide_Mode );
  ret;

Hide_Search:
  ShowWindow( GetDlgItem( Dlg, id_col_ForTxt ), Hide_Mode );
  ShowWindow( GetDlgItem( Dlg, id_col_SearchStr ), Hide_Mode );
  ShowWindow( GetDlgItem( Dlg, id_col_RegExp ), Hide_Mode );
  ShowWindow( GetDlgItem( Dlg, id_col_Case ), Hide_Mode );
  ShowWindow( GetDlgItem( Dlg, id_col_InvertCB ), Hide_Mode );
  ret;

Hide_Tags:
  ret;

} // CollapseDlgSet

void CollapseWithMode( int dlg, int get_values )
{
  str  cs = global_str( _COLLAPSE_GLOBAL );
  int jx,
			cm = parse_int("/CM=", cs);
  int sflags = 0;

  if(get_values)
  {
		// Get Block Exclude
		GCollapse_BlockEx = IsDlgButtonChecked( dlg, id_col_BlockEx);
		Collapse_Block_Ex =  GCollapse_BlockEx;

		// Get Search Exclude
		GCollapse_SearchEx   = IsDlgButtonChecked( dlg, id_col_SearchEx);
		Collapse_Search_Ex =  GCollapse_SearchEx;

		if(IsDlgButtonChecked(dlg, id_col_ColumnRB))
		{
			cm = 1;
		}
		else
		if(IsDlgButtonChecked(dlg, id_col_SearchRB))
		{
			cm = 2;
		}
		else
		{
			cm = 0;
		}

    if ( IsDlgButtonChecked( dlg, id_col_RegExp ) )
    {
      sflags |= _COLLAPSE_REGEXP;
    }
    if ( IsDlgButtonChecked( dlg, id_col_Case ) )
    {
      sflags |= _COLLAPSE_CASESENSITIVE;
    }
    if ( IsDlgButtonChecked( dlg, id_col_InvertCB ) )
    {
      sflags |= _COLLAPSE_INVERT;
    }

    str ts;
    GetDlgItemText( dlg, id_col_SearchStr, ts, 255 );
    jx = 1;
    while( jx = xpos( "/", ts, jx ) )
    {
      ts = str_ins( "/", ts, jx );
      ++jx;
      ++jx;
    }

    cs = "/CM=" + str(cm) +
         "/CL=" + str(GetDlgItemInt( dlg, id_col_ColumnNo, jx, 0 )) +
         "/CSF=" + str(sflags) +
         "/CS=" + ts +
				 "/CON=" + str(cm != 0);

    set_global_str( _COLLAPSE_GLOBAL, cs );
  }

  switch (cm )
  {
    case _COLLAPSE_COLUMN :
        CollapseByLevel( parse_int("/CL=", cs));
        break;

    case _COLLAPSE_SEARCH :
        return_str = parse_str("/CS=", cs);                //add items to history list
        rm('History_List /M=1/HISTORY=SEARCH_HISTORY');    //add items to history list
				str ts = return_str;
				SendDlgItemMessageStr(dlg,3001, CB_INSERTSTRING, 0, ts );
        CollapseBySearch( parse_str("/CS=", cs), parse_int("/CSF=", cs));
        break;

    case _COLLAPSE_OFF :
        CollapseOff();
        break;
  }
	SendDlgItemMessage( dlg, id_col_ActiveCB, bm_setcheck, !((cm == _COLLAPSE_OFF) || ((collapse_mode & 1) == 0)), 0 );

}

int CollapseMsgProc( int &retval, int window, int message, int wparam, int lparam, str parms ) no_break
{
  int cm;

	if ( message == WM_NEWACTIVEMDI )
	{
    CollapseDlgSet( window, TRUE );
	}
	else
	switch ( message )
	{
		case WM_DESTROY :
			retval = 0;
			// deallocate globals
      collapse_hdlg      = 0;
      collapse_dlg       = 0;
			break;

		case WM_COMMAND :
      switch ( wparam )
      {
        case 111 :  // Cancel
          CollapseAllOff();
          break;

        case 110 :
Do_Ok:
      		//EnableWindow( GetDlgItem( window, 100 ), FALSE );
          SetFocus( GetDlgItem(window,111));
          SetDefaultButton( window, 111 );
          SetActiveWindow( frame_handle );
          CollapseWithMode(window,true);
          redraw;
          return(1);

        case DLG_WCMD_INIT :
          collapse_hdlg = window;
          CollapseDlgSet( window, TRUE );
          break;

				case id_col_BlockEx :
					if((lparam >> 16) == BN_CLICKED)
					{
						GCollapse_BlockEx = IsDlgButtonChecked( window, id_col_BlockEx);
						Collapse_Block_Ex =  GCollapse_BlockEx;
						Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
					}
					break;

				case id_col_SearchEx :
					if((lparam >> 16) == BN_CLICKED)
					{
						GCollapse_SearchEx = IsDlgButtonChecked( window, id_col_SearchEx);
						Collapse_Search_Ex =  GCollapse_SearchEx;
						Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);
					}
					break;

        case id_col_ColumnRB :  // Column mode
          if((lparam >> 16) == BN_CLICKED)
          {
             cm = _COLLAPSE_COLUMN;
             call reset_dlg;
						 SetFocus( GetDlgItem( Window, id_col_ColumnNo ) );
          }
          break;

        case id_col_SearchRB :  // Search mode
          if((lparam >> 16) == BN_CLICKED)
          {
             cm = _COLLAPSE_SEARCH;
             call reset_dlg;
						 SetFocus( GetDlgItem( Window, id_col_SearchStr ) );
          }
          break;

        case 1003 :  // Tags mode
          if((lparam >> 16) == BN_CLICKED)
          {
             cm = _COLLAPSE_TAGS;
             call reset_dlg;
          }
          break;

        case id_col_ActiveCB :  // Off/On mode
          if((lparam >> 16) == BN_CLICKED)
          {
						if(IsDlgButtonChecked( window, id_col_ActiveCB ))
						{
							if( !parse_int("/CON=", Global_Str( _COLLAPSE_GLOBAL )))
							{
								goto do_ok;
							}
							else
							{
						  	collapse_mode |= 0x01;
							}
						}
						else
						{
							collapse_mode &= 0xfe;
							redraw;
						}
          //   cm = _COLLAPSE_OFF;
          //   call reset_dlg;
          }
          break;

        case id_col_ColumnNo :
          if((lparam >> 16) == EN_CHANGE)
          {
             call set_ok;
          }
          break;

        case id_col_SearchStr :
          if((lparam >> 16) == CBN_EDITCHANGE)
          {
             call set_ok;
          }
          break;
      }
      break;

	}
	return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));

reset_dlg:
  {
    str collapse_parms = Global_Str( _COLLAPSE_GLOBAL );
    int tcm = parse_int("/CM=", collapse_parms );
    var_remove_str("/CM=", collapse_parms );
    Set_Global_Str(_COLLAPSE_GLOBAL, "/CM=" + str(cm) + collapse_parms);
    CollapseDlgSet( window, false );
    if(tcm != cm)
    {
      call set_ok;
    }
    ret;
  }

set_ok:
  {
    SetDefaultButton( window, 110 );
    //EnableWindow( GetDlgItem( window, 100 ), TRUE );
    ret;
  }
}

void CollapseBySearch(
			str SearchStr = Parse_Str( "/S=", MParm_Str ),
			int Flags			= Parse_Int( "/F=", MParm_Str ) )
/******************************************************************************
															 Multi-Edit Macro
															 18-Dec-95  13:12

	Function: Collapse using a search string

	Entry   : str SearchStr - The string to use to collapse text ( "/S=" )
						int Flags			- Flags to specify type of search.   ( "/F=" )
							_COLLAPSE_REGEXP  			- 1 Regular expression search
							_COLLAPSE_CASESENSITIVE - 2 Case sensitive search
							_COLLAPSE_INVERT				- 4 Collapse text matching SearchStr



							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
  int TRefresh = refresh;
  int nFlags = 0;
  int OLine = False;
	int Tr;
	int Kr;

  Refresh = False;
  Collapse_Mode &= 0xFE;
	Mark_Pos;
	Tof;

  if ( Flags & _COLLAPSE_CASESENSITIVE ) {
    nFlags |= _CaseSensitive;
  }

  if ( Flags & _COLLAPSE_REGEXP ) {
    if ( Global_Int( "REG_EXP_STYLE" ) ) {
      nFlags |= _RegExp;
    }
		else {
      nFlags |= _OldExp;
    }
		// Translate RE aliases
		SearchStr = ReTranslate( SearchStr, 0 );
  }
	if ( Flags & _COLLAPSE_INVERT ) {
		Kr = 0;
	}
	else {
		Kr = 1;
	}
	Line_Stat &= ( 0xFFFF ^ 0x0704 );
	Line_Stat |= 0x100;
	Down;
	while ( !At_Eof ) {
		Line_Stat &= ( 0xFFFF ^ 0x0704 );
		Tr = Find_Text( SearchStr, 1, nFlags );
		if ( Tr == Kr ) {
			Line_Stat |= 0x0400;
			OLine = True;
		}
		else {
			Line_Stat |= 0x04;
			if ( OLine ) {
				Up;
			  Line_Stat |= 0x100;
				Down;
			}
			OLine = False;
		}
		Down;
		Goto_Col( 1 );
	}
	Goto_Mark;
  while ( ( C_Line > 1 ) && ( Line_Stat & 4 ) ) {
    Up;
  }
  while ( !At_Eof && ( Line_Stat & 4 ) ) {
    Down;
  }
  Collapse_Mode |= 0x01;
  Redraw;
  Refresh = TRefresh;
  return ( );

} // CollapseBySearch

void CollapseByLevel( int clevel )
{
/*******************************************************************************
  CollapseByLevel - 5/23/95 11:26AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

*******************************************************************************/

  int TRefresh = Refresh;
  int PLine = 1;

  if ( CLevel == 0 ) {
    CLevel = 1;
  }
  Refresh = False;
  Collapse_Mode &= 0xFE;
  Mark_Pos;
  Tof;
	Line_Stat &= ( 0xFFFF ^ 0x0704 );
  Down;
	First_Word;
  while ( !At_Eof ) {
    if ( Line_Stat & 0x0704 ) {
      Line_Stat &= ( 0xFFFF ^ 0x0704 );
		}
    //line_stat &= 0xFCDF;
    if ( !At_Eol ) {
      if ( C_Col > CLevel ) {
        Goto_Line( PLine );
        CollapseLevel( 1, CLevel );
        Up;
      }
      else {
        PLine = C_Line;
      }
    }
    Down;
    First_Word;
  }
  Goto_Mark;

  while ( ( C_Line > 1 ) && ( Line_Stat & 4 ) ) {
    Up;
  }
  while ( !At_Eof && ( Line_Stat & 4 ) ) {
    Down;
  }
  Collapse_Mode |= 0x01;
  Redraw;
  Refresh = TRefresh;

} // CollapseByLevel

void CollapseMouse( int cmode = parse_int("/M=", mparm_str) )
{
/*******************************************************************************
  Collapse - 5/23/95 8:37AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
  str collapse_parms = global_str( _COLLAPSE_GLOBAL );
  int cm = parse_int("/CM=", collapse_parms);
	int cl = parse_int("/CL=", collapse_parms);
	int tper = persistent_blocks;
	int tser = search_highlight;
	int tr = refresh;

	persistent_blocks = TRUE;

  switch ( cmode )
  {
    case 1 :
      {
        mark_pos;
        refresh = false;
        collapse_mode &= 0xFE;

        if( line_stat & 0x100 )
        {
          ExpandLevel( cm, cl );
        }
        else
        if ( line_stat & 0x200 )
        {
          CollapseLevel( cm, cl );
        }
        collapse_mode |= 0x01;
        goto_mark;
        refresh = true;
        redraw;
				break;
      }

		case 2 :
			{
        int tr = refresh;
        mark_pos;
        refresh = false;
        collapse_mode &= 0xFE;

				while(line_stat & 0x04)
				{
					up;
				}

        ExpandLevel( cm, cl );

        collapse_mode |= 0x01;
        goto_mark;
        refresh = tr;
        redraw;
				break;
			}
			break;
  }
	search_highlight = tser;
	persistent_blocks = tper;
} // Collapse

void CollapseOff(  ) {
/*******************************************************************************
  CollapseOff - 5/23/95 3:34PM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

*******************************************************************************/

  int TRefresh = Refresh;

  Refresh = False;
  Collapse_Mode &= 0xFE;
  Mark_Pos;
  Tof;
  while ( !At_Eof ) {
    if ( Line_Stat & 0x0704 ) {
      Line_Stat &= ( 0xFFFF ^ 0x0704 );
		}
    Down;
  }
  Goto_Mark;
  Refresh = TRefresh;
  Redraw;

} // CollapseOff

/*******************************************************************************
  CollapseAllOff - 8/25/95 3:32PM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
void CollapseAllOff(  )
{
  int Trefresh = refresh;
  refresh = false;
  int tw = cur_window;

  int jx = 0;
  while(jx++ < window_count)
  {
    switch_window(jx);
    if ( _COLLAPSE_GLOBAL != "" )
    {
      Collapse_Mode &= 0xFE;
      redraw;
    }
  }

  switch_window(tw);
  refresh = Trefresh;
} // CollapseAllOff

void CollapseLevel( int m, level )
{
/*******************************************************************************
  CollapseLevel - 5/23/95 8:41AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

*******************************************************************************/

  int nlevel = 0;
  int pline = c_line;

  Line_Stat &= ( 0xFFFF ^ 0x700 );
  Line_Stat |= 0x500;
  Down;
	First_Word;
	if ( m == 2 ) {
		while ( !At_Eof && !( Line_Stat & 0x700 ) ) {
	    if ( !( Line_Stat & 0x04 ) ) {
	      Line_Stat |= 0x04;
			}
			Down;
		}
	}
	else {
	  while ( !At_Eof ) {
	    if ( At_Eol ) {
	      if ( !( Line_Stat & 0x04 ) ) {
	        Line_Stat |= 0x04;
				}
	    }
	    else {
	      if ( C_Col <= Level ) {
	        break;
	      }
	      if ( C_Col > Level ) {
	        if(!(line_stat & 0x04))
	          line_stat |= 0x04;
	        if( !m )
	        {
	          if( nlevel == 0)
	          {
	            nlevel = c_col;
	          }
	          else
	          {
	            if(c_col > nlevel )
	            {
	              goto_line(pline);
	              line_stat |= 0x140;
	              CollapseLevel( m, c_col );
	              continue;
	            }
	          }
	        }
	      }
	      else {
	        break;
	      }
	      pline = c_line;
	    }
	    down;
	    first_word;
	  }
	}
} // CollapseLevel

void ExpandLevel( int m, level )
{

/*******************************************************************************
  ExpandLevel - 5/23/95 8:41AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/

  int nlevel = 0;
  int pline = c_line;
  line_stat &= (0xFFFF ^ 0x100);
  line_stat |= 0x600;
  down;
  first_word;
	if(m == 2)
	{
		while((!at_eof) && (!(line_stat & 0x700)))
		{
	    if(line_stat & 0x04)
	      line_stat &= (0xFFFF ^ 0x04);
			down;
		}
	}
	else
	{
	  while(!at_eof)
	  {
	    if(at_eol)
	    {
        if(line_stat & 0x04)
	        line_stat &= (0xFFFF ^ 0x0004);
	    }
	    else
	    {
	      if(c_col <= level)
	      {
	        break;
	      }

	      if( nlevel == 0)
	      {
	        nlevel = c_col;
	      }

	      if((m == 1) || (c_col <= nlevel))
	      {
	        line_stat &= (0xFFFF ^ 0x0004);
	      }
	    }
	    down;
	    first_word;
	  }
	}
} // ExandLevel

void NextCollapseLevel( int Back = Parse_Int( "/BACK=", Mparm_Str ) ) {
/******************************************************************************
															 Multi-Edit Macro
															 05-Jul-95  15:47

  Function: Positions the cursor on the next or previous collapse level.

  Entry   : int Back	- True to search backwards from current line ( "/BACK=1" )

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int TRefresh = Refresh;
	int OrgLine = C_Line;
//	int TCollapse_Mode = Collapse_Mode;

	Refresh = False;
//  Collapse_Mode = False;
	Mark_Pos;
	if ( Back ) {
		Up;
//		while ( ( C_Line != 1 ) && ( ( Line_Stat & 0x700 ) == 0 ) ) {
		while ( ( C_Line != 1 ) && ( ( Line_Stat & 0x300 ) == 0 ) ) {
			Up;
		}
	}
	else {
		Down;
//		while ( !At_Eof && ( ( Line_Stat & 0x700 ) == 0 ) ) {
		while ( !At_Eof && ( ( Line_Stat & 0x300 ) == 0 ) ) {
			Down;
		}
	}
//	if ( At_Eof || ( ( C_Line == 1 ) && ( ( Line_Stat & 0x700 ) == 0 ) ) ) {
	if ( At_Eof || ( ( C_Line == 1 ) && ( ( Line_Stat & 0x300 ) == 0 ) ) ) {
		Make_Message( "No more collapsed lines" );
		Goto_Mark;
	}
	else {
		Pop_Mark;
		if ( C_Line > OrgLine ) {
			OrgLine = C_Line;
			if ( C_Row > ( Win_Y2 - Win_Y1 ) ) {
//				Rm( "CenterLn" );
				Rm( "TopWin" );
				Goto_Line( OrgLine );
			}
		}

#ifdef Windows
//		Set_Highlight( C_Line, 0, C_Line, Max_Line_Length );
#endif

	}
//  Collapse_Mode = TCollapse_Mode;
	Refresh = TRefresh;
	Redraw;

}  // NextCollapseLevel

void CollapseModeToggle( ) {
/******************************************************************************
															 Multi-Edit Macro
															 18-Dec-95  13:27

	Function: Toggle collapse display.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Collapse_Mode = !Collapse_Mode;
	Redraw;

}  // CollapseModeToggle