// $Header: /MeWin/Src/BRIEF.S 14    3/13/96 10:42 Dan $

macro_file BRIEF;  // brief.s for multi-edit for windows

#include WINDOWS.SH
#include MEW.SH
#include METOOLS.SH
#include DIALOG.SH
#include MENUS.SH
#include WINDOW.SH
#include HEX.SH

#ifdef _Debug_
	#include MSGLOG.SH
#endif

#define BRIEF_SCREEN_WIDTH  ( Win_CWidth )
#define SEARCH_HELPLINK     "SEARCH"
#define SRCHREP_HELPLINK    "SEARCH AND REPLACE"

#define _SplitCntGlo		"BrSplitCnt_"

global {
  int SReturn_Int;   // Added for Modeless Purposes
	int g_BrCurBuffer			"!BrCurBuffer";
	int g_BrCurWindow 		"!BrCurWindow";
	int g_BrErrNoBeep			"!BrErrNoBeep";
	int g_WinRedrawOff		"!WinRedrawOff";

	// Remove when added to FC.SH (ldh)
	int g_FcSelWin					"!FcSelWin";
}

/*****************************************************************************
														MULTI-EDIT MACRO FILE

Name:		BRIEF

Description:  This macro file contains macros to emulate a subset of common
							B.R.I.E.F. macros.  It is not our intention to completely mimic
							BRIEF, but to provide a less painful transition from BRIEF to
							Multi-Edit.

BRIEF_HELP			- Brings up BRIEF quick reference
SRC_CASE				- Mimics Brief's Search_Case macro
DELETE_M				- Mimics Brief's Delete_Macro macro
NEXT_ERR				- Mimics Brief's Next_Error 1 macro
QUOTE						- Mimics Brief's Quote macro
TOGGLE_R				- Mimics Brief's Toggle_Re macro
SEARCH_F				- Mimics Brief's Search_Fwd macro
SEARCH_B				- Mimics Brief's Search_Back macro
SEARCH_A				- Mimics Brief's Search_Again macro
TRANSLAT				- Mimics Brief's Translate macro
XLAT_BWD				- Mimics Brief's Translate_Back macro
XLAT_AGA				- Mimics Brief's Translate_Again macro
WRITE_IT				- Mimics Brief's Write_It macro
CHANGE_WINDOW  	- Mimics Brief's Change_Window macro
B_DEL_CHAR			- Mimics Brief's use of the <Del> key

BUF_LIST        - Mimics Brief's Buffer list
B_DELETE_BUFFER - Mimics Brief's Delete_Buffer command
B_CREATE_EDGE   - Mimics Brief's Create_Edge command
B_DELETE_EDGE   - Mimics Brief's Delete_Edge command

*******************************PLEASE READ THIS*******************************
NOTES ON BRIEF WINDOWING EMULATION MACROS (BUF_LIST, B_DELETE_BUFFER,
B_CREATE_EDGE and B_DELETE_EDGE)

One of the most important concepts I'm trying to convey is the differences in
Multi-Edit's windowing versus BRIEF's.  I would appreciate any comments you
can give to help me make this as complete and easy-to-understand as possible.

This set of macros is designed to approximate the BRIEF-like window
operations.  IT IS NOT intended to mimic every subtle nuance of BRIEF, but to
make the transition from BRIEF to Multi-Edit more comfortable.  It is written
in such a way as to reasonably co-exist with Multi-Edit's built-in windowing
operations.

In order to successfully use this set of macros along side Multi-Edit's
built-in windowing operations, you need to understand a little about how this
macro package is doing its thing.  In BRIEF, there are 2 types of "objects":
buffers, and windows.  A buffer is approximately equivalent to a Multi-Edit
window with the exception that it cannot be viewed or edited unless it is
attached to a window.  A window in BRIEF is merely a "view port" to a buffer
that allows editing of that buffer.  Only with the "attaching" of a buffer
to a window can the user edit a file.  In Multi-Edit, there are only windows.
However, Multi-Edit windows have an attribute associated with them that allow
the macro programmer to simulate a buffer, or a view port.  Also, unlike
BRIEF, windows can overlap, even to the extent that all are full screen.  In
BRIEF, windows can only be tiled.

Probably the most serious disparity between BRIEF and Multi-Edit is that fact
that you can load the same file into more than one window (buffer).  This may
upset some former BRIEF users.  The reason we allow this is 2 fold:

	1. Our philosophy is to refrain from restricting the user from doing
		 anything that he or she wants, even if it can be dangerous.  We do,
		 however always build adequate warning mechanisms into any feature that
		 might be potentially hazardous.  By the way, this philosophy should not
		 be foreign to any C programmer who despises the "restrictive" nature of
		 other languages like Pascal and Modula 2.

	2. Multi-Edit is a CUA compliant editor.  Although the current CUA
		 specification appears to be silent on this subject (I say "appears"
		 because the documentation isn't exactly easy to decipher) we have
		 carefully studied other CUA compliant products such as Word for Windows
		 and the Borland IDE and have concluded that there is enough conformity
		 to easily support our suspicion that this may eventually become part of
		 the CUA specification.

Having laid that ground work, I'll attempt to explain how this macro package
can co-exist with Multi-Edit's built-in windowing.  Actually, there is a way
that you need not be concerned with that.  So long as you ALWAYS create and
delete windows, switch windows and buffers, and load all files using these
macros exclusively, everything will work pretty much as a former BRIEF user
would expect.  But on to reality...


Multi-Edit's Window List
Shows all windows except the "invisible" and non-editable ones, like
the cut and paste buffer, and MECONFIG.DB.  You might discover that the same
file may appear more than once in this list and that each instance is marked
as LINKED.  Most likely, at least one instance is currently visible or in the
"foreground" while others, hopefully only one, may not be visible; i.e. in the
"background".  You can think of the "background" windows as "buffers".  You
might say that the "foreground window(s)" is(are) attached to the "background
buffer".  This window list allows you to do some things that can potentially
screw things up if you are trying to emulate BRIEF behavior:

		HIDE - It's ok if you hide a "background buffer", but it could lead to
					 confusion if you hide any "foreground" window.

		DELETE - see the section titled "Multi-Edit's Menu-Window-Close or Delete
						 from the Window List"

Our BUFF_LIST is similar, except it excludes all but one instance of a
group of linked windows, thus eliminating the redundant listing of windows
with the same file.  By doing that, it only shows you a list of editable
files, and doesn't confuse you with concepts such as LINKED.

CAUTION: If you find the same file in more than one window in BUFF_LIST, it
means you have the same file loaded into 2 non-linked windows.  As this can
lead to problems, it is advisable that you either make one of them read-only
via Menu-File-Information or delete one of the windows.


Multi-Edit's Menu-Window-Close or Delete from the Window List
If you delete a "foreground" window (this always happens with Menu-Window-
Close) and it's not linked, the file will no longer exist in memory.  If it
is linked, it would be approximately equivalent to BRIEF's DELETE_EDGE.  In
either case, if it is a full screen window (i.e. not split), it will go ahead
and delete it.  If there is more than one window or buffer, this will bring a
previously background "buffer" into the foreground.  If you delete a
"background buffer" and it's not linked, it would be approximately equivalent
to BRIEF's DELETE_BUFFER.  Our B_DELETE_EDGE and B_DELETE_BUFFER is preferred.


Multi-Edit's Menu-File-Open or Menu-Window-Open
This opens a new full screen window and prompts for a file name to load.
This means that the window (viewport) you were previously looking at is now
in the background.  This concept is not compatible with BRIEF behavior.
Our B_EDIT_FILE is preferred because the new file will end up in the same
window (viewport) as the previous one.  If you happen to use one of our built-
in window open routines by mistake, not to worry.  You can get back to the
previous window (viewport) by using the next window command Menu-Window-Next.


Multi-Edit's Menu-File-Load
It is not recommended that you use this one, unless you see the linked
indicator to the right of the window letter near the upper left corner of
the window borderĿ
		 
͸A


If the linked indicator does not show, and you load a file this way, the
file you were previously editing will no longer exist in memory.  If the
linked indicator is present, the previous file will still remain (in the
background) and can be "switched" into via EDIT_NEXT_BUFFER,
EDIT_PREV_BUFFER or BUF_LIST.

Toney Robinson

							 (C) Copyright 1993 by American Cybernetics, Inc.
******************************************************************************/

void BrErrorMsg( str Msg = Parse_Str( "/M=", MParm_Str ) ) {
/******************************************************************************
															 Multi-Edit Macro
															 31-Aug-95  14:32

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	if ( !g_BrErrNoBeep ) {
		Beep;
	}
	Make_Message( Msg );

}  // BrErrorMsg

macro BRIEF_HELP TRANS {

// _ Completed
//  Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		BRIEF_HELP

Description:  Brings up BRIEF quick reference

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/
	//rm('MeHelp  '+MParm_Str+'/F=BRIEF/L=*');
	rm('mew^not_yet_supp');
}


macro SET_BACK TRANS {
	rm('mew^not_yet_supp');
}


macro SRC_CASE TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		SRC_CASE

Description:  Mimics Brief's Search_Case macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	str		Switches=Caps(Global_Str('Switches')),
				REPL_Switches=Caps(Global_Str('REPL_Switches')),
				TStr[3];

	if ( 0!=(Return_Int=XPos('I',Switches,1)) )
	{
		while ( 0!=(Return_Int=XPos('I',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);
		while ( 0!=(Return_Int=XPos('I',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);
		TStr='on';
	}
	else
	{
		Switches=Switches+'I';
		if ( !XPos('I',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'I';
		TStr='off';
	}

	Set_Global_Str('Switches',Switches);
	Set_Global_Str('REPL_Switches',REPL_Switches);
	BrErrorMsg( "Case sensitivity " + TStr + "." );
}

macro DELETE_M TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		DELETE_M

Description:  Mimics Brief's Delete_Macro macro.  A significant difference is
							that BRIEF can only delete entire macro files from memory, ME
							can delete individual macros

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	Set_Global_Str('!B_IPARM_1','/C=1/L=1/W=16/H=MC/T=Macro to unload:');
	RM( 'USERIN^DATA_IN /PRE=!B_/#=1/T=/X=5/Y=3');
	if ( Return_Int ) {
		UnLoad_Macro(Global_Str('!B_ISTR_1'));
		BrErrorMsg( "Macro " + Caps( Return_Str ) + " unloaded" );
	}
}  // DELETE_M

macro QUOTE TRANS {

//  Completed
// _ Stubbed
//  Tested


// See MEUTIL1^REPEAT for getting keystrokes from status line prompt

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		QUOTE

Description:  Mimics Brief's Quote macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

#ifndef WINDOWS
	Read_Key;
	if(  (Key1 != 0)  )
		Text(Char(Key1));
	else
		Pass_Key(Key1,Key2);
#else
	rm('ASCII');
#endif
}

macro TOGGLE_R TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		TOGGLE_R

Description:  Mimics Brief's Toggle_Re macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	str		Switches=Caps(Global_Str('Switches')),
				REPL_Switches=Caps(Global_Str('REPL_Switches')),
				Tstr[3];

	if ( 0!=(Return_Int=XPos('X',Switches,1)) )
	{
		while ( 0!=(Return_Int=XPos('X',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);
		while ( 0!=(Return_Int=XPos('X',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);
		TStr='on';
	}
	else
	{
		Switches=Switches+'X';
		if ( !XPos('X',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'X';
		TStr='off';
	}
	Set_Global_Str('Switches',Switches);
	Set_Global_Str('REPL_Switches',REPL_Switches);
	BrErrorMsg( "Regular expressions " + TStr + "." );
}

macro SEARCH_F TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		SEARCH_F

Description:  Mimics Brief's Search_Fwd macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	int OldRefresh=Refresh;
	str	Switches=Caps(Global_Str('Switches'));

	while ( 0!=(Return_Int=XPos('B',Switches,1)) )
		Switches=Str_Del(Global_Str('Switches'),Return_Int,1);

	if ( Block_Stat )
	{
		int	tblx=Block_LineX,tbcx=Block_ColX,
				tbs=Block_Stat,tm=Marking;

		if ( Block_Line1==tblx )
			if ( ((Block_Stat==1)&&(Block_Line1!=Block_Line2))||
					((Block_Stat!=1)&&(Block_Col1==tbcx)) )
			{
				tblx=Block_Line2;
				tbcx=Block_Col2;
			}

		if ( !XPos('R',Switches,1) )
			Switches=Switches+'R';
		if ( !XPos('G',Switches,1) )
			Switches=Switches+'G';

		Call DoSearch;
		if ( Global_Int('Found_Count') )
		{
			Block_LineX=tblx;
			Block_ColX=tbcx;
		}
		Block_Stat=tbs;
		Marking=tm;
		Refresh=True;
		Goto_Line(C_Line);
		Goto_Col(C_Col);
		Redraw;
	}
	else
	{
		while ( 0!=(Return_Int=XPos('R',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);

		while ( 0!=(Return_Int=XPos('G',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);

		Call DoSearch;
	}
	Goto Exit;

DoSearch:
	Set_Global_Str('Switches',Switches);
	Set_Global_Int('Search_Mode',0);
  if (Global_Int('~SR_MODAL') != 0) {
    RM( 'S_AND_R ');
  } else {
    RM('SRCHINTR /H=' + SEARCH_HELPLINK + '/SRG=SEARCH_STR');
  }
	Set_Global_Int('RepSearch',0);
	ret;

Exit:
	Refresh=OldRefresh;
}

macro SEARCH_B TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		SEARCH_B

Description:  Mimics Brief's Search_Back macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	int	OldRefresh=Refresh;
	str Switches=Caps(Global_Str('Switches'));

	if ( !XPos('B',Switches,1) )
		Switches=Switches+'B';

	if ( Block_Stat )
	{
		int	tblx=Block_LineX,tbcx=Block_ColX,
				tbs=Block_Stat,tm=Marking;

		if ( Block_Line2==tblx )
			if ( ((Block_Stat==1)&&(Block_LIne1!=Block_Line2))||
					((Block_Stat!=1)&&(Block_Col2==tbcx)) )
			{
				tblx=Block_Line1;
				tbcx=Block_Col1;
			}

		if ( !XPos('R',Switches,1) )
			Switches=Switches+'R';
		if ( !XPos('G',Switches,1) )
			Switches=Switches+'G';

		Call DoSearch;
		if ( Global_Int('Found_Count') )
		{
			Block_LineX=tblx;
			Block_ColX=tbcx;
		}
		Block_Stat=tbs;
		Marking=tm;
		Refresh=True;
		Goto_Line(C_Line);
		Goto_Col(C_Col);
		Redraw;
	}
	else
	{
		while ( 0!=(Return_Int=XPos('R',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);

		while ( 0!=(Return_Int=XPos('G',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);

		Call DoSearch;
	}
	Goto Exit;

DoSearch:
	Set_Global_Str('Switches',Switches);
	Set_Global_Int('Search_Mode',0);
	Set_Global_Int('RepSearch',0);
  if (Global_Int('~SR_MODAL') != 0) {
    RM( 'S_AND_R '+ mparm_str);
  } else {
    RM('SRCHINTR /H=' + SEARCH_HELPLINK + '/SRG=SEARCH_STR');
  }
	ret;

Exit:
	Refresh=OldRefresh;
}

macro SEARCH_A TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		SEARCH_A

Description:  Mimics Brief's Search_Again macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	int	OldRefresh=Refresh;
	str Switches=Caps(Global_Str('Switches'));

	if ( Block_Stat )
	{
		int	tblx=Block_LineX,tbcx=Block_ColX,
				tbs=Block_Stat,tm=Marking;

		if ( XPos('B',Switches,1) )
		{
			if ( Block_Line2==tblx )
				if ( ((Block_Stat==1)&&(Block_LIne1!=Block_Line2))||
						((Block_Stat!=1)&&(Block_Col2==tbcx)) )
				{
					tblx=Block_Line1;
					tbcx=Block_Col1;
				}
		}
		else
		{
			if ( Block_Line1==tblx )
				if ( ((Block_Stat==1)&&(Block_Line1!=Block_Line2))||
						((Block_Stat!=1)&&(Block_Col1==tbcx)) )
				{
					tblx=Block_Line2;
					tbcx=Block_Col2;
				}
		}

		if ( !XPos('R',Switches,1) )
			Switches=Switches+'R';
		if ( !XPos('G',Switches,1) )
			Switches=Switches+'G';

		Call DoSearch;
		if ( Return_Int && Global_Int('Found_Count') )
		{
			Block_LineX=tblx;
			Block_ColX=tbcx;
		}
		Block_Stat=tbs;
		Marking=tm;
		Refresh=True;
		Goto_Line(C_Line);
		Goto_Col(C_Col);
		Redraw;
	}
	else
	{
		while ( 0!=(Return_Int=XPos('R',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);

		while ( 0!=(Return_Int=XPos('G',Switches,1)) )
			Switches=Str_Del(Switches,Return_Int,1);

		Call DoSearch;
	}
	Goto Exit;

DoSearch:
	Set_Global_Str('Switches',Switches);
	Set_Global_Int('Search_Mode',0);
	Set_Global_Int('REPSearch',1);
	Mark_Pos;
	if ( XPos('B',Switches,1) )
		Left;
	else
	{
		Right;
		while ( !At_EOL && (Cur_Char=='|255') )
			Right;
	}
	rm('MeUtil2^S_AND_R');
	if ( Return_Int && !Global_Int('Found_Count') )
		Goto_Mark;
	else
		Pop_Mark;
	ret;

Exit:
}

macro TRANSLAT TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:	 TRANSLAT

Description:  Mimics Brief's Translate macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	int OldRefresh=Refresh;
	str	REPL_Switches=Caps(Global_Str('REPL_Switches'));

	Push_Undo;
	Mark_Pos;

	if ( 0!=(Return_Int=XPos('B',REPL_Switches,1)) )
		REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);

	if ( Block_Stat )
	{
		int	tblx=Block_LineX,tbcx=Block_ColX,
				tbs=Block_Stat,tm=Marking;

		if ( Block_Line1==tblx )
			if ( ((Block_Stat==1)&&(Block_Line1!=Block_Line2))||
					((Block_Stat!=1)&&(Block_Col1==tbcx)) )
			{
				tblx=Block_Line2;
				tbcx=Block_Col2;
			}

		if ( !XPos('R',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'R';
		if ( !XPos('G',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'G';

		Call DoSearch;
		if ( Return_Int && Global_Int('Found_Count') )
		{
			Block_LineX=tblx;
			Block_ColX=tbcx;
		}
		Block_Stat=tbs;
		Marking=tm;
		Refresh=True;
		Goto_Line(C_Line);
		Goto_Col(C_Col);
		Redraw;
	}
	else
	{
		while ( 0!=(Return_Int=XPos('R',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);

		while ( 0!=(Return_Int=XPos('G',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);

		Call DoSearch;
	}
	Goto Exit;
DoSearch:
	Set_Global_Str('REPL_Switches',REPL_Switches);
	Set_Global_Int('Search_Mode',1);
	Set_Global_Int('RepSearch',0);
  if (Global_Int('~SR_MODAL') != 0) {
    RM( 'S_AND_R '+mparm_str);
  } else {
    RM('SRCHINTR /M=1/H=' + SRCHREP_HELPLINK + '/SRG=SEARCH_STR/RPG=REPLACE_STR');
  }
	ret;

Exit:
	switch ( Return_Int )
	{
		case 0 :
		case 3 :
			Pop_Mark;
			break;

		case 1 :
		case 2 :
		case 4 :
			Goto_Mark;
			break;
	}
	Pop_Undo;
}

macro XLAT_BWD TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		XLAT_BWD

Description:  Mimics Brief's Translate_Back macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/

	int OldRefresh=Refresh;
	str	REPL_Switches=Caps(Global_Str('REPL_Switches'));

	Push_Undo;
	Mark_Pos;

	if ( !XPos('B',REPL_Switches,1) )
		REPL_Switches=REPL_Switches+'B';

	if ( Block_Stat )
	{
		int	tblx=Block_LineX,tbcx=Block_ColX,
				tbs=Block_Stat,tm=Marking;

		if ( Block_Line2==tblx )
			if ( ((Block_Stat==1)&&(Block_LIne1!=Block_Line2))||
					((Block_Stat!=1)&&(Block_Col2==tbcx)) )
			{
				tblx=Block_Line1;
				tbcx=Block_Col1;
			}

		if ( !XPos('R',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'R';
		if ( !XPos('G',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'G';

		Call DoSearch;
		if ( Return_Int && Global_Int('Found_Count') )
		{
			Block_LineX=tblx;
			Block_ColX=tbcx;
		}
		Block_Stat=tbs;
		Marking=tm;
		Refresh=True;
		Goto_Line(C_Line);
		Goto_Col(C_Col);
		Redraw;
	}
	else
	{
		while ( 0!=(Return_Int=XPos('R',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);

		while ( 0!=(Return_Int=XPos('G',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);

		Call DoSearch;
	}
	Goto Exit;

DoSearch:
	Set_Global_Str('REPL_Switches',REPL_Switches);
	Set_Global_Int('Search_Mode',1);
	Set_Global_Int('RepSearch',0);
  if (Global_Int('~SR_MODAL') != 0) {
    RM( 'S_AND_R '+mparm_str);
  } else {
    RM('SRCHINTR /M=1/H=' + SRCHREP_HELPLINK + '/SRG=SEARCH_STR/RPG=REPLACE_STR');
  }
	ret;

Exit:
	switch ( Return_Int )
	{
		case 0 :
		case 3 :
			Pop_Mark;
			break;

		case 1 :
		case 2 :
		case 4 :
			Goto_Mark;
			break;
	}
	Pop_Undo;
}

macro XLAT_AGA TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:		XLAT_AGA

Description:  Mimics Brief's Translate_Again macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/
	int OldRefresh=Refresh;
	str	REPL_Switches=Caps(Global_Str('REPL_Switches'));

	Push_Undo;
	Mark_Pos;
	if ( Block_Stat )
	{
		int	tblx=Block_LineX,tbcx=Block_ColX,
				tbs=Block_Stat,tm=Marking;

		if ( XPos('B',REPL_Switches,1) )
		{
			if ( Block_Line2==tblx )
				if ( ((Block_Stat==1)&&(Block_LIne1!=Block_Line2))||
						((Block_Stat!=1)&&(Block_Col2==tbcx)) )
				{
					tblx=Block_Line1;
					tbcx=Block_Col1;
				}
		}
		else
		{
			if ( Block_Line1==tblx )
				if ( ((Block_Stat==1)&&(Block_Line1!=Block_Line2))||
						((Block_Stat!=1)&&(Block_Col1==tbcx)) )
				{
					tblx=Block_Line2;
					tbcx=Block_Col2;
				}
		}

		if ( !XPos('R',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'R';
		if ( !XPos('G',REPL_Switches,1) )
			REPL_Switches=REPL_Switches+'G';

		Call DoSearch;
		if ( Return_Int && Global_Int('Found_Count') )
		{
			Block_LineX=tblx;
			Block_ColX=tbcx;
		}
		Block_Stat=tbs;
		Marking=tm;
		Refresh=True;
		Goto_Line(C_Line);
		Goto_Col(C_Col);
		Redraw;

	}
	else
	{
		while ( 0!=(Return_Int=XPos('R',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);

		while ( 0!=(Return_Int=XPos('G',REPL_Switches,1)) )
			REPL_Switches=Str_Del(REPL_Switches,Return_Int,1);

		Call DoSearch;
	}
	Goto Exit;

DoSearch:
	Set_Global_Str('REPL_Switches',REPL_Switches);
	Set_Global_Int('Search_Mode',1);
	Set_Global_Int('REPSearch',1);
	Mark_Pos;
	if ( XPos('B',REPL_Switches,1) )
		Left;
	else
	{
		Right;
		while ( !At_EOL && (Cur_Char=='|255') )
			Right;
	}
  if ( !Global_Int('~SR_MODAL') ) {
    if ( Global_Int('!hSRDialog') == 0 ) {
      sreturn_int = 555;
    }
  }
	rm('MeUtil2^S_AND_R');
	if ( Return_Int && !Global_Int('Found_Count') )
		Goto_Mark;
	else
		Pop_Mark;
	ret;

Exit:
	Refresh=OldRefresh;
	switch ( Return_Int )
	{
		case 0 :
		case 3 :
			Pop_Mark;
			break;

		case 1 :
		case 2 :
		case 4 :
			Goto_Mark;
			break;
	}
	Pop_Undo;
}

macro WRITE_IT TRANS {

//  Completed
// _ Stubbed
//  Tested

/*****************************************************************************
																MULTI-EDIT MACRO

Name:	 WRITE_IT

Description:  Mimics Brief's Write_It macro

							 (C) Copyright 1994 by American Cybernetics, Inc.
******************************************************************************/
	if ( Block_Stat )
	{
		RM('MEUTIL1^SAVEBLCK');
		if ( Return_Int )
			Block_Off;
	}
	else
		RM('MEUTIL1^SAVEFILE ' + MParm_Str);
}

macro B_GreyENTER {

//  Completed
// _ Stubbed
//  Tested

/*******************************************************************************
																MULTI-EDIT MACRO

Name:		B_GreyENTER

Description:	Mimics the use of the <GreyENTER> key in brief

							 (C) Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/
	int tr=Refresh,ti=Insert_Mode;

	Refresh=False;
	Insert_Mode=True;
	Mark_Pos;
	Goto_Col(1);
	Set_Indent_Level;
	Goto_Mark;
//	Cr;
	RM("CR");
	Insert_Mode=ti;
	Refresh=tr;
}

macro SVFilesStatus {

//  Completed
// _ Stubbed
//  Tested

/*******************************************************************************
																MULTI-EDIT MACRO

Name:  SVFilesStatus

Description:	Saves all changed files and optionally the current status of
							editor.

Parameters:		/S= - if Non-Zero will save the status of the editor.

							 (C) Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/

	Rm( "AutoSave" );
	if ( Parse_Int( "/S=", MParm_Str ) ) {
		Rm( "Status" );
	}
}  // SVFilesStatus

int SetWinRedraw( int RedrawOn = Parse_Int( "/ON=", MParm_Str ) ) {
/******************************************************************************
															 Multi-Edit Macro
															 13-Sep-95  12:44

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int OldRedrawOff = g_WinRedrawOff;

	if ( RedrawOn ) {
	 	// Here we are going to turn on the windows redraw flag
	 	if ( OldRedrawOff ) {
	 		g_WinRedrawOff = False;
			SendMessage( Frame_Handle, WM_SETREDRAW, 1, 0 );
			RedrawWindow( Frame_Handle, 0, 0, RDW_FRAME | RDW_ALLCHILDREN |
					RDW_INVALIDATE );
	 	}
	}
  else {
		// Here we are going to turn off the windows redraw flag
		if ( !OldRedrawOff ) {
			if ( IsWindowVisible( Frame_Handle ) ) {
				if ( ( SendMessage( Frame_Handle, WM_MDIGETACTIVE, 0, 0 ) >> 16 ) == 0 ) {
					g_WinRedrawOff = True;
					SendMessage( Frame_Handle, WM_SETREDRAW, 0, 0 );
				}
			}
		}
	}
	return ( OldRedrawOff );

}  // SetWinRedraw

int BrSpecialWindow( ) {
/******************************************************************************
															 Multi-Edit Macro
															 21-Sep-95  11:21

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	Return_Int = ( ( Window_Name == "OUTPUT" ) || ( Window_Name == "BUFFER" ) ||
			XPos( "-Cmpr", Window_Name, 1 ) || HexEnabled( ) );
	return ( Return_Int );

}  // BrSpecialWindow

int BrSetCurWindow( ) {
/******************************************************************************
															 Multi-Edit Macro
																9/13/95 4:54PM

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	if ( !BrSpecialWindow( ) && ( Caps( File_Name ) != "?NO-FILE?" ) ) {
//		Beep;
		g_BrCurWindow = Window_Id;
	}
}  // BrSetCurWindow

int BrFindBuffer(
			int BufferId = Parse_Int( "/B=", MParm_Str ),
			int RetWinId = Parse_Int( "/ID=", MParm_Str ),
			int Visible	 = Parse_Int( "/VIS=", MParm_Str )
)
/******************************************************************************
															 Multi-Edit Macro
															 12-Sep-95  12:29

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/
{
	int SavRefresh = Refresh;
	int ActiveWin	 = Window_Id;
	int Result 		 = 0;
	int Jx;

	Refresh = False;
	if ( Visible ) {
		g_BrCurBuffer = 0;
	}
	for ( Jx = 1; Jx <= Window_Count; ++Jx ) {
		Switch_Window( Jx );
		if ( Buffer_Id == BufferId ) {
			if ( Visible ) {
				if ( !g_BrCurBuffer ) {
					g_BrCurBuffer = Window_Id;
				}
				if ( ( Window_Attr & 0x01 ) != 0 ) {
					continue;
				}
			}
			if ( RetWinId ) {
				Result = Window_Id;
			}
			else {
				Result = Cur_Window;
			}
			break;
		}
	}
	Switch_Win_Id( ActiveWin );
	Refresh = SavRefresh;
	return ( Return_Int = Result );

}  // BrFindBuffer

int BrSyncCursorPos( int WindowNum, int DoResize ) {
/******************************************************************************
															 Multi-Edit Macro
															 25-Aug-95  12:32

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int SavRefresh		= Refresh;
	int ActiveWin			= Window_Id;
	int ActiveBufId		= Buffer_Id;
	int BufWinId			= 0;
	int T_Col					= C_Col;
	int T_Row					= C_Row;
	int T_Line				= C_Line;
	int T_Screen_Num  = Screen_Num;
	int T_Left_Offset = Left_Offset;
	int WinRedrawOff	= g_WinRedrawOff;
	int SavWinAttr;
	int SavCRow;

	struct TWindowPlacement Twp;

	if ( DoResize ) {
		// Turn windows redraw off
		SetWinRedraw( False );
		Twp.Length = 22;
		GetWindowPlacement( Window_Handle, &Twp );
	}
	Refresh = False;
	if ( WindowNum ) {
		Switch_Window( WindowNum );
		call DoSize;
	}
	else {
		Switch_Window( Window_Count );
		do {
  		Switch_Window( Cur_Window + 1 );
			call DoSize;
		} while ( Window_Id != ActiveWin );
	}
	if ( DoResize ) {
		if ( !WinRedrawOff && g_WinRedrawOff ) {
			SetWinRedraw( True );
		}
	}
	Refresh = SavRefresh;
	return ( BufWinId );


DoSize:
	if ( ( Window_Id != ActiveWin ) && ( Buffer_Id == ActiveBufId ) ) {
		if ( !BufWinId ) {
			BufWinId = Window_Id;
		}
		if ( Window_Attr & 0x81 == 1 ) {
			if ( DoResize ) {
				SavWinAttr = Window_Attr;
				Window_Attr = 0;
				Make_Window_Visible( True );
				SetWindowPlacement( Window_Handle, &Twp );
				Window_Attr = SavWinAttr;
			}
			while ( C_Row < T_Row ) {
				SavCRow = C_Row;
				Down;
				if ( C_Row == SavCRow ) {
					break;
				}
			}
			while ( C_Row > T_Row ) {
				Up;
			}
			Left_Offset = T_Left_Offset;
			Goto_Line( T_Line );
			Goto_Col( T_Col );
		}
	}
	ret;

}  // BrSyncCursorPos

int BrMakeBuffer( ) {
/******************************************************************************
															 Multi-Edit Macro
															 12-Sep-95  13:46

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int LinkWin			= Cur_Window;
	int SavRefresh	= Refresh;
	int ActiveWinId	= Window_Id;
	int Result;

	Refresh = False;
	Create_Window;
	Window_Attr = 0x01; 								// make it hidden
	Make_Window_Visible( True );
	Result = Window_Id;
	Link_Window( LinkWin );
	LinkWin = Cur_Window;
	Switch_Win_Id( ActiveWinId );
	BrSyncCursorPos( LinkWin, True );
	Rm( "SetWindowNames" );
	Refresh = SavRefresh;
	return ( Return_Int = Result );

}  // BrMakeBuffer

void BrMakeSpecialWin( )
/******************************************************************************
															 Multi-Edit Macro
																01/08/96 13:58

	Function: Create a new visible window when current window is linked.
	Entry   : None
	Exit    : Return_Int = New window_id

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	if ( Link_Stat ) {
		Switch_Win_Id( BrMakeBuffer( ) );
		Window_Attr &= 0xFFFE;
		Screen_Num = 0;
	}
}  // BrMakeSpecialWin

int BrSwitchBuffer(
			int Prev 		 = Parse_Int( "/PREV=", MParm_Str ),
			int LinkWin	 = Parse_Int( "/NEWBUFF=", MParm_Str ),
			int NoNewBuf = Parse_Int( "/NOMAKENEW=", MParm_Str ),
			int NoLink	 = Parse_Int( "/NOLINK=", MParm_Str ),
			int Visible	 = Parse_Int( "/VIS=", MParm_Str )
) {
/******************************************************************************
															 Multi-Edit Macro
															 12-Sep-95  12:44

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	if ( BrSpecialWindow( ) ) {
		Make_Message( "Can't show another buffer in this window." );
		return ( Return_Int = False );
	}

	int ActiveWinId	 = Window_Id;
	int ActiveBufId	 = Buffer_Id;
	int ActiveWinNo;
	int SavWinAttr;

	if ( Visible ) {
		if ( Switch_Win_Id( g_BrCurWindow ) ) {
			if ( Buffer_Id != ActiveBufId ) {
				Switch_Win_Id( ActiveWinId );
				if ( Switch_Win_Id( BrFindBuffer( Buffer_Id, True, True ) ) ) {
					goto SelVisible;
				}
			}
			else {

SelVisible:
				ActiveWinNo = Cur_Window;
				SavWinAttr = Window_Attr;
				Window_Attr = 0x01;
				Switch_Win_Id( ActiveWinId );
				BrSyncCursorPos( ActiveWinNo, False );
				Window_Attr = SavWinAttr;
				return ( Return_Int = g_BrCurBuffer );
			}
		}
	}
	if ( LinkWin == Window_Id ) {
		Switch_Win_Id( g_BrCurWindow );
	}

	int ActiveScrNum = Screen_Num;
	int BufferWinId	 = Window_Id;
	int SavRefresh	 = Refresh;
	int Direction		 = 1;
	int BufferFound	 = True;
	int ChangeRedraw = False;
	int WinZoomed		 = IsZoomed( Window_Handle );
	int SystemWin;

	ActiveWinId = Window_Id;
	ActiveBufId = Buffer_Id;
	Refresh = False;
	if ( !Switch_Win_Id( LinkWin ) ) {
		if ( Link_Stat ) {
			Switch_Win_Id( g_BrCurBuffer );
			if ( Buffer_Id != ActiveBufId ) {
				BufferWinId = BrFindBuffer( ActiveBufId, True, False );
			}
			else {
				BufferWinId = Window_Id;
			}
		}
		Switch_Win_Id( BufferWinId );
		if ( Prev ) {
			Direction = -1;
		}
		while ( True ) {
			Switch_Window( Cur_Window + Direction );
			Rm( "FindWin /HIDDEN=1/B=" + Str( Prev ) );
			if ( Window_Id == BufferWinId ) {
				Make_Message( "No other \"buffers\"" );
				Switch_Win_Id( ActiveWinId );
				BufferFound = False;
			}
			else if ( ( Buffer_Id == ActiveBufId ) || !( Window_Attr & 0x01 ) ) {
				continue;
			}
			LinkWin = BrFindBuffer( Buffer_Id, True, False );
			break;
		}
	}
	if ( BufferFound ) {
		BufferFound = LinkWin;
		Switch_Win_Id( ActiveWinId );
		if ( !NoLink ) {
			// turn Windows redraw off
//			if ( !g_WinRedrawOff ) {
//				SetWinRedraw( False );
//				ChangeRedraw = True;
//			}
			// make sure this window has a "buffer" before linking with another
			if ( !NoNewBuf ) {
				if ( !Link_Stat ) {
					// hide current window
					Window_Attr |= 0x01;
					Make_Window_Visible( True );
					Screen_Num = 0;
					ActiveWinId = BrMakeBuffer( );
				}
			}
			Switch_Win_Id( LinkWin );
			Window_Attr |= 0x01;
			Make_Window_Visible( True );
			g_BrCurBuffer = Window_Id;
			LinkWin = Cur_Window;
			SystemWin = Window_Attr & 0x80;
			Switch_Win_Id( ActiveWinId );
			if ( Link_Stat ) {
				BufferWinId = BrSyncCursorPos( 0, False );
			}
			Link_Window( LinkWin );
			if ( ( Cur_Window < LinkWin ) && !SystemWin ) {
				LinkWin = BrMakeBuffer( );
				if ( Switch_Win_Id( ActiveWinId ) ) {
					Delete_Window;
				}
				Switch_Win_Id( LinkWin );
			}
//      g_BrCurWindow = Window_Id;
			Screen_Num = ActiveScrNum;
			Window_Attr &= 0xFFFE;
			if ( WinZoomed ) {
				Make_Window_Visible( 3 );
			}
			else {
				Make_Window_Visible( True );
			}
			Rm( "SetWindowNames" );
//			if ( ChangeRedraw ) {
//				SetWinRedraw( True );
//			}
		}
	}
	Refresh = SavRefresh;
	Redraw;
	return ( Return_Int = BufferFound );

}  // BrSwitchBuffer

void BrDelSpecialWin( )
/******************************************************************************
															 Multi-Edit Macro
																01/08/96 14:28

	Function: When the current window is linked to another window, delete it and
						switch to the current visible Brief buffer.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	str FName = File_Name;

	if ( Link_Stat ) {
		Delete_Window;
		Switch_Win_Id( g_BrCurWindow );
		if ( FName != File_Name ) {
			Switch_File( FName );
			Rm( "Select_Window /VIS=1/BM=1" );
		}
		Rm( "SetWindowNames" );
	}
	else {
		Rm( "SetWindowNames" );
		BrSwitchBuffer( 0, Window_Id, False, False, False );
	}
}  // BrDelSpecialWin

macro BrDeleteBuffer trans {

	int SavRefresh   = Refresh;

	if ( BrSpecialWindow( ) ) {

		int ErrWinTop 	 = 0;
		int ErrWinBottom = 0;
		int DelOutput    = ( Window_Name == "OUTPUT" );
		int SavWinAttr;

		struct TWindowPlacement Twp;

		Refresh = False;
		if ( DelOutput ) {
			Twp.Length = 22;
			GetWindowPlacement( Window_Handle, &Twp );
			ErrWinTop = Twp.rcNormPos_Top;
			ErrWinBottom = Twp.rcNormPos_Bottom;

      Delete_Window;

			for ( int Jx = Window_Count; Jx; --Jx ) {
				Switch_Window( Jx );
				if ( ( Window_Attr & 0x81 ) == 0 ) {
					GetWindowPlacement( Window_Handle, &Twp );
					if ( Twp.rcNormPos_Bottom == ErrWinTop ) {
						SavWinAttr = Window_Attr;
						Twp.rcNormPos_Bottom = ErrWinBottom;
						SetWindowPlacement( Window_Handle, &Twp );
						Window_Attr = SavWinAttr;
						Make_Window_Visible( True );
					}
				}
			}
		}
		else {
			Delete_Window;
			Switch_Win_Id( g_FcSelWin );
			BrDelSpecialWin( );
		}
		Refresh = SavRefresh;
		return ( );
	}

	int NoRelink			 = Parse_Int( "/NORELINK=", MParm_Str );
	int ActiveScrNum 	 = Parse_Int( "/SCREEN=", MParm_Str );
	int WinVisible		 = ( Window_Attr & 0x81 ) == 0;
	int ActiveWinId 	 = Window_Id;
	int ActiveBufId	 	 = Buffer_Id;
	int ActiveLinkStat = Link_Stat;
	int Result 				 = False;
	int LinkCnt			 	 = 0;
	int NewWinId;
	int NewLinkWin;

	Refresh = False;
	if ( ActiveScrNum < 1 ) {
		ActiveScrNum = Screen_Num;
	}
	// first, find out if there is only 1 buffer left.
	do {
		Switch_Window( Cur_Window + 1 );
		Rm( "FindWin /HIDDEN=1" );
		if ( ( Buffer_Id == ActiveBufId ) && ( Window_Id != ActiveWinId ) ) {
			NewLinkWin = Window_Id;
		}
	} while ( ( Buffer_Id == ActiveBufId ) && ( Window_Id != ActiveWinId ) );

	if ( Window_Id == ActiveWinId ) {
		// we came full circle, this means no other buffers.
		Delete_Window;
		Switch_Win_Id( NewLinkWin );
		Rm( "WINDOW^DelWin /NB=1" );
		g_BrCurWindow = 0;
		g_BrCurBuffer = 0;
	}
	else {
		Switch_Win_Id( ActiveWinId );
		Rm( "USERIN^CheckFile /H=" );
		if ( Return_Int > 0 ) {
			Result = True;
			if ( ActiveLinkStat ) {
				// make a list of all windows linked to current buffer so we can deal
				// with them later on
				do {
					Switch_Window( Cur_Window + 1 );
					if ( ( Buffer_Id == ActiveBufId ) && ( Window_Id != ActiveWinId ) ) {
						if ( BrSpecialWindow( ) ) {
							for ( ; LinkCnt > 0; --LinkCnt ) {
								Set_Global_Int( "B_T_WIN_" + Str( LinkCnt ), 0 );
							}
							Switch_Win_Id( ActiveWinId );
							BrErrorMsg( "Can't delete buffer linked to a special window." );
							Refresh = SavRefresh;
							Return_Int = False;
							return ( );
						}
						Set_Global_Int( "B_T_WIN_" + Str( ++LinkCnt ), Window_Id );
					}
				} while ( Window_Id != ActiveWinId );
			}
			if ( !( !ActiveLinkStat && !WinVisible ) ) {
				NewLinkWin = BrSwitchBuffer( False, 0, True, !WinVisible, False );
				Switch_Win_Id( NewLinkWin );
				NewLinkWin = Cur_Window;
			}
			if ( ActiveLinkStat ) {
				// this window was linked to other window(s), deal with them
				for ( ; LinkCnt > 0; --LinkCnt ) {
					Switch_Win_Id( Global_Int( "B_T_WIN_" + Str( LinkCnt ) ) );
					if ( ( Window_Attr & 0x81 ) == 0 ) {
						// it is on the same visible screen, relink with new buffer.
						Link_Window( NewLinkWin );
						Refresh = True;
						Redraw;
						Refresh = False;
					}
					Set_Global_Int( "B_T_WIN_" + Str( LinkCnt ), 0 );
				}
			}
			if ( Switch_Win_Id( BrFindBuffer( ActiveBufId, True, False ) ) ) {
				Delete_Window;
			}
			if ( WinVisible ) {
				Switch_Win_Id( ActiveWinId );
			}
			else {
				for ( int Jx = Window_Count; Jx; --Jx ) {
					Switch_Window( Jx );
					if ( ( Window_Attr & 0x81 ) == 0 ) {
						break;
					}
				}
			}
			Rm( "SetWindowNames" );
		}
	}
	Refresh = SavRefresh;
	New_Screen;
//	Redraw;
	Return_Int = Result;

}  // B_Delete_Buffer

void BrBufferList( ) trans {
/******************************************************************************
															 Multi-Edit Macro
															 24-Aug-95  15:52

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int Active_Win = Window_Id;
	int SavRefresh = Refresh;
	int WinSpecial = BrSpecialWindow( );
	int NewWinId;

	Rm( "WinMenu /WT=Buffer List/HE=1/DB=0/DC=1/NL=1/NR=1/NH=1" + MParm_Str );

	if ( Return_Int > 0 ) {
		if ( Cur_Window != Return_Int ) {
			Refresh = False;
			Switch_Window( Return_Int );
			NewWinId = Window_Id;
			if ( !BrSpecialWindow( ) ) {
				if ( WinSpecial ) {
					Switch_Win_Id( g_BrCurWindow );
				}
				else {
 					Switch_Win_Id( Active_Win );
				}
				BrSwitchBuffer( 0, NewWinId, False, False, False );
			}
			Refresh = SavRefresh;
		}
	}
	Redraw;

}  // Buf_List

macro BrCreateEdge trans {

	if ( BriefMode ) {

		str TStr 	 = Parse_Str( "/DIR=", MParm_Str );
		str DirStr = "RIGHTLEFT UP   DOWN ";

		int ActiveWindow = Window_Id;
		int SavRefresh 	 = Refresh;
		int SplitCnt 	 	 = Global_Int( _SplitCntGlo + Str( Screen_Num ) );
		int OutWinTop 	 = 0;
		int LinkWin;
		int NewWindow;
		int NewLinkWin;
		int CurScreenNum;
		int Result;

		struct TRect Client_Rect;
		struct TWindowPlacement Twp;

		if ( BrSpecialWindow( ) ) {
			BrErrorMsg( "Can't create edge from this window." );
		}
		else if ( ( ( Win_X2 - Win_X1 ) < 10 ) || ( ( Win_Y2 - Win_Y1 ) < 3 ) ) {
			// current window is already too small
			BrErrorMsg( "Window too small to split!" );
		}
		else {
			// check to see if we can create a new window
			Rm( "MakeWin /NC=1/NL=1" );
			if ( Error_Level ) {
				Rm( "MessageBox /B=1/M=The maximum combination of windows and \"buffers" +
						"\" has been reached.  You can use DELETE CURRRENT BUFFER to make " +
						"room for more windows." );
			}
			else {
				Refresh = False;
				if ( Svl( TStr ) != 0 ) {
					Result = XPos( TStr, DirStr, 1 );
					if ( Result ) {
						Result = ( Result / 5 ) + 11;
					}
				}
				else {
					Result = SplitWinDlg( "Split Window", 0 );
				}
				if ( Result != 0 ) {
					for ( int Jx = Window_Count; Jx; --Jx ) {
						Switch_Window( Jx );
						if ( Window_Name == "OUTPUT" ) {
							Twp.Length = 22;
							if ( GetWindowPlacement( Window_Handle, &Twp ) ) {
								OutWinTop = Twp.rcNormPos_Top;
							}
							break;
						}
					}
					Switch_Win_Id( ActiveWindow );
					if ( !SplitCnt ) {
						// make window fill client area minus OUTPUT window when found
						GetClientRect( Client_Handle, &Client_Rect );
						Twp.Length = 22;
						if ( GetWindowPlacement( Window_Handle, &Twp ) ) {
							Twp.rcNormPos_Left   = 0;
							Twp.rcNormPos_Top    = 0;
							Twp.rcNormPos_Right  = Client_Rect.Right;
							if ( OutWinTop ) {
								Twp.rcNormPos_Bottom = OutWinTop;
							}
							else {
								Twp.rcNormPos_Bottom = Client_Rect.Bottom;
							}
							SetWindowPlacement( Window_Handle, &Twp );
						}
						SendMessage( Client_Handle, WM_MDIRESTORE, Window_Handle, 0 );
					}
					Create_Window;
					Make_Window_Visible( True );
					NewWindow = Window_Id;
					Switch_Win_Id( ActiveWindow );
					LinkWin = Cur_Window;
					Rm( "SplitWin /ID=" + Str( NewWindow ) + "/DIR=" +
							Remove_Space( Copy( DirStr, ( ( Result - 11 ) * 5 ) + 1, 5 ) ) );
					Link_Window( LinkWin );
	//				Screen_Num = CurScreenNum;
//          g_BrCurWindow = Window_Id;
					Rm( "SetWindowNames" );
					Set_Global_Int( _SplitCntGlo + Str( Screen_Num ), ++SplitCnt );
					Refresh = SavRefresh;
					Redraw;
				}
			}
		}
	}
	else {
		Rm( "WINDOW^WinOp /T=4" );
	}
}  // BrCreateEdge

macro BrDeleteEdge trans {

	if ( BriefMode ) {
		if ( BrSpecialWindow( ) ) {
			BrErrorMsg( "Can't delete edge from this window." );
			return ( );
		}

		str TStr 				= Parse_Str( "/DIR=", MParm_Str );
		str SplitCntGlo = _SplitCntGlo + Str( Screen_Num );
		str DirStr 			= "RIGHTLEFT UP   DOWN ";

		int SavRefresh 		= Refresh;
		int ActiveWinId 	= Window_Id;
		int SavCur_Window = Cur_Window;
		int SplitCnt 			= Global_Int( SplitCntGlo );
		int OutputWin 		= False;
		int DoRemove 			= False;
		int NewWindow;
		int Direction;
		int Result;

		struct TWindowPlacement OrgTwp;
		struct TWindowPlacement CurTwp;

		OrgTwp.Length = 22;
		CurTwp.Length = 22;

		Refresh = False;
		Rm( "Screen_Share" );
		if ( Return_Int & 0x7F ) {
			Refresh = False;
			// if this window is not linked to any other, create a "buffer" and link to it
			if ( Svl( TStr ) != 0 ) {
				Result = XPos( TStr, DirStr, 1 );
				if ( Result ) {
					Result = ( Result / 5 ) + 11;
				}
			}
			else {
				Result = SplitWinDlg( "Edge to delete", Return_Int );
			}
			if ( Result != 0 ) {
				Direction = Result - 10;
				GetWindowPlacement( Window_Handle, &CurTwp );
				for ( int Jx = Window_Count; Jx; --Jx ) {
					Switch_Window( Jx );
					if ( Window_Name == "OUTPUT" ) {
						OutputWin = Window_Id;
						break;
					}
				}
				Switch_Win_Id( Parse_Int( "/" + Str( Direction ) + "=",
						Global_Str( "!Screen_Share" ) ) );

				if ( ( Window_Name != "OUTPUT" ) || !OutputWin ) {
					GetWindowPlacement( Window_Handle, &OrgTwp );
					if ( ( Direction == 1 ) || ( Direction == 2 ) ) {
						if ( ( CurTwp.rcNormPos_Top == OrgTwp.rcNormPos_Top ) &&
								( CurTwp.rcNormPos_Bottom == OrgTwp.rcNormPos_Bottom ) ) {
							DoRemove = True;
						}
					}
					else if ( ( Direction == 3 ) || ( Direction == 4 ) ) {
						if ( ( CurTwp.rcNormPos_Left == OrgTwp.rcNormPos_Left ) &&
								( CurTwp.rcNormPos_Right == OrgTwp.rcNormPos_Right ) ) {
							DoRemove = True;
						}
					}
					if ( DoRemove ) {
						if ( !Link_Stat ) {
							BrMakeBuffer( );
						}
						Rm( "DelWin /NB=1" );
						Switch_Win_Id( ActiveWinId );
						switch ( Direction ) {
							case 1 :  // Right
								CurTwp.rcNormPos_Right = OrgTwp.rcNormPos_Right;
								break;

							case 2 :  // Left
								CurTwp.rcNormPos_Left = OrgTwp.rcNormPos_Left;
								break;

							case 3 :  // Up
								CurTwp.rcNormPos_Top = OrgTwp.rcNormPos_Top;
								break;

							case 4 :  // Down
								CurTwp.rcNormPos_Bottom = OrgTwp.rcNormPos_Bottom;
								break;
						}
						SetWindowPlacement( Window_Handle, &CurTwp );
						if ( --SplitCnt < 1 ) {
							if ( !OutputWin ) {
								SendMessage( Client_Handle, WM_MDIMAXIMIZE, Window_Handle, 0 );
							}
							Screen_Num = 0;
							SplitCnt = 0;
						}
						Set_Global_Int( SplitCntGlo, SplitCnt );
					}
					else {
						Switch_Win_Id( ActiveWinId );
						BrErrorMsg( "Edge doesn't have just one adjoining window." );
					}
				}
				else {
					Switch_Win_Id( ActiveWinId );
					BrErrorMsg( "Can't delete output window edge." );
				}
			}
			Refresh = SavRefresh;
			Redraw;
		}
	}
	else {
		Rm( "WINDOW^WinOp /T=1" );
	}
}  // B_Delete_Edge

void B_Save_File( ) trans {
/******************************************************************************
															 Multi-Edit Macro
															 24-Aug-95  22:25

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int SavRefresh 		 = Refresh;
	int SavWindow_Attr = Window_Attr;
	int Dlg;

	str Title = "This buffer has not been saved.";

	Window_Attr = 0;
	Refresh = True;
	Redraw;

	DlgCreate( Dlg );

	DlgAddCtrl( Dlg, DLG_Icon, "IC_QUESTION",
			1, 1,
			0, 0,
			100,0, "" );

	DlgAddCtrl( Dlg, DLG_Static, "Delete?",
			8, 2,
			0, 2,
			101, 0, "" );

  DlgAddCtrl( Dlg, DLG_PushButton, "&Yes",
			1, dlg_PosOffset | dlg_Units | ( dlg_Units_QLine * 5 ),
			DLG_StanBtnWidth, 0,
			110, 0, "/R=1" );

  DlgAddCtrl( Dlg, DLG_PushButton, "&No",
			dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
			DLG_StanBtnWidth, 0,
			111, 0, "/R=0" );

  DlgAddCtrl( Dlg, DLG_PushButton, "&Write",
			dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
			DLG_StanBtnWidth, 0,
			112, 0, "/R=3" );

  DlgAddCtrl( Dlg, DLG_PushButton, "&Help",
			dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
			DLG_StanBtnWidth, 0,
			112, 0, "/R=2" );

	Return_Int = DlgExecute( Dlg, 110, Title, "", "", 0 );
	if ( Return_Int == 3 ) {
		Error_Level = 0;
		Save_File;
		if ( Error_Level ) {
			Rm( "MeError" );
			Return_Int = -1;
		}
	}
	DlgKill( Dlg );
	Window_Attr = SavWindow_Attr;
	Refresh = SavRefresh;

}  // B_Save_File

#ifdef Windows
macro Brief_Vcs_Menu( ) {


// special macro that can be attached to <Alt+V>.


	struct tpoint tp;
	int x, y;





		//GetCaretPos( &tp );
		GetCursorPos( &tp );
		tp.x += 3;


	ClientToscreen( window_handle, &tp );
	int Menu = CreateMenuFromDB( wcmdmapname, "VCS", MENU_Popup );

	if(Menu)
	{
		TrackPopupMenu( menu,
					0x0000 /* TPM_LEFTALIGN */  | 0x0002 /* TPM_RIGHTBUTTON */,
					tp.x, tp.y,0,frame_handle,0 );
		destroymenu( menu );
	}
	{		make_message('unable to popup VCS.MNU menu');
	}

}
#endif

#ifndef Windows
macro BriefInstall {

// _ Completed
//  Stubbed        // undef _BWindowStyle for windows version
//  Tested

	Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $02);
	Set_Global_Str('@KEYMAP_NAME@','KN=BRIEFFN=BRIEF');
}
#endif

void BriefInit( ) {
/******************************************************************************
															 Multi-Edit Macro
																8/28/95 3:16PM

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	BriefMode = True;

}  // BriefInit

void B_Edit_File( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "MEUTIL1^LoadFile /E=1" );

}  // B_Edit_File

void B_Del_Char( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "MESYS^Del /I=1" );

}  // B_Del_Char

void To_Top( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "MESYS^TopWin /ML=1" );

}  // To_Top

void To_Botto( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "MESYS^BotWin /ML=1" );

}  // To_Botto

void Brief_Tab_Left( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "MESYS^Tab /M=1" );

}  // Brief_Tab_Left

void Brief_Tab_Right( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "MESYS^Tab /M=0" );

}  // Brief_Tab_Right

void SetGlobalBkMrk( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "TEXT^Set_Mark " + MParm_Str );

}  // SetGlobalBkMrk

void GetGlobalBkMrk( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "TEXT^Get_Mark" );

}  // GetGlobalBkMrk

void Open_Lin( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "MESYS^Cr /NS=1" );

}  // Open_Lin

void Buf_List( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "WINDOW^WinOp /T=3" );

}  // Buf_List

void B_Delete_Buffer( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "WINDOW^WinOp /T=1" );

}  // B_Delete_Buffer

void Edit_Next_Buffer( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "WINDOW^NextWin" );

}  // Edit_Next_Buffer

void Edit_Prev_Buffer( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "WINDOW^LastWin" );

}  // Edit_Prev_Buffer

void B_Create_Edge( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "BrCreateEdge" );

}  // B_Create_Edge

void B_Delete_Edge( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "BrDeleteEdge" );

}  // B_Delete_Edge

void Next_Err( ) {
/******************************************************************************
															 Multi-Edit Macro
															 06-Dec-95  13:48

	Function: Stub for the old Brief keymap to run the new Brief command.

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/

	Rm( "CmpError " + MParm_Str );

}  // Next_Err
