/****************************g************************************************
 *
 *  HPSJUSD.H
 *
 *  Microsoft Confidential
 *  Copyright (c) Microsoft Corporation 1996-1997
 *  All rights reserved
 *
 ***************************************************************************/

#define WIN32_LEAN_AND_MEAN

#include <windows.h>

#pragma intrinsic(memcmp,memset)

#include <objbase.h>

#include "sti.h"
#include "stierr.h"
#include "stiusd.h"

/*
 * Class IID's
 */
#if defined( _WIN32 ) && !defined( _NO_COM)

//  {E9FA3320-7F3F-11D0-90EA-00AA0060F86C}
DEFINE_GUID(CLSID_SclUsdObj, 0xE9FA3320L, 0x7F3F, 0x11D0, 0x90, 0xEA, 0x00, 0xAA, 0x00, 0x60, 0xF8, 0x6C);

//  {59eb1ee0-8339-11d0-b22d-080009eebdf6}
DEFINE_GUID(CLSID_HPSJDOSUsdObj, 0x59EB1EE0L, 0x8339, 0x11D0, 0xB2, 0x2D, 0x08, 0x00, 0x09, 0xEE, 0xBD, 0xF6);

#endif


#define DATASEG_PERINSTANCE     ".instance"
#define DATASEG_SHARED          ".shared"
#define DATASEG_READONLY        ".code"

#define DATASEG_DEFAULT         DATASEG_SHARED

#pragma data_seg(DATASEG_PERINSTANCE)

// Set the default data segment
#pragma data_seg(DATASEG_DEFAULT)

//
// Module ref counting
//
extern UINT g_cRefThisDll;
extern UINT g_cLocks;

extern BOOL DllInitializeCOM(void);
extern BOOL DllUnInitializeCOM(void);

extern void DllAddRef(void);
extern void DllRelease(void);

//
// Class definition for object
//

class UsdHPSJDevice :  public IStiUSD
{
private:
    ULONG       m_cRef;
    BOOL        m_fValid;
    LPTYPEINFO  m_ptinfo;
    BOOL        m_bRaiseException;
    EXCEPINFO   m_excepinfo;
    LPUNKNOWN   m_punkOuter;
    PSTIDEVICECONTROL   m_pDcb;
    WCHAR       m_szDeviceName[MAX_PATH];
    HANDLE      m_DeviceDataHandle;
    DWORD       m_dwLastOperationError;

    BOOL inline IsValid(VOID) {
        return m_fValid;
    }

public:
    // *** IUnknown methods ***
    STDMETHODIMP QueryInterface( REFIID riid, LPVOID * ppvObj);
    STDMETHODIMP_(ULONG) AddRef( void);
    STDMETHODIMP_(ULONG) Release( void);

    /*** IStiUSD methods ***/
    STDMETHOD(Initialize) (THIS_ PSTIDEVICECONTROL pHelDcb,DWORD dwStiVersion,HKEY hParametersKey)  ;
    STDMETHOD(GetCapabilities) (THIS_ PSTI_USD_CAPS pDevCaps)  ;
    STDMETHOD(GetStatus) (THIS_ PSTI_DEVICE_STATUS pDevStatus)  ;
    STDMETHOD(DeviceReset)(THIS )  ;
    STDMETHOD(Diagnostic)(THIS_ LPDIAG pBuffer)  ;
    STDMETHOD(Escape)(THIS_ STI_RAW_CONTROL_CODE    EscapeFunction,LPVOID  lpInData,DWORD   cbInDataSize,LPVOID pOutData,DWORD dwOutDataSize,LPDWORD pdwActualData)   ;
    STDMETHOD(GetLastError) (THIS_ LPDWORD pdwLastDeviceError)  ;
    STDMETHOD(LockDevice) (THIS )  ;
    STDMETHOD(UnLockDevice) (THIS )  ;
    STDMETHOD(RawReadData)(THIS_ LPVOID lpBuffer,LPDWORD lpdwNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(RawWriteData)(THIS_ LPVOID lpBuffer,DWORD nNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(RawReadCommand)(THIS_ LPVOID lpBuffer,LPDWORD lpdwNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(RawWriteCommand)(THIS_ LPVOID lpBuffer,DWORD nNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(SetNotificationHandle)(THIS_ HANDLE hEvent)  ;
    STDMETHOD(GetNotificationData)(THIS_ LPSTINOTIFY   lpNotify)  ;

    UsdHPSJDevice(LPUNKNOWN punkOuter);
    ~UsdHPSJDevice();
};

typedef UsdHPSJDevice *PUsdHPSJDevice;

class UsdHPSJDOSDevice :  public IStiUSD
{
private:
    ULONG       m_cRef;
    BOOL        m_fValid;
    LPTYPEINFO  m_ptinfo;
    BOOL        m_bRaiseException;
    EXCEPINFO   m_excepinfo;
    LPUNKNOWN   m_punkOuter;
    PSTIDEVICECONTROL   m_pDcb;
    WCHAR       m_szDeviceName[MAX_PATH];
    HANDLE      m_DeviceDataHandle;
    DWORD       m_dwLastOperationError;

    BOOL inline IsValid(VOID) {
        return m_fValid;
    }

public:
    // *** IUnknown methods ***
    STDMETHODIMP QueryInterface( REFIID riid, LPVOID * ppvObj);
    STDMETHODIMP_(ULONG) AddRef( void);
    STDMETHODIMP_(ULONG) Release( void);

    /*** IStiUSD methods ***/
    STDMETHOD(Initialize) (THIS_ PSTIDEVICECONTROL pHelDcb,DWORD dwStiVersion,HKEY hParametersKey)  ;
    STDMETHOD(GetCapabilities) (THIS_ PSTI_USD_CAPS pDevCaps)  ;
    STDMETHOD(GetStatus) (THIS_ PSTI_DEVICE_STATUS pDevStatus)  ;
    STDMETHOD(DeviceReset)(THIS )  ;
    STDMETHOD(Diagnostic)(THIS_ LPDIAG pBuffer)  ;
    STDMETHOD(Escape)(THIS_ STI_RAW_CONTROL_CODE    EscapeFunction,LPVOID  lpInData,DWORD   cbInDataSize,LPVOID pOutData,DWORD dwOutDataSize,LPDWORD pdwActualData)   ;
    STDMETHOD(GetLastError) (THIS_ LPDWORD pdwLastDeviceError)  ;
    STDMETHOD(LockDevice) (THIS )  ;
    STDMETHOD(UnLockDevice) (THIS )  ;
    STDMETHOD(RawReadData)(THIS_ LPVOID lpBuffer,LPDWORD lpdwNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(RawWriteData)(THIS_ LPVOID lpBuffer,DWORD nNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(RawReadCommand)(THIS_ LPVOID lpBuffer,LPDWORD lpdwNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(RawWriteCommand)(THIS_ LPVOID lpBuffer,DWORD nNumberOfBytes,LPOVERLAPPED lpOverlapped)  ;
    STDMETHOD(SetNotificationHandle)(THIS_ HANDLE hEvent)  ;
    STDMETHOD(GetNotificationData)(THIS_ LPSTINOTIFY   lpNotify)  ;

    UsdHPSJDOSDevice(LPUNKNOWN punkOuter);
    ~UsdHPSJDOSDevice();
};

typedef UsdHPSJDOSDevice *PUsdHPSJDOSDevice;

//
// Prototypes for flat thunk functions, used for accessing DOS compatible device
//
extern "C" BOOL WINAPI filedos_ThunkConnect32(LPSTR, LPSTR, DWORD, DWORD);

extern "C" short _stdcall ScannerLock(short hWnd, short bLock);
extern "C" long _stdcall RecFromScanner(BYTE* pBuffer, long Length, LONG TermChar);
extern "C" long _stdcall SendToScanner(BYTE* pBuffer, long Length);

// Module names, used for thunk connection
#define STR_MODULE32_NAME   "hpusd.DLL"
#define STR_MODULE16_NAME   "hpsjthk.DLL"

//
// Syncronization mechanisms
//
#define ENTERCRITICAL   DllEnterCrit(void);
#define LEAVECRITICAL   DllLeaveCrit(void);


