/****************************************************************************
 *
 *  DEVICE.CPP
 *
 *  Microsoft Confidential
 *  Copyright (c) Microsoft Corporation 1996-1997
 *  All rights reserved
 *
 ***************************************************************************/

#include "hpsjusd.h"
#include "sclbuton.h"


UsdHPSJDevice::UsdHPSJDevice( LPUNKNOWN punkOuter ):
    m_cRef(1),
    m_punkOuter(NULL),
    m_fValid(FALSE),
    m_pDcb(NULL),
    m_DeviceDataHandle(INVALID_HANDLE_VALUE)
{
    *m_szDeviceName = L'\0';

    m_fValid = TRUE;
}

UsdHPSJDevice::~UsdHPSJDevice( VOID )
{
    if( INVALID_HANDLE_VALUE != m_DeviceDataHandle )
    {
        CloseHandle( m_DeviceDataHandle );
    }
}


//
// *** IUnknown methods ***
//

/* Note that we AddRef through the public UNknown
 * (i.e., through the controlling unknown).
 * That's part of the rules of aggregation,
 * and we have to follow them in order to keep the controlling
 * unknown from getting confused.
 */
STDMETHODIMP UsdHPSJDevice::QueryInterface( REFIID riid, LPVOID* ppvObj )
{
    HRESULT hres;

    if( !IsValid() || !ppvObj )
    {
        return STIERR_INVALID_PARAM;
    }

    *ppvObj = NULL;

    if( IsEqualIID( riid, IID_IUnknown ))
    {
        *ppvObj = (LPUNKNOWN)(PSTIUSD)this;
        m_punkOuter->AddRef();
        hres = S_OK;
    }
    else if( IsEqualIID( riid, IID_IStiUSD ))
    {
        *ppvObj = (PSTIUSD)this;
        AddRef();
        hres = S_OK;
    }

    else
    {
        hres =  STIERR_NOINTERFACE;
    }

    return hres;
}


STDMETHODIMP_(ULONG) UsdHPSJDevice::AddRef( VOID )
{
    ULONG ulRef;
    ulRef = InterlockedIncrement((LPLONG)&m_cRef);
    return ulRef;
}

STDMETHODIMP_(ULONG) UsdHPSJDevice::Release( VOID )
{
    ULONG ulRef;
    ulRef = InterlockedDecrement((LPLONG)&m_cRef);

    if(!ulRef)
    {
        delete this;
    }
    return ulRef;
}


STDMETHODIMP UsdHPSJDevice::GetCapabilities( PSTI_USD_CAPS pUsdCaps )
{
    HRESULT hres = STI_OK;

    ZeroMemory(pUsdCaps,sizeof(*pUsdCaps));

    // Set that we are only pass-through, requiring serialization
    pUsdCaps->dwVersion = STI_VERSION;

    return hres;
}

STDMETHODIMP UsdHPSJDevice::GetStatus( PSTI_DEVICE_STATUS pDevStatus )
{
    HRESULT hres = STI_OK;
	
    pDevStatus->dwOnlineState = STI_ONLINESTATE_OPERATIONAL;

    //
    // Verify state of the button
    //
    if (pDevStatus->StatusMask & STI_DEVSTATUS_EVENTS_STATE ) {

        BYTE    ButtonReadBuffer[LEN_INQUIRE_BUTTON_READ+1];
        DWORD   ReadLength = LEN_INQUIRE_BUTTON_READ;
        BYTE    Zero = 0;

        ZeroMemory(ButtonReadBuffer,sizeof(ButtonReadBuffer));

        hres = RawWriteData( (void*)INQUIRE_BUTTON, LEN_INQUIRE_BUTTON, NULL );
        hres = RawReadData( ButtonReadBuffer, &ReadLength, NULL );

        if( !SUCCEEDED( hres ) || (ReadLength < 9)) {
            return hres;
        }

        if ( ButtonReadBuffer[8] == '1' ) {
            //Button push detected
            pDevStatus->dwEventHandlingState |=STI_EVENTHANDLING_PENDING;
        }

    }

    return hres;
}

STDMETHODIMP UsdHPSJDevice::DeviceReset( VOID )
{
    HRESULT hres = STI_OK;

    // Reset current active device
    if (INVALID_HANDLE_VALUE != m_DeviceDataHandle)
    {
        // Reset scanner
        BYTE Buffer[3] = "\033E";
        m_dwLastOperationError = RawWriteData( Buffer, sizeof(Buffer), NULL );
    }

    hres = HRESULT_FROM_WIN32(m_dwLastOperationError);

    return hres;
}

STDMETHODIMP UsdHPSJDevice::Diagnostic( LPDIAG pBuffer )
{
    HRESULT hres = STI_OK;

    // Initialize response buffer
    pBuffer->dwStatusMask = 0;
    pBuffer->dwGenericError = NOERROR;
    pBuffer->dwVendorError = 0;

    // turn on lamp
    m_dwLastOperationError = RawWriteData( "\033*f1L", 6, NULL );
    hres = HRESULT_FROM_WIN32(m_dwLastOperationError);
    if( !SUCCEEDED( hres )) {
        pBuffer->dwGenericError = m_dwLastOperationError;
        return hres;
    }

    SleepEx( 2000, FALSE );

    // turn off lamp
    m_dwLastOperationError = RawWriteData( "\033*f0L", 6, NULL );
    hres = HRESULT_FROM_WIN32(m_dwLastOperationError);
    if( !SUCCEEDED( hres )) {
        pBuffer->dwGenericError = m_dwLastOperationError;
        return hres;
    }

    // get status string
    m_dwLastOperationError = RawWriteData( "\033*f2T", 6, NULL );
    hres = HRESULT_FROM_WIN32(m_dwLastOperationError);
    if( !SUCCEEDED( hres )) {
        pBuffer->dwGenericError = m_dwLastOperationError;
        return hres;
    }

    // m_dwLastOperationError = RawWriteData( "\033*s10485E", 9, NULL );
    m_dwLastOperationError = RawWriteData( "\033*s5E", 9, NULL );
    hres = HRESULT_FROM_WIN32(m_dwLastOperationError);
    if( !SUCCEEDED( hres )) {
        pBuffer->dwGenericError = m_dwLastOperationError;
        return hres;
    }

    DWORD Length = 30;
    BYTE Buffer[30];

    ZeroMemory(Buffer,sizeof(Buffer));

    m_dwLastOperationError = RawReadData( Buffer, &Length, NULL );
    if( !SUCCEEDED( hres )) {
        pBuffer->dwGenericError = STIERR_GENERIC;
        return hres;
    }

    hres = HRESULT_FROM_WIN32(m_dwLastOperationError);
    if( !SUCCEEDED( hres )) {
        pBuffer->dwGenericError = m_dwLastOperationError;
        return hres;
    }

    if( Buffer[10] != 'P' && Buffer[8] != 'd') {
        pBuffer->dwGenericError = STIERR_GENERIC;
    }

    return hres;
}

STDMETHODIMP UsdHPSJDevice:: SetNotificationHandle( HANDLE hEvent )
{
    HRESULT hres = STI_OK;

    return hres;
}


STDMETHODIMP UsdHPSJDevice::GetNotificationData( LPSTINOTIFY pBuffer )
{
    HRESULT hres = STI_OK;

    return hres;
}

STDMETHODIMP UsdHPSJDevice::Escape( STI_RAW_CONTROL_CODE    EscapeFunction,
                                    LPVOID                  pInData,
                                    DWORD                   cbInDataSize,
                                    LPVOID                  pOutData,
                                    DWORD                   cbOutDataSize,
                                    LPDWORD                 pcbActualData )
{
    HRESULT hres = STI_OK;
    //
    // Write indata to device  if needed.
    //

    return hres;
}

STDMETHODIMP UsdHPSJDevice::GetLastError( LPDWORD pdwLastDeviceError )
{
    HRESULT hres = STI_OK;

    if ( IsBadWritePtr( pdwLastDeviceError,4 ))
    {
        hres = STIERR_INVALID_PARAM;
    }
    else
    {
        *pdwLastDeviceError = m_dwLastOperationError;
    }

    return hres;
}

STDMETHODIMP UsdHPSJDevice::LockDevice( VOID )
{
    HRESULT hres = STI_OK;

    return hres;
}

STDMETHODIMP UsdHPSJDevice::UnLockDevice( VOID )
{
    HRESULT hres = STI_OK;

    return hres;
}

STDMETHODIMP UsdHPSJDevice::RawReadData( LPVOID lpBuffer, LPDWORD lpdwNumberOfBytes,
                                        LPOVERLAPPED lpOverlapped )
{
    HRESULT hres = STI_OK;
    BOOL    fRet;
    DWORD   dwBytesReturned = 0;

    if (INVALID_HANDLE_VALUE != m_DeviceDataHandle)
    {
        fRet = ReadFile( m_DeviceDataHandle,
                         lpBuffer,
                         *lpdwNumberOfBytes,
                         &dwBytesReturned,
                         lpOverlapped );

        m_dwLastOperationError = ::GetLastError();
        hres = fRet ? STI_OK : HRESULT_FROM_WIN32(m_dwLastOperationError);

        *lpdwNumberOfBytes = (fRet) ? dwBytesReturned : 0;

    }
    else
    {
        hres = STIERR_NOT_INITIALIZED;
    }

    return hres;
}

STDMETHODIMP UsdHPSJDevice::RawWriteData( LPVOID lpBuffer, DWORD dwNumberOfBytes,
                                            LPOVERLAPPED lpOverlapped )
{
    HRESULT hres = STI_OK;
    BOOL    fRet;
    DWORD   dwBytesReturned = 0;

    if (INVALID_HANDLE_VALUE != m_DeviceDataHandle)
    {
        fRet = WriteFile(m_DeviceDataHandle,lpBuffer,dwNumberOfBytes,&dwBytesReturned,lpOverlapped);
        m_dwLastOperationError = ::GetLastError();
        hres = fRet ? STI_OK : HRESULT_FROM_WIN32(m_dwLastOperationError);
    }
    else
    {
        hres = STIERR_NOT_INITIALIZED;
    }

    return hres;
}

STDMETHODIMP UsdHPSJDevice::RawReadCommand( LPVOID lpBuffer, LPDWORD lpdwNumberOfBytes,
                                            LPOVERLAPPED lpOverlapped )
{
    HRESULT hres = STIERR_UNSUPPORTED;

    return hres;
}

STDMETHODIMP UsdHPSJDevice::RawWriteCommand( LPVOID lpBuffer, DWORD nNumberOfBytes,
                                            LPOVERLAPPED lpOverlapped )
{
    HRESULT hres = STIERR_UNSUPPORTED;

    return hres;
}


STDMETHODIMP UsdHPSJDevice::Initialize( PSTIDEVICECONTROL pDcb, DWORD dwStiVersion,
                                        HKEY hParametersKey )
{
    HRESULT hres = STI_OK;
    CHAR    *pszDeviceNameA = NULL;
    UINT    uiNameLen = 0;

    if (!pDcb)
    {
        hres = STIERR_INVALID_PARAM;
    }
    else
    {
        // Check STI specification version number
        m_pDcb = pDcb;
        m_pDcb->AddRef();

        // Get the name of the device port we need to open
        hres = m_pDcb->GetMyDevicePortName(m_szDeviceName,sizeof(m_szDeviceName)/sizeof(WCHAR));
        if (!SUCCEEDED(hres) || !*m_szDeviceName)
        {
            return hres;
        }

        // Convert name to SBCS for use in WIn95
        uiNameLen = WideCharToMultiByte(CP_ACP, 0, m_szDeviceName, -1, NULL, NULL, 0, 0);
        if (!uiNameLen)
        {
            return STIERR_INVALID_PARAM;
        }

        pszDeviceNameA = new CHAR[uiNameLen+1];
        if (!pszDeviceNameA)
        {
            return STIERR_INVALID_PARAM;
        }

        WideCharToMultiByte(CP_ACP, 0, m_szDeviceName, -1, pszDeviceNameA, uiNameLen, 0, 0);

        // Open device ourselves
        m_DeviceDataHandle = CreateFileA( pszDeviceNameA,
                                         GENERIC_READ | GENERIC_WRITE, // Access mask
                                         0,                            // Share mode
                                         NULL,                         // SA
                                         OPEN_EXISTING,                // Create disposition
                                         FILE_ATTRIBUTE_SYSTEM,        // Attributes
                                         NULL );
        m_dwLastOperationError = ::GetLastError();

        if (pszDeviceNameA)
        {
            delete pszDeviceNameA;
            pszDeviceNameA = NULL;
        }

        hres = (m_DeviceDataHandle != INVALID_HANDLE_VALUE) ?
                    S_OK : MAKE_HRESULT(SEVERITY_ERROR,FACILITY_WIN32,m_dwLastOperationError);

    }

    return hres;
}



