/******************************************************************************

  winx.h
  Windows utility procedures

  Copyright (c) 1997 Microsoft Corporation
  All rights reserved

Notes:
  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
  PURPOSE.

******************************************************************************/


// macros
#define	RANDBYTE(r)		LOBYTE(rand() % ((r)+1))

#ifdef _DEBUG
#define TRAP { _asm int 3 }
#else
#define TRAP {}
#endif

// stringtables
typedef struct _STRINGTABLE
{
	long	number;
	char 	*szString;
	long	end;
} STRINGTABLE, *PSTRINGTABLE;

/*
STRINGTABLE StSample[] =
{
	0, "String zero",0,
	1, "String one",0,
    0, "",-1
};

Retrieve strings associated with unique values:
  strString = StrFromTable(nValue,&StSample);

*/

// WINERROR.H - GetLastError errors
STRINGTABLE StWinerror[] =
{
	ERROR_SUCCESS,				"ERROR_SUCCESS",0,
	ERROR_INVALID_FUNCTION,		"ERROR_INVALID_FUNCTION",0,
	ERROR_ACCESS_DENIED,		"ERROR_ACCESS_DENIED",0,
	ERROR_INVALID_HANDLE,		"ERROR_INVALID_HANDLE",0,
	ERROR_INVALID_PARAMETER,	"ERROR_INVALID_PARAMETER",0,
	ERROR_CALL_NOT_IMPLEMENTED,	"ERROR_CALL_NOT_IMPLEMENTED",0,
	RPC_S_SERVER_UNAVAILABLE,	"RPC_S_SERVER_UNAVAILABLE",0,
    0, "",-1
};


// prototypes
ULONG	atox(LPSTR);
void	DisplayDebug(LPSTR sz,...);
BOOL	ErrorMsg(HWND,LPSTR,LPSTR,BOOL);
BOOL	fDialog(int,HWND,FARPROC);
void	FormatHex(unsigned char *,char *);
BOOL	GetFinalWindow (HANDLE,LPRECT,LPSTR,LPSTR);
BOOL	LastError(BOOL);
int		NextToken(char *,char *);
BOOL	SaveFinalWindow (HANDLE,HWND,LPSTR,LPSTR);
char *  StrFromTable(long,PSTRINGTABLE);
BOOL	Wait32(DWORD);

