/******************************************************************************

  scan2dib.h
  Simple test of WDM Still Image Class

  Copyright (c) 1997 Microsoft Corporation
  All rights reserved

Notes:
  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
  PURPOSE.

******************************************************************************/

#include "resource.h"

//
// global defines
//
#define	LONGSTRING	    			256         // big strings
#define	MEDSTRING	    			128         // medium strings
#define	SHORTSTRING	    			32          // little strings

//
// reset listbox window display after this many iterations
//
#define MAX_LOOP 16383

//
// INF defines
//
#define	INFBUFSIZ					0x8000      // assume 32k for largest INF

//
// current test status defines
//
#define STATUS_SUCCESS				0			// SUCCESS
#define STATUS_NEXT					1			// run next test
#define STATUS_PRIOR				2			// re-run last test
#define STATUS_TERSE				3			// stop writing to log
#define STATUS_VERBOSE				4			// start writing to log
#define STATUS_PAUSE				5			// PAUSE pause
#define STATUS_EXIT					6			// EXIT end of script exit
#define STATUS_ERROR				7			// can continue error
#define STATUS_FATAL				8			// cannot continue error

// timers
#define	TIMER_INF  					3001


//
// misc local functions
//
void	DisplayOutput(LPSTR,...);
int		EndTest(HWND,int);
BOOL	FirstInstance(HANDLE);
HWND	MakeWindow(HANDLE);
int		ParseCmdLine(LPSTR);

//
// windows message handlers
//
BOOL	CommandParse(HWND,UINT,WPARAM,LPARAM);
BOOL	Creation(HWND,UINT,WPARAM,LPARAM);
BOOL	Destruction(HWND,UINT,WPARAM,LPARAM);
BOOL	HScroll(HWND,UINT,WPARAM,LPARAM);
BOOL	VScroll(HWND,UINT,WPARAM,LPARAM);

//
// exported functions
//
long FAR PASCAL WiskProc(HWND,UINT,WPARAM,LPARAM);


//
// GLOBAL VARIABLES
//

//
// global window handles
//
HANDLE		hThisInstance;				// current instance
HWND		hThisWindow;				// current window
HMENU		hMenu;						// current menu

//
// general purpose strings
//
HGLOBAL		hLHand[5];					// utility string handles 
LPSTR		lpzString;					// utility string
PSTR		pszOut,                     // TextOut string
			pszMsg,                     // generic NEAR string 1
			pszString,                  // generic NEAR string 2
			pszCommand,					// current INF command
			pszComment;					// any comments

//
// global test settings
//
int 		nAuto       = 0,            // 1 = run 60 second timed test
			nError      = 0,			// number of errors
			nFatal      = 0,    		// can't continue after this...
			nGo         = 0,			// 1 = nonstop timed test
			nLastLine   = 1,    		// last line number in script
			nNextLine   = 1,    		// next line of inf to run
			nNextTest   = 0,    		// next test to run
			nRunInf     = 0,			// 0 = no INF, 1 = INF is loaded
			nRadix      = 10,			// base is decimal (or hex)
			nSaveLog    = 0,    		// always write out log
   			nScriptLine = 1,			// next script line to parse
			nStatus     = 0,			// state of the tests
			nTimeState  = 0,			// 0 timer is off, 1 timer is on
			nTime       = 10000;		// SetTimer in 1000's of seconds
DWORD		dwLastError = 0;			// last GetLastError found

//
// text display
//
HWND		hLogWindow;
ULONG		ulCount1,ulCount2;
int			cxChar,cxCaps,cyChar,cxClient,cyClient,iMaxWidth,
			iHscrollPos,iHscrollMax,
			iVscrollPos,iVscrollMax;

//
// inf, logfile handles
//
HANDLE		hLog = NULL;				// output log file handle
char		szInfName[LONGSTRING] = "",	// input INF file name
			szLogName[LONGSTRING] = "";	// output log file name
LPSTR		lpInf = NULL,				// buffer for INF commands
			lpLine;

