/******************************************************************************

  scan2dib.cpp
  Simple test of WDM Still Image Class

  Copyright (c) 1997 Microsoft Corporation
  All rights reserved

Notes:
  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
  PURPOSE.

******************************************************************************/

#pragma warning (disable:4001)	        // ignore '//' comments

#define 	_X86_   1
#define 	WIN32_LEAN_AND_MEAN 1

#define 	INITGUID

#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>          	    // rand()
#include	<string.h>                  // strcat
#include	<time.h>                    // srand(time())

#include	<sti.h>						// Still Image services
#include	<scanner.h>					// SCL commands

#include	"scan2dib.h" 				// scan2dib local includes
#include	"resource.h" 				// resource defines

#include	"winx.cpp"					// private utility windows procedures
#include	"wsti.cpp"					// the actual STI interface code


/******************************************************************************
  BOOL CommandParse(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)

  Handle user menu and button commands.
******************************************************************************/
BOOL CommandParse(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
	int		nReturn = 0;	// generic return value


	switch(wParam)
	{
	case IDM_ENUM:
		StiEnum();
		break;
	case IDM_SELECT:
		StiSelect(hWnd);
		break;
	case IDM_LAMPON:
		StiLamp(ON);
		break;
	case IDM_LAMPOFF:
		StiLamp(OFF);
		break;
	case IDM_SCAN:
		StiScan(hWnd);
		break;
	case IDM_SHOWDIB:
		DisplayScanDIB(hWnd);
		break;
	default:
		break;
	}
	// always return 0
	return 0;
}


/******************************************************************************
  BOOL TimerParse(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)

  Each timer tick, decide whether to run the next test, repeat a prior test,
  end testing, or shut everything down.
******************************************************************************/
BOOL TimerParse(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
	int		nReturn = 0;	// generic return value


	switch (nStatus)
	{
	case STATUS_NEXT:
		break;
	case STATUS_PRIOR:
		break;
	case STATUS_SUCCESS:
		break;
	case STATUS_EXIT:
		break;
	case STATUS_ERROR:
		break;
	case STATUS_FATAL:
		// Cannot continue error. Shut app down.
		PostMessage(hWnd,WM_CLOSE,0,0);
		break;
	default:
		break;
	}
	// always return 0
	return 0;
}


/******************************************************************************
  int EndTest(HWND hWnd,int nNumTest)

  After each test run cleanup.
******************************************************************************/
int EndTest(HWND hWnd,int nNumTest)
{
	int		nReturn = 0;	// generic return value


	// shut off timer
	KillTimer(hWnd,TIMER_INF);

	// close any open still imaging devices
	StiClose();

	DisplayOutput("Testing complete: there were %d errors",nError);

	// reset current line, errors
	nError = nNextLine = 0;

	return nReturn;
}


/******************************************************************************
  BOOL SizeDiff(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)

  Output redraw handler when window size changes.
******************************************************************************/
BOOL SizeDiff(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
  	RECT rcClient;


	GetClientRect(hWnd,&rcClient);
	SetWindowPos(hLogWindow,NULL,0,0,
		rcClient.right+(GetSystemMetrics(SM_CXBORDER)*2),
		rcClient.bottom+(GetSystemMetrics(SM_CXBORDER)*2),
		SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
	// always return 0
	return 0;
}


/******************************************************************************
  BOOL HScroll(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)

  Horizontal scroll handler.
******************************************************************************/
BOOL HScroll(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
    int iHscrollInc;
	

	switch (LOWORD (wParam))
	{
	case SB_LINEUP :
		iHscrollInc = -1 ;
		break ;
		
	case SB_LINEDOWN :
		iHscrollInc = 1 ;
		break ;

	case SB_PAGEUP :
		iHscrollInc = -8 ;
		break ;

	case SB_PAGEDOWN :
		iHscrollInc = 8 ;
		break ;

	case SB_THUMBPOSITION :
		iHscrollInc = HIWORD(wParam) - iHscrollPos ;
		break ;

	default :
		iHscrollInc = 0 ;
	}
   iHscrollInc = max (-iHscrollPos,
                 min (iHscrollInc, iHscrollMax - iHscrollPos)) ;

   if (iHscrollInc != 0)
   {
	   iHscrollPos += iHscrollInc ;
	   ScrollWindow (hWnd, -cxChar * iHscrollInc, 0, NULL, NULL) ;
	   SetScrollPos (hWnd, SB_HORZ, iHscrollPos, TRUE) ;
   }
	// always return 0
	return 0;
}


/******************************************************************************
  BOOL VScroll(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)

  Vertical scroll handler.
******************************************************************************/
BOOL VScroll(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
    int iVscrollInc;

	
	switch (LOWORD (wParam))
	{
	case SB_TOP :
		iVscrollInc = -iVscrollPos ;
		break ;
		
	case SB_BOTTOM :
		iVscrollInc = iVscrollMax - iVscrollPos ;
		break ;
	        
	case SB_LINEUP :
		iVscrollInc = -1 ;
		break ;
        
	case SB_LINEDOWN :
		iVscrollInc = 1 ;
		break ;

	case SB_PAGEUP :
		iVscrollInc = min (-1, -cyClient / cyChar) ;
		break ;
        
	case SB_PAGEDOWN :
		iVscrollInc = max (1, cyClient / cyChar) ;
		break ;
        
	case SB_THUMBTRACK :
		iVscrollInc = HIWORD (wParam) - iVscrollPos ;
		break ;
        
	default :
		iVscrollInc = 0 ;
	}
   iVscrollInc = max (-iVscrollPos,
                 min (iVscrollInc, iVscrollMax - iVscrollPos)) ;

   if (iVscrollInc != 0)
   {
	   iVscrollPos += iVscrollInc ;
	   ScrollWindow (hWnd, 0, -cyChar * iVscrollInc, NULL, NULL) ;
	   SetScrollPos (hWnd, SB_VERT, iVscrollPos, TRUE) ;
	   UpdateWindow (hWnd) ;
   }
	// always return 0
	return 0;
}


/******************************************************************************
  BOOL Creation(HWND,UINT,WPARAM,LPARAM)

  Initialization and global allocation.
  Return 0 to continue creation of window, -1 to abort
******************************************************************************/
BOOL Creation(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
	TEXTMETRIC	tm;
	RECT		rRect;
	HDC			hDC;


	// seed random generator
	srand((unsigned)time(NULL));

	// create the 5 display and utility strings
	if (! ((hLHand[0] = LocalAlloc(LPTR,LONGSTRING)) &&
		(pszOut = (PSTR) LocalLock(hLHand[0]))))
	    return -1;
	if (! ((hLHand[1] = LocalAlloc(LPTR,LONGSTRING)) &&
		(pszMsg = (PSTR) LocalLock(hLHand[1]))))
	    return -1;
	if (! ((hLHand[2] = LocalAlloc(LPTR,LONGSTRING)) &&
		(pszString = (PSTR) LocalLock(hLHand[2]))))
	    return -1;
	if (! ((hLHand[3] = LocalAlloc(LPTR,LONGSTRING)) &&
		(pszCommand = (PSTR) LocalLock(hLHand[2]))))
	    return -1;
	if (! ((hLHand[4] = LocalAlloc(LPTR,LONGSTRING)) &&
		(pszComment = (PSTR) LocalLock(hLHand[2]))))
	    return -1;

	// create output display window
	hDC = GetDC(hWnd);
	GetTextMetrics(hDC,&tm);
	
	cxChar = tm.tmAveCharWidth ;
   	cxCaps = (tm.tmPitchAndFamily & 1 ? 3 : 2) * cxChar / 2 ;
   	cyChar = tm.tmHeight + tm.tmExternalLeading ;
	iMaxWidth = 40 * cxChar + 22 * cxCaps ;

	ReleaseDC(hWnd,hDC);
		
	GetClientRect(hWnd,&rRect);

	if (NULL == (hLogWindow = CreateWindow("LISTBOX",NULL,
		WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL | LBS_NOINTEGRALHEIGHT,
		0,0,rRect.right,rRect.bottom,hWnd,NULL,
		(HINSTANCE)GetWindowLong(hWnd,GWL_HINSTANCE),NULL)))
		return -1;

	// create the DIB to display scanned image
	if (CreateScanDIB(hWnd))
		return -1;

	// return 0 to continue creation of window
	return 0;
}


/******************************************************************************
  BOOL Destruction(HWND,UINT,WPARAM,LPARAM)

  Current instance termination routines.
  Free error message buffer, send destroy window message.
  Note that if Creation() fails, pszMessage is 0.
******************************************************************************/
BOOL Destruction(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
	int		x;	// loop counter


	LoadString(hThisInstance,IDS_PRIVINI,pszMsg,LONGSTRING);
	LoadString(hThisInstance,IDS_PRIVSECTION,pszString,LONGSTRING);

	SaveFinalWindow(hThisInstance,hWnd,pszMsg,pszString);

	// free the 5 display and utility strings
	for (x = 0;x < 5;x++)
	{
		LocalUnlock(hLHand[x]);
		LocalFree(hLHand[x]);
	}

	// delete the DIB object
	GdiFlush();
	DeleteObject(hDIBSection);

	// free the output and main windows
	DestroyWindow(hLogWindow);
	DestroyWindow(hWnd);

	// always return 0
	return 0;
}


/******************************************************************************
  BOOL FirstInstance(HANDLE)

  Register the window.
  Return TRUE/FALSE on success/failure.
******************************************************************************/
BOOL FirstInstance(HANDLE hInst)
{
   PWNDCLASS	pClass;
   PSTR			pszClass;


	if (! (pszClass = (PSTR) LocalAlloc(LPTR, LONGSTRING)))
		return FALSE;
	LoadString(hInst, IDS_CLASSNAME, pszClass, LONGSTRING);

	pClass = (PWNDCLASS) LocalAlloc(LPTR, sizeof(WNDCLASS));

	// set hbrBackground to 0 for no background (app draws background)
	// use COLOR_BACKGROUND+1 for desktop color
	pClass->style          = CS_HREDRAW | CS_VREDRAW;
	pClass->lpfnWndProc    = WiskProc;
	pClass->cbClsExtra     = 0;
	pClass->cbWndExtra     = 0;
	pClass->hInstance      = hInst;
	pClass->hIcon          = LoadIcon(hInst, MAKEINTRESOURCE(IDI_SCAN1));
	pClass->hCursor        = LoadCursor((HANDLE) NULL, IDC_ARROW);
	pClass->hbrBackground  = (HBRUSH) (COLOR_WINDOW + 1);
	pClass->lpszMenuName   = NULL;
	pClass->lpszClassName  = (LPSTR) pszClass;

	if (! (RegisterClass((LPWNDCLASS) pClass)))
		return FALSE;

	LocalFree((HANDLE) pClass);
	LocalFree((HANDLE) pszClass);

	return TRUE;
}


/******************************************************************************
  HWND MakeWindow(HANDLE)

  Create a window for current instance.
  Return handle to window (which is 0 on failure)
******************************************************************************/
HWND MakeWindow(HANDLE hInst)
{
	HWND	hWindow;
	PSTR	pszA,pszB;
	RECT	rect;

	// if we can't get string memory, shut down app
	if (pszA = (PSTR) LocalAlloc(LPTR, LONGSTRING))
	{
		if (! (pszB = (PSTR) LocalAlloc(LPTR, LONGSTRING)))
		{
			LocalFree((HANDLE) pszA);
			return FALSE;
		}
	}
	else
		return FALSE;

	// get the caption, classname
	LoadString(hInst, IDS_PRIVINI, pszA, LONGSTRING);
	LoadString(hInst, IDS_PRIVSECTION, pszB, LONGSTRING);

	GetFinalWindow(hInst,&rect,pszA,pszB);

	LoadString(hInst,IDS_CAPTION,pszA,LONGSTRING);
	LoadString(hInst,IDS_CLASSNAME,pszB,LONGSTRING);

	hWindow = CreateWindow((LPSTR) pszB,
		(LPSTR) pszA,
		WS_OVERLAPPEDWINDOW,
		rect.left,
		rect.top,
		rect.right,
		rect.bottom,
		(HWND) NULL,
		0,
		hInst,
		NULL);

	// Save Instance globally
	hThisInstance = hInst;

	LocalFree((HANDLE) pszB);
	LocalFree((HANDLE) pszA);

	return hWindow;
}


/******************************************************************************
  void DisplayOutput(LPSTR pString,...)

  Show text on the display window
******************************************************************************/
void DisplayOutput(LPSTR pString,...)
{
	char	Buffer[512];
	MSG		msg;
	int		iIndex;
	va_list	list;


	va_start(list,pString);
	vsprintf(Buffer,pString,list);

	if (ulCount1 == MAX_LOOP)
	{
		ulCount1 = 1;
		ulCount2++;
		SendMessage(hLogWindow,LB_RESETCONTENT,0,0);		
	}
	 
	iIndex = SendMessage(hLogWindow,LB_ADDSTRING,0,(LPARAM)Buffer);
	SendMessage(hLogWindow,LB_SETCARETINDEX,iIndex,(LPARAM)MAKELONG(FALSE,0));

	while (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	UpdateWindow(hLogWindow);
}


/******************************************************************************
  int ParseCmdLine(LPSTR lpCmdLine)

  Parse the command line for valid options
******************************************************************************/
int ParseCmdLine(LPSTR lpCmdLine)
{
	int     linenum = 0,				    // got line number yet? flag
			inf = 0,					    // got INF file yet? flag
			usrlog = 0,						// got a log file name yet? flag
			next;
	char	*pArg,
			szTmpBuf[LONGSTRING];


	for (pArg = lpCmdLine;*pArg;)
	{
		next = NextToken(szTmpBuf,pArg);
		
		pArg += next;

		// look for command line parameters
        if ( szTmpBuf[0] == '/' || szTmpBuf[0] == '-')
        {
	        // Look for other switches
            switch( toupper( szTmpBuf[1] ) )
            {
                case 'I':	// inf filename
					if (! inf)
					{
						strcpy(szInfName,szTmpBuf + 2);
						inf = 1;
					}
                    break;
                case 'L':	// log filename
					if (! usrlog)
					{
						strcpy(szLogName,szTmpBuf + 2);
						usrlog = 1;
						DisplayOutput("WARNING: logging not implemented!");
					}
                    break;
				default:
					DisplayOutput("%d is an invalid switch!",szTmpBuf[1]);
					break;
			}
		}
		else
		{
			// is a line number (in INF file)?
			if (!linenum)
			{
				if (atoi(szTmpBuf))
				{
					if (((nScriptLine = atoi(szTmpBuf)) > 500) || 
						(nScriptLine < 1))
					{
						DisplayOutput(
							"Line %d out of allowable range 1 through 500",
							nScriptLine);
					}
					else
						linenum = 1;
				}
				else
				{
					// assume script name if not a number and no script yet
					if (! inf)
					{
						strcpy(szInfName,szTmpBuf);
						inf = 1;
					}
				}
			}
		}
	}

	// auto-start with any valid command line param
	if (linenum || inf || usrlog)
		return 1;
	else
		return 0;
}


/******************************************************************************
  int PASCAL WinMain(HANDLE,HANDLE,LPSTR,short)

  The app itself.
******************************************************************************/
int APIENTRY WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{
	MSG		msg;						// message passing structure
	HWND	hWnd;						// Handle to main window
	HMENU	hMenuPopup;				    // add ports to PORT menu


	// allow multiple instances
/*	if (hPrevInstance)
       return FALSE;	*/

	// exit if registration and window creation fail
	if (! FirstInstance (hInstance))
       return FALSE;

	// Can't create window? Bail out
	if (! (hWnd = MakeWindow (hInstance)))
		return FALSE;

	// load the menu
	hMenu = LoadMenu(hThisInstance, MAKEINTRESOURCE(IDR_SCAN1));
	hMenuPopup = CreateMenu();
	SetMenu(hWnd, hMenu);
	ShowWindow(hWnd,nCmdShow);

	// save instance
	hThisInstance = hInstance;

	// look for any errors
	if (LastError(TRUE))
		DisplayOutput("Found an error during initialization");

	// display name of this app
	LoadString(hThisInstance,IDS_APPNAME,pszString,LONGSTRING);
    DisplayOutput(pszString);

	// enumerate available still image devices
	StiEnum();

	// parse the command line
	// if there are ANY valid command line options, start automated tests running
	if (nAuto = ParseCmdLine(lpCmdLine))
	{
		// start the timer to run tests automatically
		if (! SetTimer(hWnd,TIMER_INF,nTime,NULL))
			ErrorMsg((HWND) NULL,"Too many clocks or timers!","Scan2DIB",TRUE);
	}

	while (GetMessage(&msg,(HWND) NULL,0,0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return nError;	// return total errors
}


/******************************************************************************
  long FAR PASCAL WiskProc(HWND,UINT,WPARAM,LPARAM)

  The main exported procedure. 
******************************************************************************/
long FAR PASCAL WiskProc(HWND hWnd,UINT wMsgID,WPARAM wParam,LPARAM lParam)
{
	switch (wMsgID)
	{
		case WM_COMMAND:
			return CommandParse(hWnd,wMsgID,wParam,lParam);

		case WM_TIMER:
			return TimerParse(hWnd,wMsgID,wParam,lParam);

		case WM_SIZE:
			return SizeDiff(hWnd,wMsgID,wParam,lParam);

		case WM_HSCROLL:
			return HScroll(hWnd,wMsgID,wParam,lParam);

		case WM_VSCROLL:
			return VScroll(hWnd,wMsgID,wParam,lParam);

		case WM_CLOSE:
			EndTest(hWnd,0);
			return Destruction(hWnd,wMsgID,wParam,lParam);

		case WM_DESTROY:
			PostQuitMessage(0);
 			return 0L;

		case WM_CREATE:
			return Creation(hWnd,wMsgID,wParam,lParam);

		default:
			return DefWindowProc(hWnd,wMsgID,wParam,lParam);
	}
}


