/******************************************************************************

  Source File:  Sample.CPP

  This has the main routines for the Sample STI Property Sheet Extension DLL.

  Copyright (c) 1997 by Microsoft Corporation.  All Rights Reserved.

  Change History:

******************************************************************************/
#define STRICT

#include    <Windows.H>
#include    <sti.h>
#include    "Resource.H"

static  HINSTANCE   hiMe;

static BOOL CALLBACK MyDialog(HWND hwnd, UINT uMessage, WPARAM wp, LPARAM lp) {

    if  (uMessage != WM_INITDIALOG)
        return  FALSE;

    //  On WM_INITDIALOG, the LPARAM points at the PROPSHEETPAGE that created
    //  us.  We walk down to the lParam member to find the pointer to this
    //  STI device.

    PSTI_DEVICE_INFORMATION psdi = 
        (PSTI_DEVICE_INFORMATION) ((LPPROPSHEETPAGE) lp) -> lParam;

    SetWindowLong(hwnd, DWL_USER, (long) psdi);

    return  TRUE;
}

static PROPSHEETPAGE    psp = {sizeof psp, PSP_DEFAULT };

extern "C" 
BOOL WINAPI  DllEntryPoint(HINSTANCE hi, ULONG uReason, LPVOID lpv) {

    if  (uReason == DLL_PROCESS_ATTACH)
        hiMe = hi;

     return  TRUE;
}

typedef BOOL    (WINAPI *ADDER)(HPROPSHEETPAGE hpsp, LPARAM lp);

__declspec(dllexport) 
BOOL WINAPI    EnumStiPropPages(PSTI_DEVICE_INFORMATION psdi, ADDER adder, 
                                LPARAM lp) {

    psp.hInstance = hiMe;

    psp.pszTemplate = MAKEINTRESOURCE(SamplePage);
    psp.pfnDlgProc = &MyDialog;
    psp.lParam = (LPARAM) psdi;

    HPROPSHEETPAGE  hpsp = CreatePropertySheetPage(&psp);

    if  (!hpsp || !(*adder)(hpsp, lp)) {
        if  (hpsp)
            DestroyPropertySheetPage(hpsp);

        return  FALSE;  //  We failed to add anything...
    }

    return  TRUE;
}

