PRO WaveSurfAnim, kw, file
ON_ERROR, 2

; Get all the tag names passed
tags = ASKEYS(kw)

; Initialize strings to hold the positional parameter names and
; one string to hold all the kewword parameters.
key  = ''
posx = ''
posy = ''
posz = ''

gkey = ''
grid = 0
gridnx = 20
gridny = 20
gridnghbr = 0
sizflg = 0

; Parse each tag
FOR i=0,N_ELEMENTS(tags)-1 DO BEGIN
   CASE tags(i) OF

      'WaveSurfAnim' : BEGIN
                          siz = kw(tags(i))
                          xsize = siz(0)
                          ysize = siz(1)
                          OpenZBuff, [xsize, ysize]
                       END

      'Frames'   : BEGIN
                     frames = kw(tags(i))
                   END
                   
      'X'        : posx = ', kw("' + tags(i) + '")'
      
      'Y'        : posy = ', kw("' + tags(i) + '")'
      
      'Z'        : posz = ', kw("' + tags(i) + '")'
      
      'Z2'       : key = key + ', Shades=kw("' + tags(i) + '")'
      
      'Grid'     : grid = 1
      
      'Nx'   : BEGIN
                      gridnx = kw(tags(i))
                      sizflg = 1
                   END
      
      'Ny'   : BEGIN
                      gridny = kw(tags(i))
                      sizflg = 1
                   END
      
      'Nghbr': gkey = gkey + ', ' + tags(i) + '=kw("' + tags(i) + '")' 
                  
                 ; Else is a keyword param to be added:
      ELSE       : key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'                   
   ENDCASE
ENDFOR

; Grid data if required
IF grid THEN BEGIN
   status = EXECUTE("Z = FAST_GRID3( TRANSPOSE([[kw('X')], [kw('Y')], [kw('Z')]])"+ $
                    ", gridnx, gridny" + gkey+ ")")
   posparam = ''
ENDIF ELSE BEGIN
   Z = kw('Z')
   
   ; See if we need to CONGRID data
   IF sizflg THEN Z = CONGRID(Z, gridnx, gridny)

   posparam = posx + posy
ENDELSE


; Create animation sequence

mov = BYTARR(xsize*frames,ysize)

FOR i=0, frames-1 DO BEGIN
   ang = STRING((i * 360.0/frames)+5.0)
   print,'Frame ',i,ang
   status = EXECUTE('SHADE_SURF, Z, AZ=' + ang + posparam + key)
   img = tvrd(0,0,xsize,ysize)
   mov(i*xsize:i*xsize+xsize-1, *) = img
   ERASE
ENDFOR

; Save plot as gif file

; Get the current color palette (which we must switch
; to a device other than the Z buffer to do, because
; TVLCT returns an error with the Z buffer device).
set_plot,'PS'
TVLCT, r, g, b, /Get
set_plot,'Z'

IF !VERSION.RELEASE EQ '6.04' THEN BEGIN
   s=EXECUTE("mov = CREATE_IMAGE(mov, Colormap=TRANSPOSE([[r],[g],[b]]), Colormodel=1)")
   s=EXECUTE("status = WRITE_IMAGE(file, mov, file_type='GIF', /Compress, /Overwrite)")
ENDIF ELSE BEGIN
   s=EXECUTE("mov = IMAGE_CREATE(mov, Colormap=TRANSPOSE([[r],[g],[b]]), Colormodel=1)")
   s=EXECUTE("status = IMAGE_WRITE(file, mov, file_type='GIF', /Compress, /Overwrite)")
ENDELSE

; Update Log file
dt_to_str, today(), d, t, date=1, time=-1
desc = 'Surface Animation created '+d+' '+t
UpdateLog, desc, file, frames

END
