PRO WAVESURFACE, kw, file
ON_ERROR, 2

; Get all the tag names passed
tags = ASKEYS(kw)

; Initialize strings to hold the positional parameter names and
; one string to hold all the kewword parameters.
key  = ''
posx = ''
posy = ''
posz = ''

gkey = ''
grid = 0
gridnx = 20
gridny = 20
gridnghbr = 0
sizflg = 0

; Parse each tag
FOR i=0,N_ELEMENTS(tags)-1 DO BEGIN
   CASE tags(i) OF
   
      'WaveSurface' : BEGIN
                         OpenZBuff, kw(tags(i))
                         SET_PLOT, 'PS'
                         TEK_COLOR
                         SET_PLOT, 'Z'
                      END
                      
      'X'        : posx = ', kw("' + tags(i) + '")'
      
      'Y'        : posy = ', kw("' + tags(i) + '")'
      
      'Z'        : posz = ', kw("' + tags(i) + '")'
      
      'Grid'     : grid = 1
      
      'Nx'   : BEGIN
                      gridnx = kw(tags(i))
                      sizflg = 1
                   END
      
      'Ny'   : BEGIN
                      gridny = kw(tags(i))
                      sizflg = 1
                   END
      
      'Nghbr': gkey = gkey + ', ' + tags(i) + '=kw("' + tags(i) + '")' 
      
                 ; Else is a keyword param to be added:
      ELSE       : key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
   ENDCASE
ENDFOR

; Grid data if required
IF grid THEN BEGIN

   status = EXECUTE("Z = FAST_GRID3( TRANSPOSE([[kw('X')], [kw('Y')], [kw('Z')]])"+ $
                    ", gridnx, gridny" + gkey+ ")")

   ; Execute strings to create plot
   status = EXECUTE('SURFACE, Z' + key)

ENDIF ELSE BEGIN

   Z = kw('Z')
   ; See if we need to CONGRID data
   IF sizflg THEN Z = CONGRID(Z, gridnx, gridny)

   ; Execute strings to create plot
   status = EXECUTE('SURFACE, Z' + posx + posy + key)

ENDELSE

; Save plot as gif file
CloseZBuff, file

dt_to_str, today(), d, t, date=1, time=-1
desc = 'Surface created '+d+' '+t
UpdateLog, desc, file, 0

END
