PRO WAVEPIE, kw, file
ON_ERROR, 2

; Get all the tag names passed
tags = ASKEYS(kw)

; Initialize strings to hold the positional parameter names and
; one string to hold all the kewword parameters.
key  = ''
posx = ''
xcnt = ', 0.5'
ycnt = ', 0.5'
rad  = ', 0.3'
back = 0

; Parse each tag
FOR i=0,N_ELEMENTS(tags)-1 DO BEGIN
   CASE tags(i) OF
   
      'WavePie' : BEGIN
                      OpenZBuff, kw(tags(i))
                      SET_PLOT, 'PS'
                      TEK_COLOR
                      SET_PLOT, 'Z'
                   END
                                         
      'X'        : posx = ', kw("' + tags(i) + '")'
      
      'Xcentre'  : xcnt = ', kw("' + tags(i) + '")'
      
      'Ycentre'  : ycnt = ', kw("' + tags(i) + '")'
      
      'Radius'   : rad = ', kw("' + tags(i) + '")'
      
      'Background': back = kw(tags(i))
      
                 ; Else is a keyword param to be added:
      ELSE       : key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
   ENDCASE
ENDFOR

; Execute strings to create plot
!P.Color = 0
IF back NE 0 THEN ERASE, back
status = EXECUTE('PIE_CHART2' + posx + xcnt + ycnt + rad + key)

; Save plot as gif file
CloseZBuff, file

; Update Log file
dt_to_str, today(), d, t, date=1, time=-1
desc = 'Plot created '+d+' '+t
UpdateLog, desc, file, 0

END
