PRO WAVEHISTOGRAM, kw, file
ON_ERROR, 2

; Get all the tag names passed
tags = ASKEYS(kw)

; Initialize strings to hold the positional parameter names and
; one string to hold all the keyword parameters.
key  = ''
posz = ''
fill = 0

; Parse each tag
FOR i=0,N_ELEMENTS(tags)-1 DO BEGIN
   CASE tags(i) OF
   
      'WaveHistogram' : BEGIN
                           OpenZBuff, kw(tags(i))
                           SET_PLOT, 'PS'
                           TEK_COLOR
                           SET_PLOT, 'Z'
                        END
                   
      'Binsize'  : BEGIN
                     binsize = kw(tags(i))
                     key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
                   END      
      
      'Z'        : posz = 'kw("' + tags(i) + '")'
      
                 ; Else is a keyword param to be added:
      ELSE       : key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
   ENDCASE
ENDFOR

; Execute strings to calculate distribution
status = EXECUTE('datadist = HISTOGRAM(' + posz + ', Binsize=binsize)')

; Execute strings to create histogram
status = EXECUTE('PLOT_HISTOGRAM, datadist' + key)

; Save plot as gif file
CloseZBuff, file

; Update Log file
dt_to_str, today(), d, t, date=1, time=-1
desc = 'Plot created '+d+' '+t
UpdateLog, desc, file, 0

END
