PRO WAVECONTOUR, kw, file
ON_ERROR, 2

; Name of temp file used for filled contours
IF !Version.OS NE 'Windows' THEN $
   filepath = '/usr/tmp/cnt.tmp' $
ELSE $
   filepath = 'cnt.tmp'

; Get all the tag names passed
tags = ASKEYS(kw)

; Initialize strings to hold the positional parameter names and
; one string to hold all the kewword parameters.
key  = ''
posx = ''
posy = ''
posz = ''
fill = 0

gkey = ''
grid = 0
gridnx = 20
gridny = 20
gridnghbr = 0
sizflg = 0

; Parse each tag
FOR i=0,N_ELEMENTS(tags)-1 DO BEGIN
   CASE tags(i) OF
   
      'WaveContour' : BEGIN
                         OpenZBuff, kw(tags(i))
                         SET_PLOT, 'PS'
                         TEK_COLOR
                         SET_PLOT, 'Z'
                      END
                   
      'Filled'   : fill = 1
      
      'Color_Index': color_index = kw(tags(i))
      
      'XRange'   : BEGIN
                      xrange = kw(tags(i))
                      key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
                   END

      'YRange'   : BEGIN
                      yrange = kw(tags(i))
                      key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
                   END
                                         
      'X'        : posx = ', kw("' + tags(i) + '")'
      
      'Y'        : posy = ', kw("' + tags(i) + '")'

      'Z'        : posz = ', kw("' + tags(i) + '")'

      'Grid'     : grid = 1
      
      'Nx'   : BEGIN
                      gridnx = kw(tags(i))
                      sizflg = 1
                   END
      
      'Ny'   : BEGIN
                      gridny = kw(tags(i))
                      sizflg = 1
                   END
      
      'Nghbr': gkey = gkey + ', ' + tags(i) + '=kw("' + tags(i) + '")' 
            
                 ; Else is a keyword param to be added:
      ELSE       : key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
   ENDCASE
ENDFOR

; Grid data if required
IF grid THEN BEGIN
   status = EXECUTE("Z = FAST_GRID3( TRANSPOSE([[kw('X')], [kw('Y')], [kw('Z')]])"+ $
                    ", gridnx, gridny" + gkey+ ")")
   posparam = ''
ENDIF ELSE BEGIN
   Z = kw('Z')
   
   ; See if we need to CONGRID data
   IF sizflg THEN Z = CONGRID(Z, gridnx, gridny)

   posparam = posx + posy
ENDELSE

; Draw the contour plot
IF NOT fill THEN BEGIN ; Contour lines only

   ; Execute strings to create plot
   status = EXECUTE('CONTOUR, Z, /Follow' + posparam + key)

ENDIF ELSE BEGIN ; Filled contour plot

   ; Execute strings to create contour data
   status = EXECUTE('CONTOUR, Z, /Follow' + posparam + key + $
                    ', Path="'+filepath+'"')
                    
   ; Execute strings to create filled contour
   cmd = 'CONTOURFILL, /Delete, "' + filepath+'", Z' + posparam
   IF N_ELEMENTS(color_index) NE 0 THEN cmd = cmd + ', color_index=color_index'
   IF N_ELEMENTS(xrange) NE 0 THEN cmd = cmd + ', xrange=xrange'
   IF N_ELEMENTS(yrange) NE 0 THEN cmd = cmd + ', yrange=yrange'
   status = EXECUTE(cmd)

   ; Execute strings to overplot the contour 
   status = EXECUTE('CONTOUR, Z' + posparam + key + ', /Noerase')
                       
ENDELSE

; Save plot as gif file
CloseZBuff, file

; Update Log file
dt_to_str, today(), d, t, date=1, time=-1
desc = 'Plot created '+d+' '+t
UpdateLog, desc, file, 0

END
