PRO WAVEBAR3D, kw, file
ON_ERROR, 2

; Get all the tag names passed
tags = ASKEYS(kw)

; Initialize strings to hold the positional parameter names and
; one string to hold all the keyword parameters.
key  = ''
posz = ''

; Parse each tag
FOR i=0,N_ELEMENTS(tags)-1 DO BEGIN
   CASE tags(i) OF
   
      'WaveBar3D' : BEGIN
                       OpenZBuff, kw(tags(i))
                       SET_PLOT, 'PS'
                       TEK_COLOR
                       SET_PLOT, 'Z'
                    END
                   
      'Z'        : posz = 'kw("' + tags(i) + '")'

                 ; Else is a keyword param to be added:
      ELSE       : key = key + ', ' + tags(i) + '=kw("' + tags(i) + '")'
   ENDCASE
ENDFOR

; Execute strings to create chart
status = EXECUTE('BAR3D, ' + posz + key)

; Save plot as gif file
CloseZBuff, file

; Update Log file
dt_to_str, today(), d, t, date=1, time=-1
desc = 'Plot created '+d+' '+t
UpdateLog, desc, file, 0

END
