PRO ParseLines, file, indx, colr, line

OPENR, unit, file, /Get_Lun, /Delete
stat = FSTAT(unit)
nbuff = stat.size
maxbuff = nbuff-1
buff = BYTARR(nbuff, /Nozero)
READU, unit, buff
FREE_LUN, unit

buff(WHERE(buff EQ 10B)) = 32B ; Make linefeeds spaces

sep = WHERE(buff EQ 59B) ; Get indexes of ';' characters
nsep = N_ELEMENTS(sep)-1

; Variables to hold data
line = INTARR(100000,2)
indx = INTARR(5000)
colr = INTARR(5000)
newl = 0
col  = 0
curi = 0
lptr = 0

; Loop over each tag
FOR i=0,nsep-1 DO BEGIN
   begtag = sep(i)+1
   endtag = sep(i+1)-1
   IF endtag GT begtag THEN BEGIN ; tag is not empty
      tag = STRING(buff(begtag:endtag))
      tagname = STRMID(tag,0,2)
      CASE tagname OF ; only process tags we want
         'PU': BEGIN  ; Pen up
                  tag = STRMID(tag,2,STRLEN(tag)-1)
                  tag = STRSPLIT(tag,',')
                  curx = fix(tag(0))
                  cury = fix(tag(1))
                  newl = 1
               END
         'PD': BEGIN  ; Pen down
                  tag = STRMID(tag,2,STRLEN(tag)-1)
                  tag = STRSPLIT(tag,',')
                  IF newl THEN BEGIN ; Mark the beginning of a new line
                     newl = 0
                     indx(curi) = lptr
                     colr(curi) = col
                     curi = curi + 1
                     line(lptr,0) = curx
                     line(lptr,1) = cury
                     lptr = lptr + 1
                  ENDIF
                  FOR j=0,N_ELEMENTS(tag)-2,2 DO BEGIN ; for each x/y pair
                     curx = curx + FIX(tag(j))   ; X value
                     cury = cury + FIX(tag(j+1)) ; Y value
                     line(lptr,0) = curx
                     line(lptr,1) = cury
                     lptr = lptr + 1
                  ENDFOR
               END
         'SP': BEGIN  ; Change color
                  col = FIX(STRMID(tag,2,1))
               END
         ELSE:
      ENDCASE
   ENDIF
ENDFOR

indx(curi) = lptr
indx = indx(0:curi) 
colr = colr(0:curi) 
line = line(0:lptr-1,*) / 10000.0 ; normalize
END

; -------------------------------------------------------------------------
; This routine takes a color index(s) in the current PV-WAVE color palette
; and returns the rgb color for this index as a 3,n array.  Called with
; /init initializes the color palette it will use.
FUNCTION RGBColor, col, init=init
COMMON RGBColor_Common, rgb
IF KEYWORD_SET(init) THEN BEGIN
   TVLCT, r, g, b, /GET
   rgb = BYTARR(3, 256)
   FOR i=0,N_ELEMENTS(r)-1 DO BEGIN
      rgb(0,i) = r(i)
      rgb(1,i) = g(i)
      rgb(2,i) = b(i)
   ENDFOR
ENDIF
IF N_ELEMENTS(col) NE 0 THEN RETURN, rgb(*,col) ELSE RETURN, 1
END


; -------------------------------------------------------------------------
; This routine will scale the polyline axes data read from the HPGL
; file into either data or normalized coordinates and output
; the lines in VRML 
PRO scale_axes, indx, color, lines, x=xflag, y=yflag, z=zflag, $
                ax=ax, az=az, norm=norm
COMMON vrmlaxes_common, xr, yr, zr, t3d, tx, ty, tz, lun

;!P.T = t3d
;!P.T3D = 1
;!X = tx
;!Y = ty
;!Z = tz
col = RGBColor(color)

; Scale data for X axes 
IF KEYWORD_SET(xflag) THEN BEGIN
   IF KEYWORD_SET(norm) THEN BEGIN
      lines(*,0) = 1.25*(lines(*,0)-0.1)
      lines(*,1) = lines(*,1) - 0.1 
   ENDIF ELSE BEGIN
      lines(*,0) = (xr(1)-xr(0))*1.25*(lines(*,0)-0.1)+xr(0)
      lines(*,1) = lines(*,1) - 0.1 + yr(0)
      miny = lines(0,1)
      lines(*,1) = lines(*,1) * (yr(1)-yr(0)) 
      lines(*,1) = lines(*,1) + (miny - lines(0,1))
   ENDELSE
ENDIF

; Scale data for Y axes
IF KEYWORD_SET(yflag) THEN BEGIN
   IF KEYWORD_SET(norm) THEN BEGIN
      lines(*,0) = lines(*,0) - 0.1
      lines(*,1) = 1.25*(lines(*,1)-0.1)
   ENDIF ELSE BEGIN
      lines(*,0) = lines(*,0) - 0.1 + xr(0)
      minx = lines(0,0)
      lines(*,0) = lines(*,0) * (xr(1)-xr(0))
      lines(*,0) = lines(*,0) + (minx - lines(0,0))
      lines(*,1) = (yr(1)-yr(0))*1.25*(lines(*,1)-0.1)+yr(0)
   ENDELSE
ENDIF

; Scale data for Z axes
IF KEYWORD_SET(zflag) THEN BEGIN
   IF KEYWORD_SET(norm) THEN BEGIN
      lines(*,0) = lines(*,0) - 0.1
      lines(*,1) = 1.25*(lines(*,1)-0.1)
   ENDIF ELSE BEGIN
      lines(*,0) = lines(*,0) - 0.1 + xr(0)
      minx = lines(0,0)
      lines(*,0) = lines(*,0) * (xr(1)-xr(0))
      lines(*,0) = lines(*,0) + (minx - lines(0,0))
      lines(*,1) = (zr(1)-zr(0))*1.25*(lines(*,1)-0.1)+zr(0)
   ENDELSE
ENDIF

; Loop over each polyline and create 3D coords
FOR i=0,N_ELEMENTS(indx)-2 DO BEGIN
   IF KEYWORD_SET(zflag) THEN BEGIN
      x = lines(indx(i):indx(i+1)-1, 0)
      IF KEYWORD_SET(norm) THEN $
         y = REPLICATE(1.0, N_ELEMENTS(x)) $
      ELSE $
         y = REPLICATE(yr(1), N_ELEMENTS(x))
      z = lines(indx(i):indx(i+1)-1, 1)
   ENDIF ELSE BEGIN
      x = lines(indx(i):indx(i+1)-1, 0)
      y = lines(indx(i):indx(i+1)-1, 1)
      IF KEYWORD_SET(norm) THEN $
         z = REPLICATE(0.0, N_ELEMENTS(x)) $
      ELSE $
         z = REPLICATE(zr(0), N_ELEMENTS(x))
   ENDELSE

; Write to VRML
   VRML_LINE, lun, x, y, z, DiffuseColor=col
ENDFOR

!P.T3D = 0
END


; -------------------------------------------------------------------------
; Main Routine which works like SURFACE/SHADE_SURF but creates VRML file
PRO VRMLSurface, z, x, y, ax=ax, az=az, shades=shades, wireframe=wireframe, $
                 surface=surface, file=file, light=light, color=color, $
                 norm=norm, $
                 Charsize=Charsize, Font=Font, $
                 Title=Title, Subtitle=Subtitle, TickLen=Ticklen, $
                 Tickformat=Tickformat, $
                 XCharsize=XCharsize, XGridstyle=XGridstyle, XMinor=Xminor, $
                 XRange=XRange, XStyle=XStyle, XTickFormat=XTickFormat, $
                 XTicklen=XTicklen, XTickName=XTickName, XTicks=XTicks, $
                 XTitle=XTitle, $
                 YCharsize=YCharsize, YGridstyle=YGridstyle, YMinor=Yminor, $
                 YRange=YRange, YStyle=YStyle, YTickFormat=YTickFormat, $
                 YTicklen=YTicklen, YTickName=YTickName, YTicks=YTicks, $
                 YTitle=YTitle, $
                 ZCharsize=ZCharsize, ZGridstyle=ZGridstyle, ZMinor=Zminor, $
                 ZRange=ZRange, ZStyle=ZStyle, ZTickFormat=ZTickFormat, $
                 ZTicklen=ZTicklen, ZTickName=ZTickName, ZTicks=ZTicks, $
                 ZTitle=ZTitle
COMMON vrmlaxes_common, xr, yr, zr, t3d, tx, ty, tz, lun

; List of possible keywords for axes
kwds = ['Charsize','Font','TickLen','Tickformat', $
        'XCharsize','XGridstyle','XMinor','XRange','XStyle','XTickFormat',$
        'XTicklen','XTickName','XTicks','XTitle', $
        'YCharsize','YGridstyle','YMinor','YRange','YStyle','YTickFormat',$
        'YTicklen','YTickName','YTicks','YTitle', $
        'ZCharsize','ZGridstyle','ZMinor','ZRange','ZStyle','ZTickFormat',$
        'ZTicklen','ZTickName','ZTicks','ZTitle']

IF N_ELEMENTS(color) EQ 0 THEN color=!D.N_COLORS-1
IF N_ELEMENTS(shades) EQ 0 THEN shades=!D.N_COLORS/2
IF N_ELEMENTS(ax) EQ 0 THEN ax = 30
IF N_ELEMENTS(az) EQ 0 THEN az = 30
IF N_ELEMENTS(ticklen) EQ 0 THEN ticklen = -0.02  ; Make the ticks point out by default
IF NOT KEYWORD_SET(wireframe) THEN surface=1

status = RGBColor(/Init)

; Get the axes/surface data
orgdev = !D.Name
SET_PLOT, 'HP'
hpfact = 9.8425196

IF (strmatch(!Version.OS, "Windows")) THEN BEGIN
   hpglfile = 'temp.hp'
ENDIF ELSE IF (!Version.OS EQ 'axpvms' OR !Version.OS EQ 'vms') THEN BEGIN
   hpglfile = 'SYS$LOGIN:temp.hp'
ENDIF ELSE BEGIN
   hpglfile = '/usr/tmp/temp.hp'
ENDELSE

device,file=hpglfile, xoff=0,yoff=0,xsize=hpfact,ysize=hpfact,/inch

; Get the size of the Z variable and create x and y if not provided
s = size(z)
nx = s(1) 
ny = s(2)
IF N_ELEMENTS(x) EQ 0 THEN x = FINDGEN(nx) 
IF N_ELEMENTS(y) EQ 0 THEN y = FINDGEN(ny) 

; Call Surface to get axes ranges
cmd = 'SURFACE, /Save, /Nodata, z, x, y, Xstyle=5, Ystyle=5, Zstyle=5,'+ $
      'ax=ax, az=az'
FOR i=0,N_ELEMENTS(kwds)-1 DO BEGIN
   kw = 'IF N_ELEMENTS('+kwds(i)+') NE 0 THEN cmd = cmd + ",'+ $
        kwds(i)+'='+kwds(i)+'"'
   status = EXECUTE(kw)
ENDFOR
status = EXECUTE(cmd)
xr  = !X.CRANGE
yr  = !Y.CRANGE
zr  = !Z.CRANGE
;tx = !X
;ty = !Y
;tz = !Z
;t3d = !P.t
;!P.T3D = 0
;DEVICE, /CLOSE

; Normalize !P.T to 0-1 if /Norm
IF KEYWORD_SET(norm) THEN BEGIN
   SURFACE, z, ax=ax, az=az, /Nodata, $
            xrange=[0,1], yrange=[0,1], zrange=[0,1], $
            xstyle=5, ystyle=5, zstyle=5, /Save
;   t3d = !P.t
ENDIF

; Start the VRML file
VRML_OPEN, lun, /get, file

; Set the background for the VRML browser to grey
; (If it understands this command...)
PRINTF, lun, 'DEF BackgroundColor Info {'
PRINTF, lun, '   string "0.8 0.8 0.8"'
PRINTF, lun, '}'

VRML_WRITE_TRANSFORM, lun, !P.T

; Add a light
IF N_ELEMENTS(light) NE 3 THEN BEGIN
   IF KEYWORD_SET(norm) THEN BEGIN
      light = [-3.0, -3.0, 5.0]
      VRML_LIGHT, lun, light, Intensity=0.5
      light = [3.0, 3.0, 3.0]
      VRML_LIGHT, lun, light, Intensity=0.5
   ENDIF ELSE BEGIN
      light = [-3.0*MIN(x),-3.0*MIN(y),5.0*MAX(z)]
      VRML_LIGHT, lun, light, Intensity=0.5
      light = [3.0*MIN(x),3.0*MIN(y),3.0*MAX(z)]
      VRML_LIGHT, lun, light, Intensity=0.5
   ENDELSE
ENDIF ELSE BEGIN
   VRML_LIGHT, lun, light, Intensity=0.75
ENDELSE

!P.CHARSIZE=1.5

; X Axes
SET_PLOT, 'HP'
device,file=hpglfile, xoff=0,yoff=0,xsize=hpfact,ysize=hpfact,/inch
cmd = 'PLOT,[xr(0),xr(1)],[0,1],/nodata,ystyle=4,xstyle=9,xrange=xr,'+ $
      'position=[.1,.1,.9,.9]'
FOR i=0,N_ELEMENTS(kwds)-1 DO BEGIN
   kw = 'IF N_ELEMENTS('+kwds(i)+') NE 0 THEN cmd = cmd + ",'+ $
        kwds(i)+'='+kwds(i)+'"'
   status = EXECUTE(kw)
ENDFOR
status = EXECUTE(cmd)
EMPTY
DEVICE, /CLOSE
ParseLines,hpglfile,  indx, colr, lines
scale_axes, indx, color, lines, /X, ax=ax, az=az, norm=norm

; Y Axes
SET_PLOT, 'HP'
device,file=hpglfile, xoff=0,yoff=0,xsize=hpfact,ysize=hpfact,/inch
cmd = 'PLOT,[yr(0),yr(1)],[0,1],/nodata,xstyle=4,ystyle=9,yrange=yr,'+ $
      'position=[.1,.1,.9,.9]'
FOR i=0,N_ELEMENTS(kwds)-1 DO BEGIN
   kw = 'IF N_ELEMENTS('+kwds(i)+') NE 0 THEN cmd = cmd + ",'+ $
        kwds(i)+'='+kwds(i)+'"'
   status = EXECUTE(kw)
ENDFOR
status = EXECUTE(cmd)
EMPTY
DEVICE, /CLOSE
ParseLines,hpglfile,  indx, colr, lines
scale_axes, indx, color, lines, /Y, ax=ax, az=az, norm=norm

; Z Axes
SET_PLOT, 'HP'
device,file=hpglfile, xoff=0,yoff=0,xsize=hpfact,ysize=hpfact,/inch
cmd = 'PLOT,[zr(0),zr(1)],[0,1],/nodata,xstyle=4,ystyle=9,yrange=zr,'+ $
      'position=[.1,.1,.9,.9]'
FOR i=0,N_ELEMENTS(kwds)-1 DO BEGIN
   kw = 'IF N_ELEMENTS('+kwds(i)+') NE 0 THEN cmd = cmd + ",'+ $
        kwds(i)+'='+kwds(i)+'"'
   status = EXECUTE(kw)
ENDFOR
status = EXECUTE(cmd)
EMPTY
DEVICE, /CLOSE
ParseLines,hpglfile,  indx, colr, lines
scale_axes, indx, color, lines, /Z, ax=ax, az=az, norm=norm

; Reset device
SET_PLOT, orgdev

; Normalize data to 0-1 if /Norm
IF KEYWORD_SET(norm) THEN BEGIN
   x = (x - xr(0))/ (xr(1)-xr(0))
   y = (y - yr(0))/ (yr(1)-yr(0))
   z = (z - zr(0))/ (zr(1)-zr(0))
ENDIF

; Add wireframe
IF KEYWORD_SET(wireframe) THEN BEGIN
   FOR i=0,nx-1 DO $
      VRML_LINE, lun, REPLICATE(x(i),ny), y, REFORM(z(i,*)), $
                 DiffuseColor=RGBColor(color)
   FOR i=0,ny-1 DO $
      VRML_LINE, lun, x, REPLICATE(y(i),nx), REFORM(z(*,i)), $
                 DiffuseColor=RGBColor(color)
END 

; Add surface
IF KEYWORD_SET(surface) THEN BEGIN

   ; Create vertex and polynomial list
   Poly_Surf, z, vlist, plist, npoly

   ; Normalize to 0-1 if /Norm
   IF KEYWORD_SET(norm) THEN BEGIN
      vlist(0,*) = (vlist(0,*) - xr(0))/ (xr(1)-xr(0))
      vlist(1,*) = (vlist(1,*) - yr(0))/ (yr(1)-yr(0))
   ENDIF

   ; Set color keywords
   IF N_ELEMENTS(shades) EQ 1 THEN BEGIN
      amb = RGBColor(shades)
      vert = 0
   ENDIF ELSE BEGIN
      amb = RGBColor(shades)
      vert = 1
   ENDELSE

   ;Render it
   VRML_POLY, lun, vlist, plist, AmbientColor=amb, DiffuseColor=amb, $
              VertexColor=vert

ENDIF

IF KEYWORD_SET(title) THEN $
   IF KEYWORD_SET(norm) THEN $
      VRML_TEXT, title, 0.5, 1.0, 1.3 $
   ELSE $
      VRML_TEXT, title, (xr(1)-xr(0))/2+xr(0), yr(1), zr(1)*1.3

IF KEYWORD_SET(subtitle) THEN $
   IF KEYWORD_SET(norm) THEN $
      VRML_TEXT, subtitle, 0.5, 1.0, 1.1 $
   ELSE $
      VRML_TEXT, subtitle, (xr(1)-xr(0))/2+xr(0), yr(1), zr(1)*1.2
      
; Done
FREE_LUN, lun

END
