PRO VRML_TEXT, lun, text, $
                         Center=center, Rotation=rotation, $
                         Left=left, $
                         FontSize=fontsize, $
                         Serif=serif, Sans=sans, Typewriter=typewriter, $
                         Bold=bold, Italic=italic, $
                         Transform=Transform, $
                         Texture_Image=texture_image, $
                         AmbientColor=kamb, Diffusecolor = kdiff, $
                         EmissiveColor = color, Transparency = ktran, $
                         SpecularColor = kspec, shininess = ns

; text - A string or STRARR of text.
; FontSize - Point size of font.  Default 10
; /Serif, /Sans, /Typewriter - Specify the font family.  Default is Serif
; /Bold, /Italic - Font style modification.  Default is normal
; Rotation - A 3-element vector specifying the rotations about (x,y,z)
;          of the text.  Default orientation is with the text 
;          written with up as the +Y axis, and reading to +X.
; Center - 3-element (x,y,z) array with the center of the first line 
;          of the text.  Default is [0,0,0]
; /Left - If true, left justify the text at the center.  Default is to 
;          center-justify the text around center.
; Transform - A (4,4) matrix (as in !P.T) containing the transform to 
;          apply to the object.  Applied after Center and Rotation
; Texture_Image - A Texture image to apply to the object.
;          Four options:
;             (w,h) or (1,w,h) - Greyscale image
;             (2,w,h) - Greyscale in (0,*,*) plus transparency in (1,*,*)
;             (3,w,h) - True color image (red, green, blue)
;             (4,w,h) - True Color plus transparency in (3,*,*)
;          Image is wrapped copmpletely around object (CLAMPed)
;          Image values and Transparencies lie in range of 0...255
; AmbientColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; DiffuseColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; EmissiveColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; Transparency - Scalar transparency factor.  In range of 0...255
; SpecularColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; Shininess - Scalar shininess factor.  In range of 0...255
   
   ON_ERROR,2

   PRINTF, lun, 'Separator {'

   IF N_ELEMENTS(fontsize) EQ 0 THEN $
     fontsize = 10.

   PRINTF, lun, 'FontStyle { size ', fontsize(0)
   IF KEYWORD_SET(serif) THEN BEGIN
      PRINTF, lun, 'family SERIF'
   ENDIF ELSE IF KEYWORD_SET(sans) THEN BEGIN
      PRINTF, lun, 'family SANS'
   ENDIF ELSE IF KEYWORD_SET(typewriter) THEN BEGIN
      PRINTF, lun, 'family TYPEWRITER'
   ENDIF

   IF KEYWORD_SET(bold) THEN BEGIN
      PRINTF, lun, 'style BOLD'
   ENDIF ELSE IF KEYWORD_SET(italic) THEN BEGIN
      PRINTF, lun, 'style ITALIC'
   ENDIF

   PRINTF, lun, '}'   ; FontStyle

   IF N_ELEMENTS(transform) EQ 16 THEN $
     VRML_WRITE_Transform, lun, transform
               
   IF N_ELEMENTS(center) EQ 3 THEN $
     PRINTF, lun, 'Translation { translation ', center, ' }'

   IF N_ELEMENTS(rotation) EQ 3 THEN BEGIN
      PRINTF, lun, 'Rotation { rotation  1 0 0 ', rotation(0) *!Dtor, ' }'
      PRINTF, lun, 'Rotation { rotation  0 1 0 ', rotation(1) *!Dtor, ' }'
      PRINTF, lun, 'Rotation { rotation  0 0 1 ', rotation(2) *!Dtor, ' }'
   ENDIF

   VRML_WRITE_Texture, lun, texture_image

   VRML_WRITE_Material, lun, $
                   AmbientColor=kamb, Diffusecolor = kdiff, $
                   EmissiveColor = color, Transparency = ktran, $
                   SpecularColor = kspec, shininess = ns

   IF N_ELEMENTS(radius) EQ 0 THEN radius=1.0
   IF N_ELEMENTS(height) EQ 0 THEN height=2.0

   str = text
   FOR i=0L, N_ELEMENTS(str)-1 DO $
     str(i) = STRSUBST(str(i), '"', '\\"', /Global)

   PRINTF, lun, 'AsciiText { string ['

   PRINTF, lun, str, Format='(1H",A,1H",:,",")'

   PRINTF, lun, ']'

   IF NOT KEYWORD_SET(left) THEN $
      PRINTF, lun, 'justification CENTER'

   PRINTF, lun, '}'


   PRINTF, lun, '}' ; Separator - end of Object

END
