PRO VRML_SPOTLIGHT, lun, position, $
               Direction=direction, Angle=angle, Rate=rate, $
               Color=color, Intensity=intens

; position - Position of the point light
; Color - 3-element array of RGB light color in range 0...255
;         Defaults to white
; Intensity - Light intensity in range 0...1 Default 1
; Direction - A 3-element vector specifying the orientation of 
;          the light cone.   Default orientation is with the light 
;          pointed along the -Y axis (pointed down, [0,0,-1]).
; Angle - The light cone angle in degrees - default is 45.
; Rate - The drop off rate for the light intensity.

   ON_ERROR,2

   IF N_ELEMENTS(position) NE 3 THEN MESSAGE, 'Bad position'

   PRINTF, lun, 'SpotLight { location ', position

   IF N_ELEMENTS(color) EQ 3 THEN $
     PRINTF, lun, 'color ', color/255.

   IF N_ELEMENTS(intens) NE 0 THEN $
     PRINTF, lun, 'intensity ', intens(0)

   IF N_ELEMENTS(direction) EQ 3 THEN $
     PRINTF, lun, 'direction ', direction

   IF N_ELEMENTS(angle) NE 0 THEN $
     PRINTF, lun, 'cutOffAngle ', angle(0) *!Dtor

   IF N_ELEMENTS(rate) NE 0 THEN $
     PRINTF, lun, 'dropOffRate ', rate

   PRINTF, lun, '}'

END
